# -*- coding: utf-8 -*-
__license__   = 'GPL v3'
__copyright__ = '2015,2016,2017,2018,2019,2020,2021,2022,2023  DaltonST'
__my_version__ = "1.0.96"   # Qt.core

from qt.core import (Qt, QApplication, QButtonGroup, QCheckBox, QComboBox, QCompleter,
                                QDate, QDateEdit, QDialog, QDialogButtonBox, QDoubleSpinBox, QFileDialog, QFont, QFrame,
                                QGridLayout, QGroupBox, QHBoxLayout, QIcon, QLabel, QLineEdit, QMargins, QObject, QPushButton,
                                QRadioButton, QScrollArea, QSize, QSizePolicy, QSpacerItem, QSpinBox, QTabWidget, QTextEdit, QTextOption,
                                QVBoxLayout, QWidget)
import os,sys,apsw
import ast
import copy
import datetime
from datetime import datetime
from functools import partial
import re

from calibre import isbytestring
from calibre.constants import filesystem_encoding, DEBUG
from calibre.ebooks.metadata.meta import set_metadata
from calibre.ebooks.metadata.book.base import Metadata
from calibre.gui2 import FileDialog  #__init__
from calibre.gui2 import error_dialog, info_dialog

from polyglot.builtins import as_unicode, iteritems, map, range, unicode_type

COMPARE_AS_IS = "Compare: 'as-is'"
COMPARE_UPPER_CASE = "Compare: Upper Case"
COMPARE_NO_SPACES_NO_PUNCTUATION = "Compare: No Spaces; No Punctuation"
COMPARE_UPPER_CASE_NO_SPACES_NO_PUNCTUATION = "Compare: Upper Case; No Spaces; No Punctuation"
COMPARE_DECOMPOSED_NORMALIZED_ALPHABET = as_unicode('Compare as: Decomposed & Normalized Alphabet')

FUZZYWUZZY_NONE = "Fuzzy Equality: None"
FUZZYWUZZY_TOKEN_SORT_RATIO = "Fuzzy Equality: Token Sort Ratio"
FUZZYWUZZY_TOKEN_SET_RATIO = "Fuzzy Equality: Token Set Ratio"
FUZZYWUZZY_SIMPLE_RATIO_UPPER_CASE_NO_PUNCTUATION = "Fuzzy Equality: Simple Ratio, No Punctuation, Upper Case"
FUZZYWUZZY_SIMPLE_RATIO_DECOMPOSED_NORMALIZED_ALPHABET = "Fuzzy Equality: Simple Ratio, Decomposed & Normalized Alphabet"
FUZZY_DOUBLEMETAPHONE_SIMPLE = "Fuzzy Equality: DoubleMetaphone Sounds-Like"

COMPLETER_MAX_VISIBLE_ITEMS = 20

MAX_AUTO_INDEX_SELECTED_BOOKS = 4

WORD_QUERIES_INDEXING_GROUPBOX_TITLE = 'Word-in-Book Index:  Indexing                                     [Index Row Count: '

SEARCHTAB = 'SearchTab'
REGEXTAB = 'RegexTab'
FINALFILTERTAB = 'FinalFilterTab'
SPECIALQUERIESTAB = 'SpecialQueriesTab'
SIMILARITYTAB = 'SimilarityTab'
RAWSQLTAB = 'RawSQLTab'
VIRTUALCOLUMNTXTTAB = 'VirtualColumnTXTTab'
WORDBOOKINDEXQUERYTAB = 'WordBookIndexQueryTab'
RESULTSTAB = 'ResultsTab'

INTRA_BOOK_SEARCH_TYPE = 'INTRA_BOOK_SEARCH'
INTER_BOOK_SEARCH_TYPE = 'INTER_BOOK_SEARCH'
REGULAR_EXPRESSIONS_TYPE = 'REGULAR_EXPRESSIONS'
FINAL_FILTERS_TYPE = 'FINAL_FILTERS'
SPECIAL_QUERIES_TYPE = 'SPECIAL_QUERIES'
SIMILARITY_QUERIES_TYPE = 'SIMILARITY_QUERIES'
SQL_QUERIES_TYPE = 'SQL_QUERIES'
TXT_QUERIES_TYPE = 'TXT_QUERIES'
WORD_QUERIES_TYPE = 'WORD_QUERIES'
POST_SEARCH_TYPE = 'POST_SEARCH'

standard_fields_list = []
interbook_search_standard_fields_list = []
param_dict = {}
#--------------------------------------------------------------------------------------------------
class MCSDialog(QDialog):
    # a.k.a. "Multi-Column Search", with 9 child QWidget Tabs, all sharing a single instance of "prefs" with ui.py's class ActionMultiColumnSearch(InterfaceAction)
    prefs = None
    #-----------------------------------------------------------------------------------------------
    def __init__(self,gui,icon,font,guidb,mcsprefs,search_request_control,swap_criteria_refresh,current_library_path,
                        custom_column_label_dict,custom_column_datatype_dict,custom_column_normalized_dict,special_query_control,
                        raw_sql_query_control,search_virtual_column_format_txt_control,search_word_in_book_query_control,search_similarity_control,
                        mcs_build_index_job_control,mcs_trim_index_job_control,
                        load_criteria_settings_generic, create_criteria_parm_list_generic,save_settings_parm_history_to_prefs_generic,
                        unpack_selected_parm_generic,manage_saved_criteria):
        QDialog.__init__(self, gui, Qt.WindowSystemMenuHint|Qt.WindowMinimizeButtonHint )
        from calibre_plugins.multi_column_search.mcs_search_dialog import MCSSearchTab
        from calibre_plugins.multi_column_search.mcs_search_dialog import MCSRegexTab
        from calibre_plugins.multi_column_search.mcs_search_dialog import MCSFinalFilterTab
        from calibre_plugins.multi_column_search.mcs_search_dialog import MCSSpecialQueriesTab
        from calibre_plugins.multi_column_search.mcs_search_dialog import MCSSimilarityTab
        from calibre_plugins.multi_column_search.mcs_search_dialog import MCSRawSQLTab
        from calibre_plugins.multi_column_search.mcs_search_dialog import MCSVirtualColumnTXTTab
        from calibre_plugins.multi_column_search.mcs_search_dialog import MCSWordBookIndexQueryTab
        from calibre_plugins.multi_column_search.mcs_search_dialog import MCSResultsTab

        #-----------------------------------------------------
        self.gui = gui
        self.guidb = guidb
        self.icon = icon
        self.font = font
        #-----------------------------------------------------
        global prefs
        prefs = mcsprefs
        #~ Important: the ui.py prefs are the real "master" instantiated prefs, so the mcsdialog prefs must always explicitly use and return the ui.py prefs passed originally to mcsdialog...
        #-----------------------------------------------------
        self.current_library_path = as_unicode(current_library_path)
        self.custom_column_datatype_dict = custom_column_datatype_dict
        self.custom_column_label_dict = custom_column_label_dict
        self.custom_column_normalized_dict = custom_column_normalized_dict
        self.mcs_build_index_job_control = mcs_build_index_job_control
        self.mcs_trim_index_job_control = mcs_trim_index_job_control
        self.new_search_path = current_library_path
        self.raw_sql_query_control = raw_sql_query_control
        self.search_path = current_library_path
        self.search_request_control = search_request_control
        self.search_similarity_control = search_similarity_control
        self.search_virtual_column_format_txt_control = search_virtual_column_format_txt_control
        self.search_word_in_book_query_control = search_word_in_book_query_control
        self.special_query_control = special_query_control
        self.swap_criteria_refresh = swap_criteria_refresh
        #-----------------------------------------------------
        self.load_criteria_settings_generic = load_criteria_settings_generic
        self.create_criteria_parm_list_generic = create_criteria_parm_list_generic
        self.save_settings_parm_history_to_prefs_generic = save_settings_parm_history_to_prefs_generic
        self.unpack_selected_parm_generic = unpack_selected_parm_generic
        self.manage_saved_criteria = manage_saved_criteria
        #-----------------------------------------------------
        #-----------------------------------------------------
        #-----------------------------------------------------
        # Tab #0: MCSSearchTab
        #-----------------------------------------------------
        self.MCSSearchTab = MCSSearchTab(self.gui,icon,self.guidb,prefs,search_request_control,swap_criteria_refresh,current_library_path,
                                                                    self.load_criteria_settings_generic,self.create_criteria_parm_list_generic,
                                                                    self.save_settings_parm_history_to_prefs_generic, self.unpack_selected_parm_generic)
        self.validate = self.MCSSearchTab.validate
        self.build_dict = self.MCSSearchTab.build_dict
        self.validate_param_dict = self.MCSSearchTab.validate_param_dict
        self.radio18 = self.MCSSearchTab.radio18
        self.radio28 = self.MCSSearchTab.radio28
        #-----------------------------------------------------
        #-----------------------------------------------------
        #-----------------------------------------------------
        # Tab #1: MCSRegexTab
        #-----------------------------------------------------
        self.MCSRegexTab  = MCSRegexTab(self.gui,icon,prefs,self.load_criteria_settings_generic,self.create_criteria_parm_list_generic,self.save_settings_parm_history_to_prefs_generic,
                                                                    self.unpack_selected_parm_generic)
        self.value_0 = self.MCSRegexTab.value_0
        self.value_1 = self.MCSRegexTab.value_1
        self.value_2 = self.MCSRegexTab.value_2
        self.value_3 = self.MCSRegexTab.value_3
        self.value_4 = self.MCSRegexTab.value_4
        self.value_5 = self.MCSRegexTab.value_5
        self.value_6 = self.MCSRegexTab.value_6
        self.value_7 = self.MCSRegexTab.value_7
        self.value_8 = self.MCSRegexTab.value_8
        self.value_9 = self.MCSRegexTab.value_9
        self.ignore_case_checkbox1 = self.MCSRegexTab.ignore_case_checkbox1
        self.ignore_case_checkbox2 = self.MCSRegexTab.ignore_case_checkbox2
        self.determine_selected_regex = self.MCSRegexTab.determine_selected_regex
        self.save_regex_values = self.MCSRegexTab.save_regex_values
        self.load_saved_regex_values = self.MCSRegexTab.load_saved_regex_values

        self.MCSSearchTab.determine_selected_regex = self.MCSRegexTab.determine_selected_regex  #special handling required due to timing of sequential initializations of Tabs...

        #-----------------------------------------------------
        #-----------------------------------------------------
        #-----------------------------------------------------
        # Tab #2: MCSFinalFilterTab
        #-----------------------------------------------------
        self.MCSFinalFilterTab = MCSFinalFilterTab(self.gui,icon,self.guidb,prefs,current_library_path,
                                                                             self.custom_column_label_dict,self.custom_column_datatype_dict,self.custom_column_normalized_dict,
                                                                             self.load_criteria_settings_generic,self.create_criteria_parm_list_generic,self.save_settings_parm_history_to_prefs_generic,
                                                                            self.unpack_selected_parm_generic)
        #-----------------------------------------------------
        #-----------------------------------------------------
        #-----------------------------------------------------
        # Tab #3: MCSSpecialQueriesTab
        #-----------------------------------------------------
        self.MCSSpecialQueriesTab = MCSSpecialQueriesTab(self.gui,icon,self.guidb,prefs,current_library_path,self.special_query_control,
                                                                                            self.custom_column_label_dict,self.custom_column_datatype_dict,self.custom_column_normalized_dict,
                                                                                            self.load_criteria_settings_generic,self.create_criteria_parm_list_generic,self.save_settings_parm_history_to_prefs_generic,
                                                                                            self.unpack_selected_parm_generic)
        #-----------------------------------------------------
        #-----------------------------------------------------
        #-----------------------------------------------------
        # Tab #4: MCSSimilarityTab
        #-----------------------------------------------------
        self.MCSSimilarityTab = MCSSimilarityTab(self.gui,icon,self.guidb,prefs,self.search_similarity_control,
                                                                            self.load_criteria_settings_generic,self.create_criteria_parm_list_generic,self.save_settings_parm_history_to_prefs_generic,
                                                                            self.unpack_selected_parm_generic)
        #-----------------------------------------------------
        #-----------------------------------------------------
        #-----------------------------------------------------
        # Tab #5: MCSRawSQLTab
        #-----------------------------------------------------
        self.MCSRawSQLTab = MCSRawSQLTab(self.gui,icon,self.guidb,prefs,current_library_path,self.raw_sql_query_control,
                                                                        self.custom_column_label_dict,self.custom_column_datatype_dict,self.custom_column_normalized_dict,
                                                                        self.load_criteria_settings_generic,self.create_criteria_parm_list_generic,self.save_settings_parm_history_to_prefs_generic,
                                                                        self.unpack_selected_parm_generic)
        #-----------------------------------------------------
        #-----------------------------------------------------
        #-----------------------------------------------------
        # Tab #6: MCSVirtualColumnTXTTab
        #-----------------------------------------------------
        self.MCSVirtualColumnTXTTab = MCSVirtualColumnTXTTab(self.gui,icon,self.guidb,prefs,self.search_virtual_column_format_txt_control,
                                                                                                        self.load_criteria_settings_generic,self.create_criteria_parm_list_generic,
                                                                                                        self.save_settings_parm_history_to_prefs_generic,self.unpack_selected_parm_generic)


        #-----------------------------------------------------
        #-----------------------------------------------------
        #-----------------------------------------------------
        # Tab #7: MCSWordBookIndexQueryTab
        #-----------------------------------------------------
        self.MCSWordBookIndexQueryTab = MCSWordBookIndexQueryTab(self.gui,icon,self.guidb,prefs,self.search_word_in_book_query_control,
                                                                                                                    self.mcs_build_index_job_control,self.mcs_trim_index_job_control,self.custom_column_label_dict,
                                                                                                                    self.load_criteria_settings_generic,self.create_criteria_parm_list_generic,
                                                                                                                    self.save_settings_parm_history_to_prefs_generic,self.unpack_selected_parm_generic)
        #-----------------------------------------------------
        #-----------------------------------------------------
        #-----------------------------------------------------
        # Tab #8: MCSResultsTab
        #-----------------------------------------------------
        self.MCSResultsTab = MCSResultsTab(self.gui,icon,self.guidb,prefs,current_library_path,
                                                                    self.load_criteria_settings_generic,self.create_criteria_parm_list_generic,self.save_settings_parm_history_to_prefs_generic,
                                                                    self.unpack_selected_parm_generic)
        #-----------------------------------------------------
        #-----------------------------------------------------
        #-----------------------------------------------------
        font = self.font
        font.setBold(False)
        font.setPointSize(8)
        #-----------------------------------------------------
        self.setWindowTitle('Multi-Column Search')
        self.setWindowIcon(icon)
        #-----------------------------------------------------
        self.layout_frame = QVBoxLayout()
        self.setLayout(self.layout_frame)
        #-----------------------------------------------------
        self.MCStabWidget = QTabWidget()

        self.MCStabWidget.addTab(self.MCSSearchTab,"Intra/Inter Book Queries")
        self.MCStabWidget.addTab(self.MCSRegexTab,"Regular Expressions")
        self.MCStabWidget.addTab(self.MCSFinalFilterTab,"Final Filters")
        self.MCStabWidget.addTab(self.MCSSpecialQueriesTab,"Special Queries")
        self.MCStabWidget.addTab(self.MCSSimilarityTab,"Similarity Queries")
        self.MCStabWidget.addTab(self.MCSRawSQLTab,"SQL Queries")
        self.MCStabWidget.addTab(self.MCSVirtualColumnTXTTab,"TXT Queries")
        self.MCStabWidget.addTab(self.MCSWordBookIndexQueryTab,"Word Queries")
        self.MCStabWidget.addTab(self.MCSResultsTab,"Post-Search Actions")

        self.layout_frame.addWidget(self.MCStabWidget)

        #-----------------------------------------------------
        #-----------------------------------------------------
        self.MCStabWidget.currentChanged.connect(self.event_tab_index_changed)
        #-----------------------------------------------------
        #-----------------------------------------------------
        #-----------------------------------------------------
        self.bottom_buttonbox = QDialogButtonBox()
        self.bottom_buttonbox.setCenterButtons(True)
        self.layout_frame.addWidget(self.bottom_buttonbox)
        #-----------------------------------------------------
        self.push_button_execute_selected = QPushButton(" ", self)
        self.push_button_execute_selected.setText("Execute Search [Selected Books]")
        self.push_button_execute_selected.setToolTip("<p style='white-space:wrap'> Execute a search for only the Selected Books.<br><br> Warning: disallowed if the 'Inter-Book Search' checkbox is checked.")
        self.push_button_execute_selected.clicked.connect(self.execute_mcs_selected)
        self.push_button_execute_selected.setFont(font)
        self.bottom_buttonbox.addButton(self.push_button_execute_selected,QDialogButtonBox.AcceptRole)
        #-----------------------------------------------------
        self.push_button_execute_all = QPushButton(" ", self)
        self.push_button_execute_all.setText("   Execute Search [All Books]   ")
        self.push_button_execute_all.clicked.connect(self.execute_mcs_all)
        self.push_button_execute_all.setFont(font)
        self.bottom_buttonbox.addButton(self.push_button_execute_all,QDialogButtonBox.AcceptRole)
        #-----------------------------------------------------
        self.push_button_execute_another_library = QPushButton(" ", self)
        self.push_button_execute_another_library.setText("Execute Search [Another Library: All Books]")
        self.push_button_execute_another_library.setToolTip("<p style='white-space:wrap'>Execute a search for All Books in Another Library, not the Current Library.<br><br>Warning: disallowed if the 'Inter-Book Search' checkbox is checked.")
        self.push_button_execute_another_library.clicked.connect(self.search_another_library)
        self.push_button_execute_another_library.setFont(font)
        self.bottom_buttonbox.addButton(self.push_button_execute_another_library,QDialogButtonBox.AcceptRole)
        #-----------------------------------------------------
        self.bottom_exit_buttonbox = QDialogButtonBox()
        self.bottom_exit_buttonbox.setCenterButtons(True)
        self.layout_frame.addWidget(self.bottom_exit_buttonbox)
        #-----------------------------------------------------
        self.push_button_manage_saved_criteria = QPushButton("Manage Saved Criteria")
        self.push_button_manage_saved_criteria.setToolTip("<p style='white-space:wrap'>Rename or Delete saved (named) sets of criteria for each Tab.")
        self.push_button_manage_saved_criteria.clicked.connect(self.manage_saved_criteria)
        self.push_button_manage_saved_criteria.setMinimumWidth(150)
        self.bottom_exit_buttonbox.addButton(self.push_button_manage_saved_criteria,QDialogButtonBox.AcceptRole)
        #-----------------------------------------------------
        self.push_button_cancel = QPushButton("Exit")
        self.push_button_cancel.clicked.connect(self.reject)
        self.push_button_cancel.setDefault(True)
        self.push_button_cancel.setMinimumWidth(150)
        self.bottom_exit_buttonbox.addButton(self.push_button_cancel,QDialogButtonBox.RejectRole)
        #-----------------------------------------------------
        if 'LAST_TAB_USED' in prefs:
            n = int(prefs['LAST_TAB_USED'])
            if n == 8:  # never start with the Results Tab
                n = 0
            self.MCStabWidget.setCurrentIndex(n)
    #-----------------------------------------------------------------------------------------------
    #-----------------------------------------------------------------------------------------------
    # EVENTS
    #-----------------------------------------------------------------------------------------------
    #-----------------------------------------------------------------------------------------------
    def event_tab_index_changed(self,event):

        n = self.MCStabWidget.currentIndex()

        #--------------------------
        if n == 0:     # Search Tab
        #--------------------------
            self.push_button_execute_selected.show()
            self.push_button_execute_all.show()
            self.push_button_execute_another_library.show()
            self.repaint()
        #--------------------------
        elif n == 1:  # Regex Tab
        #--------------------------
            self.push_button_execute_selected.hide()
            self.push_button_execute_all.hide()
            self.push_button_execute_another_library.hide()
            self.repaint()
        #--------------------------
        elif n == 2:  # Final Filters Tab
        #--------------------------
            self.push_button_execute_selected.hide()
            self.push_button_execute_all.hide()
            self.push_button_execute_another_library.hide()
            self.repaint()
        #--------------------------
        elif n == 3:  # Special Queries Tab
        #--------------------------
            self.push_button_execute_selected.hide()
            self.push_button_execute_all.hide()
            self.push_button_execute_another_library.hide()
            self.repaint()
        #--------------------------
        elif n == 4:  # Similarity Queries Tab
        #--------------------------
            self.push_button_execute_selected.hide()
            self.push_button_execute_all.hide()
            self.push_button_execute_another_library.hide()
            self.repaint()
        #--------------------------
        elif n == 5:  # Raw SQL Tab
        #--------------------------
            self.push_button_execute_selected.hide()
            self.push_button_execute_all.hide()
            self.push_button_execute_another_library.hide()
            self.repaint()
        #--------------------------
        elif n == 6:  # TXT Queries Tab
        #--------------------------
            self.push_button_execute_selected.hide()
            self.push_button_execute_all.hide()
            self.push_button_execute_another_library.hide()
            self.repaint()
        #--------------------------
        elif n == 7:  # Word-in-Book Queries Tab
        #--------------------------
            self.push_button_execute_selected.hide()
            self.push_button_execute_all.hide()
            self.push_button_execute_another_library.hide()
            self.repaint()
        #--------------------------
        elif n == 8:  # Post-Search Results Action Tab
        #--------------------------
            self.push_button_execute_selected.hide()
            self.push_button_execute_all.hide()
            self.push_button_execute_another_library.hide()
            self.repaint()

        global prefs
        prefs['LAST_TAB_USED'] = as_unicode(n)
    #-----------------------------------------------------------------------------------------------
    #-----------------------------------------------------------------------------------------------
    # OTHER
    #-----------------------------------------------------------------------------------------------
    #-----------------------------------------------------------------------------------------------
    def add_selected_regex_to_param_dict(self):

        global param_dict

        if self.radio18.isChecked():
            param_dict['OPERATOR1'] = 'regex'
            regex,n = self.determine_selected_regex(1)
            param_dict['REGEX1'] = regex
            param_dict['REGEX1#'] = n
            if self.ignore_case_checkbox1.isChecked():
                param_dict['IGNORECASE1'] = "1"
            else:
                param_dict['IGNORECASE1'] = "0"

        if self.radio28.isChecked():
            param_dict['OPERATOR2'] = 'regex'
            regex,n = self.determine_selected_regex(2)
            param_dict['REGEX2'] = regex
            param_dict['REGEX2#'] = n
            if self.ignore_case_checkbox2.isChecked():
                param_dict['IGNORECASE2'] = "1"
            else:
                param_dict['IGNORECASE2'] = "0"
    #-----------------------------------------------------------------------------------------------
    def execute_mcs_selected(self):
        global param_dict
        self.build_dict()
        if param_dict['INTER_BOOK_SEARCH'] == "True":
            error_dialog(self.gui, _('MCS'),_(("Inter-Book Searches are always for <b>'All'</b> Books, never <b>'Selected'</b> Books.<br><br>\
                                                                Execution Canceled. ")), show=True)
            return
        if param_dict['CROSS_LIBRARY_DUPLICATES_SEARCH'] == "True":
            error_dialog(self.gui, _('MCS'),_(("Cross-Library Duplicates Searches are never for 'Selected Books'.  Use 'Another Library [All Books]' instead.\
                                                                Execution Canceled. ")), show=True)
            return
        path = as_unicode(self.current_library_path)
        sel_type = "selected"
        self.execute_mcs(sel_type,path)
    #-----------------------------------------------------------------------------------------------
    def execute_mcs_all(self):
        if param_dict['CROSS_LIBRARY_DUPLICATES_SEARCH'] == "True":
            error_dialog(self.gui, _('MCS'),_(("Cross-Library Duplicates Searches are never for 'All Books'.  Use 'Another Library [All Books]' instead.\
                                                                Execution Canceled. ")), show=True)
            return
        path = as_unicode(self.current_library_path)
        sel_type = "all"
        self.execute_mcs(sel_type,path)
    #-----------------------------------------------------------------------------------------------
    def execute_mcs(self,sel_type,search_path):
        global param_dict
        global prefs

        self.build_dict()

        if param_dict['OPERATOR1'] != "=":
            if param_dict['FUZZYWUZZY1'] != as_unicode(FUZZYWUZZY_NONE):
                error_dialog(self.gui, _('MCS'),_(("'Fuzzy Search Functions' are valid only for an Operator of '='. <br><br>\
                                                                    Execution Canceled. ")), show=True)
                return
        if param_dict['OPERATOR2'] != "=":
            if param_dict['FUZZYWUZZY2'] != as_unicode(FUZZYWUZZY_NONE):
                error_dialog(self.gui, _('MCS'),_(("'Fuzzy Search Functions' are valid only for an Operator of '='. <br><br>\
                                                                    Execution Canceled. ")), show=True)
                return

        if  prefs['FINAL_FILTERS_LAST_SAVED'] != prefs['FINAL_FILTERS_LAST_VALIDATED']:
            error_dialog(self.gui, _('MCS'),_(("Final Filters have not been Validated since they were last Saved.<br><br>\
                                                                Execution Canceled. ")), show=True)
            return

        if prefs['FINAL_FILTERS_PASSED_VALIDATION'] != "True" and prefs['USE_FINAL_FILTERS'] == "True":
            error_dialog(self.gui, _('MCS'),_(("Final Filters failed Validation.  They cannot be used until they pass.<br><br>\
                                                                Execution Canceled. ")), show=True)
            return

        self.add_selected_regex_to_param_dict()
        force_repaint,force_abort = self.validate_param_dict()
        self.search_request_control(self.guidb,param_dict,sel_type,force_repaint,force_abort,self.current_library_path,search_path)
    #-----------------------------------------------------------------------------------------------
    def search_another_library(self):
        global param_dict

        self.build_dict()

        if param_dict['INTER_BOOK_SEARCH'] == "True":
            error_dialog(self.gui, _('MCS'),_(("Inter-Book Searches of  <b>'Another'  Library</b> are Prohibited.<br><br>\
                                                                Execution Canceled. ")), show=True)
            return
        if (param_dict['TRANSFORM_FUNCTION1'] != as_unicode(COMPARE_AS_IS)) or (param_dict['TRANSFORM_FUNCTION2'] != as_unicode(COMPARE_AS_IS)):
            error_dialog(self.gui, _('MCS'),_(("Cross-Library Searches <b>do not</b> use 'Compare-As' Transform Functions.<br><br>\
                                                                Execution Canceled. ")), show=True)
            return

        param_dict['ALL_AUTHORS_BOOKS'] = "False"
        param_dict['USE_FINAL_FILTERS'] = "False"

        name = "choose_search_library"
        title = "Choose Library to Search"
        all_files=True
        select_only_single_file=True
        filters=[]
        window = None   # parent = None
        mode = QFileDialog.ExistingFile if select_only_single_file else QFileDialog.ExistingFiles
        fd = FileDialog(title=title, name=name, filters=filters, parent=window, add_all_files_filter=all_files, mode=mode)
        fd.setParent(None)
        if not fd.accepted:
            if DEBUG: print("NO selected external library path")
            return
        p = fd.get_files()
        path = p[0]   #tuple, not list
        try:
            if DEBUG: print("selected external library path is: ", path)
        except:
            pass
        if isbytestring(path):
            path = path.decode(filesystem_encoding)
        path = path.replace(os.sep, '/')
        p = path
        if p.count("metadata.db") == 0:
            if DEBUG: print("NO metadata.db was selected")
            return
        self.search_path = path
        sel_type = "all"
        self.execute_mcs(sel_type,self.search_path)
#--------------------------------------------------------------------------------------------------
#--------------------------------------------------------------------------------------------------
#--------------------------------------------------------------------------------------------------
#--------------------------------------------------------------------------------------------------
class MCSSearchTab(QWidget):
    # a.k.a. "Intra/Inter Book Queries"
    prefs = None
    def __init__(self,gui,icon,guidb,mcsprefs,search_request_control,swap_criteria_refresh,current_library_path,
                        load_criteria_settings_generic, create_criteria_parm_list_generic,save_settings_parm_history_to_prefs_generic,unpack_selected_parm_generic):
        super(MCSSearchTab, self).__init__()

        #-----------------------------------------------------
        self.gui = gui
        self.guidb = self.gui.library_view.model().db

        global prefs
        prefs = mcsprefs

        self.search_request_control = search_request_control
        self.swap_criteria_refresh = swap_criteria_refresh

        self.load_criteria_settings_generic = load_criteria_settings_generic
        self.create_criteria_parm_list_generic = create_criteria_parm_list_generic
        self.save_settings_parm_history_to_prefs_generic = save_settings_parm_history_to_prefs_generic
        self.unpack_selected_parm_generic = unpack_selected_parm_generic

        self.current_library_path = as_unicode(current_library_path)
        self.search_path = current_library_path
        self.new_search_path = current_library_path

        self.determine_selected_regex = None
        #-----------------------------------------------------
        for k,v in iteritems(prefs.defaults):
            if k in prefs:
                continue
            else:
                prefs[k] = v
        #END FOR
        #-----------------------------------------------------
        font = QFont()
        font.setBold(False)
        font.setPointSize(8)

        self.setWindowTitle('Multi-Column Search')
        self.setWindowIcon(icon)

        s_tooltip = "<p style='white-space:wrap'>This Tab is used to search using 3 different types of multi-column queries:  Intra-Book; Inter-Book, and Cross-Library.\
                                                                            <br><br> Intra-Book queries are the 'default', and simultaneously compare multiple columns within a single book before moving on to the next book.\
                                                                            <br><br> Inter-Book queries compare multiple columns simultaneously in each book to the same columns of all other books in the library.\
                                                                            <br><br> Cross-Library queries are all Intra-Book, but in a library that is not the current library."
        self.setToolTip(s_tooltip)

        #-----------------------------------------------------
        self.layout_frame = QGridLayout()
        self.layout_frame.setSpacing(0)
        self.layout_frame.setContentsMargins(QMargins(0,0,0,0));
        self.setLayout(self.layout_frame)
        #-----------------------------------------------------
        self.groupbox_main = QGroupBox('')
        self.layout_frame.addWidget(self.groupbox_main)

        self.layout_main = QHBoxLayout()
        self.groupbox_main.setLayout(self.layout_main)

        #-----------------------------------------------------
        self.col1_groupbox = QGroupBox(' ')
        self.layout_main.addWidget(self.col1_groupbox)

        self.col1_layout = QGridLayout()
        self.col1_groupbox.setLayout(self.col1_layout)

        self.label1 = QLabel()
        self.label1.setTextFormat(Qt.RichText)
        self.label1.setText("<center><font color='#0404B4'>Lookup/Search Name [1]</font></center>")
        self.label1.setFont(font)
        self.col1_layout.addWidget(self.label1)

        self.msg1 = QLineEdit(self)
        self.msg1.setText(prefs['NAME1'])
        self.msg1.setToolTip("<p style='white-space:wrap'>Either a Custom Column Lookup/Search Name, such as '#genre', \
                                                                                            or one of eight (8) Standard Columns[*] supported by MCS: authors, title, series, tags, publisher, comments, pubdate, path.  \
                                                                                            MCS will also understand using 'author' instead of 'authors', and 'published' instead of 'pubdate'. \
                                                                                            <br><br>[*]Inter-Book Searches have fewer valid choices for Standard Columns:  authors, title and series.  ")
        self.col1_layout.addWidget(self.msg1)

        self.label1.setBuddy(self.msg1)

        #--------------------------------------------------
        #--------------------------------------------------
        global standard_fields_list
        standard_fields_list[:] = []
        standard_fields_list.append("authors")
        standard_fields_list.append("author")
        standard_fields_list.append("title")
        standard_fields_list.append("series")
        standard_fields_list.append("tags")
        standard_fields_list.append("publisher")
        standard_fields_list.append("comments")
        standard_fields_list.append("pubdate")
        standard_fields_list.append("published")
        standard_fields_list.append("path")
        #--------------------------------------------------
        autocompletion_field_list = []
        for row in standard_fields_list:
            autocompletion_field_list.append(row)
        autocompletion_field_list.sort()
        #--------------------------------------------------
        tmp_list = self.guidb.custom_field_keys(include_composites=False)
        for row in tmp_list:
            autocompletion_field_list.append(row)
        del tmp_list
        #--------------------------------------------------
        self.msg1_completer = QCompleter(autocompletion_field_list)
        self.msg1_completer.setCompletionMode(QCompleter.CompletionMode.UnfilteredPopupCompletion)
        self.msg1_completer.setCaseSensitivity(Qt.CaseInsensitive)
        self.msg1_completer.setMaxVisibleItems(COMPLETER_MAX_VISIBLE_ITEMS)
        self.msg1.setCompleter(self.msg1_completer)
        #--------------------------------------------------
        #--------------------------------------------------

        self.vswap_pushbutton1 = QPushButton(" ")
        self.vswap_pushbutton1.setText("↑↓ Swap ↑↓")
        self.vswap_pushbutton1.setMaximumWidth(60)
        self.vswap_pushbutton1.clicked.connect(self.execute_vswap_criteria_1)
        self.vswap_pushbutton1.setFont(font)
        self.col1_layout.addWidget( self.vswap_pushbutton1)

        self.label1a = QLabel()
        self.label1a.setTextFormat(Qt.RichText)
        self.label1a.setText("<center><font color='#0404B4'>Search Text</font></center>")
        self.label1a.setFont(font)
        self.col1_layout.addWidget(self.label1a)

        self.msg1a = QLineEdit(self)
        self.msg1a.setText(prefs['TEXT1'])
        self.msg1a.setToolTip("<p style='white-space:wrap'>Depending on your choice between the 2 radio buttons just below, either: (1) a textual literal to search for, or: (2) a Custom Column Lookup/Search Name, such as '#genre', \
                                                                                    or one of eight (8) Standard Columns[*] supported by MCS: authors, title, series, tags, publisher, comments, pubdate, path.  \
                                                                                    MCS will also understand using 'author' instead of 'authors', and 'published' instead of 'pubdate'. \
                                                                                    <br><br>[*]Inter-Book Searches have fewer valid choices for Standard Columns:  authors, title and series.  ")


        self.col1_layout.addWidget(self.msg1a)

        self.label1a.setBuddy(self.msg1a)

        #--------------------------------------------------
        self.msg1a_completer = QCompleter(autocompletion_field_list)
        self.msg1a_completer.setCompletionMode(QCompleter.CompletionMode.UnfilteredPopupCompletion)
        self.msg1a_completer.setCaseSensitivity(Qt.CaseInsensitive)
        self.msg1a_completer.setMaxVisibleItems(COMPLETER_MAX_VISIBLE_ITEMS)
        self.msg1a.setCompleter(self.msg1a_completer)
        #--------------------------------------------------
        #--------------------------------------------------

        self.col1a_radio = QRadioButton('Search Text is Text')
        if prefs['TYPE1'] == 'TEXT' :
            self.col1a_radio.setChecked(True)
        self.col1_layout.addWidget(self.col1a_radio)
        self.col1b_radio = QRadioButton('Search Text is a Lookup/Search Name')
        if prefs['TYPE1'] == 'LABEL' :
            self.col1b_radio.setChecked(True)
        self.col1_layout.addWidget(self.col1b_radio)
        self.col1_button_group_1 = QButtonGroup(self.col1_layout)
        self.col1_button_group_1.addButton(self.col1a_radio)
        self.col1_button_group_1.addButton(self.col1b_radio)

        self.spacing1 = QLabel()
        self.col1_layout.addWidget(self.spacing1)

        self.radio10 = QRadioButton("=")
        self.col1_layout.addWidget(self.radio10)
        self.radio11 = QRadioButton(">")
        self.col1_layout.addWidget(self.radio11)
        self.radio12 = QRadioButton("<")
        self.col1_layout.addWidget(self.radio12)
        self.radio13 = QRadioButton(">=")
        self.col1_layout.addWidget(self.radio13)
        self.radio14 = QRadioButton("<=")
        self.col1_layout.addWidget(self.radio14)
        self.radio16 = QRadioButton("!=")
        self.col1_layout.addWidget(self.radio16)
        self.radio15 = QRadioButton("contains")
        self.col1_layout.addWidget(self.radio15)
        self.radio17 = QRadioButton("does not contain")
        self.col1_layout.addWidget(self.radio17)
        self.radio18 = QRadioButton("regular expression")
        self.col1_layout.addWidget(self.radio18)

        if prefs['OPERATOR1'] == '=':
            self.radio10.setChecked(True)
        if prefs['OPERATOR1'] == '>':
            self.radio11.setChecked(True)
        if prefs['OPERATOR1'] == '<':
            self.radio12.setChecked(True)
        if prefs['OPERATOR1'] == '>=':
            self.radio13.setChecked(True)
        if prefs['OPERATOR1'] == '<=':
            self.radio14.setChecked(True)
        if prefs['OPERATOR1'] == '!=':
            self.radio16.setChecked(True)
        if prefs['OPERATOR1'] == 'contains':
            self.radio15.setChecked(True)
        if prefs['OPERATOR1'] == 'notcontains':
            self.radio17.setChecked(True)
        if prefs['OPERATOR1'] == 'regex':
            self.radio18.setChecked(True)


        self.col1_transform_function_combobox = QComboBox()
        self.col1_transform_function_combobox.addItem(COMPARE_AS_IS)
        self.col1_transform_function_combobox.addItem(COMPARE_UPPER_CASE)
        self.col1_transform_function_combobox.addItem(COMPARE_NO_SPACES_NO_PUNCTUATION)
        self.col1_transform_function_combobox.addItem(COMPARE_UPPER_CASE_NO_SPACES_NO_PUNCTUATION)
        self.col1_transform_function_combobox.addItem(COMPARE_DECOMPOSED_NORMALIZED_ALPHABET)
        self.col1_transform_function_combobox.setEditable(False)

        transform_functions_tooltip ="<p style='white-space:wrap'>Functions to 'transform' the values to be compared prior to comparison.\
                                                                                                                                            <br><br><b><i>'Decompose and Normalize Alphabet'</b></i> allows searching for non-English metadata that may or may not have been mangled into something English-like.  Basically, it changes complex letters into simple letters, removes diacritics, removes spaces, and removes punctuation.  Then, the values are compared.\
                                                                                                                                            <br><br>\
                                                                                                                                            <br>[*]Important:  Inter-Book Searches <b>do not</b> use Fuzzy Logic Search Functions, but <b>do</b> use Transform Functions. \
                                                                                                                                            <br><br>\
                                                                                                                                            <br>[*]Important:  Cross-Library Searches <b>do</b> use Fuzzy Logic Search Functions, but do <b>not</b> use Transform Functions. \
                                                                                                                                            <br><br>\
                                                                                                                                            <br>[*]Important:  Intra-Book Searches use <b>both</b> Fuzzy Logic Search Functions <b>and</b> Transform Functions.<br>"

        self.col1_transform_function_combobox.setToolTip(transform_functions_tooltip)

        self.col1_layout.addWidget(self.col1_transform_function_combobox)

        if prefs['TRANSFORM_FUNCTION1'] == COMPARE_AS_IS:
                self.col1_transform_function_combobox.setCurrentIndex(0)
        elif prefs['TRANSFORM_FUNCTION1'] == COMPARE_UPPER_CASE:
                self.col1_transform_function_combobox.setCurrentIndex(1)
        elif prefs['TRANSFORM_FUNCTION1'] == COMPARE_NO_SPACES_NO_PUNCTUATION:
                self.col1_transform_function_combobox.setCurrentIndex(2)
        elif prefs['TRANSFORM_FUNCTION1'] == COMPARE_UPPER_CASE_NO_SPACES_NO_PUNCTUATION:
                self.col1_transform_function_combobox.setCurrentIndex(3)
        elif prefs['TRANSFORM_FUNCTION1'] == COMPARE_DECOMPOSED_NORMALIZED_ALPHABET:
                self.col1_transform_function_combobox.setCurrentIndex(4)

        self.col1_fuzzywuzzy_function_combobox = QComboBox()
        self.col1_fuzzywuzzy_function_combobox.addItem(FUZZYWUZZY_NONE)
        self.col1_fuzzywuzzy_function_combobox.addItem(FUZZYWUZZY_TOKEN_SORT_RATIO)
        self.col1_fuzzywuzzy_function_combobox.addItem(FUZZYWUZZY_TOKEN_SET_RATIO)
        self.col1_fuzzywuzzy_function_combobox.addItem(FUZZYWUZZY_SIMPLE_RATIO_UPPER_CASE_NO_PUNCTUATION)
        self.col1_fuzzywuzzy_function_combobox.addItem(FUZZYWUZZY_SIMPLE_RATIO_DECOMPOSED_NORMALIZED_ALPHABET)
        self.col1_fuzzywuzzy_function_combobox.addItem(FUZZY_DOUBLEMETAPHONE_SIMPLE)
        self.col1_fuzzywuzzy_function_combobox.setEditable(False)
        fuzzywuzzy_tooltip_text = \
            "<p style='white-space:wrap'>Fuzzy Logic Search Functions.  These functions are used <b>only for an operator of '='</b>, because they are used to test for 'Fuzzy <b>Equality'</b>. \
             <br><br>[A]Function <b><i>'Token Sort Ratio'</b></i>: the words must be identical and in the same quantity, but their sort sequence may be different. \
             <br><br>[A1]Example:  'fuzzy wuzzy was a bear' <b>is identical to</b> 'a bear was wuzzy fuzzy' \
             <br><br>\
             <br><br>[B]Function <b><i>'Token Set Ratio'</b></i>: the number of duplicate words do not matter as long as all of the words in the second value are used somewhere in the first value.\
             <br><br>[B1]Example:  'fuzzy wuzzy was a bear' <b>is identical to</b> 'was fuzzy fuzzy was a wuzzy wuzzy a bear bear' \
             <br><br>[B2]Example:  'Bokmal: Å,å,A,a,O,o,Å,å,AE,ae,Ø,ø' <b>is identical to</b> 'Bokmal: AE,ae  Bokmal: AE,ae  Bokmal: AE,ae' \
             <br><br>\
            <br><br>[C]Function <b><i>'Simple Ratio, No Punctuation, Upper Case'</b></i>: the words are compared with all punctuation first removed and then converted to upper case. \
             <br><br>[C1]Example:  'fuzzy wuzzy was a bear...' <b>is identical to</b> 'fuzzy wuzzy was a bear?' \
             <br><br>\
            <br><br>[D]Function <b><i>'Simple Ratio': Decomposed and Normalized Alphabet'</b></i> allows searching for non-English metadata that may or may not have been mangled into something English-like.  Basically, it changes complex letters into simple letters, removes diacritics, removes spaces, and removes punctuation.  Then, the values are compared.\
             <br><br>[D1]Example:  ''Bokmal: AE,ae <b>is identical to</b> Bokmål: Æ,æ'' \
             <br><br>\
            <br><br>[E]Function <b><i>'DoubleMetaphone Sounds-Like'</b></i> uses a multi-language phonetic algorithm as described by Wikipedia:  https://en.wikipedia.org/wiki/Metaphone#Double_Metaphone \
             <br><br>[E1]Example: 'Brian Katherine' <b>is identical to</b> 'Bryan Catherine'.\
             <br><br>[E2]Example: 'Bokmål: Å,å' <b>is identical to</b> 'Bokmal: A,a'.\
             <br><br>\
             <br>[*]Important:  Inter-Book Searches <b>do not</b> use Fuzzy Logic Search Functions, but <b>do</b> use Transform Functions. \
             <br><br>\
             <br>[*]Important:  Cross-Library Searches <b>do</b> use Fuzzy Logic Search Functions, but do <b>not</b> use Transform Functions.\
            <br><br>\
             <br>[*]Important:  Intra-Book Searches use <b>both</b> Fuzzy Logic Search Functions <b>and</b> Transform Functions.<br>"

        self.col1_fuzzywuzzy_function_combobox.setToolTip(fuzzywuzzy_tooltip_text)
        self.col1_layout.addWidget(self.col1_fuzzywuzzy_function_combobox)

        if prefs['FUZZYWUZZY1'] == FUZZYWUZZY_NONE:
                self.col1_fuzzywuzzy_function_combobox.setCurrentIndex(0)
        elif prefs['FUZZYWUZZY1'] == FUZZYWUZZY_TOKEN_SORT_RATIO:
                self.col1_fuzzywuzzy_function_combobox.setCurrentIndex(1)
        elif prefs['FUZZYWUZZY1'] == FUZZYWUZZY_TOKEN_SET_RATIO:
                self.col1_fuzzywuzzy_function_combobox.setCurrentIndex(2)
        elif prefs['FUZZYWUZZY1'] == FUZZYWUZZY_SIMPLE_RATIO_UPPER_CASE_NO_PUNCTUATION:
                self.col1_fuzzywuzzy_function_combobox.setCurrentIndex(3)
        elif prefs['FUZZYWUZZY1'] == FUZZYWUZZY_SIMPLE_RATIO_DECOMPOSED_NORMALIZED_ALPHABET:
                self.col1_fuzzywuzzy_function_combobox.setCurrentIndex(4)
        elif prefs['FUZZYWUZZY1'] == FUZZY_DOUBLEMETAPHONE_SIMPLE:
                self.col1_fuzzywuzzy_function_combobox.setCurrentIndex(5)

        #-----------------------------------------------------

        self.boolean_groupbox = QGroupBox(' ')
        self.layout_main.addWidget(self.boolean_groupbox)

        self.layout_boolean = QVBoxLayout()
        self.boolean_groupbox.setLayout(self.layout_boolean)

        self.and_radio = QRadioButton('AND')
        self.layout_boolean.addWidget(self.and_radio)
        self.or_radio = QRadioButton('OR')
        self.layout_boolean.addWidget(self.or_radio)
        self.not_radio = QRadioButton('NOT')
        self.layout_boolean.addWidget(self.not_radio)
        self.ignore_radio = QRadioButton('Inactive')
        self.layout_boolean.addWidget(self.ignore_radio)

        self.layout_boolean.addSpacing(50)

        self.push_button_swap = QPushButton(" ", self)
        self.push_button_swap.setText("← Swap →")
        self.push_button_swap.setMinimumWidth(75)
        self.push_button_swap.clicked.connect(self.execute_swap_criteria)
        self.push_button_swap.setFont(font)
        self.layout_boolean.addWidget(self.push_button_swap)

        self.activate_interbook_search_checkbox = QCheckBox()
        #~ self.activate_interbook_search_checkbox.stateChanged.connect(self.interbook_search_selected)  -  deferred until the end after all other objects have been created.
        self.activate_interbook_search_checkbox.setText("Inter-Book Search?")
        self.activate_interbook_search_checkbox.setFont(font)
        self.activate_interbook_search_checkbox.setToolTip("<p style='white-space:wrap'>Checking this box activates a search algorithm that answers this type of query:\
                                                                                                                            <br><br><b>'Find all of the books that have the same [COLUMN NAME 1] and the same [COLUMN NAME 2],\
                                                                                                                            ignoring all other columns.  I want to compare each book to every other book. \
                                                                                                                            I do NOT want to have to provide any specific value to search for. Let MCS do the work for me'.</b>\
                                                                                                                            <br><br>REQUIRED SETTINGS:\
                                                                                                                            <br>[1] The Top and Bottom 'Lookup/Search Names' must be identical on the Left Side.  Ditto for the Right Side. \
                                                                                                                            <br>[2] Valid 'Lookup/Search Names':  Any #Custom Column; 3 Standard Columns: Title; Authors; Series.  No others.\
                                                                                                                            <br>[3] The Operators must both be '='. \
                                                                                                                            <br>[4] 'AND' must be selected in the Middle Column. \
                                                                                                                            <br>[5] Execution is always for 'All Books'. \
                                                                                                                            <br>[6] Execution is always for the Current Library, and never Another Library. \
                                                                                                                            <br><br>OPTIONAL SETTINGS:\
                                                                                                                            <br>The 'Compare:' Transform Functions may be anything, and may be different between Left and Right.\
                                                                                                                            <br><br>EXAMPLE:\
                                                                                                                            <br>I have many books by many Authors both written in their original languages and translated to English, so I <b>cannot</b> specify any particular Author to search for. \
                                                                                                                            I want to display all books which have the same Author and same Custom Column:original_title. The Author is crucial for comparison,\
                                                                                                                            as the same Title/Custom Column:original_title can have multiple authors. MCS should return only books for which there are translations.\
                                                                                                                            <br><br>Example of returned result:\
                                                                                                                            <br>Author ------------------ Name -------------------------Custom Column:original_title\
                                                                                                                            <br>\
                                                                                                                            <br>Jules Verne ----- Five weeks in ballon ----------------- Cinq semaines en ballon\
                                                                                                                            <br>Jules Verne ----- Cinq semaines en ballon ------------ Cinq semaines en ballon\
                                                                                                                            <br>Victor Hugo ---- Notre-Dame de Paris ---------------- Notre-Dame de Paris\
                                                                                                                            <br>Victor Hugo ---- The Hunchback of Notre-Dame ----- Notre-Dame de Paris\
                                                                                                                            ")
        self.layout_boolean.addWidget(self.activate_interbook_search_checkbox)


        self.cross_library_duplicates_search_checkbox = QCheckBox()
        self.cross_library_duplicates_search_checkbox.setText("CL Duplicates?")
        self.cross_library_duplicates_search_checkbox.setFont(font)
        self.cross_library_duplicates_search_checkbox.setToolTip("<p style='white-space:wrap'>Do you want to check for duplicates in another library using the current search settings?\
                                                                                                                                            <br><br> This option is used <b>only</b> with Cross-Library searches. ")
        self.layout_boolean.addWidget(self.cross_library_duplicates_search_checkbox)

        self.activate_all_author_books_checkbox = QCheckBox()
        self.activate_all_author_books_checkbox.setText("All Authors' Books?")
        self.activate_all_author_books_checkbox.setFont(font)
        self.activate_all_author_books_checkbox.setToolTip("<p style='white-space:wrap'>Checking this box causes all books of every Author in the search results to also be marked and displayed.\
                                                                                                                                            <br><br> This option is not used and will be ignored in Cross-Library searches. ")
        self.layout_boolean.addWidget(self.activate_all_author_books_checkbox)

        if prefs['ALL_AUTHORS_BOOKS'] == "True":
            self.activate_all_author_books_checkbox.setChecked(True)

        self.add_final_filters_checkbox = QCheckBox()
        self.add_final_filters_checkbox.setText("Use Final Filters?")
        self.add_final_filters_checkbox.setFont(font)
        self.add_final_filters_checkbox.setToolTip("<p style='white-space:wrap'>Checking this box causes the active filters defined in the Final Filters Tab to be used at the very end of the search.\
                                                                                                                                            <br><br> This option is not used and will be ignored in Cross-Library searches. ")
        self.layout_boolean.addWidget(self.add_final_filters_checkbox)

        if prefs['USE_FINAL_FILTERS'] == "True":
            self.add_final_filters_checkbox.setChecked(True)

        self.push_button_save_defaults = QPushButton(" ", self)
        self.push_button_save_defaults.setText("Save Criteria")
        self.push_button_save_defaults.setToolTip("<p style='white-space:wrap'>Save (with a name) all criteria for this Tab.")
        self.push_button_swap.setMinimumWidth(75)
        self.push_button_save_defaults.clicked.connect(self.save_criteria_settings)
        self.push_button_save_defaults.setFont(font)
        self.layout_boolean.addWidget(self.push_button_save_defaults)

        self.push_button_load_defaults = QPushButton(" ", self)
        self.push_button_load_defaults.setText("Load Criteria")
        self.push_button_load_defaults.setToolTip("<p style='white-space:wrap'>Select a previously saved (with a name) set of criteria for this Tab.<br><br>The checkmarks for All Authors' Books and Use Final Filters are not saved, and must be selected separately for each executed Query.")
        self.push_button_swap.setMinimumWidth(75)
        self.push_button_load_defaults.clicked.connect(self.load_criteria_settings_searchtab)
        self.push_button_load_defaults.setFont(font)
        self.layout_boolean.addWidget(self.push_button_load_defaults)

        self.ignore_radio.setChecked(True)
        if prefs['ANDORNOT'] == 'AND' :
            self.and_radio.setChecked(True)
        if prefs['ANDORNOT'] == 'OR' :
            self.or_radio.setChecked(True)
        if prefs['ANDORNOT'] == 'NOT' :
            self.not_radio.setChecked(True)
        if prefs['ANDORNOT'] == 'IGNORE' :
            self.ignore_radio.setChecked(True)

        #-----------------------------------------------------
        self.col2_groupbox = QGroupBox(' ')
        self.layout_main.addWidget(self.col2_groupbox)

        self.col2_layout = QGridLayout()
        self.col2_groupbox.setLayout(self.col2_layout)

        self.label2 = QLabel()
        self.label2.setTextFormat(Qt.RichText)
        self.label2.setText("<center><font color='#0404B4'>Lookup/Search Name [2]</font></center>")
        self.label2.setFont(font)
        self.col2_layout.addWidget(self.label2)

        self.msg2 = QLineEdit(self)
        self.msg2.setText(prefs['NAME2'])
        self.msg2.setToolTip("<p style='white-space:wrap'>Either a Custom Column Lookup/Search Name, such as '#genre', \
                                                                                            or one of eight (8) Standard Columns[*] supported by MCS: authors, title, series, tags, publisher, comments, pubdate, path.  \
                                                                                            MCS will also understand using 'author' instead of 'authors', and 'published' instead of 'pubdate'. \
                                                                                            <br><br>[*]Inter-Book Searches have fewer valid choices for Standard Columns:  authors, title and series.  ")



        self.col2_layout.addWidget(self.msg2)

        self.label2.setBuddy(self.msg2)

        #--------------------------------------------------
        self.msg2_completer = QCompleter(autocompletion_field_list)
        self.msg2_completer.setCompletionMode(QCompleter.CompletionMode.UnfilteredPopupCompletion)
        self.msg2_completer.setCaseSensitivity(Qt.CaseInsensitive)
        self.msg2_completer.setMaxVisibleItems(COMPLETER_MAX_VISIBLE_ITEMS)
        self.msg2.setCompleter(self.msg2_completer)
        #--------------------------------------------------
        #--------------------------------------------------

        self.vswap_pushbutton2 = QPushButton(" ")
        self.vswap_pushbutton2.setText("↑↓ Swap ↑↓")
        self.vswap_pushbutton2.setMaximumWidth(60)
        self.vswap_pushbutton2.clicked.connect(self.execute_vswap_criteria_2)
        self.vswap_pushbutton2.setFont(font)
        self.col2_layout.addWidget( self.vswap_pushbutton2)


        self.label2a = QLabel()
        self.label2a.setTextFormat(Qt.RichText)
        self.label2a.setText("<center><font color='#0404B4'>Search Text</font></center>")
        self.label2a.setFont(font)
        self.col2_layout.addWidget(self.label2a)

        self.msg2a = QLineEdit(self)
        self.msg2a.setText(prefs['TEXT2'])
        self.msg2a.setToolTip("<p style='white-space:wrap'>Depending on your choice between the 2 radio buttons just below, either: (1) a textual literal to search for, or: (2) a Custom Column Lookup/Search Name, such as '#genre', \
                                                                                    or one of eight (8) Standard Columns[*] supported by MCS: authors, title, series, tags, publisher, comments, pubdate, path.  \
                                                                                    MCS will also understand using 'author' instead of 'authors', and 'published' instead of 'pubdate'. \
                                                                                    <br><br>[*]Inter-Book Searches have fewer valid choices for Standard Columns:  authors, title and series.  ")
        self.col2_layout.addWidget(self.msg2a)

        self.label2a.setBuddy(self.msg2a)

        #--------------------------------------------------
        self.msg2a_completer = QCompleter(autocompletion_field_list)
        self.msg2a_completer.setCompletionMode(QCompleter.CompletionMode.UnfilteredPopupCompletion)
        self.msg2a_completer.setCaseSensitivity(Qt.CaseInsensitive)
        self.msg2a_completer.setMaxVisibleItems(COMPLETER_MAX_VISIBLE_ITEMS)
        self.msg2a.setCompleter(self.msg2_completer)
        #--------------------------------------------------
        #--------------------------------------------------

        self.col2a_radio = QRadioButton('Search Text is Text')
        if prefs['TYPE2'] == 'TEXT' :
            self.col2a_radio.setChecked(True)
        self.col2_layout.addWidget(self.col2a_radio)
        self.col2b_radio = QRadioButton('Search Text is a Lookup/Search Name')
        if prefs['TYPE2'] == 'LABEL' :
            self.col2b_radio.setChecked(True)
        self.col2_layout.addWidget(self.col2b_radio)
        self.col2_button_group_2 = QButtonGroup(self.col2_layout)
        self.col2_button_group_2.addButton(self.col2a_radio)
        self.col2_button_group_2.addButton(self.col2b_radio)

        self.spacing2 = QLabel()
        self.col2_layout.addWidget(self.spacing2)

        self.radio20 = QRadioButton("=")
        self.col2_layout.addWidget(self.radio20)
        self.radio21 = QRadioButton(">")
        self.col2_layout.addWidget(self.radio21)
        self.radio22 = QRadioButton("<")
        self.col2_layout.addWidget(self.radio22)
        self.radio23 = QRadioButton(">=")
        self.col2_layout.addWidget(self.radio23)
        self.radio24 = QRadioButton("<=")
        self.col2_layout.addWidget(self.radio24)
        self.radio26 = QRadioButton("!=")
        self.col2_layout.addWidget(self.radio26)
        self.radio25 = QRadioButton("contains")
        self.col2_layout.addWidget(self.radio25)
        self.radio27 = QRadioButton("does not contain")
        self.col2_layout.addWidget(self.radio27)
        self.radio28 = QRadioButton("regular expression")
        self.col2_layout.addWidget(self.radio28)

        if prefs['OPERATOR2'] == '=':
            self.radio20.setChecked(True)
        if prefs['OPERATOR2'] == '>':
            self.radio21.setChecked(True)
        if prefs['OPERATOR2'] == '<':
            self.radio22.setChecked(True)
        if prefs['OPERATOR2'] == '>=':
            self.radio23.setChecked(True)
        if prefs['OPERATOR2'] == '<=':
            self.radio24.setChecked(True)
        if prefs['OPERATOR2'] == '!=':
            self.radio26.setChecked(True)
        if prefs['OPERATOR2'] == 'contains':
            self.radio25.setChecked(True)
        if prefs['OPERATOR2'] == 'notcontains':
            self.radio27.setChecked(True)
        if prefs['OPERATOR2'] == 'regex':
            self.radio28.setChecked(True)


        self.col2_transform_function_combobox = QComboBox()
        self.col2_transform_function_combobox.addItem(COMPARE_AS_IS)
        self.col2_transform_function_combobox.addItem(COMPARE_UPPER_CASE)
        self.col2_transform_function_combobox.addItem(COMPARE_NO_SPACES_NO_PUNCTUATION)
        self.col2_transform_function_combobox.addItem(COMPARE_UPPER_CASE_NO_SPACES_NO_PUNCTUATION)
        self.col2_transform_function_combobox.addItem(COMPARE_DECOMPOSED_NORMALIZED_ALPHABET)
        self.col2_transform_function_combobox.setEditable(False)
        self.col2_transform_function_combobox.setToolTip(transform_functions_tooltip)
        self.col2_layout.addWidget(self.col2_transform_function_combobox)

        if prefs['TRANSFORM_FUNCTION2'] == COMPARE_AS_IS:
                self.col2_transform_function_combobox.setCurrentIndex(0)
        elif  prefs['TRANSFORM_FUNCTION2'] == COMPARE_UPPER_CASE:
                self.col2_transform_function_combobox.setCurrentIndex(1)
        elif prefs['TRANSFORM_FUNCTION2'] == COMPARE_NO_SPACES_NO_PUNCTUATION:
                self.col2_transform_function_combobox.setCurrentIndex(2)
        elif prefs['TRANSFORM_FUNCTION2'] == COMPARE_UPPER_CASE_NO_SPACES_NO_PUNCTUATION:
                self.col2_transform_function_combobox.setCurrentIndex(3)
        elif prefs['TRANSFORM_FUNCTION2'] == COMPARE_DECOMPOSED_NORMALIZED_ALPHABET:
                self.col2_transform_function_combobox.setCurrentIndex(4)


        self.col2_fuzzywuzzy_function_combobox = QComboBox()
        self.col2_fuzzywuzzy_function_combobox.addItem(FUZZYWUZZY_NONE)
        self.col2_fuzzywuzzy_function_combobox.addItem(FUZZYWUZZY_TOKEN_SORT_RATIO)
        self.col2_fuzzywuzzy_function_combobox.addItem(FUZZYWUZZY_TOKEN_SET_RATIO)
        self.col2_fuzzywuzzy_function_combobox.addItem(FUZZYWUZZY_SIMPLE_RATIO_UPPER_CASE_NO_PUNCTUATION)
        self.col2_fuzzywuzzy_function_combobox.addItem(FUZZYWUZZY_SIMPLE_RATIO_DECOMPOSED_NORMALIZED_ALPHABET)
        self.col2_fuzzywuzzy_function_combobox.addItem(FUZZY_DOUBLEMETAPHONE_SIMPLE)
        self.col2_fuzzywuzzy_function_combobox.setEditable(False)
        self.col2_fuzzywuzzy_function_combobox.setToolTip(fuzzywuzzy_tooltip_text)

        self.col2_layout.addWidget(self.col2_fuzzywuzzy_function_combobox)

        if prefs['FUZZYWUZZY2'] == FUZZYWUZZY_NONE:
                self.col2_fuzzywuzzy_function_combobox.setCurrentIndex(0)
        elif prefs['FUZZYWUZZY2'] == FUZZYWUZZY_TOKEN_SORT_RATIO:
                self.col2_fuzzywuzzy_function_combobox.setCurrentIndex(1)
        elif prefs['FUZZYWUZZY2'] == FUZZYWUZZY_TOKEN_SET_RATIO:
                self.col2_fuzzywuzzy_function_combobox.setCurrentIndex(2)
        elif prefs['FUZZYWUZZY2'] == FUZZYWUZZY_SIMPLE_RATIO_UPPER_CASE_NO_PUNCTUATION:
                self.col2_fuzzywuzzy_function_combobox.setCurrentIndex(3)
        elif prefs['FUZZYWUZZY2'] == FUZZYWUZZY_SIMPLE_RATIO_DECOMPOSED_NORMALIZED_ALPHABET:
                self.col2_fuzzywuzzy_function_combobox.setCurrentIndex(4)
        elif prefs['FUZZYWUZZY2'] == FUZZY_DOUBLEMETAPHONE_SIMPLE:
                self.col2_fuzzywuzzy_function_combobox.setCurrentIndex(5)

        #-----------------------------------------------------
        #-----------------------------------------------------
        self.cross_library_duplicates_search_checkbox.stateChanged.connect(self.cross_library_duplicates_search_selected)
        if prefs['CROSS_LIBRARY_DUPLICATES_SEARCH'] == "True":
            self.cross_library_duplicates_search_checkbox.setChecked(True)
            self.activate_cross_library_duplicates_search()
            self.col1_transform_function_combobox.setCurrentIndex(0)
            self.col2_transform_function_combobox.setCurrentIndex(0)
        #-----------------------------------------------------
        #-----------------------------------------------------
        self.activate_interbook_search_checkbox.stateChanged.connect(self.interbook_search_selected)
        if prefs['INTER_BOOK_SEARCH'] == "True":
            self.activate_interbook_search_checkbox.setChecked(True)
            self.col1_fuzzywuzzy_function_combobox.setCurrentIndex(0)
            self.col2_fuzzywuzzy_function_combobox.setCurrentIndex(0)
        #-----------------------------------------------------
        #-----------------------------------------------------
        self.radio10.toggled.connect(self.operator1_radio_button_equals_changed)
        self.radio20.toggled.connect(self.operator2_radio_button_equals_changed)
        #-----------------------------------------------------
        if prefs['OPERATOR1'] != "=":
            self.col1_fuzzywuzzy_function_combobox.setCurrentIndex(0)
        if prefs['OPERATOR2'] != "=":
            self.col2_fuzzywuzzy_function_combobox.setCurrentIndex(0)

        #-----------------------------------------------------
        #-----------------------------------------------------
        #-----------------------------------------------------

        self.resize(self.sizeHint())

        global interbook_search_standard_fields_list            # Only 3 of 8 Standard Columns Supported for Inter-Book Searches:  Title, Authors, Series.  Other 5 make no sense to use.
        interbook_search_standard_fields_list[:] = []

        interbook_search_standard_fields_list.append("authors")
        interbook_search_standard_fields_list.append("author")
        interbook_search_standard_fields_list.append("title")
        interbook_search_standard_fields_list.append("series")

        global param_dict
        self.build_dict()

        param_dict['REGEX1'] = "^.+$"
        param_dict['REGEX2'] = "^.+$"
        param_dict['IGNORECASE1'] = "1"
        param_dict['IGNORECASE2'] = "1"
    #-----------------------------------------------------------------------------------------------
    def interbook_search_selected(self,event):
        # the event 'stateChanged()' is connected to this function for widget:  self.activate_interbook_search_checkbox
        if self.activate_interbook_search_checkbox.isChecked():
            self.activate_interbook_search()
        else:
            self.deactivate_interbook_search()
        self.repaint()
    #-----------------------------------------------------------------------------------------------
    def activate_interbook_search(self):
        self.cross_library_duplicates_search_checkbox.setChecked(False)  # never
        self.label1.setText("<center><font color='#0404B4'>For Each Book in Turn [1]</font></center>")
        self.label1a.setText("<center><font color='#0404B4'>Compared to All Other Books</font></center>")
        s = self.msg1.text()
        self.msg1a.setText(s)
        self.col1b_radio.setChecked(True)    # column name, not a string
        self.radio10.setChecked(True)          #    =
        self.and_radio.setChecked(True)      #   AND
        self.label2.setText("<center><font color='#0404B4'>For Each Book in Turn [2]</font></center>")
        self.label2a.setText("<center><font color='#0404B4'>Compared to All Other Books</font></center>")
        s = self.msg2.text()
        self.msg2a.setText(s)
        self.col2b_radio.setChecked(True)    # column name, not a string
        self.radio20.setChecked(True)          #    =
        self.col1_fuzzywuzzy_function_combobox.setCurrentIndex(0)  # Type = none
        self.col2_fuzzywuzzy_function_combobox.setCurrentIndex(0)  # Type = none
    #-----------------------------------------------------------------------------------------------
    def deactivate_interbook_search(self):
        self.label1.setText("<center><font color='#0404B4'>Lookup/Search Name [1]</font></center>")
        self.label1a.setText("<center><font color='#0404B4'>Search Text</font></center>")
        self.label2.setText("<center><font color='#0404B4'>Lookup/Search Name [2]</font></center>")
        self.label2a.setText("<center><font color='#0404B4'>Search Text</font></center>")
    #-----------------------------------------------------------------------------------------------
    def cross_library_duplicates_search_selected(self,event):
        # the event 'stateChanged()' is connected to this function for widget:  self.cross_library_duplicates_search_checkbox
        if self.cross_library_duplicates_search_checkbox.isChecked():
            self.activate_cross_library_duplicates_search()
        else:
            self.deactivate_cross_library_duplicates_search()
        self.repaint()
    #-----------------------------------------------------------------------------------------------
    def activate_cross_library_duplicates_search(self):
        self.activate_interbook_search_checkbox.setChecked(False)
        self.activate_all_author_books_checkbox.setChecked(False)
        self.add_final_filters_checkbox.setChecked(False)
        self.label1.setText("<center><font color='#0404B4'>For Each Book in Turn [1]</font></center>")
        self.label1a.setText("<center><font color='#0404B4'>Compared to Another Library</font></center>")
        s = self.msg1.text()
        self.msg1a.setText(s)
        self.col1b_radio.setChecked(True)    # column name, not a string
        self.radio10.setChecked(True)          #    =
        self.and_radio.setChecked(True)      #   AND
        self.label2.setText("<center><font color='#0404B4'>For Each Book in Turn [2]</font></center>")
        self.label2a.setText("<center><font color='#0404B4'>Compared to Another Library</font></center>")
        s = self.msg2.text()
        self.msg2a.setText(s)
        self.col2b_radio.setChecked(True)    # column name, not a string
        self.radio20.setChecked(True)          #    =
        self.col1_transform_function_combobox.setCurrentIndex(0)  # Type = none
        self.col2_transform_function_combobox.setCurrentIndex(0)  # Type = none
        self.msg1a.setText(self.msg1.text())
        self.msg2a.setText(self.msg2.text())
    #-----------------------------------------------------------------------------------------------
    def deactivate_cross_library_duplicates_search(self):
        self.label1.setText("<center><font color='#0404B4'>Lookup/Search Name [1]</font></center>")
        self.label1a.setText("<center><font color='#0404B4'>Search Text</font></center>")
        self.label2.setText("<center><font color='#0404B4'>Lookup/Search Name [2]</font></center>")
        self.label2a.setText("<center><font color='#0404B4'>Search Text</font></center>")
    #-----------------------------------------------------------------------------------------------
    def operator1_radio_button_equals_changed(self,event):
        # the event 'stateChanged()' is connected to this function for widget:  self.radio10
        if self.radio10.isChecked():
            pass
        else:
            self.col1_fuzzywuzzy_function_combobox.setCurrentIndex(0)
        self.repaint()
    #-----------------------------------------------------------------------------------------------
    def operator2_radio_button_equals_changed(self,event):
        # the event 'stateChanged()' is connected to this function for widget:  self.radio10
        if self.radio20.isChecked():
            pass
        else:
            self.col2_fuzzywuzzy_function_combobox.setCurrentIndex(0)
        self.repaint()
    #-----------------------------------------------------------------------------------------------
    def execute_swap_criteria(self):

        global param_dict

        self.build_dict()

        old_name1 = param_dict['NAME1']
        old_text1 = param_dict['TEXT1']
        old_type1 = param_dict['TYPE1']
        old_operator1 = param_dict['OPERATOR1']
        old_regex1 = param_dict['REGEX1']
        old_fuzzywuzzy1 = param_dict['FUZZYWUZZY1']

        old_name2 = param_dict['NAME2']
        old_text2 = param_dict['TEXT2']
        old_type2 = param_dict['TYPE2']
        old_operator2 = param_dict['OPERATOR2']
        old_regex2 = param_dict['REGEX2']
        old_fuzzywuzzy2 = param_dict['FUZZYWUZZY2']

        param_dict['NAME1'] = old_name2
        param_dict['TEXT1'] = old_text2
        param_dict['TYPE1'] = old_type2
        param_dict['OPERATOR1'] = old_operator2
        param_dict['REGEX1'] = old_regex2
        param_dict['FUZZYWUZZY1'] = old_fuzzywuzzy2

        param_dict['NAME2'] = old_name1
        param_dict['TEXT2'] = old_text1
        param_dict['TYPE2'] = old_type1
        param_dict['OPERATOR2'] = old_operator1
        param_dict['REGEX2'] = old_regex1
        param_dict['FUZZYWUZZY2'] = old_fuzzywuzzy1

        prefs['NAME1'] = param_dict['NAME1']
        prefs['TEXT1'] = param_dict['TEXT1']
        prefs['TYPE1'] = param_dict['TYPE1']
        prefs['OPERATOR1'] = param_dict['OPERATOR1']
        prefs['REGEX1'] = param_dict['REGEX1']
        prefs['FUZZYWUZZY1'] = param_dict['FUZZYWUZZY1']

        prefs['ANDORNOT'] = param_dict['ANDORNOT']

        prefs['NAME2'] = param_dict['NAME2']
        prefs['TEXT2'] = param_dict['TEXT2']
        prefs['TYPE2'] = param_dict['TYPE2']
        prefs['OPERATOR2'] = param_dict['OPERATOR2']
        prefs['REGEX2'] = param_dict['REGEX2']
        prefs['FUZZYWUZZY2'] = param_dict['FUZZYWUZZY2']

        prefs

        self.swap_criteria_refresh()
    #-----------------------------------------------------------------------------------------------
    def execute_vswap_criteria_1(self):

        global param_dict

        self.build_dict()

        old_name1 = param_dict['NAME1']
        old_text1 = param_dict['TEXT1']
        self.msg1.setText(old_text1)
        self.msg1a.setText(old_name1)
        prefs['NAME1'] = old_text1
        prefs['TEXT1'] =    old_name1
        prefs['TYPE1'] = 'LABEL'
        self.col1b_radio.setChecked(True)

        prefs

        self.swap_criteria_refresh()
    #-----------------------------------------------------------------------------------------------
    def execute_vswap_criteria_2(self):

        global prefs
        global param_dict

        self.build_dict()

        old_name2 = param_dict['NAME2']
        old_text2 = param_dict['TEXT2']
        self.msg2.setText(old_text2)
        self.msg2a.setText(old_name2)
        prefs['NAME2'] = old_text2
        prefs['TEXT2'] = old_name2
        prefs['TYPE2'] = 'LABEL'
        self.col2b_radio.setChecked(True)

        prefs

        self.swap_criteria_refresh()
    #-----------------------------------------------------------------------------------------------
    #-----------------------------------------------------------------------------------------------
    #-----------------------------------------------------------------------------------------------
    def build_dict(self):

        global prefs
        global param_dict

        param_dict['INTER_BOOK_SEARCH'] = 'False'
        if self.activate_interbook_search_checkbox.isChecked():
            param_dict['INTER_BOOK_SEARCH'] = 'True'
            self.activate_interbook_search()   # ensures the user did not manually reverse the proper settings for an inter-book search query after the checkbox was checked.
            self.repaint()

        param_dict['CROSS_LIBRARY_DUPLICATES_SEARCH'] = 'False'
        if self.cross_library_duplicates_search_checkbox.isChecked():
            param_dict['CROSS_LIBRARY_DUPLICATES_SEARCH'] = 'True'
            self.activate_all_author_books_checkbox.setChecked(False)
            self.add_final_filters_checkbox.setChecked(False)
            self.col1b_radio.setChecked(True)
            self.col2b_radio.setChecked(True)
            self.radio10.setChecked(True)
            self.radio20.setChecked(True)
            self.and_radio.setChecked(True)
            self.col1_transform_function_combobox.setCurrentIndex(0)  # Type = none
            self.col2_transform_function_combobox.setCurrentIndex(0)  # Type = none
            self.repaint()

        param_dict['ALL_AUTHORS_BOOKS'] = "False"
        if self.activate_all_author_books_checkbox.isChecked():
            param_dict['ALL_AUTHORS_BOOKS'] = "True"

        param_dict['USE_FINAL_FILTERS']  = "False"
        if self.add_final_filters_checkbox.isChecked():
            param_dict['USE_FINAL_FILTERS'] = "True"

        if not self.msg1.text():
            param_dict['NAME1'] = ""
        else:
            param_dict['NAME1'] = self.msg1.text()

        if not self.msg1a.text():
            param_dict['TEXT1'] = ""
        else:
            param_dict['TEXT1'] = self.msg1a.text()

        if self.col1a_radio.isChecked():
            param_dict['TYPE1'] = 'TEXT'
        else:
            param_dict['TYPE1'] = 'LABEL'

        param_dict['OPERATOR1'] = '='

        if self.radio10.isChecked():
            param_dict['OPERATOR1'] = '='
        if self.radio11.isChecked():
            param_dict['OPERATOR1'] = '>'
        if self.radio12.isChecked():
            param_dict['OPERATOR1'] = '<'
        if self.radio13.isChecked():
            param_dict['OPERATOR1'] = '>='
        if self.radio14.isChecked():
            param_dict['OPERATOR1'] = '<='
        if self.radio15.isChecked():
            param_dict['OPERATOR1'] = 'contains'
        if self.radio16.isChecked():
            param_dict['OPERATOR1'] = '!='
        if self.radio17.isChecked():
            param_dict['OPERATOR1'] = 'notcontains'
        if self.radio18.isChecked():
            param_dict['OPERATOR1'] = 'regex'
            try:
                param_dict['REGEX1'],param_dict['REGEX1#'] = self.determine_selected_regex(1)
            except Exception as e:#this SearchTab is initialized just before RegexTab, so the borrowed RegexTab function is a millisecond away yet from being initialized;
                if DEBUG: print("INFORMATION: RegexTab's determine_selected_regex() has not *yet* been initialized; defaults being used very briefly: ", as_unicode(e))
                param_dict['REGEX1'] = prefs['REGEX1']
                param_dict['REGEX1#'] = prefs['REGEX1#']
        else:
            param_dict['REGEX1'] = "^.+$"
            param_dict['REGEX1#'] = "0"

        param_dict['TRANSFORM_FUNCTION1'] = as_unicode(self.col1_transform_function_combobox.currentText())

        param_dict['FUZZYWUZZY1']  = as_unicode(self.col1_fuzzywuzzy_function_combobox.currentText())

        param_dict['ANDORNOT'] = 'AND'
        if self.or_radio.isChecked():
            param_dict['ANDORNOT'] = 'OR'
        else:
            if self.not_radio.isChecked():
                param_dict['ANDORNOT'] = 'NOT'
            else:
                if self.ignore_radio.isChecked():
                    param_dict['ANDORNOT'] = 'IGNORE'

        if not self.msg2.text():
            param_dict['NAME2'] = ""
        else:
            param_dict['NAME2'] = self.msg2.text()

        if not self.msg2a.text():
            param_dict['TEXT2'] = ""
        else:
            param_dict['TEXT2'] = self.msg2a.text()

        if self.col2a_radio.isChecked():
            param_dict['TYPE2'] = 'TEXT'
        else:
            param_dict['TYPE2'] = 'LABEL'

        param_dict['OPERATOR2'] = '='

        if self.radio20.isChecked():
            param_dict['OPERATOR2'] = '='
        if self.radio21.isChecked():
            param_dict['OPERATOR2'] = '>'
        if self.radio22.isChecked():
            param_dict['OPERATOR2'] = '<'
        if self.radio23.isChecked():
            param_dict['OPERATOR2'] = '>='
        if self.radio24.isChecked():
            param_dict['OPERATOR2'] = '<='
        if self.radio25.isChecked():
            param_dict['OPERATOR2'] = 'contains'
        if self.radio26.isChecked():
            param_dict['OPERATOR2'] = '!='
        if self.radio27.isChecked():
            param_dict['OPERATOR2'] = 'notcontains'
        if self.radio28.isChecked():
            param_dict['OPERATOR2'] = 'regex'
            try:
                param_dict['REGEX2'],param_dict['REGEX2#'] = self.determine_selected_regex(2)
            except Exception as e:  #this SearchTab is initialized just before RegexTab, so the borrowed RegexTab function is a millisecond away yet from being initialized;
                if DEBUG: print("INFORMATION: RegexTab's determine_selected_regex() has not *yet* been initialized; defaults being used very briefly: ", as_unicode(e))
                param_dict['REGEX2'] = prefs['REGEX2']
                param_dict['REGEX2#'] = prefs['REGEX2#']
        else:
            param_dict['REGEX2'] = "^.+$"
            param_dict['REGEX2#'] = "0"

        param_dict['TRANSFORM_FUNCTION2'] = as_unicode(self.col2_transform_function_combobox.currentText())

        param_dict['FUZZYWUZZY2']  = as_unicode(self.col2_fuzzywuzzy_function_combobox.currentText())

        if param_dict['OPERATOR1'] != "=":
            if param_dict['FUZZYWUZZY1'] != as_unicode(FUZZYWUZZY_NONE):
                self.col1_fuzzywuzzy_function_combobox.setCurrentIndex(0)
                self.repaint()
        if param_dict['OPERATOR2'] != "=":
            if param_dict['FUZZYWUZZY2'] != as_unicode(FUZZYWUZZY_NONE):
                self.col2_fuzzywuzzy_function_combobox.setCurrentIndex(0)
                self.repaint()


        if self.cross_library_duplicates_search_checkbox.isChecked():
            self.msg1a.setText(self.msg1.text())
            param_dict['TEXT1'] = param_dict['NAME1']
            self.msg2a.setText(self.msg2.text())
            param_dict['TEXT2'] = param_dict['NAME2']


        param_dict['FINAL_FILTER_0'] = prefs['FINAL_FILTER_0']
        param_dict['FINAL_FILTER_1'] = prefs['FINAL_FILTER_1']
        param_dict['FINAL_FILTER_2'] = prefs['FINAL_FILTER_2']
        param_dict['FINAL_FILTER_3'] = prefs['FINAL_FILTER_3']
        param_dict['FINAL_FILTER_4'] = prefs['FINAL_FILTER_4']
        param_dict['FINAL_FILTER_5'] = prefs['FINAL_FILTER_5']
        param_dict['FINAL_FILTER_6'] = prefs['FINAL_FILTER_6']
        param_dict['FINAL_FILTER_7'] = prefs['FINAL_FILTER_7']
        param_dict['FINAL_FILTER_8'] = prefs['FINAL_FILTER_8']
        param_dict['FINAL_FILTER_9'] = prefs['FINAL_FILTER_9']
    #-----------------------------------------------------------------------------------------------
    def save_criteria_settings(self):

        global prefs
        global param_dict

        self.build_dict()

        prefs['NAME1'] = as_unicode(param_dict['NAME1'])
        prefs['TEXT1'] = as_unicode(param_dict['TEXT1'])
        prefs['TYPE1'] = as_unicode(param_dict['TYPE1'])
        prefs['OPERATOR1'] = as_unicode(param_dict['OPERATOR1'])
        prefs['REGEX1'] = as_unicode(param_dict['REGEX1'])
        prefs['REGEX1#'] = as_unicode(param_dict['REGEX1#'])
        prefs['TRANSFORM_FUNCTION1'] = as_unicode(param_dict['TRANSFORM_FUNCTION1'])
        prefs['FUZZYWUZZY1'] = as_unicode(param_dict['FUZZYWUZZY1'])

        prefs['ANDORNOT'] = as_unicode(param_dict['ANDORNOT'])

        prefs['INTER_BOOK_SEARCH']  = as_unicode(param_dict['INTER_BOOK_SEARCH'] )

        prefs['CROSS_LIBRARY_DUPLICATES_SEARCH'] = as_unicode(param_dict['CROSS_LIBRARY_DUPLICATES_SEARCH'])

        prefs['ALL_AUTHORS_BOOKS']  = as_unicode(param_dict['ALL_AUTHORS_BOOKS'] )

        prefs['USE_FINAL_FILTERS'] = as_unicode(param_dict['USE_FINAL_FILTERS'])

        prefs['NAME2'] = as_unicode(param_dict['NAME2'])
        prefs['TEXT2'] = as_unicode(param_dict['TEXT2'])
        prefs['TYPE2'] = as_unicode(param_dict['TYPE2'])
        prefs['OPERATOR2'] = as_unicode(param_dict['OPERATOR2'])
        prefs['REGEX2'] = as_unicode(param_dict['REGEX2'])
        prefs['REGEX2#'] = as_unicode(param_dict['REGEX2#'])
        prefs['TRANSFORM_FUNCTION2'] = as_unicode(param_dict['TRANSFORM_FUNCTION2'])
        prefs['FUZZYWUZZY2'] = as_unicode(param_dict['FUZZYWUZZY2'])

        prefs['BOOKS_VALID_FOR_POST_SEARCH_ACTIONS'] = "[]"

        prefs['PARAM_DICT_LAST_SAVED_TO_PREFS_FROM_TAB'] = SEARCHTAB

        prefs

        param_dict['PARAM_DICT_LAST_SAVED_TO_PREFS_FROM_TAB'] = SEARCHTAB

        srchtab_dict = {}
        for k,v in iteritems(param_dict):
            if not k.startswith('FINAL_FILTER_'):
                if not k.startswith('REGEX'):
                    srchtab_dict[k] = v  # only save current SearchTab widget values, not all of param_dict which necessarily includes criteria from multiple Tabs...
        #END FOR

        srchtab_dict['REGEX1'] = prefs['REGEX1']  #for an audit trail of what the SearchTab's 'selected' RegexTab regular expressions were when the SearchTab criteria were saved...
        srchtab_dict['REGEX1#'] = prefs['REGEX1#']
        srchtab_dict['REGEX2'] = prefs['REGEX2']
        srchtab_dict['REGEX2#'] = prefs['REGEX2#']
        srchtab_dict['IGNORECASE1'] = prefs['IGNORECASE1']
        srchtab_dict['IGNORECASE2'] = prefs['IGNORECASE2']

        #~ ----------------------------------------------------------------------------------
        #~ These 2 options are selected at query execution time only, and never saved
        #~ ----------------------------------------------------------------------------------
        srchtab_dict['ALL_AUTHORS_BOOKS'] = "False"
        srchtab_dict['USE_FINAL_FILTERS'] = "False"
        #~ ----------------------------------------------------------------------------------
        prefs = self.save_settings_parm_history_to_prefs_generic(prefs,current_tab=SEARCHTAB,param_dict=srchtab_dict)
        prefs
        #~ ----------------------------------------------------------------------------------
        del srchtab_dict
    #-----------------------------------------------------------------------------------------------
    def load_criteria_settings_searchtab(self):
        self.load_criteria_settings_generic(SEARCHTAB)
    #-----------------------------------------------------------------------------------------------
    def unpack_selected_parm_searchtab(self, selected_parm, parm_dict):

        n = selected_parm[-1: ]
        if n.isdigit and isinstance(parm_dict,dict):
            n = int(n)
        else:
            if DEBUG: print("parm and/or parm_dict to restore is corrupt; nothing can be done...")
            return False

        saveddate,type,vdict,parm = parm_dict[n]   #for actual restoration of loaded criteria

        if saveddate.startswith("["):  #name is dynamically shown to the user in a combobox item
            n = saveddate.find("]:")
            if n > -1:
                saveddate = saveddate[n+2: ]

        if DEBUG:
            for k, v in iteritems(vdict):
                print(as_unicode(k), " = ", as_unicode(v))

        self.msg1a.setText(vdict['TEXT1'])
        if vdict['TYPE1'] == 'TEXT' :
            self.col1a_radio.setChecked(True)
        if vdict['TYPE1'] == 'LABEL' :
            self.col1b_radio.setChecked(True)

        if vdict['OPERATOR1'] == '=':
            self.radio10.setChecked(True)
        if vdict['OPERATOR1'] == '>':
            self.radio11.setChecked(True)
        if vdict['OPERATOR1'] == '<':
            self.radio12.setChecked(True)
        if vdict['OPERATOR1'] == '>=':
            self.radio13.setChecked(True)
        if vdict['OPERATOR1'] == '<=':
            self.radio14.setChecked(True)
        if vdict['OPERATOR1'] == '!=':
            self.radio16.setChecked(True)
        if vdict['OPERATOR1'] == 'contains':
            self.radio15.setChecked(True)
        if vdict['OPERATOR1'] == 'notcontains':
            self.radio17.setChecked(True)
        if vdict['OPERATOR1'] == 'regex':
            self.radio18.setChecked(True)

        if vdict['TRANSFORM_FUNCTION1'] == COMPARE_AS_IS:
                self.col1_transform_function_combobox.setCurrentIndex(0)
        elif vdict['TRANSFORM_FUNCTION1'] == COMPARE_UPPER_CASE:
                self.col1_transform_function_combobox.setCurrentIndex(1)
        elif vdict['TRANSFORM_FUNCTION1'] == COMPARE_NO_SPACES_NO_PUNCTUATION:
                self.col1_transform_function_combobox.setCurrentIndex(2)
        elif vdict['TRANSFORM_FUNCTION1'] == COMPARE_UPPER_CASE_NO_SPACES_NO_PUNCTUATION:
                self.col1_transform_function_combobox.setCurrentIndex(3)
        elif vdict['TRANSFORM_FUNCTION1'] == COMPARE_DECOMPOSED_NORMALIZED_ALPHABET:
                self.col1_transform_function_combobox.setCurrentIndex(4)

        if vdict['FUZZYWUZZY1'] == FUZZYWUZZY_NONE:
                self.col1_fuzzywuzzy_function_combobox.setCurrentIndex(0)
        elif vdict['FUZZYWUZZY1'] == FUZZYWUZZY_TOKEN_SORT_RATIO:
                self.col1_fuzzywuzzy_function_combobox.setCurrentIndex(1)
        elif vdict['FUZZYWUZZY1'] == FUZZYWUZZY_TOKEN_SET_RATIO:
                self.col1_fuzzywuzzy_function_combobox.setCurrentIndex(2)
        elif vdict['FUZZYWUZZY1'] == FUZZYWUZZY_SIMPLE_RATIO_UPPER_CASE_NO_PUNCTUATION:
                self.col1_fuzzywuzzy_function_combobox.setCurrentIndex(3)
        elif vdict['FUZZYWUZZY1'] == FUZZYWUZZY_SIMPLE_RATIO_DECOMPOSED_NORMALIZED_ALPHABET:
                self.col1_fuzzywuzzy_function_combobox.setCurrentIndex(4)
        elif vdict['FUZZYWUZZY1'] == FUZZY_DOUBLEMETAPHONE_SIMPLE:
                self.col1_fuzzywuzzy_function_combobox.setCurrentIndex(5)

        if vdict['ALL_AUTHORS_BOOKS'] == "True":
            self.activate_all_author_books_checkbox.setChecked(True)
        else:
            self.activate_all_author_books_checkbox.setChecked(False)

        if vdict['USE_FINAL_FILTERS'] == "True":
            self.add_final_filters_checkbox.setChecked(True)
        else:
            self.add_final_filters_checkbox.setChecked(False)

        self.ignore_radio.setChecked(True)
        if vdict['ANDORNOT'] == 'AND' :
            self.and_radio.setChecked(True)
        if vdict['ANDORNOT'] == 'OR' :
            self.or_radio.setChecked(True)
        if vdict['ANDORNOT'] == 'NOT' :
            self.not_radio.setChecked(True)
        if vdict['ANDORNOT'] == 'IGNORE' :
            self.ignore_radio.setChecked(True)

        self.msg2.setText(vdict['NAME2'])
        self.msg2a.setText(vdict['TEXT2'])
        if vdict['TYPE2'] == 'TEXT' :
            self.col2a_radio.setChecked(True)
        if vdict['TYPE2'] == 'LABEL' :
            self.col2b_radio.setChecked(True)

        if vdict['OPERATOR2'] == '=':
            self.radio20.setChecked(True)
        if vdict['OPERATOR2'] == '>':
            self.radio21.setChecked(True)
        if vdict['OPERATOR2'] == '<':
            self.radio22.setChecked(True)
        if vdict['OPERATOR2'] == '>=':
            self.radio23.setChecked(True)
        if vdict['OPERATOR2'] == '<=':
            self.radio24.setChecked(True)
        if vdict['OPERATOR2'] == '!=':
            self.radio26.setChecked(True)
        if vdict['OPERATOR2'] == 'contains':
            self.radio25.setChecked(True)
        if vdict['OPERATOR2'] == 'notcontains':
            self.radio27.setChecked(True)
        if vdict['OPERATOR2'] == 'regex':
            self.radio28.setChecked(True)

        if vdict['TRANSFORM_FUNCTION2'] == COMPARE_AS_IS:
                self.col2_transform_function_combobox.setCurrentIndex(0)
        elif  vdict['TRANSFORM_FUNCTION2'] == COMPARE_UPPER_CASE:
                self.col2_transform_function_combobox.setCurrentIndex(1)
        elif vdict['TRANSFORM_FUNCTION2'] == COMPARE_NO_SPACES_NO_PUNCTUATION:
                self.col2_transform_function_combobox.setCurrentIndex(2)
        elif vdict['TRANSFORM_FUNCTION2'] == COMPARE_UPPER_CASE_NO_SPACES_NO_PUNCTUATION:
                self.col2_transform_function_combobox.setCurrentIndex(3)
        elif vdict['TRANSFORM_FUNCTION2'] == COMPARE_DECOMPOSED_NORMALIZED_ALPHABET:
                self.col2_transform_function_combobox.setCurrentIndex(4)

        if vdict['FUZZYWUZZY2'] == FUZZYWUZZY_NONE:
                self.col2_fuzzywuzzy_function_combobox.setCurrentIndex(0)
        elif vdict['FUZZYWUZZY2'] == FUZZYWUZZY_TOKEN_SORT_RATIO:
                self.col2_fuzzywuzzy_function_combobox.setCurrentIndex(1)
        elif vdict['FUZZYWUZZY2'] == FUZZYWUZZY_TOKEN_SET_RATIO:
                self.col2_fuzzywuzzy_function_combobox.setCurrentIndex(2)
        elif vdict['FUZZYWUZZY2'] == FUZZYWUZZY_SIMPLE_RATIO_UPPER_CASE_NO_PUNCTUATION:
                self.col2_fuzzywuzzy_function_combobox.setCurrentIndex(3)
        elif vdict['FUZZYWUZZY2'] == FUZZYWUZZY_SIMPLE_RATIO_DECOMPOSED_NORMALIZED_ALPHABET:
                self.col2_fuzzywuzzy_function_combobox.setCurrentIndex(4)
        elif vdict['FUZZYWUZZY2'] == FUZZY_DOUBLEMETAPHONE_SIMPLE:
                self.col2_fuzzywuzzy_function_combobox.setCurrentIndex(5)

        if vdict['CROSS_LIBRARY_DUPLICATES_SEARCH'] == "True":
            self.cross_library_duplicates_search_checkbox.setChecked(True)
            self.activate_cross_library_duplicates_search()
            self.col1_transform_function_combobox.setCurrentIndex(0)
            self.col2_transform_function_combobox.setCurrentIndex(0)

        if vdict['INTER_BOOK_SEARCH'] == "True":
            self.activate_interbook_search_checkbox.setChecked(True)
            self.col1_fuzzywuzzy_function_combobox.setCurrentIndex(0)
            self.col2_fuzzywuzzy_function_combobox.setCurrentIndex(0)
        else:
            self.activate_interbook_search_checkbox.setChecked(False)

        if vdict['OPERATOR1'] != "=":
            self.col1_fuzzywuzzy_function_combobox.setCurrentIndex(0)
        if vdict['OPERATOR2'] != "=":
            self.col2_fuzzywuzzy_function_combobox.setCurrentIndex(0)

        self.update()

        if DEBUG: print("*** All SearchTab widgets have been reset per loaded criteria selected by user ***")

        return True
    #-----------------------------------------------------------------------------------------------
    def validate(self):
        return True
    #-----------------------------------------------------------------------------------------------
    def validate_param_dict(self):

        global standard_fields_list
        global interbook_search_standard_fields_list
        global param_dict
        global prefs

        force_repaint = False
        force_abort = False

        #~ for k,v in iteritems(param_dict):
            #~ if DEBUG: print(k,as_unicode(v))

        if (param_dict['NAME1'].count("#") > 0 or param_dict['NAME1'] in standard_fields_list) \
            and param_dict['NAME1'] != "":
            pass
        else:
            param_dict['NAME1'] = "ERROR: UNSUPPORTED COLUMN NAME"
            force_repaint = True
            force_abort = True

        if (param_dict['NAME2'].count("#") > 0 or param_dict['NAME2'] in standard_fields_list) \
            and param_dict['NAME2'] != "":
            pass
        else:
            param_dict['NAME2'] = "ERROR: UNSUPPORTED COLUMN NAME"
            force_repaint = True
            force_abort = True

        if (param_dict['TEXT1'].count("#") > 0 or param_dict['TEXT1'] in standard_fields_list) \
            and param_dict['TEXT1'] != "":
            if param_dict['TYPE1'] != "LABEL":
                param_dict['TYPE1'] = "LABEL"
                force_repaint = True
        else:
            if param_dict['TYPE1'] == "LABEL":
                if not ((param_dict['TEXT1'].count("#") > 0) or (param_dict['TEXT1'] in standard_fields_list)):
                    param_dict['TEXT1'] = "ERROR: UNSUPPORTED COLUMN NAME"
                    force_repaint = True
                    force_abort = True

        if (param_dict['TEXT2'].count("#") > 0 or param_dict['TEXT2'] in standard_fields_list) \
            and param_dict['TEXT2'] != "":
            if param_dict['TYPE2'] != "LABEL":
                param_dict['TYPE2'] = "LABEL"
                force_repaint = True
        else:
            if param_dict['TYPE2'] == "LABEL":
                if not ((param_dict['TEXT2'].count("#") > 0) or (param_dict['TEXT2'] in standard_fields_list)):
                    param_dict['TEXT2'] = "ERROR: UNSUPPORTED COLUMN NAME"
                    force_repaint = True
                    force_abort = True


        if self.activate_interbook_search_checkbox.isChecked():     # Only 3 of 8 Standard Columns Supported for Inter-Book Searches:  Title, Authors, Series.  Other 5 make no sense to use.
            if (param_dict['NAME1'].count("#") > 0 or param_dict['NAME1'] in interbook_search_standard_fields_list) \
                and param_dict['NAME1'] != "":
                pass
            else:
                param_dict['NAME1'] = "ERROR: UNSUPPORTED COLUMN NAME -- INTER-BOOK SEARCH"
                force_repaint = True
                force_abort = True
            if (param_dict['NAME2'].count("#") > 0 or param_dict['NAME2'] in interbook_search_standard_fields_list) \
                and param_dict['NAME2'] != "":
                pass
            else:
                param_dict['NAME2'] = "ERROR: UNSUPPORTED COLUMN NAME -- INTER-BOOK SEARCH"
                force_repaint = True
                force_abort = True

        if self.cross_library_duplicates_search_checkbox.isChecked():
            if param_dict['TYPE1'] != "LABEL":
                param_dict['TEXT1'] = "ERROR: INVALID FOR CROSS-LIBRARY DUPLICATES"
                force_repaint = True
                force_abort = True
            if param_dict['TYPE2'] != "LABEL":
                param_dict['TEXT2'] = "ERROR: INVALID FOR CROSS-LIBRARY DUPLICATES"
                force_repaint = True
                force_abort = True
                if param_dict['TEXT1'] != param_dict['NAME1']:
                    param_dict['TEXT1'] = param_dict['NAME1']
                if param_dict['TEXT2'] != param_dict['NAME2']:
                    param_dict['TEXT2'] = param_dict['NAME2']

        if force_repaint:
            prefs['NAME1'] = as_unicode(param_dict['NAME1'])
            prefs['TEXT1'] = as_unicode(param_dict['TEXT1'])
            prefs['TYPE1'] = as_unicode(param_dict['TYPE1'])
            prefs['OPERATOR1'] = as_unicode(param_dict['OPERATOR1'])
            prefs['REGEX1'] = as_unicode(param_dict['REGEX1'])
            prefs['TRANSFORM_FUNCTION1'] = as_unicode(param_dict['TRANSFORM_FUNCTION1'])
            prefs['FUZZYWUZZY1'] = as_unicode(param_dict['FUZZYWUZZY1'])

            prefs['ANDORNOT'] = as_unicode(param_dict['ANDORNOT'])

            prefs['NAME2'] = as_unicode(param_dict['NAME2'])
            prefs['TEXT2'] = as_unicode(param_dict['TEXT2'])
            prefs['TYPE2'] = as_unicode(param_dict['TYPE2'])
            prefs['OPERATOR2'] = as_unicode(param_dict['OPERATOR2'])
            prefs['REGEX2'] = as_unicode(param_dict['REGEX2'])
            prefs['TRANSFORM_FUNCTION2'] = as_unicode(param_dict['TRANSFORM_FUNCTION2'])
            prefs['FUZZYWUZZY2'] = as_unicode(param_dict['FUZZYWUZZY2'])

            prefs

        return force_repaint,force_abort
#--------------------------------------------------------------------------------------------------
#--------------------------------------------------------------------------------------------------
#--------------------------------------------------------------------------------------------------
#--------------------------------------------------------------------------------------------------
class MCSRegexTab(QWidget):
    # a.k.a. "Regular Expressions"
    prefs = None
    #-----------------------------------------------------------------------------------------------
    def __init__(self,gui,icon,mcsprefs,load_criteria_settings_generic, create_criteria_parm_list_generic,save_settings_parm_history_to_prefs_generic,unpack_selected_parm_generic):
        super(MCSRegexTab, self).__init__()

        self.gui = gui
        global prefs
        prefs = mcsprefs

        self.load_criteria_settings_generic = load_criteria_settings_generic
        self.create_criteria_parm_list_generic = create_criteria_parm_list_generic
        self.save_settings_parm_history_to_prefs_generic = save_settings_parm_history_to_prefs_generic
        self.unpack_selected_parm_generic = unpack_selected_parm_generic

       #-----------------------------------------------------
        font = QFont()
        font.setBold(False)
        font.setPointSize(8)
       #-----------------------------------------------------
        self.layout_frame = QGridLayout()
        self.layout_frame.setSpacing(0)
        self.layout_frame.setContentsMargins(QMargins(0,0,0,0));
        self.setLayout(self.layout_frame)
        #-----------------------------------------------------
        #-----------------------------------------------------
        self.setToolTip("<p style='white-space:wrap'>This Tab is used to select specific Regular Expressions to be used for 'Column 1' and 'Column 2' in the 'Intra/Inter Book' Search Tab.")
        #-----------------------------------------------------
        self.regex_col1_0 = QRadioButton('1:')
        self.regex_col1_1 = QRadioButton('2:')
        self.regex_col1_2 = QRadioButton('3:')
        self.regex_col1_3 = QRadioButton('4:')
        self.regex_col1_4 = QRadioButton('5:')
        self.regex_col1_5 = QRadioButton('6:')
        self.regex_col1_6 = QRadioButton('7:')
        self.regex_col1_7 = QRadioButton('8:')
        self.regex_col1_8 = QRadioButton('9:')
        self.regex_col1_9 = QRadioButton('10')

        self.layout_frame.addWidget(self.regex_col1_0,0,0)
        self.layout_frame.addWidget(self.regex_col1_1,1,0)
        self.layout_frame.addWidget(self.regex_col1_2,2,0)
        self.layout_frame.addWidget(self.regex_col1_3,3,0)
        self.layout_frame.addWidget(self.regex_col1_4,4,0)
        self.layout_frame.addWidget(self.regex_col1_5,5,0)
        self.layout_frame.addWidget(self.regex_col1_6,6,0)
        self.layout_frame.addWidget(self.regex_col1_7,7,0)
        self.layout_frame.addWidget(self.regex_col1_8,8,0)
        self.layout_frame.addWidget(self.regex_col1_9,9,0)

        self.regex_col1_button_group = QButtonGroup(self.layout_frame)

        self.regex_col1_button_group.addButton(self.regex_col1_0)
        self.regex_col1_button_group.addButton(self.regex_col1_1)
        self.regex_col1_button_group.addButton(self.regex_col1_2)
        self.regex_col1_button_group.addButton(self.regex_col1_3)
        self.regex_col1_button_group.addButton(self.regex_col1_4)
        self.regex_col1_button_group.addButton(self.regex_col1_5)
        self.regex_col1_button_group.addButton(self.regex_col1_6)
        self.regex_col1_button_group.addButton(self.regex_col1_7)
        self.regex_col1_button_group.addButton(self.regex_col1_8)
        self.regex_col1_button_group.addButton(self.regex_col1_9)

        self.regex_col2_0 = QRadioButton('1:')
        self.regex_col2_1 = QRadioButton('2:')
        self.regex_col2_2 = QRadioButton('3:')
        self.regex_col2_3 = QRadioButton('4:')
        self.regex_col2_4 = QRadioButton('5:')
        self.regex_col2_5 = QRadioButton('6:')
        self.regex_col2_6 = QRadioButton('7:')
        self.regex_col2_7 = QRadioButton('8:')
        self.regex_col2_8 = QRadioButton('9:')
        self.regex_col2_9 = QRadioButton('10')

        self.layout_frame.addWidget(self.regex_col2_0,0,1)
        self.layout_frame.addWidget(self.regex_col2_1,1,1)
        self.layout_frame.addWidget(self.regex_col2_2,2,1)
        self.layout_frame.addWidget(self.regex_col2_3,3,1)
        self.layout_frame.addWidget(self.regex_col2_4,4,1)
        self.layout_frame.addWidget(self.regex_col2_5,5,1)
        self.layout_frame.addWidget(self.regex_col2_6,6,1)
        self.layout_frame.addWidget(self.regex_col2_7,7,1)
        self.layout_frame.addWidget(self.regex_col2_8,8,1)
        self.layout_frame.addWidget(self.regex_col2_9,9,1)

        self.regex_col2_button_group = QButtonGroup(self.layout_frame)

        self.regex_col2_button_group.addButton(self.regex_col2_0)
        self.regex_col2_button_group.addButton(self.regex_col2_1)
        self.regex_col2_button_group.addButton(self.regex_col2_2)
        self.regex_col2_button_group.addButton(self.regex_col2_3)
        self.regex_col2_button_group.addButton(self.regex_col2_4)
        self.regex_col2_button_group.addButton(self.regex_col2_5)
        self.regex_col2_button_group.addButton(self.regex_col2_6)
        self.regex_col2_button_group.addButton(self.regex_col2_7)
        self.regex_col2_button_group.addButton(self.regex_col2_8)
        self.regex_col2_button_group.addButton(self.regex_col2_9)

        self.value_0 = QLineEdit(self)
        self.value_1 = QLineEdit(self)
        self.value_2 = QLineEdit(self)
        self.value_3 = QLineEdit(self)
        self.value_4 = QLineEdit(self)
        self.value_5 = QLineEdit(self)
        self.value_6 = QLineEdit(self)
        self.value_7 = QLineEdit(self)
        self.value_8 = QLineEdit(self)
        self.value_9 = QLineEdit(self)

        self.layout_frame.addWidget(self.value_0,0,2)
        self.layout_frame.addWidget(self.value_1,1,2)
        self.layout_frame.addWidget(self.value_2,2,2)
        self.layout_frame.addWidget(self.value_3,3,2)
        self.layout_frame.addWidget(self.value_4,4,2)
        self.layout_frame.addWidget(self.value_5,5,2)
        self.layout_frame.addWidget(self.value_6,6,2)
        self.layout_frame.addWidget(self.value_7,7,2)
        self.layout_frame.addWidget(self.value_8,8,2)
        self.layout_frame.addWidget(self.value_9,9,2)

        self.value_0.setText("^.+$")

        self.ignore_case_checkbox1 = QCheckBox()
        self.ignore_case_checkbox1.setText("")
        self.ignore_case_checkbox1.setToolTip("<p style='white-space:wrap'>Should the Regular Expression be evaluated using the 'Ignore Case' option?")
        self.layout_frame.addWidget(self.ignore_case_checkbox1,11,0)

        self.ignore_case_checkbox2 = QCheckBox()
        self.ignore_case_checkbox2.setText("I.C.?")
        self.ignore_case_checkbox2.setToolTip("<p style='white-space:wrap'>Should the Regular Expression be evaluated using the 'Ignore Case' option?")
        self.layout_frame.addWidget(self.ignore_case_checkbox2,11,1)

        self.push_button_save_regex_values = QPushButton(" ", self)
        self.push_button_save_regex_values.setText("Save Current Regular Expressions")
        self.push_button_save_regex_values.setToolTip("<p style='white-space:wrap'>Save (with a name) all criteria for this Tab.")
        self.push_button_save_regex_values.setMinimumWidth(200)
        self.push_button_save_regex_values.setMaximumWidth(600)
        self.push_button_save_regex_values.clicked.connect(self.save_regex_values)
        self.layout_frame.addWidget(self.push_button_save_regex_values,11,2)

        self.push_button_load_regex_values = QPushButton(" ", self)
        self.push_button_load_regex_values.setText("Load Previously Saved Criteria?")
        self.push_button_load_regex_values.setToolTip("<p style='white-space:wrap'>Select a previously saved (with a name) set of criteria for this Tab.")
        self.push_button_load_regex_values.setMinimumWidth(200)
        self.push_button_load_regex_values.setMaximumWidth(600)
        self.push_button_load_regex_values.clicked.connect(self.load_criteria_settings_regextab)
        self.layout_frame.addWidget(self.push_button_load_regex_values,12,2)

        self.resize(self.sizeHint())

        self.load_saved_regex_values(source=prefs)
    #-----------------------------------------------------------------------------------------------
    def load_criteria_settings_regextab(self):
        self.load_criteria_settings_generic(current_tab=REGEXTAB)
    #-----------------------------------------------------------------------------------------------
    def load_saved_regex_values(self,source=None):

        if source is None:
            return

        self.value_0.setText(source['REGEXVALUE_0'])
        self.value_1.setText(source['REGEXVALUE_1'])
        self.value_2.setText(source['REGEXVALUE_2'])
        self.value_3.setText(source['REGEXVALUE_3'])
        self.value_4.setText(source['REGEXVALUE_4'])
        self.value_5.setText(source['REGEXVALUE_5'])
        self.value_6.setText(source['REGEXVALUE_6'])
        self.value_7.setText(source['REGEXVALUE_7'])
        self.value_8.setText(source['REGEXVALUE_8'])
        self.value_9.setText(source['REGEXVALUE_9'])

        self.regex_col1_0.setChecked(False)
        self.regex_col1_1.setChecked(False)
        self.regex_col1_2.setChecked(False)
        self.regex_col1_3.setChecked(False)
        self.regex_col1_4.setChecked(False)
        self.regex_col1_5.setChecked(False)
        self.regex_col1_6.setChecked(False)
        self.regex_col1_7.setChecked(False)
        self.regex_col1_8.setChecked(False)
        self.regex_col1_9.setChecked(False)

        true_false0 = as_unicode(source['REGEX_RADIO_COL1_0'])
        true_false1 = as_unicode(source['REGEX_RADIO_COL1_1'])
        true_false2 = as_unicode(source['REGEX_RADIO_COL1_2'])
        true_false3 = as_unicode(source['REGEX_RADIO_COL1_3'])
        true_false4 = as_unicode(source['REGEX_RADIO_COL1_4'])
        true_false5 = as_unicode(source['REGEX_RADIO_COL1_5'])
        true_false6 = as_unicode(source['REGEX_RADIO_COL1_6'])
        true_false7 = as_unicode(source['REGEX_RADIO_COL1_7'])
        true_false8 = as_unicode(source['REGEX_RADIO_COL1_8'])
        true_false9 = as_unicode(source['REGEX_RADIO_COL1_9'])

        if true_false0 == "True":
            self.regex_col1_0.setChecked(True)
        if true_false1 == "True":
            self.regex_col1_1.setChecked(True)
        if true_false2 == "True":
            self.regex_col1_2.setChecked(True)
        if true_false3 == "True":
            self.regex_col1_3.setChecked(True)
        if true_false4 == "True":
            self.regex_col1_4.setChecked(True)
        if true_false5 == "True":
            self.regex_col1_5.setChecked(True)
        if true_false6 == "True":
            self.regex_col1_6.setChecked(True)
        if true_false7 == "True":
            self.regex_col1_7.setChecked(True)
        if true_false8 == "True":
            self.regex_col1_8.setChecked(True)
        if true_false9 == "True":
            self.regex_col1_9.setChecked(True)

        self.regex_col2_0.setChecked(False)
        self.regex_col2_1.setChecked(False)
        self.regex_col2_2.setChecked(False)
        self.regex_col2_3.setChecked(False)
        self.regex_col2_4.setChecked(False)
        self.regex_col2_5.setChecked(False)
        self.regex_col2_6.setChecked(False)
        self.regex_col2_7.setChecked(False)
        self.regex_col2_8.setChecked(False)
        self.regex_col2_9.setChecked(False)

        true_false0 = as_unicode(source['REGEX_RADIO_COL2_0'])
        true_false1 = as_unicode(source['REGEX_RADIO_COL2_1'])
        true_false2 = as_unicode(source['REGEX_RADIO_COL2_2'])
        true_false3 = as_unicode(source['REGEX_RADIO_COL2_3'])
        true_false4 = as_unicode(source['REGEX_RADIO_COL2_4'])
        true_false5 = as_unicode(source['REGEX_RADIO_COL2_5'])
        true_false6 = as_unicode(source['REGEX_RADIO_COL2_6'])
        true_false7 = as_unicode(source['REGEX_RADIO_COL2_7'])
        true_false8 = as_unicode(source['REGEX_RADIO_COL2_8'])
        true_false9 = as_unicode(source['REGEX_RADIO_COL2_9'])

        if true_false0 == "True":
            self.regex_col2_0.setChecked(True)
        if true_false1 == "True":
            self.regex_col2_1.setChecked(True)
        if true_false2 == "True":
            self.regex_col2_2.setChecked(True)
        if true_false3 == "True":
            self.regex_col2_3.setChecked(True)
        if true_false4 == "True":
            self.regex_col2_4.setChecked(True)
        if true_false5 == "True":
            self.regex_col2_5.setChecked(True)
        if true_false6 == "True":
            self.regex_col2_6.setChecked(True)
        if true_false7 == "True":
            self.regex_col2_7.setChecked(True)
        if true_false8 == "True":
            self.regex_col2_8.setChecked(True)
        if true_false9 == "True":
            self.regex_col2_9.setChecked(True)

        self.ignore_case_checkbox1.setChecked(False)
        true_false = source['REGEX_IGNORECASE_1']
        if as_unicode(true_false) == "True":
            self.ignore_case_checkbox1.setChecked(True)

        self.ignore_case_checkbox2.setChecked(False)
        true_false = source['REGEX_IGNORECASE_2']
        if as_unicode(true_false) == "True":
            self.ignore_case_checkbox2.setChecked(True)
    #-----------------------------------------------------------------------------------------------
    def save_regex_values(self):

        global prefs

        prefs['REGEXVALUE_0'] = as_unicode(self.value_0.text())
        prefs['REGEXVALUE_1'] = as_unicode(self.value_1.text())
        prefs['REGEXVALUE_2'] = as_unicode(self.value_2.text())
        prefs['REGEXVALUE_3'] = as_unicode(self.value_3.text())
        prefs['REGEXVALUE_4'] = as_unicode(self.value_4.text())
        prefs['REGEXVALUE_5'] = as_unicode(self.value_5.text())
        prefs['REGEXVALUE_6'] = as_unicode(self.value_6.text())
        prefs['REGEXVALUE_7'] = as_unicode(self.value_7.text())
        prefs['REGEXVALUE_8'] = as_unicode(self.value_8.text())
        prefs['REGEXVALUE_9'] = as_unicode(self.value_9.text())

        prefs['REGEX_RADIO_COL1_0'] = as_unicode(self.regex_col1_0.isChecked())
        prefs['REGEX_RADIO_COL1_1'] = as_unicode(self.regex_col1_1.isChecked())
        prefs['REGEX_RADIO_COL1_2'] = as_unicode(self.regex_col1_2.isChecked())
        prefs['REGEX_RADIO_COL1_3'] = as_unicode(self.regex_col1_3.isChecked())
        prefs['REGEX_RADIO_COL1_4'] = as_unicode(self.regex_col1_4.isChecked())
        prefs['REGEX_RADIO_COL1_5'] = as_unicode(self.regex_col1_5.isChecked())
        prefs['REGEX_RADIO_COL1_6'] = as_unicode(self.regex_col1_6.isChecked())
        prefs['REGEX_RADIO_COL1_7'] = as_unicode(self.regex_col1_7.isChecked())
        prefs['REGEX_RADIO_COL1_8'] = as_unicode(self.regex_col1_8.isChecked())
        prefs['REGEX_RADIO_COL1_9'] = as_unicode(self.regex_col1_9.isChecked())

        prefs['REGEX_RADIO_COL2_0'] = as_unicode(self.regex_col2_0.isChecked())
        prefs['REGEX_RADIO_COL2_1'] = as_unicode(self.regex_col2_1.isChecked())
        prefs['REGEX_RADIO_COL2_2'] = as_unicode(self.regex_col2_2.isChecked())
        prefs['REGEX_RADIO_COL2_3'] = as_unicode(self.regex_col2_3.isChecked())
        prefs['REGEX_RADIO_COL2_4'] = as_unicode(self.regex_col2_4.isChecked())
        prefs['REGEX_RADIO_COL2_5'] = as_unicode(self.regex_col2_5.isChecked())
        prefs['REGEX_RADIO_COL2_6'] = as_unicode(self.regex_col2_6.isChecked())
        prefs['REGEX_RADIO_COL2_7'] = as_unicode(self.regex_col2_7.isChecked())
        prefs['REGEX_RADIO_COL2_8'] = as_unicode(self.regex_col2_8.isChecked())
        prefs['REGEX_RADIO_COL2_9'] = as_unicode(self.regex_col2_9.isChecked())

        prefs['REGEX_IGNORECASE_1'] = as_unicode(self.ignore_case_checkbox1.isChecked())
        prefs['REGEX_IGNORECASE_2'] = as_unicode(self.ignore_case_checkbox2.isChecked())

        prefs['REGEX1'],prefs['REGEX1#'] = self.determine_selected_regex(1)
        prefs['REGEX2'],prefs['REGEX2#'] = self.determine_selected_regex(2)

        prefs

        global param_dict

        param_dict['REGEX1'],param_dict['REGEX1#'] = self.determine_selected_regex(1)
        param_dict['REGEX2'],param_dict['REGEX2#'] = self.determine_selected_regex(2)

        param_dict['PARAM_DICT_LAST_SAVED_TO_PREFS_FROM_TAB'] = REGEXTAB

        regex_dict = {}
        for k,v in iteritems(prefs):
            if k.startswith("REGEX"):
                regex_dict[k] = v
                if DEBUG: print(k)
        #END FOR

        regex_dict[REGULAR_EXPRESSIONS_TYPE] = REGULAR_EXPRESSIONS_TYPE  # used by 'def prefs_history_avoid_duplicates' to verify flavor/source of param_dict...
        prefs = self.save_settings_parm_history_to_prefs_generic(prefs,current_tab=REGEXTAB,param_dict=regex_dict)
        prefs

        del regex_dict
    #-----------------------------------------------------------------------------------------------
    def validate(self):
        return True
    #-----------------------------------------------------------------------------------------------
    def determine_selected_regex(self,column):

        regex = "^.+$"
        n = 0

        if column == 1:
            if self.regex_col1_0.isChecked():
                regex = as_unicode(self.value_0.text())
                n = 0
            if self.regex_col1_1.isChecked():
                regex = as_unicode(self.value_1.text())
                n = 1
            if self.regex_col1_2.isChecked():
                regex = as_unicode(self.value_2.text())
                n = 2
            if self.regex_col1_3.isChecked():
                regex = as_unicode(self.value_3.text())
                n = 3
            if self.regex_col1_4.isChecked():
                regex = as_unicode(self.value_4.text())
                n = 4
            if self.regex_col1_5.isChecked():
                regex = as_unicode(self.value_5.text())
                n = 5
            if self.regex_col1_6.isChecked():
                regex = as_unicode(self.value_6.text())
                n = 6
            if self.regex_col1_7.isChecked():
                regex = as_unicode(self.value_7.text())
                n = 7
            if self.regex_col1_8.isChecked():
                regex = as_unicode(self.value_8.text())
                n = 8
            if self.regex_col1_9.isChecked():
                regex = as_unicode(self.value_9.text())
                n = 9
        else:
            if self.regex_col2_0.isChecked():
                regex = as_unicode(self.value_0.text())
                n = 0
            if self.regex_col2_1.isChecked():
                regex = as_unicode(self.value_1.text())
                n = 1
            if self.regex_col2_2.isChecked():
                regex = as_unicode(self.value_2.text())
                n = 2
            if self.regex_col2_3.isChecked():
                regex = as_unicode(self.value_3.text())
                n = 3
            if self.regex_col2_4.isChecked():
                regex = as_unicode(self.value_4.text())
                n = 4
            if self.regex_col2_5.isChecked():
                regex = as_unicode(self.value_5.text())
                n = 5
            if self.regex_col2_6.isChecked():
                regex = as_unicode(self.value_6.text())
                n = 6
            if self.regex_col2_7.isChecked():
                regex = as_unicode(self.value_7.text())
                n = 7
            if self.regex_col2_8.isChecked():
                regex = as_unicode(self.value_8.text())
                n = 8
            if self.regex_col2_9.isChecked():
                regex = as_unicode(self.value_9.text())
                n = 9

        regex = as_unicode(regex)
        n = as_unicode(n)

        return regex,n
    #-----------------------------------------------------------------------------------------------
    def unpack_selected_parm_regextab(self,selected_parm,parm_dict):

        n = selected_parm[-1: ]
        if n.isdigit and isinstance(parm_dict,dict):
            n = int(n)
        else:
            if DEBUG: print("RegexTab: parm and/or parm_dict to restore is corrupt; nothing can be done...")
            return False

        saveddate,type,vdict,parm = parm_dict[n]   #for actual restoration of loaded criteria

        if saveddate.startswith("["):  #name is dynamically shown to the user in a combobox item
            n = saveddate.find("]:")
            if n > -1:
                saveddate = saveddate[n+2: ]

        if DEBUG:
            for k, v in iteritems(vdict):
                print(as_unicode(k), " = ", as_unicode(v))

        self.load_saved_regex_values(source=vdict)

        self.update()

        if DEBUG: print("*** All RegexTab widgets have been reset per loaded criteria selected by user ***")

        return True
#--------------------------------------------------------------------------------------------------
#--------------------------------------------------------------------------------------------------
#--------------------------------------------------------------------------------------------------
#--------------------------------------------------------------------------------------------------
class MCSFinalFilterTab(QWidget):
    # a.k.a. "Final Filters"
    prefs = None
    #-----------------------------------------------------------------------------------------------
    def __init__(self,gui,icon,guidb,mcsprefs,current_library_path,
                        custom_column_label_dict,custom_column_datatype_dict,custom_column_normalized_dict,
                        load_criteria_settings_generic,create_criteria_parm_list_generic,save_settings_parm_history_to_prefs_generic,unpack_selected_parm_generic):
        super(MCSFinalFilterTab, self).__init__()

        self.gui = gui
        self.icon = icon
        self.guidb = guidb

        global prefs
        prefs = mcsprefs

        self.current_library_path = current_library_path
        self.custom_column_label_dict = custom_column_label_dict
        self.custom_column_datatype_dict = custom_column_datatype_dict
        self.custom_column_normalized_dict = custom_column_normalized_dict
        self.load_criteria_settings_generic = load_criteria_settings_generic
        self.create_criteria_parm_list_generic = create_criteria_parm_list_generic
        self.save_settings_parm_history_to_prefs_generic = save_settings_parm_history_to_prefs_generic
        self.unpack_selected_parm_generic = unpack_selected_parm_generic
        #-----------------------------------------------------
        #-----------------------------------------------------
        #-----------------------------------------------------
        #-----------------------------------------------------
        font = QFont()
        font.setBold(False)
        font.setPointSize(8)
        #-----------------------------------------------------
        self.layout_frame = QGridLayout()
        self.layout_frame.setSpacing(0)
        self.layout_frame.setContentsMargins(QMargins(0,0,0,0));
        self.setLayout(self.layout_frame)
        self.setToolTip("<p style='white-space:wrap'>This Tab is used to define and select specific filters to be optionally applied at the very end of a search query after the search defined in the various Query Tabs has otherwise been executed and completed.")
        #-----------------------------------------------------
        #-----------------------------------------------------

        self.checkbox_filter_0 = QCheckBox('1:')
        self.checkbox_filter_1 = QCheckBox('2:')
        self.checkbox_filter_2 = QCheckBox('3:')
        self.checkbox_filter_3 = QCheckBox('4:')
        self.checkbox_filter_4 = QCheckBox('5:')
        self.checkbox_filter_5 = QCheckBox('6:')
        self.checkbox_filter_6 = QCheckBox('7:')
        self.checkbox_filter_7 = QCheckBox('8:')
        self.checkbox_filter_8 = QCheckBox('9:')
        self.checkbox_filter_9 = QCheckBox('10')

        self.checkbox_filter_0.setMaximumWidth(50)
        self.checkbox_filter_1.setMaximumWidth(50)
        self.checkbox_filter_2.setMaximumWidth(50)
        self.checkbox_filter_3.setMaximumWidth(50)
        self.checkbox_filter_4.setMaximumWidth(50)
        self.checkbox_filter_5.setMaximumWidth(50)
        self.checkbox_filter_6.setMaximumWidth(50)
        self.checkbox_filter_7.setMaximumWidth(50)
        self.checkbox_filter_8.setMaximumWidth(50)
        self.checkbox_filter_9.setMaximumWidth(50)

        self.layout_frame.addWidget(self.checkbox_filter_0,0,0)
        self.layout_frame.addWidget(self.checkbox_filter_1,1,0)
        self.layout_frame.addWidget(self.checkbox_filter_2,2,0)
        self.layout_frame.addWidget(self.checkbox_filter_3,3,0)
        self.layout_frame.addWidget(self.checkbox_filter_4,4,0)
        self.layout_frame.addWidget(self.checkbox_filter_5,5,0)
        self.layout_frame.addWidget(self.checkbox_filter_6,6,0)
        self.layout_frame.addWidget(self.checkbox_filter_7,7,0)
        self.layout_frame.addWidget(self.checkbox_filter_8,8,0)
        self.layout_frame.addWidget(self.checkbox_filter_9,9,0)

        self.checkbox_tooltip = "<p style='white-space:wrap'>Activate this specific filter for use whenever Final Filters are being used?"
        self.checkbox_filter_0.setToolTip(self.checkbox_tooltip)
        self.checkbox_filter_1.setToolTip(self.checkbox_tooltip)
        self.checkbox_filter_2.setToolTip(self.checkbox_tooltip)
        self.checkbox_filter_3.setToolTip(self.checkbox_tooltip)
        self.checkbox_filter_4.setToolTip(self.checkbox_tooltip)
        self.checkbox_filter_5.setToolTip(self.checkbox_tooltip)
        self.checkbox_filter_6.setToolTip(self.checkbox_tooltip)
        self.checkbox_filter_7.setToolTip(self.checkbox_tooltip)
        self.checkbox_filter_8.setToolTip(self.checkbox_tooltip)
        self.checkbox_filter_9.setToolTip(self.checkbox_tooltip)

        #-----------------------------------------------------
        self.table_0_combobox = QComboBox()
        self.table_0_combobox.setEditable(False)
        self.table_0_combobox.setFont(font)
        self.table_0_combobox.setMaximumWidth(230)
        self.layout_frame.addWidget(self.table_0_combobox,0,1)

        self.table_1_combobox = QComboBox()
        self.table_1_combobox.setEditable(False)
        self.table_1_combobox.setFont(font)
        self.table_1_combobox.setMaximumWidth(230)
        self.layout_frame.addWidget(self.table_1_combobox,1,1)

        self.table_2_combobox = QComboBox()
        self.table_2_combobox.setEditable(False)
        self.table_2_combobox.setFont(font)
        self.table_2_combobox.setMaximumWidth(230)
        self.layout_frame.addWidget(self.table_2_combobox,2,1)

        self.table_3_combobox = QComboBox()
        self.table_3_combobox.setEditable(False)
        self.table_3_combobox.setFont(font)
        self.table_3_combobox.setMaximumWidth(230)
        self.layout_frame.addWidget(self.table_3_combobox,3,1)

        self.table_4_combobox = QComboBox()
        self.table_4_combobox.setEditable(False)
        self.table_4_combobox.setFont(font)
        self.table_4_combobox.setMaximumWidth(230)
        self.layout_frame.addWidget(self.table_4_combobox,4,1)

        self.table_5_combobox = QComboBox()
        self.table_5_combobox.setEditable(False)
        self.table_5_combobox.setFont(font)
        self.table_5_combobox.setMaximumWidth(230)
        self.layout_frame.addWidget(self.table_5_combobox,5,1)

        self.table_6_combobox = QComboBox()
        self.table_6_combobox.setEditable(False)
        self.table_6_combobox.setFont(font)
        self.table_6_combobox.setMaximumWidth(230)
        self.layout_frame.addWidget(self.table_6_combobox,6,1)

        self.table_7_combobox = QComboBox()
        self.table_7_combobox.setEditable(False)
        self.table_7_combobox.setFont(font)
        self.table_7_combobox.setMaximumWidth(230)
        self.layout_frame.addWidget(self.table_7_combobox,7,1)

        self.table_8_combobox = QComboBox()
        self.table_8_combobox.setEditable(False)
        self.table_8_combobox.setFont(font)
        self.table_8_combobox.setMaximumWidth(230)
        self.layout_frame.addWidget(self.table_8_combobox,8,1)

        self.table_9_combobox = QComboBox()
        self.table_9_combobox.setEditable(False)
        self.table_9_combobox.setFont(font)
        self.table_9_combobox.setMaximumWidth(230)
        self.layout_frame.addWidget(self.table_9_combobox,9,1)

        self.checkbox_filter_tables_list = []
        self.checkbox_filter_tables_list.append('authors: name')
        self.checkbox_filter_tables_list.append('authors: sort')
        self.checkbox_filter_tables_list.append('books: title')
        self.checkbox_filter_tables_list.append('books: pubdate')
        self.checkbox_filter_tables_list.append('books: path')
        self.checkbox_filter_tables_list.append('books: has_cover')
        self.checkbox_filter_tables_list.append('books: series_index')
        self.checkbox_filter_tables_list.append('publishers: name')
        self.checkbox_filter_tables_list.append('series: name')
        self.checkbox_filter_tables_list.append('tags: name')
        self.checkbox_filter_tables_list.append('comments: text')
        self.checkbox_filter_tables_list.append('identifiers: type')
        self.checkbox_filter_tables_list.append('data: format')

        self.tables_item_index_dict = {}

        try:
            i = -1
            for table in self.checkbox_filter_tables_list:
                i = i + 1
                table = as_unicode(table)
                self.tables_item_index_dict[table] = i
                self.table_0_combobox.addItem(table)
                self.table_1_combobox.addItem(table)
                self.table_2_combobox.addItem(table)
                self.table_3_combobox.addItem(table)
                self.table_4_combobox.addItem(table)
                self.table_5_combobox.addItem(table)
                self.table_6_combobox.addItem(table)
                self.table_7_combobox.addItem(table)
                self.table_8_combobox.addItem(table)
                self.table_9_combobox.addItem(table)
            #END FOR
        except:
            pass
        del self.checkbox_filter_tables_list
        self.checkbox_filter_labels_list = self.guidb.custom_field_keys(include_composites=True)
        try:
            for row in self.checkbox_filter_labels_list:
                label = "cc: " + row
                label = as_unicode(label)
                i = i + 1
                self.tables_item_index_dict[label] = i
                self.table_0_combobox.addItem(label)
                self.table_1_combobox.addItem(label)
                self.table_2_combobox.addItem(label)
                self.table_3_combobox.addItem(label)
                self.table_4_combobox.addItem(label)
                self.table_5_combobox.addItem(label)
                self.table_6_combobox.addItem(label)
                self.table_7_combobox.addItem(label)
                self.table_8_combobox.addItem(label)
                self.table_9_combobox.addItem(label)
            #END FOR
        except:
            pass
        del self.checkbox_filter_labels_list

        self.table_tooltip = "<p style='white-space:wrap'>Select the Calibre Column for this specific filter.  The choices are specific to this particular Library."
        self.table_0_combobox.setToolTip(self.table_tooltip)
        self.table_1_combobox.setToolTip(self.table_tooltip)
        self.table_2_combobox.setToolTip(self.table_tooltip)
        self.table_3_combobox.setToolTip(self.table_tooltip)
        self.table_4_combobox.setToolTip(self.table_tooltip)
        self.table_5_combobox.setToolTip(self.table_tooltip)
        self.table_6_combobox.setToolTip(self.table_tooltip)
        self.table_7_combobox.setToolTip(self.table_tooltip)
        self.table_8_combobox.setToolTip(self.table_tooltip)
        self.table_9_combobox.setToolTip(self.table_tooltip)

        #-----------------------------------------------------
        #-----------------------------------------------------
        self.isnot_0_combobox = QComboBox()
        self.isnot_0_combobox.setEditable(False)
        self.isnot_0_combobox.setFont(font)
        self.isnot_0_combobox.setMaximumWidth(75)
        self.layout_frame.addWidget(self.isnot_0_combobox,0,2)

        self.isnot_1_combobox = QComboBox()
        self.isnot_1_combobox.setEditable(False)
        self.isnot_1_combobox.setFont(font)
        self.isnot_1_combobox.setMaximumWidth(75)
        self.layout_frame.addWidget(self.isnot_1_combobox,1,2)

        self.isnot_2_combobox = QComboBox()
        self.isnot_2_combobox.setEditable(False)
        self.isnot_2_combobox.setFont(font)
        self.isnot_2_combobox.setMaximumWidth(75)
        self.layout_frame.addWidget(self.isnot_2_combobox,2,2)

        self.isnot_3_combobox = QComboBox()
        self.isnot_3_combobox.setEditable(False)
        self.isnot_3_combobox.setFont(font)
        self.isnot_3_combobox.setMaximumWidth(75)
        self.layout_frame.addWidget(self.isnot_3_combobox,3,2)

        self.isnot_4_combobox = QComboBox()
        self.isnot_4_combobox.setEditable(False)
        self.isnot_4_combobox.setFont(font)
        self.layout_frame.addWidget(self.isnot_4_combobox,4,2)

        self.isnot_5_combobox = QComboBox()
        self.isnot_5_combobox.setEditable(False)
        self.isnot_5_combobox.setFont(font)
        self.isnot_5_combobox.setMaximumWidth(75)
        self.layout_frame.addWidget(self.isnot_5_combobox,5,2)

        self.isnot_6_combobox = QComboBox()
        self.isnot_6_combobox.setEditable(False)
        self.isnot_6_combobox.setFont(font)
        self.isnot_6_combobox.setMaximumWidth(75)
        self.layout_frame.addWidget(self.isnot_6_combobox,6,2)

        self.isnot_7_combobox = QComboBox()
        self.isnot_7_combobox.setEditable(False)
        self.isnot_7_combobox.setFont(font)
        self.isnot_7_combobox.setMaximumWidth(75)
        self.layout_frame.addWidget(self.isnot_7_combobox,7,2)

        self.isnot_8_combobox = QComboBox()
        self.isnot_8_combobox.setEditable(False)
        self.isnot_8_combobox.setFont(font)
        self.isnot_8_combobox.setMaximumWidth(75)
        self.layout_frame.addWidget(self.isnot_8_combobox,8,2)

        self.isnot_9_combobox = QComboBox()
        self.isnot_9_combobox.setEditable(False)
        self.isnot_9_combobox.setFont(font)
        self.isnot_9_combobox.setMaximumWidth(75)
        self.layout_frame.addWidget(self.isnot_9_combobox,9,2)

        self.checkbox_filter_operators_list = []
        self.checkbox_filter_operators_list.append(as_unicode('IS'))
        self.checkbox_filter_operators_list.append(as_unicode('IS NOT'))

        self.isnot_item_index_dict = {}
        self.isnot_item_index_dict[as_unicode('IS')] = 0
        self.isnot_item_index_dict[as_unicode('IS NOT')] = 1

        try:
            for item in self.checkbox_filter_operators_list:
                self.isnot_0_combobox.addItem(item)
                self.isnot_1_combobox.addItem(item)
                self.isnot_2_combobox.addItem(item)
                self.isnot_3_combobox.addItem(item)
                self.isnot_4_combobox.addItem(item)
                self.isnot_5_combobox.addItem(item)
                self.isnot_6_combobox.addItem(item)
                self.isnot_7_combobox.addItem(item)
                self.isnot_8_combobox.addItem(item)
                self.isnot_9_combobox.addItem(item)
            #END FOR
        except Exception as e:
            if DEBUG: print(as_unicode(e))
            pass
        del self.checkbox_filter_operators_list

        self.isnot_tooltip = "<p style='white-space:wrap'>Select the logical 'IS' or 'IS NOT' for this specific filter."
        self.isnot_0_combobox.setToolTip(self.isnot_tooltip)
        self.isnot_1_combobox.setToolTip(self.isnot_tooltip)
        self.isnot_2_combobox.setToolTip(self.isnot_tooltip)
        self.isnot_3_combobox.setToolTip(self.isnot_tooltip)
        self.isnot_4_combobox.setToolTip(self.isnot_tooltip)
        self.isnot_5_combobox.setToolTip(self.isnot_tooltip)
        self.isnot_6_combobox.setToolTip(self.isnot_tooltip)
        self.isnot_7_combobox.setToolTip(self.isnot_tooltip)
        self.isnot_8_combobox.setToolTip(self.isnot_tooltip)
        self.isnot_9_combobox.setToolTip(self.isnot_tooltip)
        #-----------------------------------------------------
        #-----------------------------------------------------
        self.operators_0_combobox = QComboBox()
        self.operators_0_combobox.setEditable(False)
        self.operators_0_combobox.setFont(font)
        self.operators_0_combobox.setMaximumWidth(75)
        self.layout_frame.addWidget(self.operators_0_combobox,0,3)

        self.operators_1_combobox = QComboBox()
        self.operators_1_combobox.setEditable(False)
        self.operators_1_combobox.setFont(font)
        self.operators_1_combobox.setMaximumWidth(75)
        self.layout_frame.addWidget(self.operators_1_combobox,1,3)

        self.operators_2_combobox = QComboBox()
        self.operators_2_combobox.setEditable(False)
        self.operators_2_combobox.setFont(font)
        self.operators_2_combobox.setMaximumWidth(75)
        self.layout_frame.addWidget(self.operators_2_combobox,2,3)

        self.operators_3_combobox = QComboBox()
        self.operators_3_combobox.setEditable(False)
        self.operators_3_combobox.setFont(font)
        self.operators_3_combobox.setMaximumWidth(75)
        self.layout_frame.addWidget(self.operators_3_combobox,3,3)

        self.operators_4_combobox = QComboBox()
        self.operators_4_combobox.setEditable(False)
        self.operators_4_combobox.setFont(font)
        self.operators_4_combobox.setMaximumWidth(75)
        self.layout_frame.addWidget(self.operators_4_combobox,4,3)

        self.operators_5_combobox = QComboBox()
        self.operators_5_combobox.setEditable(False)
        self.operators_5_combobox.setFont(font)
        self.operators_5_combobox.setMaximumWidth(75)
        self.layout_frame.addWidget(self.operators_5_combobox,5,3)

        self.operators_6_combobox = QComboBox()
        self.operators_6_combobox.setEditable(False)
        self.operators_6_combobox.setFont(font)
        self.operators_6_combobox.setMaximumWidth(75)
        self.layout_frame.addWidget(self.operators_6_combobox,6,3)

        self.operators_7_combobox = QComboBox()
        self.operators_7_combobox.setEditable(False)
        self.operators_7_combobox.setFont(font)
        self.operators_7_combobox.setMaximumWidth(75)
        self.layout_frame.addWidget(self.operators_7_combobox,7,3)

        self.operators_8_combobox = QComboBox()
        self.operators_8_combobox.setEditable(False)
        self.operators_8_combobox.setFont(font)
        self.operators_8_combobox.setMaximumWidth(75)
        self.layout_frame.addWidget(self.operators_8_combobox,8,3)

        self.operators_9_combobox = QComboBox()
        self.operators_9_combobox.setEditable(False)
        self.operators_9_combobox.setFont(font)
        self.operators_9_combobox.setMaximumWidth(75)
        self.layout_frame.addWidget(self.operators_9_combobox,9,3)

        self.checkbox_filter_operators_list = []
        self.checkbox_filter_operators_list.append('=')
        self.checkbox_filter_operators_list.append('<')
        self.checkbox_filter_operators_list.append('<=')
        self.checkbox_filter_operators_list.append('>')
        self.checkbox_filter_operators_list.append('>=')
        self.checkbox_filter_operators_list.append('!=')
        self.checkbox_filter_operators_list.append('LIKE')
        self.checkbox_filter_operators_list.append('TRUE')
        self.checkbox_filter_operators_list.append('FALSE')
        self.checkbox_filter_operators_list.append('EXISTENT')
        self.checkbox_filter_operators_list.append('NULL')
        self.checkbox_filter_operators_list.append('REGEX')

        self.operators_item_index_dict = {}
        self.operators_item_index_dict['='] = 0
        self.operators_item_index_dict['<'] = 1
        self.operators_item_index_dict['<='] = 2
        self.operators_item_index_dict['>'] = 3
        self.operators_item_index_dict['>='] = 4
        self.operators_item_index_dict['!='] = 5
        self.operators_item_index_dict['LIKE'] = 6
        self.operators_item_index_dict['TRUE'] = 7
        self.operators_item_index_dict['FALSE'] = 8
        self.operators_item_index_dict['EXISTENT'] = 9
        self.operators_item_index_dict['NULL'] = 10
        self.operators_item_index_dict['REGEX'] = 11

        try:
            for item in self.checkbox_filter_operators_list:
                self.operators_0_combobox.addItem(item)
                self.operators_1_combobox.addItem(item)
                self.operators_2_combobox.addItem(item)
                self.operators_3_combobox.addItem(item)
                self.operators_4_combobox.addItem(item)
                self.operators_5_combobox.addItem(item)
                self.operators_6_combobox.addItem(item)
                self.operators_7_combobox.addItem(item)
                self.operators_8_combobox.addItem(item)
                self.operators_9_combobox.addItem(item)
            #END FOR
        except Exception as e:
            if DEBUG: print(as_unicode(e))
            pass
        del self.checkbox_filter_operators_list

        liketext = "<br><br>There are two wildcards used in conjunction with the LIKE operator: The percent sign (%) and the underscore (_).  The percent sign represents zero, one, or many numbers or characters. The underscore represents a single (1) number or character. These symbols can be used in combinations."
        liketext = liketext + "<br><br>MCS <b>automatically</b> adds '% to the left side of the value, and %' right side of the value.  The use of % and _ within the value by you is totally optional. "
        liketext = liketext + "<br><br>Example:  if you specify a value of Star Wars, MCS will <b>automatically</b> treat the value as:  '%Star Wars%' which would match: !!!!!Star Wars!!!!! ."
        liketext = liketext + "<br><br>Example: If you specify a value of Star_Wars, MCS will <b>automatically</b> treat the value as:  '%Star_Wars%' would would match: !!!!!Star!Wars!!!!! ."
        liketext = liketext + "<br><br>Example: If you specify a value of Star%Wars, MCS will <b>automatically</b> treat the value as:  '%Star%Wars%' which would match: !!!!!Star!!!!!!!Wars!!!!!"
        self.operators_tooltip = "<p style='white-space:wrap'>Select the logical Operator for this specific filter.  " + liketext + "<br><br>Do not try to use single or double quotes anywhere in the value column.<br><br> "
        self.operators_0_combobox.setToolTip(self.operators_tooltip)
        self.operators_1_combobox.setToolTip(self.operators_tooltip)
        self.operators_2_combobox.setToolTip(self.operators_tooltip)
        self.operators_3_combobox.setToolTip(self.operators_tooltip)
        self.operators_4_combobox.setToolTip(self.operators_tooltip)
        self.operators_5_combobox.setToolTip(self.operators_tooltip)
        self.operators_6_combobox.setToolTip(self.operators_tooltip)
        self.operators_7_combobox.setToolTip(self.operators_tooltip)
        self.operators_8_combobox.setToolTip(self.operators_tooltip)
        self.operators_9_combobox.setToolTip(self.operators_tooltip)
        #-----------------------------------------------------
        #-----------------------------------------------------
        self.qlineedit_value_0 = QLineEdit(self)
        self.qlineedit_value_1 = QLineEdit(self)
        self.qlineedit_value_2 = QLineEdit(self)
        self.qlineedit_value_3 = QLineEdit(self)
        self.qlineedit_value_4 = QLineEdit(self)
        self.qlineedit_value_5 = QLineEdit(self)
        self.qlineedit_value_6 = QLineEdit(self)
        self.qlineedit_value_7 = QLineEdit(self)
        self.qlineedit_value_8 = QLineEdit(self)
        self.qlineedit_value_9 = QLineEdit(self)

        self.qlineedit_value_0.setMaximumWidth(200)
        self.qlineedit_value_1.setMaximumWidth(200)
        self.qlineedit_value_2.setMaximumWidth(200)
        self.qlineedit_value_3.setMaximumWidth(200)
        self.qlineedit_value_4.setMaximumWidth(200)
        self.qlineedit_value_5.setMaximumWidth(200)
        self.qlineedit_value_6.setMaximumWidth(200)
        self.qlineedit_value_7.setMaximumWidth(200)
        self.qlineedit_value_8.setMaximumWidth(200)
        self.qlineedit_value_9.setMaximumWidth(200)

        self.layout_frame.addWidget(self.qlineedit_value_0,0,4)
        self.layout_frame.addWidget(self.qlineedit_value_1,1,4)
        self.layout_frame.addWidget(self.qlineedit_value_2,2,4)
        self.layout_frame.addWidget(self.qlineedit_value_3,3,4)
        self.layout_frame.addWidget(self.qlineedit_value_4,4,4)
        self.layout_frame.addWidget(self.qlineedit_value_5,5,4)
        self.layout_frame.addWidget(self.qlineedit_value_6,6,4)
        self.layout_frame.addWidget(self.qlineedit_value_7,7,4)
        self.layout_frame.addWidget(self.qlineedit_value_8,8,4)
        self.layout_frame.addWidget(self.qlineedit_value_9,9,4)

        self.qlineedit_tooltip = "<p style='white-space:wrap'>Specify a specific Value to be used for this specific filter.  \
                                                                                             <br><br>Not always required, and sometimes not allowed.  Sometimes a specific format is required. \
                                                                                             <br><br>Custom Columns of datatype 'series' (i.e., series-like) require either a specific series index or a wildcard series index.  Example:  Star Wars [*]     (or [1] or [2] or [0.5]) \
                                                                                             <br><br>Tags are evaluated individually, and not as displayed in the GUI (concatenated).  So, a book with many Tags will not be filtered out if you specify 'IS NOT LIKE' (some Tag).  That is because the book definitely has one or more Tags that 'ARE NOT LIKE' (some Tag).  Avoid 'IS NOT LIKE' for books with multiple Tags unless the 'value' matches all of their Tags.  'NOT'......'IS LIKE' should similarly be avoided.\
                                                                                             <br><br>'Integer' and 'Float' Custom Columns require an appropriate numeric value.  'Alphabetic' operators (e.g. 'LIKE') are not allowed for numerics.\
                                                                                             <br><br>Ratings are an integer from 1-10, and not simply the 'number of stars' that are displayed.\
                                                                                             <br><br>Regular Expressions for Operator 'REGEX' must be valid Regular Expressions that will not cause an RE error.\
                                                                                             <br><br>'Undefined' values, such as a 'nothing' in an Integer Custom Column or in Tags, are highly problematic.  You are advised to ensure that every book has at least a 0 in a numeric Custom Column if you intend to use Final Filters based on its 'existence'.  That trick does not work on Tags, because they do not allow an empty string or space. Be careful when filtering based on the existence of Tags.\
                                                                                             <br><br> "
        self.qlineedit_value_0.setToolTip(self.qlineedit_tooltip)
        self.qlineedit_value_1.setToolTip(self.qlineedit_tooltip)
        self.qlineedit_value_2.setToolTip(self.qlineedit_tooltip)
        self.qlineedit_value_3.setToolTip(self.qlineedit_tooltip)
        self.qlineedit_value_4.setToolTip(self.qlineedit_tooltip)
        self.qlineedit_value_5.setToolTip(self.qlineedit_tooltip)
        self.qlineedit_value_6.setToolTip(self.qlineedit_tooltip)
        self.qlineedit_value_7.setToolTip(self.qlineedit_tooltip)
        self.qlineedit_value_8.setToolTip(self.qlineedit_tooltip)
        self.qlineedit_value_9.setToolTip(self.qlineedit_tooltip)

        #-----------------------------------------------------
        #-----------------------------------------------------
        self.andornot_tooltip = "<p style='white-space:wrap'>This is the logical operator that connects one active filter to the following active filter.  The sequence from Top to Bottom (filter 1 to 10) must always be:  ORs then ANDs then NOTs.  You do not need to use all 3, but if you do, they must be used in that order.  The final active filter will always have a blank value, since there is nothing to connect it to. "

        self.andornot_0_combobox = QComboBox()
        self.andornot_0_combobox.setEditable(False)
        self.andornot_0_combobox.setFont(font)
        self.andornot_0_combobox.setMaximumWidth(50)
        self.andornot_0_combobox.setToolTip(self.andornot_tooltip)
        self.layout_frame.addWidget(self.andornot_0_combobox,0,5)

        self.andornot_1_combobox = QComboBox()
        self.andornot_1_combobox.setEditable(False)
        self.andornot_1_combobox.setFont(font)
        self.andornot_1_combobox.setMaximumWidth(50)
        self.andornot_1_combobox.setToolTip(self.andornot_tooltip)
        self.layout_frame.addWidget(self.andornot_1_combobox,1,5)

        self.andornot_2_combobox = QComboBox()
        self.andornot_2_combobox.setEditable(False)
        self.andornot_2_combobox.setFont(font)
        self.andornot_2_combobox.setMaximumWidth(50)
        self.andornot_2_combobox.setToolTip(self.andornot_tooltip)
        self.layout_frame.addWidget(self.andornot_2_combobox,2,5)

        self.andornot_3_combobox = QComboBox()
        self.andornot_3_combobox.setEditable(False)
        self.andornot_3_combobox.setFont(font)
        self.andornot_3_combobox.setMaximumWidth(50)
        self.andornot_3_combobox.setToolTip(self.andornot_tooltip)
        self.layout_frame.addWidget(self.andornot_3_combobox,3,5)

        self.andornot_4_combobox = QComboBox()
        self.andornot_4_combobox.setEditable(False)
        self.andornot_4_combobox.setFont(font)
        self.andornot_4_combobox.setMaximumWidth(50)
        self.andornot_4_combobox.setToolTip(self.andornot_tooltip)
        self.layout_frame.addWidget(self.andornot_4_combobox,4,5)

        self.andornot_5_combobox = QComboBox()
        self.andornot_5_combobox.setEditable(False)
        self.andornot_5_combobox.setFont(font)
        self.andornot_5_combobox.setMaximumWidth(50)
        self.andornot_5_combobox.setToolTip(self.andornot_tooltip)
        self.layout_frame.addWidget(self.andornot_5_combobox,5,5)

        self.andornot_6_combobox = QComboBox()
        self.andornot_6_combobox.setEditable(False)
        self.andornot_6_combobox.setFont(font)
        self.andornot_6_combobox.setMaximumWidth(50)
        self.andornot_6_combobox.setToolTip(self.andornot_tooltip)
        self.layout_frame.addWidget(self.andornot_6_combobox,6,5)

        self.andornot_7_combobox = QComboBox()
        self.andornot_7_combobox.setEditable(False)
        self.andornot_7_combobox.setFont(font)
        self.andornot_7_combobox.setMaximumWidth(50)
        self.andornot_7_combobox.setToolTip(self.andornot_tooltip)
        self.layout_frame.addWidget(self.andornot_7_combobox,7,5)

        self.andornot_8_combobox = QComboBox()
        self.andornot_8_combobox.setEditable(False)
        self.andornot_8_combobox.setFont(font)
        self.andornot_8_combobox.setMaximumWidth(50)
        self.andornot_8_combobox.setToolTip(self.andornot_tooltip)
        self.layout_frame.addWidget(self.andornot_8_combobox,8,5)

        self.andornot_9_combobox = QComboBox()
        self.andornot_9_combobox.setEditable(False)
        #final line may show no andornot, but the object is required to exist.

        self.checkbox_filter_andor_list = []
        self.checkbox_filter_andor_list.append('')
        self.checkbox_filter_andor_list.append('AND')
        self.checkbox_filter_andor_list.append('OR')
        self.checkbox_filter_andor_list.append('NOT')

        self.andornot_item_index_dict = {}
        self.andornot_item_index_dict[''] = 0
        self.andornot_item_index_dict['AND'] = 1
        self.andornot_item_index_dict['OR'] = 2
        self.andornot_item_index_dict['NOT'] = 3

        try:
            for item in self.checkbox_filter_andor_list:
                self.andornot_0_combobox.addItem(item)
                self.andornot_1_combobox.addItem(item)
                self.andornot_2_combobox.addItem(item)
                self.andornot_3_combobox.addItem(item)
                self.andornot_4_combobox.addItem(item)
                self.andornot_5_combobox.addItem(item)
                self.andornot_6_combobox.addItem(item)
                self.andornot_7_combobox.addItem(item)
                self.andornot_8_combobox.addItem(item)
                #~ self.andornot_9_combobox.addItem(item)
            #END FOR
        except:
            pass
        del self.checkbox_filter_andor_list

        self.push_button_check_all_checkboxes = QPushButton("", self)
        self.push_button_check_all_checkboxes.setText("■")
        self.push_button_check_all_checkboxes.setToolTip("<p style='white-space:wrap'>Activate all filters? ")
        self.push_button_check_all_checkboxes.setMaximumWidth(50)
        self.push_button_check_all_checkboxes.clicked.connect(self.check_all_checkboxes)
        self.layout_frame.addWidget(self.push_button_check_all_checkboxes,11,0)


        self.push_button_save_filter_values = QPushButton(" ", self)
        self.push_button_save_filter_values.setText("Save Filters?")
        self.push_button_save_filter_values.setToolTip("<p style='white-space:wrap'>Save temporarily, unvalidated, everything currently shown on this Tab? ")
        self.push_button_save_filter_values.setMaximumWidth(400)
        self.push_button_save_filter_values.clicked.connect(self.save_filter_values)
        self.layout_frame.addWidget(self.push_button_save_filter_values,11,1)

        self.push_button_uncheck_all_checkboxes = QPushButton("", self)
        self.push_button_uncheck_all_checkboxes.setText("☐")
        self.push_button_uncheck_all_checkboxes.setToolTip("<p style='white-space:wrap'>Deactivate all filters? ")
        self.push_button_uncheck_all_checkboxes.setMaximumWidth(50)
        self.push_button_uncheck_all_checkboxes.clicked.connect(self.uncheck_all_checkboxes)
        self.layout_frame.addWidget(self.push_button_uncheck_all_checkboxes,12,0)

        self.push_button_validate_filter_values = QPushButton(" ", self)
        self.push_button_validate_filter_values.setText("Save and Validate Filters?")
        self.push_button_validate_filter_values.setToolTip("<p style='white-space:wrap'>Save (with a name) all criteria for this Tab, and then Validate all active filters? ")

        self.push_button_validate_filter_values.clicked.connect(self.validate_final_filters)
        self.layout_frame.addWidget(self.push_button_validate_filter_values,12,1)

        self.push_button_load_saved_criteria_values = QPushButton(" ", self)
        self.push_button_load_saved_criteria_values.setText("Load Previously Saved and Validated Criteria?")
        self.push_button_load_saved_criteria_values.setToolTip("<p style='white-space:wrap'>Select a previously saved (with a name) set of criteria for this Tab.")
        self.push_button_load_saved_criteria_values.clicked.connect(self.load_criteria_settings_finalfiltertab)
        self.layout_frame.addWidget(self.push_button_load_saved_criteria_values,12,2)
        #-----------------------------------------------------
        #-----------------------------------------------------
        #-----------------------------------------------------
        self.resize(self.sizeHint())
        #-----------------------------------------------------
        #-----------------------------------------------------
        #-----------------------------------------------------
        self.load_saved_filter_values(source=prefs)
        #-----------------------------------------------------
        self.build_qt_object_dicts()
        #-----------------------------------------------------
        self.build_final_filter_invalid_combinations_sets()
        #-----------------------------------------------------
        #-----------------------------------------------------
    #-----------------------------------------------------------------------------------------------
    #-----------------------------------------------------------------------------------------------
    def save_filter_values(self,action='save_only'):

        global prefs

        row_list = []
        row_list.append("")
        row_list.append("")
        row_list.append("")
        row_list.append("")
        row_list.append("")
        row_list.append("")
        #-------------------------
        if self.checkbox_filter_0.isChecked():
            a = "True"
        else:
            a = "False"
        b = self.table_0_combobox.currentText()
        c = self.isnot_0_combobox.currentText()
        f = self.operators_0_combobox.currentText()
        d = self.qlineedit_value_0.text()
        e = self.andornot_0_combobox.currentText()
        row_list[0] = a
        row_list[1] = b
        row_list[2] = c
        row_list[3] = d
        row_list[4] = e
        row_list[5] = f
        prefs['FINAL_FILTER_0'] = as_unicode(row_list)
        #-------------------------
        if self.checkbox_filter_1.isChecked():
            a = "True"
        else:
            a = "False"
        b = self.table_1_combobox.currentText()
        c = self.isnot_1_combobox.currentText()
        f = self.operators_1_combobox.currentText()
        d = self.qlineedit_value_1.text()
        e = self.andornot_1_combobox.currentText()
        row = a,b,c,d,e,f
        prefs['FINAL_FILTER_1'] = as_unicode(row)
        #-------------------------
        if self.checkbox_filter_2.isChecked():
            a = "True"
        else:
            a = "False"
        b = self.table_2_combobox.currentText()
        c = self.isnot_2_combobox.currentText()
        f = self.operators_2_combobox.currentText()
        d = self.qlineedit_value_2.text()
        e = self.andornot_2_combobox.currentText()
        row = a,b,c,d,e,f
        prefs['FINAL_FILTER_2'] = as_unicode(row)
        #-------------------------
        if self.checkbox_filter_3.isChecked():
            a = "True"
        else:
            a = "False"
        b = self.table_3_combobox.currentText()
        c = self.isnot_3_combobox.currentText()
        f = self.operators_3_combobox.currentText()
        d = self.qlineedit_value_3.text()
        e = self.andornot_3_combobox.currentText()
        row = a,b,c,d,e,f
        prefs['FINAL_FILTER_3'] = as_unicode(row)
        #-------------------------
        if self.checkbox_filter_4.isChecked():
            a = "True"
        else:
            a = "False"
        b = self.table_4_combobox.currentText()
        c = self.isnot_4_combobox.currentText()
        f = self.operators_4_combobox.currentText()
        d = self.qlineedit_value_4.text()
        e = self.andornot_4_combobox.currentText()
        row = a,b,c,d,e,f
        prefs['FINAL_FILTER_4'] = as_unicode(row)
        #-------------------------
        if self.checkbox_filter_5.isChecked():
            a = "True"
        else:
            a = "False"
        b = self.table_5_combobox.currentText()
        c = self.isnot_5_combobox.currentText()
        f = self.operators_5_combobox.currentText()
        d = self.qlineedit_value_5.text()
        e = self.andornot_5_combobox.currentText()
        row = a,b,c,d,e,f
        prefs['FINAL_FILTER_5'] = as_unicode(row)
        #-------------------------
        if self.checkbox_filter_6.isChecked():
            a = "True"
        else:
            a = "False"
        b = self.table_6_combobox.currentText()
        c = self.isnot_6_combobox.currentText()
        f = self.operators_6_combobox.currentText()
        d = self.qlineedit_value_6.text()
        e = self.andornot_6_combobox.currentText()
        row = a,b,c,d,e,f
        prefs['FINAL_FILTER_6'] = as_unicode(row)
        #-------------------------
        if self.checkbox_filter_7.isChecked():
            a = "True"
        else:
            a = "False"
        b = self.table_7_combobox.currentText()
        c = self.isnot_7_combobox.currentText()
        f = self.operators_7_combobox.currentText()
        d = self.qlineedit_value_7.text()
        e = self.andornot_7_combobox.currentText()
        row = a,b,c,d,e,f
        prefs['FINAL_FILTER_7'] = as_unicode(row)
        #-------------------------
        if self.checkbox_filter_8.isChecked():
            a = "True"
        else:
            a = "False"
        b = self.table_8_combobox.currentText()
        c = self.isnot_8_combobox.currentText()
        f = self.operators_8_combobox.currentText()
        d = self.qlineedit_value_8.text()
        e = self.andornot_8_combobox.currentText()
        row = a,b,c,d,e,f
        prefs['FINAL_FILTER_8'] = as_unicode(row)
        #-------------------------
        if self.checkbox_filter_9.isChecked():
            a = "True"
        else:
            a = "False"
        b = self.table_9_combobox.currentText()
        c = self.isnot_9_combobox.currentText()
        f = self.operators_9_combobox.currentText()
        d = self.qlineedit_value_9.text()
        e = self.andornot_9_combobox.currentText()
        row = a,b,c,d,e,f
        prefs['FINAL_FILTER_9'] = as_unicode(row)
        #-------------------------
        prefs['FINAL_FILTERS_LAST_SAVED'] = as_unicode(datetime.now())
        #-------------------------
        prefs

        del row_list
        del row

        if action == 'save_validated':
            if DEBUG: print("if action == 'save_validated':")
            current_tab = FINALFILTERTAB
            param_dict = {}
            for k,v in iteritems(prefs):
                if k.startswith('FINAL_'):
                    param_dict[k] = v
            #END FOR
            param_dict[FINAL_FILTERS_TYPE] = FINAL_FILTERS_TYPE
            del param_dict['FINAL_FILTERS_LAST_SAVED']
            prefs = self.save_settings_parm_history_to_prefs_generic(prefs,current_tab,param_dict)
            prefs
            del param_dict
    #-----------------------------------------------------------------------------------------------
    def load_saved_filter_values(self,source=None):
        if not isinstance(source,dict):
            return
        #-------------------------
        self.uncheck_all_checkboxes()
        #-------------------------
        try:
            raw = source['FINAL_FILTER_0']
        except:
            self.save_filter_values(action='save_only')
            #-------------------------
        try:
            try:
                now_loading = 0
                raw = source['FINAL_FILTER_0']
                row_list = eval(raw)
                a = row_list[0]
                b = as_unicode(row_list[1])
                c = as_unicode(row_list[2])
                d = row_list[3]
                e = as_unicode(row_list[4])
                f = as_unicode(row_list[5])
                if a == "True":
                    self.checkbox_filter_0.setChecked(True)
                n = self.tables_item_index_dict[b]
                self.table_0_combobox.setCurrentIndex(n)
                n = self.isnot_item_index_dict[c]
                self.isnot_0_combobox.setCurrentIndex(n)
                n = self.operators_item_index_dict[f]
                self.operators_0_combobox.setCurrentIndex(n)
                self.qlineedit_value_0.setText(d)
                n = self.andornot_item_index_dict[e]
                self.andornot_0_combobox.setCurrentIndex(n)
            except Exception as e:
                #~ if DEBUG: print("Last attempted Final Filter to be loaded was: ", as_unicode(now_loading + 1))
                #~ if DEBUG: print("Load Saved Final Filters Exception: ", as_unicode(e))
                pass
            #-------------------------
            try:
                now_loading = 1
                raw = source['FINAL_FILTER_1']
                row_list = eval(raw)
                a = row_list[0]
                b = as_unicode(row_list[1])
                c = as_unicode(row_list[2])
                d = row_list[3]
                e = as_unicode(row_list[4])
                f = as_unicode(row_list[5])
                if a == "True":
                    self.checkbox_filter_1.setChecked(True)
                n = self.tables_item_index_dict[b]
                self.table_1_combobox.setCurrentIndex(n)
                n = self.isnot_item_index_dict[c]
                self.isnot_1_combobox.setCurrentIndex(n)
                n = self.operators_item_index_dict[f]
                self.operators_1_combobox.setCurrentIndex(n)
                self.qlineedit_value_1.setText(d)
                n = self.andornot_item_index_dict[e]
                self.andornot_1_combobox.setCurrentIndex(n)
            except Exception as e:
                #~ if DEBUG: print("Last attempted Final Filter to be loaded was: ", as_unicode(now_loading + 1))
                #~ if DEBUG: print("Load Saved Final Filters Exception: ", as_unicode(e))
                pass
            #-------------------------
            try:
                now_loading = 2
                raw = source['FINAL_FILTER_2']
                row_list = eval(raw)
                a = row_list[0]
                b = as_unicode(row_list[1])
                c = as_unicode(row_list[2])
                d = row_list[3]
                e = as_unicode(row_list[4])
                f = as_unicode(row_list[5])
                if a == "True":
                    self.checkbox_filter_2.setChecked(True)
                n = self.tables_item_index_dict[b]
                self.table_2_combobox.setCurrentIndex(n)
                n = self.isnot_item_index_dict[c]
                self.isnot_2_combobox.setCurrentIndex(n)
                n = self.operators_item_index_dict[f]
                self.operators_2_combobox.setCurrentIndex(n)
                self.qlineedit_value_2.setText(d)
                n = self.andornot_item_index_dict[e]
                self.andornot_2_combobox.setCurrentIndex(n)
            except Exception as e:
                #~ if DEBUG: print("Last attempted Final Filter to be loaded was: ", as_unicode(now_loading + 1))
                #~ if DEBUG: print("Load Saved Final Filters Exception: ", as_unicode(e))
                pass
            #-------------------------
            try:
                now_loading = 3
                raw = source['FINAL_FILTER_3']
                row_list = eval(raw)
                a = row_list[0]
                b = as_unicode(row_list[1])
                c = as_unicode(row_list[2])
                d = row_list[3]
                e = as_unicode(row_list[4])
                f = as_unicode(row_list[5])
                if a == "True":
                    self.checkbox_filter_3.setChecked(True)
                n = self.tables_item_index_dict[b]
                self.table_3_combobox.setCurrentIndex(n)
                n = self.isnot_item_index_dict[c]
                self.isnot_3_combobox.setCurrentIndex(n)
                n = self.operators_item_index_dict[f]
                self.operators_3_combobox.setCurrentIndex(n)
                self.qlineedit_value_3.setText(d)
                n = self.andornot_item_index_dict[e]
                self.andornot_3_combobox.setCurrentIndex(n)
            except Exception as e:
                #~ if DEBUG: print("Last attempted Final Filter to be loaded was: ", as_unicode(now_loading + 1))
                #~ if DEBUG: print("Load Saved Final Filters Exception: ", as_unicode(e))
                pass
            #-------------------------
            try:
                now_loading = 4
                raw = source['FINAL_FILTER_4']
                row_list = eval(raw)
                a = row_list[0]
                b = as_unicode(row_list[1])
                c = as_unicode(row_list[2])
                d = row_list[3]
                e = as_unicode(row_list[4])
                f = as_unicode(row_list[5])
                if a == "True":
                    self.checkbox_filter_4.setChecked(True)
                n = self.tables_item_index_dict[b]
                self.table_4_combobox.setCurrentIndex(n)
                n = self.isnot_item_index_dict[c]
                self.isnot_4_combobox.setCurrentIndex(n)
                n = self.operators_item_index_dict[f]
                self.operators_4_combobox.setCurrentIndex(n)
                self.qlineedit_value_4.setText(d)
                n = self.andornot_item_index_dict[e]
                self.andornot_4_combobox.setCurrentIndex(n)
            except Exception as e:
                #~ if DEBUG: print("Last attempted Final Filter to be loaded was: ", as_unicode(now_loading + 1))
                #~ if DEBUG: print("Load Saved Final Filters Exception: ", as_unicode(e))
                pass
            #-------------------------
            try:
                now_loading = 5
                raw = source['FINAL_FILTER_5']
                row_list = eval(raw)
                a = row_list[0]
                b = as_unicode(row_list[1])
                c = as_unicode(row_list[2])
                d = row_list[3]
                e = as_unicode(row_list[4])
                f = as_unicode(row_list[5])
                if a == "True":
                    self.checkbox_filter_5.setChecked(True)
                n = self.tables_item_index_dict[b]
                self.table_5_combobox.setCurrentIndex(n)
                n = self.isnot_item_index_dict[c]
                self.isnot_5_combobox.setCurrentIndex(n)
                n = self.operators_item_index_dict[f]
                self.operators_5_combobox.setCurrentIndex(n)
                self.qlineedit_value_5.setText(d)
                n = self.andornot_item_index_dict[e]
                self.andornot_5_combobox.setCurrentIndex(n)
            except Exception as e:
                #~ if DEBUG: print("Last attempted Final Filter to be loaded was: ", as_unicode(now_loading + 1))
                #~ if DEBUG: print("Load Saved Final Filters Exception: ", as_unicode(e))
                pass
            #-------------------------
            try:
                now_loading = 6
                raw = source['FINAL_FILTER_6']
                row_list = eval(raw)
                a = row_list[0]
                b = as_unicode(row_list[1])
                c = as_unicode(row_list[2])
                d = row_list[3]
                e = as_unicode(row_list[4])
                f = as_unicode(row_list[5])
                if a == "True":
                    self.checkbox_filter_6.setChecked(True)
                n = self.tables_item_index_dict[b]
                self.table_6_combobox.setCurrentIndex(n)
                n = self.isnot_item_index_dict[c]
                self.isnot_6_combobox.setCurrentIndex(n)
                n = self.operators_item_index_dict[f]
                self.operators_6_combobox.setCurrentIndex(n)
                self.qlineedit_value_6.setText(d)
                n = self.andornot_item_index_dict[e]
                self.andornot_6_combobox.setCurrentIndex(n)
            except Exception as e:
                #~ if DEBUG: print("Last attempted Final Filter to be loaded was: ", as_unicode(now_loading + 1))
                #~ if DEBUG: print("Load Saved Final Filters Exception: ", as_unicode(e))
                pass
            #-------------------------
            try:
                now_loading = 7
                raw = source['FINAL_FILTER_7']
                row_list = eval(raw)
                a = row_list[0]
                b = as_unicode(row_list[1])
                c = as_unicode(row_list[2])
                d = row_list[3]
                e = as_unicode(row_list[4])
                f = as_unicode(row_list[5])
                if a == "True":
                    self.checkbox_filter_7.setChecked(True)
                n = self.tables_item_index_dict[b]
                self.table_7_combobox.setCurrentIndex(n)
                n = self.isnot_item_index_dict[c]
                self.isnot_7_combobox.setCurrentIndex(n)
                n = self.operators_item_index_dict[f]
                self.operators_7_combobox.setCurrentIndex(n)
                self.qlineedit_value_7.setText(d)
                n = self.andornot_item_index_dict[e]
                self.andornot_7_combobox.setCurrentIndex(n)
            except Exception as e:
                #~ if DEBUG: print("Last attempted Final Filter to be loaded was: ", as_unicode(now_loading + 1))
                #~ if DEBUG: print("Load Saved Final Filters Exception: ", as_unicode(e))
                pass
            #-------------------------
            try:
                now_loading = 8
                raw = source['FINAL_FILTER_8']
                row_list = eval(raw)
                a = row_list[0]
                b = as_unicode(row_list[1])
                c = as_unicode(row_list[2])
                d = row_list[3]
                e = as_unicode(row_list[4])
                f = as_unicode(row_list[5])
                if a == "True":
                    self.checkbox_filter_8.setChecked(True)
                n = self.tables_item_index_dict[b]
                self.table_8_combobox.setCurrentIndex(n)
                n = self.isnot_item_index_dict[c]
                self.isnot_8_combobox.setCurrentIndex(n)
                n = self.operators_item_index_dict[f]
                self.operators_8_combobox.setCurrentIndex(n)
                self.qlineedit_value_8.setText(d)
                n = self.andornot_item_index_dict[e]
                self.andornot_8_combobox.setCurrentIndex(n)
            except Exception as e:
                #~ if DEBUG: print("Last attempted Final Filter to be loaded was: ", as_unicode(now_loading + 1))
                #~ if DEBUG: print("Load Saved Final Filters Exception: ", as_unicode(e))
                pass
            #-------------------------
            try:
                now_loading = 9
                raw = source['FINAL_FILTER_9']
                row_list = eval(raw)
                a = row_list[0]
                b = as_unicode(row_list[1])
                c = as_unicode(row_list[2])
                d = row_list[3]
                e = as_unicode(row_list[4])
                f = as_unicode(row_list[5])
                if a == "True":
                    self.checkbox_filter_9.setChecked(True)
                n = self.tables_item_index_dict[b]
                self.table_9_combobox.setCurrentIndex(n)
                n = self.isnot_item_index_dict[c]
                self.isnot_9_combobox.setCurrentIndex(n)
                n = self.operators_item_index_dict[f]
                self.operators_9_combobox.setCurrentIndex(n)
                self.qlineedit_value_9.setText(d)
                n = self.andornot_item_index_dict[e]
                self.andornot_9_combobox.setCurrentIndex(n)
            except Exception as e:
                #~ if DEBUG: print("Last attempted Final Filter to be loaded was: ", as_unicode(now_loading + 1))
                #~ if DEBUG: print("Load Saved Final Filters Exception: ", as_unicode(e))
                pass
        except Exception as e:
            #~ if DEBUG: print("Last attempted Final Filter to be loaded was: ", as_unicode(now_loading + 1))
            #~ if DEBUG: print("Load Saved Final Filters Exception: ", as_unicode(e))
            pass
    #-----------------------------------------------------------------------------------------------
    def validate_final_filters(self):

        global prefs

        self.save_filter_values(action='save_only')

        filter_message = ""

        all_valid = True
        is_valid = True

        n_active = 0
        for x in range(0,10):
            filter_checkbox = self.qt_final_filters_tab_filter_checkbox_objects_dict[x]
            if filter_checkbox.isChecked():
                n_active = n_active + 1

        if n_active == 0:
            t = datetime.now()   # must be the same
            prefs['FINAL_FILTERS_LAST_SAVED'] = as_unicode(t)
            prefs['FINAL_FILTERS_LAST_VALIDATED'] = as_unicode(t)
            prefs
            msg = "There are no 'active' filters, so there is nothing to validate. "
            info_dialog(self.gui, _("MCS: Final Filter Validation"), _(msg), show=True)
            return

        prior_andornot = "TOP"

        n_current_filter_row = 0
        n_prior_filter_row = 0
        n_count = 0
        for x in range(0,10):
            filter_checkbox = self.qt_final_filters_tab_filter_checkbox_objects_dict[x]
            if not filter_checkbox.isChecked():
                continue
            n_count = n_count + 1
            n_current_filter_row = x
            table_combobox = self.qt_final_filters_tab_table_combobox_objects_dict[x]
            isnot_combobox = self.qt_final_filters_tab_isnot_combobox_objects_dict[x]
            operators_combobox = self.qt_final_filters_tab_operators_combobox_objects_dict[x]
            value_qlineedit = self.qt_final_filters_tab_value_qlineedit_objects_dict[x]
            andornot_combobox = self.qt_final_filters_tab_andornot_combobox_objects_dict[x]

            table = table_combobox.currentText()
            isnot = isnot_combobox.currentText()
            sqloperator = operators_combobox.currentText()
            value = value_qlineedit.text()
            andornot = andornot_combobox.currentText()

            if "cc: #" in table:
                is_cc = True
                label = table[4: ]  #  cc: #mything
                id = self.custom_column_label_dict[label]
                datatype = self.custom_column_datatype_dict[id]
            else:
                is_cc = False
                if table == "books: has_cover":
                    datatype = "bool"
                else:
                    datatype = ""

            # for numeric datatypes, change alphabetic operators to an equals symbol so they cannot be used
            if datatype == "int" or datatype == "float":
                if sqloperator == "EXISTENT" or sqloperator == "LIKE" or sqloperator == "NULL" or sqloperator == "TRUE" or sqloperator == "FALSE" or sqloperator == "REGEX":
                    sqloperator = "="
                    operators_combobox.setCurrentText("=")
                    if value == "":
                        value = "0"
                        value_qlineedit.setText(value)

            #~ simplify expressions
            if isnot == "IS NOT":
                if sqloperator == "TRUE":
                    isnot = "IS"
                    sqloperator = "FALSE"
                    isnot_combobox.setCurrentText(isnot)
                    operators_combobox.setCurrentText(sqloperator)
                elif sqloperator == "FALSE":
                    isnot = "IS"
                    sqloperator = "TRUE"
                    isnot_combobox.setCurrentText(isnot)
                    operators_combobox.setCurrentText(sqloperator)
                elif sqloperator == "=":
                    isnot = "IS"
                    sqloperator = "!="
                    isnot_combobox.setCurrentText(isnot)
                    operators_combobox.setCurrentText(sqloperator)
                elif sqloperator == "!=":
                    isnot = "IS"
                    sqloperator = "="
                    isnot_combobox.setCurrentText(isnot)
                    operators_combobox.setCurrentText(sqloperator)
                elif sqloperator == ">":
                    isnot = "IS"
                    sqloperator = "<="
                    isnot_combobox.setCurrentText(isnot)
                    operators_combobox.setCurrentText(sqloperator)
                elif sqloperator == ">=":
                    isnot = "IS"
                    sqloperator = "<"
                    isnot_combobox.setCurrentText(isnot)
                    operators_combobox.setCurrentText(sqloperator)
                elif sqloperator == "<":
                    isnot = "IS"
                    sqloperator = ">="
                    isnot_combobox.setCurrentText(isnot)
                    operators_combobox.setCurrentText(sqloperator)
                elif sqloperator == "<=":
                    isnot = "IS"
                    sqloperator = ">"
                    isnot_combobox.setCurrentText(isnot)
                    operators_combobox.setCurrentText(sqloperator)
                else:
                    pass

            #~ if DEBUG: print("[0] checking: ", table, isnot, sqloperator,as_unicode(value),andornot)

            # blank out andornot on the very last active filter...
            if n_count == n_active:
                andornot_combobox.setCurrentText("")
                andornot = ""

            value = value.replace("'","")   # quotes will cause sql errors.
            value = value.replace('"','')
            value_qlineedit.setText(value)

            # blank out value if the operator is TRUE, FALSE, NULL, EXISTENT
            if datatype != "series" and table != "identifiers: type":
                if sqloperator == "TRUE" or sqloperator == "FALSE" or sqloperator == "NULL" or sqloperator == "EXISTENT":
                    value_qlineedit.setText("")
            else:
                if datatype == "series":
                    if value == "":
                        value = "seriesnamegoeshere  [*]"
                        value_qlineedit.setText(value)
                    else:
                        if not '[' in value:
                            value = value + "  [*]"
                            value_qlineedit.setText(value)


            # for identifiers:type there is only one valid sqloperator, so force it.
            if table == "identifiers: type":
                operators_combobox.setCurrentText("EXISTENT")
                sqloperator = operators_combobox.currentText()
                if value == "":
                    value = "xxxxx"
                    value_qlineedit.setText(value)

            # for tags, no blank value is allowed.
            if table == "tags: name":
                if value == "":
                    value = "xxxxx"
                    value_qlineedit.setText(value)

            # change NULL to use EXISTENT
            if sqloperator == "NULL":
                if isnot == "IS":  # if IS NULL, change to IS NOT EXISTENT
                    isnot_combobox.setCurrentText("IS NOT")
                    operators_combobox.setCurrentText("EXISTENT")
                elif isnot == "IS NOT":   # if IS NOT NULL, change to IS EXISTENT
                    isnot_combobox.setCurrentText("IS")
                    operators_combobox.setCurrentText("EXISTENT")
                isnot = isnot_combobox.currentText()
                sqloperator = operators_combobox.currentText()

            # change TRUE/FALSE to use EXISTENT for non-boolean datatypes
            if not datatype == "bool":
                if sqloperator == "TRUE":
                    if isnot == "IS":
                        # IS TRUE = IS EXISTENT
                        sqloperator = "EXISTENT"
                        operators_combobox.setCurrentText("EXISTENT")
                    else:  # IS NOT
                        # IS NOT TRUE = IS NOT EXISTENT
                        sqloperator = "EXISTENT"
                        operators_combobox.setCurrentText("EXISTENT")
                else:
                    if sqloperator == "FALSE":
                        if isnot == "IS":
                            # IS FALSE = IS NOT EXISTENT
                            isnot = "IS NOT"
                            isnot_combobox.setCurrentText("IS NOT")
                            sqloperator = "EXISTENT"
                            operators_combobox.setCurrentText("EXISTENT")
                        else:  # IS NOT
                            # IS NOT FALSE = IS EXISTENT
                            isnot = "IS"
                            isnot_combobox.setCurrentText("IS")
                            sqloperator = "EXISTENT"
                            operators_combobox.setCurrentText("EXISTENT")
            else:  # bool
                if sqloperator == "EXISTENT":  # change EXISTENT to use TRUE/FALSE  for boolean datatypes
                    if isnot == "IS":
                        # IS EXISTENT = IS TRUE
                        sqloperator = "TRUE"
                        operators_combobox.setCurrentText("TRUE")
                    else:  # IS NOT
                        # IS NOT EXISTANT = IS FALSE
                        isnot = "IS"
                        isnot_combobox.setCurrentText("IS")
                        sqloperator = "FALSE"
                        operators_combobox.setCurrentText("FALSE")

            # for numeric datatypes, change alphabetic operators to an equals symbol so they cannot be used
            if datatype == "int" or datatype == "float":
                if sqloperator == "EXISTENT" or  sqloperator == "LIKE" or  sqloperator == "REGEX":
                    sqloperator = "="
                    operators_combobox.setCurrentText("=")
                    if value == "":
                        value = "0"
                        value_qlineedit.setText(value)

            if sqloperator == "REGEX":
                if not value > " ":
                    value = "^.+$"
                    value_qlineedit.setText(value)

            is_valid = True

            # ensure that they actually use andornots for each of the active filters
            if n_count < n_active:
                if not andornot > "":
                    error_text = "AND/OR/NOT is required for active filters (except the last)"
                    s = "Filter " + as_unicode(x+1) + " : " + error_text
                    filter_message = filter_message + " <br> " + s
                    is_valid = False
                    all_valid = False

            if prior_andornot == "TOP":
                prior_andornot = as_unicode(andornot)

            if (as_unicode(prior_andornot) == "AND" and as_unicode(andornot) == "OR") or \
               (as_unicode(prior_andornot) == "NOT" and as_unicode(andornot) == "AND") or \
               (as_unicode(prior_andornot) == "NOT" and as_unicode(andornot) == "OR"):
                is_valid = False
                all_valid = False
                error_text = "ORs must be used before ANDs which must be used before NOTs"
                s = "Filter " + as_unicode(x+1) + " : " + error_text
                filter_message = filter_message + " <br> " + s
            else:
                pass

            prior_andornot = as_unicode(andornot)

            if is_valid:
                is_valid,error_text = self.check_for_invalid_combinations(table,isnot,sqloperator,value,andornot)
                if not is_valid:
                    s = "Filter " + as_unicode(x+1) + " : " + error_text
                    filter_message = filter_message + " <br> " + s
                    all_valid = False

            n_prior_filter_row =  n_current_filter_row

        #END FOR

        if not all_valid:
            prefs['FINAL_FILTERS_PASSED_VALIDATION'] = "False"
            msg = "Final Filters have validation errors:<br>" + filter_message + "<br><br>"
            error_dialog(self.gui, _('MCS: Final Filter Validation'),_((msg)), show=True)
            return
        else:
            prefs['FINAL_FILTERS_PASSED_VALIDATION'] = "True"
            msg = "MCS: Final Filters have passed basic validation.  That is no guarantee that they are logical or otherwise correct. "
            self.gui.status_bar.showMessage(msg)

        if all_valid:
            self.save_filter_values(action='save_validated')
            t = datetime.now()   # must be the same
            prefs['FINAL_FILTERS_LAST_SAVED'] = as_unicode(t)
            prefs['FINAL_FILTERS_LAST_VALIDATED'] = as_unicode(t)
            prefs
    #-----------------------------------------------------------------------------------------------
    def check_for_invalid_combinations(self,table,isnot,sqloperator,value,andornot):
        #~ self.custom_column_label_dict                     label = id
        #~ self.custom_column_datatype_dict               id = datatype
        #~ self.custom_column_normalized_dict           id = normalized

        is_valid = True
        error_text = ""

        if "cc: #" in table:
            is_cc = True
        else:
            is_cc = False

        if not is_cc:
            table = as_unicode(table)
            sqloperator = as_unicode(sqloperator)
            key = as_unicode(table + sqloperator)
        else:
            label = table[4: ]  #  cc: #mything
            id = self.custom_column_label_dict[label]
            datatype = self.custom_column_datatype_dict[id]
            table = as_unicode(datatype)
            sqloperator = as_unicode(sqloperator)
            key = as_unicode(table + sqloperator)  # for custom columns, the datatype is what is important, not the label.

        if key in self.final_filter_invalid_combinations_table_operator_set:
            is_valid = False
            error_text = "Table/Operator Combination: " + table + " / " + sqloperator
            #~ if DEBUG: print(error_text)

        if is_valid:
            if is_cc:
                if as_unicode(datatype) == as_unicode('int') or as_unicode(datatype) == as_unicode('float'):
                   value = as_unicode(value)
                   for c in value:
                        if c in ".0123456789":
                            pass
                        else:
                            is_valid = False
                            error_text = "Table/Value Combination: " + datatype + " " + as_unicode(value) + "  -- number required"
                            break
                    #END FOR
                elif as_unicode(datatype) == as_unicode('series'):
                    if "[" in value and "]" in value:
                        pass
                    else:
                        is_valid = False
                        error_text = "Table/Value Combination: " + datatype + " " + as_unicode(value) + " -- is missing ' [*]'  "
                elif as_unicode(datatype) == as_unicode('rating'):
                    value = as_unicode(value)
                    for c in value:
                        if c in "0123456789":
                            pass
                        else:
                            is_valid = False
                            error_text = "Table/Value Combination: " + datatype + " " + as_unicode(value) + " -- rating is 1-10"
                            break
                    #END FOR
                else:
                    pass
            else:
                if table == "identifiers: type":
                    if not value > " ":
                        is_valid = False
                        error_text = "Table/Value Combination: " + table + " " + as_unicode(value)
                elif table == "books: series_index":
                    value = as_unicode(value)
                    for c in value:
                        if c in ".0123456789":        #  0.5 is valid
                            pass
                        else:
                            is_valid = False
                            error_text = "Table/Value Combination: " + table + " " + as_unicode(value)
                            break
                    #END FOR
        else:
            pass

        return is_valid,error_text
    #-----------------------------------------------------------------------------------------------
    def build_final_filter_invalid_combinations_sets(self):

        self.final_filter_invalid_combinations_table_operator_set = set()

        self.final_filter_invalid_combinations_table_operator_set.add(("authors: name") + "True")
        self.final_filter_invalid_combinations_table_operator_set.add(("authors: name") + "False")
        self.final_filter_invalid_combinations_table_operator_set.add(("authors: name") + "NULL")

        self.final_filter_invalid_combinations_table_operator_set.add(("authors: sort") + "True")
        self.final_filter_invalid_combinations_table_operator_set.add(("authors: sort") + "False")
        self.final_filter_invalid_combinations_table_operator_set.add(("authors: sort") + "NULL")

        self.final_filter_invalid_combinations_table_operator_set.add(("books: has_cover") + "LIKE")    # boolean
        self.final_filter_invalid_combinations_table_operator_set.add(("books: has_cover") + "NULL")
        self.final_filter_invalid_combinations_table_operator_set.add(("books: has_cover") + "REGEX")
        self.final_filter_invalid_combinations_table_operator_set.add(("books: has_cover") + "=")
        self.final_filter_invalid_combinations_table_operator_set.add(("books: has_cover") + ">")
        self.final_filter_invalid_combinations_table_operator_set.add(("books: has_cover") + ">=")
        self.final_filter_invalid_combinations_table_operator_set.add(("books: has_cover") + "<")
        self.final_filter_invalid_combinations_table_operator_set.add(("books: has_cover") + "<=")
        self.final_filter_invalid_combinations_table_operator_set.add(("books: has_cover") + "!=")

        self.final_filter_invalid_combinations_table_operator_set.add(("books: path") + "True")
        self.final_filter_invalid_combinations_table_operator_set.add(("books: path") + "False")
        self.final_filter_invalid_combinations_table_operator_set.add(("books: path") + "NULL")

        self.final_filter_invalid_combinations_table_operator_set.add(("books: pubdate") + "True")     # datetime
        self.final_filter_invalid_combinations_table_operator_set.add(("books: pubdate") + "False")
        self.final_filter_invalid_combinations_table_operator_set.add(("books: pubdate") + "NULL")

        self.final_filter_invalid_combinations_table_operator_set.add(("books: title") + "True")
        self.final_filter_invalid_combinations_table_operator_set.add(("books: title") + "False")
        self.final_filter_invalid_combinations_table_operator_set.add(("books: title") + "NULL")

        self.final_filter_invalid_combinations_table_operator_set.add(("books: series_index") + "True")   # integer
        self.final_filter_invalid_combinations_table_operator_set.add(("books: series_index") + "False")
        self.final_filter_invalid_combinations_table_operator_set.add(("books: series_index") + "NULL")

        self.final_filter_invalid_combinations_table_operator_set.add(("publishers: name") + "True")
        self.final_filter_invalid_combinations_table_operator_set.add(("publishers: name") + "False")
        self.final_filter_invalid_combinations_table_operator_set.add(("publishers: name") + "NULL")

        self.final_filter_invalid_combinations_table_operator_set.add(("series: name") + "True")
        self.final_filter_invalid_combinations_table_operator_set.add(("series: name") + "False")
        self.final_filter_invalid_combinations_table_operator_set.add(("series: name") + "NULL")

        self.final_filter_invalid_combinations_table_operator_set.add(("tags: name") + "True")
        self.final_filter_invalid_combinations_table_operator_set.add(("tags: name") + "False")
        self.final_filter_invalid_combinations_table_operator_set.add(("tags: name") + "NULL")

        self.final_filter_invalid_combinations_table_operator_set.add(("comments: text") + "True")
        self.final_filter_invalid_combinations_table_operator_set.add(("comments: text") + "False")
        self.final_filter_invalid_combinations_table_operator_set.add(("comments: text") + "NULL")

        self.final_filter_invalid_combinations_table_operator_set.add(("data: format") + "True")
        self.final_filter_invalid_combinations_table_operator_set.add(("data: format") + "False")
        self.final_filter_invalid_combinations_table_operator_set.add(("data: format") + "NULL")

        self.final_filter_invalid_combinations_table_operator_set.add(("identifiers: type") + "LIKE")   # special case...
        self.final_filter_invalid_combinations_table_operator_set.add(("identifiers: type") + "True")
        self.final_filter_invalid_combinations_table_operator_set.add(("identifiers: type") + "False")
        self.final_filter_invalid_combinations_table_operator_set.add(("identifiers: type") + "NULL")
        self.final_filter_invalid_combinations_table_operator_set.add(("identifiers: type") + "REGEX")
        self.final_filter_invalid_combinations_table_operator_set.add(("identifiers: type") + "=")
        self.final_filter_invalid_combinations_table_operator_set.add(("identifiers: type") + ">")
        self.final_filter_invalid_combinations_table_operator_set.add(("identifiers: type") + ">=")
        self.final_filter_invalid_combinations_table_operator_set.add(("identifiers: type") + "<")
        self.final_filter_invalid_combinations_table_operator_set.add(("identifiers: type") + "<=")
        self.final_filter_invalid_combinations_table_operator_set.add(("identifiers: type") + "!=")

        self.final_filter_invalid_combinations_table_operator_set.add(("bool") + "LIKE")                   # custom column:   datatype = bool
        self.final_filter_invalid_combinations_table_operator_set.add(("bool") + "NULL")
        self.final_filter_invalid_combinations_table_operator_set.add(("bool") + "REGEX")
        self.final_filter_invalid_combinations_table_operator_set.add(("bool") + "=")
        self.final_filter_invalid_combinations_table_operator_set.add(("bool") + ">")
        self.final_filter_invalid_combinations_table_operator_set.add(("bool") + ">=")
        self.final_filter_invalid_combinations_table_operator_set.add(("bool") + "<")
        self.final_filter_invalid_combinations_table_operator_set.add(("bool") + "<=")
        self.final_filter_invalid_combinations_table_operator_set.add(("bool") + "!=")

        self.final_filter_invalid_combinations_table_operator_set.add(("datetime") + "True")          # custom column: datatype = datetime
        self.final_filter_invalid_combinations_table_operator_set.add(("datetime") + "False")
        self.final_filter_invalid_combinations_table_operator_set.add(("datetime") + "NULL")

        self.final_filter_invalid_combinations_table_operator_set.add(("series") + "True")              # custom column: datatype = series
        self.final_filter_invalid_combinations_table_operator_set.add(("series") + "False")
        self.final_filter_invalid_combinations_table_operator_set.add(("series") + "NULL")
        self.final_filter_invalid_combinations_table_operator_set.add(("series") + ">")
        self.final_filter_invalid_combinations_table_operator_set.add(("series") + ">=")
        self.final_filter_invalid_combinations_table_operator_set.add(("series") + "<")
        self.final_filter_invalid_combinations_table_operator_set.add(("series") + "<=")
    #-----------------------------------------------------------------------------------------------
    def build_qt_object_dicts(self):

        try:
            del self.qt_final_filters_tab_filter_checkbox_objects_dict
            del self.qt_final_filters_tab_table_combobox_objects_dict
            del self.qt_final_filters_tab_isnot_combobox_objects_dict
            del self.qt_final_filters_tab_operators_combobox_objects_dict
            del self.qt_final_filters_tab_value_qlineedit_objects_dict
            del self.qt_final_filters_tab_andornot_combobox_objects_dict
        except:
            pass

        self.qt_final_filters_tab_filter_checkbox_objects_dict = {}
        self.qt_final_filters_tab_table_combobox_objects_dict = {}
        self.qt_final_filters_tab_isnot_combobox_objects_dict = {}
        self.qt_final_filters_tab_operators_combobox_objects_dict = {}
        self.qt_final_filters_tab_value_qlineedit_objects_dict = {}
        self.qt_final_filters_tab_andornot_combobox_objects_dict = {}

        self.qt_final_filters_tab_filter_checkbox_objects_dict[0] = self.checkbox_filter_0
        self.qt_final_filters_tab_table_combobox_objects_dict[0] = self.table_0_combobox
        self.qt_final_filters_tab_isnot_combobox_objects_dict[0] = self.isnot_0_combobox
        self.qt_final_filters_tab_operators_combobox_objects_dict[0] = self.operators_0_combobox
        self.qt_final_filters_tab_value_qlineedit_objects_dict[0] = self.qlineedit_value_0
        self.qt_final_filters_tab_andornot_combobox_objects_dict[0] = self.andornot_0_combobox

        self.qt_final_filters_tab_filter_checkbox_objects_dict[1] = self.checkbox_filter_1
        self.qt_final_filters_tab_table_combobox_objects_dict[1] = self.table_1_combobox
        self.qt_final_filters_tab_isnot_combobox_objects_dict[1] = self.isnot_1_combobox
        self.qt_final_filters_tab_operators_combobox_objects_dict[1] = self.operators_1_combobox
        self.qt_final_filters_tab_value_qlineedit_objects_dict[1] = self.qlineedit_value_1
        self.qt_final_filters_tab_andornot_combobox_objects_dict[1] = self.andornot_1_combobox

        self.qt_final_filters_tab_filter_checkbox_objects_dict[2] = self.checkbox_filter_2
        self.qt_final_filters_tab_table_combobox_objects_dict[2] = self.table_2_combobox
        self.qt_final_filters_tab_isnot_combobox_objects_dict[2] = self.isnot_2_combobox
        self.qt_final_filters_tab_operators_combobox_objects_dict[2] = self.operators_2_combobox
        self.qt_final_filters_tab_value_qlineedit_objects_dict[2] = self.qlineedit_value_2
        self.qt_final_filters_tab_andornot_combobox_objects_dict[2] = self.andornot_2_combobox

        self.qt_final_filters_tab_filter_checkbox_objects_dict[3] = self.checkbox_filter_3
        self.qt_final_filters_tab_table_combobox_objects_dict[3] = self.table_3_combobox
        self.qt_final_filters_tab_isnot_combobox_objects_dict[3] = self.isnot_3_combobox
        self.qt_final_filters_tab_operators_combobox_objects_dict[3] = self.operators_3_combobox
        self.qt_final_filters_tab_value_qlineedit_objects_dict[3] = self.qlineedit_value_3
        self.qt_final_filters_tab_andornot_combobox_objects_dict[3] = self.andornot_3_combobox

        self.qt_final_filters_tab_filter_checkbox_objects_dict[4] = self.checkbox_filter_4
        self.qt_final_filters_tab_table_combobox_objects_dict[4] = self.table_4_combobox
        self.qt_final_filters_tab_isnot_combobox_objects_dict[4] = self.isnot_4_combobox
        self.qt_final_filters_tab_operators_combobox_objects_dict[4] = self.operators_4_combobox
        self.qt_final_filters_tab_value_qlineedit_objects_dict[4] = self.qlineedit_value_4
        self.qt_final_filters_tab_andornot_combobox_objects_dict[4] = self.andornot_4_combobox

        self.qt_final_filters_tab_filter_checkbox_objects_dict[5] = self.checkbox_filter_5
        self.qt_final_filters_tab_table_combobox_objects_dict[5] = self.table_5_combobox
        self.qt_final_filters_tab_isnot_combobox_objects_dict[5] = self.isnot_5_combobox
        self.qt_final_filters_tab_operators_combobox_objects_dict[5] = self.operators_5_combobox
        self.qt_final_filters_tab_value_qlineedit_objects_dict[5] = self.qlineedit_value_5
        self.qt_final_filters_tab_andornot_combobox_objects_dict[5] = self.andornot_5_combobox

        self.qt_final_filters_tab_filter_checkbox_objects_dict[6] = self.checkbox_filter_6
        self.qt_final_filters_tab_table_combobox_objects_dict[6] = self.table_6_combobox
        self.qt_final_filters_tab_isnot_combobox_objects_dict[6] = self.isnot_6_combobox
        self.qt_final_filters_tab_operators_combobox_objects_dict[6] = self.operators_6_combobox
        self.qt_final_filters_tab_value_qlineedit_objects_dict[6] = self.qlineedit_value_6
        self.qt_final_filters_tab_andornot_combobox_objects_dict[6] = self.andornot_6_combobox

        self.qt_final_filters_tab_filter_checkbox_objects_dict[7] = self.checkbox_filter_7
        self.qt_final_filters_tab_table_combobox_objects_dict[7] = self.table_7_combobox
        self.qt_final_filters_tab_isnot_combobox_objects_dict[7] = self.isnot_7_combobox
        self.qt_final_filters_tab_operators_combobox_objects_dict[7] = self.operators_7_combobox
        self.qt_final_filters_tab_value_qlineedit_objects_dict[7] = self.qlineedit_value_7
        self.qt_final_filters_tab_andornot_combobox_objects_dict[7] = self.andornot_7_combobox

        self.qt_final_filters_tab_filter_checkbox_objects_dict[8] = self.checkbox_filter_8
        self.qt_final_filters_tab_table_combobox_objects_dict[8] = self.table_8_combobox
        self.qt_final_filters_tab_isnot_combobox_objects_dict[8] = self.isnot_8_combobox
        self.qt_final_filters_tab_operators_combobox_objects_dict[8] = self.operators_8_combobox
        self.qt_final_filters_tab_value_qlineedit_objects_dict[8] = self.qlineedit_value_8
        self.qt_final_filters_tab_andornot_combobox_objects_dict[8] = self.andornot_8_combobox

        self.qt_final_filters_tab_filter_checkbox_objects_dict[9] = self.checkbox_filter_9
        self.qt_final_filters_tab_table_combobox_objects_dict[9] = self.table_9_combobox
        self.qt_final_filters_tab_isnot_combobox_objects_dict[9] = self.isnot_9_combobox
        self.qt_final_filters_tab_operators_combobox_objects_dict[9] = self.operators_9_combobox
        self.qt_final_filters_tab_value_qlineedit_objects_dict[9] = self.qlineedit_value_9
        self.qt_final_filters_tab_andornot_combobox_objects_dict[9] = self.andornot_9_combobox
    #--------------------------------------------------------------------------------------------------
    def check_all_checkboxes(self):
        self.checkbox_filter_0.setChecked(True)
        self.checkbox_filter_1.setChecked(True)
        self.checkbox_filter_2.setChecked(True)
        self.checkbox_filter_3.setChecked(True)
        self.checkbox_filter_4.setChecked(True)
        self.checkbox_filter_5.setChecked(True)
        self.checkbox_filter_6.setChecked(True)
        self.checkbox_filter_7.setChecked(True)
        self.checkbox_filter_8.setChecked(True)
        self.checkbox_filter_9.setChecked(True)
    #--------------------------------------------------------------------------------------------------
    def uncheck_all_checkboxes(self):
        self.checkbox_filter_0.setChecked(False)
        self.checkbox_filter_1.setChecked(False)
        self.checkbox_filter_2.setChecked(False)
        self.checkbox_filter_3.setChecked(False)
        self.checkbox_filter_4.setChecked(False)
        self.checkbox_filter_5.setChecked(False)
        self.checkbox_filter_6.setChecked(False)
        self.checkbox_filter_7.setChecked(False)
        self.checkbox_filter_8.setChecked(False)
        self.checkbox_filter_9.setChecked(False)
    #--------------------------------------------------------------------------------------------------
    def load_criteria_settings_finalfiltertab(self):
        self.load_criteria_settings_generic(current_tab=FINALFILTERTAB)
    #--------------------------------------------------------------------------------------------------
    def unpack_selected_parm_finalfiltertab(self,selected_parm,parm_dict):

        n = selected_parm[-1: ]
        if n.isdigit and isinstance(parm_dict,dict):
            n = int(n)
        else:
            if DEBUG: print("FinalFilterTab: parm and/or parm_dict to restore is corrupt; nothing can be done...")
            return False

        saveddate,type,vdict,parm = parm_dict[n]   #for actual restoration of loaded criteria

        if saveddate.startswith("["):  #name is dynamically shown to the user in a combobox item
            n = saveddate.find("]:")
            if n > -1:
                saveddate = saveddate[n+2: ]

        if DEBUG:
            for k, v in iteritems(vdict):
                print(as_unicode(k), " = ", as_unicode(v))

        self.load_saved_filter_values(source=vdict)

        self.update()

        if DEBUG: print("*** All FinalFilterTab widgets have been reset per loaded criteria selected by user ***")

        return True
#--------------------------------------------------------------------------------------------------
#--------------------------------------------------------------------------------------------------
#--------------------------------------------------------------------------------------------------
#--------------------------------------------------------------------------------------------------
class MCSSpecialQueriesTab(QWidget):
    # a.k.a. "Special Queries"
    prefs = None
    #-----------------------------------------------------------------------------------------------
    def __init__(self,gui,icon,guidb,mcsprefs,current_library_path,special_query_control,custom_column_label_dict,custom_column_datatype_dict,custom_column_normalized_dict,
                        load_criteria_settings_generic,create_criteria_parm_list_generic,save_settings_parm_history_to_prefs_generic,unpack_selected_parm_generic):

        super(MCSSpecialQueriesTab, self).__init__()

        self.gui = gui
        self.icon = icon
        self.guidb = guidb

        global prefs
        prefs = mcsprefs

        self.current_library_path = current_library_path
        self.special_query_control = special_query_control
        self.custom_column_label_dict = custom_column_label_dict
        self.custom_column_datatype_dict = custom_column_datatype_dict
        self.custom_column_normalized_dict = custom_column_normalized_dict
        self.load_criteria_settings_generic = load_criteria_settings_generic
        self.create_criteria_parm_list_generic = create_criteria_parm_list_generic
        self.save_settings_parm_history_to_prefs_generic = save_settings_parm_history_to_prefs_generic
        self.unpack_selected_parm_generic = unpack_selected_parm_generic
        #-----------------------------------------------------
        #-----------------------------------------------------
        #-----------------------------------------------------
        #-----------------------------------------------------
        font = QFont()
        font.setBold(False)
        font.setPointSize(8)
        #-----------------------------------------------------
        self.layout_frame = QGridLayout()
        self.layout_frame.setSpacing(0)
        self.layout_frame.setContentsMargins(QMargins(0,0,0,0));
        self.setLayout(self.layout_frame)
        self.setToolTip("<p style='white-space:wrap'>This Tab is used to execute a few powerful queries against only a few standard Calibre columns (but all 'text' Custom Columns) for the purpose of finding metadata that needs correction.\
                                                                                <br><br>The chosen columns are evaluated for all books using all possible values found in the current library.\
                                                                                <br><br>For example, the query 'books: title CONTAINS author: name' compares all known author names in the current library to all book titles in the current library. \
                                                                                <br><br>Up to three different table comparisons may be made simultaneously.  Only the first table comparison is required; the two lower comparisons may be set to 'Inactive'.\
                                                                                <br><br>Caution: 'Authors' that are bogus or only one (1) word (or worse, only a few letters such as 'Avi' or 'An') will cause unexpected matches. \
                                                                                <br><br>Example: if you have an 'Author' with the full name of 'Other', then any Title containing the letter sequence (substring) 'other' will be viewed as a match.  Example:  'Band of Brothers'.\
                                                                                <br><br>Example: if you have an 'Author' with the full name of 'Joy', then any Title containing the letter sequence (substring) 'joy' will be viewed as a match.  Example:  'Killjoy'.\
                                                                                <br><br>If you have a few of these problem 'Authors', you could use the 'Final Filters' option to filter them out.  Or, you can change their names permanently.\
                                                                                <br><br>The above caution also applies to 'Series' (and even more so) since a 'Series' may be anything whatsoever. ")
        #-----------------------------------------------------
        #-----------------------------------------------------
        # 1st Choice
        #-----------------------------------------------------
        #-----------------------------------------------------
        self.table_1a_combobox = QComboBox()
        self.table_1a_combobox.setEditable(False)
        self.table_1a_combobox.setFont(font)
        self.table_1a_combobox.setMaximumWidth(250)
        self.layout_frame.addWidget(self.table_1a_combobox,0,0)

        self.valid_tables_list = []
        self.valid_tables_list.append("authors: name")
        self.valid_tables_list.append("books: title")
        self.valid_tables_list.append("series: name")
        try:
            for table in self.valid_tables_list:
                table = as_unicode(table)
                self.table_1a_combobox.addItem(table)
            #END FOR
        except Exception as e:
            if DEBUG: print(as_unicode(e))

        tmp_list = []
        #~ self.custom_column_label_dict                     label = id        and label includes the #
        #~ self.custom_column_datatype_dict               id = datatype
        #~ self.custom_column_normalized_dict           id = normalized     0 or 1
        for label,id in iteritems(self.custom_column_label_dict):
            if id in self.custom_column_normalized_dict:
                normalized = self.custom_column_normalized_dict[id]
                if normalized == 1:
                    if id in self.custom_column_datatype_dict:
                        datatype = self.custom_column_datatype_dict[id]
                        if datatype == "text" or datatype == "series":
                            s = "cc: " + label
                            tmp_list.append(s)
        #END FOR
        tmp_list.sort()

        try:
            for table in tmp_list:
                self.valid_tables_list.append(table)
                table = as_unicode(table)
                self.table_1a_combobox.addItem(table)
            #END FOR
        except Exception as e:
            if DEBUG: print(as_unicode(e))

        self.table_1a_combobox.setCurrentIndex(1)  # books: title

        self.table_tooltip = "<p style='white-space:wrap'>Select the Calibre Column to be compared to the other Calibre Column.  The choices are limited to those shown."
        self.table_1a_combobox.setToolTip(self.table_tooltip)

        #-----------------------------------------------------
        #-----------------------------------------------------
        self.operator1_combobox = QComboBox()
        self.operator1_combobox.setEditable(False)
        self.operator1_combobox.setFont(font)
        self.operator1_combobox.setMaximumWidth(150)
        self.layout_frame.addWidget(self.operator1_combobox,0,1)

        self.operator_list = []
        self.operator_list.append('CONTAINS')
        self.operator_list.append('EQUALS')

        try:
            for item in self.operator_list:
                self.operator1_combobox.addItem(item)
            #END FOR
        except Exception as e:
            if DEBUG: print(as_unicode(e))
            pass

        self.operator_tooltip = "<p style='white-space:wrap'>Select the operator you wish to use.  The choices are limited to those shown."
        self.operator1_combobox.setToolTip(self.operator_tooltip)
        #-----------------------------------------------------
        #-----------------------------------------------------

        #-----------------------------------------------------
        #-----------------------------------------------------
        #-----------------------------------------------------
        self.table_1b_combobox = QComboBox()
        self.table_1b_combobox.setEditable(False)
        self.table_1b_combobox.setFont(font)
        self.table_1b_combobox.setMaximumWidth(250)
        self.layout_frame.addWidget(self.table_1b_combobox,0,2)

        try:
            for table in self.valid_tables_list:
                table = as_unicode(table)
                self.table_1b_combobox.addItem(table)
            #END FOR
        except Exception as e:
            if DEBUG: print(as_unicode(e))

        self.table_1b_combobox.setCurrentIndex(0)  # authors: name

        self.table_tooltip = "<p style='white-space:wrap'>Select the Calibre Column for comparison.  The choices are limited to those shown."
        self.table_1b_combobox.setToolTip(self.table_tooltip)
        #-----------------------------------------------------
        #-----------------------------------------------------
        #-----------------------------------------------------
        radio_tool_tip = "<p style='white-space:wrap'>ANDs and ORs may not be used simultaneously.\
                                                                                    <br><br>If the upper choice is AND, then the lower choice may not be OR.\
                                                                                    <br><br>The lower choice may always be INACTIVE, regardless of the upper choice.\
                                                                                    <br><br>If the upper choice is INACTIVE, then the lower choice must be INACTIVE."
        self.choice1a_radio = QRadioButton('AND')
        self.choice1a_radio.setToolTip(radio_tool_tip)
        self.layout_frame.addWidget(self.choice1a_radio,1,0)
        self.choice1b_radio = QRadioButton('OR')
        self.choice1b_radio.setToolTip(radio_tool_tip)
        self.layout_frame.addWidget(self.choice1b_radio,2,0)
        self.choice1c_radio = QRadioButton('Inactive')
        self.choice1c_radio.setToolTip(radio_tool_tip)
        self.layout_frame.addWidget(self.choice1c_radio,3,0)
        self.choice1_button_group = QButtonGroup(self.layout_frame)
        self.choice1_button_group.addButton(self.choice1a_radio)
        self.choice1_button_group.addButton(self.choice1b_radio)
        self.choice1_button_group.addButton(self.choice1c_radio)

        self.choice1b_radio.setChecked(True)

        #-----------------------------------------------------
        #-----------------------------------------------------
        #-----------------------------------------------------
        # 2nd Choice
        #-----------------------------------------------------
        #-----------------------------------------------------
        #-----------------------------------------------------
        self.table_2a_combobox = QComboBox()
        self.table_2a_combobox.setEditable(False)
        self.table_2a_combobox.setFont(font)
        self.table_2a_combobox.setMaximumWidth(250)
        self.layout_frame.addWidget(self.table_2a_combobox,5,0)

        try:
            for table in self.valid_tables_list:
                table = as_unicode(table)
                self.table_2a_combobox.addItem(table)
            #END FOR
        except Exception as e:
            if DEBUG: print(as_unicode(e))
            pass

        try:
            for table in tmp_list:
                self.valid_tables_list.append(table)
                table = as_unicode(table)
                self.table_2a_combobox.addItem(table)
            #END FOR
        except Exception as e:
            if DEBUG: print(as_unicode(e))
            pass

        self.table_2a_combobox.setCurrentIndex(0)  # authors.name

        self.table_tooltip = "<p style='white-space:wrap'>Select the Calibre Column to be compared to the other Calibre Column.  The choices are limited to those shown."
        self.table_2a_combobox.setToolTip(self.table_tooltip)

        #-----------------------------------------------------
        #-----------------------------------------------------
        self.operator2_combobox = QComboBox()
        self.operator2_combobox.setEditable(False)
        self.operator2_combobox.setFont(font)
        self.operator2_combobox.setMaximumWidth(150)
        self.layout_frame.addWidget(self.operator2_combobox,5,1)

        try:
            for item in self.operator_list:
                self.operator2_combobox.addItem(item)
            #END FOR
        except Exception as e:
            if DEBUG: print(as_unicode(e))
            pass

        self.operator_tooltip = "<p style='white-space:wrap'>Select the operator you wish to use.  The choices are limited to those shown."
        self.operator2_combobox.setToolTip(self.operator_tooltip)
        #-----------------------------------------------------
        #-----------------------------------------------------

        #-----------------------------------------------------
        #-----------------------------------------------------
        #-----------------------------------------------------
        self.table_2b_combobox = QComboBox()
        self.table_2b_combobox.setEditable(False)
        self.table_2b_combobox.setFont(font)
        self.table_2b_combobox.setMaximumWidth(250)
        self.layout_frame.addWidget(self.table_2b_combobox,5,2)

        try:
            for table in self.valid_tables_list:
                table = as_unicode(table)
                self.table_2b_combobox.addItem(table)
            #END FOR
        except Exception as e:
            if DEBUG: print(as_unicode(e))
            pass

        self.table_2b_combobox.setCurrentIndex(1)  # books.title

        self.table_tooltip = "<p style='white-space:wrap'>Select the Calibre Column for comparison.  The choices are limited to those shown."
        self.table_2b_combobox.setToolTip(self.table_tooltip)
        #-----------------------------------------------------
        #-----------------------------------------------------
        #-----------------------------------------------------
        self.choice2a_radio = QRadioButton('AND')
        self.choice2a_radio.setToolTip(radio_tool_tip)
        self.layout_frame.addWidget(self.choice2a_radio,6,0)
        self.choice2b_radio = QRadioButton('OR')
        self.choice2b_radio.setToolTip(radio_tool_tip)
        self.layout_frame.addWidget(self.choice2b_radio,7,0)
        self.choice2c_radio = QRadioButton('Inactive')
        self.choice2c_radio.setToolTip(radio_tool_tip)
        self.layout_frame.addWidget(self.choice2c_radio,8,0)
        self.choice2_button_group = QButtonGroup(self.layout_frame)
        self.choice2_button_group.addButton(self.choice2a_radio)
        self.choice2_button_group.addButton(self.choice2b_radio)
        self.choice2_button_group.addButton(self.choice2c_radio)

        self.choice2b_radio.setChecked(True)
        #-----------------------------------------------------
        #-----------------------------------------------------
        #-----------------------------------------------------
        # 3d Choice
        #-----------------------------------------------------
        #-----------------------------------------------------
        #-----------------------------------------------------
        self.table_3a_combobox = QComboBox()
        self.table_3a_combobox.setEditable(False)
        self.table_3a_combobox.setFont(font)
        self.table_3a_combobox.setMaximumWidth(250)
        self.layout_frame.addWidget(self.table_3a_combobox,9,0)

        try:
            for table in self.valid_tables_list:
                table = as_unicode(table)
                self.table_3a_combobox.addItem(table)
            #END FOR
        except Exception as e:
            if DEBUG: print(as_unicode(e))
            pass

        try:
            for table in tmp_list:
                self.valid_tables_list.append(table)
                table = as_unicode(table)
                self.table_3a_combobox.addItem(table)
            #END FOR
        except Exception as e:
            if DEBUG: print(as_unicode(e))
            pass

        self.table_3a_combobox.setCurrentIndex(1)  # books: title

        self.table_tooltip = "<p style='white-space:wrap'>Select the Calibre Column to be compared to the other Calibre Column.  The choices are limited to those shown."
        self.table_3a_combobox.setToolTip(self.table_tooltip)

        #-----------------------------------------------------
        #-----------------------------------------------------
        self.operator3_combobox = QComboBox()
        self.operator3_combobox.setEditable(False)
        self.operator3_combobox.setFont(font)
        self.operator3_combobox.setMaximumWidth(150)
        self.layout_frame.addWidget(self.operator3_combobox,9,1)

        try:
            for item in self.operator_list:
                self.operator3_combobox.addItem(item)
            #END FOR
        except Exception as e:
            if DEBUG: print(as_unicode(e))
            pass

        self.operator_tooltip = "<p style='white-space:wrap'>Select the operator you wish to use.  The choices are limited to those shown."
        self.operator3_combobox.setToolTip(self.operator_tooltip)
        #-----------------------------------------------------
        #-----------------------------------------------------

        #-----------------------------------------------------
        #-----------------------------------------------------
        #-----------------------------------------------------
        self.table_3b_combobox = QComboBox()
        self.table_3b_combobox.setEditable(False)
        self.table_3b_combobox.setFont(font)
        self.table_3b_combobox.setMaximumWidth(250)
        self.layout_frame.addWidget(self.table_3b_combobox,9,2)

        try:
            for table in self.valid_tables_list:
                table = as_unicode(table)
                self.table_3b_combobox.addItem(table)
            #END FOR
        except Exception as e:
            if DEBUG: print(as_unicode(e))
            pass

        self.table_3b_combobox.setCurrentIndex(2)  # series.name

        self.table_tooltip = "<p style='white-space:wrap'>Select the Calibre Column for comparison.  The choices are limited to those shown."
        self.table_3b_combobox.setToolTip(self.table_tooltip)

        #-----------------------------------------------------
        #-----------------------------------------------------

        self.choice1a_radio.toggled.connect(self.andorignore_selected)
        self.choice1b_radio.toggled.connect(self.andorignore_selected)
        self.choice1c_radio.toggled.connect(self.andorignore_selected)

        self.choice2a_radio.toggled.connect(self.andorignore_selected)
        self.choice2b_radio.toggled.connect(self.andorignore_selected)
        self.choice2c_radio.toggled.connect(self.andorignore_selected)


        #-----------------------------------------------------
        #-----------------------------------------------------
        #-----------------------------------------------------
        #-----------------------------------------------------
        #-----------------------------------------------------
        self.activate_all_author_books_checkbox = QCheckBox()
        self.activate_all_author_books_checkbox.setText("All Authors' Books?")
        self.activate_all_author_books_checkbox.setFont(font)
        self.activate_all_author_books_checkbox.setToolTip("<p style='white-space:wrap'>Checking this box causes all books of every Author otherwise in the search results to also be marked and displayed.")

        self.layout_frame.addWidget(self.activate_all_author_books_checkbox,11,0)

        self.add_final_filters_checkbox = QCheckBox()
        self.add_final_filters_checkbox.setText("Use Final Filters?")
        self.add_final_filters_checkbox.setFont(font)
        self.add_final_filters_checkbox.setToolTip("<p style='white-space:wrap'>Checking this box causes the active filters defined in the Final Filters Tab to be used at the very end of the search.")

        self.layout_frame.addWidget(self.add_final_filters_checkbox,12,0)

        #-----------------------------------------------------
        #-----------------------------------------------------

        self.push_button_execute_special_query = QPushButton(" ", self)
        self.push_button_execute_special_query.setText("Save and Execute the Special Search Query [All Books]")
        self.push_button_execute_special_query.setToolTip("<p style='white-space:wrap'>Save (with a name) all criteria for this Tab, then Execute the specified Special Query [All Books].")
        self.push_button_execute_special_query.setMinimumWidth(300)
        self.push_button_execute_special_query.setMaximumWidth(600)
        self.push_button_execute_special_query.clicked.connect(self.execute_special_query)
        self.layout_frame.addWidget(self.push_button_execute_special_query,13,0)

        self.push_button_load_saved_criteria_values = QPushButton(" ", self)
        self.push_button_load_saved_criteria_values.setText("Load Previously Saved Criteria?")
        self.push_button_load_saved_criteria_values.setToolTip("<p style='white-space:wrap'>Select a previously saved (with a name) set of criteria for this Tab.<br><br>The checkmarks for All Authors' Books and Use Final Filters are not saved, and must be selected separately for each executed Query.")

        self.push_button_load_saved_criteria_values.clicked.connect(self.load_criteria_settings_specialqueriestab)
        self.layout_frame.addWidget(self.push_button_load_saved_criteria_values,13,1)
        #-----------------------------------------------------
        #-----------------------------------------------------
        #-----------------------------------------------------
        self.resize(self.sizeHint())
        #-----------------------------------------------------
        #-----------------------------------------------------
    #-----------------------------------------------------------------------------------------------
    #-----------------------------------------------------------------------------------------------
    #-----------------------------------------------------------------------------------------------
    def execute_special_query(self):

        global prefs

        param_dict = {}

        #---------------------------------------
        val1 = self.table_1a_combobox.currentText()
        param_dict['TABLE_1_1'] = as_unicode(val1)

        val2 = self.operator1_combobox.currentText()
        param_dict['OPERATOR_1'] = as_unicode(val2)

        val3 = self.table_1b_combobox.currentText()
        param_dict['TABLE_1_2'] = as_unicode(val3)

        if val1 == val3:
            error_dialog(self.gui, _('MCS'),_(("Left Table is Identical to Right Table.  Execution Canceled. ")), show=True)
            del param_dict
            return

        if self.choice1a_radio.isChecked():
            param_dict['SPECIAL_QUERY_AND_OR_INACTIVE_1'] = "AND"
        elif self.choice1b_radio.isChecked():
            param_dict['SPECIAL_QUERY_AND_OR_INACTIVE_1'] = "OR"
        else:
            param_dict['SPECIAL_QUERY_AND_OR_INACTIVE_1'] = "INACTIVE"
            self.choice2c_radio.setChecked(True)
            self.repaint()

        #---------------------------------------
        val1 = self.table_2a_combobox.currentText()
        param_dict['TABLE_2_1'] = as_unicode(val1)

        val2 = self.operator2_combobox.currentText()
        param_dict['OPERATOR_2'] = as_unicode(val2)

        val3 = self.table_2b_combobox.currentText()
        param_dict['TABLE_2_2'] = as_unicode(val3)

        if val1 == val3:
            if not self.choice1c_radio.isChecked():
                error_dialog(self.gui, _('MCS'),_(("Left Table is Identical to Right Table.  Execution Canceled. ")), show=True)
                del param_dict
                return

        if self.choice2a_radio.isChecked():
            param_dict['SPECIAL_QUERY_AND_OR_INACTIVE_2'] = "AND"
        elif self.choice2b_radio.isChecked():
            param_dict['SPECIAL_QUERY_AND_OR_INACTIVE_2'] = "OR"
        else:
            param_dict['SPECIAL_QUERY_AND_OR_INACTIVE_2'] = "INACTIVE"

        #---------------------------------------
        val1 = self.table_3a_combobox.currentText()
        param_dict['TABLE_3_1'] = as_unicode(val1)

        val2 = self.operator3_combobox.currentText()
        param_dict['OPERATOR_3'] = as_unicode(val2)

        val3 = self.table_3b_combobox.currentText()
        param_dict['TABLE_3_2'] = as_unicode(val3)

        if val1 == val3:
            if not self.choice2c_radio.isChecked():
                error_dialog(self.gui, _('MCS'),_(("Left Table is Identical to Right Table.  Execution Canceled. ")), show=True)
                del param_dict
                return

        #---------------------------------------
        param_dict['ALL_AUTHORS_BOOKS'] = "False"
        param_dict['USE_FINAL_FILTERS'] = "False"
        if self.add_final_filters_checkbox.isChecked():
            param_dict['USE_FINAL_FILTERS'] = "True"
        if self.activate_all_author_books_checkbox.isChecked():
            param_dict['ALL_AUTHORS_BOOKS'] = "True"

        if self.add_final_filters_checkbox.isChecked():
            if  prefs['FINAL_FILTERS_LAST_SAVED'] != prefs['FINAL_FILTERS_LAST_VALIDATED']:
                error_dialog(self.gui, _('MCS'),_(("Final Filters have not been Validated since they were last Saved.<br><br>\
                                                                    Execution Canceled. ")), show=True)
                del param_dict
                return
            if prefs['FINAL_FILTERS_PASSED_VALIDATION'] != "True" and prefs['USE_FINAL_FILTERS'] == "True":
                error_dialog(self.gui, _('MCS'),_(("Final Filters failed Validation.  They cannot be used until they pass.<br><br>\
                                                                    Execution Canceled. ")), show=True)
                del param_dict
                return

        #~ ----------------------------------------------------------------------------------
        #~ Save actual values temporarily
        #~ ----------------------------------------------------------------------------------
        save1 = param_dict['ALL_AUTHORS_BOOKS']
        save2 = param_dict['USE_FINAL_FILTERS']
        #~ ----------------------------------------------------------------------------------
        #~ These 2 options are selected at query execution time only, and never saved
        #~ ----------------------------------------------------------------------------------
        param_dict['ALL_AUTHORS_BOOKS'] = "False"
        param_dict['USE_FINAL_FILTERS'] = "False"
        #~ ----------------------------------------------------------------------------------
        param_dict[SPECIAL_QUERIES_TYPE] = SPECIAL_QUERIES_TYPE
        current_tab = SPECIALQUERIESTAB
        prefs = self.save_settings_parm_history_to_prefs_generic(prefs,current_tab,param_dict)
        prefs
        #~ ----------------------------------------------------------------------------------
        #~ Restore saved values after self.save_settings_parm_history_to_prefs_generic()
        #~ ----------------------------------------------------------------------------------
        param_dict['ALL_AUTHORS_BOOKS'] = save1
        param_dict['USE_FINAL_FILTERS'] = save2
        #~ ----------------------------------------------------------------------------------
        self.special_query_control(self.guidb,param_dict,self.current_library_path)
        #~ ----------------------------------------------------------------------------------
        del param_dict
    #-----------------------------------------------------------------------------------------------
    def andorignore_selected(self,event):
        # the event 'toggled' is connected to this function for radiobuttons

        #rule: either both ANDs or both ORs, but never a mixture.
        #rule: if the upper Inactive is checked, then the lower Inactive must also be checked.

        if self.choice1c_radio.isChecked():  # first Inactive
            self.choice2c_radio.setChecked(True)  #second inactive

        if not self.choice2c_radio.isChecked():  # second Inactive
            if self.choice1a_radio.isChecked():  # first AND
                self.choice2a_radio.setChecked(True)  #second AND
            elif self.choice1b_radio.isChecked():  # first OR
                self.choice2b_radio.setChecked(True)  #second OR

        self.repaint()
    #-----------------------------------------------------------------------------------------------
    #-----------------------------------------------------------------------------------------------
    def load_criteria_settings_specialqueriestab(self):
        self.load_criteria_settings_generic(current_tab=SPECIALQUERIESTAB)
    #-----------------------------------------------------------------------------------------------
    def unpack_selected_parm_specialqueriestab(self,selected_parm,parm_dict):

        n = selected_parm[-1: ]
        if n.isdigit and isinstance(parm_dict,dict):
            n = int(n)
        else:
            if DEBUG: print("specialqueriestab: parm and/or parm_dict to restore is corrupt; nothing can be done...")
            return False

        saveddate,type,vdict,parm = parm_dict[n]   #for actual restoration of loaded criteria

        if DEBUG:
            for k, v in iteritems(vdict):
                print(as_unicode(k), " = ", as_unicode(v))

        val1 = vdict['TABLE_1_1']
        i = self.table_1a_combobox.findText(val1)
        self.table_1a_combobox.setCurrentIndex(i)

        val2 = vdict['OPERATOR_1']
        i = self.operator1_combobox.findText(val2)
        self.operator1_combobox.setCurrentIndex(i)

        val3 = vdict['TABLE_1_2']
        i = self.table_1b_combobox.findText(val3)
        self.table_1b_combobox.setCurrentIndex(i)

        status = vdict['SPECIAL_QUERY_AND_OR_INACTIVE_1']
        if status == "AND":
            self.choice1a_radio.setChecked(True)
        elif status == "OR":
            self.choice1b_radio.setChecked(True)
        elif status == "INACTIVE":
            self.choice1c_radio.setChecked(True)

        val1 = vdict['TABLE_2_1']
        i = self.table_2a_combobox.findText(val1)
        self.table_2a_combobox.setCurrentIndex(i)

        val2 = vdict['OPERATOR_2']
        i = self.operator2_combobox.findText(val2)
        self.operator2_combobox.setCurrentIndex(i)

        val3 = vdict['TABLE_2_2']
        i = self.table_2b_combobox.findText(val3)
        self.table_2b_combobox.setCurrentIndex(i)

        status = vdict['SPECIAL_QUERY_AND_OR_INACTIVE_2']
        if status == "AND":
            self.choice2a_radio.setChecked(True)
        elif status == "OR":
            self.choice2b_radio.setChecked(True)
        elif status == "INACTIVE":
            self.choice2c_radio.setChecked(True)

        val1 = vdict['TABLE_3_1']
        i = self.table_3a_combobox.findText(val1)
        self.table_3a_combobox.setCurrentIndex(i)

        val2 = vdict['OPERATOR_3']
        i = self.operator3_combobox.findText(val2)
        self.operator3_combobox.setCurrentIndex(i)

        val3 = vdict['TABLE_3_2']
        i = self.table_3b_combobox.findText(val3)
        self.table_3b_combobox.setCurrentIndex(i)

        val4 = vdict['ALL_AUTHORS_BOOKS']
        if val4 == "True":
            self.activate_all_author_books_checkbox.setChecked(True)
        else:
            self.activate_all_author_books_checkbox.setChecked(False)

        val5 = vdict['USE_FINAL_FILTERS']
        if val5 == "True":
            self.add_final_filters_checkbox.setChecked(True)
        else:
            self.add_final_filters_checkbox.setChecked(False)

        self.update()

        if DEBUG: print("*** All specialqueriestab widgets have been reset per loaded criteria selected by user ***")

        return True
#--------------------------------------------------------------------------------------------------
#--------------------------------------------------------------------------------------------------
#--------------------------------------------------------------------------------------------------
#--------------------------------------------------------------------------------------------------
class MCSSimilarityTab(QWidget):
    # a.k.a. "Similarity Queries"
    prefs = None
    #-----------------------------------------------------------------------------------------------
    def __init__(self,gui,icon,guidb,mcsprefs,search_similarity_control,load_criteria_settings_generic, create_criteria_parm_list_generic,
                        save_settings_parm_history_to_prefs_generic,unpack_selected_parm_generic):

        super(MCSSimilarityTab, self).__init__()

        self.gui = gui
        self.icon = icon
        self.guidb = guidb

        global prefs
        prefs = mcsprefs

        self.search_similarity_control = search_similarity_control
        self.load_criteria_settings_generic = load_criteria_settings_generic
        self.create_criteria_parm_list_generic = create_criteria_parm_list_generic
        self.save_settings_parm_history_to_prefs_generic = save_settings_parm_history_to_prefs_generic
        self.unpack_selected_parm_generic = unpack_selected_parm_generic
        #-----------------------------------------------------
        #-----------------------------------------------------
        #-----------------------------------------------------
        #-----------------------------------------------------
        font = QFont()
        font.setBold(False)
        font.setPointSize(10)
        #-----------------------------------------------------
        self.layout_frame = QGridLayout()
        self.layout_frame.setSpacing(0)
        self.layout_frame.setContentsMargins(QMargins(0,0,0,0));
        self.setLayout(self.layout_frame)

        s_tooltip = "<p style='white-space:wrap'>This Tab is used to find books that have a similar value in a specified Standard or Custom Column."
        self.setToolTip(s_tooltip)
        #-----------------------------------------------------
        #-----------------------------------------------------
        #-----------------------------------------------------
        #-----------------------------------------------------
        #-----------------------------------------------------
        self.similarity_query_groupbox = QGroupBox('Similarity Query:')
        self.similarity_query_groupbox.setToolTip(s_tooltip)
        self.similarity_query_groupbox.setMinimumWidth(700)
        self.similarity_query_groupbox.setMaximumWidth(700)
        self.layout_frame.addWidget(self.similarity_query_groupbox)

        self.similarity_query_layout = QVBoxLayout()
        self.similarity_query_layout.setAlignment(Qt.AlignCenter)
        self.similarity_query_groupbox.setLayout(self.similarity_query_layout)

        font.setPointSize(10)
        font.setBold(False)
        #-----------------------------------------------------
        #-----------------------------------------------------
        self.line_1_label = QLabel(' ')
        self.similarity_query_layout.addWidget(self.line_1_label)
        #-----------------------------------------------------
        #-----------------------------------------------------

        self.similarity_query_options_1_layout = QHBoxLayout()
        self.similarity_query_options_1_layout.setAlignment(Qt.AlignLeft)

        self.similarity_query_layout.addLayout(self.similarity_query_options_1_layout)

        self.column_compare_label = QLabel('Value Comparison Column: ')
        self.column_compare_label.setAlignment(Qt.AlignRight)
        self.column_compare_label.setMinimumWidth(300)
        self.column_compare_label.setMaximumWidth(300)
        self.similarity_query_options_1_layout.addWidget(self.column_compare_label)

        self.column_compare_combobox = QComboBox()
        self.column_compare_combobox.setEditable(False)
        self.column_compare_combobox.setFont(font)
        self.column_compare_combobox.setMinimumWidth(300)
        self.column_compare_combobox.setMaximumWidth(300)
        self.column_compare_combobox.setToolTip("<p style='white-space:wrap'>This is the Value Comparison Column.  \
        The values in this column will be compared using the specified 'Similarity Percentage'.\
        <br><br>The specified Comparison Column must be 'textual', which includes datatypes of 'text', 'comments', 'series' and 'enumeration'.\
        <br><br>For Tags and Tag-Like Columns, all Tags for a book will first be sorted and then concatenated prior to value comparison.\
        <br><br>For Authors, all Authors for a book will first be sorted and then concatenated prior to value comparison.")
        self.similarity_query_options_1_layout.addWidget(self.column_compare_combobox)

        self.column_compare_combobox.addItem("Authors")
        self.column_compare_combobox.addItem("Comments")
        self.column_compare_combobox.addItem("Publisher")
        self.column_compare_combobox.addItem("Series")
        self.column_compare_combobox.addItem("Tags")
        self.column_compare_combobox.addItem("Title")

        self.comparison_custom_column_dict = {}

        tmp_list = self.guidb.custom_field_keys(include_composites=False)
        custom_field_keys = []
        for label in tmp_list:
            cc_metadata_dict = self.guidb.custom_field_metadata(label)
            for k,v in iteritems(cc_metadata_dict):
                if k == label:
                    cc_datatype = v['datatype']
                    if cc_datatype == "text" or cc_datatype == "comments" or cc_datatype == "enumeration" or cc_datatype == "series":
                        custom_field_keys.append(label)
                        self.comparison_custom_column_dict[k] = v
                        break
            #END FOR
        #END FOR

        del tmp_list

        custom_field_keys.sort()

        try:
            for label in custom_field_keys:
                self.column_compare_combobox.addItem(label)
            #END FOR
        except:
            pass

        del custom_field_keys

        column = prefs['OPTIONS_SIMILARITY_QUERIES_COMPARISON_COLUMN']
        i = self.column_compare_combobox.findText(column,Qt.MatchExactly)
        if i > -1:
            self.column_compare_combobox.setCurrentIndex(i)

        #-----------------------------------------------------
        #-----------------------------------------------------
        self.line_2_label = QLabel(' ')
        self.similarity_query_layout.addWidget(self.line_2_label)
        #-----------------------------------------------------
        #-----------------------------------------------------

        self.similarity_query_options_2_layout = QHBoxLayout()
        self.similarity_query_options_2_layout.setAlignment(Qt.AlignLeft)

        self.similarity_query_layout.addLayout(self.similarity_query_options_2_layout)

        self.compare_percentage_label = QLabel('Value Comparison Percentage: ')
        self.compare_percentage_label.setAlignment(Qt.AlignRight)
        self.compare_percentage_label.setMinimumWidth(300)
        self.compare_percentage_label.setMaximumWidth(300)
        self.similarity_query_options_2_layout.addWidget(self.compare_percentage_label)

        self.spinbox = QSpinBox(self)
        self.spinbox.setMinimum(1)
        self.spinbox.setMaximum(100)
        self.spinbox.setProperty('value', prefs['OPTIONS_SIMILARITY_QUERIES_PERCENTAGE'])
        self.spinbox.setMinimumWidth(300)
        self.spinbox.setMaximumWidth(300)
        self.spinbox.setSuffix("")
        self.spinbox.setToolTip("<p style='white-space:nowrap'>Minimum Similarity Match Percentage to be considered for inclusion within a particular 'Similarity Group'.\
        <br><br>'Identical' is '100%'.  The default is '75%'.  Percentages less than 70% are rarely useful.\
        <br><br>The Similarity % for each Comparison Value is calculated on a 'per-letter/digit' basis, and not on 'words'.")
        self.similarity_query_options_2_layout.addWidget(self.spinbox)

        #-----------------------------------------------------
        #-----------------------------------------------------
        self.line_3_label = QLabel(' ')
        self.similarity_query_layout.addWidget(self.line_3_label)
        #-----------------------------------------------------
        #-----------------------------------------------------

        self.similarity_query_options_3_layout = QHBoxLayout()
        self.similarity_query_options_3_layout.setAlignment(Qt.AlignLeft)

        self.similarity_query_layout.addLayout(self.similarity_query_options_3_layout)

        self.custom_column_update_label = QLabel('Similarity Group Custom Column: ')
        self.custom_column_update_label.setAlignment(Qt.AlignRight)
        self.custom_column_update_label.setMinimumWidth(300)
        self.custom_column_update_label.setMaximumWidth(300)
        self.similarity_query_options_3_layout.addWidget(self.custom_column_update_label)

        self.custom_column_update_combobox = QComboBox()
        self.custom_column_update_combobox.setEditable(False)
        self.custom_column_update_combobox.setFont(font)
        self.custom_column_update_combobox.setMinimumWidth(300)
        self.custom_column_update_combobox.setMaximumWidth(300)
        self.custom_column_update_combobox.setToolTip("<p style='white-space:wrap'>This is the 'Similarity Group' Tag-Like Custom Column\
        that will be updated with the 'Similarity Group', if any, for a book.\
        <br><br>The structure of a Similarity Group is:  'column_id' where 'column' is the Comparison Column, and 'id' is the Book ID of the book with the value being compared to the other books.")
        self.similarity_query_options_3_layout.addWidget(self.custom_column_update_combobox)

        self.similarity_group_custom_column_dict = {}

        tmp_list = self.guidb.custom_field_keys(include_composites=False)
        custom_field_keys = []
        for label in tmp_list:
            cc_metadata_dict = self.guidb.custom_field_metadata(label)
            for k,v in iteritems(cc_metadata_dict):
                if k == label:
                    if v['datatype'] == "text":
                        ismultiple = v['is_multiple']
                        if as_unicode(ismultiple) != "{}":   #e.g.  {u'ui_to_list': u',', u'list_to_ui': u', ', u'cache_to_list': u'|'}
                            custom_field_keys.append(label)  #taglike only...
                            self.similarity_group_custom_column_dict[k] = v
                            #~ if DEBUG: print(as_unicode(k),v['datatype'],v['is_multiple'])
            #END FOR
        #END FOR

        del tmp_list

        custom_field_keys.sort()

        try:
            for label in custom_field_keys:
                self.custom_column_update_combobox.addItem(label)
            #END FOR
        except:
            pass

        cc = prefs['OPTIONS_SIMILARITY_QUERIES_GROUP_UPDATE_TAGLIKE_CC']
        if cc in custom_field_keys:
            i = self.custom_column_update_combobox.findText(cc,Qt.MatchExactly)
            self.custom_column_update_combobox.setCurrentIndex(i)

        del custom_field_keys

        #-----------------------------------------------------
        #-----------------------------------------------------
        self.line_pushbutton_label = QLabel(' ')
        self.similarity_query_layout.addWidget(self.line_pushbutton_label)
        #-----------------------------------------------------
        #-----------------------------------------------------
        font.setPointSize(8)

        self.push_button_load_saved_criteria_values = QPushButton(" ", self)
        self.push_button_load_saved_criteria_values.setText("Load Previously Saved and Executed Criteria?")
        self.push_button_load_saved_criteria_values.setToolTip("<p style='white-space:wrap'>Select a previously saved (with a name) set of criteria for this Tab.")
        self.push_button_load_saved_criteria_values.clicked.connect(self.load_criteria_settings_similaritytab)
        self.similarity_query_layout.addWidget(self.push_button_load_saved_criteria_values)

        self.push_button_execute_similarity_query_selected = QPushButton(" ", self)
        self.push_button_execute_similarity_query_selected.setText("Execute the Similarity Query [Selected Books]")
        self.push_button_execute_similarity_query_selected.setToolTip("<p style='white-space:wrap'>Save (with a name) all criteria for this Tab, then Execute the Similarity Query [Selected Books].")
        self.push_button_execute_similarity_query_selected.clicked.connect(self.execute_similarity_query_selected)
        self.similarity_query_layout.addWidget(self.push_button_execute_similarity_query_selected)


        self.push_button_execute_similarity_query_all = QPushButton(" ", self)
        self.push_button_execute_similarity_query_all.setText("Execute the Similarity Query [All Books]")
        self.push_button_execute_similarity_query_all.setToolTip("<p style='white-space:wrap'>Save (with a name) all criteria for this Tab, then Execute the Similarity Query [All Books].")
        self.push_button_execute_similarity_query_all.clicked.connect(self.execute_similarity_query_all)
        self.similarity_query_layout.addWidget(self.push_button_execute_similarity_query_all)

        #-----------------------------------------------------
        #-----------------------------------------------------
        self.resize(self.sizeHint())
    #-----------------------------------------------------------------------------------------------
    #-----------------------------------------------------------------------------------------------
    #-----------------------------------------------------------------------------------------------
    def execute_similarity_query_selected(self):
        sel_type = "selected"
        self.execute_similarity_query(sel_type)
    def execute_similarity_query_all(self):
        sel_type = "all"
        self.execute_similarity_query(sel_type)
    def execute_similarity_query(self,sel_type):
        global prefs
        param_dict = {}
        #~ -------------------
        column = self.column_compare_combobox.currentText()
        if column is not None:
            if column > " ":
                prefs['OPTIONS_SIMILARITY_QUERIES_COMPARISON_COLUMN'] = column
            else:
                return
        #~ -------------------
        cc = self.custom_column_update_combobox.currentText()
        if cc is not None:
            if cc.startswith("#"):
                prefs['OPTIONS_SIMILARITY_QUERIES_GROUP_UPDATE_TAGLIKE_CC'] = cc
            else:
                return
        #~ -------------------
        percent_val = int(self.spinbox.value())
        prefs['OPTIONS_SIMILARITY_QUERIES_PERCENTAGE'] = percent_val
        #~ -------------------
        prefs
        #~ -------------------
        param_dict['OPTIONS_SIMILARITY_QUERIES_COMPARISON_COLUMN'] = column
        param_dict['OPTIONS_SIMILARITY_QUERIES_PERCENTAGE'] = percent_val
        param_dict['OPTIONS_SIMILARITY_QUERIES_GROUP_UPDATE_TAGLIKE_CC'] = cc
        #~ -------------------
        if DEBUG:
            for k,v in iteritems(param_dict):
                print(as_unicode(k),as_unicode(v))
            #END FOR
        #~ -------------------
        if column.startswith("#"):
            if not column in self.comparison_custom_column_dict:
                msg = "Comparison Custom Column Not Found; Program Error: " + column
                error_dialog(self.gui, _('MCS'),_((msg)), show=True)
                return
        #~ -------------------
        if not percent_val > 0:
            msg = "Comparison Percentage is Invalid; Program Error: " + as_unicode(percent_val)
            error_dialog(self.gui, _('MCS'),_((msg)), show=True)
            return
        #~ -------------------
        if not cc in self.similarity_group_custom_column_dict:
            msg = "Similarity Group Custom Column Not Found; Program Error: " + cc
            error_dialog(self.gui, _('MCS'),_((msg)), show=True)
            return
        #~ -------------------
        if column == cc:
            msg = "Specified columns cannot be identical"
            error_dialog(self.gui, _('MCS'),_((msg)), show=True)
            return
        #~ -------------------
        param_dict[SIMILARITY_QUERIES_TYPE] = SIMILARITY_QUERIES_TYPE
        current_tab = SIMILARITYTAB
        prefs = self.save_settings_parm_history_to_prefs_generic(prefs,current_tab,param_dict)
        prefs
        #~ -------------------
        self.search_similarity_control(self.guidb,param_dict,sel_type,self.comparison_custom_column_dict,self.similarity_group_custom_column_dict)
        #~ -------------------
        del param_dict
#--------------------------------------------------------------------------------------------------
#--------------------------------------------------------------------------------------------------
    def load_criteria_settings_similaritytab(self):
        self.load_criteria_settings_generic(current_tab=SIMILARITYTAB)
#--------------------------------------------------------------------------------------------------
    def unpack_selected_parm_similaritytab(self,selected_parm,parm_dict):
        n = selected_parm[-1: ]
        if n.isdigit and isinstance(parm_dict,dict):
            n = int(n)
        else:
            if DEBUG: print("similaritytab: parm and/or parm_dict to restore is corrupt; nothing can be done...")
            return False

        saveddate,type,vdict,parm = parm_dict[n]   #for actual restoration of loaded criteria

        if DEBUG:
            for k, v in iteritems(vdict):
                print(as_unicode(k), " = ", as_unicode(v))

        column = vdict['OPTIONS_SIMILARITY_QUERIES_COMPARISON_COLUMN']
        percent_val = vdict['OPTIONS_SIMILARITY_QUERIES_PERCENTAGE']
        cc = vdict['OPTIONS_SIMILARITY_QUERIES_GROUP_UPDATE_TAGLIKE_CC']

        i = self.column_compare_combobox.findText(column)
        self.column_compare_combobox.setCurrentIndex(i)

        self.spinbox.setValue(int(percent_val))

        i = self.custom_column_update_combobox.findText(cc)
        self.custom_column_update_combobox.setCurrentIndex(i)

        self.update()

        if DEBUG: print("*** All similaritytab widgets have been reset per loaded criteria selected by user ***")

        return True
#--------------------------------------------------------------------------------------------------
#--------------------------------------------------------------------------------------------------
#--------------------------------------------------------------------------------------------------
#--------------------------------------------------------------------------------------------------
class MCSRawSQLTab(QWidget):
    # a.k.a. "SQL Queries"
    prefs = None
    #-----------------------------------------------------------------------------------------------
    def __init__(self,gui,icon,guidb,mcsprefs,current_library_path,raw_sql_query_control,
                        custom_column_label_dict,custom_column_datatype_dict,custom_column_normalized_dict,
                        load_criteria_settings_generic,create_criteria_parm_list_generic,save_settings_parm_history_to_prefs_generic,unpack_selected_parm_generic):
        super(MCSRawSQLTab, self).__init__()

        self.gui = gui
        self.icon = icon
        self.guidb = guidb

        global prefs
        prefs = mcsprefs

        self.current_library_path = current_library_path
        self.raw_sql_query_control = raw_sql_query_control

        self.custom_column_label_dict = custom_column_label_dict
        self.custom_column_datatype_dict = custom_column_datatype_dict
        self.custom_column_normalized_dict = custom_column_normalized_dict
        self.unpack_selected_parm_generic = unpack_selected_parm_generic

        self.load_criteria_settings_generic = load_criteria_settings_generic
        self.create_criteria_parm_list_generic = create_criteria_parm_list_generic
        self.save_settings_parm_history_to_prefs_generic = save_settings_parm_history_to_prefs_generic
        self.unpack_selected_parm_generic = unpack_selected_parm_generic

        tmp_list = []
        for label,id in iteritems(self.custom_column_label_dict):
            if id in self.custom_column_datatype_dict:
                if id in self.custom_column_normalized_dict:
                    datatype = self.custom_column_datatype_dict[id]
                    normalized = self.custom_column_normalized_dict[id]
                    s =  "<br>" + as_unicode(id) + "---" + label + "---" + datatype
                    if normalized == 1:
                        s = s + "---" + "Normalized"
                    tmp_list.append(s)
        #END FOR
        tmp_list.sort()
        s = "<br>"
        for row in tmp_list:
            s = s + row
        #END FOR
        s1 = "<p style='white-space:wrap'>This Tab is used to execute raw 'SELECT bookid' SQL with the addition of the optional 'All Authors' Books' and 'Final Filters' afterwards."
        s1 = s1 + "The custom column information from table custom_columns for this library is shown below.  \
                        <br><br><b>Normalized</b>:          Table custom_column_N  has the values.  Columns:  id,value.   Table books_custom_column_N_link has the link of the value to the book.  Columns: id,book,value where value is the id of the value from table custom_column_N.\
                        <br><br><b>Not Normalized</b>:   Table custom_column_N  has both the value and the link to the book.  Columns:  id,book,value."
        s_tooltip = s1 + s
        del tmp_list
        del s
        del s1

        #-----------------------------------------------------
        #-----------------------------------------------------
        #-----------------------------------------------------
        #-----------------------------------------------------
        font = QFont()
        font.setBold(False)
        font.setPointSize(10)
        #-----------------------------------------------------
        self.layout_frame = QGridLayout()
        self.layout_frame.setSpacing(0)
        self.layout_frame.setContentsMargins(QMargins(0,0,0,0));
        self.setLayout(self.layout_frame)

        self.setToolTip(s_tooltip)
        #-----------------------------------------------------
        #-----------------------------------------------------
        #-----------------------------------------------------
        #-----------------------------------------------------
        #-----------------------------------------------------

        self.raw_sql_groupbox = QGroupBox('Raw SQL:')
        self.raw_sql_groupbox.setToolTip(s_tooltip)
        self.raw_sql_groupbox.setMinimumWidth(700)
        self.raw_sql_groupbox.setMaximumWidth(900)
        self.raw_sql_groupbox.setMinimumHeight(150)
        self.layout_frame.addWidget(self.raw_sql_groupbox)

        self.raw_sql_layout = QVBoxLayout()
        self.raw_sql_layout.setAlignment(Qt.AlignCenter)
        self.raw_sql_groupbox.setLayout(self.raw_sql_layout)

        font.setPointSize(9)

        #-----------------------------------------------------
        self.top_buttonbox = QDialogButtonBox()
        self.top_buttonbox.setCenterButtons(True)
        self.top_buttonbox.setToolTip(s_tooltip)
        self.raw_sql_layout.addWidget(self.top_buttonbox)
        #-----------------------------------------------------

        self.push_button_save_raw_sql_query = QPushButton(" ", self)
        self.push_button_save_raw_sql_query.setText("Save Current Criteria")
        self.push_button_save_raw_sql_query.setMinimumWidth(200)
        self.push_button_save_raw_sql_query.setToolTip("<p style='white-space:wrap'>Save (with a name) the current SQL and related criteria.")
        self.push_button_save_raw_sql_query.clicked.connect(self.save_raw_sql_query)
        self.top_buttonbox.addButton(self.push_button_save_raw_sql_query,QDialogButtonBox.AcceptRole)

        self.push_button_load_saved_criteria_values = QPushButton(" ", self)
        self.push_button_load_saved_criteria_values.setText("Load Previously Saved Criteria?")
        self.push_button_load_saved_criteria_values.setMinimumWidth(200)
        self.push_button_load_saved_criteria_values.setToolTip("<p style='white-space:wrap'>Select a previously saved (with a name) set of criteria for this Tab.<br><br>The checkmarks for All Authors' Books and Use Final Filters are not saved, and must be selected separately for each executed Query.")
        self.push_button_load_saved_criteria_values.clicked.connect(self.load_criteria_settings_rawsqltab)
        self.top_buttonbox.addButton(self.push_button_load_saved_criteria_values,QDialogButtonBox.AcceptRole)

        self.push_button_example_raw_sql_query = QPushButton(" ", self)
        self.push_button_example_raw_sql_query.setText("Load Example SQL")
        self.push_button_example_raw_sql_query.setMinimumWidth(200)
        self.push_button_example_raw_sql_query.setToolTip("<p style='white-space:wrap'>Load the example SQL.")
        self.push_button_example_raw_sql_query.clicked.connect(self.example_raw_sql_query)
        self.top_buttonbox.addButton(self.push_button_example_raw_sql_query,QDialogButtonBox.AcceptRole)

        font.setPointSize(12)
        font.setBold(False)

        self.raw_sql_qtextedit =  QTextEdit("")
        self.raw_sql_qtextedit.setAcceptRichText(True)
        self.raw_sql_qtextedit.setReadOnly(False)
        self.raw_sql_qtextedit.setFont(font)
        self.raw_sql_qtextedit.setWordWrapMode(QTextOption.WrapMode.WordWrap)
        self.raw_sql_qtextedit.clear()

        self.example_sql_text = "SELECT id FROM books WHERE id IN (SELECT book FROM books_authors_link WHERE author IN (SELECT id FROM authors WHERE name LIKE '%victor%hugo%' )   OR author IN (SELECT id FROM authors WHERE name LIKE '%rachel%' ) OR author IN (SELECT id FROM authors WHERE name LIKE '%george r_r__martin%' ) ) AND has_cover = 0 AND id IN (SELECT book FROM custom_column_19 WHERE value > 0  AND value < 10) AND id NOT IN (SELECT book FROM books_custom_column_4_link WHERE value IN (SELECT id FROM custom_column_4 WHERE value LIKE '%star wars%' AND value NOT NULL) ) AND id IN (SELECT book FROM custom_column_8 WHERE value REGEXP '^.+$' )           \n\n /*Comments: The above REGEXP function will be evaluated after converting both 'value' AND the regular expression itself to Unicode text. The re parameters to be used are re.IGNORECASE, re.DOTALL, re.MULTILINE, AND re.escape. */              /*Comments: An example that finds ALL Series Names within a Title:  SELECT id FROM books CROSS JOIN (SELECT name FROM series) WHERE books.title LIKE '%'||name||'%'*/            /*Comments: An example that queries a non-Normalized custom column:  SELECT book FROM custom_column_11 WHERE value NOT NULL   */ \n /*Comments: An example that finds ALL books with Author Names that are a certain length:  SELECT id FROM books WHERE id IN (SELECT book FROM books_authors_link WHERE author IN (SELECT id FROM authors WHERE length(name) < 7 ))*/            \n /*Comments: An example that finds ALL books with Hugo Awards: SELECT book FROM _mcs_authors_by_book,_mcs_book_awards WHERE award LIKE '%hugo%' AND substr(authorname,1,3) = substr(author,1,3)  AND SIMILARTO(authorname,author) > 0.80 AND _mcs_authors_by_book.book IN ( SELECT id FROM books WHERE books.id = _mcs_authors_by_book.book AND SIMILARTO(books.title,_mcs_book_awards.title) > 0.80) */            \n/*Comments: An example that finds ISBNs within Tags:  SELECT book FROM _mcs_tags_by_book WHERE tagname LIKE '%978%' OR tagname LIKE '%045%' OR tagname LIKE '%isbn%' OR tagname REGEXP '^[0-9][-]*[0-9][-]*[0-9][-]*[0-9][-]*[0-9][-]*[0-9][-]*[0-9][-]*[0-9][-]*[0-9][-]*[0-9]+$'*/             \n/*Comments: An example that finds Composite Custom Column data IN table books_plugin_data:  SELECT book FROM books_plugin_data WHERE name = 'CompositeColumnValues' AND val IS NOT NULL AND PARSEJSON(val,'#mysize','>=','188282') IS TRUE */             \n/*Comments: An example that finds Composite Custom Column data IN table books_plugin_data:  SELECT book FROM books_plugin_data WHERE name = 'CompositeColumnValues' AND val IS NOT NULL AND PARSEJSON(val,'#isbn') LIKE '%55%'  */"

        self.default_sql_text = "SELECT id FROM books WHERE id IN (SELECT book FROM books_authors_link WHERE author IN (SELECT id FROM authors WHERE name LIKE '%victor%hugo%' )   OR author IN (SELECT id FROM authors WHERE name LIKE '%rachel%' ) OR author IN (SELECT id FROM authors WHERE name LIKE '%george r_r__martin%' ) ) AND has_cover = 0 "

        if not 'RAW_SQL_QUERY_LAST_SAVED' in prefs:
             prefs['RAW_SQL_QUERY_LAST_SAVED'] =  ""
             prefs

        if prefs['RAW_SQL_QUERY_LAST_SAVED'] > "":
            self.raw_sql_text = prefs['RAW_SQL_QUERY_LAST_SAVED']
        elif 'RAW_SQL_QUERY_LAST_CURRENT' in prefs:
            self.raw_sql_text = prefs['RAW_SQL_QUERY_LAST_CURRENT']
            prefs['RAW_SQL_QUERY_LAST_SAVED'] = self.raw_sql_text  #convert keys for version 1.0.86
            prefs

        if not prefs['RAW_SQL_QUERY_LAST_SAVED'] > "":
            self.raw_sql_text  = self.default_sql_text
            prefs['RAW_SQL_QUERY_LAST_SAVED'] = self.raw_sql_text
            prefs

        if 'RAW_SQL_QUERY_LAST_CURRENT' in prefs:
            del prefs['RAW_SQL_QUERY_LAST_CURRENT']  #convert keys for version 1.0.86
            prefs

        self.raw_sql_qtextedit.setPlainText(self.raw_sql_text)

        self.raw_sql_layout.addWidget(self.raw_sql_qtextedit)

        self.raw_sql_qtextedit.setToolTip("<p style='white-space:wrap'>Raw SQL.  The Rules: \
                                                                                                            <br><br>[1] Must start with SELECT \
                                                                                                            <br><br>[2] The very first column selected must be an integer book id (e.g. 'books.id' or 'books_authors_link.book') \
                                                                                                            <br><br>[3] May not contain SQLite Keywords that add, change, or delete data or objects \
                                                                                                            <br><br>[4] May not contain semi-colons \
                                                                                                            <br><br>[5] May not contain question marks \
                                                                                                            <br><br>[6] May not contain double quotes \
                                                                                                            <br><br>[7] Must otherwise comply with the syntax in: https://www.sqlite.org/lang_corefunc.html \
                                                                                                            <br><br>[8] Must use the syntax provided by 'Load Example SQL' for all MCS Raw SQL User Functions, including capitalization and punctuation:  \
                                                                                                            <br>[*] REGEXP  <i>example</i>: WHERE value REGEXP '^.+$' \
                                                                                                            <br>[*] SIMILARTO <i>example</i>:  WHERE SIMILARTO(authorname,author) > 0.80\
                                                                                                            <br>[*] PARSEJSON <i>example - returning true or false</i>: PARSEJSON(val,'#mysize','>=','188282') IS TRUE\
                                                                                                            <br>[*] PARSEJSON <i>example - returning the raw #column value extracted from JSON</i>: PARSEJSON(val,'#isbn') LIKE '%55%'\
                                                                                                            <br><br>[9] Full-Text-Search (FTS) SQL must use this template:  'SELECT book FROM books_text WHERE format = 'EPUB' AND searchable_text REGEXP  '^.+$';\
                                                                                                             You may search either the FTS database or the normal Metadata database, but not both simultaneously.  Table 'books_text' and column 'searchable_text' exist only in the FTS database.\
                                                                                                             It is strongly recommended to specify a specific format, since otherwise the identical text will be searched needlessly for each format of the identical book.\
                                                                                                            <br><br> Suggestion: create a .txt file to keep your SQL history for future copy-and-paste ease. \
                                                                                                            <br><br>Refer to this Tab's ToolTips for a list of the current library's custom columns. \
                                                                                                            <br><br>SQLite Syntax questions?  Answer them at http://www.w3schools.com/sql/ or http://www.sqlcourse.com/.")

        #-----------------------------------------------------
        #-----------------------------------------------------
        font.setPointSize(8)

        self.activate_all_author_books_checkbox = QCheckBox()
        self.activate_all_author_books_checkbox.setText("All Authors' Books?")
        self.activate_all_author_books_checkbox.setFont(font)
        self.activate_all_author_books_checkbox.setToolTip("<p style='white-space:wrap'>Checking this box causes all books of every Author otherwise in the search results to also be marked and displayed.")

        self.raw_sql_layout.addWidget(self.activate_all_author_books_checkbox)

        self.add_final_filters_checkbox = QCheckBox()
        self.add_final_filters_checkbox.setText("Use Final Filters?")
        self.add_final_filters_checkbox.setFont(font)
        self.add_final_filters_checkbox.setToolTip("<p style='white-space:wrap'>Checking this box causes the active filters defined in the Final Filters Tab to be used at the very end of the search.")

        self.raw_sql_layout.addWidget(self.add_final_filters_checkbox)

        #-----------------------------------------------------
        #-----------------------------------------------------
        self.push_button_execute_raw_sql_query = QPushButton(" ", self)
        self.push_button_execute_raw_sql_query.setText("Save then Execute the Raw SQL Query [All Books]")
        self.push_button_execute_raw_sql_query.setToolTip("<p style='white-space:wrap'>Save (with a name) all criteria for this Tab, then Execute the Raw SQL Query [All Books].")
        self.push_button_execute_raw_sql_query.clicked.connect(self.execute_raw_sql_query)
        self.raw_sql_layout.addWidget(self.push_button_execute_raw_sql_query)

        #-----------------------------------------------------
        #-----------------------------------------------------
        #-----------------------------------------------------
        self.resize(self.sizeHint())
        #-----------------------------------------------------
        #-----------------------------------------------------
    #-----------------------------------------------------------------------------------------------
    #-----------------------------------------------------------------------------------------------
    #-----------------------------------------------------------------------------------------------
    def execute_raw_sql_query(self):

        global prefs

        is_valid,sql = self.validate_raw_sql_query()
        if not is_valid:
            return

        prefs['RAW_SQL_QUERY_LAST_SAVED'] =  sql
        prefs

        param_dict = self.build_param_dict(sql)

        self.save_raw_sql_query(param_dict,sql)

        #~ Always at execution time...these are never saved as part of managing saved criteria...
        param_dict['ALL_AUTHORS_BOOKS'] = prefs['ALL_AUTHORS_BOOKS']
        param_dict['USE_FINAL_FILTERS'] = prefs['USE_FINAL_FILTERS']

        self.raw_sql_query_control(self.guidb,param_dict,self.current_library_path)

        del param_dict
    #-----------------------------------------------------------------------------------------------
    def validate_raw_sql_query(self):

        global prefs

        sql = self.raw_sql_qtextedit.toPlainText()
        #~ if DEBUG: print('sql: ', sql)
        lc_sql = as_unicode(sql.lower())
        if lc_sql.count("select") == 0:
            error_dialog(self.gui, _('MCS'),_(("SQL must be for a SELECT query.<br><br>\
                                                                Execution Canceled. ")), show=True)
            return False,sql
        elif lc_sql.count(" create ") > 0 or lc_sql.count(" drop ") > 0 or lc_sql.count(" insert ") > 0 or lc_sql.count(" update ") > 0 \
                                                          or lc_sql.count(" delete ") > 0 or lc_sql.count(" replace ") > 0 or lc_sql.count(" reindex ") > 0 \
                                                          or lc_sql.count(" pragma ") > 0 or lc_sql.count(" alter ") > 0 or lc_sql.count(" vacuum ") > 0 \
                                                          or lc_sql.count(" create ") > 0 or lc_sql.count(" begin ") > 0 or lc_sql.count(" commit ") > 0:
            error_dialog(self.gui, _('MCS'),_(("SQL must be for a SELECT query.  CREATE, DROP, INSERT, UPDATE, REPLACE, DELETE and so forth are strictly forbidden.<br><br>\
                                                                Execution Canceled. ")), show=True)
            return False,sql
        elif lc_sql.count("?") > 0:
            error_dialog(self.gui, _('MCS'),_(("SQL may not contain a ? (Question Mark).<br><br>\
                                                                Execution Canceled. ")), show=True)
            return False,sql
        elif lc_sql.count('"') > 0:
            error_dialog(self.gui, _('MCS'),_(("SQL may not contain Double Quotes.<br><br>\
                                                                Execution Canceled. ")), show=True)
            return False,sql
        elif sql.count(";") > 0:
            error_dialog(self.gui, _('MCS'),_(("SQL may not contain semi-colons.<br><br>\
                                                                Execution Canceled. ")), show=True)
            return False,sql

        sql = sql.replace("select "," SELECT ")
        sql = sql.replace(" from "," FROM ")
        sql = sql.replace(" where "," WHERE ")
        sql = sql.replace(" all "," ALL ")
        sql = sql.replace(" by "," BY ")
        sql = sql.replace(" is "," IS ")
        sql = sql.replace(" in "," IN ")
        sql = sql.replace(" in("," IN(")
        sql = sql.replace(" like "," LIKE ")
        sql = sql.replace(" as "," AS ")
        sql = sql.replace(" and "," AND ")
        sql = sql.replace(" not "," NOT ")
        sql = sql.replace(" or "," OR ")
        sql = sql.replace(" null "," NULL ")
        sql = sql.replace(" exists "," EXISTS ")
        sql = sql.replace(" union "," UNION ")
        sql = sql.replace(" join "," JOIN ")
        sql = sql.replace(" inner "," INNER ")
        sql = sql.replace(" outer "," OUTER ")
        sql = sql.replace(" cross "," CROSS ")
        sql = sql.replace(" using "," USING ")
        sql = sql.replace(" group "," GROUP ")
        sql = sql.replace(" order "," ORDER ")
        sql = sql.replace(" distinct "," DISTINCT ")
        sql = sql.replace(" having "," HAVING ")
        sql = sql.replace(" between "," BETWEEN ")
        sql = sql.replace(" case "," CASE ")
        sql = sql.replace(" when "," WHEN ")
        sql = sql.replace(" end "," END ")
        sql = sql.replace(" else "," ELSE ")
        sql = sql.replace(" then "," THEN ")
        sql = sql.replace(" cast "," CAST ")
        sql = sql.replace(" regexp "," REGEXP ")
        sql = sql.replace(" similarto "," SIMILARTO ")
        sql = sql.replace(" similarto"," SIMILARTO")
        sql = sql.replace("parsejson","PARSEJSON")
        sql = sql.replace("Parsejson","PARSEJSON")

        sql = sql.strip()

        self.raw_sql_qtextedit.setPlainText(sql)
        self.repaint()

        nl = sql.count("(")
        nr = sql.count(")")
        if nl != nr:
            error_dialog(self.gui, _('MCS'),_(("SQL must have an equal number of left and right parentheses.<br><br>\
                                                                Execution Canceled. ")), show=True)
            return False,sql

        if (not sql.startswith("SELECT id ")) and (not sql.startswith("SELECT book ")) \
            and (not sql.startswith("SELECT ALL id ")) and (not sql.startswith("SELECT ALL book ")) \
            and (not sql.startswith("SELECT DISTINCT id ")) and (not sql.startswith("SELECT DISTINCT book ")):
            error_dialog(self.gui, _('MCS'),_(("SQL must start with: SELECT and the column to be returned must be either the integer 'id' or the integer 'book'.<br><br>\
                                                                Execution Canceled. ")), show=True)
            return False,sql

        return True,sql
    #-----------------------------------------------------------------------------------------------
    def save_raw_sql_query(self,param_dict=None,sql=None):

        global prefs

        if sql is None:
            is_valid,sql = self.validate_raw_sql_query()
            if not is_valid:
                error_dialog(self.gui, _('MCS'),_(("SQL is invalid.  Not Saved.")), show=True)
                return
        #~ -------------------
        prefs['RAW_SQL_QUERY_LAST_SAVED'] = sql
        prefs
        #~ -------------------
        if not isinstance(param_dict,dict):
            if DEBUG: print("param_dict is None:")
            param_dict = self.build_param_dict(sql)
        #~ -------------------

        #~ ----------------------------------------------------------------------------------
        #~ Save actual values temporarily
        #~ ----------------------------------------------------------------------------------
        save1 = param_dict['ALL_AUTHORS_BOOKS']
        save2 = param_dict['USE_FINAL_FILTERS']
        #~ ----------------------------------------------------------------------------------
        #~ These 2 options are selected at query execution time only, and never saved
        #~ ----------------------------------------------------------------------------------
        param_dict['ALL_AUTHORS_BOOKS'] = "False"
        param_dict['USE_FINAL_FILTERS'] = "False"
        #~ ----------------------------------------------------------------------------------
        param_dict[SQL_QUERIES_TYPE] = SQL_QUERIES_TYPE
        current_tab = RAWSQLTAB
        prefs = self.save_settings_parm_history_to_prefs_generic(prefs,current_tab,param_dict)
        #~ ----------------------------------------------------------------------------------
        #~ Restore saved values after self.save_settings_parm_history_to_prefs_generic()
        #~ ----------------------------------------------------------------------------------
        prefs['ALL_AUTHORS_BOOKS'] = save1
        prefs['USE_FINAL_FILTERS'] = save2
        prefs
        #~ ----------------------------------------------------------------------------------
    #-----------------------------------------------------------------------------------------------
    def build_param_dict(self,sql=None):
        param_dict = {}

        param_dict[SQL_QUERIES_TYPE] = SQL_QUERIES_TYPE

        if sql is None:
            param_dict['RAW_SQL_QUERY_LAST_SAVED']= self.raw_sql_qtextedit.toPlainText()
            param_dict['RAW_SQL_QUERY'] = self.raw_sql_qtextedit.toPlainText()
        else:
            param_dict['RAW_SQL_QUERY_LAST_SAVED']= sql
            param_dict['RAW_SQL_QUERY'] = sql

        param_dict['ALL_AUTHORS_BOOKS'] = "False"
        if self.activate_all_author_books_checkbox.isChecked():
            param_dict['ALL_AUTHORS_BOOKS'] = "True"

        param_dict['USE_FINAL_FILTERS'] = "False"
        if self.add_final_filters_checkbox.isChecked():
            param_dict['USE_FINAL_FILTERS'] = "True"

        return param_dict
    #-----------------------------------------------------------------------------------------------
    #-----------------------------------------------------------------------------------------------
    def example_raw_sql_query(self):
        global prefs
        self.raw_sql_qtextedit.setPlainText(self.example_sql_text)
        prefs['RAW_SQL_QUERY_LAST_SAVED'] =  self.raw_sql_qtextedit.toPlainText()
        prefs
    #-----------------------------------------------------------------------------------------------
    #-----------------------------------------------------------------------------------------------
    def load_criteria_settings_rawsqltab(self):
        self.load_criteria_settings_generic(current_tab=RAWSQLTAB)
    #-----------------------------------------------------------------------------------------------
    def unpack_selected_parm_rawsqltab(self,selected_parm,parm_dict):

        global prefs

        n = selected_parm[-1: ]
        if n.isdigit and isinstance(parm_dict,dict):
            n = int(n)
        else:
            if DEBUG: print("rawsqltab: parm and/or parm_dict to restore is corrupt; nothing can be done...")
            return False

        saveddate,type,vdict,parm = parm_dict[n]   #for actual restoration of loaded criteria

        if DEBUG:
            for k, v in iteritems(vdict):
                print(as_unicode(k), " = ", as_unicode(v))

        if 'RAW_SQL_QUERY_LAST_SAVED' in vdict:
            self.raw_sql_text = vdict['RAW_SQL_QUERY_LAST_SAVED']
        else:
            return False

        self.raw_sql_qtextedit.setPlainText(self.raw_sql_text)

        prefs['RAW_SQL_QUERY_LAST_SAVED'] = self.raw_sql_text
        prefs

        self.activate_all_author_books_checkbox.setChecked(False)
        self.add_final_filters_checkbox.setChecked(False)

        self.update()

        if DEBUG: print("*** All rawsqltab widgets have been reset per loaded criteria selected by user ***")

        return True
#--------------------------------------------------------------------------------------------------
#--------------------------------------------------------------------------------------------------
#--------------------------------------------------------------------------------------------------
#--------------------------------------------------------------------------------------------------
class MCSVirtualColumnTXTTab(QWidget):
    # a.k.a. "TXT Queries"
    prefs = None
    #-----------------------------------------------------------------------------------------------
    def __init__(self,gui,icon,guidb,mcsprefs,search_virtual_column_format_txt_control,
                        load_criteria_settings_generic,create_criteria_parm_list_generic,save_settings_parm_history_to_prefs_generic,unpack_selected_parm_generic):
        super(MCSVirtualColumnTXTTab, self).__init__()

        self.gui = gui
        self.icon = icon
        self.guidb = guidb

        global prefs
        prefs = mcsprefs

        self.search_virtual_column_format_txt_control = search_virtual_column_format_txt_control
        self.load_criteria_settings_generic = load_criteria_settings_generic
        self.create_criteria_parm_list_generic = create_criteria_parm_list_generic
        self.save_settings_parm_history_to_prefs_generic = save_settings_parm_history_to_prefs_generic
        self.unpack_selected_parm_generic = unpack_selected_parm_generic
        #-----------------------------------------------------
        #-----------------------------------------------------
        #-----------------------------------------------------
        #-----------------------------------------------------
        font = QFont()
        font.setBold(False)
        font.setPointSize(10)
        #-----------------------------------------------------
        self.layout_frame = QGridLayout()
        self.layout_frame.setSpacing(0)
        self.layout_frame.setContentsMargins(QMargins(0,0,0,0));
        self.setLayout(self.layout_frame)

        s_tooltip = "<p style='white-space:wrap'>This Tab considers the actual Text of a book as a 'virtual column' for the purposes of searching using MCS.  If you wish to use this Tab, you must have either previously converted the appropriate books into a TXT format, or indexed the books in Calibre FTS (Full Text Search)."
        self.setToolTip(s_tooltip)

        #-----------------------------------------------------
        #-----------------------------------------------------
        #-----------------------------------------------------
        #-----------------------------------------------------
        #-----------------------------------------------------

        self.txt_query_groupbox = QGroupBox('Full-Text Search Regular Expression:')
        self.txt_query_groupbox.setToolTip(s_tooltip)
        self.txt_query_groupbox.setMinimumWidth(700)
        self.txt_query_groupbox.setMaximumWidth(900)
        self.txt_query_groupbox.setMinimumHeight(50)
        self.layout_frame.addWidget(self.txt_query_groupbox)

        self.txt_query_layout = QVBoxLayout()
        self.txt_query_layout.setAlignment(Qt.AlignCenter)
        self.txt_query_groupbox.setLayout(self.txt_query_layout)

        font.setPointSize(12)
        font.setBold(False)

        self.txt_query_qtextedit =  QTextEdit("")
        self.txt_query_qtextedit.setAcceptRichText(True)
        self.txt_query_qtextedit.setReadOnly(False)
        self.txt_query_qtextedit.setFont(font)
        self.txt_query_qtextedit.setWordWrapMode(QTextOption.WrapMode.WordWrap)
        self.txt_query_qtextedit.clear()



        if 'TXT_QUERY_LAST_CURRENT' in prefs:
            self.txt_query_text = prefs['TXT_QUERY_LAST_CURRENT']
        else:
            self.txt_query_text  = "Horatio Hornblower|Mein schönes Fräulein, darf ich wagen, Meinen Arm und Geleit Ihr anzutragen?|\\bDNA\W+(?:\w+\W+){0,100}?VIRUS\\b"
            prefs['TXT_QUERY_LAST_CURRENT'] = self.txt_query_text
            prefs

        self.txt_query_qtextedit.setPlainText(self.txt_query_text)

        self.txt_query_layout.addWidget(self.txt_query_qtextedit)

        self.txt_query_qtextedit.setToolTip("<p style='white-space:wrap'>Enter the text you wish to search for here.  Do not enclose the text in quotes. Multiple searches may be combined with a bar ('|') meaning 'OR'.\
                                                                                                                 <br><br>The text you enter will be converted into a Regular Expression using the re parameters re.IGNORECASE, re.DOTALL, re.MULTILINE.  \
                                                                                                                 <br><br>Example:    Mein schönes Fräulein, darf ich wagen, Meinen Arm und Geleit Ihr anzutragen? \
                                                                                                                 <br><br>Example:    Horatio Hornblower \
                                                                                                                 <br><br>Example:    Nile[ ]River|Nile.+River|River.+Nile \
                                                                                                                 <br><br>Example:    Nile|Egypt|Pyramid|Pharaoh \
                                                                                                                 <br><br>Example:    \\bDNA\W+(?:\w+\W+){0,100}?VIRUS\\b   ('Find the word DNA that is within 100 words of the word VIRUS, including right next to it')\
                                                                                                                 <br><br>Example:    \\bDNA\W+(?:\w+\W+){9,36}?VIRUS\\b   ('Find the word DNA that is within 36 words of the word VIRUS, but is at least 9 words away')\
                                                                                                                 <br><br>Example:    Story URL: https://www.fanfiction.net/s/[0-9]+/[0-9]/|Story URL: http://www.fanfiction.net/s/[0-9]+/[0-9]/ \
                                                                                                                 <br><br>Example:    http[a-z0-9/:.-]+ ('Find any URL having no spaces in it', such as:  https://www.FANFICTION.net/u/1354887/80-sLover)\
                                                                                                                 <br><br>Since re:MULTILINE and re:DOTALL are used, you may at times need to add one or more 'modes' to your Regular Expression.  Example: '(?s)', meaning 'single-line mode'.  \
                                                                                                                 However, re.MULTILINE allows '^' to search for patterns at the beginning of every line instead of just at the beginning of the entire text being examined, which might simplify your Regular Expression.\
                                                                                                                 <br><br>By default, all quantifiers use the greedy mode.  Greedy quantifiers will match their preceding elements as much as possible.   Use the '?' character \
                                                                                                                 to specify that the previous quantifier should be 'non-greedy'.  Examples:  '*?'  and  '+?' \
                                                                                                                 <br><br>This URL is highly recommended to test your Python REs quickly and interatively:  https://pythex.org/\
                                                                                                                 <br><br>For Python re syntax, refer to:  https://docs.python.org/3/library/re.html.  Its more gentle tutorial is:  https://docs.python.org/3/howto/regex.html \
                                                                                                                 <br><br>The use of a 'Virtual Library' while executing a TXT query for 'All Books' may cause a confusing results count, since MCS selects 'All Books' based on metadata.db, not what is currently displayed.")

        #-----------------------------------------------------
        #-----------------------------------------------------
        font.setPointSize(8)

        self.txt_query_options_layout = QHBoxLayout()
        self.txt_query_options_layout.setAlignment(Qt.AlignLeft)

        self.txt_query_layout.addLayout(self.txt_query_options_layout)

        self.activate_options_checkbox = QCheckBox()
        self.activate_options_checkbox.setText("When Found:")
        self.activate_options_checkbox.setFont(font)
        self.activate_options_checkbox.setToolTip("<p style='white-space:wrap'>Checking this box will activate the use of the criteria to the right.  You may use either or both. The use of Regular Expressions is optional.")

        self.txt_query_options_layout.addWidget(self.activate_options_checkbox)

        if prefs['OPTIONS_TEXT_ACTIVATE'] == "True":
            self.activate_options_checkbox.setChecked(True)

        self.compare_found_text_checkbox = QCheckBox()
        self.compare_found_text_checkbox.setText("Filter Using CC?")
        self.compare_found_text_checkbox.setFont(font)
        self.compare_found_text_checkbox.setToolTip("<p style='white-space:wrap'> Compare the search text found to a Custom Column?  This means that for the search text to be viewed as 'found', that search text must successfully be compared to the specified Custom Column.")

        self.txt_query_options_layout.addWidget(self.compare_found_text_checkbox)

        if prefs['OPTIONS_COMPARE_FOUND_TEXT'] == "True":
            self.compare_found_text_checkbox.setChecked(True)

        self.custom_column_compare_combobox = QComboBox()
        self.custom_column_compare_combobox.setEditable(False)
        self.custom_column_compare_combobox.setFont(font)

        self.custom_column_compare_combobox.setToolTip("<p style='white-space:wrap'>This is the Comparison Custom Column.  The search text will be compared to the value of this Custom Column.  The comparison can be further limited by a Regular Expression.  If a RE is not used, then the search text must be identical to the value of this Custom Column. ")
        self.txt_query_options_layout.addWidget(self.custom_column_compare_combobox)

        tmp_list = self.guidb.custom_field_keys(include_composites=False)
        custom_field_keys = []
        for label in tmp_list:
            cc_metadata_dict = self.guidb.custom_field_metadata(label)
            for k,v in iteritems(cc_metadata_dict):
                if k == label:
                    cc_datatype = v['datatype']
                    if cc_datatype == "text" or cc_datatype == "comments":
                        custom_field_keys.append(label)
                        break
            #END FOR
        #END FOR

        del tmp_list

        try:
            for label in custom_field_keys:
                self.custom_column_compare_combobox.addItem(label)
            #END FOR
        except:
            pass

        cc = prefs['OPTIONS_COMPARE_FOUND_TEXT_CC']
        if cc in custom_field_keys:
            i = self.custom_column_compare_combobox.findText(cc,Qt.MatchExactly)
            self.custom_column_compare_combobox.setCurrentIndex(i)


        self.custom_column_compare_regex_combobox = QComboBox()
        self.custom_column_compare_regex_combobox.setEditable(False)
        self.custom_column_compare_regex_combobox.setFont(font)

        self.custom_column_compare_regex_combobox.setToolTip("<p style='white-space:wrap'>This is the Regular Expression from the MCS Regular Expression Tab to further select the text to be compared.  Leave the Regular Expression blank to have the original value compared.  Example:  '[0-9][0-9][0-9]+' would select only 2 or more consecutive numbers within the found search text to be compared to the selected Comparison Custom Column.  ")
        self.txt_query_options_layout.addWidget(self.custom_column_compare_regex_combobox)

        self.custom_column_compare_regex_combobox.addItem("")    # None
        self.custom_column_compare_regex_combobox.addItem("1")  #prefs['REGEXVALUE_0']
        self.custom_column_compare_regex_combobox.addItem("2")
        self.custom_column_compare_regex_combobox.addItem("3")
        self.custom_column_compare_regex_combobox.addItem("4")
        self.custom_column_compare_regex_combobox.addItem("5")
        self.custom_column_compare_regex_combobox.addItem("6")
        self.custom_column_compare_regex_combobox.addItem("7")
        self.custom_column_compare_regex_combobox.addItem("8")
        self.custom_column_compare_regex_combobox.addItem("9")
        self.custom_column_compare_regex_combobox.addItem("10") #prefs['REGEXVALUE_9']

        regex = prefs['OPTIONS_COMPARE_FOUND_TEXT_REGEX']
        if regex  != "":
            i = self.custom_column_compare_regex_combobox.findText(regex,Qt.MatchExactly)
            self.custom_column_compare_regex_combobox.setCurrentIndex(i)

        self.update_found_text_checkbox = QCheckBox()
        self.update_found_text_checkbox.setText("Update this CC?")
        self.update_found_text_checkbox.setFont(font)
        self.update_found_text_checkbox.setToolTip("<p style='white-space:wrap'> Update the specified Custom Column with the search text found by the above query?")

        self.txt_query_options_layout.addWidget(self.update_found_text_checkbox)

        if prefs['OPTIONS_UPDATE_FOUND_TEXT'] == "True":
            self.update_found_text_checkbox.setChecked(True)

        if prefs['OPTIONS_TEXT_ACTIVATE'] == "True":
            self.update_found_text_checkbox.setChecked(False)  # Reduce chance the user makes a huge mistake and accidently updates without thinking about it...

        self.custom_column_update_combobox = QComboBox()
        self.custom_column_update_combobox.setEditable(False)
        self.custom_column_update_combobox.setFont(font)

        self.custom_column_update_combobox.setToolTip("<p style='white-space:wrap'>This is the Update Custom Column.  This Custom Column will be updated with the search text found by the above query.  The search text that is found may be further selected using a Regular Expression.  If no RE is specified, then the entire final search text will updated in this Custom Column.  ")
        self.txt_query_options_layout.addWidget(self.custom_column_update_combobox)

        try:
            for label in custom_field_keys:
                self.custom_column_update_combobox.addItem(label)
            #END FOR
        except:
            pass

        cc = prefs['OPTIONS_UPDATE_FOUND_TEXT_CC']
        if cc in custom_field_keys:
            i = self.custom_column_update_combobox.findText(cc,Qt.MatchExactly)
            self.custom_column_update_combobox.setCurrentIndex(i)

        del custom_field_keys

        self.custom_column_update_regex_combobox = QComboBox()
        self.custom_column_update_regex_combobox.setEditable(False)
        self.custom_column_update_regex_combobox.setFont(font)

        self.custom_column_update_regex_combobox.setToolTip("<p style='white-space:wrap'>This is the Regular Expression from the Regular Expression Tab to further select the text to be updated in the Custom Column.  Leave the Regular Expression blank to update using the original value.  Example:  '[0-9][0-9][0-9]+' would select only 2 or more consecutive numbers within a file path, such as 'Story URL: https://www.fanfiction.net/s/10742531/1/', within the found search text to be added to the selected Custom Column.  ")
        self.txt_query_options_layout.addWidget(self.custom_column_update_regex_combobox)

        self.custom_column_update_regex_combobox.addItem("")    # None
        self.custom_column_update_regex_combobox.addItem("1")  #prefs['REGEXVALUE_0']
        self.custom_column_update_regex_combobox.addItem("2")
        self.custom_column_update_regex_combobox.addItem("3")
        self.custom_column_update_regex_combobox.addItem("4")
        self.custom_column_update_regex_combobox.addItem("5")
        self.custom_column_update_regex_combobox.addItem("6")
        self.custom_column_update_regex_combobox.addItem("7")
        self.custom_column_update_regex_combobox.addItem("8")
        self.custom_column_update_regex_combobox.addItem("9")
        self.custom_column_update_regex_combobox.addItem("10") #prefs['REGEXVALUE_9']

        regex = prefs['OPTIONS_UPDATE_FOUND_TEXT_REGEX']
        if regex  != "":
            i = self.custom_column_update_regex_combobox.findText(regex,Qt.MatchExactly)
            self.custom_column_update_regex_combobox.setCurrentIndex(i)


        #-----------------------------------------------------
        #-----------------------------------------------------
        font.setPointSize(8)

        self.activate_all_author_books_checkbox = QCheckBox()
        self.activate_all_author_books_checkbox.setText("All Authors' Books?")
        self.activate_all_author_books_checkbox.setFont(font)
        self.activate_all_author_books_checkbox.setToolTip("<p style='white-space:wrap'>Checking this box causes all books of every Author otherwise in the search results to also be marked and displayed.")

        self.txt_query_layout.addWidget(self.activate_all_author_books_checkbox)

        self.add_final_filters_checkbox = QCheckBox()
        self.add_final_filters_checkbox.setText("Use Final Filters?")
        self.add_final_filters_checkbox.setFont(font)
        self.add_final_filters_checkbox.setToolTip("<p style='white-space:wrap'>Checking this box causes the active filters defined in the Final Filters Tab to be used at the very end of the search.")

        self.txt_query_layout.addWidget(self.add_final_filters_checkbox)

        #-----------------------------------------------------
        #-----------------------------------------------------
        self.push_button_load_saved_criteria_values = QPushButton(" ", self)
        self.push_button_load_saved_criteria_values.setText("Load Previously Saved Criteria?")
        self.push_button_load_saved_criteria_values.setToolTip("<p style='white-space:wrap'>Select a previously saved (with a name) set of criteria for this Tab.<br><br>The checkmarks for All Authors' Books and Use Final Filters are not saved, and must be selected separately for each executed Query.")
        self.push_button_load_saved_criteria_values.clicked.connect(self.load_criteria_settings_virtualcolumntxttab)
        self.txt_query_layout.addWidget(self.push_button_load_saved_criteria_values)


        self.push_button_execute_txt_query_selected = QPushButton(" ", self)
        self.push_button_execute_txt_query_selected.setText("Save and Execute the TXT Query [Selected Books with either TXT Formats or in the FTS Index]")
        self.push_button_execute_txt_query_selected.setToolTip("<p style='white-space:wrap'>Save (with a name) all criteria for this Tab, then Execute the TXT Query [Selected Books] [TXT Formats or in the FTS Index].")
        self.push_button_execute_txt_query_selected.clicked.connect(self.execute_txt_query_selected)
        self.txt_query_layout.addWidget(self.push_button_execute_txt_query_selected)


        self.push_button_execute_txt_query_all = QPushButton(" ", self)
        self.push_button_execute_txt_query_all.setText("Save and Execute the TXT Query [All Books with either TXT Formats or in the FTS Index]")
        self.push_button_execute_txt_query_all.setToolTip("<p style='white-space:wrap'>Save (with a name) all criteria for this Tab, then Execute the TXT Query [All Books] [TXT Formats or in the FTS Index].")
        self.push_button_execute_txt_query_all.clicked.connect(self.execute_txt_query_all)
        self.txt_query_layout.addWidget(self.push_button_execute_txt_query_all)

        #-----------------------------------------------------
        #-----------------------------------------------------
        #-----------------------------------------------------
        self.resize(self.sizeHint())
        #-----------------------------------------------------
        #-----------------------------------------------------
        #-----------------------------------------------------
        #-----------------------------------------------------
        #-----------------------------------------------------
    #-----------------------------------------------------------------------------------------------
    #-----------------------------------------------------------------------------------------------
    #-----------------------------------------------------------------------------------------------
    def execute_txt_query_selected(self):
        sel_type = "selected"
        self.execute_txt_query(sel_type)
    def execute_txt_query_all(self):
        sel_type = "all"
        self.execute_txt_query(sel_type)
    def execute_txt_query(self,sel_type):
        global prefs
        param_dict = {}
        #~ -------------------
        txt_search_terms = self.txt_query_qtextedit.toPlainText()

        prefs['TXT_QUERY_LAST_CURRENT'] = txt_search_terms.strip()
        #~ -------------------
        param_dict['TXT_SEARCH_TERMS'] = txt_search_terms.strip()
        #~ -------------------
        param_dict['OPTIONS_TEXT_ACTIVATE'] = "False"
        if self.activate_options_checkbox.isChecked():
            param_dict['OPTIONS_TEXT_ACTIVATE'] = "True"

        prefs['OPTIONS_TEXT_ACTIVATE'] = param_dict['OPTIONS_TEXT_ACTIVATE']

        param_dict['OPTIONS_COMPARE_FOUND_TEXT'] = "False"
        param_dict['OPTIONS_COMPARE_FOUND_TEXT_CC'] = ""
        param_dict['OPTIONS_COMPARE_FOUND_TEXT_REGEX'] = ""
        if self.compare_found_text_checkbox.isChecked():
            param_dict['OPTIONS_COMPARE_FOUND_TEXT'] = "True"
            param_dict['OPTIONS_COMPARE_FOUND_TEXT_CC'] = self.custom_column_compare_combobox.currentText()
            param_dict['OPTIONS_COMPARE_FOUND_TEXT_REGEX'] = self.custom_column_compare_regex_combobox.currentText()
            prefs['OPTIONS_COMPARE_FOUND_TEXT_CC'] = param_dict['OPTIONS_COMPARE_FOUND_TEXT_CC']
            prefs['OPTIONS_COMPARE_FOUND_TEXT_REGEX'] = param_dict['OPTIONS_COMPARE_FOUND_TEXT_REGEX']

        prefs['OPTIONS_COMPARE_FOUND_TEXT'] = param_dict['OPTIONS_COMPARE_FOUND_TEXT']


        param_dict['OPTIONS_UPDATE_FOUND_TEXT'] = "False"
        param_dict['OPTIONS_UPDATE_FOUND_TEXT_CC'] = ""
        param_dict['OPTIONS_UPDATE_FOUND_TEXT_REGEX'] = ""
        if self.update_found_text_checkbox.isChecked():
            param_dict['OPTIONS_UPDATE_FOUND_TEXT'] = "True"
            param_dict['OPTIONS_UPDATE_FOUND_TEXT_CC'] = self.custom_column_update_combobox.currentText()
            param_dict['OPTIONS_UPDATE_FOUND_TEXT_REGEX'] = self.custom_column_update_regex_combobox.currentText()
            prefs['OPTIONS_UPDATE_FOUND_TEXT_CC'] = param_dict['OPTIONS_UPDATE_FOUND_TEXT_CC']
            prefs['OPTIONS_UPDATE_FOUND_TEXT_REGEX'] = param_dict['OPTIONS_UPDATE_FOUND_TEXT_REGEX']

        prefs['OPTIONS_UPDATE_FOUND_TEXT'] = param_dict['OPTIONS_UPDATE_FOUND_TEXT']

        if param_dict['OPTIONS_COMPARE_FOUND_TEXT'] == "False":
            if param_dict['OPTIONS_UPDATE_FOUND_TEXT'] == "False":
                param_dict['OPTIONS_TEXT_ACTIVATE'] = "False"
                prefs['OPTIONS_TEXT_ACTIVATE'] = param_dict['OPTIONS_TEXT_ACTIVATE']

        prefs
        #~ -------------------

        param_dict['ALL_AUTHORS_BOOKS'] = "False"
        param_dict['USE_FINAL_FILTERS'] = "False"
        if self.add_final_filters_checkbox.isChecked():
            param_dict['USE_FINAL_FILTERS'] = "True"
        if self.activate_all_author_books_checkbox.isChecked():
            param_dict['ALL_AUTHORS_BOOKS'] = "True"

        if self.add_final_filters_checkbox.isChecked():
            if  prefs['FINAL_FILTERS_LAST_SAVED'] != prefs['FINAL_FILTERS_LAST_VALIDATED']:
                error_dialog(self.gui, _('MCS'),_(("Final Filters have not been Validated since they were last Saved.<br><br>\
                                                                    Execution Canceled. ")), show=True)
                del param_dict
                return
            if prefs['FINAL_FILTERS_PASSED_VALIDATION'] != "True" and prefs['USE_FINAL_FILTERS'] == "True":
                error_dialog(self.gui, _('MCS'),_(("Final Filters failed Validation.  They cannot be used until they pass.<br><br>\
                                                                    Execution Canceled. ")), show=True)
                del param_dict
                return
        #~ -------------------

        #~ ----------------------------------------------------------------------------------
        #~ Save actual values temporarily
        #~ ----------------------------------------------------------------------------------
        save1 = param_dict['ALL_AUTHORS_BOOKS']
        save2 = param_dict['USE_FINAL_FILTERS']
        #~ ----------------------------------------------------------------------------------
        #~ These 2 options are selected at query execution time only, and never saved
        #~ ----------------------------------------------------------------------------------
        param_dict['ALL_AUTHORS_BOOKS'] = "False"
        param_dict['USE_FINAL_FILTERS'] = "False"
        #~ ----------------------------------------------------------------------------------
        param_dict[TXT_QUERIES_TYPE] = TXT_QUERIES_TYPE
        current_tab = VIRTUALCOLUMNTXTTAB
        prefs = self.save_settings_parm_history_to_prefs_generic(prefs,current_tab,param_dict)
        #~ ----------------------------------------------------------------------------------
        #~ Restore saved values after self.save_settings_parm_history_to_prefs_generic()
        #~ ----------------------------------------------------------------------------------
        param_dict['ALL_AUTHORS_BOOKS'] = save1
        param_dict['USE_FINAL_FILTERS'] = save2
        prefs['ALL_AUTHORS_BOOKS'] = save1
        prefs['USE_FINAL_FILTERS'] = save2
        prefs
        #~ ----------------------------------------------------------------------------------

        self.search_virtual_column_format_txt_control(self.guidb,param_dict,sel_type)

        #~ -------------------

        if DEBUG:
            for k,v in iteritems(param_dict):
                print(k,v)
            #END FOR


        del param_dict
    #-----------------------------------------------------------------------------------------------
    def load_criteria_settings_virtualcolumntxttab(self):
        self.load_criteria_settings_generic(current_tab=VIRTUALCOLUMNTXTTAB)
    #-----------------------------------------------------------------------------------------------
    def unpack_selected_parm_virtualcolumntxttab(self,selected_parm,parm_dict):

        n = selected_parm[-1: ]
        if n.isdigit and isinstance(parm_dict,dict):
            n = int(n)
        else:
            if DEBUG: print("virtualcolumntxttab: parm and/or parm_dict to restore is corrupt; nothing can be done...")
            return False

        saveddate,type,vdict,parm = parm_dict[n]   #for actual restoration of loaded criteria

        if DEBUG:
            for k, v in iteritems(vdict):
                print(as_unicode(k), " = ", as_unicode(v))

        txt = vdict['TXT_SEARCH_TERMS'].strip()
        self.txt_query_qtextedit.setPlainText(txt)

        if vdict['OPTIONS_TEXT_ACTIVATE']  ==  "True":
            self.activate_options_checkbox.setChecked(True)
        else:
            self.activate_options_checkbox.setChecked(False)

        if vdict['OPTIONS_COMPARE_FOUND_TEXT']  ==  "True":
            self.compare_found_text_checkbox.setChecked(True)
        else:
            self.compare_found_text_checkbox.setChecked(False)

        cc = vdict['OPTIONS_COMPARE_FOUND_TEXT_CC']
        i = self.custom_column_compare_combobox.findText(cc)
        self.custom_column_compare_combobox.setCurrentIndex(i)

        cc = vdict['OPTIONS_COMPARE_FOUND_TEXT_REGEX']
        i = self.custom_column_compare_regex_combobox.findText(cc)
        self.custom_column_compare_regex_combobox.setCurrentIndex(i)

        if vdict['OPTIONS_UPDATE_FOUND_TEXT']  ==  "True":
            self.update_found_text_checkbox.setChecked(True)
        else:
            self.update_found_text_checkbox.setChecked(False)

        cc = vdict['OPTIONS_UPDATE_FOUND_TEXT_CC']
        i = self.custom_column_update_combobox.findText(cc)
        self.custom_column_update_combobox.setCurrentIndex(i)

        cc = vdict['OPTIONS_UPDATE_FOUND_TEXT_REGEX']
        i = self.custom_column_update_regex_combobox.findText(cc)
        self.custom_column_update_regex_combobox.setCurrentIndex(i)

        self.activate_all_author_books_checkbox.setChecked(False)
        self.add_final_filters_checkbox.setChecked(False)

        self.update()

        if DEBUG: print("*** All virtualcolumntxttab widgets have been reset per loaded criteria selected by user ***")

        return True
#--------------------------------------------------------------------------------------------------
#--------------------------------------------------------------------------------------------------
#--------------------------------------------------------------------------------------------------
#--------------------------------------------------------------------------------------------------
class MCSWordBookIndexQueryTab(QWidget):
    # a.k.a. "Word Queries"
    prefs = None
    #-----------------------------------------------------------------------------------------------
    def __init__(self,gui,icon,guidb,mcsprefs,search_word_in_book_query_control,mcs_build_index_job_control,mcs_trim_index_job_control,custom_column_label_dict,
                        load_criteria_settings_generic,create_criteria_parm_list_generic,save_settings_parm_history_to_prefs_generic,unpack_selected_parm_generic):
        super(MCSWordBookIndexQueryTab, self).__init__()

        self.gui = gui
        self.icon = icon
        self.guidb = guidb

        global prefs
        prefs = mcsprefs

        self.search_word_in_book_query_control = search_word_in_book_query_control
        self.mcs_build_index_job_control = mcs_build_index_job_control
        self.mcs_trim_index_job_control = mcs_trim_index_job_control
        self.custom_column_label_dict = custom_column_label_dict
        self.load_criteria_settings_generic = load_criteria_settings_generic
        self.create_criteria_parm_list_generic = create_criteria_parm_list_generic
        self.save_settings_parm_history_to_prefs_generic = save_settings_parm_history_to_prefs_generic
        self.unpack_selected_parm_generic = unpack_selected_parm_generic

        #-----------------------------------------------------
        #-----------------------------------------------------
        #-----------------------------------------------------
        #-----------------------------------------------------
        font = QFont()
        font.setBold(False)
        font.setPointSize(10)
        #-----------------------------------------------------
        self.layout_frame = QGridLayout()
        self.layout_frame.setSpacing(0)
        self.layout_frame.setContentsMargins(QMargins(0,0,0,0));
        self.setLayout(self.layout_frame)

        s_tooltip = "<p style='white-space:wrap'>This Tab is used to build and maintain a 'Word-by-Book' index within Calibre, and then to execute queries against that index.\
                                                                            <br><br>The Word-by-Book' index is built from each book's TXT format.  Optionally, a CSV file can be imported to build (or enhance) the index for specific Books. \
                                                                            <br><br>In order to optimize the index, it may be 'Trimmed' by deleting uninteresting and/or undesirable words."
        self.setToolTip(s_tooltip)
        #-----------------------------------------------------
        #-----------------------------------------------------
        #-----------------------------------------------------
        #-----------------------------------------------------
        #-----------------------------------------------------

        self.word_query_groupbox = QGroupBox('Word-in-Book Index:  Queries')
        self.word_query_groupbox.setToolTip("<p style='white-space:wrap'>This group of options is used to query word-book combinations that may or may not exist in the index.")
        self.word_query_groupbox.setMinimumWidth(900)
        self.word_query_groupbox.setMaximumWidth(900)
        self.word_query_groupbox.setMinimumHeight(50)
        self.word_query_groupbox.setMaximumHeight(300)
        self.layout_frame.addWidget(self.word_query_groupbox)

        self.word_query_layout = QVBoxLayout()
        self.word_query_layout.setAlignment(Qt.AlignCenter)
        self.word_query_groupbox.setLayout(self.word_query_layout)

        font.setPointSize(12)
        font.setBold(False)

        self.word_query_qtextedit =  QTextEdit("")
        self.word_query_qtextedit.setAcceptRichText(True)
        self.word_query_qtextedit.setReadOnly(False)
        self.word_query_qtextedit.setFont(font)
        self.word_query_qtextedit.setWordWrapMode(QTextOption.WrapMode.WordWrap)
        self.word_query_qtextedit.setMinimumHeight(0)
        self.word_query_qtextedit.setMaximumHeight(50)
        self.word_query_qtextedit.setMinimumWidth(400)
        self.word_query_qtextedit.setMaximumWidth(400)
        self.word_query_qtextedit.clear()

        if 'WORD_SEARCH_TERMS' in prefs:                 #__my_version__ = "1.0.86"   # New: Saved Searches Function
            self.word_query_text = prefs['WORD_SEARCH_TERMS']
        elif 'WORD_QUERY_LAST_CURRENT' in prefs:  # user's saved value prior to 1.0.86, so need to convert it...one time only...
            self.word_query_text =  prefs['WORD_QUERY_LAST_CURRENT']
            prefs['WORD_SEARCH_TERMS'] = self.word_query_text
            del prefs['WORD_QUERY_LAST_CURRENT']
            prefs
        else:
            self.word_query_text  = "ägypten|%ribonucleic%|Φοινικικοζ"  # default for first-time users
            prefs['WORD_SEARCH_TERMS'] = self.word_query_text
            prefs

        if self.word_query_text == "": # default for all users if empty string
            self.word_query_text  = "ägypten|%ribonucleic%|Φοινικικοζ"

        self.word_query_qtextedit.setPlainText(self.word_query_text)

        self.word_query_layout.addWidget(self.word_query_qtextedit)

        self.word_query_qtextedit.setToolTip("<p style='white-space:wrap'>Enter the WORD you wish to search for here.  Do not enclose the word in quotes.\
                                                                                                                    <br><br>Multiple WORDS may be specified by using the bar symbol to mean either 'OR' or 'AND'.\
                                                                                                                    <br><br>Example: Egypt|Sudan|Ethiopia \
                                                                                                                    <br><br>If (and only if) the bar symbol means 'AND', the exclamation symbol '!' may be used at the beginning of a word to mean 'NOT'.\
                                                                                                                    <br><br>Example: !Egypt|Sudan|Ethiopia<br>Example: Egypt|!Sudan|!Ethiopia\
                                                                                                                    <br><br><br>MCS will treat each WORD as a 'pattern' to be searched for in the Word-Book index.\
                                                                                                                    <br><br>Optionally, variable WORD patterns may be specified by using the '%' and '_' symbols.  \
                                                                                                                    <br><br>Refer to the 'Final Filters' Tab for a full explanation of those symbols for use with 'LIKE', although in this Tab MCS does <b>NOT</b> automatically add a '%' before and after each unique word.  That means it searches for 'equals to' unless you specify a 'LIKE' style wildcard.\
                                                                                                                    <br><br>The use of a 'Virtual Library' while executing a Word query for 'All Books' may cause a confusing results count, since MCS selects 'All Books' based on metadata.db, not what is currently displayed.")

        #-----------------------------------------------------
        #-----------------------------------------------------
        font.setPointSize(10)

        self.bar_is_and_not_or_checkbox = QCheckBox()
        self.bar_is_and_not_or_checkbox.setText("A 'bar' ( '|' ) means 'AND' instead of 'OR'; '!' means 'NOT' ")
        self.bar_is_and_not_or_checkbox.setFont(font)
        s = "<p style='white-space:wrap'>Checking this box causes the query to require that 'ALL' of the specified words exist in the index rather than 'ANY' of the words.\
                                                                <br><br>When (and only when) this checkbox is checked, the exclamation symbol '!' may be placed at the beginning of a word to mean 'NOT'.  "
        self.bar_is_and_not_or_checkbox.setToolTip(s)

        self.word_query_layout.addWidget(self.bar_is_and_not_or_checkbox)

        self.auto_index_checkbox = QCheckBox()
        s = "Automatically Index Unindexed Books? [Selection Maximum: [N]]"
        s = s.replace("[N]",as_unicode(MAX_AUTO_INDEX_SELECTED_BOOKS))
        self.auto_index_checkbox.setText(s)
        self.auto_index_checkbox.setFont(font)
        self.auto_index_checkbox.setToolTip("<p style='white-space:wrap'>Checking this box causes the selected books to be indexed if necessary.  This is a convenience, and not designed or intended to be used routinely in lieu of the normal indexing job.  ")

        self.word_query_layout.addWidget(self.auto_index_checkbox)

        self.auto_index_checkbox.setChecked(False)

        self.activate_all_author_books_checkbox = QCheckBox()
        self.activate_all_author_books_checkbox.setText("All Authors' Books?")
        self.activate_all_author_books_checkbox.setFont(font)
        self.activate_all_author_books_checkbox.setToolTip("<p style='white-space:wrap'>Checking this box causes all books of every Author otherwise in the search results to also be marked and displayed.")

        self.word_query_layout.addWidget(self.activate_all_author_books_checkbox)

        self.add_final_filters_checkbox = QCheckBox()
        self.add_final_filters_checkbox.setText("Use Final Filters?")
        self.add_final_filters_checkbox.setFont(font)
        self.add_final_filters_checkbox.setToolTip("<p style='white-space:wrap'>Checking this box causes the active filters defined in the Final Filters Tab to be used at the very end of the search.")

        self.word_query_layout.addWidget(self.add_final_filters_checkbox)

        #-----------------------------------------------------
        #-----------------------------------------------------
        self.push_button_load_saved_criteria_values = QPushButton(" ", self)
        self.push_button_load_saved_criteria_values.setText("Load Previously Saved Criteria?")
        self.push_button_load_saved_criteria_values.setToolTip("<p style='white-space:wrap'>Select a previously saved (with a name) set of criteria for this Tab.<br><br>The checkmarks for All Authors' Books and Use Final Filters are not saved, and must be selected separately for each executed Query.")
        self.push_button_load_saved_criteria_values.clicked.connect(self.load_criteria_settings_wordbookindexquerytab)
        self.word_query_layout.addWidget(self.push_button_load_saved_criteria_values)

        self.push_button_execute_word_query_selected = QPushButton(" ", self)
        self.push_button_execute_word_query_selected.setText("Save and Execute the Word-in-Book Query [Selected Indexed Books]")
        self.push_button_execute_word_query_selected.setToolTip("<p style='white-space:wrap'>Save (with a name) all criteria for this Tab, then Execute the Word-in-Book Query [Selected Books] [Indexed TXT Formats Only].")
        self.push_button_execute_word_query_selected.clicked.connect(self.execute_word_query_selected)
        self.word_query_layout.addWidget(self.push_button_execute_word_query_selected)

        self.push_button_execute_word_query_selected.setDefault(True)


        self.push_button_execute_word_query_all = QPushButton(" ", self)
        self.push_button_execute_word_query_all.setText("Save and Execute the Word-in-Book Query [All Indexed Books]")
        self.push_button_execute_word_query_all.setToolTip("<p style='white-space:wrap'>Save (with a name) all criteria for this Tab, then Execute the Word-in-Book Query [All Books] [Indexed TXT Formats Only].")
        self.push_button_execute_word_query_all.clicked.connect(self.execute_word_query_all)
        self.word_query_layout.addWidget(self.push_button_execute_word_query_all)
        #-----------------------------------------------------
        #-----------------------------------------------------
        #-----------------------------------------------------
        #-----------------------------------------------------
        #-----------------------------------------------------
        font.setPointSize(10)
        font.setBold(False)

        if not 'WORD_INDEX_LATEST_RECORD_COUNT' in prefs:
            prefs['WORD_INDEX_LATEST_RECORD_COUNT'] = "0"
            prefs

        s = WORD_QUERIES_INDEXING_GROUPBOX_TITLE + prefs['WORD_INDEX_LATEST_RECORD_COUNT'] +  "]"

        self.index_admin_groupbox = QGroupBox(s)
        self.index_admin_groupbox.setToolTip("<p style='white-space:wrap'>This group of options is used to add new word-book combinations to the index.")
        self.index_admin_groupbox.setMinimumWidth(900)
        self.index_admin_groupbox.setMaximumWidth(900)
        self.index_admin_groupbox.setMinimumHeight(50)
        self.index_admin_groupbox.setMaximumHeight(300)
        self.layout_frame.addWidget(self.index_admin_groupbox)

        self.index_admin_layout = QVBoxLayout()
        self.index_admin_layout.setAlignment(Qt.AlignCenter)
        self.index_admin_groupbox.setLayout(self.index_admin_layout)

        if not 'WORD_INDEX_MINIMUM_NUMBER_OF_LETTERS'  in prefs:
            prefs['WORD_INDEX_MINIMUM_NUMBER_OF_LETTERS'] = 6
            prefs

        self.min_word_length_spin = QSpinBox(self)
        self.min_word_length_spin.setMinimum(3)
        self.min_word_length_spin.setMaximum(10)
        self.min_word_length_spin.setToolTip("<p style='white-space:wrap'>Specify the minimum number of letters in a word in order to add it to the index.<br><br>The index may grow quite large if every word is indexed, regardless of its value or interest, so the shortest word allowed is 3 letters.")
        self.min_word_length_spin.setProperty('value',prefs['WORD_INDEX_MINIMUM_NUMBER_OF_LETTERS'])
        self.min_word_length_spin.setSuffix("       Minimum Letters in Words to Index                                                                              ")
        self.min_word_length_spin.setMaximumWidth(400)
        self.index_admin_layout.addWidget(self.min_word_length_spin)

        if not 'WORD_INDEX_SKIP_REGEX'  in prefs:
            prefs['WORD_INDEX_SKIP_REGEX'] = "(\w)\1{2,}(?#Ignore words with 3+ repeating letters, such as 'xxx' or 'www' )"
            prefs

        self.regex_to_skip_words_qlineedit = QLineEdit(self)
        self.regex_to_skip_words_qlineedit.setText(prefs['WORD_INDEX_SKIP_REGEX'])
        self.regex_to_skip_words_qlineedit.setMinimumWidth(400)
        self.regex_to_skip_words_qlineedit.setMaximumWidth(400)
        self.regex_to_skip_words_qlineedit.setToolTip("<p style='white-space:wrap'>Specify a regular expression to be used to 'skip' undesirable words during indexing.  Use the 'bar' symbol to separate multiple regular expressions.")
        self.index_admin_layout.addWidget(self.regex_to_skip_words_qlineedit)

        self.index_options_checkboxes_layout = QHBoxLayout()
        self.index_options_checkboxes_layout.setAlignment(Qt.AlignCenter)

        self.index_admin_layout.addLayout(self.index_options_checkboxes_layout)

        self.update_mcs_indexed_custom_column_checkbox = QCheckBox()
        self.update_mcs_indexed_custom_column_checkbox.setText("Update the '#mcs_was_indexed' Custom Column?")
        self.update_mcs_indexed_custom_column_checkbox.setFont(font)
        self.update_mcs_indexed_custom_column_checkbox.setToolTip("<p style='white-space:wrap'>Optional but recommended.  Checking this box causes a 'yes/no' Custom Column (that you created) named exactly 'mcs_was_indexed' to be updated.  If that Custom Column does not exist, then this option will be ignored.")

        self.index_options_checkboxes_layout.addWidget(self.update_mcs_indexed_custom_column_checkbox)

        if not 'WORD_INDEX_UPDATE_MCS_INDEXED_CUSTOM_COLUMN' in prefs:
            prefs['WORD_INDEX_UPDATE_MCS_INDEXED_CUSTOM_COLUMN'] = "False"
            prefs

        if not '#mcs_was_indexed' in self.custom_column_label_dict:
            prefs['WORD_INDEX_UPDATE_MCS_INDEXED_CUSTOM_COLUMN'] = "False"
            prefs

        if prefs['WORD_INDEX_UPDATE_MCS_INDEXED_CUSTOM_COLUMN'] == "True":
            self.update_mcs_indexed_custom_column_checkbox.setChecked(True)

        self.csv_index_word_list_checkbox = QCheckBox()
        self.csv_index_word_list_checkbox.setText("CSV")
        self.csv_index_word_list_checkbox.setFont(font)
        s = "<p style='white-space:wrap'>Checking this box causes the indexing job to import a CSV file to be used to update the index.\
                                                            <br><br>The CSV file must:\
                                                            <br>[1] Be Comma Separated (not Tab or Space or any other character);\
                                                            <br>[2] Be 'Unicode UTF-8' encoded.  Refer to the 'save' or 'filter' or 'encoding' options in your spreadsheet program;\
                                                            <br>[3] Have exactly two (2) columns:  Book and Word.\
                                                            <br>[4] Have a Book that is the <b>Calibre Book ID</b>, which is an <b>integer</b>. \
                                                            <br>[5] Have a Word that is enclosed with double-quotes.  \
                                                            <br><br>Example row from a CSV file that is viewed using a normal text editor:      " + '6785,"φεpáπalvav" '

        self.csv_index_word_list_checkbox.setToolTip(s)
        self.index_options_checkboxes_layout.addWidget(self.csv_index_word_list_checkbox)

        if not 'WORD_INDEX_ADD_CSV'  in prefs:
            prefs['WORD_INDEX_ADD_CSV'] = "False"
            prefs

        if prefs['WORD_INDEX_ADD_CSV'] == "True":
            self.csv_index_word_list_checkbox.setChecked(True)

        self.push_button_execute_indexing_selected = QPushButton(" ", self)
        self.push_button_execute_indexing_selected.setText("Index/Reindex [Selected Books with TXT Formats]")
        self.push_button_execute_indexing_selected.setToolTip("<p style='white-space:wrap'>Execute the job that indexes or reindexes selected Books that have pre-existing TXT formats.")
        self.push_button_execute_indexing_selected.setMinimumWidth(400)
        self.push_button_execute_indexing_selected.setMaximumWidth(400)
        self.push_button_execute_indexing_selected.clicked.connect(self.execute_indexing_selected)
        self.index_admin_layout.addWidget(self.push_button_execute_indexing_selected)

        self.push_button_execute_indexing_selected.setDefault(False)

        self.push_button_execute_indexing_all = QPushButton(" ", self)
        self.push_button_execute_indexing_all.setText("Index/Reindex [All Books with TXT Formats]")
        self.push_button_execute_indexing_all.setToolTip("<p style='white-space:wrap'>Execute the job that indexes or reindexes all Books that have pre-existing TXT formats.")
        self.push_button_execute_indexing_all.setMinimumWidth(400)
        self.push_button_execute_indexing_all.setMaximumWidth(400)
        self.push_button_execute_indexing_all.clicked.connect(self.execute_indexing_all)
        self.index_admin_layout.addWidget(self.push_button_execute_indexing_all)

        self.push_button_execute_indexing_all.setDefault(False)

        self.push_button_execute_indexing_unindexed = QPushButton(" ", self)
        self.push_button_execute_indexing_unindexed.setText("Index Unindexed Only [All Unindexed Books with TXT Formats]")
        self.push_button_execute_indexing_unindexed.setToolTip("<p style='white-space:wrap'>Execute the job that indexes all unindexed Books that have pre-existing TXT formats.")
        self.push_button_execute_indexing_unindexed.setMinimumWidth(400)
        self.push_button_execute_indexing_unindexed.setMaximumWidth(400)
        self.push_button_execute_indexing_unindexed.clicked.connect(self.execute_indexing_unindexed)
        self.index_admin_layout.addWidget(self.push_button_execute_indexing_unindexed)

        self.push_button_execute_indexing_unindexed.setDefault(False)
        #-----------------------------------------------------
        #-----------------------------------------------------
        #-----------------------------------------------------
        #-----------------------------------------------------
        #-----------------------------------------------------
        s = 'Word-in-Book Index:  Trimming'
        self.index_trim_purge_groupbox = QGroupBox(s)
        self.index_trim_purge_groupbox.setToolTip("<p style='white-space:wrap'>This group of options is used to trim/delete/purge words from the index to optimize its size.")
        self.index_trim_purge_groupbox.setMinimumWidth(900)
        self.index_trim_purge_groupbox.setMaximumWidth(900)
        self.index_trim_purge_groupbox.setMinimumHeight(50)
        self.index_trim_purge_groupbox.setMaximumHeight(300)
        self.layout_frame.addWidget(self.index_trim_purge_groupbox)

        self.index_trim_purge_layout = QVBoxLayout()
        self.index_trim_purge_layout.setAlignment(Qt.AlignCenter)
        self.index_trim_purge_groupbox.setLayout(self.index_trim_purge_layout)

        if not 'WORD_INDEX_DELETION_REGEX'  in prefs:
            prefs['WORD_INDEX_DELETION_REGEX'] = "^abcde(?#Purpose:  Starts with 'abcde'  )"
            prefs

        self.regex_to_delete_words_qlineedit = QLineEdit(self)
        self.regex_to_delete_words_qlineedit.setText(prefs['WORD_INDEX_DELETION_REGEX'])
        self.regex_to_delete_words_qlineedit.setMinimumWidth(400)
        self.regex_to_delete_words_qlineedit.setMaximumWidth(400)
        self.regex_to_delete_words_qlineedit.setToolTip("<p style='white-space:wrap'>Regular Expression that will be used to delete any matching Words from the index.")
        self.index_trim_purge_layout.addWidget(self.regex_to_delete_words_qlineedit)

        self.push_button_execute_trim_index_basic = QPushButton(" ", self)
        self.push_button_execute_trim_index_basic.setText("Trim Index per Minimum Letters && Regex [Selected Books]")
        self.push_button_execute_trim_index_basic.setToolTip("<p style='white-space:wrap'>Execute the job that will delete any Words from the index that either do not have the current Minimum Letter count, or that match the Regular Expression.  This job may be termed as 'Basic Trimming'.")
        self.push_button_execute_trim_index_basic.setMinimumWidth(400)
        self.push_button_execute_trim_index_basic.setMaximumWidth(400)
        self.push_button_execute_trim_index_basic.clicked.connect(self.execute_trim_index_basic)
        self.index_trim_purge_layout.addWidget(self.push_button_execute_trim_index_basic)

        self.push_button_execute_trim_index_basic.setDefault(True)

        self.english_checkboxes_layout = QHBoxLayout()
        self.english_checkboxes_layout.setAlignment(Qt.AlignCenter)

        self.index_trim_purge_layout.addLayout(self.english_checkboxes_layout)

        self.english_top_100_checkbox = QCheckBox()
        self.english_top_100_checkbox.setText("Top 100 English Nouns?")
        self.english_top_100_checkbox.setFont(font)
        self.english_top_100_checkbox.setToolTip("<p style='white-space:wrap'>Checking this box causes any Words in the index that are in the list of '100 Most Common English Nouns' to be deleted.")
        self.english_checkboxes_layout.addWidget(self.english_top_100_checkbox)

        if not 'WORD_INDEX_TRIM_ENGLISH_TOP_100'  in prefs:
            prefs['WORD_INDEX_TRIM_ENGLISH_TOP_100'] = "True"
            prefs

        if prefs['WORD_INDEX_TRIM_ENGLISH_TOP_100'] == "True":
            self.english_top_100_checkbox.setChecked(True)

        self.english_bad_word_list_checkbox = QCheckBox()
        self.english_bad_word_list_checkbox.setText("English Non-Nouns?")
        self.english_bad_word_list_checkbox.setFont(font)
        self.english_bad_word_list_checkbox.setToolTip("<p style='white-space:wrap'>Checking this box causes a list of over 18,000 English non-nouns to be deleted from the index.  This list is identical to that used by the 'English Noun Frequency' plug-in to ignore non-nouns.")
        self.english_checkboxes_layout.addWidget(self.english_bad_word_list_checkbox)


        if not 'WORD_INDEX_TRIM_ENGLISH_BAD_LIST'  in prefs:
            prefs['WORD_INDEX_TRIM_ENGLISH_BAD_LIST'] = "True"
            prefs

        if prefs['WORD_INDEX_TRIM_ENGLISH_BAD_LIST'] == "True":
            self.english_bad_word_list_checkbox.setChecked(True)

        self.asian_word_list_checkbox = QCheckBox()
        self.asian_word_list_checkbox.setText("漢")
        self.asian_word_list_checkbox.setFont(font)
        self.asian_word_list_checkbox.setToolTip("<p style='white-space:wrap'>Checking this box causes pictograms to be deleted from the index.  The alphabets to be deleted are:  Han (Chinese, Old Japanese, Old Korean, Old Vietnamese); Modern Japanese; and Modern Korean.")
        self.english_checkboxes_layout.addWidget(self.asian_word_list_checkbox)

        if not 'WORD_INDEX_TRIM_HAN'  in prefs:
            prefs['WORD_INDEX_TRIM_HAN'] = "True"
            prefs

        if prefs['WORD_INDEX_TRIM_HAN'] == "True":
            self.asian_word_list_checkbox.setChecked(True)

        self.csv_trim_word_list_checkbox = QCheckBox()
        self.csv_trim_word_list_checkbox.setText("CSV")
        self.csv_trim_word_list_checkbox.setFont(font)
        s = "<p style='white-space:wrap'>Checking this box causes the indexing job to import a CSV file to be used to delete words from the index.\
                                                            <br><br>The CSV file must:\
                                                            <br>[1] Be Comma Separated (not Tab or Space or any other character);\
                                                            <br>[2] Be Unicode UTF-8 encoded.  Refer to the 'save' or 'filter' or 'encoding' options in your spreadsheet program;\
                                                            <br>[3] Have exactly one (1) column:  Word.\
                                                            <br>[4] Have a Word that is enclosed with double-quotes.  \
                                                            <br><br>Example row from a CSV file that is viewed using a normal text editor:      " + '    "φεpáπalvav" '
        self.csv_trim_word_list_checkbox.setToolTip(s)
        self.english_checkboxes_layout.addWidget(self.csv_trim_word_list_checkbox)

        if not 'WORD_INDEX_TRIM_CSV'  in prefs:
            prefs['WORD_INDEX_TRIM_CSV'] = "False"
            prefs

        if prefs['WORD_INDEX_TRIM_CSV'] == "True":
            self.csv_trim_word_list_checkbox.setChecked(True)

        self.push_button_execute_trim_index_advanced = QPushButton(" ", self)
        self.push_button_execute_trim_index_advanced.setText("Trim Index per English/漢/CSV Options [All Books]")
        self.push_button_execute_trim_index_advanced.setToolTip("<p style='white-space:wrap'>Execute the job that will delete any Words from the index according to the English/漢/CSV checkboxes.  This job may be termed as 'Advanced Trimming'.")
        self.push_button_execute_trim_index_advanced.setMinimumWidth(400)
        self.push_button_execute_trim_index_advanced.setMaximumWidth(400)
        self.push_button_execute_trim_index_advanced.clicked.connect(self.execute_trim_index_advanced)
        self.index_trim_purge_layout.addWidget(self.push_button_execute_trim_index_advanced)

        self.line_1_label = QLabel('─────────────────────────────────────────────────────────────────────────────────────────────────────────')
        self.line_1_label.setMaximumHeight(10)
        self.line_1_label.setMinimumWidth(400)
        self.line_1_label.setMaximumWidth(400)
        self.index_trim_purge_layout.addWidget(self.line_1_label)

        self.push_button_execute_purge_index = QPushButton(" ", self)
        self.push_button_execute_purge_index.setText("Purge Index [Selected Books] [Use with Caution]")
        self.push_button_execute_purge_index.setToolTip("<p style='white-space:wrap'>Delete all book-word combinations from the index for each selected book.")
        self.push_button_execute_purge_index.setMinimumWidth(400)
        self.push_button_execute_purge_index.setMaximumWidth(400)
        self.push_button_execute_purge_index.clicked.connect(self.execute_purge_index)
        self.index_trim_purge_layout.addWidget(self.push_button_execute_purge_index)

        #-----------------------------------------------------
        #-----------------------------------------------------
        #-----------------------------------------------------
        #-----------------------------------------------------
        self.resize(self.sizeHint())
        #-----------------------------------------------------
        #-----------------------------------------------------
        my_db,my_cursor = self.apsw_connect_to_guidb()
        self.mcs_create_txt_format_word_index_table(my_db,my_cursor)
        self.count_records_in_index(my_db,my_cursor)
        my_db.close()
        #-----------------------------------------------------
        #-----------------------------------------------------
        #-----------------------------------------------------
    #-----------------------------------------------------------------------------------------------
    #-----------------------------------------------------------------------------------------------
#--------------------------------------------------------------------------------------------------
# Submit Queries
#--------------------------------------------------------------------------------------------------
#-----------------------------------------------------------------------------------------------
    def execute_word_query_selected(self):
        if self.auto_index_checkbox.isChecked():
            tmp_list = self.gui.library_view.get_selected_ids()
            if len(tmp_list) > MAX_AUTO_INDEX_SELECTED_BOOKS:
                error_dialog(self.gui, _('MCS'),_(("'Automatically Index Unindexed Books' was chosen, but more than the maximum books were selected.<br><br>\
                                                    Execution Canceled. ")), show=True)
                del tmp_list
                return
            else:
                del tmp_list
        sel_type = "selected"
        self.execute_word_query(sel_type)
    def execute_word_query_all(self):
        if self.auto_index_checkbox.isChecked():
            error_dialog(self.gui, _('MCS'),_(("'Automatically Index Unindexed Books' was chosen, but 'all' books were selected.<br><br>\
                                                Execution Canceled. ")), show=True)
            return
        sel_type = "all"
        self.execute_word_query(sel_type)
    def execute_word_query(self,sel_type):

        global prefs

        self.save_all_prefs()

        param_dict = {}

        param_dict['WORD_SEARCH_TERMS'] = self.word_query_qtextedit.toPlainText().strip()

        is_valid,msg = self.validate_word_query()
        if not is_valid:
            msg = msg + "<br><br>Execution Canceled. "
            error_dialog(self.gui, _('MCS'),_((msg)), show=True)
            del param_dict
            return

        param_dict['BAR_MEANS_OR'] = "True"
        if self.bar_is_and_not_or_checkbox.isChecked():
            param_dict['BAR_MEANS_OR'] = "False"

        param_dict['AUTOINDEX_SELECTED_BOOKS_IF_REQUIRED'] = "False"
        if self.auto_index_checkbox.isChecked():
            param_dict['AUTOINDEX_SELECTED_BOOKS_IF_REQUIRED'] = "True"

        param_dict['ALL_AUTHORS_BOOKS'] = "False"
        param_dict['USE_FINAL_FILTERS'] = "False"
        if self.add_final_filters_checkbox.isChecked():
            param_dict['USE_FINAL_FILTERS'] = "True"
        if self.activate_all_author_books_checkbox.isChecked():
            param_dict['ALL_AUTHORS_BOOKS'] = "True"

        if self.add_final_filters_checkbox.isChecked():
            if  prefs['FINAL_FILTERS_LAST_SAVED'] != prefs['FINAL_FILTERS_LAST_VALIDATED']:
                error_dialog(self.gui, _('MCS'),_(("Final Filters have not been Validated since they were last Saved.<br><br>\
                                                                    Execution Canceled. ")), show=True)
                del param_dict
                return
            if prefs['FINAL_FILTERS_PASSED_VALIDATION'] != "True" and prefs['USE_FINAL_FILTERS'] == "True":
                error_dialog(self.gui, _('MCS'),_(("Final Filters failed Validation.  They cannot be used until they pass.<br><br>\
                                                                    Execution Canceled. ")), show=True)
                del param_dict
                return

        self.search_word_in_book_query_control(self.guidb,param_dict,sel_type)

        n_records = prefs['WORD_INDEX_LATEST_RECORD_COUNT']
        s = WORD_QUERIES_INDEXING_GROUPBOX_TITLE + unicode_type(n_records) +  "]"
        self.index_admin_groupbox.setTitle(s)
        self.repaint()
        #~ -------------------

        #~ ----------------------------------------------------------------------------------
        #~ Save actual values temporarily
        #~ ----------------------------------------------------------------------------------
        save1 = param_dict['ALL_AUTHORS_BOOKS']
        save2 = param_dict['USE_FINAL_FILTERS']
        #~ ----------------------------------------------------------------------------------
        #~ These 2 options are selected at query execution time only, and never saved
        #~ ----------------------------------------------------------------------------------
        param_dict['ALL_AUTHORS_BOOKS'] = "False"
        param_dict['USE_FINAL_FILTERS'] = "False"
        #~ ----------------------------------------------------------------------------------
        param_dict[WORD_QUERIES_TYPE] = WORD_QUERIES_TYPE
        current_tab = WORDBOOKINDEXQUERYTAB
        prefs = self.save_settings_parm_history_to_prefs_generic(prefs,current_tab,param_dict)
        #~ ----------------------------------------------------------------------------------
        #~ Restore saved values after self.save_settings_parm_history_to_prefs_generic()
        #~ ----------------------------------------------------------------------------------
        prefs['ALL_AUTHORS_BOOKS'] = save1
        prefs['USE_FINAL_FILTERS'] = save2
        prefs
        #~ ----------------------------------------------------------------------------------
        del param_dict
#--------------------------------------------------------------------------------------------------
#--------------------------------------------------------------------------------------------------
# Submit Indexing Job
#--------------------------------------------------------------------------------------------------
#--------------------------------------------------------------------------------------------------
    def execute_indexing_selected(self):
        sel_type = "selected"
        self.execute_indexing(sel_type)
    def execute_indexing_all(self):
        sel_type = "all"
        self.execute_indexing(sel_type)
    def execute_indexing_unindexed(self):
        sel_type = "all_unindexed"
        self.execute_indexing(sel_type)
    def execute_indexing(self,sel_type):
        #~ if DEBUG: print("submit job: ", sel_type)
        global prefs
        self.save_all_prefs()

        if not '#mcs_was_indexed' in self.custom_column_label_dict:
            if self.update_mcs_indexed_custom_column_checkbox.isChecked():
                prefs['WORD_INDEX_UPDATE_MCS_INDEXED_CUSTOM_COLUMN'] = "False"
                prefs
                self.update_mcs_indexed_custom_column_checkbox.setChecked(False)
                error_dialog(self.gui, _('MCS'),_(("The 'update the #mcvs_was_indexed custom column' was checked, but there is no such custom column.  The checkbox has been cleared.\
                                                                    <br><br>To avoid reindexing your .txt formats, and if you want that custom column, you should create it prior to resubmitting this indexing job.\
                                                                    <br><br>Execution Canceled. ")), show=True)
                return

        mwicc = False
        if self.update_mcs_indexed_custom_column_checkbox.isChecked():
            mwicc = True

        if self.csv_index_word_list_checkbox.isChecked():
            chosen_files = self.choose_index_add_csv_file()
            if not chosen_files:
                info_dialog(self.gui, 'Canceled','No CSV File was was selected; Execution cancelled.').show()
                return
            else:
                csv_path = chosen_files[0]
                prefs['WORD_INDEX_ADD_CSV_CHOSEN_FILE_PATH'] = csv_path
                prefs
        else:
            prefs['WORD_INDEX_ADD_CSV_CHOSEN_FILE_PATH'] = ""
            prefs

        self.mcs_build_index_job_control(self.gui,self.guidb,sel_type,mwicc)
#--------------------------------------------------------------------------------------------------
    def validate_word_query(self):

        is_valid = True
        msg = ""

        if self.bar_is_and_not_or_checkbox.isChecked():
            exclamation_is_allowed = True
        else:
            exclamation_is_allowed = False

        minimum = int(unicode_type(self.min_word_length_spin.value()))

        text = self.word_query_qtextedit.toPlainText()

        if text.count("|") > 0:
            s_split = text.split("|")
        else:
            s_split = []
            s_split.append(text)

        for word in s_split:
            word = word.strip()
            if word == "":
                continue
            if len(word) < minimum:
                if word.count("%") == 0 and word.count("_") == 0:
                    msg = "Word is shorter than the current 'Minimum Letters in Words' option specifies."
                    is_valid = False
                    break
            if not exclamation_is_allowed:
                if word.count("!") > 0:
                    msg = "Exclamation ('!') meaning 'NOT' may only be specified when the bar ('|') means 'AND'."
                    is_valid = False
                    break
            else:
                if word.endswith("!"):
                    msg = "Exclamation ('!') must be located at the start of a word, not the end."
                    is_valid = False
                    break
                else:
                    if word.count("!") > 0:
                        if not word.startswith("!"):
                            msg = "Exclamation ('!') must be located at the start of a word, not in the middle."
                            is_valid = False
                            break
                        else:
                            if len(word) - 1 < minimum:
                                msg = "Without the '!', the Word is shorter than the current 'Minimum Letters in Words' option specifies, so impossible to find it."
                                is_valid = False
                                break
        #END FOR
        return is_valid,msg
#--------------------------------------------------------------------------------------------------
#--------------------------------------------------------------------------------------------------
# Submit Index Trimming Job
#--------------------------------------------------------------------------------------------------
#--------------------------------------------------------------------------------------------------
    def execute_trim_index_basic(self):
        self.save_all_prefs()
        trim_type = "Basic"
        selected_books_list = self.get_selected_books()
        self.mcs_trim_index_job_control(self.gui,self.guidb,trim_type,selected_books_list)
        del selected_books_list
#--------------------------------------------------------------------------------------------------
    def execute_trim_index_advanced(self):
        global prefs
        self.save_all_prefs()

        if self.csv_trim_word_list_checkbox.isChecked():
            chosen_files = self.choose_index_trimming_csv_file()
            if not chosen_files:
                info_dialog(self.gui, 'Canceled','No CSV File was was selected; Execution cancelled.').show()
                return
            else:
                csv_path = chosen_files[0]
                prefs['WORD_INDEX_TRIM_CSV_CHOSEN_FILE_PATH'] = csv_path
                prefs

        if self.english_top_100_checkbox.isChecked() or self.english_bad_word_list_checkbox.isChecked() \
            or self.asian_word_list_checkbox.isChecked() or self.csv_trim_word_list_checkbox.isChecked():
            trim_type = "advanced"
            selected_books_list = []
            self.mcs_trim_index_job_control(self.gui,self.guidb,trim_type,selected_books_list)
#--------------------------------------------------------------------------------------------------
#--------------------------------------------------------------------------------------------------
# Common Functions
#--------------------------------------------------------------------------------------------------
    def execute_purge_index(self):
        self.save_all_prefs()
        my_db,my_cursor = self.apsw_connect_to_guidb()
        selected_books_list = self.get_selected_books()
        self.get_custom_column_id(my_db,my_cursor)
        my_cursor.execute("begin")
        mysql = "DELETE FROM _mcs_word_book_index WHERE book = ? "
        for book in selected_books_list:
            my_cursor.execute(mysql,([book]))
        #END FOR
        my_cursor.execute("commit")

        if self.update_mcs_indexed_custom_column_checkbox.isChecked():
            my_cursor.execute("begin")
            for book in selected_books_list:
                is_valid = self.set_mcs_was_indexed_custom_column(my_db,my_cursor,book,0)
                if not is_valid:
                    break
            #END FOR
            my_cursor.execute("commit")
        self.count_records_in_index(my_db,my_cursor)
        my_db.close()
        self.force_refresh_of_cache(selected_books_list)
        del selected_books_list
        info_dialog(self.gui, _("MCS: Purge Index"), _("Words by Book Index has been purged for the Selected Books. <br><br>Please click 'Library Maintenance > Check Library' to defragment metadata.db."), show=True)
#--------------------------------------------------------------------------------------------------
    def remove_deleted_books_from_index(self,my_db,my_cursor):
        my_cursor.execute("begin")
        mysql = "DELETE FROM _mcs_word_book_index WHERE book NOT IN(SELECT id FROM books WHERE id = _mcs_word_book_index.book)"
        my_cursor.execute(mysql)
        my_cursor.execute("commit")
#--------------------------------------------------------------------------------------------------
    def apsw_connect_to_guidb(self):

        my_db =self.gui.library_view.model().db
        path = my_db.library_path
        if isbytestring(path):
            path = path.decode(filesystem_encoding)
        path = path.replace(os.sep, '/')
        path = os.path.join(path, 'metadata.db')
        path = path.replace(os.sep, '/')
        try:
            my_db = apsw.Connection(path)
        except Exception as e:
            if DEBUG: print(as_unicode(e))
            path = path.encode("ascii", "ignore")
            msg = "MCS cannot use the path that you selected:" + as_unicode(path) + " - " + as_unicode(e)
            self.gui.status_bar.showMessage(msg)
            return
        my_cursor = my_db.cursor()
        mysql = "PRAGMA main.busy_timeout = 10000;"      #PRAGMA busy_timeout = milliseconds;
        my_cursor.execute(mysql)
        #--------------------------------------
        return my_db,my_cursor
#--------------------------------------------------------------------------------------------------
    def get_selected_books(self):

        selected_books_list = []
        del selected_books_list
        selected_books_list = []

        book_ids_list = list(map(partial(self.convert_id_to_book), self.gui.library_view.get_selected_ids() ) )
        n = len(book_ids_list)
        if  n == 0:
            return selected_books_list
        for item in book_ids_list:
            s = as_unicode(item['calibre_id'])
            selected_books_list.append(s)
        del book_ids_list

        return selected_books_list
#--------------------------------------------------------------------------------------------------
    def convert_id_to_book(self, idval):
        book = {}
        book['calibre_id'] = idval
        return book
#--------------------------------------------------------------------------------------------------
    def force_refresh_of_cache(self,selected_books_list):
        if len(selected_books_list) == 0:
            return
        db = self.maingui.current_db.new_api
        db.reload_from_db(clear_caches=False)
        frozen = db.all_book_ids()
        books = list(frozen)
        self.maingui.library_view.model().refresh_ids(books)
        self.maingui.tags_view.recount()
        QApplication.instance().processEvents()
#--------------------------------------------------------------------------------------------------
    def set_mcs_was_indexed_custom_column(self,my_db,my_cursor,book,value):
        try:
            my_cursor.execute(self.mysql_set_mcs_was_indexed,(book,value))
            return True
        except Exception as e:
            if DEBUG: print("def set_mcs_was_indexed_custom_column:  Exception: ", as_unicode(e))
            return False
#---------------------------------------------------------------------------------------------------------------------------------------------
    def get_custom_column_id(self,my_db,my_cursor):

        custom_column_id = as_unicode(0)

        mysql = "SELECT id,editable FROM custom_columns WHERE label = 'mcs_was_indexed' AND datatype = 'bool' AND normalized = 0   "
        my_cursor.execute(mysql)
        tmp_rows = my_cursor.fetchall()
        if not tmp_rows:
            tmp_rows = []
            update_mcs_was_indexed_custom_column = False
            return
        for row in tmp_rows:
            custom_column_id,editable = row
        #END FOR

        if editable == 1:
            my_cursor.execute("begin")
            mysql = "UPDATE custom_columns SET editable = 0 WHERE id = ?"
            my_cursor.execute(mysql,([custom_column_id]))
            my_cursor.execute("commit")

        custom_column_id = as_unicode(custom_column_id)

        self.mysql_set_mcs_was_indexed = "INSERT OR REPLACE INTO custom_column_[N] (id,book,value) VALUES(NULL,?,?) "
        self.mysql_set_mcs_was_indexed = self.mysql_set_mcs_was_indexed.replace("[N]",as_unicode(custom_column_id))
#--------------------------------------------------------------------------------------------------
#--------------------------------------------------------------------------------------------------
    def count_records_in_index(self,my_db,my_cursor):
        global prefs
        n_records = 0
        mysql = "SELECT count(*) FROM _mcs_word_book_index "
        my_cursor.execute(mysql)
        tmp_rows = my_cursor.fetchall()
        if not tmp_rows:
            pass
        else:
            for row in tmp_rows:
                for col in row:
                    n_records = col
                #END FOR
            #END FOR
        prefs['WORD_INDEX_LATEST_RECORD_COUNT'] = as_unicode(n_records)
        prefs

        s = WORD_QUERIES_INDEXING_GROUPBOX_TITLE + unicode_type(n_records) +  "]"
        self.index_admin_groupbox.setTitle(s)

        self.repaint()
#--------------------------------------------------------------------------------------------------
    def choose_index_add_csv_file(self):

        name = "choose_index_add_csv_file"
        title = "Choose Add-to-Index CSV File"
        all_files=True
        select_only_single_file=True
        filters=[]
        window = None   # parent = None

        mode = QFileDialog.ExistingFile if select_only_single_file else QFileDialog.ExistingFiles
        fd = FileDialog(title=title, name=name, filters=filters, parent=window, add_all_files_filter=all_files, mode=mode)
        fd.setParent(None)
        if fd.accepted:
            return fd.get_files()
        return None
#--------------------------------------------------------------------------------------------------
    def choose_index_trimming_csv_file(self):

        name = "choose_index_trimming_csv_file"
        title = "Choose Delete-from-Index CSV File"
        all_files=True
        select_only_single_file=True
        filters=[]
        window = None   # parent = None

        mode = QFileDialog.ExistingFile if select_only_single_file else QFileDialog.ExistingFiles
        fd = FileDialog(title=title, name=name, filters=filters, parent=window, add_all_files_filter=all_files, mode=mode)
        fd.setParent(None)
        if fd.accepted:
            return fd.get_files()
        return None
#--------------------------------------------------------------------------------------------------
    def save_all_prefs(self):
        global prefs
        #-------------------------------------------
        #Queries
        #-------------------------------------------
        prefs['WORD_SEARCH_TERMS'] = self.word_query_qtextedit.toPlainText().strip()

        if self.bar_is_and_not_or_checkbox.isChecked():
            param_dict['BAR_MEANS_OR'] = "False"
        else:
            param_dict['BAR_MEANS_OR'] = "True"

        if self.auto_index_checkbox.isChecked():
            param_dict['AUTOINDEX_SELECTED_BOOKS_IF_REQUIRED'] = "True"
        else:
            param_dict['AUTOINDEX_SELECTED_BOOKS_IF_REQUIRED'] = "False"
        #-------------------------------------------
        #Indexing
        #-------------------------------------------
        prefs['WORD_INDEX_MINIMUM_NUMBER_OF_LETTERS'] = int(unicode_type(self.min_word_length_spin.value()))

        prefs['WORD_INDEX_SKIP_REGEX'] = self.regex_to_skip_words_qlineedit.text().strip()

        if self.update_mcs_indexed_custom_column_checkbox.isChecked():
            prefs['WORD_INDEX_UPDATE_MCS_INDEXED_CUSTOM_COLUMN'] = "True"
        else:
            prefs['WORD_INDEX_UPDATE_MCS_INDEXED_CUSTOM_COLUMN'] = "False"

        if self.csv_index_word_list_checkbox.isChecked():
            prefs['WORD_INDEX_ADD_CSV'] = "True"
        else:
            prefs['WORD_INDEX_ADD_CSV'] = "False"

        prefs['WORD_INDEX_ADD_CSV_CHOSEN_FILE_PATH'] = ""

        #-------------------------------------------
        #Trimming
        #-------------------------------------------
        prefs['WORD_INDEX_DELETION_REGEX'] = self.regex_to_delete_words_qlineedit.text().strip()

        if self.english_top_100_checkbox.isChecked():
            prefs['WORD_INDEX_TRIM_ENGLISH_TOP_100'] = "True"
        else:
            prefs['WORD_INDEX_TRIM_ENGLISH_TOP_100'] = "False"

        if self.english_bad_word_list_checkbox.isChecked():
            prefs['WORD_INDEX_TRIM_ENGLISH_BAD_LIST'] = "True"
        else:
            prefs['WORD_INDEX_TRIM_ENGLISH_BAD_LIST'] = "False"

        if self.asian_word_list_checkbox.isChecked():
             prefs['WORD_INDEX_TRIM_HAN'] = "True"
        else:
            prefs['WORD_INDEX_TRIM_HAN'] = "False"

        if self.csv_trim_word_list_checkbox.isChecked():
             prefs['WORD_INDEX_TRIM_CSV'] = "True"
        else:
            prefs['WORD_INDEX_TRIM_CSV'] = "False"

        prefs['WORD_INDEX_TRIM_CSV_CHOSEN_FILE_PATH'] = ""
        #-------------------------------------------
        prefs
#--------------------------------------------------------------------------------------------------
    def mcs_create_txt_format_word_index_table(self,my_db,my_cursor):
        my_cursor.execute("begin")
        mysql = "CREATE TABLE IF NOT EXISTS _mcs_word_book_index (book INTEGER NOT NULL, word TEXT NOT NULL , PRIMARY KEY (book, word))"
        my_cursor.execute(mysql)
        my_cursor.execute("commit")
        my_cursor.execute("begin")
        mysql =  "CREATE INDEX IF NOT EXISTS __mcs_word_book_index_by_word ON _mcs_word_book_index ( word )  "
        my_cursor.execute(mysql)
        my_cursor.execute("commit")
#--------------------------------------------------------------------------------------------------
    def load_criteria_settings_wordbookindexquerytab(self):
        self.load_criteria_settings_generic(current_tab=WORDBOOKINDEXQUERYTAB)
#--------------------------------------------------------------------------------------------------
    def unpack_selected_parm_wordbookindexquerytab(self,selected_parm,parm_dict):

        n = selected_parm[-1: ]
        if n.isdigit and isinstance(parm_dict,dict):
            n = int(n)
        else:
            if DEBUG: print("wordbookindexquerytab: parm and/or parm_dict to restore is corrupt; nothing can be done...")
            return False

        saveddate,type,vdict,parm = parm_dict[n]   #for actual restoration of loaded criteria

        if DEBUG:
            print("----------unpack_selected_parm_wordbookindexquerytab----------")
            for k, v in iteritems(vdict):
                print(as_unicode(k), " = ", as_unicode(v))
            print("-------------------------------------------------------------------------")

        txt = vdict['WORD_SEARCH_TERMS'].strip()
        self.word_query_qtextedit.setPlainText(txt)

        if vdict['BAR_MEANS_OR'] == "True":
            self.bar_is_and_not_or_checkbox.setChecked(False)  #appears backwards, but is correct due to definition of checkbox...
        else:
            self.bar_is_and_not_or_checkbox.setChecked(True)

        if vdict['AUTOINDEX_SELECTED_BOOKS_IF_REQUIRED'] == "True":
            self.auto_index_checkbox.setChecked(True)
        else:
            self.auto_index_checkbox.setChecked(False)

        self.activate_all_author_books_checkbox.setChecked(False)
        self.add_final_filters_checkbox.setChecked(False)

        self.update()
        QApplication.instance().processEvents()

        if DEBUG: print("*** All wordbookindexquerytab widgets have been reset per newly loaded criteria selected by user ***")

        return True
#--------------------------------------------------------------------------------------------------
#--------------------------------------------------------------------------------------------------
#--------------------------------------------------------------------------------------------------
#--------------------------------------------------------------------------------------------------
class MCSResultsTab(QWidget):
    # a.k.a. "Post-Search Actions"
    prefs = None
    #-----------------------------------------------------------------------------------------------
    def __init__(self,gui,icon,guidb,mcsprefs,current_library_path,load_criteria_settings_generic,create_criteria_parm_list_generic,save_settings_parm_history_to_prefs_generic,
                        unpack_selected_parm_generic):
        super(MCSResultsTab, self).__init__()

        self.gui = gui
        self.icon = icon
        self.guidb = guidb

        global prefs
        prefs = mcsprefs

        self.current_library_path = current_library_path
        self.load_criteria_settings_generic = load_criteria_settings_generic
        self.create_criteria_parm_list_generic = create_criteria_parm_list_generic
        self.save_settings_parm_history_to_prefs_generic = save_settings_parm_history_to_prefs_generic
        self.unpack_selected_parm_generic = unpack_selected_parm_generic

        #-----------------------------------------------------
        font = QFont()
        font.setBold(False)
        font.setPointSize(10)
        #-----------------------------------------------------
        #-----------------------------------------------------
        self.results_action_layout = QGridLayout()
        self.setLayout(self.results_action_layout)
        self.setToolTip("<p style='white-space:wrap'>This Tab is used to change a Target Custom Column of books both Marked by MCS and Selected by the User.<br><br>The Custom Column may only be changed to a compatible value based upon its Data Type.")

        self.setMaximumWidth(700)
        #-----------------------------------------------------
        #-----------------------------------------------------
        self.spacer0_label = QLabel("")
        self.spacer0_label.setFont(font)
        self.spacer0_label.setMinimumWidth(300)
        self.results_action_layout.addWidget(self.spacer0_label,5,0)
        #-----------------------------------------------------
        self.custom_column_combobox_label = QLabel("Target Custom Column:")
        self.custom_column_combobox_label.setFont(font)
        self.custom_column_combobox_label.setMinimumWidth(300)
        self.custom_column_combobox_label.setToolTip("<p style='white-space:wrap'>This is the Custom Column that you wish to change.")
        self.results_action_layout.addWidget(self.custom_column_combobox_label,10,0)
        #-----------------------------------------------------
        self.custom_column_combobox = QComboBox()
        self.custom_column_combobox.setEditable(False)
        self.custom_column_combobox.setFont(font)
        self.custom_column_combobox.setMinimumWidth(200)
        self.custom_column_combobox.setToolTip("<p style='white-space:wrap'>This is the Target Custom Column that you wish to change.  ")
        self.results_action_layout.addWidget(self.custom_column_combobox,10,1)

        self.custom_field_keys = []
        custom_field_keys = self.guidb.custom_field_keys(include_composites=False)
        try:
            first_label = ""
            for label in custom_field_keys:
                self.custom_column_combobox.addItem(label)
                self.custom_field_keys.append(label)
                if first_label == "":
                    first_label = label
            #END FOR
        except:
            pass
        #-----------------------------------------------------
        self.datatype1_label = QLabel("Target Column Data Type:")
        self.datatype1_label.setFont(font)
        self.datatype1_label.setMinimumWidth(300)
        self.datatype1_label.setToolTip("<p style='white-space:wrap'>This is Data Type of Target Custom Column. ")
        self.results_action_layout.addWidget(self.datatype1_label,11,0)

        cc_metadata_dict = self.guidb.custom_field_metadata(first_label)
        cc_datatype = "Unknown"
        for k,v in iteritems(cc_metadata_dict):
            if k == first_label:
                cc_datatype = v['datatype']
                break
        #END FOR

        self.datatype1a_label = QLabel(cc_datatype)
        self.datatype1a_label.setFont(font)
        self.datatype1a_label.setMinimumWidth(300)
        self.datatype1a_label.setToolTip("<p style='white-space:wrap'>This is Data Type of Target Custom Column. ")
        self.results_action_layout.addWidget(self.datatype1a_label,11,1)

        #~ self.custom_column_combobox.currentIndexChanged.connect(self.event_target_combobox_choice_changed)     moved to end of init after all other widgets created

        #-----------------------------------------------------
        self.boolean_radio = QRadioButton("Set Custom Column to this Boolean:")
        self.boolean_radio.setFont(font)
        self.boolean_radio.setMinimumWidth(300)
        self.boolean_radio.setToolTip("<p style='white-space:wrap'>Select this if you wish to change a Boolean Custom Column to a Boolean value.")
        self.results_action_layout.addWidget(self.boolean_radio,20,0)

        self.boolean_combobox = QComboBox()
        self.boolean_combobox.addItem("True")
        self.boolean_combobox.addItem("False")
        self.boolean_combobox.setEditable(False)
        self.boolean_combobox.setFont(font)
        self.boolean_combobox.setMinimumWidth(200)
        self.boolean_combobox.setToolTip("<p style='white-space:wrap'>Select this if you wish to change a Boolean Custom Column to a Boolean value.")
        self.results_action_layout.addWidget(self.boolean_combobox,20,1)
        #-----------------------------------------------------
        self.integer_radio = QRadioButton(("Set Custom Column to this integer:"))
        self.integer_radio.setFont(font)
        self.integer_radio.setMinimumWidth(300)
        self.integer_radio.setToolTip("<p style='white-space:wrap'>Select this if you wish to change an Integer Custom Column to an Integer value.")
        self.results_action_layout.addWidget(self.integer_radio,21,0)

        self.integer_radio_specified_value_spinbox = QSpinBox(self)
        self.integer_radio_specified_value_spinbox.setFont(font)
        self.integer_radio_specified_value_spinbox.setMinimumWidth(200)
        self.integer_radio_specified_value_spinbox.setToolTip("<p style='white-space:wrap'>Select this if you wish to change an Integer Custom Column to an Integer value.")
        self.results_action_layout.addWidget(self.integer_radio_specified_value_spinbox,21,1)
        #-----------------------------------------------------
        self.float_radio = QRadioButton(("Set Custom Column to this number:"))
        self.float_radio.setFont(font)
        self.float_radio.setMinimumWidth(300)
        self.float_radio.setToolTip("<p style='white-space:wrap'>Select this if you wish to change a Floating Decimal Point Custom Column to a Floating Point value.")
        self.results_action_layout.addWidget(self.float_radio,22,0)

        self.float_radio_specified_value_spinbox = QDoubleSpinBox(self)
        self.float_radio_specified_value_spinbox.setDecimals(6)
        self.float_radio_specified_value_spinbox.setFont(font)
        self.float_radio_specified_value_spinbox.setMinimumWidth(200)
        self.float_radio_specified_value_spinbox.setToolTip("<p style='white-space:wrap'>Select this if you wish to change a Floating Decimal Point Custom Column to a Floating Point value.")
        self.results_action_layout.addWidget(self.float_radio_specified_value_spinbox,22,1)
        #-----------------------------------------------------
        self.date_radio = QRadioButton(("Set Custom Column to this date:"))
        self.date_radio.setFont(font)
        self.date_radio.setMinimumWidth(300)
        self.date_radio.setToolTip("<p style='white-space:wrap'>Select this if you wish to change a Datetime Custom Column to a Datetime value.")
        self.results_action_layout.addWidget(self.date_radio,23,0)

        self.date_radio_specified_value_spinbox = QDateEdit(self)
        self.date_radio_specified_value_spinbox.setDisplayFormat ("yyyy-MM-dd")
        self.date_radio_specified_value_spinbox.setCalendarPopup(True)
        self.date_radio_specified_value_spinbox.setDate(QDate.currentDate())
        self.date_radio_specified_value_spinbox.setFont(font)
        self.date_radio_specified_value_spinbox.setMinimumWidth(200)
        self.date_radio_specified_value_spinbox.setToolTip("<p style='white-space:wrap'>Select this if you wish to change a Datetime Custom Column to a Datetime value.")
        self.results_action_layout.addWidget(self.date_radio_specified_value_spinbox,23,1)
        #-----------------------------------------------------
        self.text_radio = QRadioButton(("Set Custom Column to this text:"))
        self.text_radio.setFont(font)
        self.text_radio.setMinimumWidth(300)
        self.text_radio.setToolTip("<p style='white-space:wrap'>Select this if you wish to change a Text (or a Comments) Custom Column to a Textual value.")
        self.results_action_layout.addWidget(self.text_radio,27,0)

        self.text_radio_specified_value_qlineedit = QLineEdit("?")
        self.text_radio_specified_value_qlineedit.setFont(font)
        self.text_radio_specified_value_qlineedit.setMinimumWidth(200)
        self.text_radio_specified_value_qlineedit.setToolTip("<p style='white-space:wrap'>Select this if you wish to change a Text (or a Comments) Custom Column to a Textual value.")
        self.results_action_layout.addWidget(self.text_radio_specified_value_qlineedit,27,1)
        #-----------------------------------------------------
        self.other_column_radio = QRadioButton(("Set Custom Column equal to Source Column:"))
        self.other_column_radio.setFont(font)
        self.other_column_radio.setMinimumWidth(300)
        self.other_column_radio.setToolTip("<p style='white-space:wrap'>Select this if you wish to change a Custom Column to the value of another (compatible) Column.")
        self.results_action_layout.addWidget(self.other_column_radio,28,0)

        self.other_column_combobox = QComboBox()
        self.other_column_combobox.setEditable(False)
        self.other_column_combobox.setFont(font)
        self.other_column_combobox.setMinimumWidth(200)
        self.other_column_combobox.setToolTip("<p style='white-space:wrap'>Select this if you wish to change a Custom Column to the value of another (compatible) Column.")
        self.results_action_layout.addWidget(self.other_column_combobox,28,1)

        self.other_column_combobox.addItem("Authors")
        self.other_column_combobox.addItem("Title")
        self.other_column_combobox.addItem("Tags")

        for label in self.custom_field_keys:
            self.other_column_combobox.addItem(label)
        #END FOR

        self.datatype2_label = QLabel("Source Column Data Type:")
        self.datatype2_label.setFont(font)
        self.datatype2_label.setMinimumWidth(300)
        self.datatype2_label.setToolTip("<p style='white-space:wrap'>The Data Type of the Source Column currently displayed, if any.")
        self.results_action_layout.addWidget(self.datatype2_label,29,0)

        self.datatype2a_label = QLabel(cc_datatype)
        self.datatype2a_label.setFont(font)
        self.datatype2a_label.setMinimumWidth(300)
        self.datatype2a_label.setToolTip("<p style='white-space:wrap'>The Data Type of the Source Column currently displayed, if any.")
        self.results_action_layout.addWidget(self.datatype2a_label,29,1)

        #-----------------------------------------------------
        self.results_action_button_group = QButtonGroup(self.results_action_layout)
        self.results_action_button_group.addButton(self.boolean_radio)
        self.results_action_button_group.addButton(self.text_radio)
        self.results_action_button_group.addButton(self.integer_radio)
        self.results_action_button_group.addButton(self.float_radio)
        self.results_action_button_group.addButton(self.date_radio)
        self.results_action_button_group.addButton(self.other_column_radio)

        #-----------------------------------------------------
        self.push_button_layout = QVBoxLayout()
        self.results_action_layout.addLayout(self.push_button_layout,32,0,2,2)  # GridLayout->addLayout( QLayout*, row, column, rowspan, columnspan );
        #-----------------------------------------------------

        self.push_button_save_criteria_values = QPushButton(" ", self)
        self.push_button_save_criteria_values.setText("Save Current Criteria?")
        self.push_button_save_criteria_values.setToolTip("<p style='white-space:wrap'>Save (with a name) all criteria for this Tab.")
        self.push_button_save_criteria_values.clicked.connect(self.save_criteria_settings_resultstab)
        self.push_button_layout.addWidget(self.push_button_save_criteria_values)


        self.push_button_load_saved_criteria_values = QPushButton(" ", self)
        self.push_button_load_saved_criteria_values.setText("Load Previously Saved Criteria?")
        self.push_button_load_saved_criteria_values.setToolTip("<p style='white-space:wrap'>Select a previously saved (with a name) set of criteria for this Tab.")
        self.push_button_load_saved_criteria_values.clicked.connect(self.load_criteria_settings_resultstab)
        self.push_button_layout.addWidget(self.push_button_load_saved_criteria_values)

        self.push_button_apply_changes = QPushButton(" ", self)
        self.push_button_apply_changes.setText("Apply Specified Changes [Selected AND Marked Books Only]")
        self.push_button_apply_changes.setFont(font)
        self.push_button_apply_changes.setToolTip("<p style='white-space:wrap'>Apply compatible value changes to the books currently Selected AND Marked.")
        self.push_button_apply_changes.clicked.connect(self.apply_specified_changes)
        self.push_button_layout.addWidget(self.push_button_apply_changes)
        #-----------------------------------------------------
        #-----------------------------------------------------
        #-----------------------------------------------------
        self.resize(self.sizeHint())
        #-----------------------------------------------------
        #-----------------------------------------------------
        self.target_datatype = "none"
        self.source_datatype = "none"
        self.custom_column_combobox.currentIndexChanged.connect(self.event_target_combobox_choice_changed)
        self.other_column_combobox.currentIndexChanged.connect(self.event_source_combobox_choice_changed)
        self.results_action_button_group.buttonClicked.connect(self.check_for_compatible_choices)
        #-----------------------------------------------------
        #-----------------------------------------------------
        #-----------------------------------------------------
    #-----------------------------------------------------------------------------------------------
    def event_target_combobox_choice_changed(self,event):
        new_label = self.custom_column_combobox.currentText()
        cc_metadata_dict = self.guidb.custom_field_metadata(new_label)
        self.target_datatype = "Unknown"
        for k,v in iteritems(cc_metadata_dict):
            if k == new_label:
                self.target_datatype = v['datatype']
                break
        #END FOR
        del cc_metadata_dict
        self.datatype1a_label.setText(self.target_datatype)
        if self.target_datatype != "none":  # avoid recursive call
            self.check_for_compatible_choices()
    #-----------------------------------------------------------------------------------------------
    def event_source_combobox_choice_changed(self,event):
        new_label = self.other_column_combobox.currentText()
        self.source_datatype = "none"
        if new_label == 'Authors':
            self.source_datatype = 'text'
        elif new_label == "Title":
            self.source_datatype = 'text'
        elif new_label == "Tags":
            self.source_datatype = 'text'
        else:
            cc_metadata_dict = self.guidb.custom_field_metadata(new_label)
            self.source_datatype = "Unknown"
            for k,v in iteritems(cc_metadata_dict):
                if k == new_label:
                    self.source_datatype = v['datatype']
                    break
            #END FOR
            del cc_metadata_dict
        self.datatype2a_label.setText(self.source_datatype)
        if self.source_datatype != "none":  # avoid recursive call
            self.event_target_combobox_choice_changed("dummy")
    #-----------------------------------------------------------------------------------------------
    def check_for_compatible_choices(self):
        # validate selected source values and hide the pushbutton if not compatible
        is_valid = True

        if self.target_datatype == "none" and self.source_datatype == "none":
            self.event_target_combobox_choice_changed("dummy")
            self.event_source_combobox_choice_changed("dummy")

        if self.boolean_radio.isChecked():
            if self.target_datatype != "bool":
                is_valid = False
        elif self.integer_radio.isChecked():
            if self.target_datatype != "int":
                is_valid = False
        elif self.float_radio.isChecked():
            if self.target_datatype != "float":
                is_valid = False
        elif self.date_radio.isChecked():
            if self.target_datatype != "datetime":
                is_valid = False
        elif self.text_radio.isChecked():
            if self.target_datatype != "text" and self.target_datatype != "comments" and self.target_datatype != "series":
                is_valid = False
        elif self.other_column_radio.isChecked():
            if self.source_datatype != self.target_datatype:
                if self.source_datatype == "text" or self.source_datatype == "comments" or self.target_datatype == "series":
                    if self.target_datatype == "text" or self.target_datatype == "comments" or self.target_datatype == "series":
                        pass
                    else:
                        is_valid = False
                else:
                    is_valid = False
            else:
                pass
        else:
            pass

        if self.target_datatype == "none" and self.source_datatype == "none":
            is_valid = False

        if is_valid:
            self.push_button_apply_changes.show()
        else:
            self.push_button_apply_changes.hide()

        self.repaint()
    #-----------------------------------------------------------------------------------------------
    def apply_specified_changes(self):
        # apply to only those books that are both marked:true and currently selected.  MCS cannot be used to randomly change anything the user wants to change.

        global prefs

        selected_books_list = self.get_selected_books()

        marked_ids = as_unicode(prefs['BOOKS_VALID_FOR_POST_SEARCH_ACTIONS'])           #       [1,2,3,4,5]    always freshly set by ui.py when it marks the search results.  reset to "[]" when this dialog inits.  use it or lose it.
        if marked_ids == "[]":
            return
        marked_ids = as_unicode(marked_ids[1:-1])
        marked_ids = marked_ids.strip()
        if not len(marked_ids) > 0:
            return
        if marked_ids.count(",") > 0:
            s_split = marked_ids.split(",")
        else:
            s_split = []
            s_split.append(marked_ids)
        marked_ids_list = []
        for row in s_split:
            book = as_unicode(row.strip())
            book = book.replace("'","")
            book = book.replace('"','')
            book = book.strip()
            book = int(book)
            marked_ids_list.append(book)
        #END FOR
        del s_split
        del marked_ids

        #~ for book in marked_ids_list:
            #~ if DEBUG: print("marked_ids_list: ", as_unicode(book))
        #~ #END FOR

        book_ids_list = []

        for book in selected_books_list:
            if book in marked_ids_list:
                book_ids_list.append(book)   # Failsafe:  Must be BOTH Marked AND Selected to be acted upon...User must act upon them immediately after Marking, or will lose the marked:true status.
        #END FOR
        del selected_books_list
        del marked_ids_list

        n = len(book_ids_list)
        if n == 0:
            if DEBUG: print("number of book ids both selected and marked:  0")
            return
        else:
            if DEBUG: print("number of book ids both selected and marked: ", as_unicode(n))

        # now populate the dict based on the settings in this tab
        self.populate_new_values()
        if self.new_value_dict['IS_VALID'] == False:
            return
        else:
            param_dict = copy.deepcopy(self.new_value_dict)  #for saving/loading/managing criteria

        new_value =  self.new_value_dict['NEW_VALUE']
        if new_value == "SOURCE_COLUMN":
            new_value = self.new_value_dict['SOURCE_COLUMN']
            if not new_value:
                must_get_new_value_for_each_book = False
                new_value = None
            else:
                must_get_new_value_for_each_book = True
                new_value = "SOURCE_COLUMN"
                #~ self.source_custom_column  is the real value of:   self.new_value_dict['SOURCE_COLUMN']
        else:
            must_get_new_value_for_each_book = False

        if not new_value:
            info_dialog(self.gui, "MCS", "No New Value.  Nothing Was Updated.")
            return

        db = self.guidb.new_api

        for book in book_ids_list:
            book = int(book)
            if must_get_new_value_for_each_book:
                new_value = self.get_new_value_for_current_book(db,book)
                if not new_value:
                    continue
                self.new_value_dict[book] = new_value
            else:
                self.new_value_dict[book] = new_value
        #END FOR

        custom_columns = self.gui.current_db.field_metadata.custom_field_metadata()

        id_map = {}
        final_list = []

        for row in book_ids_list:

            if not book in self.new_value_dict:
                continue

            data_changed = False
            book = int(row)
            mi = Metadata(_('Unknown'))

            try:
                custcol = custom_columns[self.target_custom_column]
                custcol['#value#'] = self.new_value_dict[book]
                mi.set_user_metadata(self.target_custom_column, custcol)   # class Metadata in  src>calibre>ebooks>metadata>book>base.py
                data_changed = True

            except Exception as e:
                if DEBUG: print("exception was: ", as_unicode(e))
                continue

            if data_changed:
                id_map[book] = mi
                final_list.append(book)

        #END FOR

        n = len(final_list)
        if n == 0:
            info_dialog(self.gui, "MCS", "Nothing Was Updated.")
            return
        payload = final_list
        edit_metadata_action = self.gui.iactions['Edit Metadata']
        edit_metadata_action.apply_metadata_changes(id_map, callback=self.finish_displaying_results_actions(payload))

        self.save_criteria_settings_resultstab(param_dict)
    #--------------------------------------------------------------------------------------------------
    def populate_new_values(self):

        self.new_value_dict = {}
        self.new_value_dict['IS_VALID'] =  False
        self.new_value_dict['TARGET_CUSTOM_COLUMN'] = None
        self.new_value_dict['NEW_VALUE'] = None
        self.new_value_dict['NEW_VALUE_OBJECT'] = None
        self.new_value_dict['SOURCE_COLUMN'] = None

        self.source_column = None
        self.new_value = None

        self.target_custom_column = self.custom_column_combobox.currentText()
        if not self.target_custom_column:
            return new_value_dict
        if not self.target_custom_column.startswith("#"):
            return new_value_dict

        if self.boolean_radio.isChecked():
            self.new_value = as_unicode(self.boolean_combobox.currentText())
            self.new_value_object = '1'
        elif self.text_radio.isChecked():
            self.new_value = as_unicode(self.text_radio_specified_value_qlineedit.text())
            self.new_value_object = '2'
        elif self.integer_radio.isChecked():
            self.new_value = int(self.integer_radio_specified_value_spinbox.value())
            self.new_value_object = '3'
        elif self.float_radio.isChecked():
            self.new_value = float(self.float_radio_specified_value_spinbox.value())
            self.new_value_object = '4'
        elif self.date_radio.isChecked():
            self.new_value = as_unicode(self.date_radio_specified_value_spinbox.dateTime().toString("yyyy MMMM dd") )
            self.new_value_object = '5'
        elif self.other_column_radio.isChecked():
            self.source_column = self.other_column_combobox.currentText()
            self.source_column = self.source_column.lower()
            self.new_value = "SOURCE_COLUMN"
            self.new_value_object = '6'
        else:
            self.new_value_object = ''

        self.new_value_dict['TARGET_CUSTOM_COLUMN'] = self.target_custom_column
        self.new_value_dict['NEW_VALUE'] = self.new_value
        self.new_value_dict['NEW_VALUE_OBJECT'] = self.new_value_object
        self.new_value_dict['SOURCE_COLUMN'] = self.source_column
        self.new_value_dict['IS_VALID'] = True
    #--------------------------------------------------------------------------------------------------
    def get_new_value_for_current_book(self,db,book):

        book_mi_object = db.get_metadata(book, get_cover=False, get_user_categories=True, cover_as_data=False)    # a :class:`Metadata` object.

        #~ http://manual.calibre-ebook.com/_modules/calibre/ebooks/metadata/book/base.html
        colname = self.source_column
        if colname.startswith("#"):
            new_value = book_mi_object.get(colname)
            #~ if DEBUG: print("[1] get_new_value_for_current_book -- custom column ", colname, new_value)
        else:
            new_value = ""
            tmp = book_mi_object.__getattribute__(colname)
            if colname == "authors" or colname == "tags":
                for row in tmp:
                    new_value = new_value + row + ",  "
                    #END FOR
                #END FOR
                new_value = new_value.strip()
                if new_value.endswith(","):
                    new_value = new_value[0:-1]
            elif colname == "title":
                new_value = tmp
                new_value = new_value.strip()
            else:
                pass
            #~ if DEBUG: print("[2] get_new_value_for_current_book -- standard field: ", colname, new_value)

        return new_value
    #--------------------------------------------------------------------------------------------------
    def finish_displaying_results_actions(self,payload):
        del payload
    #--------------------------------------------------------------------------------------------------
    def convert_id_to_book(self, idval):
        book = {}
        book['calibre_id'] = idval
        return book
    #--------------------------------------------------------------------------------------------------
    def get_selected_books(self):

        selected_books_list = []
        del selected_books_list
        selected_books_list = []

        book_ids_list = []
        work_book_ids_frozenset = ""

        book_ids_list = list(map(partial(self.convert_id_to_book), self.gui.library_view.get_selected_ids() ) )
        n = len(book_ids_list)
        if  n == 0:
            return selected_books_list
        for item in book_ids_list:
            s = int(as_unicode(item['calibre_id']))
            selected_books_list.append(s)
            #~ if DEBUG: print("selected book: ", as_unicode(s))
        #END FOR

        del book_ids_list
        del work_book_ids_frozenset

        return selected_books_list
    #--------------------------------------------------------------------------------------------------
    #--------------------------------------------------------------------------------------------------
    def save_criteria_settings_resultstab(self,param_dict=None):
        global prefs
        if not isinstance(param_dict,dict):
            self.populate_new_values()
            param_dict = self.new_value_dict
        #~ -------------------
        param_dict[POST_SEARCH_TYPE] = POST_SEARCH_TYPE
        current_tab = RESULTSTAB
        prefs = self.save_settings_parm_history_to_prefs_generic(prefs,current_tab,param_dict)
        prefs
    #--------------------------------------------------------------------------------------------------
    #--------------------------------------------------------------------------------------------------
    def load_criteria_settings_resultstab(self):
        self.load_criteria_settings_generic(current_tab=RESULTSTAB)
    #--------------------------------------------------------------------------------------------------
    def unpack_selected_parm_resultstab(self,selected_parm,parm_dict):

        n = selected_parm[-1: ]
        if n.isdigit and isinstance(parm_dict,dict):
            n = int(n)
        else:
            if DEBUG: print("ResultsTab: parm and/or parm_dict to restore is corrupt; nothing can be done...")
            return False

        saveddate,type,vdict,parm = parm_dict[n]   #for actual restoration of loaded criteria

        if DEBUG:
            for k, v in iteritems(vdict):
                print(as_unicode(k), " = ", as_unicode(v))

        target = vdict['TARGET_CUSTOM_COLUMN']
        i = self.custom_column_combobox.findText(target)
        self.custom_column_combobox.setCurrentIndex(i)

        if DEBUG: print("target: ", target, "  index: ", as_unicode(i))

        newval = vdict['NEW_VALUE']
        obj = vdict['NEW_VALUE_OBJECT']
        is_valid = True

        if obj == '1':
            objct = self.boolean_combobox
            objct.setCurrentText(newval)
            self.boolean_radio.click()
        elif obj == '2':
            objct = self.text_radio_specified_value_qlineedit
            objct.setText(newval)
            self.text_radio.click()
        elif obj == '3':
            objct = self.integer_radio_specified_value_spinbox
            newval = int(newval)
            objct.setValue(newval)
            self.integer_radio.click()
        elif obj == '4':
            objct = self.float_radio_specified_value_spinbox
            newval = float(newval)
            objct.setValue(newval)
            self.float_radio.click()
        elif obj == '5':
            objct = self.date_radio_specified_value_spinbox  #QDateEdit
            objct.setDate(QDate.fromString(newval,"yyyy MMMM dd"))
            self.date_radio.click()
        elif obj == '6':
            objct = self.other_column_combobox
            i = objct.findText(newval)
            objct.setCurrentIndex(i)
            self.other_column_radio.click()
        else:
            is_valid = False

        self.update()

        if DEBUG: print("*** All resultstab widgets have been reset per loaded criteria selected by user ***")

        return is_valid
#--------------------------------------------------------------------------------------------------
#--------------------------------------------------------------------------------------------------
#--------------------------------------------------------------------------------------------------
#--------------------------------------------------------------------------------------------------
#--------------------------------------------------------------------------------------------------
#--------------------------------------------------------------------------------------------------
#--------------------------------------------------------------------------------------------------
#--------------------------------------------------------------------------------------------------
#END of mcs_search_dialog.py