# -*- coding: utf-8 -*-
__license__   = 'GPL v3'
__copyright__ = '2016,2017,2018,2019,2020,2021,2022,2023 DaltonST'
__my_version__ = "1.0.78"  # Qt.core

from calibre.constants import DEBUG, iswindows
from calibre.utils.config import prefs

from polyglot.builtins import as_unicode

#-----------------------------------------------------------------------------------------
def zmi_cli_add_custom_column(guidb,param):

    #~ param = label + '|||' + name + '|||' +  datatype

    is_multiple = False

    #~ if DEBUG: print("param:", param)

    param = param.strip()
    args = param.split("|||")
    args_list = []
    for row in args:
        s = row.strip()
        if s > " ":
            s = s.replace('"','')
            args_list.append(s)
            if DEBUG: print("arg: ", as_unicode(s))
    #END FOR

    label = args_list[0]
    name = args_list[1]
    datatype = args_list[2]

    display  = {}

    guidb.create_custom_column(label, name, datatype, is_multiple, display=display)

    if DEBUG: print("ZMI Custom Column created:  ", label, "  ", name, "  ", datatype)

    # Re-open the DB so that  field_metadata reflects the column changes
    guidb.prefs['field_metadata'] = guidb.field_metadata.all_metadata()

#-----------------------------------------------------------------------------------------
#-----------------------------------------------------------------------------------------
#-----------------------------------------------------------------------------------------
#-----------------------------------------------------------------------------------------
#-----------------------------------------------------------------------------------------
#-----------------------------------------------------------------------------------------
#-----------------------------------------------------------------------------------------
#END of lc_cli.py
