# -*- coding: utf-8 -*-
__license__   = 'GPL v3'
__copyright__ = '2016,2017,2018,2019,2020,2021,2022,2023 DaltonST'
__my_version__ = "1.0.78"  # Qt.core

from calibre.customize import InterfaceActionBase

class ActionBaseZoteroMetadataImporter(InterfaceActionBase):

    name                    = 'Zotero Metadata Importer'
    description           = "Add Zotero documents and files plus their metadata to Calibre as books using the normal .csv file exported by Zotero.  Compare items in Zotero to books in Calibre. Export an RIS file with Calibre books and their metadata for import into Zotero."
    supported_platforms     = ['windows', 'osx', 'linux']
    author                  = 'DaltonST'
    version                 = (1, 0, 78)
    minimum_calibre_version = (6, 0, 0)

    actual_plugin           = 'calibre_plugins.zotero_metadata_importer.ui:ActionZoteroMetadataImporter'

    gui_name = 'Zotero Metadata Importer'

    #--------------------------------------------------------------------------------------------------------------------------
    def initialize(self):
        pass
    #--------------------------------------------------------------------------------------------------------------------------
    def is_customizable(self):
        return False
    #-------------------------------------------
#END of __init__py