# -*- coding: utf-8 -*-
__license__   = 'GPL v3'
__copyright__ = '2019,2020,2021,2022,2023 DaltonST'
__my_version__ = "1.0.19"  # Qt.core

from qt.core import Qt, QComboBox, QVBoxLayout, QDialog, QPushButton, QUrl

from calibre.constants import DEBUG
from calibre.gui2 import open_url, error_dialog
from polyglot.builtins import as_unicode
#--------------------------------------------------------------------------------------------
class LinkViewerDialog(QDialog):

    def __init__(self,icon,font,entity_id,type,value,link_list):
        super(LinkViewerDialog, self).__init__()

        self.setWindowFlags(Qt.Window | Qt.WindowTitleHint | Qt.WindowCloseButtonHint | Qt.WindowMinMaxButtonsHint)
        self.setModal(False)
        self.setWindowIcon(icon)
        title = "Entities Manager:  Open Links for " + type + "  " + value
        self.setWindowTitle(title)
        self.setSizeGripEnabled(True)
        self.setModal(False)

        font.setBold(False)
        font.setPointSize(11)

        self.setToolTip("<p style='white-space:wrap'>View a Link")

        self.layout = QVBoxLayout()
        self.layout.setAlignment(Qt.AlignCenter)
        self.setLayout(self.layout)

        self.link_qcombobox = QComboBox()
        self.link_qcombobox.setEditable(False)
        self.link_qcombobox.setFrame(True)
        self.link_qcombobox.setDuplicatesEnabled(False)
        self.link_qcombobox.setMaxVisibleItems(25)
        self.link_qcombobox.setMinimumWidth(400)
        self.link_qcombobox.setMaximumWidth(800)
        self.link_qcombobox.setSizeAdjustPolicy(QComboBox.SizeAdjustPolicy.AdjustToContents)
        self.link_qcombobox.setFont(font)
        self.layout.addWidget(self.link_qcombobox)

        for row in link_list:
            link_id,name,link = row
            r = name + "  >>>  " + link
            self.link_qcombobox.addItem(r)
        #END FOR

        self.open_pushbutton = QPushButton("Open Selected Link", self)
        self.open_pushbutton.setFont(font)
        self.open_pushbutton.setMinimumWidth(200)
        self.open_pushbutton.setMaximumWidth(200)
        self.open_pushbutton.clicked.connect(self.open_link)
        self.layout.addWidget(self.open_pushbutton)

        self.exit_pushbutton = QPushButton("Exit", self)
        self.exit_pushbutton.setFont(font)
        self.exit_pushbutton.setMinimumWidth(100)
        self.exit_pushbutton.setMaximumWidth(100)
        self.exit_pushbutton.clicked.connect(self.done)
        self.layout.addWidget(self.exit_pushbutton)

        self.setMinimumWidth(500)

    #--------------------------------------------------------------------------------------------
    def open_link(self):
        r = self.link_qcombobox.currentText()
        s_split = r.split(">>>")
        link = s_split[1].strip()

        link = link.replace("\\","/")
        if link.startswith('"') and link.endswith('"'):  #Windows copy-path artifacts
            link = link[1:-1]

        if not link > " ":
            msg = "Open URL Error for Link; invalid Link"
            if DEBUG: print(msg)
            return error_dialog(None, _('EM'),_(msg), show=True)

        try:
            open_url(QUrl(link, QUrl.ParsingMode.TolerantMode))
            del link
        except Exception as e:
            msg = "Open URL Error for Link:  " +as_unicode(e)
            if DEBUG: print(msg)
            error_dialog(None, _('EM'),_(msg), show=True)

    #--------------------------------------------------------------------------------------------
#end of link_viewer_dialog.py