# -*- coding: utf-8 -*-
__license__   = 'GPL v3'
__copyright__ = '2019,2020,2021,2022,2023 DaltonST'
__my_version__ = "1.0.19"  # Qt.core

from qt.core import Qt, QDialog, QLabel, QComboBox, QVBoxLayout

from polyglot.builtins import as_unicode
#--------------------------------------------------------------------------------------------
class BooksFoundDialog(QDialog):

    def __init__(self,maingui,icon,font,pick_list):

        QDialog.__init__(self, maingui)

        self.maingui = maingui
        self.icon = icon
        self.font = font
        self.font.setBold(False)
        self.pick_list = pick_list

        self.setWindowIcon(self.icon)
        self.setWindowTitle('Entities')
        self.setWindowFlags( Qt.Window | Qt.WindowTitleHint | Qt.WindowSystemMenuHint | Qt.WindowMinMaxButtonsHint | Qt.WindowCloseButtonHint)   # http://doc.qt.io/qt-5/qt.html#WindowType-enum
        #--------------------------------------------------

        self.layout = QVBoxLayout()
        self.layout.setAlignment(Qt.AlignCenter)
        self.setLayout(self.layout)

        self.font.setPointSize(12)

        n = len(self.pick_list)

        s_msg = "Distinct Entities found in Books: " + as_unicode(n)

        self.text_line = QLabel()
        self.text_line.setTextFormat(Qt.RichText)
        self.text_line.setFont(font)
        self.text_line.setText("<center><font color='#0404B4'>" + s_msg + "</font></center>")
        self.layout.addWidget(self.text_line)

        self.entity_combobox = QComboBox()
        self.entity_combobox.setFont(self.font)
        self.entity_combobox.setEditable(False)
        self.entity_combobox.setFrame(True)
        self.entity_combobox.setDuplicatesEnabled(False)
        self.entity_combobox.setMaxVisibleItems(25)
        self.entity_combobox.setMinimumWidth(500)
        self.entity_combobox.setMaximumWidth(500)
        self.entity_combobox.setSizeAdjustPolicy(QComboBox.SizeAdjustPolicy.AdjustToContents)
        self.entity_combobox.setFont(self.font)
        self.entity_combobox.setToolTip("<p style='white-space:wrap'>Books Found Information")
        self.layout.addWidget(self.entity_combobox)

        for row in self.pick_list:
            type,value = row
            s = type + " & " + value
            self.entity_combobox.addItem(s)
        #END FOR

        self.resize(self.sizeHint())

#END OF books_found_dialog.py