LOGFILE=/tmp/x11vnc.err

X11VNC_BASEDIR=/mnt/us/extensions/x11vnc
X11VNC_CONF_DIR="${X11VNC_BASEDIR}"/config
X11VNC_BIN="${X11VNC_BASEDIR}"/bin/x11vnc
X11VNC_PID=/var/run/x11vnc.pid

WIFI_ON="${X11VNC_CONF_DIR}"/WIFI_ON
PASSWD_ON="${X11VNC_CONF_DIR}"/PASSWD_ON

PLAINTEXT_PASSWD="${X11VNC_CONF_DIR}"/plaintext_passwd
ENCRYPTED_PASSWD="${X11VNC_CONF_DIR}"/passwd

X11VNC_ARGS=" -rfbport 5900 -nocursor -forever -o ${LOGFILE}"
export KH_HACKNAME="x11vnc"

# Pinch this snippet from NiLuJe to setup libkh...
_KH_FUNCS="/mnt/us/usbnet/bin/libkh5"
. "${_KH_FUNCS}"

toggle_x11vnc() {
  if [ ! -f "${X11VNC_PID}" ]; then
    kh_msg "* x11vnc: starting x11vnc*" I q
    start_x11vnc
  else
    kh_msg "* x11vnc: stopping x11vnc*" I q
    stop_x11vnc
  fi 
}

start_x11vnc() {
  if [ -f "${PASSWD_ON}" ]; then
    X11VNC_ARGS="-rfbauth ${ENCRYPTED_PASSWD} ${X11VNC_ARGS}"
  fi
  /sbin/start-stop-daemon --start -m -b -p "${X11VNC_PID}" -x "${X11VNC_BIN}" -- ${X11VNC_ARGS}
}

stop_x11vnc() {
  if [ -f "${X11VNC_PID}" ]; then
    start-stop-daemon --stop --pidfile "${X11VNC_PID}"
    rm -f "${X11VNC_PID}"
  fi
}

x11vnc_status() {
  if [ -f "${X11VNC_PID}" ]; then
    if [ -f "${WIFI_ON}" ]; then
      kh_msg "* x11vnc: enabled (usbnet, wifi) *" I v
    else
      kh_msg "* x11vnc: enabled (usbnet) *" I v
    fi
  else
    kh_msg "* x11vnc: disabled *" I v   
  fi
  true;
}

enable_auto() {
  true;
}

disable_auto() {
  true;
}

enable_wifi() {
  if [ ! -f "${WIFI_ON}" ]; then
    kh_msg "* x11vnc: enabling wifi access*" I v
    touch "${WIFI_ON}"
    iptables -A INPUT -i wlan0 -p tcp --dport 5901 -j ACCEPT
  fi
}

disable_wifi() {
  if [ -f "${WIFI_ON}" ]; then
    kh_msg "* x11vnc: disabling wifi access*" I v
    rm "${WIFI_ON}"
    iptables -D INPUT -i wlan0 -p tcp --dport 5901 -j ACCEPT
  fi
}

generate_password() {
  if [ -f "${PLAINTEXT_PASSWD}" ]; then
    kh_msg "* x11vnc: plaintext password found, encrypting...*" I v
    PASSWD=$(cat ${PLAINTEXT_PASSWD})
    echo -e "$PASSWD\n$PASSWD\n" | "${X11VNC_BIN}" -storepasswd "${ENCRYPTED_PASSWD}"
    kh_msg "* x11vnc: encrypted password stored in ./config/passwd...*" I v
    rm "${PLAINTEXT_PASSWD}"
  fi
}

enable_password() {
  if [ ! -f "${PASSWD_ON}" ]; then
    kh_msg "* x11vnc: enabling password... *" I v
    touch "${PASSWD_ON}"
  fi
  if [ -f "${X11VNC_PID}" ]; then
    stop_x11vnc
    start_x11vnc
  fi
}

disable_password() {
  if [ -f "${PASSWD_ON}" ]; then
    kh_msg "* x11vnc: disabling password... *" I v
    rm $PASSWD_ON
  fi
  if [ -f "${X11VNC_PID}" ]; then
    stop_x11vnc
    start_x11vnc
  fi
}

case ${1} in
  "toggle_x11vnc" )
		${1}
	;;
  "x11vnc_status" )
		${1}
	;;
  "enable_auto" )
		${1}
	;;
  "disable_auto" )
		${1}
	;;
  "enable_wifi" )
		${1}
	;;
  "disable_wifi" )
		${1}
	;;
  "generate_password" )
		${1}
	;;
  "enable_password" )
		${1}
	;;
  "disable_password" )
		${1}
	;;
esac