# -*- coding: utf-8 -*-
__license__   = 'GPL v3'
__copyright__ = '2015,2016,2017,2018,2019,2020,2021,2022,2023  DaltonST'
__my_version__ = "1.0.96"   # Qt.core

from qt.core import QWidget

from calibre.utils.config import JSONConfig

from polyglot.builtins import as_unicode

prefs = JSONConfig('plugins/multi_column_search')

# Set defaults
prefs.defaults['LAST_TAB_USED'] = as_unicode(0)

prefs.defaults['NAME1'] = "title"
prefs.defaults['TEXT1'] = "#work_title"
prefs.defaults['TYPE1'] = "LABEL"
prefs.defaults['OPERATOR1'] = "contains"
prefs.defaults['REGEX1'] = "^.+$"
prefs.defaults['REGEX1#'] = as_unicode(0)
prefs.defaults['IGNORECASE1'] = "1"
prefs.defaults['TRANSFORM_FUNCTION1'] = "Compare: 'as-is'"
prefs.defaults['FUZZYWUZZY1'] = "Fuzzy Equality Compare: None"

prefs.defaults['ANDORNOT'] = "OR"

prefs.defaults['INTER_BOOK_SEARCH'] = "False"

prefs.defaults['CROSS_LIBRARY_DUPLICATES_SEARCH'] = "False"

prefs.defaults['ALL_AUTHORS_BOOKS'] = "False"

prefs.defaults['USE_FINAL_FILTERS'] = "False"

prefs.defaults['FINAL_FILTERS_LAST_SAVED'] = "never"
prefs.defaults['FINAL_FILTERS_LAST_VALIDATED'] = "never"

prefs.defaults['FINAL_FILTERS_PASSED_VALIDATION'] = "True"

prefs.defaults['NAME2'] = "authors"
prefs.defaults['TEXT2'] = "#work_author"
prefs.defaults['TYPE2'] = "LABEL"
prefs.defaults['OPERATOR2'] = "contains"
prefs.defaults['REGEX2'] = "^.+$"
prefs.defaults['REGEX2#'] = as_unicode(0)
prefs.defaults['IGNORECASE2'] = "2"
prefs.defaults['TRANSFORM_FUNCTION2'] = "Compare: 'as-is'"
prefs.defaults['FUZZYWUZZY2'] = "Fuzzy Equality Compare: None"

prefs.defaults['PARAM_DICT_LAST_SAVED_TO_PREFS_FROM_TAB'] = "never_saved"

settings_history_dict = {}
prefs.defaults['SETTINGS_HISTORY_DICT'] = as_unicode(settings_history_dict)
del settings_history_dict
settings_history_names_dict = {}
prefs.defaults['SETTINGS_HISTORY_NAMES_DICT'] = as_unicode(settings_history_names_dict)
del settings_history_names_dict

prefs.defaults['SETTINGS_HISTORY_LAST_MANAGED_DATETIME'] = "never_managed"

prefs.defaults['REGEXVALUE_0'] = "^.+$(?#This will match everything.  The ^ and $ are optional anchors.)"
prefs.defaults['REGEXVALUE_1'] = ".+(?#For a user guide to Regular Expressions, refer to:  https://docs.python.org/2/library/re.html )"
prefs.defaults['REGEXVALUE_2'] = ".+(?#For an easy, interactive way to learn REs, refer to:  https://pythex.org/ )"
prefs.defaults['REGEXVALUE_3'] = "^[ABCD](?#Purpose:  Starts with  A,B,C or D  )"
prefs.defaults['REGEXVALUE_4'] = "^B(?#Purpose:  Starts with a B  )"
prefs.defaults['REGEXVALUE_5'] = "^[^ABD](?#Purpose:  Starts with any char except A, B, D  )"
prefs.defaults['REGEXVALUE_6'] = "^.+L$(?#Purpose:   Ends with an L  )"
prefs.defaults['REGEXVALUE_7'] = "[^a-c6](?#Purpose: matches any char except 'a', 'b', 'c' or '6'  )"
prefs.defaults['REGEXVALUE_8'] = "[a]"
prefs.defaults['REGEXVALUE_9'] = "Please note the 2 'I.C.?' checkboxes to the left.  'I.C.?' means 'Use re.IGNORECASE?' "

prefs.defaults['REGEX_RADIO_COL1_0'] = "True"
prefs.defaults['REGEX_RADIO_COL1_1'] = "False"
prefs.defaults['REGEX_RADIO_COL1_2'] = "False"
prefs.defaults['REGEX_RADIO_COL1_3'] = "False"
prefs.defaults['REGEX_RADIO_COL1_4'] = "False"
prefs.defaults['REGEX_RADIO_COL1_5'] = "False"
prefs.defaults['REGEX_RADIO_COL1_6'] = "False"
prefs.defaults['REGEX_RADIO_COL1_7'] = "False"
prefs.defaults['REGEX_RADIO_COL1_8'] = "False"
prefs.defaults['REGEX_RADIO_COL1_9'] = "False"

prefs.defaults['REGEX_RADIO_COL2_0'] = "True"
prefs.defaults['REGEX_RADIO_COL2_1'] = "False"
prefs.defaults['REGEX_RADIO_COL2_2'] = "False"
prefs.defaults['REGEX_RADIO_COL2_3'] = "False"
prefs.defaults['REGEX_RADIO_COL2_4'] = "False"
prefs.defaults['REGEX_RADIO_COL2_5'] = "False"
prefs.defaults['REGEX_RADIO_COL2_6'] = "False"
prefs.defaults['REGEX_RADIO_COL2_7'] = "False"
prefs.defaults['REGEX_RADIO_COL2_8'] = "False"
prefs.defaults['REGEX_RADIO_COL2_9'] = "False"

prefs.defaults['REGEX_IGNORECASE_1'] = "True"
prefs.defaults['REGEX_IGNORECASE_2'] = "True"


prefs.defaults["FINAL_FILTER_0"] = "['False', 'books: series_index', 'IS', '2', 'OR', '>=']"
prefs.defaults["FINAL_FILTER_1"] = "['False', 'identifiers: type', 'IS NOT', 'ddc', 'OR', 'EXISTENT']"
prefs.defaults["FINAL_FILTER_2"] = "['False', 'cc: #myserieslike', 'IS', 'Star Wars  [*]', 'OR', 'EXISTENT']"
prefs.defaults["FINAL_FILTER_3"] = "['False', 'cc: #mytextfixedsetofvalues', 'IS', 'Favorites', 'AND', 'LIKE']"
prefs.defaults["FINAL_FILTER_4"] = "['False', 'cc: #myyesno', 'IS', '', 'AND', 'False']"
prefs.defaults["FINAL_FILTER_5"] = "['False', 'cc: #myrating', 'IS NOT', '', 'AND', 'EXISTENT']"
prefs.defaults["FINAL_FILTER_6"] = "['False', 'cc: #original_title', 'IS', '', 'AND', 'EXISTENT']"
prefs.defaults["FINAL_FILTER_7"] = "['False', 'authors: name', 'IS NOT', 'Smith', 'NOT', 'LIKE']"
prefs.defaults["FINAL_FILTER_8"] = "['False', 'tags: name', 'IS', 'Factual', 'NOT', 'LIKE']"
prefs.defaults["FINAL_FILTER_9"] = "['False', 'books: pubdate', 'IS', '2000-01-01', '', '<']"

prefs.defaults['SPECIAL_QUERY_ACTIVE'] = "False"

prefs.defaults['RAW_SQL_QUERY_LAST_SAVED'] = ""

prefs.defaults['COLUMN__0_WIDTH'] = as_unicode(1)
prefs.defaults['COLUMN__1_WIDTH'] = as_unicode(1)
prefs.defaults['COLUMN__2_WIDTH'] = as_unicode(1)
prefs.defaults['COLUMN__1_WIDTH'] = as_unicode(1)
prefs.defaults['COLUMN__4_WIDTH'] = as_unicode(1)
prefs.defaults['COLUMN__5_WIDTH'] = as_unicode(1)
prefs.defaults['COLUMN__6_WIDTH'] = as_unicode(1)
prefs.defaults['COLUMN__7_WIDTH'] = as_unicode(1)
prefs.defaults['COLUMN__8_WIDTH'] = as_unicode(1)
prefs.defaults['COLUMN__9_WIDTH'] = as_unicode(1)
prefs.defaults['COLUMN__10_WIDTH'] = as_unicode(1)

prefs.defaults['BOOKS_VALID_FOR_POST_SEARCH_ACTIONS'] = "[]"

prefs.defaults['OPTIONS_TEXT_ACTIVATE'] = "False"
prefs.defaults['OPTIONS_COMPARE_FOUND_TEXT'] = "False"
prefs.defaults['OPTIONS_COMPARE_FOUND_TEXT_CC'] = ""
prefs.defaults['OPTIONS_COMPARE_FOUND_TEXT_REGEX'] = ""
prefs.defaults['OPTIONS_UPDATE_FOUND_TEXT'] = "False"
prefs.defaults['OPTIONS_UPDATE_FOUND_TEXT_CC'] = ""
prefs.defaults['OPTIONS_UPDATE_FOUND_TEXT_REGEX'] = ""

prefs.defaults['OPTIONS_SIMILARITY_QUERIES_COMPARISON_COLUMN'] = "Title"
prefs.defaults['OPTIONS_SIMILARITY_QUERIES_PERCENTAGE'] = 75
prefs.defaults['OPTIONS_SIMILARITY_QUERIES_GROUP_UPDATE_TAGLIKE_CC'] = ""

#--------------------------------------------------
#--------------------------------------------------
class ConfigWidget(QWidget):
    def __init__(self):
        QWidget.__init__(self)
        return
#--------------------------------------------------
#--------------------------------------------------
    def validate(self):
        return True
#--------------------------------------------------
#--------------------------------------------------
#END of config.py

