# -*- coding: utf-8 -*-
__license__   = 'GPL v3'
__copyright__ = '2015,2016,2017,2018,2019,2020,2021,2022,2023  DaltonST'
__my_version__ = "1.0.96"   # Qt.core

from qt.core import ( Qt, QAbstractItemView, QDialog, QFont, QIcon, QPushButton,
                                        QSize, QTableWidget, QTableWidgetItem, QTextEdit, QVBoxLayout, QWidget )
from calibre.constants import DEBUG
from calibre.gui2 import gprefs

from polyglot.builtins import as_unicode
#-----------------------------------------------------------------------------------------
#-----------------------------------------------------------------------------------------
class SizePersistedDialog(QDialog):
    initial_extra_size = QSize(400, 400)

    def __init__(self, parent, unique_pref_name):
        QDialog.__init__(self, parent)
        self.unique_pref_name = unique_pref_name
        self.geom = gprefs.get(unique_pref_name, None)

    def resize_dialog(self):
        if self.geom is None:
            self.resize(self.sizeHint()+self.initial_extra_size)
        else:
            self.restoreGeometry(self.geom)

    def save_dialog_geometry(self):
        geom = bytearray(self.saveGeometry())
        gprefs[self.unique_pref_name] = geom
#-----------------------------------------------------------------------------------------
#-----------------------------------------------------------------------------------------
class MCSSearchCommentsDialog(SizePersistedDialog):

    def __init__(self,gui,guidb,icon,found_list,param_dict):

        parent = gui
        unique_pref_name = 'multicolumnsearch:mcssearchcommentsdialog'
        SizePersistedDialog.__init__(self, parent, unique_pref_name)

        self.gui = gui
        self.guidb = guidb
        self.icon = icon

        self.found_list = found_list
        self.param_dict = param_dict

        self.search_string = self.param_dict['TEXT1']

        if DEBUG: print(self.search_string)

        self.setWindowTitle('MCS: Search Comments')
        self.setWindowIcon(self.icon)

        self.layout = QVBoxLayout()
        self.setLayout(self.layout)

        font = QFont()
        font.setBold(False)
        font.setPointSize(8)

        self.found_list.sort()
        nrows = len(self.found_list)

        column_label_list = []
        column_label_list.append("ID")
        column_label_list.append("Author(s)")
        column_label_list.append("Title")
        column_label_list.append("Comments")

        self.mcs_qtablewidget = QTableWidget(nrows,4)     # number of rows and columns

        self.mcs_qtablewidget.setSortingEnabled(False)

        self.mcs_qtablewidget.setHorizontalHeaderLabels(column_label_list)

        self.mcs_qtablewidget.setColumnWidth(0, 25)
        self.mcs_qtablewidget.setColumnWidth(1, 75)
        self.mcs_qtablewidget.setColumnWidth(2, 75)
        self.mcs_qtablewidget.setColumnWidth(3, 600)

        r = 0
        for book in self.found_list:
            mi = self.guidb.get_metadata(book,index_is_id=True)
            #~ ---------
            book = as_unicode(book)
            c0 = QTableWidgetItem(book,0)
            #~ ---------
            authors = mi.authors
            author = " "
            for row in authors:
                author = author + row + ", "
            #END FOR
            author = author[0:-2]
            author = author.strip()
            c1 = QTableWidgetItem(author,0)
            #~ ---------
            title = mi.title
            c2 = QTableWidgetItem(title,0)
            #~ ---------
            self.mcs_qtablewidget.setItem(r,0,c0)
            self.mcs_qtablewidget.setItem(r,1,c1)
            self.mcs_qtablewidget.setItem(r,2,c2)
            #~ ---------
            comments =  mi.comments
            s = ' <b style="color:#ff0000">' + self.search_string.upper() + '</b> '
            comments = comments.replace(self.search_string,s)
            c3 = QTableWidgetItem(comments)
            self.mcs_qtablewidget.setItem(r,3,c3)

            comments_text = QTextEdit()
            comments_text.insertHtml(comments)
            comments_text.setReadOnly(True)

            self.mcs_qtablewidget.setCellWidget(r,3,comments_text)          #~ QTableWidget::setCellWidget(int row, int column, QWidget *widget)
            #~ ---------
            self.mcs_qtablewidget.resizeRowToContents(r)
            r = r + 1
        #END FOR

        self.mcs_qtablewidget.resizeColumnToContents(0)

        self.layout.addWidget(self.mcs_qtablewidget)

        self.mcs_qtablewidget.setEditTriggers(QAbstractItemView.NoEditTriggers)

        font.setPointSize(8)

        self.push_button_save_geometry = QPushButton(" ", self)
        self.push_button_save_geometry.setText("Exit")
        self.push_button_save_geometry.clicked.connect(self.save_current_geometry)
        self.push_button_save_geometry.setFont(font)
        self.push_button_save_geometry.setMaximumWidth(200)
        self.push_button_save_geometry.setToolTip("<p style='white-space:wrap'>Save the current size of these results and then exit.")
        self.layout.addWidget(self.push_button_save_geometry)

        self.resize(self.sizeHint())

        self.resize_dialog()

    #----------------------------------------------------
    def save_current_geometry(self):
        self.save_dialog_geometry()
        self.close()
    #----------------------------------------------------


#END OF mcs_search_comments_dialog.py