# -*- coding: utf-8 -*-
__license__   = 'GPL v3'
__copyright__ = '2015,2016,2017,2018,2019,2020,2021,2022,2023  DaltonST'
__my_version__ = "1.0.96"   # Qt.core

from calibre.gui2.threaded_jobs import ThreadedJob
from calibre.utils.logging import Log

from calibre_plugins.multi_column_search.mcs_build_index import mcs_update_word_book_index
from calibre_plugins.multi_column_search.mcs_trim_index import mcs_trim_word_book_index

# ------------------------------------------------------------------------------
#              Jobs to perform MCS Word Index Maintenance
# ------------------------------------------------------------------------------

# ------------------------------------------------------------------------------
def start_mcs_build_index(self, my_gui, my_guidb,sel_type,selected_books_list,mwicc,wdcl,callback):

    self.gui = my_gui

    try:
        print("mcs_build_index: ", my_guidb.library_path)
    except:
        pass

    job = ThreadedJob('multicolumnsearch plugin','MultiColumnSearch: Build Index',mcs_update_word_book_index,(self,my_guidb,sel_type,selected_books_list,mwicc,wdcl), {}, callback)
    self.gui.job_manager.run_threaded_job(job)
    self.gui.status_bar.show_message(_('This MCS job will update the Word-Book Index for use in Word Queries'), 5000)
# ------------------------------------------------------------------------------
def start_mcs_trim_index(self, my_gui,my_guidb,trim_type,selected_books_list,callback):

    self.gui = my_gui

    try:
        print("mcs_trim_index: ", my_guidb.library_path)
    except:
        pass

    job = ThreadedJob('multicolumnsearch plugin','MultiColumnSearch: Trim Index',mcs_trim_word_book_index,(self,my_guidb,trim_type,selected_books_list), {}, callback)
    self.gui.job_manager.run_threaded_job(job)
    self.gui.status_bar.show_message(_('This MCS job will update the Word-Book Index for use in Word Queries'), 5000)
# ------------------------------------------------------------------------------
#END of jobs.py
