# -*- coding: utf-8 -*-
__license__   = 'GPL v3'
__copyright__ = '2015,2016,2017,2018,2019,2020,2021,2022,2023  DaltonST'
__my_version__ = "1.0.96"   # Qt.core

from qt.core import (Qt, QDialog, QVBoxLayout, QTimer, QDialogButtonBox, QInputDialog,
                                        QApplication, QSize, QPushButton, QComboBox, QGroupBox)

from calibre.constants import DEBUG
from calibre.gui2 import gprefs, error_dialog, question_dialog, info_dialog

from polyglot.builtins import  as_bytes, as_unicode, iteritems, range

import ast

SEARCHTAB = 'SearchTab'
REGEXTAB = 'RegexTab'
FINALFILTERTAB = 'FinalFilterTab'
SPECIALQUERIESTAB = 'SpecialQueriesTab'
SIMILARITYTAB = 'SimilarityTab'
RAWSQLTAB = 'RawSQLTab'
VIRTUALCOLUMNTXTTAB = 'VirtualColumnTXTTab'
WORDBOOKINDEXQUERYTAB = 'WordBookIndexQueryTab'
RESULTSTAB = 'ResultsTab'

searchtab = 'Intra/Inter Book Queries'
regextab = 'Regular Expressions'
finalfiltertab = 'Final Filters'
specialqueriestab = 'Special Queries'
similaritytab = 'Similarity Queries'
rawsqltab = 'SQL Queries'
virtualcolumntxttab = 'TXT Queries'
wordbookindexquerytab = 'Word Queries'
resultstab = 'Post-Search Actions'

#~ INTRA_BOOK_SEARCH_TYPE = 'INTRA_BOOK_SEARCH'
#~ INTER_BOOK_SEARCH_TYPE = 'INTER_BOOK_SEARCH'
#~ REGULAR_EXPRESSIONS_TYPE = 'REGULAR_EXPRESSIONS'
#~ FINAL_FILTERS_TYPE = 'FINAL_FILTERS'
#~ SPECIAL_QUERIES_TYPE = 'SPECIAL_QUERIES'
#~ SIMILARITY_QUERIES_TYPE = 'SIMILARITY_QUERIES'
#~ SQL_QUERIES_TYPE = 'SQL_QUERIES'
#~ TXT_QUERIES_TYPE = 'TXT_QUERIES'
#~ WORD_QUERIES_TYPE = 'WORD_QUERIES'
#~ POST_SEARCH_TYPE = 'POST_SEARCH'

TAB = "Tab?"

#-----------------------------------------------------------------------------------------
#-----------------------------------------------------------------------------------------
class SizePersistedDialog(QDialog):
    initial_extra_size = QSize(100, 100)
    def __init__(self, parent, unique_pref_name):
        QDialog.__init__(self, parent)
        self.unique_pref_name = unique_pref_name
        self.geom = gprefs.get(unique_pref_name, None)
    def resize_dialog(self):
        if self.geom is None:
            self.resize(self.sizeHint()+self.initial_extra_size)
        else:
            self.restoreGeometry(self.geom)
    def save_dialog_geometry(self):
        geom = bytearray(self.saveGeometry())
        gprefs[self.unique_pref_name] = geom
#-----------------------------------------------------------------------------------------
#-----------------------------------------------------------------------------------------
class ManageSavedCriteriaDialog(SizePersistedDialog):

    proxyprefs = None
    proxy_history_dict = None
    proxy_history_names_dict = None
    proxy_deleted_parms_dict = None
    proxy_deleted_names_dict = None
    current_parm_list = None
    current_parm_dict = None
    ref_settings_history_names_dict = None

    def __init__(self,gui,icon,font,mcsprefs,load_criteria_settings_generic,create_criteria_parm_list_generic,
                        save_settings_parm_history_to_prefs_generic,restart_mcs):
        SizePersistedDialog.__init__(self,parent=gui,unique_pref_name="MCS:ManageSavedCriteriaDialog" )

        self.gui = gui

        global proxyprefs
        proxyprefs = {}
        proxyprefs['SETTINGS_HISTORY_DICT'] = mcsprefs['SETTINGS_HISTORY_DICT']
        proxyprefs['SETTINGS_HISTORY_NAMES_DICT'] = mcsprefs['SETTINGS_HISTORY_NAMES_DICT']

        global proxy_history_dict
        proxy_history_dict = {}

        global proxy_history_names_dict
        proxy_history_names_dict = {}

        global proxy_deleted_parms_dict
        proxy_deleted_parms_dict = {}

        global proxy_deleted_names_dict
        proxy_deleted_names_dict = {}

        global current_parm_list
        current_parm_list = []

        global current_parm_dict
        current_parm_dict = {}

        global ref_settings_history_names_dict
        ref_settings_history_names_dict = {}

        self.load_criteria_settings_generic = load_criteria_settings_generic
        self.create_criteria_parm_list_generic = create_criteria_parm_list_generic
        self.save_settings_parm_history_to_prefs_generic = save_settings_parm_history_to_prefs_generic
        self.restart_mcs = restart_mcs

        self.setWindowTitle('MCS: Manage MCS Saved Criteria by Tab')
        self.setWindowIcon(icon)

        self.setModal(False)

        font.setBold(False)
        font.setPointSize(10)

        tip = "<p style='white-space:wrap'>Change the Name (Rename), or Delete any Tab's previously saved (named) set of criteria."

        self.setToolTip(tip)

        self.layout_main = QVBoxLayout()
        self.setLayout(self.layout_main)

        self.mcs_groupbox = QGroupBox('')
        self.mcs_groupbox.setAlignment(Qt.AlignCenter)
        self.mcs_groupbox.setFont(font)
        self.mcs_groupbox.setToolTip(tip)
        self.layout_main.addWidget(self.mcs_groupbox)

        self.mcs_gb_layout = QVBoxLayout()
        self.mcs_groupbox.setLayout(self.mcs_gb_layout)

        self.mcs_tabs_combobox = QComboBox()
        self.mcs_tabs_combobox.setEditable(False)
        self.mcs_tabs_combobox.setFont(font)
        self.mcs_tabs_combobox.setToolTip("<p style='white-space:wrap'>Select the Tab for which you wish to Manage Saved Criteria.")
        self.mcs_gb_layout.addWidget(self.mcs_tabs_combobox)

        self.mcs_tabs_combobox.addItem(TAB)
        self.mcs_tabs_combobox.addItem(searchtab)
        self.mcs_tabs_combobox.addItem(regextab)
        self.mcs_tabs_combobox.addItem(finalfiltertab)
        self.mcs_tabs_combobox.addItem(specialqueriestab)
        self.mcs_tabs_combobox.addItem(similaritytab)
        self.mcs_tabs_combobox.addItem(rawsqltab)
        self.mcs_tabs_combobox.addItem(virtualcolumntxttab)
        self.mcs_tabs_combobox.addItem(wordbookindexquerytab)
        self.mcs_tabs_combobox.addItem(resultstab)

        self.mcs_tabs_combobox.setCurrentIndex(0)  # TAB
        self.mcs_tabs_combobox.currentIndexChanged.connect(self.event_mcs_tab_changed)
        self.mcs_tabs_combobox.activated.connect(self.event_mcs_tab_dropdown_arrow_clicked)

        #-----------------------------------------------------
        #~ self.mcs_gb_layout.addStretch(1)
        #-----------------------------------------------------
        font.setBold(False)
        font.setPointSize(10)

        self.mcs_tab_saved_parms_combobox = QComboBox()
        self.mcs_tab_saved_parms_combobox.setEditable(False)
        self.mcs_tab_saved_parms_combobox.setFont(font)
        self.mcs_tab_saved_parms_combobox.setMaxVisibleItems(50)
        self.mcs_tab_saved_parms_combobox.setMinimumHeight(10)
        self.mcs_tab_saved_parms_combobox.setToolTip("<p style='white-space:wrap'>Select the saved (named) set of criteria for the Tab you chose.")
        self.mcs_gb_layout.addWidget(self.mcs_tab_saved_parms_combobox)

        self.saved_parms_current_index = -1
        self.mcs_tab_saved_parms_combobox.setCurrentIndex(-1)
        self.mcs_tab_saved_parms_combobox.currentIndexChanged.connect(self.event_mcs_tab_saved_parms_changed)

        self.mcs_tab_saved_parms_combobox.hide()
        #-----------------------------------------------------
        self.edit_parm_buttonbox = QDialogButtonBox()
        self.edit_parm_buttonbox.setCenterButtons(True)
        self.mcs_gb_layout.addWidget(self.edit_parm_buttonbox)

        font.setBold(True)
        font.setPointSize(8)

        self.push_button_rename = QPushButton("Rename Current Item")
        self.push_button_rename.setFont(font)
        self.push_button_rename.clicked.connect(self.rename_parm)
        self.push_button_rename.setToolTip("<p style='white-space:wrap'>Change the name of the current saved (named) set of criteria.")

        self.push_button_delete = QPushButton("Delete Current Item")
        self.push_button_delete.setFont(font)
        self.push_button_delete.clicked.connect(self.delete_parm)
        self.push_button_delete.setToolTip("<p style='white-space:wrap'>Delete the current saved (named) set of criteria.")

        self.edit_parm_buttonbox.addButton(self.push_button_rename,QDialogButtonBox.AcceptRole)
        self.edit_parm_buttonbox.addButton(self.push_button_delete,QDialogButtonBox.AcceptRole)

        self.edit_parm_buttonbox.hide()
        #-----------------------------------------------------
        self.mcs_gb_layout.addStretch(1)
        #-----------------------------------------------------
        self.finalize_parm_buttonbox = QDialogButtonBox()
        self.finalize_parm_buttonbox.setCenterButtons(True)
        self.mcs_gb_layout.addWidget(self.finalize_parm_buttonbox)

        font.setBold(True)
        font.setPointSize(8)

        self.push_button_discard_changes = QPushButton("Discard All Changes")
        self.push_button_discard_changes.setFont(font)
        self.push_button_discard_changes.clicked.connect(self.discard_changes_parm)
        self.push_button_discard_changes.setToolTip("<p style='white-space:wrap'>Discard all changes you have made.")

        self.push_button_apply_changes = QPushButton("Apply All Changes")
        self.push_button_apply_changes.setFont(font)
        self.push_button_apply_changes.clicked.connect(self.apply_changes_parm)
        self.push_button_apply_changes.setToolTip("<p style='white-space:wrap'>Save all of the changes you have made, and then restart MCS using the refreshed saved (named) criteria.")

        self.finalize_parm_buttonbox.addButton(self.push_button_discard_changes,QDialogButtonBox.AcceptRole)
        self.finalize_parm_buttonbox.addButton(self.push_button_apply_changes,QDialogButtonBox.AcceptRole)

        self.finalize_parm_buttonbox.hide()
        #-----------------------------------------------------
        font.setBold(True)
        font.setPointSize(8)

        self.push_button_cancel = QPushButton("Exit")
        self.push_button_cancel.setFont(font)
        self.push_button_cancel.clicked.connect(self.save_and_exit)
        self.push_button_cancel.setDefault(True)
        self.push_button_cancel.setToolTip("<p style='white-space:wrap'>Save the current size of this dialog, and then exit.")
        self.mcs_gb_layout.addWidget(self.push_button_cancel)
        #------------------------------------------------

        self.resize_dialog()

        self.changes_exist = False
        self.changes_applied = False
    #-----------------------------------------------------------------------------------------
    #-----------------------------------------------------------------------------------------
    #~ EVENTS
    #-----------------------------------------------------------------------------------------
    #-----------------------------------------------------------------------------------------
    def event_mcs_tab_changed(self,event=None):
        if self.changes_exist:
            self.finalize_parm_buttonbox.show()
            return
        if self.mcs_tabs_combobox.currentText() == TAB:
            return
        self.manage_selected_tab()
    #-----------------------------------------------------------------------------------------
    def event_mcs_tab_dropdown_arrow_clicked(self,event=None):
        self.mcs_tab_saved_parms_combobox.hide()
        self.mcs_tab_saved_parms_combobox.clear()
        self.edit_parm_buttonbox.hide()
        if self.changes_exist:
            self.finalize_parm_buttonbox.show()
            return
    #-----------------------------------------------------------------------------------------
    def event_mcs_tab_saved_parms_changed(self,event=None):
        self.saved_parms_current_index = self.mcs_tab_saved_parms_combobox.currentIndex()
    #-----------------------------------------------------------------------------------------
    #-----------------------------------------------------------------------------------------
    #~ OTHER
    #-----------------------------------------------------------------------------------------
    #-----------------------------------------------------------------------------------------
    def manage_selected_tab(self):
        if self.mcs_tabs_combobox.currentText() == TAB:
            self.event_mcs_tab_dropdown_arrow_clicked()
            return
        QTimer.singleShot(0,self.get_saved_parms)
    #-----------------------------------------------------------------------------------------
    def get_saved_parms(self):

        current_tab = self.mcs_tabs_combobox.currentText()

        current_tab = self.translate_current_tab(current_tab)

        self.mcs_tab_saved_parms_combobox.clear()

        global proxyprefs

        settings_history_names_dict = proxyprefs['SETTINGS_HISTORY_NAMES_DICT']
        settings_history_names_dict = as_unicode(settings_history_names_dict)
        settings_history_names_dict = ast.literal_eval(settings_history_names_dict)
        if not isinstance(settings_history_names_dict,dict):
            proxyprefs['SETTINGS_HISTORY_NAMES_DICT'] = as_unicode({})

        global ref_settings_history_names_dict
        ref_settings_history_names_dict = settings_history_names_dict

        tmp_list = []
        parm_list,parm_dict,saveddate_for_name_dict = self.create_criteria_parm_list_generic(current_tab=current_tab)
        for parm in parm_list:
            saveddate = saveddate_for_name_dict[parm]
            if saveddate in settings_history_names_dict:
                name = settings_history_names_dict[saveddate]
                item = "[" + name + "]:" + parm
            else:
                item = "[ ]:" + parm
            tmp_list.append(item)
        #END FOR
        tmp_list.sort(reverse=True)
        for item in tmp_list:
            self.mcs_tab_saved_parms_combobox.addItem(item)
            if DEBUG: print(item)
        #END FOR
        del tmp_list

        if self.mcs_tab_saved_parms_combobox.count() > -1:
            self.mcs_tab_saved_parms_combobox.setCurrentIndex(0)

        global current_parm_list
        global current_parm_dict
        current_parm_list = parm_list
        current_parm_dict = parm_dict

        self.mcs_tab_saved_parms_combobox.show()

        self.edit_parm_buttonbox.show()

        self.update()

        QApplication.instance().processEvents()

        self.mcs_tab_saved_parms_combobox.showPopup()
    #-----------------------------------------------------------------------------------------
    def rename_parm(self):

        global proxy_history_dict
        global proxy_history_names_dict
        global proxy_deleted_parms_dict
        global current_parm_list
        global current_parm_dict
        global ref_settings_history_names_dict

        selected_parm = self.mcs_tab_saved_parms_combobox.currentText()
        selected_parm_index = self.mcs_tab_saved_parms_combobox.currentIndex()

        if selected_parm is None:
            return
        if not selected_parm > "":
            return
        if not len(current_parm_dict) > 0:
            return
        n = selected_parm[-1: ]
        if n.isdigit and isinstance(current_parm_dict,dict):
            n = int(n)
        else:
            return

        saveddate,type,vdict,parm = current_parm_dict[n]

        if saveddate.startswith("["):  #name is dynamically shown to the user in a combobox item
            n = saveddate.find("]:")
            if n > -1:
                saveddate = saveddate[n+2: ]

        qid = QInputDialog()
        qid.setOption(QInputDialog.InputDialogOption.UsePlainTextEditForTextInput)
        name,ok = qid.getText(self,"Rename Criteria for Future Ease of Use","Enter the New Name")
        if (not ok):
            return

        #~ Important: a parm's "name" is never in any key to any dict, whatsoever. it is temporarily shown to the user, but is never within a key to anything.
        oldname = ref_settings_history_names_dict[saveddate]
        proxy_history_names_dict[saveddate] = name
        ref_settings_history_names_dict[saveddate] = name

        old = self.mcs_tab_saved_parms_combobox.currentText()
        new = old.replace(oldname,name,1)
        self.mcs_tab_saved_parms_combobox.setItemText(selected_parm_index,new)
        self.mcs_tab_saved_parms_combobox.update()

        self.changes_exist = True
        self.mcs_tabs_combobox.setEnabled(False)
        self.finalize_parm_buttonbox.show()
    #-----------------------------------------------------------------------------------------
    def delete_parm(self):

        global proxy_history_dict
        global proxy_history_names_dict
        global proxy_deleted_parms_dict
        global proxy_deleted_names_dict
        global current_parm_list
        global current_parm_dict

        index = self.mcs_tab_saved_parms_combobox.currentIndex()
        selected_parm = self.mcs_tab_saved_parms_combobox.itemText(index)

        if selected_parm is None:
            return
        if not selected_parm > "":
            return
        if not len(current_parm_dict) > 0:
            return
        n = selected_parm[-1: ]
        if n.isdigit and isinstance(current_parm_dict,dict):
            n = int(n)
        else:
            return

        saveddate,type,vdict,parm = current_parm_dict[n]

        if saveddate.startswith("["):  #name is dynamically shown to the user in a combobox item
            n = saveddate.find("]:")
            if n > -1:
                saveddate = saveddate[n+2: ]

        if DEBUG: print("saveddate,type,vdict,parm = current_parm_dict[n] ", saveddate,type)

        proxy_deleted_parms_dict[saveddate] = None
        proxy_deleted_names_dict[saveddate] = None
        if saveddate in proxy_history_names_dict:  # previous Rename just before this Delete
            del proxy_history_names_dict[saveddate]

        self.mcs_tab_saved_parms_combobox.setCurrentIndex(index)
        self.mcs_tab_saved_parms_combobox.setItemText(index,"DELETED")
        self.mcs_tab_saved_parms_combobox.removeItem(index)  # This will update the current index when the index is removed.
        self.mcs_tab_saved_parms_combobox.update()

        self.changes_exist = True
        self.mcs_tabs_combobox.setEnabled(False)
        self.finalize_parm_buttonbox.show()

        msg = "Item has been marked to Delete; apply changes to actually Delete it."
        self.gui.status_bar.showMessage(msg)
    #-----------------------------------------------------------------------------------------
    def translate_current_tab(self,current_tab):
        if current_tab == searchtab:
            current_tab = SEARCHTAB
        elif current_tab == regextab:
            current_tab = REGEXTAB
        elif current_tab == finalfiltertab:
            current_tab = FINALFILTERTAB
        elif current_tab == specialqueriestab:
            current_tab = SPECIALQUERIESTAB
        elif current_tab == similaritytab:
            current_tab = SIMILARITYTAB
        elif current_tab == rawsqltab:
            current_tab = RAWSQLTAB
        elif current_tab == virtualcolumntxttab:
            current_tab = VIRTUALCOLUMNTXTTAB
        elif current_tab == wordbookindexquerytab:
            current_tab = WORDBOOKINDEXQUERYTAB
        elif current_tab == resultstab:
            current_tab = RESULTSTAB
        return current_tab
    #-----------------------------------------------------------------------------------------
    def discard_changes_parm(self):

        global proxy_history_dict
        global proxy_history_names_dict
        global proxy_deleted_parms_dict
        global proxy_deleted_names_dict
        global current_parm_list
        global current_parm_dict

        proxy_history_dict.clear()
        proxy_history_names_dict.clear()
        proxy_deleted_parms_dict.clear()
        proxy_deleted_names_dict.clear()
        del current_parm_list[:]
        current_parm_dict.clear()


        self.mcs_tabs_combobox.setCurrentIndex(0)  # TAB
        self.event_mcs_tab_dropdown_arrow_clicked()

        self.changes_exist = False
        self.mcs_tabs_combobox.setEnabled(True)
        self.finalize_parm_buttonbox.hide()

        msg = "All Unapplied Changes Discarded..."
        self.gui.status_bar.showMessage(msg)
    #-----------------------------------------------------------------------------------------
    def apply_changes_parm(self):

        if not self.changes_exist:
            return

        global proxyprefs
        global proxy_history_dict
        global proxy_history_names_dict
        global proxy_deleted_parms_dict
        global proxy_deleted_names_dict
        global current_parm_list
        global current_parm_dict

        settings_history_dict, settings_history_names_dict = self.get_history_dicts()

        #~ Important: a parm's "name" is never in any key to any dict, whatsoever. it is temporarily shown to the user, but is never a key to anything.

        #~ ---------------------------------------------
        #~ Delete a parm
        #~ ---------------------------------------------
        for k,v in iteritems(proxy_deleted_parms_dict):
            if k in settings_history_dict:
                del settings_history_dict[k]
        #END FOR
        #~ ---------------------------------------------
        #~ Delete a parm's name
        #~ ---------------------------------------------
        for k,v in iteritems(proxy_deleted_names_dict):
            if k in settings_history_names_dict:
                del settings_history_names_dict[k]
        #END FOR
        #~ ---------------------------------------------
        #~ Rename a (non-deleted) parm
        #~ ---------------------------------------------
        for k,v in iteritems(proxy_history_names_dict):
            if not k in proxy_deleted_names_dict:
                if k in settings_history_names_dict:
                    settings_history_names_dict[k] = v
        #END FOR
        #~ ---------------------------------------------
        #~ Remove orphans from names dict, if any.
        #~ ---------------------------------------------
        orphans_dict = {}
        for k,v in iteritems(settings_history_names_dict):
            if not k in settings_history_dict:
                orphans_dict[k] = v
        #END FOR
        for k,v in iteritems(orphans_dict):
            del settings_history_names_dict[k]
        #END FOR
        del orphans_dict
        #~ ---------------------------------------------
        #~ ---------------------------------------------
        #~ ---------------------------------------------
        proxyprefs['SETTINGS_HISTORY_DICT'] = as_unicode(settings_history_dict)
        proxyprefs['SETTINGS_HISTORY_NAMES_DICT']  = as_unicode(settings_history_names_dict)
        #~ ---------------------------------------------
        proxy_history_dict.clear()
        proxy_history_names_dict.clear()
        proxy_deleted_parms_dict.clear()
        proxy_deleted_names_dict.clear()
        del current_parm_list[:]
        current_parm_dict.clear()
        #~ ---------------------------------------------
        self.changes_applied = True
        msg = "Changes Applied; Restarting..."
        self.gui.status_bar.showMessage(msg)
        self.save_and_exit()
    #-----------------------------------------------------------------------------------------
    #-----------------------------------------------------------------------------------------
    def get_history_dicts(self):

        global proxyprefs
        #~ ---------------------------------------------
        settings_history_dict = proxyprefs['SETTINGS_HISTORY_DICT']
        settings_history_dict = as_unicode(settings_history_dict)
        settings_history_dict = ast.literal_eval(settings_history_dict)
        if not isinstance(settings_history_dict,dict):
            settings_history_dict = {}
        #~ ---------------------------------------------
        settings_history_names_dict = proxyprefs['SETTINGS_HISTORY_NAMES_DICT']
        settings_history_names_dict = as_unicode(settings_history_names_dict)
        settings_history_names_dict = ast.literal_eval(settings_history_names_dict)
        if not isinstance(settings_history_names_dict,dict):
            settings_history_names_dict = {}
        #~ ---------------------------------------------
        #~ ---------------------------------------------
        return settings_history_dict, settings_history_names_dict
    #-----------------------------------------------------------------------------------------
    #-----------------------------------------------------------------------------------------
    def save_and_exit(self):

        self.save_dialog_geometry()

        if self.changes_applied:

            import time
            now = as_unicode(time.strftime("%Y-%b-%d-%H:%M:%S", time.localtime(time.time())))

            global proxyprefs
            proxyprefs['SETTINGS_HISTORY_LAST_MANAGED_DATETIME'] = as_unicode(now)
            self.restart_mcs(proxyprefs)

        else:

            self.restart_mcs(None)  #ignore all pending changes and exit immediately

    #-----------------------------------------------------------------------------------------
    #-----------------------------------------------------------------------------------------
    #-----------------------------------------------------------------------------------------
    #-----------------------------------------------------------------------------------------
#END OF mcs_manage_criteria_dialog.py