# -*- coding: utf-8 -*-
__license__   = 'GPL v3'
__copyright__ = '2014,2015,2016,2017,2018,2019,2020,2021,2022,2023 DaltonST'
__my_version__ = "2.2.3"   # Qt.core

from calibre.customize import InterfaceActionBase

try:
    load_translations()
except Exception as e:
    from calibre.constants import DEBUG
    if DEBUG: print("author_book_count:  _init_.py - load_translations() - Exception: ", as_unicode(e))

class ActionAuthorBookCount(InterfaceActionBase):

    name                    = 'Author Book Count'
    description           = _('Updates a custom column for the total number of books written by each author for every book in your library. It has functionality that standard Calibre does not provide, especially the ability to search using queries constructed with integers. Example: ((#abc_numeric:">6") and (#abc_numeric:"<47")). Its ABC column in the Tag Browser has full functionality based specifically on ABC.')
    supported_platforms     = ['windows', 'osx', 'linux']
    author                  = 'DaltonST'
    version                 = (2, 2, 3)
    minimum_calibre_version = (6, 0, 0)

    actual_plugin           = 'calibre_plugins.author_book_count.ui:AuthorBookCountUpdate'

    gui_name = "author_book_count"

    def is_customizable(self):
        return False
#END of __init__py