# -*- coding: utf-8 -*-
__license__   = 'GPL v3'
__copyright__ = '2014,2015,2016,2017,2018,2019,2020,2021,2022,2023 DaltonST'
__my_version__ = "2.2.3"   # Qt.core

try:
    load_translations()
except Exception as e:
    from calibre.constants import DEBUG
    if DEBUG: print("author_book_count:  jobs.py - load_translations() - Exception: ", as_unicode(e))

from calibre.gui2.threaded_jobs import ThreadedJob
from calibre.utils.logging import Log

from polyglot.queue import Queue

from calibre_plugins.author_book_count.main import get_all_author_book_counts

# ------------------------------------------------------------------------------
def start_abc_threaded(self, my_gui, my_guidb, callback):
    job = ThreadedJob('author book count plugin','Author Book Count',get_all_author_book_counts,(self, my_guidb), {}, callback)
    self.gui.job_manager.run_threaded_job(job)
    self.gui.status_bar.show_message(_('This ABC job will update every book in your library'), 5000)
#END of jobs.py