# -*- coding: utf-8 -*-
__license__   = 'GPL v3'
__copyright__ = '2023 DaltonST'
__my_version__ = "1.0.0"  #New

from functools import partial

from qt.core import (Qt, QIcon, QMenu, QAction, QApplication)

from calibre.ebooks.metadata.book.base import Metadata
from calibre.gui2 import Dispatcher, error_dialog
from calibre.gui2.actions import InterfaceAction
from calibre.constants import DEBUG

from polyglot.builtins import as_unicode, iteritems

from calibre_plugins.extract_people_other_metadata.__init__ import EPOM_NAME, EPOM_DESCRIPTION
from calibre_plugins.extract_people_other_metadata.common_utils import set_plugin_icon_resources, get_icon, create_menu_action_unique
from calibre_plugins.extract_people_other_metadata.config import prefs
from calibre_plugins.extract_people_other_metadata.jobs import start_threaded_extract_people_other_metadata

PLUGIN_ICONS = ['images/epom.png']

class ActionExtractPeopleOtherMetadata(InterfaceAction):

    name = EPOM_NAME
    action_spec = ('EPOM','images/epom.png', EPOM_DESCRIPTION, None)
    action_type = 'global'
    accepts_drops = False
    auto_repeat = False
    priority = 1
    popup_type = 1

    #---------------------------------------------------------------------------------------------------------------------------------------
    #---------------------------------------------------------------------------------------------------------------------------------------
    def genesis(self):
        icon_resources = self.load_resources(PLUGIN_ICONS)
        set_plugin_icon_resources(self.name, icon_resources )
        self.qaction.setIcon(get_icon(PLUGIN_ICONS[0]))
        self.qaction.triggered.connect(self.create_epom_dialog)
    #---------------------------------------------------------------------------------------------------------------------------------------
    def library_changed(self,guidb):
        self.guidb = guidb
        try:
            self.extract_people_other_metadata_dialog.close()
        except:
            pass

        try:
            del self.template_functions
            self.template_functions = None
        except:
            pass
    #---------------------------------------------------------------------------------------------------------------------------------------
    def initialization_complete(self):

        self.guidb = self.gui.library_view.model().db

        for k,v in iteritems(prefs.defaults):
            if not k in prefs:
                prefs[k] = v
                prefs
        #END FOR

        from calibre.gui2.ui import get_gui
        self.maingui = get_gui()
        del get_gui

        self.template_functions = None

        if DEBUG: print("Extract People & Other Metadata (EPOM) has initialized...")
    #---------------------------------------------------------------------------------------------------------------------------------------
    def create_epom_dialog(self):

        self.guidb = self.gui.library_view.model().db

        self.selected_books_list = []

        try:
            self.extract_people_other_metadata_dialog.close()
        except:
            pass

        from calibre_plugins.extract_people_other_metadata.extract_people_other_metadata_dialog import Extract_People_Other_Metadata_Dialog
        self.extract_people_other_metadata_dialog = Extract_People_Other_Metadata_Dialog(self.maingui,self.qaction.icon(),self.guidb,self.start_extract_people_other_metadata,self.epom_dialog_restart_immediately)
        self.extract_people_other_metadata_dialog.show()
        self.extract_people_other_metadata_dialog.setAttribute(Qt.WA_DeleteOnClose)
        del Extract_People_Other_Metadata_Dialog
    #---------------------------------------------------------------------------------------------------------------------------------------
    def start_extract_people_other_metadata(self,active_cc_list):

        book_ids_list = self.get_selected_books()

        n_books = len(book_ids_list)
        if  n_books == 0:
            return error_dialog(self.gui, _('EPOM'),_('No Books Were Selected.'), show=True)

        self.guidb = self.gui.library_view.model().db

        import collections
        param_dict = collections.OrderedDict([])
        param_list = []
        for k,v in iteritems(prefs):
            item = k,v
            param_list.append(item)
        param_list.sort()
        for item in param_list:
            k,v = item
            param_dict[k] = v

        if self.template_functions is None:
            from calibre.utils.formatter_functions import formatter_functions, StoredObjectType
            self.template_functions = formatter_functions().get_builtins_and_aliases()
            if DEBUG: print("Items in template_functions: ", str(len(self.template_functions)))

        if prefs['EPOM_USE_FTS_INDEX']:
            start_threaded_extract_people_other_metadata(self.maingui, self.guidb, self.plugin_path, book_ids_list, param_dict, active_cc_list, self.template_functions, Dispatcher(self.finish_extract_people_other_metadata))
        else:
            for book in book_ids_list:
                book_list = []
                book_list.append(book)
                start_threaded_extract_people_other_metadata(self.maingui, self.guidb, self.plugin_path, book_list, param_dict, active_cc_list, self.template_functions, Dispatcher(self.finish_extract_people_other_metadata))
                del book_list
                QApplication.instance().processEvents()
        #END FOR

        del book_ids_list
        del collections
        del param_list
        del active_cc_list
    #---------------------------------------------------------------------------------------------------------------------------------------
    def finish_extract_people_other_metadata(self,job):

        if job.result is not None:
            book_ids_list,results_list = job.result
            del job
        else:
            del job
            return

        self.update_custom_metadata_using_standard_calibre(book_ids_list,results_list)

        del book_ids_list
        del results_list
    #---------------------------------------------------------------------------------------------------------------------------------------
    def update_custom_metadata_using_standard_calibre(self,book_ids_list,results_list):

        payload = None
        custom_columns_dict = self.maingui.current_db.field_metadata.custom_field_metadata()
        valid_datatypes = ['text', 'comments', 'int', 'float', 'datetime', 'bool']
        edit_metadata_action = self.maingui.iactions['Edit Metadata']
        merge_tags = prefs['EPOM_MERGE_TAGS']
        results_list.sort()

        final_book_ids_list = []  #all books that had usable results...

        book_ids_list = list(set(book_ids_list))  #some books may have had no usable results...'continue' books...

        id_map = None
        mi = None
        prior_book = None

        for row in results_list:

            current_book,custom_column,final_text,source = row
            current_book = int(current_book)

            if  prior_book == None:
                prior_book = current_book
                mi = Metadata(_('Unknown'))
                id_map = {}
                is_finished = False
            elif current_book != prior_book:
                id_map[prior_book] = mi
                final_book_ids_list.append(prior_book)
                is_finished = True
                prior_book = current_book
                mi = Metadata(_('Unknown'))

            if not final_text > " ":
                continue

            if not custom_column in custom_columns_dict:
                continue

            cc_dict = custom_columns_dict[custom_column]
            datatype = cc_dict['datatype']
            if not datatype in valid_datatypes:
                continue

            if DEBUG: print(custom_column)

            if datatype == "comments":
                new_value = final_text
            elif datatype == "text":
                multiple_dict = cc_dict["is_multiple"]
                if "list_to_ui" in multiple_dict:
                    new_value_list = []  # tag-like in tag-browser
                    new_value = final_text  + ','
                    s = new_value.split(',')
                    if len(s) > 0:
                        for new_value in s:
                            if new_value is not None:
                                new_value = new_value.strip()
                                if new_value > " ":
                                    new_value_list.append(new_value)
                            #END FOR
                    new_value = new_value_list
                else: # single text shown in tag-browser
                    new_value = final_text
            elif datatype == "int":
                new_value = self.format_numerics(final_text,"int")
                if new_value is None:
                    continue
            elif datatype == "float":
                new_value = self.format_numerics(final_text,"float")
                if new_value is None:
                    continue
            elif datatype == "bool":
                ft = self.format_numerics(final_text,"int")
                if ft is not None:
                    new_value = str(ft)
                    if new_value == "1":
                        new_value = True
                    elif new_value == "0":
                        new_value = False
                    else:
                        continue
                else:
                    if new_value.lower() == "true" or new_value.lower() == "t" or new_value.lower() == "yes":
                        new_value = True
                    elif new_value.lower() == "false" or new_value.lower() == "f" or new_value.lower() == "no":
                        new_value = False
                    else:
                        continue
            elif datatype == "datetime":
                new_value = self.format_datetime(final_text)
            else:
                continue

            mi_field = custom_column
            custcol = custom_columns_dict[mi_field]   #   '#translator'
            custcol['#value#'] = new_value
            mi.set_user_metadata(mi_field, custcol)
            is_finished = False

        #END FOR

        if not is_finished:
            id_map[current_book] = mi
            final_book_ids_list.append(current_book)

        final_book_ids_list = list(set(final_book_ids_list))
        final_book_ids_list.sort()

        payload = final_book_ids_list

        QApplication.instance().processEvents()

        try:
            if len(id_map) > 0:
                edit_metadata_action.apply_metadata_changes(id_map, callback=None, merge_tags=merge_tags, merge_comments=False)
        except Exception as e:
            if DEBUG: print("ERROR in:  edit_metadata_action.apply_metadata_changes:  ",str(e))

        QApplication.instance().processEvents()

        del custom_columns_dict
        del results_list
        del id_map
        del mi

        final_book_ids_list = list(set(final_book_ids_list))

        if len(final_book_ids_list) > 0:
            self.mark_selected_books(final_book_ids_list)
            QApplication.instance().processEvents()

        if DEBUG:
            if len(book_ids_list) != len(final_book_ids_list):
                print("Original Books List differs from Final Books List due to lack of sufficient returned results to process the edit_metadata_action")
                print("Info:  len(book_ids_list): ", str(len(book_ids_list)), "    len(final_book_ids_list)", str(len(final_book_ids_list))) #  Caution:   len(book_ids_list):  5     len(final_book_ids_list) 4
    #---------------------------------------------------------------------------------------------------------------------------------------
    def format_datetime(self,date):
        # 2016///    2016/02//    2016/02/28/

        year = "1901"
        month = "1"
        day = "1"

        if "/" in date:
            ssplit = date.split("/")
        elif "-" in date:
            ssplit = date.split("-")
        else:
            return None

        n = len(ssplit)
        if n > 0:
            yr = ssplit[0].strip()
            if yr.isdigit():
                year = yr
                if n > 1:
                    mo = ssplit[1].strip()
                    if mo.isdigit():
                        month = mo
                        if n > 2:
                            da = ssplit[2].strip()
                            if da.isdigit():
                                day = da

        year = int(year)
        month = int(month)
        day = int(day)

        date = self.mydatetime(year, month, day, 12, 0, 0)

        return date
    #---------------------------------------------------------------------------------------------------------------------------------------
    def format_numerics(self,value,datatype):
        try:
            value = value.strip()
            value = float(value)
            if datatype == "int":
                value = int(value)
        except:
            value = None
        return value
    #---------------------------------------------------------------------------------------------------------------------------------------
    def get_selected_books(self):

        book_ids_list = []

        book_ids = list(map(partial(self.convert_id_to_book), self.maingui.library_view.get_selected_ids()))
        n = len(book_ids)
        if n == 0:
            return book_ids_list
        else:
            for item in book_ids:
                s = item['calibre_id']
                s = int(s)
                book_ids_list.append(s)
            #END FOR
            return book_ids_list
    #---------------------------------------------------------------------------------------------------------------------------------------
    def convert_id_to_book(self, idval):
        book = {}
        book['calibre_id'] = int(idval)
        return book
    #---------------------------------------------------------------------------------------------------------------------------------------
    def mark_selected_books(self,book_ids_list):
        found_dict = {}
        s_true = 'true'
        for book in book_ids_list:
            key = int(book)
            found_dict[key] = s_true
        #END FOR
        marked_ids = dict.fromkeys(found_dict, s_true)
        self.maingui.current_db.set_marked_ids(marked_ids)
        self.maingui.search.set_search_string('marked:true')
        QApplication.instance().processEvents()
        del found_dict
        del book_ids_list
        del marked_ids
        return
    #---------------------------------------------------------------------------------------------------------------------------------------
    def epom_dialog_restart_immediately(self):
        self.extract_people_other_metadata_dialog.close()
        self.create_epom_dialog()
    #---------------------------------------------------------------------------------------------------------------------------------------
#END