# -*- coding: utf-8 -*-
__license__   = 'GPL v3'
__copyright__ = '2023 DaltonST'
__my_version__ = "1.0.0"  #New

import os

from qt.core import Qt, QApplication, QFileDialog, QTextEdit, QVBoxLayout, QDialog, QPushButton, QTextOption, QAbstractScrollArea

from calibre.constants import DEBUG
from calibre.gui2 import error_dialog

TEXT_DEFAULT_WIDTH =  700
TEXT_DEFAULT_HEIGHT = 700
    #---------------------------------------------------------------------------------------------------------------------------------------
class TweaksInfoViewerDialog(QDialog):


    def __init__(self,maingui,prefs,icon,title,text):
        super(TweaksInfoViewerDialog, self).__init__()

        self.maingui = maingui
        self.filename = title + ".txt"
        self.prefs = prefs
        self.text = text

        self.setWindowFlags(Qt.Window | Qt.WindowTitleHint | Qt.WindowCloseButtonHint | Qt.WindowMinMaxButtonsHint)
        self.setModal(False)
        self.setWindowIcon(icon)
        title = "EPOM:    " + title
        self.setWindowTitle(title)
        self.setSizeGripEnabled(True)
        self.setModal(False)

        self.setToolTip("<p style='white-space:wrap'>Save a back-up of your parameters for a chosen Custom Column.")
        self.layout = QVBoxLayout()
        self.layout.setAlignment(Qt.AlignRight)
        self.setLayout(self.layout)

        self.tweak_qtextedit =  QTextEdit("")
        self.tweak_qtextedit.setReadOnly(True)
        self.tweak_qtextedit.setWordWrapMode(QTextOption.WrapMode.NoWrap)
        self.tweak_qtextedit.setSizeAdjustPolicy(QAbstractScrollArea.SizeAdjustPolicy.AdjustToContents)
        self.tweak_qtextedit.setMinimumWidth(TEXT_DEFAULT_WIDTH)
        self.tweak_qtextedit.setMinimumHeight(TEXT_DEFAULT_HEIGHT)
        self.tweak_qtextedit.clear()
        self.tweak_qtextedit.setPlainText(text)
        self.layout.addWidget(self.tweak_qtextedit)

        self.resize(self.tweak_qtextedit.size())

        self.layout.addSpacing(10)

        self.save_pushbutton = QPushButton("Save to TXT File", self)
        self.save_pushbutton.clicked.connect(self.save_to_file)
        self.save_pushbutton.setMaximumWidth(300)
        self.layout.addWidget(self.save_pushbutton)

        self.layout.addSpacing(10)

        self.exit_pushbutton = QPushButton("Exit", self)
        self.exit_pushbutton.clicked.connect(self.exit_dialog)
        self.exit_pushbutton.setMaximumWidth(300)
        self.layout.addWidget(self.exit_pushbutton)

        self.show()
    #---------------------------------------------------------------------------------------------------------------------------------------
    def save_to_file(self):
        QApplication.instance().processEvents()
        title = "EPOM Custom Column Parameters: Export"
        default_user_directory = self.prefs['DEFAULT_USER_DIRECTORY']
        directory_name = QFileDialog.getExistingDirectory(None,title,default_user_directory,QFileDialog.Option.ShowDirsOnly | QFileDialog.Option.DontResolveSymlinks )
        self.prefs['DEFAULT_USER_DIRECTORY'] = directory_name
        self.prefs
        export_file_full_path = os.path.join(directory_name,self.filename)
        export_file_full_path = export_file_full_path.replace(os.sep, '/')

        try:
            with open(export_file_full_path, 'wt', encoding='utf-8') as f:
                f.write(self.text)
            #END WITH
            f.close()
            self.exit_dialog()
        except Exception as e:
            msg = "Save to .TXT File Error: " + str(e)
            if DEBUG: print(msg)
            return error_dialog(self.maingui, _('EPOM'),_(msg), show=True)
    #---------------------------------------------------------------------------------------------------------------------------------------
    def exit_dialog(self):
        self.done
        self.close()
#~ # end of tweak_info_viewer_dialog.py