# -*- coding: utf-8 -*-
__license__   = 'GPL v3'
__copyright__ = '2023 DaltonST'
__my_version__ = "1.0.0"  #New

from functools import partial
import re,sre_constants

from qt.core import (Qt,
                                    QButtonGroup,
                                    QCheckBox,
                                    QCompleter,
                                    QDialog,
                                    QFont,
                                    QHBoxLayout,
                                    QInputDialog,
                                    QLabel,
                                    QLineEdit,
                                    QPushButton,
                                    QRadioButton,
                                    QScrollArea,
                                    QSize,
                                    QSizePolicy,
                                    QTimer,
                                    QVBoxLayout,
                                    QWidget,
                                    )

from calibre.constants import DEBUG
from calibre.gui2 import gprefs, error_dialog, info_dialog

from polyglot.builtins import iteritems

from calibre_plugins.extract_people_other_metadata.config import prefs,GROUP_A,GROUP_B,GROUP_C,GROUP_D,GROUP_E
from calibre_plugins.extract_people_other_metadata.jobs import start_threaded_extract_people_other_metadata
from calibre_plugins.extract_people_other_metadata.tweak_info_viewer_dialog import TweaksInfoViewerDialog

VALID_DATATYPES =  ['text', 'comments', 'int', 'float', 'datetime', 'bool']
COMPLETER_MAX_VISIBLE_ITEMS = 1000
VALID_GROUPS = [GROUP_A,GROUP_B,GROUP_C,GROUP_D,GROUP_E]

#---------------------------------------------------------------------------------------------------------------------------------------
#---------------------------------------------------------------------------------------------------------------------------------------
class SizePersistedDialog(QDialog):

    initial_extra_size = QSize(150, 150)

    def __init__(self, parent, unique_pref_name):
        QDialog.__init__(self, parent)
        self.unique_pref_name = unique_pref_name
        self.geom = gprefs.get(unique_pref_name, None)
        self.finished.connect(self.save_dialog_geometry)

    def resize_dialog(self):
        if self.geom is None:
            self.resize(self.sizeHint()+self.initial_extra_size)
        else:
            self.restoreGeometry(self.geom)

    def save_dialog_geometry(self):
        geom = bytearray(self.saveGeometry())
        gprefs[self.unique_pref_name] = geom
#---------------------------------------------------------------------------------------------------------------------------------------
#---------------------------------------------------------------------------------------------------------------------------------------
class Extract_People_Other_Metadata_Dialog(SizePersistedDialog):

    def __init__(self, parent, icon,guidb,start_extract_people_other_metadata,epom_dialog_restart_immediately):

        self.parent = parent
        self.gui = parent
        self.guidb = guidb
        self.icon = icon
        self.start_extract_people_other_metadata = start_extract_people_other_metadata
        self.epom_dialog_restart_immediately = epom_dialog_restart_immediately
        #--------------------------------------------------
        self.unique_pref_name = 'Extract_People_Other_Metadata:extract_people_other_metadata_dialog'
        SizePersistedDialog.__init__(self, self.parent, self.unique_pref_name)
        #--------------------------------------------------
        from calibre.gui2.ui import get_gui
        self.maingui = get_gui()
        del get_gui
        #--------------------------------------------------
        self.current_group = prefs['EPOM_CONFIG_GROUP_CURRENT']
        if not self.current_group in VALID_GROUPS:
            self.current_group = GROUP_A
        self.old_current_group = self.current_group
        current_prefs_list = prefs[self.current_group]
        for row in current_prefs_list:
            k,v = row
            if not 'EPOM_CONFIG_GROUP_' in k:
                if not 'EPOM_DEFAULT' in k:
                    prefs[k] = v
        #END FOR
        prefs
        #~ self.set_current_group_button(self.current_group)  --- deferred until widgets actually exist...
        #--------------------------------------------------
        self.setWindowIcon(icon)
        self.setWindowTitle('EPOM Extract People & Other Metadata')
        self.setWindowFlags( Qt.Window | Qt.WindowTitleHint | Qt.WindowSystemMenuHint | Qt.WindowCloseButtonHint | Qt.WindowMinMaxButtonsHint)
        #--------------------------------------------------
        self.layout_frame = QVBoxLayout()
        self.setLayout(self.layout_frame)
        self.layout_frame.setAlignment(Qt.AlignCenter)
        self.setToolTip("<p style='white-space:wrap'>Extract People and Other Metadata from EPUBs (or the FTS Index), then update those values in their respective Custom Column.")
        #-----------------------------------------------------
        #-----------------------------------------------------
        self.scroll_area_frame = QScrollArea()
        self.scroll_area_frame.setAlignment(Qt.AlignCenter)
        self.scroll_area_frame.setWidgetResizable(True)
        self.scroll_area_frame.ensureVisible(800,800)
        self.layout_frame.addWidget(self.scroll_area_frame)
        #-----------------------------------------------------
        self.scroll_widget = QWidget()
        self.layout_frame.addWidget(self.scroll_widget)
        #-----------------------------------------------------
        self.layout_top = QVBoxLayout()
        self.layout_top.setSpacing(0)
        self.layout_top.setAlignment(Qt.AlignCenter)
        #-----------------------------------------------------
        self.scroll_widget.setLayout(self.layout_top)
        #-----------------------------------------------------
        font = QFont()
        font.setBold(False)
        font.setPointSize(10)
        #--------------------------------------------------
        self.layout_top.addSpacing(10)
        #--------------------------------------------------
        tip_activate = "<p style='white-space:wrap'>Activate for an Execution of an Extraction?"
        tip_cc = "<p style='white-space:wrap'>This is the Custom Column to update with the extracted text. Supported Custom Column Datatypes:  'text', 'comments', 'int', 'float', 'datetime', 'bool'."
        tip_keywords = "<p style='white-space:wrap'>'Keywords RE'  will be used as a single Regular Expression.  A bar, '|', means 'OR' in a Regular Expression. \
                                                                                  <br><br>'Keywords RE' is used with 're.finditer' (not 're.search' or 're.match').  re.finditer() matches all occurrences of a pattern, not just the first one as re.search() does.  \
                                                                                  re.finditer() is the same as re.findall().  Unlike re.findall(), re.finditer() does not use as much memory while it executes, since it does not\
                                                                                  read 100% of the text being analyzed prior to doing any matching.  re.finditer() iterates match-by-match over the text, reading into memory \
                                                                                  as little text as it needs at a time. Books are often quite long, so re.finditer() is preferred to re.findall()."
        tip_flag_ignorecase = "<p style='white-space:wrap'> Use the re.IGNORECASE flag?<br><br>This is often necessary unless you have specific reasons to not use it (e.g. regex specifies 'Reference' and not 'reference')."
        tip_flag_general = "<br><br>By default the '^' and '$' symbol match the beginning and end, respectively, of a string.\
                                    <br><br>By default, '^' and '$' would consider the whole text of a book as a single string and completely defeat their purpose.\
                                    <br><br>re.MULTILINE changes that behavior so each line with an 'end of line' (CRLF/newline) character is treated individually.\
                                    <br><br>re.DOTALL makes the '.' operator (Wildcard operator) match all characters, including newline. By default, the '.' operator does not match newline characters.\
                                    <br><br>The above two flags are not mutually exclusive in certain constructions of the Keywords RE.  Example:  the first part of the RE requires re.MULTILINE, \
                                    and the last part of the RE requres re.DOTALL.  This might be useful in selecting large blocks of text, and the 'starting point' might require re.MULTILINE, but \
                                    the rest of the block of text requires re.DOTALL.  However, do not use a particular flag unless you need it."
        tip_flag_multiline = "<p style='white-space:wrap'> Use the re.MULTILINE flag?  This is necessary if you wish each line of a book to be treated as a separate string. " + tip_flag_general
        tip_flag_dotall = "<p style='white-space:wrap'> Use the re.DOTALL flag?  This may be useful for extracting blocks of text, such as a Table of Contents. \
                                     <br><br>Caution: you may need to specify '.+?' instead of '.+' to make re.DOTALL stop selecting at the end of the text you are trying to match.\
                                     Depending on the the specific text being matched, a little simple deletion of unneeded text afterwards may be unavoidable." + tip_flag_general
        tip_regex = "<p style='white-space:wrap'>This is an optional regular expression that will be used with 're.search' (not 're.finditer' or 're.match') to select (fine tune) the final desired text from the raw text found using the specified Keywords RE.\
                                                                             <br><br>To use 're.search' as a 're.match', simply add a leading caret, '^', meaning 'begins with', to your regular expression.\
                                                                            <br><br>When the re.DOTALL flag is specified, this optional regular expression may be required to trim the initial text selected by the Keywords RE. \
                                                                            <br><br>For the supported non-textual Custom Column Datatypes 'int', 'float', 'datetime', and 'bool', this may not be optional.  EPOM will \
                                                                             attempt to convert the extracted text to the proper format (integer, float, datetime, boolean), but the final extracted text must be a proper value to convert appropriately.\
                                                                             <br><br>REGEX is only the second RE that you may specify for searching.  See Tweaks for as many additional searches as you wish using: \
                                                                             <br>ADDITIONAL_FINDITER_REGEX='pattern',flags=IGNORECASE,MULTILINE,DOTALL; and/or \
                                                                             <br>ADDITIONAL_SEARCH_REGEX='pattern',flags=IGNORECASE,MULTILINE,DOTALL."
        tip_tweaks = "<p style='white-space:wrap'>Tweak the text value after both the Keywords search and the optional REGEX search have completed by applying or executing one or more text formatting functions or other operations.  For more details, use the 'Tweaks List' button."
        tip_export = "<p style='white-space:wrap'>Save a .txt file with the parameters you have specified for a particular Custom Column.  Highly recommended as a back-up of your work."
        #--------------------------------------------------
        self.layout_column_headings = QHBoxLayout()
        self.layout_column_headings.setAlignment(Qt.AlignLeft)
        self.layout_top.addLayout(self.layout_column_headings)

        HEADINGTXT = "            Custom Column                                 Keywords RE                                        RE Flags                     Results RE   "
        tip_heading = "<p style='white-space:wrap'>Use the 'RE Help' button for detailed help in understanding Regular Expressions."
        self.column_headings_qlabel = QLabel(HEADINGTXT)
        self.column_headings_qlabel.setToolTip(tip_heading)
        self.layout_column_headings.addWidget(self.column_headings_qlabel)
        #--------------------------------------------------
        autocompletion_field_list = []
        tmp_list = self.guidb.custom_field_keys(include_composites=False)
        tmp_list.sort()
        self.custom_columns_dict = self.gui.current_db.field_metadata.custom_field_metadata()
        for row in tmp_list:
            datatype = self.custom_columns_dict[row]['datatype']
            if datatype not in VALID_DATATYPES:
                continue
            autocompletion_field_list.append(row)
        #END FOR
        del tmp_list
        #--------------------------------------------------
        #--------------------------------------------------
        self.layout_people_1 = QHBoxLayout()
        self.layout_people_1.setAlignment(Qt.AlignLeft)
        self.layout_top.addLayout(self.layout_people_1)

        self.extract_people_1_qcheckbox = QCheckBox(" ")
        self.extract_people_1_qcheckbox.setToolTip(tip_activate)
        self.layout_people_1.addWidget(self.extract_people_1_qcheckbox)
        self.extract_people_1_qcheckbox.setChecked(prefs['EPOM_EXTRACT_PEOPLE_1_ACTIVE'])

        self.extract_people_1_custom_column_qlineedit = QLineEdit(self)
        self.extract_people_1_custom_column_qlineedit.setText(prefs['EPOM_EXTRACT_PEOPLE_1_CUSTOM_COLUMN'])
        self.extract_people_1_custom_column_qlineedit.setFont(font)
        self.extract_people_1_custom_column_qlineedit.setMaximumWidth(120)
        self.extract_people_1_custom_column_qlineedit.setToolTip(tip_cc)
        self.extract_people_1_custom_column_qlineedit.setCursorPosition(0)
        self.extract_people_1_custom_column_qlineedit.setReadOnly(False)
        self.layout_people_1.addWidget(self.extract_people_1_custom_column_qlineedit)

        self.extract_people_1_custom_column_completer = QCompleter(autocompletion_field_list)  # https://doc.qt.io/qt-6/qcompleter.html#currentCompletion
        self.extract_people_1_custom_column_completer.setCompletionMode(QCompleter.CompletionMode.UnfilteredPopupCompletion)
        self.extract_people_1_custom_column_completer.setCaseSensitivity(Qt.CaseInsensitive)
        self.extract_people_1_custom_column_completer.setMaxVisibleItems(COMPLETER_MAX_VISIBLE_ITEMS)

        self.extract_people_1_custom_column_qlineedit.setCompleter(self.extract_people_1_custom_column_completer)

        s = prefs['EPOM_EXTRACT_PEOPLE_1_KEYWORDS']
        s = s.strip()
        if s.endswith("|"):
            s = s[0:-1]

        self.layout_people_1.addSpacing(5)

        self.extract_people_1_keyword_qlineedit = QLineEdit(self)
        self.extract_people_1_keyword_qlineedit.setText(s)
        self.extract_people_1_keyword_qlineedit.setFont(font)
        self.extract_people_1_keyword_qlineedit.setToolTip(tip_keywords)
        self.extract_people_1_keyword_qlineedit.setCursorPosition(0)
        self.layout_people_1.addWidget(self.extract_people_1_keyword_qlineedit)

        self.layout_people_1.addSpacing(5)

        self.extract_people_1_ignorecase_qcheckbox = QCheckBox(" ")
        self.extract_people_1_ignorecase_qcheckbox.setToolTip(tip_flag_ignorecase)
        self.layout_people_1.addWidget(self.extract_people_1_ignorecase_qcheckbox)
        self.extract_people_1_ignorecase_qcheckbox.setChecked(prefs['EPOM_EXTRACT_PEOPLE_1_IGNORECASE'])

        self.extract_people_1_multiline_qcheckbox = QCheckBox(" ")
        self.extract_people_1_multiline_qcheckbox.setToolTip(tip_flag_multiline)
        self.layout_people_1.addWidget(self.extract_people_1_multiline_qcheckbox)
        self.extract_people_1_multiline_qcheckbox.setChecked(prefs['EPOM_EXTRACT_PEOPLE_1_MULTILINE'])

        self.extract_people_1_dotall_qcheckbox = QCheckBox(" ")
        self.extract_people_1_dotall_qcheckbox.setToolTip(tip_flag_dotall)
        self.layout_people_1.addWidget(self.extract_people_1_dotall_qcheckbox)
        self.extract_people_1_dotall_qcheckbox.setChecked(prefs['EPOM_EXTRACT_PEOPLE_1_DOTALL'])

        self.extract_people_1_regex_qlineedit = QLineEdit(self)
        self.extract_people_1_regex_qlineedit.setText(prefs['EPOM_EXTRACT_PEOPLE_1_REGEX'])
        self.extract_people_1_regex_qlineedit.setFont(font)
        self.extract_people_1_regex_qlineedit.setMaximumWidth(175)
        self.extract_people_1_regex_qlineedit.setToolTip(tip_regex)
        self.extract_people_1_regex_qlineedit.setCursorPosition(0)
        self.layout_people_1.addWidget(self.extract_people_1_regex_qlineedit)

        self.layout_people_1.addSpacing(5)

        self.extract_people_1_tweaks_qpushbutton = QPushButton("Tweaks")
        self.extract_people_1_tweaks_qpushbutton.clicked.connect(self.people_1_format_tweaks)
        self.extract_people_1_tweaks_qpushbutton.setDefault(False)
        self.extract_people_1_tweaks_qpushbutton.setFont(font)
        self.extract_people_1_tweaks_qpushbutton.setToolTip(tip_tweaks)
        self.layout_people_1.addWidget(self.extract_people_1_tweaks_qpushbutton)

        self.layout_people_1.addSpacing(5)

        font.setPointSize(5)

        self.extract_people_1_export_qpushbutton = QPushButton("EXPORT")
        self.extract_people_1_export_qpushbutton.clicked.connect(self.people_1_export)
        self.extract_people_1_export_qpushbutton.setDefault(False)
        self.extract_people_1_export_qpushbutton.setFont(font)
        self.extract_people_1_export_qpushbutton.setMaximumWidth(25)
        self.extract_people_1_export_qpushbutton.setToolTip(tip_export)
        self.layout_people_1.addWidget(self.extract_people_1_export_qpushbutton)

        font.setPointSize(10)
        #--------------------------------------------------
        self.layout_top.addSpacing(10)

        self.layout_people_2 = QHBoxLayout()
        self.layout_people_2.setAlignment(Qt.AlignLeft)
        self.layout_top.addLayout(self.layout_people_2)

        self.extract_people_2_qcheckbox = QCheckBox(" ")
        self.extract_people_2_qcheckbox.setToolTip(tip_activate)
        self.layout_people_2.addWidget(self.extract_people_2_qcheckbox)
        self.extract_people_2_qcheckbox.setChecked(prefs['EPOM_EXTRACT_PEOPLE_2_ACTIVE'])

        self.extract_people_2_custom_column_qlineedit = QLineEdit(self)
        self.extract_people_2_custom_column_qlineedit.setText(prefs['EPOM_EXTRACT_PEOPLE_2_CUSTOM_COLUMN'])
        self.extract_people_2_custom_column_qlineedit.setFont(font)
        self.extract_people_2_custom_column_qlineedit.setMaximumWidth(120)
        self.extract_people_2_custom_column_qlineedit.setToolTip(tip_cc)
        self.extract_people_2_custom_column_qlineedit.setCursorPosition(0)
        self.extract_people_2_custom_column_qlineedit.setReadOnly(False)
        self.layout_people_2.addWidget(self.extract_people_2_custom_column_qlineedit)

        self.extract_people_2_custom_column_completer = QCompleter(autocompletion_field_list)
        self.extract_people_2_custom_column_completer.setCompletionMode(QCompleter.CompletionMode.UnfilteredPopupCompletion)
        self.extract_people_2_custom_column_completer.setCaseSensitivity(Qt.CaseInsensitive)
        self.extract_people_2_custom_column_completer.setMaxVisibleItems(COMPLETER_MAX_VISIBLE_ITEMS)

        self.extract_people_2_custom_column_qlineedit.setCompleter(self.extract_people_2_custom_column_completer)

        self.layout_people_2.addSpacing(5)

        s = prefs['EPOM_EXTRACT_PEOPLE_2_KEYWORDS']
        s = s.strip()
        if s.endswith("|"):
            s = s[0:-1]

        self.extract_people_2_keyword_qlineedit = QLineEdit(self)
        self.extract_people_2_keyword_qlineedit.setText(s)
        self.extract_people_2_keyword_qlineedit.setFont(font)
        self.extract_people_2_keyword_qlineedit.setToolTip(tip_keywords)
        self.extract_people_2_keyword_qlineedit.setCursorPosition(0)
        self.layout_people_2.addWidget(self.extract_people_2_keyword_qlineedit)

        self.layout_people_2.addSpacing(5)

        self.extract_people_2_ignorecase_qcheckbox = QCheckBox(" ")
        self.extract_people_2_ignorecase_qcheckbox.setToolTip(tip_flag_ignorecase)
        self.layout_people_2.addWidget(self.extract_people_2_ignorecase_qcheckbox)
        self.extract_people_2_ignorecase_qcheckbox.setChecked(prefs['EPOM_EXTRACT_PEOPLE_2_IGNORECASE'])

        self.extract_people_2_multiline_qcheckbox = QCheckBox(" ")
        self.extract_people_2_multiline_qcheckbox.setToolTip(tip_flag_multiline)
        self.layout_people_2.addWidget(self.extract_people_2_multiline_qcheckbox)
        self.extract_people_2_multiline_qcheckbox.setChecked(prefs['EPOM_EXTRACT_PEOPLE_2_MULTILINE'])

        self.extract_people_2_dotall_qcheckbox = QCheckBox(" ")
        self.extract_people_2_dotall_qcheckbox.setToolTip(tip_flag_dotall)
        self.layout_people_2.addWidget(self.extract_people_2_dotall_qcheckbox)
        self.extract_people_2_dotall_qcheckbox.setChecked(prefs['EPOM_EXTRACT_PEOPLE_2_DOTALL'])

        self.extract_people_2_regex_qlineedit = QLineEdit(self)
        self.extract_people_2_regex_qlineedit.setText(prefs['EPOM_EXTRACT_PEOPLE_2_REGEX'])
        self.extract_people_2_regex_qlineedit.setFont(font)
        self.extract_people_2_regex_qlineedit.setMaximumWidth(175)
        self.extract_people_2_regex_qlineedit.setToolTip(tip_regex)
        self.extract_people_2_regex_qlineedit.setCursorPosition(0)
        self.layout_people_2.addWidget(self.extract_people_2_regex_qlineedit)

        self.layout_people_2.addSpacing(5)

        self.extract_people_2_tweaks_qpushbutton = QPushButton("Tweaks")
        self.extract_people_2_tweaks_qpushbutton.clicked.connect(self.people_2_format_tweaks)
        self.extract_people_2_tweaks_qpushbutton.setDefault(False)
        self.extract_people_2_tweaks_qpushbutton.setFont(font)
        self.extract_people_2_tweaks_qpushbutton.setToolTip(tip_tweaks)
        self.layout_people_2.addWidget(self.extract_people_2_tweaks_qpushbutton)

        self.layout_people_2.addSpacing(5)

        font.setPointSize(5)

        self.extract_people_2_export_qpushbutton = QPushButton("EXPORT")
        self.extract_people_2_export_qpushbutton.clicked.connect(self.people_2_export)
        self.extract_people_2_export_qpushbutton.setDefault(False)
        self.extract_people_2_export_qpushbutton.setFont(font)
        self.extract_people_2_export_qpushbutton.setMaximumWidth(25)
        self.extract_people_2_export_qpushbutton.setToolTip(tip_export)
        self.layout_people_2.addWidget(self.extract_people_2_export_qpushbutton)

        font.setPointSize(10)
        #--------------------------------------------------
        self.layout_top.addSpacing(10)

        self.layout_people_3 = QHBoxLayout()
        self.layout_people_3.setAlignment(Qt.AlignLeft)
        self.layout_top.addLayout(self.layout_people_3)

        self.extract_people_3_qcheckbox = QCheckBox(" ")
        self.extract_people_3_qcheckbox.setToolTip(tip_activate)
        self.layout_people_3.addWidget(self.extract_people_3_qcheckbox)
        self.extract_people_3_qcheckbox.setChecked(prefs['EPOM_EXTRACT_PEOPLE_3_ACTIVE'])

        self.extract_people_3_custom_column_qlineedit = QLineEdit(self)
        self.extract_people_3_custom_column_qlineedit.setText(prefs['EPOM_EXTRACT_PEOPLE_3_CUSTOM_COLUMN'])
        self.extract_people_3_custom_column_qlineedit.setFont(font)
        self.extract_people_3_custom_column_qlineedit.setMaximumWidth(120)
        self.extract_people_3_custom_column_qlineedit.setToolTip(tip_cc)
        self.extract_people_3_custom_column_qlineedit.setCursorPosition(0)
        self.extract_people_3_custom_column_qlineedit.setReadOnly(False)
        self.layout_people_3.addWidget(self.extract_people_3_custom_column_qlineedit)

        self.extract_people_3_custom_column_completer = QCompleter(autocompletion_field_list)
        self.extract_people_3_custom_column_completer.setCompletionMode(QCompleter.CompletionMode.UnfilteredPopupCompletion)
        self.extract_people_3_custom_column_completer.setCaseSensitivity(Qt.CaseInsensitive)
        self.extract_people_3_custom_column_completer.setMaxVisibleItems(COMPLETER_MAX_VISIBLE_ITEMS)

        self.extract_people_3_custom_column_qlineedit.setCompleter(self.extract_people_3_custom_column_completer)

        self.layout_people_3.addSpacing(5)

        s = prefs['EPOM_EXTRACT_PEOPLE_3_KEYWORDS']
        s = s.strip()
        if s.endswith("|"):
            s = s[0:-1]

        self.extract_people_3_keyword_qlineedit = QLineEdit(self)
        self.extract_people_3_keyword_qlineedit.setText(s)
        self.extract_people_3_keyword_qlineedit.setFont(font)
        self.extract_people_3_keyword_qlineedit.setToolTip(tip_keywords)
        self.extract_people_3_keyword_qlineedit.setCursorPosition(0)
        self.layout_people_3.addWidget(self.extract_people_3_keyword_qlineedit)

        self.layout_people_3.addSpacing(5)

        self.extract_people_3_ignorecase_qcheckbox = QCheckBox(" ")
        self.extract_people_3_ignorecase_qcheckbox.setToolTip(tip_flag_ignorecase)
        self.layout_people_3.addWidget(self.extract_people_3_ignorecase_qcheckbox)
        self.extract_people_3_ignorecase_qcheckbox.setChecked(prefs['EPOM_EXTRACT_PEOPLE_3_IGNORECASE'])

        self.extract_people_3_multiline_qcheckbox = QCheckBox(" ")
        self.extract_people_3_multiline_qcheckbox.setToolTip(tip_flag_multiline)
        self.layout_people_3.addWidget(self.extract_people_3_multiline_qcheckbox)
        self.extract_people_3_multiline_qcheckbox.setChecked(prefs['EPOM_EXTRACT_PEOPLE_3_MULTILINE'])

        self.extract_people_3_dotall_qcheckbox = QCheckBox(" ")
        self.extract_people_3_dotall_qcheckbox.setToolTip(tip_flag_dotall)
        self.layout_people_3.addWidget(self.extract_people_3_dotall_qcheckbox)
        self.extract_people_3_dotall_qcheckbox.setChecked(prefs['EPOM_EXTRACT_PEOPLE_3_DOTALL'])

        self.extract_people_3_regex_qlineedit = QLineEdit(self)
        self.extract_people_3_regex_qlineedit.setText(prefs['EPOM_EXTRACT_PEOPLE_3_REGEX'])
        self.extract_people_3_regex_qlineedit.setFont(font)
        self.extract_people_3_regex_qlineedit.setMaximumWidth(175)
        self.extract_people_3_regex_qlineedit.setToolTip(tip_regex)
        self.extract_people_3_regex_qlineedit.setCursorPosition(0)
        self.layout_people_3.addWidget(self.extract_people_3_regex_qlineedit)

        self.layout_people_3.addSpacing(5)

        self.extract_people_3_tweaks_qpushbutton = QPushButton("Tweaks")
        self.extract_people_3_tweaks_qpushbutton.clicked.connect(self.people_3_format_tweaks)
        self.extract_people_3_tweaks_qpushbutton.setDefault(False)
        self.extract_people_3_tweaks_qpushbutton.setFont(font)
        self.extract_people_3_tweaks_qpushbutton.setToolTip(tip_tweaks)
        self.layout_people_3.addWidget(self.extract_people_3_tweaks_qpushbutton)

        self.layout_people_3.addSpacing(5)

        font.setPointSize(5)

        self.extract_people_3_export_qpushbutton = QPushButton("EXPORT")
        self.extract_people_3_export_qpushbutton.clicked.connect(self.people_3_export)
        self.extract_people_3_export_qpushbutton.setDefault(False)
        self.extract_people_3_export_qpushbutton.setFont(font)
        self.extract_people_3_export_qpushbutton.setMaximumWidth(25)
        self.extract_people_3_export_qpushbutton.setToolTip(tip_export)
        self.layout_people_3.addWidget(self.extract_people_3_export_qpushbutton)

        font.setPointSize(10)
        #--------------------------------------------------
        #--------------------------------------------------
        self.layout_top.addSpacing(10)

        self.layout_people_4 = QHBoxLayout()
        self.layout_people_4.setAlignment(Qt.AlignLeft)
        self.layout_top.addLayout(self.layout_people_4)

        self.extract_people_4_qcheckbox = QCheckBox(" ")
        self.extract_people_4_qcheckbox.setToolTip(tip_activate)
        self.layout_people_4.addWidget(self.extract_people_4_qcheckbox)
        self.extract_people_4_qcheckbox.setChecked(prefs['EPOM_EXTRACT_PEOPLE_4_ACTIVE'])

        self.extract_people_4_custom_column_qlineedit = QLineEdit(self)
        self.extract_people_4_custom_column_qlineedit.setText(prefs['EPOM_EXTRACT_PEOPLE_4_CUSTOM_COLUMN'])
        self.extract_people_4_custom_column_qlineedit.setFont(font)
        self.extract_people_4_custom_column_qlineedit.setMaximumWidth(120)
        self.extract_people_4_custom_column_qlineedit.setToolTip(tip_cc)
        self.extract_people_4_custom_column_qlineedit.setCursorPosition(0)
        self.extract_people_4_custom_column_qlineedit.setReadOnly(False)
        self.layout_people_4.addWidget(self.extract_people_4_custom_column_qlineedit)

        self.extract_people_4_custom_column_completer = QCompleter(autocompletion_field_list)
        self.extract_people_4_custom_column_completer.setCompletionMode(QCompleter.CompletionMode.UnfilteredPopupCompletion)
        self.extract_people_4_custom_column_completer.setCaseSensitivity(Qt.CaseInsensitive)
        self.extract_people_4_custom_column_completer.setMaxVisibleItems(COMPLETER_MAX_VISIBLE_ITEMS)

        self.extract_people_4_custom_column_qlineedit.setCompleter(self.extract_people_4_custom_column_completer)

        self.layout_people_4.addSpacing(5)

        s = prefs['EPOM_EXTRACT_PEOPLE_4_KEYWORDS']
        s = s.strip()
        if s.endswith("|"):
            s = s[0:-1]

        self.extract_people_4_keyword_qlineedit = QLineEdit(self)
        self.extract_people_4_keyword_qlineedit.setText(s)
        self.extract_people_4_keyword_qlineedit.setFont(font)
        self.extract_people_4_keyword_qlineedit.setToolTip(tip_keywords)
        self.extract_people_4_keyword_qlineedit.setCursorPosition(0)
        self.layout_people_4.addWidget(self.extract_people_4_keyword_qlineedit)

        self.layout_people_4.addSpacing(5)

        self.extract_people_4_ignorecase_qcheckbox = QCheckBox(" ")
        self.extract_people_4_ignorecase_qcheckbox.setToolTip(tip_flag_ignorecase)
        self.layout_people_4.addWidget(self.extract_people_4_ignorecase_qcheckbox)
        self.extract_people_4_ignorecase_qcheckbox.setChecked(prefs['EPOM_EXTRACT_PEOPLE_4_IGNORECASE'])

        self.extract_people_4_multiline_qcheckbox = QCheckBox(" ")
        self.extract_people_4_multiline_qcheckbox.setToolTip(tip_flag_multiline)
        self.layout_people_4.addWidget(self.extract_people_4_multiline_qcheckbox)
        self.extract_people_4_multiline_qcheckbox.setChecked(prefs['EPOM_EXTRACT_PEOPLE_4_MULTILINE'])

        self.extract_people_4_dotall_qcheckbox = QCheckBox(" ")
        self.extract_people_4_dotall_qcheckbox.setToolTip(tip_flag_dotall)
        self.layout_people_4.addWidget(self.extract_people_4_dotall_qcheckbox)
        self.extract_people_4_dotall_qcheckbox.setChecked(prefs['EPOM_EXTRACT_PEOPLE_4_DOTALL'])

        self.extract_people_4_regex_qlineedit = QLineEdit(self)
        self.extract_people_4_regex_qlineedit.setText(prefs['EPOM_EXTRACT_PEOPLE_4_REGEX'])
        self.extract_people_4_regex_qlineedit.setFont(font)
        self.extract_people_4_regex_qlineedit.setMaximumWidth(175)
        self.extract_people_4_regex_qlineedit.setToolTip(tip_regex)
        self.extract_people_4_regex_qlineedit.setCursorPosition(0)
        self.layout_people_4.addWidget(self.extract_people_4_regex_qlineedit)

        self.layout_people_4.addSpacing(5)

        self.extract_people_4_tweaks_qpushbutton = QPushButton("Tweaks")
        self.extract_people_4_tweaks_qpushbutton.clicked.connect(self.people_4_format_tweaks)
        self.extract_people_4_tweaks_qpushbutton.setDefault(False)
        self.extract_people_4_tweaks_qpushbutton.setFont(font)
        self.extract_people_4_tweaks_qpushbutton.setToolTip(tip_tweaks)
        self.layout_people_4.addWidget(self.extract_people_4_tweaks_qpushbutton)

        self.layout_people_4.addSpacing(5)

        font.setPointSize(5)

        self.extract_people_4_export_qpushbutton = QPushButton("EXPORT")
        self.extract_people_4_export_qpushbutton.clicked.connect(self.people_4_export)
        self.extract_people_4_export_qpushbutton.setDefault(False)
        self.extract_people_4_export_qpushbutton.setFont(font)
        self.extract_people_4_export_qpushbutton.setMaximumWidth(25)
        self.extract_people_4_export_qpushbutton.setToolTip(tip_export)
        self.layout_people_4.addWidget(self.extract_people_4_export_qpushbutton)

        font.setPointSize(10)
        #--------------------------------------------------
        self.layout_top.addSpacing(10)

        self.layout_people_5 = QHBoxLayout()
        self.layout_people_5.setAlignment(Qt.AlignLeft)
        self.layout_top.addLayout(self.layout_people_5)

        self.extract_people_5_qcheckbox = QCheckBox(" ")
        self.extract_people_5_qcheckbox.setToolTip(tip_activate)
        self.layout_people_5.addWidget(self.extract_people_5_qcheckbox)
        self.extract_people_5_qcheckbox.setChecked(prefs['EPOM_EXTRACT_PEOPLE_5_ACTIVE'])

        self.extract_people_5_custom_column_qlineedit = QLineEdit(self)
        self.extract_people_5_custom_column_qlineedit.setText(prefs['EPOM_EXTRACT_PEOPLE_5_CUSTOM_COLUMN'])
        self.extract_people_5_custom_column_qlineedit.setFont(font)
        self.extract_people_5_custom_column_qlineedit.setMaximumWidth(120)
        self.extract_people_5_custom_column_qlineedit.setToolTip(tip_cc)
        self.extract_people_5_custom_column_qlineedit.setCursorPosition(0)
        self.layout_people_5.addWidget(self.extract_people_5_custom_column_qlineedit)

        self.extract_people_5_custom_column_completer = QCompleter(autocompletion_field_list)
        self.extract_people_5_custom_column_completer.setCompletionMode(QCompleter.CompletionMode.UnfilteredPopupCompletion)
        self.extract_people_5_custom_column_completer.setCaseSensitivity(Qt.CaseInsensitive)
        self.extract_people_5_custom_column_completer.setMaxVisibleItems(COMPLETER_MAX_VISIBLE_ITEMS)

        self.extract_people_5_custom_column_qlineedit.setCompleter(self.extract_people_5_custom_column_completer)

        self.layout_people_5.addSpacing(5)

        s = prefs['EPOM_EXTRACT_PEOPLE_5_KEYWORDS']
        s = s.strip()
        if s.endswith("|"):
            s = s[0:-1]

        self.extract_people_5_keyword_qlineedit = QLineEdit(self)
        self.extract_people_5_keyword_qlineedit.setText(s)
        self.extract_people_5_keyword_qlineedit.setFont(font)
        self.extract_people_5_keyword_qlineedit.setToolTip(tip_keywords)
        self.extract_people_5_keyword_qlineedit.setCursorPosition(0)
        self.layout_people_5.addWidget(self.extract_people_5_keyword_qlineedit)

        self.layout_people_5.addSpacing(5)

        self.extract_people_5_ignorecase_qcheckbox = QCheckBox(" ")
        self.extract_people_5_ignorecase_qcheckbox.setToolTip(tip_flag_ignorecase)
        self.layout_people_5.addWidget(self.extract_people_5_ignorecase_qcheckbox)
        self.extract_people_5_ignorecase_qcheckbox.setChecked(prefs['EPOM_EXTRACT_PEOPLE_5_IGNORECASE'])

        self.extract_people_5_multiline_qcheckbox = QCheckBox(" ")
        self.extract_people_5_multiline_qcheckbox.setToolTip(tip_flag_multiline)
        self.layout_people_5.addWidget(self.extract_people_5_multiline_qcheckbox)
        self.extract_people_5_multiline_qcheckbox.setChecked(prefs['EPOM_EXTRACT_PEOPLE_5_MULTILINE'])

        self.extract_people_5_dotall_qcheckbox = QCheckBox(" ")
        self.extract_people_5_dotall_qcheckbox.setToolTip(tip_flag_dotall)
        self.layout_people_5.addWidget(self.extract_people_5_dotall_qcheckbox)
        self.extract_people_5_dotall_qcheckbox.setChecked(prefs['EPOM_EXTRACT_PEOPLE_5_DOTALL'])

        self.extract_people_5_regex_qlineedit = QLineEdit(self)
        self.extract_people_5_regex_qlineedit.setText(prefs['EPOM_EXTRACT_PEOPLE_5_REGEX'])
        self.extract_people_5_regex_qlineedit.setFont(font)
        self.extract_people_5_regex_qlineedit.setMaximumWidth(175)
        self.extract_people_5_regex_qlineedit.setToolTip(tip_regex)
        self.extract_people_5_regex_qlineedit.setCursorPosition(0)
        self.layout_people_5.addWidget(self.extract_people_5_regex_qlineedit)

        self.layout_people_5.addSpacing(5)

        self.extract_people_5_tweaks_qpushbutton = QPushButton("Tweaks")
        self.extract_people_5_tweaks_qpushbutton.clicked.connect(self.people_5_format_tweaks)
        self.extract_people_5_tweaks_qpushbutton.setDefault(False)
        self.extract_people_5_tweaks_qpushbutton.setFont(font)
        self.extract_people_5_tweaks_qpushbutton.setToolTip(tip_tweaks)
        self.layout_people_5.addWidget(self.extract_people_5_tweaks_qpushbutton)

        self.layout_people_5.addSpacing(5)

        font.setPointSize(5)

        self.extract_people_5_export_qpushbutton = QPushButton("EXPORT")
        self.extract_people_5_export_qpushbutton.clicked.connect(self.people_5_export)
        self.extract_people_5_export_qpushbutton.setDefault(False)
        self.extract_people_5_export_qpushbutton.setFont(font)
        self.extract_people_5_export_qpushbutton.setMaximumWidth(25)
        self.extract_people_5_export_qpushbutton.setToolTip(tip_export)
        self.layout_people_5.addWidget(self.extract_people_5_export_qpushbutton)

        font.setPointSize(10)
        #--------------------------------------------------
        self.layout_top.addSpacing(10)

        self.layout_people_6 = QHBoxLayout()
        self.layout_people_6.setAlignment(Qt.AlignLeft)
        self.layout_top.addLayout(self.layout_people_6)

        self.extract_people_6_qcheckbox = QCheckBox(" ")
        self.extract_people_6_qcheckbox.setToolTip(tip_activate)
        self.layout_people_6.addWidget(self.extract_people_6_qcheckbox)
        self.extract_people_6_qcheckbox.setChecked(prefs['EPOM_EXTRACT_PEOPLE_6_ACTIVE'])

        self.extract_people_6_custom_column_qlineedit = QLineEdit(self)
        self.extract_people_6_custom_column_qlineedit.setText(prefs['EPOM_EXTRACT_PEOPLE_6_CUSTOM_COLUMN'])
        self.extract_people_6_custom_column_qlineedit.setFont(font)
        self.extract_people_6_custom_column_qlineedit.setMaximumWidth(120)
        self.extract_people_6_custom_column_qlineedit.setToolTip(tip_cc)
        self.extract_people_6_custom_column_qlineedit.setCursorPosition(0)
        self.layout_people_6.addWidget(self.extract_people_6_custom_column_qlineedit)

        self.extract_people_6_custom_column_completer = QCompleter(autocompletion_field_list)
        self.extract_people_6_custom_column_completer.setCompletionMode(QCompleter.CompletionMode.UnfilteredPopupCompletion)
        self.extract_people_6_custom_column_completer.setCaseSensitivity(Qt.CaseInsensitive)
        self.extract_people_6_custom_column_completer.setMaxVisibleItems(COMPLETER_MAX_VISIBLE_ITEMS)

        self.extract_people_6_custom_column_qlineedit.setCompleter(self.extract_people_6_custom_column_completer)

        self.layout_people_6.addSpacing(5)

        s = prefs['EPOM_EXTRACT_PEOPLE_6_KEYWORDS']
        s = s.strip()
        if s.endswith("|"):
            s = s[0:-1]

        self.extract_people_6_keyword_qlineedit = QLineEdit(self)
        self.extract_people_6_keyword_qlineedit.setText(s)
        self.extract_people_6_keyword_qlineedit.setFont(font)
        self.extract_people_6_keyword_qlineedit.setToolTip(tip_keywords)
        self.extract_people_6_keyword_qlineedit.setCursorPosition(0)
        self.layout_people_6.addWidget(self.extract_people_6_keyword_qlineedit)

        self.layout_people_6.addSpacing(5)

        self.extract_people_6_ignorecase_qcheckbox = QCheckBox(" ")
        self.extract_people_6_ignorecase_qcheckbox.setToolTip(tip_flag_ignorecase)
        self.layout_people_6.addWidget(self.extract_people_6_ignorecase_qcheckbox)
        self.extract_people_6_ignorecase_qcheckbox.setChecked(prefs['EPOM_EXTRACT_PEOPLE_6_IGNORECASE'])

        self.extract_people_6_multiline_qcheckbox = QCheckBox(" ")
        self.extract_people_6_multiline_qcheckbox.setToolTip(tip_flag_multiline)
        self.layout_people_6.addWidget(self.extract_people_6_multiline_qcheckbox)
        self.extract_people_6_multiline_qcheckbox.setChecked(prefs['EPOM_EXTRACT_PEOPLE_6_MULTILINE'])

        self.extract_people_6_dotall_qcheckbox = QCheckBox(" ")
        self.extract_people_6_dotall_qcheckbox.setToolTip(tip_flag_dotall)
        self.layout_people_6.addWidget(self.extract_people_6_dotall_qcheckbox)
        self.extract_people_6_dotall_qcheckbox.setChecked(prefs['EPOM_EXTRACT_PEOPLE_6_DOTALL'])

        self.extract_people_6_regex_qlineedit = QLineEdit(self)
        self.extract_people_6_regex_qlineedit.setText(prefs['EPOM_EXTRACT_PEOPLE_6_REGEX'])
        self.extract_people_6_regex_qlineedit.setFont(font)
        self.extract_people_6_regex_qlineedit.setMaximumWidth(175)
        self.extract_people_6_regex_qlineedit.setToolTip(tip_regex)
        self.extract_people_6_regex_qlineedit.setCursorPosition(0)
        self.layout_people_6.addWidget(self.extract_people_6_regex_qlineedit)

        self.layout_people_6.addSpacing(5)

        self.extract_people_6_tweaks_qpushbutton = QPushButton("Tweaks")
        self.extract_people_6_tweaks_qpushbutton.clicked.connect(self.people_6_format_tweaks)
        self.extract_people_6_tweaks_qpushbutton.setDefault(False)
        self.extract_people_6_tweaks_qpushbutton.setFont(font)
        self.extract_people_6_tweaks_qpushbutton.setToolTip(tip_tweaks)
        self.layout_people_6.addWidget(self.extract_people_6_tweaks_qpushbutton)

        self.layout_people_6.addSpacing(5)

        font.setPointSize(5)

        self.extract_people_6_export_qpushbutton = QPushButton("EXPORT")
        self.extract_people_6_export_qpushbutton.clicked.connect(self.people_6_export)
        self.extract_people_6_export_qpushbutton.setDefault(False)
        self.extract_people_6_export_qpushbutton.setFont(font)
        self.extract_people_6_export_qpushbutton.setMaximumWidth(25)
        self.extract_people_6_export_qpushbutton.setToolTip(tip_export)
        self.layout_people_6.addWidget(self.extract_people_6_export_qpushbutton)

        font.setPointSize(10)
        #--------------------------------------------------
        #--------------------------------------------------
        self.layout_top.addSpacing(30)

        self.layout_radiobuttons = QHBoxLayout()
        self.layout_radiobuttons.setAlignment(Qt.AlignCenter)
        self.layout_top.addLayout(self.layout_radiobuttons)

        self.prefs_set_qbuttongroup = QButtonGroup()
        self.prefs_set_qbuttongroup.setExclusive(True)

        tip_buttongroup = "<p style='white-space:wrap'>You may have 5 different Groups of 6 #Custom Column customizations by selecting the appropriate button.\
                                                                                         <br><br>Upon changing the Group, that Group's values will immediately be loaded and EPOM restarted.\
                                                                                         <br><br>When you next 'save', the currently selected Group will be saved.\
                                                                                         <br><br>Be sure to explicitly save the 'old' Group, if you wish, prior to changing to a new Group, or any changes will be discarded."

        self.prefs_set_a_qradiobutton = QRadioButton('Group A')
        self.prefs_set_a_qradiobutton.setToolTip(tip_buttongroup)
        self.prefs_set_b_qradiobutton = QRadioButton('Group B')
        self.prefs_set_b_qradiobutton.setToolTip(tip_buttongroup)
        self.prefs_set_c_qradiobutton = QRadioButton('Group C')
        self.prefs_set_c_qradiobutton.setToolTip(tip_buttongroup)
        self.prefs_set_d_qradiobutton = QRadioButton('Group D')
        self.prefs_set_d_qradiobutton.setToolTip(tip_buttongroup)
        self.prefs_set_e_qradiobutton = QRadioButton('Group E')
        self.prefs_set_e_qradiobutton.setToolTip(tip_buttongroup)

        self.prefs_set_qbuttongroup.addButton(self.prefs_set_a_qradiobutton)
        self.prefs_set_qbuttongroup.addButton(self.prefs_set_b_qradiobutton)
        self.prefs_set_qbuttongroup.addButton(self.prefs_set_c_qradiobutton)
        self.prefs_set_qbuttongroup.addButton(self.prefs_set_d_qradiobutton)
        self.prefs_set_qbuttongroup.addButton(self.prefs_set_e_qradiobutton)

        self.layout_radiobuttons.addWidget(self.prefs_set_a_qradiobutton)
        self.layout_radiobuttons.addSpacing(10)
        self.layout_radiobuttons.addWidget(self.prefs_set_b_qradiobutton)
        self.layout_radiobuttons.addSpacing(10)
        self.layout_radiobuttons.addWidget(self.prefs_set_c_qradiobutton)
        self.layout_radiobuttons.addSpacing(10)
        self.layout_radiobuttons.addWidget(self.prefs_set_d_qradiobutton)
        self.layout_radiobuttons.addSpacing(10)
        self.layout_radiobuttons.addWidget(self.prefs_set_e_qradiobutton)

        #--------------------------------------------------
        self.set_current_group_button()
        self.prefs_set_qbuttongroup.buttonClicked.connect(self.event_radiobutton_clicked)
        #--------------------------------------------------
        #--------------------------------------------------
        self.layout_top.addSpacing(30)

        self.layout_checkboxes = QHBoxLayout()
        self.layout_checkboxes.setAlignment(Qt.AlignCenter)
        self.layout_top.addLayout(self.layout_checkboxes)

        self.use_fts_index_qcheckbox = QCheckBox("Use the FTS Index if Available?")
        self.use_fts_index_qcheckbox.setToolTip("<p style='white-space:wrap'>Use the FTS Index if Available?  A single Job for all books will be executed.  Otherwise, an existing TXT or EPUB format will be searched in an individual Job for each book.\
                                                                                                                       <br><br>Recommendation:  activate the Calibre FTS Index if your Library is quite large and you will be using this plugin to extract metadata repeatedly from most \
                                                                                                                      of your EPUBs.  ")
        self.layout_checkboxes.addWidget(self.use_fts_index_qcheckbox)
        self.use_fts_index_qcheckbox.setChecked(prefs['EPOM_USE_FTS_INDEX'])

        self.layout_checkboxes.addSpacing(25)

        self.merge_tags_qcheckbox = QCheckBox("Merge Tags?")
        self.merge_tags_qcheckbox.setToolTip("<p style='white-space:wrap'>Only pertains to Tag-Like Custom Columns. \
                                                                                                                         'Merge' means to add a new value to the existing values. \
                                                                                                                        Otherwise, all pre-existing values will be first removed.")
        self.layout_checkboxes.addWidget(self.merge_tags_qcheckbox)
        self.merge_tags_qcheckbox.setChecked(prefs['EPOM_MERGE_TAGS'])

        self.layout_checkboxes.addSpacing(25)

        tip = "<p style='white-space:wrap'>Sample with all possible supported Tweaks with examples that can be copied and pasted into a Custom Column Tweak."

        self.extract_tweaks_list_qpushbutton = QPushButton("Tweaks List")
        self.extract_tweaks_list_qpushbutton.clicked.connect(self.tweaks_info_viewer_dialog)
        self.extract_tweaks_list_qpushbutton.setDefault(False)
        self.extract_tweaks_list_qpushbutton.setFont(font)
        self.extract_tweaks_list_qpushbutton.setToolTip(tip)
        self.layout_checkboxes.addWidget(self.extract_tweaks_list_qpushbutton)

        self.layout_checkboxes.addSpacing(25)

        tip = "<p style='white-space:wrap'>Sources of Help on Regular Expressions and several RE Testing Tools.  "

        self.extract_re_help_qpushbutton = QPushButton("RE Help")
        self.extract_re_help_qpushbutton.clicked.connect(self.re_help)
        self.extract_re_help_qpushbutton.setDefault(False)
        self.extract_re_help_qpushbutton.setFont(font)
        self.extract_re_help_qpushbutton.setToolTip(tip)
        self.layout_checkboxes.addWidget(self.extract_re_help_qpushbutton)

        #--------------------------------------------------
        self.layout_top.addSpacing(30)

        self.layout_push_buttons = QHBoxLayout()
        self.layout_push_buttons.setAlignment(Qt.AlignCenter)
        self.layout_top.addLayout(self.layout_push_buttons)

        self.layout_push_buttons.addSpacing(25)

        self.save_customization_qpushbutton = QPushButton("Save Customization", self)
        self.save_customization_qpushbutton.clicked.connect(self.save_customization)
        self.save_customization_qpushbutton.setMaximumWidth(200)
        self.save_customization_qpushbutton.setFont(font)
        self.save_customization_qpushbutton.setDefault(True)
        self.save_customization_qpushbutton.setToolTip("<p style='white-space:wrap'>Save the extraction parameters shown above.<br><br>All Regular Expressions will be compiled (tested) to verify their technical validity to avoid runtime RE compilation errors.")
        self.layout_push_buttons.addWidget(self.save_customization_qpushbutton)

        self.layout_push_buttons.addSpacing(50)

        self.execute_extraction_qpushbutton = QPushButton("Execute Extraction [Selected Books]", self)
        self.execute_extraction_qpushbutton.clicked.connect(self.execute_extraction)
        self.execute_extraction_qpushbutton.setMinimumWidth(500)
        self.execute_extraction_qpushbutton.setFont(font)
        self.execute_extraction_qpushbutton.setToolTip("<p style='white-space:wrap'>Submit the Extraction job for currently selected books.")
        self.layout_push_buttons.addWidget(self.execute_extraction_qpushbutton)

        self.layout_push_buttons.addSpacing(50)

        self.exit_dialog_qpushbutton = QPushButton("Exit",self)
        self.exit_dialog_qpushbutton.setFont(font)
        self.exit_dialog_qpushbutton.setMaximumWidth(200)
        self.exit_dialog_qpushbutton.setToolTip("<p style='white-space:wrap'>Close this window without saving.")
        self.exit_dialog_qpushbutton.clicked.connect(self.exit_dialog)
        self.layout_push_buttons.addWidget(self.exit_dialog_qpushbutton)

        self.layout_top.addSpacing(30)

        #-----------------------------------------------------
        #-----------------------------------------------------
        self.scroll_widget.resize(self.sizeHint())
        #-----------------------------------------------------
        #-----------------------------------------------------
        self.scroll_area_frame.setWidget(self.scroll_widget)    # now that all widgets have been created and assigned to a layout...
        #-----------------------------------------------------
        #-----------------------------------------------------
        self.scroll_area_frame.resize(self.sizeHint())
        #-----------------------------------------------------
        #-----------------------------------------------------
        self.resize_dialog()
    #---------------------------------------------------------------------------------------------------------------------------------------
    def set_current_group_button(self):
        #only called from __init__
        if self.current_group == GROUP_A:
            self.prefs_set_a_qradiobutton.setChecked(True)
        elif self.current_group == GROUP_B:
            self.prefs_set_b_qradiobutton.setChecked(True)
        elif self.current_group == GROUP_C:
            self.prefs_set_c_qradiobutton.setChecked(True)
        elif self.current_group == GROUP_D:
            self.prefs_set_d_qradiobutton.setChecked(True)
        elif self.current_group == GROUP_E:
            self.prefs_set_e_qradiobutton.setChecked(True)
        else:
            self.current_group = GROUP_A
            self.prefs_set_a_qradiobutton.setChecked(True)
    #---------------------------------------------------------------------------------------------------------------------------------------
    def event_radiobutton_clicked(self,event=None,button=None):
        #called by QButtonBox.buttonClicked()

        if self.prefs_set_a_qradiobutton.isChecked():
            self.current_group = GROUP_A
        elif self.prefs_set_b_qradiobutton.isChecked():
            self.current_group = GROUP_B
        elif self.prefs_set_c_qradiobutton.isChecked():
            self.current_group = GROUP_C
        elif self.prefs_set_d_qradiobutton.isChecked():
            self.current_group = GROUP_D
        elif self.prefs_set_e_qradiobutton.isChecked():
            self.current_group = GROUP_E
        else:
            return

        if DEBUG: print("event_radiobutton_clicked: ", str(event), str(button), "self.current_group: ", self.current_group, "self.old_current_group: ", self.old_current_group)

        if self.current_group == self.old_current_group:   #user didn't really change the current group...
            return

        self.old_current_group = self.current_group

        prefs['EPOM_CONFIG_GROUP_CURRENT'] = self.current_group
        current_prefs_list = prefs[self.current_group]
        if len(current_prefs_list) > 40:
            for row in current_prefs_list:
                k,v = row
                if not 'EPOM_CONFIG_GROUP_' in k:
                    if not 'EPOM_DEFAULT' in k:
                        prefs[k] = v
                else:
                    continue
            #END FOR
        else:
            #~ default for each group is an empty set, [], in prefs.defaults[group]...so blank out the normal prefs for the first time loading a group's:
            for k,v in iteritems(prefs):
                if not 'EPOM_CONFIG_GROUP_' in k:
                    if not 'EPOM_DEFAULT' in k:
                        prefs[k] = v
        prefs

        self.exit_dialog(restart=True)
    #---------------------------------------------------------------------------------------------------------------------------------------
    def open_qinputdialog_generic(self,num,tweaks,key):
        qid = QInputDialog()
        title = "Final Text Tweaks"
        qid.setWindowTitle(title)
        s = "Specify the desired Tweaks for this Custom Column's final text"
        qid.setLabelText(s)
        qid.setTextValue(tweaks)
        qid.setOption(QInputDialog.InputDialogOption.UsePlainTextEditForTextInput)
        qid.setInputMethodHints(Qt.ImhMultiLine|Qt.ImhLatinOnly)
        qid.setOkButtonText("Save Changes")
        qid.setFixedSize(800, 800)
        qid.setToolTip("<p style='white-space:wrap'>These are the currently saved Tweaks for the current #CustomColumn (only).  The 'Tweaks Sample' may be used as a source template for this Tweak if needed.")
        qid.show()
        if qid.exec_() == qid.Accepted:
            text = qid.textValue() # After clicking OK, get the input dialog content
            if not text or len(text) < 20:
                text = prefs['EPOM_DEFAULT_FORMAT_TWEAKS']
            elif text != tweaks:
                prefs[key] = text
                prefs
                if DEBUG: print(text)
                self.validate_format_tweaks(text,num)
    #---------------------------------------------------------------------------------------------------------------------------------------
    def people_1_format_tweaks(self):
        tweaks = prefs['EPOM_EXTRACT_PEOPLE_1_FORMAT_TWEAKS']
        self.open_qinputdialog_generic(1,tweaks,'EPOM_EXTRACT_PEOPLE_1_FORMAT_TWEAKS')
    #---------------------------------------------------------------------------------------------------------------------------------------
    def people_2_format_tweaks(self):
        tweaks = prefs['EPOM_EXTRACT_PEOPLE_2_FORMAT_TWEAKS']
        self.open_qinputdialog_generic(2,tweaks,'EPOM_EXTRACT_PEOPLE_2_FORMAT_TWEAKS')
    #---------------------------------------------------------------------------------------------------------------------------------------
    def people_3_format_tweaks(self):
        tweaks = prefs['EPOM_EXTRACT_PEOPLE_3_FORMAT_TWEAKS']
        self.open_qinputdialog_generic(3,tweaks,'EPOM_EXTRACT_PEOPLE_3_FORMAT_TWEAKS')
    #---------------------------------------------------------------------------------------------------------------------------------------
    def people_4_format_tweaks(self):
        tweaks = prefs['EPOM_EXTRACT_PEOPLE_4_FORMAT_TWEAKS']
        self.open_qinputdialog_generic(4,tweaks,'EPOM_EXTRACT_PEOPLE_4_FORMAT_TWEAKS')
    #---------------------------------------------------------------------------------------------------------------------------------------
    def people_5_format_tweaks(self):
        tweaks = prefs['EPOM_EXTRACT_PEOPLE_5_FORMAT_TWEAKS']
        self.open_qinputdialog_generic(5,tweaks,'EPOM_EXTRACT_PEOPLE_5_FORMAT_TWEAKS')
    #---------------------------------------------------------------------------------------------------------------------------------------
    def people_6_format_tweaks(self):
        tweaks = prefs['EPOM_EXTRACT_PEOPLE_6_FORMAT_TWEAKS']
        self.open_qinputdialog_generic(6,tweaks,'EPOM_EXTRACT_PEOPLE_6_FORMAT_TWEAKS')
    #---------------------------------------------------------------------------------------------------------------------------------------
    def save_customization(self):

        #save current state of values...normal prefs...

        prefs['EPOM_EXTRACT_PEOPLE_1_ACTIVE'] = self.extract_people_1_qcheckbox.isChecked()
        prefs['EPOM_EXTRACT_PEOPLE_1_CUSTOM_COLUMN'] = self.extract_people_1_custom_column_qlineedit.text().strip()
        prefs['EPOM_EXTRACT_PEOPLE_1_KEYWORDS'] = self.extract_people_1_keyword_qlineedit.text().strip()
        prefs['EPOM_EXTRACT_PEOPLE_1_IGNORECASE'] = self.extract_people_1_ignorecase_qcheckbox.isChecked()
        prefs['EPOM_EXTRACT_PEOPLE_1_MULTILINE'] = self.extract_people_1_multiline_qcheckbox.isChecked()
        prefs['EPOM_EXTRACT_PEOPLE_1_DOTALL'] = self.extract_people_1_dotall_qcheckbox.isChecked()
        prefs['EPOM_EXTRACT_PEOPLE_1_REGEX'] = self.extract_people_1_regex_qlineedit.text().strip()

        prefs['EPOM_EXTRACT_PEOPLE_2_ACTIVE'] = self.extract_people_2_qcheckbox.isChecked()
        prefs['EPOM_EXTRACT_PEOPLE_2_CUSTOM_COLUMN'] = self.extract_people_2_custom_column_qlineedit.text().strip()
        prefs['EPOM_EXTRACT_PEOPLE_2_KEYWORDS'] = self.extract_people_2_keyword_qlineedit.text().strip()
        prefs['EPOM_EXTRACT_PEOPLE_2_IGNORECASE'] = self.extract_people_2_ignorecase_qcheckbox.isChecked()
        prefs['EPOM_EXTRACT_PEOPLE_2_MULTILINE'] = self.extract_people_2_multiline_qcheckbox.isChecked()
        prefs['EPOM_EXTRACT_PEOPLE_2_DOTALL'] = self.extract_people_2_dotall_qcheckbox.isChecked()
        prefs['EPOM_EXTRACT_PEOPLE_2_REGEX'] = self.extract_people_2_regex_qlineedit.text().strip()

        prefs['EPOM_EXTRACT_PEOPLE_3_ACTIVE'] = self.extract_people_3_qcheckbox.isChecked()
        prefs['EPOM_EXTRACT_PEOPLE_3_CUSTOM_COLUMN'] = self.extract_people_3_custom_column_qlineedit.text().strip()
        prefs['EPOM_EXTRACT_PEOPLE_3_KEYWORDS'] = self.extract_people_3_keyword_qlineedit.text().strip()
        prefs['EPOM_EXTRACT_PEOPLE_3_IGNORECASE'] = self.extract_people_3_ignorecase_qcheckbox.isChecked()
        prefs['EPOM_EXTRACT_PEOPLE_3_MULTILINE'] = self.extract_people_3_multiline_qcheckbox.isChecked()
        prefs['EPOM_EXTRACT_PEOPLE_3_DOTALL'] = self.extract_people_3_dotall_qcheckbox.isChecked()
        prefs['EPOM_EXTRACT_PEOPLE_3_REGEX'] = self.extract_people_3_regex_qlineedit.text().strip()

        prefs['EPOM_EXTRACT_PEOPLE_4_ACTIVE'] = self.extract_people_4_qcheckbox.isChecked()
        prefs['EPOM_EXTRACT_PEOPLE_4_CUSTOM_COLUMN'] = self.extract_people_4_custom_column_qlineedit.text().strip()
        prefs['EPOM_EXTRACT_PEOPLE_4_KEYWORDS'] = self.extract_people_4_keyword_qlineedit.text().strip()
        prefs['EPOM_EXTRACT_PEOPLE_4_IGNORECASE'] = self.extract_people_4_ignorecase_qcheckbox.isChecked()
        prefs['EPOM_EXTRACT_PEOPLE_4_MULTILINE'] = self.extract_people_4_multiline_qcheckbox.isChecked()
        prefs['EPOM_EXTRACT_PEOPLE_4_DOTALL'] = self.extract_people_4_dotall_qcheckbox.isChecked()
        prefs['EPOM_EXTRACT_PEOPLE_4_REGEX'] = self.extract_people_4_regex_qlineedit.text().strip()

        prefs['EPOM_EXTRACT_PEOPLE_5_ACTIVE'] = self.extract_people_5_qcheckbox.isChecked()
        prefs['EPOM_EXTRACT_PEOPLE_5_CUSTOM_COLUMN'] = self.extract_people_5_custom_column_qlineedit.text().strip()
        prefs['EPOM_EXTRACT_PEOPLE_5_KEYWORDS'] = self.extract_people_5_keyword_qlineedit.text().strip()
        prefs['EPOM_EXTRACT_PEOPLE_5_IGNORECASE'] = self.extract_people_5_ignorecase_qcheckbox.isChecked()
        prefs['EPOM_EXTRACT_PEOPLE_5_MULTILINE'] = self.extract_people_5_multiline_qcheckbox.isChecked()
        prefs['EPOM_EXTRACT_PEOPLE_5_DOTALL'] = self.extract_people_5_dotall_qcheckbox.isChecked()
        prefs['EPOM_EXTRACT_PEOPLE_5_REGEX'] = self.extract_people_5_regex_qlineedit.text().strip()

        prefs['EPOM_EXTRACT_PEOPLE_6_ACTIVE'] = self.extract_people_6_qcheckbox.isChecked()
        prefs['EPOM_EXTRACT_PEOPLE_6_CUSTOM_COLUMN'] = self.extract_people_6_custom_column_qlineedit.text()
        prefs['EPOM_EXTRACT_PEOPLE_6_KEYWORDS'] = self.extract_people_6_keyword_qlineedit.text()
        prefs['EPOM_EXTRACT_PEOPLE_6_IGNORECASE'] = self.extract_people_6_ignorecase_qcheckbox.isChecked()
        prefs['EPOM_EXTRACT_PEOPLE_6_MULTILINE'] = self.extract_people_6_multiline_qcheckbox.isChecked()
        prefs['EPOM_EXTRACT_PEOPLE_6_DOTALL'] = self.extract_people_6_dotall_qcheckbox.isChecked()
        prefs['EPOM_EXTRACT_PEOPLE_6_REGEX'] = self.extract_people_6_regex_qlineedit.text()

        prefs['EPOM_USE_FTS_INDEX'] = self.use_fts_index_qcheckbox.isChecked()

        prefs['EPOM_MERGE_TAGS'] = self.merge_tags_qcheckbox.isChecked()

        prefs

        #save current state of values in the current group's prefs list.  example:  prefs['EPOM_CONFIG_GROUP_A'] = groupA

        prefs['EPOM_CONFIG_GROUP_CURRENT'] = self.current_group
        group = []
        for k,v in iteritems(prefs):
            if not 'EPOM_CONFIG_GROUP_' in k:
                if not 'EPOM_DEFAULT' in k:
                    row = k,v
                    group.append(row)
        #END FOR
        prefs[self.current_group] = group
        prefs
        del group

        self.save_current_geometry()

        self.validate_custom_columns()

        self.validate_all_regular_expressions()
    #---------------------------------------------------------------------------------------------------------------------------------------
    def validate_custom_columns(self):

        self.active_cc_list = []
        self.invalid_cc_list = []
        self.can_execute_job = True
        is_in_ccdict = True

        if self.extract_people_1_qcheckbox.isChecked():
            cc = prefs['EPOM_EXTRACT_PEOPLE_1_CUSTOM_COLUMN']
            if not cc in self.custom_columns_dict:
                self.can_execute_job = False
                self.invalid_cc_list.append(cc)
            elif is_in_ccdict:
                datatype = self.custom_columns_dict[cc]['datatype']
                if datatype not in VALID_DATATYPES:
                    self.can_execute_job = False
                    self.invalid_cc_list.append(cc)
                else:
                    keywords = prefs['EPOM_EXTRACT_PEOPLE_1_KEYWORDS']
                    regex = prefs['EPOM_EXTRACT_PEOPLE_1_REGEX']
                    tweaks = prefs['EPOM_EXTRACT_PEOPLE_1_FORMAT_TWEAKS']
                    row = cc,keywords,regex,tweaks
                    self.active_cc_list.append(row)

        if self.extract_people_2_qcheckbox.isChecked():
            cc = prefs['EPOM_EXTRACT_PEOPLE_2_CUSTOM_COLUMN']
            if not cc in self.custom_columns_dict:
                self.can_execute_job = False
                self.invalid_cc_list.append(cc)
            elif is_in_ccdict:
                datatype = self.custom_columns_dict[cc]['datatype']
                if datatype not in VALID_DATATYPES:
                    self.can_execute_job = False
                    self.invalid_cc_list.append(cc)
                else:
                    keywords = prefs['EPOM_EXTRACT_PEOPLE_2_KEYWORDS']
                    regex = prefs['EPOM_EXTRACT_PEOPLE_2_REGEX']
                    tweaks = prefs['EPOM_EXTRACT_PEOPLE_2_FORMAT_TWEAKS']
                    row = cc,keywords,regex,tweaks
                    self.active_cc_list.append(row)

        if self.extract_people_3_qcheckbox.isChecked():
            cc = prefs['EPOM_EXTRACT_PEOPLE_3_CUSTOM_COLUMN']
            if not cc in self.custom_columns_dict:
                self.can_execute_job = False
                self.invalid_cc_list.append(cc)
            elif is_in_ccdict:
                datatype = self.custom_columns_dict[cc]['datatype']
                if datatype not in VALID_DATATYPES:
                    self.can_execute_job = False
                    self.invalid_cc_list.append(cc)
                else:
                    keywords = prefs['EPOM_EXTRACT_PEOPLE_3_KEYWORDS']
                    regex = prefs['EPOM_EXTRACT_PEOPLE_3_REGEX']
                    tweaks = prefs['EPOM_EXTRACT_PEOPLE_3_FORMAT_TWEAKS']
                    row = cc,keywords,regex,tweaks
                    self.active_cc_list.append(row)

        if self.extract_people_4_qcheckbox.isChecked():
            cc = prefs['EPOM_EXTRACT_PEOPLE_4_CUSTOM_COLUMN']
            if not cc in self.custom_columns_dict:
                self.can_execute_job = False
                self.invalid_cc_list.append(cc)
            elif is_in_ccdict:
                datatype = self.custom_columns_dict[cc]['datatype']
                if datatype not in VALID_DATATYPES:
                    self.can_execute_job = False
                    self.invalid_cc_list.append(cc)
                else:
                    keywords = prefs['EPOM_EXTRACT_PEOPLE_4_KEYWORDS']
                    regex = prefs['EPOM_EXTRACT_PEOPLE_4_REGEX']
                    tweaks = prefs['EPOM_EXTRACT_PEOPLE_4_FORMAT_TWEAKS']
                    row = cc,keywords,regex,tweaks
                    self.active_cc_list.append(row)

        if self.extract_people_5_qcheckbox.isChecked():
            cc = prefs['EPOM_EXTRACT_PEOPLE_5_CUSTOM_COLUMN']
            if not cc in self.custom_columns_dict:
                self.can_execute_job = False
                self.invalid_cc_list.append(cc)
            elif is_in_ccdict:
                datatype = self.custom_columns_dict[cc]['datatype']
                if datatype not in VALID_DATATYPES:
                    self.can_execute_job = False
                    self.invalid_cc_list.append(cc)
                else:
                    keywords = prefs['EPOM_EXTRACT_PEOPLE_5_KEYWORDS']
                    regex = prefs['EPOM_EXTRACT_PEOPLE_5_REGEX']
                    tweaks = prefs['EPOM_EXTRACT_PEOPLE_5_FORMAT_TWEAKS']
                    row = cc,keywords,regex,tweaks
                    self.active_cc_list.append(row)

        if self.extract_people_6_qcheckbox.isChecked():
            cc = prefs['EPOM_EXTRACT_PEOPLE_6_CUSTOM_COLUMN']
            if not cc in self.custom_columns_dict:
                self.can_execute_job = False
                self.invalid_cc_list.append(cc)
            elif is_in_ccdict:
                datatype = self.custom_columns_dict[cc]['datatype']
                if datatype not in VALID_DATATYPES:
                    self.can_execute_job = False
                    self.invalid_cc_list.append(cc)
                else:
                    keywords = prefs['EPOM_EXTRACT_PEOPLE_6_KEYWORDS']
                    regex = prefs['EPOM_EXTRACT_PEOPLE_6_REGEX']
                    tweaks = prefs['EPOM_EXTRACT_PEOPLE_6_FORMAT_TWEAKS']
                    row = cc,keywords,regex,tweaks
                    self.active_cc_list.append(row)

        if len(self.active_cc_list) == 0:
            self.can_execute_job = False
    #---------------------------------------------------------------------------------------------------------------------------------------
    def validate_format_tweaks(self,text,num):

        is_valid = True
        n_active = 0

        tweak_list = text.split("\n")

        if len(tweak_list) < 5:
            is_valid = False

        for tweak in tweak_list:
            if not tweak.startswith("#"):
                n_active = +1
        #END FOR

        if n_active == 0:
            is_valid = False

        if not is_valid:
            msg = "Tweak #" + str(num) + " may have an error that may cause it to not be fully implemented, and causing undesired results.  Please read the ToolTips to confirm its validity."
            return info_dialog(self.gui, _("EPOM: Tweak Validation"), _(msg), show=True)
    #---------------------------------------------------------------------------------------------------------------------------------------
    def validate_all_regular_expressions(self):

        self.invalid_regex_list = []
        self.regex_list = []

        self.regex_list.append(prefs['EPOM_EXTRACT_PEOPLE_1_KEYWORDS'])
        self.regex_list.append(prefs['EPOM_EXTRACT_PEOPLE_1_REGEX'])
        self.regex_list.append(prefs['EPOM_EXTRACT_PEOPLE_2_KEYWORDS'])
        self.regex_list.append(prefs['EPOM_EXTRACT_PEOPLE_2_REGEX'])
        self.regex_list.append(prefs['EPOM_EXTRACT_PEOPLE_3_KEYWORDS'])
        self.regex_list.append(prefs['EPOM_EXTRACT_PEOPLE_3_REGEX'])
        self.regex_list.append(prefs['EPOM_EXTRACT_PEOPLE_4_KEYWORDS'])
        self.regex_list.append(prefs['EPOM_EXTRACT_PEOPLE_4_REGEX'])
        self.regex_list.append(prefs['EPOM_EXTRACT_PEOPLE_5_KEYWORDS'])
        self.regex_list.append(prefs['EPOM_EXTRACT_PEOPLE_5_REGEX'])
        self.regex_list.append(prefs['EPOM_EXTRACT_PEOPLE_6_KEYWORDS'])
        self.regex_list.append(prefs['EPOM_EXTRACT_PEOPLE_6_REGEX'])

        for regex in self.regex_list:
            is_valid,msg = self.validate_regular_expression(regex)
            if not is_valid:
                self.can_execute_job = False
                r = regex,msg
                self.invalid_regex_list.append(r)
        #END FOR

        if len(self.invalid_regex_list) > 0:
            s = ""
            for error in self.invalid_regex_list:
                regex,msg = error
                s = s + regex + " " + msg + "\n"
            msg = "Regular Expression Error(s): " + s.strip()
            return error_dialog(self.gui, _('EPOM'),_(msg), show=True)
    #---------------------------------------------------------------------------------------------------------------------------------------
    def validate_regular_expression(self,regex):
        try:
            p = re.compile(regex, re.IGNORECASE|re.MULTILINE)
            is_valid = True
            msg = ""
            del p
        except Exception as e:
            is_valid = False
            msg = str(e)
        return is_valid,msg
    #---------------------------------------------------------------------------------------------------------------------------------------
    def save_current_geometry(self):
        self.save_dialog_geometry()
    #---------------------------------------------------------------------------------------------------------------------------------------
    def execute_extraction(self):
        self.save_customization()
        if self.can_execute_job:
            self.start_extract_people_other_metadata(self.active_cc_list)
            self.exit_dialog()
        elif len(self.active_cc_list) == 0:
            msg = "No Custom Column is Active...Nothing to do..."
            return error_dialog(self.gui, _('EPOM'),_(msg), show=True)
        elif len(self.invalid_cc_list) > 0:
            s = ""
            for cc in self.invalid_cc_list:
                s = s + cc + " "
            msg = "Custom Column Error(s): " + s.strip()
            return error_dialog(self.gui, _('EPOM'),_(msg), show=True)
        elif len(self.invalid_regex_list) > 0:
            s = ""
            for regex in self.invalid_regex_list:
                s = s + str(regex) + " "
            msg = "Regular Expression Error(s): " + s.strip()
            return error_dialog(self.gui, _('EPOM'),_(msg), show=True)
        else:
            msg = "Cannot Execute Transaction.  Please Check All Settings."
            return error_dialog(self.gui, _('EPOM'),_(msg), show=True)
    #---------------------------------------------------------------------------------------------------------------------------------------
    def people_1_export(self):
        self.people_export(1)
    #---------------------------------------------------------------------------------------------------------------------------------------
    def people_2_export(self):
        self.people_export(2)
    #---------------------------------------------------------------------------------------------------------------------------------------
    def people_3_export(self):
        self.people_export(3)
    #---------------------------------------------------------------------------------------------------------------------------------------
    def people_4_export(self):
        self.people_export(4)
    #---------------------------------------------------------------------------------------------------------------------------------------
    def people_5_export(self):
        self.people_export(5)
    #---------------------------------------------------------------------------------------------------------------------------------------
    def people_6_export(self):
        self.people_export(6)
    #---------------------------------------------------------------------------------------------------------------------------------------
    def people_export(self,num):
        self.save_customization()
        text,cc = self.get_export_text(num)
        title = "Custom Column [CC]"
        title = title.replace("[CC]",cc)
        self.export_viewer_dialog = TweaksInfoViewerDialog(self.maingui,prefs,self.icon,title,text)
        self.export_viewer_dialog.tweak_qtextedit.setReadOnly(False)
        self.export_viewer_dialog.show()
        self.export_viewer_dialog.setAttribute(Qt.WA_DeleteOnClose)
    #---------------------------------------------------------------------------------------------------------------------------------------
    def get_export_text(self,num):

        cc = ""
        tmp_list = []
        for k,v in iteritems(prefs):
            if str(num) in k:
                if DEBUG: print(str(num))
                if DEBUG: print(k)
                row = None
                if "CUSTOM_COLUMN" in k:
                    row = 1,"Custom Column:    ",k,v
                    cc = v
                elif "KEYWORDS" in k:
                    row = 2,"Keywords RE:     ",k,v
                elif "IGNORECASE" in k:
                    row = 3,"RE Flag: IGNORECASE:     ",k,v
                elif "MULTILINE" in k:
                    row = 4,"RE Flag: MULTILINE:    ",k,v
                elif "DOTALL" in k:
                    row = 5,"RE Flag: DOTALL:     ",k,v
                elif "REGEX" in k:
                    row = 6,"Results RE:     ",k,v
                elif "FORMAT_TWEAKS" in k:
                    row = 7,"Tweaks:     \n",k,v
                if row is not None:
                    tmp_list.append(row)
        #END FOR

        tmp_list.sort()

        text = ""

        for row in tmp_list:
            n,label,k,v = row
            if k in prefs:
                v = str(v)
                item = label + v
                text = text + item + "\n\n"
        #END FOR

        return text,cc
    #---------------------------------------------------------------------------------------------------------------------------------------
    def tweaks_info_viewer_dialog(self):

        try:
            self.tweaks_info_viewer_dialog.close()
        except:
            pass

        title = "Tweaks Sample List & Information"

        text = prefs.defaults['EPOM_DEFAULT_FORMAT_TWEAKS']
        text = text[2:-2]

        self.tweaks_info_viewer_dialog = TweaksInfoViewerDialog(self.maingui,prefs,self.icon,title,text)
        self.tweaks_info_viewer_dialog.show()
        self.tweaks_info_viewer_dialog.setAttribute(Qt.WA_DeleteOnClose)
    #---------------------------------------------------------------------------------------------------------------------------------------
    #---------------------------------------------------------------------------------------------------------------------------------------
    def re_help(self):
        QTimer.singleShot(0,self.open_browser)
    def open_browser(self):
        import webbrowser
        import time
        from time import sleep
        url="https://docs.python.org/3/library/re.html"
        webbrowser.open_new_tab(url)
        sleep(0.5)
        url = "https://manual.calibre-ebook.com/regexp.html"
        webbrowser.open_new_tab(url)
        sleep(0.25)
        url = "https://regex101.com/"
        webbrowser.open_new_tab(url)
        sleep(0.25)
        url = "https://pythex.org/"
        webbrowser.open_new_tab(url)
        del webbrowser
        del time
        del sleep
    #---------------------------------------------------------------------------------------------------------------------------------------
    def exit_dialog(self,restart=False):
        self.save_current_geometry()
        self.hide()
        if not restart:
            self.close()
        else:
            self.epom_dialog_restart_immediately()
    #---------------------------------------------------------------------------------------------------------------------------------------
    #---------------------------------------------------------------------------------------------------------------------------------------
#END