# -*- coding: utf-8 -*-
__license__   = 'GPL v3'
__copyright__ = '2023 DaltonST'
__my_version__ = "1.0.0"  #New

from calibre.constants import DEBUG
from calibre.utils.config import JSONConfig
from polyglot.builtins import iteritems

prefs = JSONConfig('plugins/Extract People Other Metadata')

from calibre_plugins.extract_people_other_metadata.all_valid_tweaks_template import EPOM_ALL_VALID_TWEAKS
from calibre_plugins.extract_people_other_metadata.empty_blank_tweaks import EPOM_BLANK_TWEAKS

GROUP_A = 'EPOM_CONFIG_GROUP_A'
GROUP_B = 'EPOM_CONFIG_GROUP_B'
GROUP_C = 'EPOM_CONFIG_GROUP_C'
GROUP_D = 'EPOM_CONFIG_GROUP_D'
GROUP_E = 'EPOM_CONFIG_GROUP_E'

prefs.defaults['EPOM_DEFAULT_FORMAT_TWEAKS'] = EPOM_ALL_VALID_TWEAKS
prefs.defaults['EPOM_DEFAULT_BLANK_TWEAKS'] = EPOM_BLANK_TWEAKS

prefs.defaults['EPOM_EXTRACT_PEOPLE_1_ACTIVE'] = False
prefs.defaults['EPOM_EXTRACT_PEOPLE_1_CUSTOM_COLUMN'] = "#translator"
prefs.defaults['EPOM_EXTRACT_PEOPLE_1_KEYWORDS'] = "Translator.+$|Translated by.+$|Traducción.+$|Traductor.+$|Traduccion.+$|Traducido por.+$|Traducción del inglés por.+$"
prefs.defaults['EPOM_EXTRACT_PEOPLE_1_IGNORECASE'] = True
prefs.defaults['EPOM_EXTRACT_PEOPLE_1_MULTILINE'] = True
prefs.defaults['EPOM_EXTRACT_PEOPLE_1_DOTALL'] = False
prefs.defaults['EPOM_EXTRACT_PEOPLE_1_REGEX'] = ""
prefs.defaults['EPOM_EXTRACT_PEOPLE_1_FORMAT_TWEAKS'] = "\n#--------------------------------------------------------------------------\n#--------------------------------------------------------------------------\n#Default values are available for copying from \"Tweaks Example\".\n#This list of Tweaks will be executed in the exact order you decide.\n#Tweaks may be executed multiple times via copy & paste.\n#Activate a Tweak by removing the leading '#'\n#Deactivate a Tweak by adding a leading '#'\n#--------------------------------------------------------------------------\n#--------------------------------------------------------------------------\n#This list of Tweaks will be executed in the exact order shown below.\n#--------------------------------------------------------------------------\n#--------------------------------------------------------------------------\n\n\nMAXIMUM_LENGTH_TO_ACCEPT=300\nCALIBRE_TEMPLATE_LANGUAGE_BUILTIN=capitalize(val)\n\n\n#--------------------------------------------------------------------------\n#--------------------------------------------------------------------------\n#This list of Tweaks will be executed in the exact order shown above.\n#--------------------------------------------------------------------------\n#--------------------------------------------------------------------------\n"

prefs.defaults['EPOM_EXTRACT_PEOPLE_2_ACTIVE'] = False
prefs.defaults['EPOM_EXTRACT_PEOPLE_2_CUSTOM_COLUMN'] = "#editor"
prefs.defaults['EPOM_EXTRACT_PEOPLE_2_KEYWORDS'] = "Editor.+$|Edited By.+$|Reviewed By.+$|Editor original[: ]*.+$"
prefs.defaults['EPOM_EXTRACT_PEOPLE_2_IGNORECASE'] = True
prefs.defaults['EPOM_EXTRACT_PEOPLE_2_MULTILINE'] = True
prefs.defaults['EPOM_EXTRACT_PEOPLE_2_DOTALL'] = False
prefs.defaults['EPOM_EXTRACT_PEOPLE_2_REGEX'] = ""
prefs.defaults['EPOM_EXTRACT_PEOPLE_2_FORMAT_TWEAKS'] = "\n#--------------------------------------------------------------------------\n#--------------------------------------------------------------------------\n#Default values are available for copying from \"Tweaks Example\".\n#This list of Tweaks will be executed in the exact order you decide.\n#Tweaks may be executed multiple times via copy & paste.\n#Activate a Tweak by removing the leading '#'\n#Deactivate a Tweak by adding a leading '#'\n#--------------------------------------------------------------------------\n#--------------------------------------------------------------------------\n#This list of Tweaks will be executed in the exact order shown below.\n#--------------------------------------------------------------------------\n#--------------------------------------------------------------------------\n\n\nMAXIMUM_LENGTH_TO_ACCEPT=300\nCALIBRE_TEMPLATE_LANGUAGE_BUILTIN=capitalize(val)\n\n\n#--------------------------------------------------------------------------\n#--------------------------------------------------------------------------\n#This list of Tweaks will be executed in the exact order shown above.\n#--------------------------------------------------------------------------\n#--------------------------------------------------------------------------\n"

prefs.defaults['EPOM_EXTRACT_PEOPLE_3_ACTIVE'] = False
prefs.defaults['EPOM_EXTRACT_PEOPLE_3_CUSTOM_COLUMN'] = "#bibliography"
prefs.defaults['EPOM_EXTRACT_PEOPLE_3_KEYWORDS'] = "(References|Bibliography).+?(Further reading)"
prefs.defaults['EPOM_EXTRACT_PEOPLE_3_IGNORECASE'] = False
prefs.defaults['EPOM_EXTRACT_PEOPLE_3_MULTILINE'] = False
prefs.defaults['EPOM_EXTRACT_PEOPLE_3_DOTALL'] = True
prefs.defaults['EPOM_EXTRACT_PEOPLE_3_REGEX'] = ""
prefs.defaults['EPOM_EXTRACT_PEOPLE_3_FORMAT_TWEAKS'] = prefs.defaults['EPOM_DEFAULT_BLANK_TWEAKS']

prefs.defaults['EPOM_EXTRACT_PEOPLE_4_ACTIVE'] = False
prefs.defaults['EPOM_EXTRACT_PEOPLE_4_CUSTOM_COLUMN'] = "#table_of_contents"
prefs.defaults['EPOM_EXTRACT_PEOPLE_4_KEYWORDS'] = "ISBN.+?Contents.+?(index|further reading|chapter)"
prefs.defaults['EPOM_EXTRACT_PEOPLE_4_IGNORECASE'] = True
prefs.defaults['EPOM_EXTRACT_PEOPLE_4_MULTILINE'] = False
prefs.defaults['EPOM_EXTRACT_PEOPLE_4_DOTALL'] = True
prefs.defaults['EPOM_EXTRACT_PEOPLE_4_REGEX'] = "Contents.+?(index|further reading|chapter)"
prefs.defaults['EPOM_EXTRACT_PEOPLE_4_FORMAT_TWEAKS'] = prefs.defaults['EPOM_DEFAULT_BLANK_TWEAKS']

prefs.defaults['EPOM_EXTRACT_PEOPLE_5_ACTIVE'] = False
prefs.defaults['EPOM_EXTRACT_PEOPLE_5_CUSTOM_COLUMN'] = "#illustrations"
prefs.defaults['EPOM_EXTRACT_PEOPLE_5_KEYWORDS'] = "Index.+?List of Illustrations.+?(Chapter|Introduction)"
prefs.defaults['EPOM_EXTRACT_PEOPLE_5_IGNORECASE'] = False
prefs.defaults['EPOM_EXTRACT_PEOPLE_5_MULTILINE'] = False
prefs.defaults['EPOM_EXTRACT_PEOPLE_5_DOTALL'] = True
prefs.defaults['EPOM_EXTRACT_PEOPLE_5_REGEX'] = "List of Illustrations.+?(Chapter|Introduction)"
prefs.defaults['EPOM_EXTRACT_PEOPLE_5_FORMAT_TWEAKS'] = prefs.defaults['EPOM_DEFAULT_BLANK_TWEAKS']

prefs.defaults['EPOM_EXTRACT_PEOPLE_6_ACTIVE'] = False
prefs.defaults['EPOM_EXTRACT_PEOPLE_6_CUSTOM_COLUMN'] = "#original_title"
prefs.defaults['EPOM_EXTRACT_PEOPLE_6_KEYWORDS'] = "Original Title.+$|Título original.+$|Titulo original.+$"
prefs.defaults['EPOM_EXTRACT_PEOPLE_6_IGNORECASE'] = True
prefs.defaults['EPOM_EXTRACT_PEOPLE_6_MULTILINE'] = True
prefs.defaults['EPOM_EXTRACT_PEOPLE_6_DOTALL'] = False
prefs.defaults['EPOM_EXTRACT_PEOPLE_6_REGEX'] = ""
prefs.defaults['EPOM_EXTRACT_PEOPLE_6_FORMAT_TWEAKS'] = prefs.defaults['EPOM_DEFAULT_BLANK_TWEAKS']

prefs.defaults['EPOM_USE_FTS_INDEX'] = True
prefs.defaults['EPOM_MERGE_TAGS'] = True
prefs.defaults['DEFAULT_USER_DIRECTORY'] = ""

groupA = []
group_empty = []

for k,v in iteritems(prefs.defaults):
    if not 'EPOM_CONFIG_GROUP_' in k:
        if not 'EPOM_DEFAULT' in k:
            row = k,v
            groupA.append(row)
            if '_ACTIVE' in k:
                v = False
            elif  'CUSTOM_COLUMN' in k:
                v = ""
            elif  'KEYWORDS' in k:
                v = ""
            elif  'IGNORECASE' in k:
                v = False
            elif  'MULTILINE' in k:
                v = False
            elif  'DOTALL' in k:
                v = False
            elif  'REGEX' in k:
                v = ""
            elif  'FORMAT_TWEAKS' in k:
                v = prefs.defaults['EPOM_DEFAULT_BLANK_TWEAKS']
            row = k,v
            group_empty.append(row)
#END FOR
prefs.defaults['EPOM_CONFIG_GROUP_A'] = groupA
prefs.defaults['EPOM_CONFIG_GROUP_C'] = group_empty
prefs.defaults['EPOM_CONFIG_GROUP_D'] = group_empty
prefs.defaults['EPOM_CONFIG_GROUP_E'] = group_empty
del groupA
del group_empty
prefs.defaults['EPOM_CONFIG_GROUP_CURRENT'] = GROUP_A


from calibre_plugins.extract_people_other_metadata.epom_config_group_b import return_epom_config_group_b
rawdict = return_epom_config_group_b()
groupB = []
for k,v in iteritems(rawdict):
    if not 'EPOM_CONFIG_GROUP_' in k:
        if not 'EPOM_DEFAULT' in k:
            row = k,v
            groupB.append(row)
#END FOR
prefs.defaults['EPOM_CONFIG_GROUP_B'] = groupB
del groupB
del rawdict


#~ Library-specific prefs cannot efficiently be used,
#~ since #custom columns should be harmonized across all Libraries,
#~ requiring identical EPOM customization wherever they are used.
#~ EPOM_CONFIG_GROUPs provide a practical and efficient alternative
#~ to using namespaced settings in Table Preferences via gprefs.
#~ PREFS_NAMESPACE = 'ExtractPeopleOtherMetadataPlugin'
#~ PREFS_KEY_SETTINGS = 'settings'


#end of config.py