#! /bin/sh

CC_DEB_PATCH=$1
CC_DIR=$2

if [ $# != 2 ]; then
    echo "undeb_binutils.sh CC_DEB_PATCH CC_DIR"
    exit
fi

if [ ! -e $CC_DEB_PATCH ]; then
    echo "Couldn't find file $CC_DEB_PATCH"
    exit
fi

function my_cat {
	local mycat;
	if echo $1 | grep -q "\.bz2"; then mycat=bzcat; fi
	if echo $1 | grep -q "\.gz"; then mycat=zcat; fi
	if [ x$mycat = x ]; then mycat=cat; fi
	eval "$mycat $*";
}

my_cat $CC_DEB_PATCH | patch -d $CC_DIR -p1

if [ x$ARCH = x ]; then ARCH=arm; fi

for p in $(cd $CC_DIR; echo "
DEB_TARGET_ARCH=$ARCH

include debian/rules.patch

print_patchlist:
	@echo \$(debian_patches);
" | make -s --no-print-directory -f - print_patchlist); do
	sh $CC_DIR/debian/patches/$p.dpatch -patch -d $CC_DIR;
done

