#!/bin/sh
#
# Copyright (C) 2004, 2005 Nokia
# Author: lauri.leukkunen@nokia.com
#
# This script can be used to build a custom toolchain and related things

usage()
{
	cat <<EOF
Usage: $0 [OPTIONS] COMPILER_SRC_DIR COMPILER_NAME ARCH SUB_ARCH [CPU]

Options:
	--toolchain                     - build only toolchain
	--devicetools                   - build only device_tools
	--devicetools=TOOL1,TOOL2,...   - build only selected device_tools
	--archtools                     - build only arch_tools
	--archtools=TOOL1,TOOL2,...     - build only selected arch_tools

Example:
	$0 ../../gcc/glibc arm-linux-gcc-3.3.4-glibc-2.3.2 arm armv3l arm7
EOF
	exit 1
}

toolchain=true
devicetools="devicetools"
archtools="archtools"

if (echo $1 | grep -q ^--); then
	toolchain=false
	devicetools=
	archtools=

	while (echo $1 | grep -q ^--); do
		if [ "$1" = "--toolchain" ]; then
			toolchain=true
		elif (echo "$1" | grep -qE "^--devicetools=?"); then
			devicetools=`echo "$1" | cut -d= -f2- | sed "s/^--//"`
		elif (echo "$1" | grep -qE "^--archtools=?"); then
			archtools=`echo "$1" | cut -d= -f2- | sed "s/^--//"`
		else
			usage
		fi

		shift
	done
fi

compiler_src_dir=$1
compiler_name=$2
arch=$3
sub_arch=$4
cpu=$5

if [ -z $arch ] || [ -z $sub_arch ]; then
	usage
fi

(set -e;

if $toolchain; then
	echo -e "\n\t*** Building $compiler_name toolchain ***\n"

	make build-toolchain \
		COMPILERGAR=$compiler_src_dir \
		ARCH=$arch \
		SUB_ARCH=$sub_arch \
		CPU=$cpu \
		COMPILERNAME=$compiler_name
fi

NAME=/scratchbox/compilers/$compiler_name/compiler-name
TARGETNAME=`cut -d: -f1 $NAME`
GCCDIR=`cut -d: -f2 $NAME`/bin
GCCPREFIX=`cut -d: -f3 $NAME`-`cut -d: -f4 $NAME`-
CC=$GCCDIR/$GCCPREFIX""gcc
CXX=$GCCDIR/$GCCPREFIX""g++

if [ x"$devicetools" != x ]; then
	echo -e "\n\t*** Building $devicetools for $compiler_name ***\n"

	make build-`echo $devicetools | sed 's/,/ build-/g'` \
		TARGETNAME=$TARGETNAME \
		GCCDIR=$GCCDIR \
		GCCPREFIX=$GCCPREFIX \
		CC=$CC \
		CXX=$CXX
fi

if [ x"$archtools" != x ]; then
	echo -e "\n\t*** Building $archtools for $compiler_name ***\n"

	make build-`echo $archtools | sed 's/,/ build-/g'` \
		TARGETNAME=$TARGETNAME \
		GCCDIR=$GCCDIR \
		GCCPREFIX=$GCCPREFIX \
		CC=$CC \
		CXX=$CXX
fi

)
