#!/bin/bash -ex

rm -f $HEADERS_SOURCE/asm-arm/arch
rm -f $HEADERS_SOURCE/asm-arm/proc
ln -s arch-sa1100 $HEADERS_SOURCE/asm-arm/arch
touch $HEADERS_SOURCE/asm-arm/dummy
ln -s dummy $HEADERS_SOURCE/asm-arm/proc

test -d $HEADERS_SOURCE/asm-arm/proc-armo && ln -s proc-armo $HEADERS_SOURCE/asm-arm/proc
test -d $HEADERS_SOURCE/asm-generic || mkdir -p $HEADERS_SOURCE/asm-generic

touch $HEADERS_SOURCE/linux/autoconf.h

echo '#define UTS_RELEASE "'$KERNEL_SOURCE_VERSION'"' > $HEADERS_SOURCE/linux/version.h
echo '#define KERNEL_VERSION(a,b,c) (((a) << 16) + ((b) << 8) + (c))' >> $HEADERS_SOURCE/linux/version.h
echo '#define LINUX_VERSION_CODE KERNEL_VERSION('"`echo $KERNEL_SOURCE_VERSION | tr . ,`"')' >> $HEADERS_SOURCE/linux/version.h

sed -i -e 's,^.*TARGET_ARM.*,TARGET_ARM=y,g' $WORKSRC/.config
sed -i -e 's,^TARGET_ARCH.*,TARGET_ARCH=\"'$TARGET_ARCH'\",g' $WORKSRC/.config
sed -i -e 's,^KERNEL_SOURCE=.*,KERNEL_SOURCE=\"'$HEADERS_SOURCE'\",g' $WORKSRC/.config
sed -i -e 's,^RUNTIME_PREFIX=.*,RUNTIME_PREFIX=\"/\",g' $WORKSRC/.config
sed -i -e 's,^DEVEL_PREFIX=.*,DEVEL_PREFIX=\"/usr/\",g' $WORKSRC/.config
sed -i -e 's,^SHARED_LIB_LOADER_PREFIX=.*,SHARED_LIB_LOADER_PREFIX=\"/lib\",g' $WORKSRC/.config
sed -i -e 's,.*UCLIBC_HAS_WCHAR.*,UCLIBC_HAS_WCHAR=y\nUCLIBC_HAS_LOCALE=y,g' $WORKSRC/.config
if [ "${USE_SOFTFLOAT}" = "yes" ]; then
	sed -i -e 's,^[[:space:]#]*HAS_FPU.*$,HAS_FPU=y,g' $WORKSRC/.config
	sed -i -e 's,^[[:space:]#]*UCLIBC_HAS_FLOATS.*$,UCLIBC_HAS_FLOATS=y,g' $WORKSRC/.config
	sed -i -e 's,^[[:space:]#]*UCLIBC_HAS_SOFT_FLOAT.*$,UCLIBC_HAS_SOFT_FLOAT=n,g' $WORKSRC/.config
else
	sed -i -e 's,^[[:space:]#]*HAS_FPU.*$,HAS_FPU=y,g' $WORKSRC/.config
	sed -i -e 's,^[[:space:]#]*UCLIBC_HAS_FLOATS.*$,UCLIBC_HAS_FLOATS=y,g' $WORKSRC/.config
	sed -i -e 's,^[[:space:]#]*UCLIBC_HAS_SOFT_FLOAT.*$,UCLIBC_HAS_SOFT_FLOAT=y,g' $WORKSRC/.config
fi

