#! /bin/sh

GLIBC_DEB_PATCH=$1
GLIBC_DEB_DIR=$2.ds1
GLIBC_DIR=$2
GLIBC_NAME=`basename $2`

if [ $# != 2 ]; then
    echo "undeb_glibc.sh GLIBC_DEB_PATCH GLIBC_DIR"
    exit
fi
if [ ! -e $GLIBC_DEB_PATCH ]; then
    echo "Couldn't find file $GLIBC_DEB_PATCH"
    exit
fi


function my_cat {
	local mycat;
	if echo $1 | grep -q "\.bz2"; then mycat=bzcat; fi
	if echo $1 | grep -q "\.gz"; then mycat=zcat; fi
	if [ x$mycat = x ]; then mycat=cat; fi
	eval "$mycat $*";
}

my_cat $GLIBC_DEB_PATCH | patch -d $GLIBC_DEB_DIR -p1

make -C $GLIBC_DEB_DIR -f debian/rules patch

rm -rf $GLIBC_DIR
mv $GLIBC_DEB_DIR/build-tree/$GLIBC_NAME $GLIBC_DIR
