#! /bin/sh


BINUTILS_DEB_PATCH=$1
BINUTILS_DIR=$2

if [ $# != 2 ]; then
   echo "undeb_binutils.sh BINUTILS_DEB_PATCH BINUTILS_DIR"
   exit
fi

if [ ! -e $BINUTILS_DEB_PATCH ]; then
   echo "Couldn't find file $BINUTILS_DEB_PATCH"
   exit
fi

function my_cat {
	local mycat;
        
	if echo $1 | grep -q "\.bz2"; then mycat=bzcat; fi
	if echo $1 | grep -q "\.gz"; then mycat=zcat; fi
	if [ x$mycat = x ]; then mycat=cat; fi
	eval "$mycat $*";
}

my_cat $BINUTILS_DEB_PATCH | patch -d $BINUTILS_DIR -p1

make -C $BINUTILS_DIR -f debian/rules patch
