<?php

$ddl = <<<EOD
CREATE TABLE languages (
  id INTEGER PRIMARY KEY,
  lang_code TEXT NOT NULL COLLATE NOCASE,
  lang_fb2 TEXT,
  UNIQUE(lang_code)
);

CREATE INDEX languages_idx ON languages (lang_code COLLATE NOCASE);

insert into languages values
            (1, "rus", "RU"),
            (2, "bel", "BE"),
            (3, "ukr", "UK"),
            (4, "eng", "EN"),
            (5, "bul", "BG"),
            (6, "deu", "DE"),
            (7, "pol", "PL"),
            (8, "esp", "ES"),
            (9, "ces", "CS"),
            (10, "swe", "SV"),
            (11, "ita", "IT"),
            (12, "fra", "FR"),
            (13, "zha", "ZH"),
            (14, "epo", "EO"),
            (15, "lat", "LA"),
            (16, "isl", "IS"),
            (17, "jpn", "JA"),
            (18, "por", "PT"),
            (19, "dan", "DA"),
            (20, "slk", "SK"),
            (21, "aze", "AZ"),
            (22, "hun", "HU"),
            (23, "ron", "RO"),
            (24, "srp", "SR"),
            (25, "kaz", "KK"),
            (26, "uzb", "UZ"),
            (27, "hrv", "HR"),
            (28, "chu", "CU"),
            (29, "ina", "IA"),
            (30, "lit", "LT"),
            (31, "tur", "TR"),
            (32, "vie", "VI"),
            (33, "fin", "FI"),
            (34, "lav", "LV"),
            (35, "nld", "NL"),
            (36, "cat", "CA"),
            (37, "est", "ET"),
            (38, "nor", "NO"),
            (39, "tgk", "TG"),
            (40, "ell", "EL"),
            (41, "chv", "CV"),
            (42, "tat", "TT"),
            (43, "ind", "ID"),
            (44, "kor", "KO"),
            (45, "kat", "KA"),
            (46, "glg", "GA"),
            (47, "kal", "KL");

CREATE TABLE series ( 
  id   INTEGER PRIMARY KEY,
  name TEXT NOT NULL COLLATE NOCASE,
  sort TEXT COLLATE NOCASE,
  UNIQUE (name)
);

CREATE INDEX series_idx ON series (sort COLLATE NOCASE);

CREATE TABLE tags ( 
  id   INTEGER PRIMARY KEY,
  name TEXT NOT NULL COLLATE NOCASE,
  fb2code TEXT COLLATE NOCASE,
  UNIQUE (fb2code)
);

CREATE INDEX tags_idx ON tags (name COLLATE NOCASE);

CREATE TABLE publishers ( 
  id INTEGER PRIMARY KEY,
  name TEXT NOT NULL COLLATE NOCASE,
  sort TEXT COLLATE NOCASE,
  UNIQUE(name)
);

CREATE INDEX publishers_idx ON publishers (name COLLATE NOCASE);

CREATE TABLE ratings ( 
  id INTEGER PRIMARY KEY,
  rating INTEGER CHECK(rating > -1 AND rating < 11),
  UNIQUE (rating)
);

CREATE TABLE authors ( 
  id   INTEGER PRIMARY KEY,
  name TEXT NOT NULL COLLATE NOCASE,
  sort TEXT COLLATE NOCASE,
  link TEXT NOT NULL DEFAULT "",
  UNIQUE(name)
);

CREATE INDEX authors_idx ON authors (sort COLLATE NOCASE);

CREATE TABLE books ( 
  id        INTEGER PRIMARY KEY AUTOINCREMENT,
  title     TEXT NOT NULL DEFAULT 'Unknown' COLLATE NOCASE,
  sort      TEXT COLLATE NOCASE,
  timestamp TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
  pubdate   TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
  series_index REAL NOT NULL DEFAULT 1.0,
  author_sort TEXT COLLATE NOCASE,
  isbn TEXT DEFAULT "" COLLATE NOCASE,
  lccn TEXT DEFAULT "" COLLATE NOCASE,
  path TEXT NOT NULL DEFAULT "",
  flags INTEGER NOT NULL DEFAULT 1,
  uuid TEXT,
  has_cover BOOL DEFAULT 0,
  last_modified TIMESTAMP NOT NULL DEFAULT "2000-01-01 00:00:00+00:00"
);

CREATE INDEX books_idx ON books (sort COLLATE NOCASE);

CREATE TABLE data ( 
  id     INTEGER PRIMARY KEY,
  book   INTEGER NOT NULL,
  format TEXT NOT NULL COLLATE NOCASE,
  uncompressed_size INTEGER NOT NULL,
  name TEXT NOT NULL,
  UNIQUE(book, format)
);

CREATE INDEX data_idx ON data (book);

CREATE INDEX formats_idx ON data (format);

CREATE TABLE books_authors_link ( 
  id INTEGER PRIMARY KEY,
  book INTEGER NOT NULL,
  author INTEGER NOT NULL,
  UNIQUE(book, author)
);

CREATE INDEX books_authors_link_aidx ON books_authors_link (author);

CREATE INDEX books_authors_link_bidx ON books_authors_link (book);

CREATE TABLE books_languages_link ( 
  id INTEGER PRIMARY KEY,
  book INTEGER NOT NULL,
  lang_code INTEGER NOT NULL,
  item_order INTEGER NOT NULL DEFAULT 0,
  UNIQUE(book, lang_code)
);

CREATE INDEX books_languages_link_aidx ON books_languages_link (lang_code);

CREATE INDEX books_languages_link_bidx ON books_languages_link (book);

CREATE TABLE books_publishers_link ( 
  id INTEGER PRIMARY KEY,
  book INTEGER NOT NULL,
  publisher INTEGER NOT NULL,
  UNIQUE(book)
);

CREATE INDEX books_publishers_link_aidx ON books_publishers_link (publisher);

CREATE INDEX books_publishers_link_bidx ON books_publishers_link (book);

CREATE TABLE books_ratings_link ( 
  id INTEGER PRIMARY KEY,
  book INTEGER NOT NULL,
  rating INTEGER NOT NULL,
  UNIQUE(book, rating)
);

CREATE INDEX books_ratings_link_aidx ON books_ratings_link (rating);

CREATE INDEX books_ratings_link_bidx ON books_ratings_link (book);

CREATE TABLE books_series_link ( 
  id INTEGER PRIMARY KEY,
  book INTEGER NOT NULL,
  series INTEGER NOT NULL,
  UNIQUE(book)
);

CREATE INDEX books_series_link_aidx ON books_series_link (series);

CREATE INDEX books_series_link_bidx ON books_series_link (book);

CREATE TABLE books_tags_link ( 
  id INTEGER PRIMARY KEY,
  book INTEGER NOT NULL,
  tag INTEGER NOT NULL,
  UNIQUE(book, tag)
);

CREATE INDEX books_tags_link_aidx ON books_tags_link (tag);

CREATE INDEX books_tags_link_bidx ON books_tags_link (book);

CREATE TABLE comments ( 
  id INTEGER PRIMARY KEY,
  book INTEGER NOT NULL,
  text TEXT NOT NULL COLLATE NOCASE,
  UNIQUE(book)
);

CREATE INDEX comments_idx ON comments (book);

CREATE TABLE custom_columns (
  id       INTEGER PRIMARY KEY AUTOINCREMENT,
  label    TEXT NOT NULL,
  name     TEXT NOT NULL,
  datatype TEXT NOT NULL,
  mark_for_delete   BOOL DEFAULT 0 NOT NULL,
  editable BOOL DEFAULT 1 NOT NULL,
  display  TEXT DEFAULT "{}" NOT NULL,
  is_multiple BOOL DEFAULT 0 NOT NULL,
  normalized BOOL NOT NULL,
  UNIQUE(label)
);

CREATE INDEX custom_columns_idx ON custom_columns (label);

EOD;

define( 'DB_DDL', $ddl);

?>