<?php 
  require_once ("../base.php");
  require_once ("create_db_conf.php");
  global $config;
   if ( !check_admin(FALSE) ) 
    die("<h2>Эта программа  требует авторизации как 'admin' и ее можно запускать только из той же сети, в которой находится сервер</h2>");

    put_log((Base::useAbsolutePath() ? "Use Absolute Path" : "Use NOT Absolute Path")."\n".
            "inpx_file='$inpx_file'\n".
            "genres_file='$genres_file'\n".
            "db_name='$db_name'\n".
            "db_dir='$db_dir'\n".
            "tmp_dir='$tmp_dir'\n".
            "skip_deleted='$skip_deleted'\n".
            "lang_load='$lang_load'\n");
?>
<!DOCTYPE html>
<html xmlns="http://www.w3.org/1999/xhtml">
<head>
  <TITLE>Загрузка INPX в БД коллекции</TITLE>
  <META http-equiv="Content-Type" content="text/html; charset=UTF-8">
  <link rel="stylesheet" type="text/css" href="../templates/default/styles/style-default.css" media="screen" />
  <link rel="stylesheet" type="text/css" href="../templates/default/styles/style-base.css" media="screen" />
  <link rel="stylesheet" type="text/css" href="../templates/default/styles/font-awesome.css" media="screen" />
  
  <script type="text/javascript" src="../vendor/bower-asset/jquery/dist/jquery.min.js"></script>
  <script type="text/javascript">
      var errorState = false;
      var stepCnt = 0;
      var fncArray = new Array('clear_cache', 'create_db', 'load_genres', 'extract_inp');  //, 'load_inp', 'clear_tmp');
      var msgArr = new Array('очистка файлов кеша', 'создание БД', 'загрузка списка жанров', 'распаковка архива INPX');  //, 'Загрузка INP-файлов', 'Удаление временных файлов');
      var aInp = new Array;
      var str_out = new String;

      function clearErrorState()
      { $("#errInfo").html("&nbsp;"); 
        errorState = false; 
      }

      function setError(txt)
      { $("#errInfo").html(txt); 
        errorState = true; 
      }


      // Рекурсивный вызов вместо цикла - т.к. getJSON выполняется асинхронно, функция завершается не дождавшись выполнения getJSON
      function DoFunc( step )
      {
          $("#msg").html('<p>Идет '+msgArr[step]+'</p>');
          $.getJSON('create_metadatadb.php', $("#f_query").serialize()+'&func='+fncArray[step], function(data){
            if (data.err_state > 0) {
              setError(data.msg); 
              return false;
            } else {
              setError(data.msg);
              if ( fncArray.length > step+1 ) {
                DoFunc( step + 1 );
              } else {
                aInp = data.inp_list;
                DoLoadInp(0);
              }
              return true;
            }
          });
      }

      function DoLoadInp( num_file )
      {
          $("#msg").html('<p>Загрузка '+aInp[num_file] + '. Файл ' + (num_file+1) + ' из ' + aInp.length +'</p>');
          $.getJSON('create_metadatadb.php', $("#f_query").serialize()+'&func=load_inp&inp_name='+aInp[num_file], function(data){
            if (data.err_state > 0) {
              setError(data.msg); 
              return false;
            } else {
              setError(data.msg);
              if ( aInp.length  > (num_file+1) ) {
                DoLoadInp( num_file + 1 );
              } else {
                DoClearTmp();
              }
              return true;
            }
          });
      }

      function DoClearTmp( )
      {
          $("#msg").html('<p>Удаляем временные файлы</p>');
          $.getJSON('create_metadatadb.php', $("#f_query").serialize()+'&func=clear_tmp', function(data){
              setError(data.msg);
              $("#msg").html('<p>&nbsp;</p>');
              setError("Загрузка закончена, для возврата в COPS нажмите <Домик> в левом верхнем углу.");
              $("#exp_begin").val( 'Перейти в библиотеку' );
              $("#exp_begin").attr("disabled", false);
              return true;
          });
      }


      function onExpBeginClick(){
        if (  $("#exp_begin").val() == 'Перейти в библиотеку' ) {
          document.location.href = "../index.php";
          return true;
        }

        if ( !($("#proc_accept").prop( "checked" )) )   { 
          setError("Вы не подтвердили удаление текущей базы!"); $("#proc_accept").focus();
        } else {
          clearErrorState();
          $("#exp_begin").attr("disabled", true);
          DoFunc(0);
        }
        return false;
      }
      
      $(document).ready(function() {
         $("#exp_begin").val( 'Начать' );
      });

  	
  </script>
</head>
<body>


<div class="container">    
  <header>
    <a class="headleft" href="../index.php">
        <div title="Домой" class="hicon hicon64"><i class="icon-home"></i></div>
    </a>
    <div class="headcenter">
        <h1>Загрузка INPX</h1>
    </div>
  </header>
  <form name="f_query" id="f_query">
  <section>
    <article class="frontpage">
            <h2>Загрузка файлов описания коллекций INPX в БД формата Calibre.</h2>
            <h4>Убедитесь, что настройки ниже указывают на копию БД, а не реальную Calibre.</h4> 
    </article>
    <article class="frontpage">
            <h2>Имя БД</h2>
            <h4><input name="myhomelib_database" type="text" id="myhomelib_database" size="50" maxlength="150" value="<?=$db_name?>" readonly></h4> 
    </article>
    <article class="frontpage">
            <h2>Файл коллекции <?=(is_readable($inpx_file)?'cуществует, доступен':'<span id="errInfo" style="color:red">отсутствует, загрузка невозможна!</span>')?></h2>
            <h4><input name="inpx_file" type="text" id="inpx_file" size="50" maxlength="150" value="<?=$inpx_file?>" readonly></h4> 
    </article>
    <article class="frontpage">
            <h2>Файл для загрузки списка жанров <?=(is_readable($genres_file)?'cуществует, доступен':'<span id="errInfo" style="color:red">отсутствует, загрузка невозможна!</span>')?></h2>
            <h4><input name="genres_file" type="text" id="genres_file" size="50" maxlength="150" value="<?=$genres_file?>" readonly></h4> 
    </article>
    <article class="frontpage">
            <h2>Я понимаю, что текущая база (если есть) будет уничтожена</h2>
            <h4><input type="checkbox" id="proc_accept" name="proc_accept" /></h4> 
    </article>
<?php if (is_readable($genres_file) && is_readable($inpx_file)) : ?>
    <article class="frontpage">
        <div align="center">
              <input type="button" value="Начать" id="exp_begin" name="exp_begin" onclick="onExpBeginClick()">
        </div>
        <div class="frontpage" align="center">
            <h2><span id="errInfo" style="color:red">&nbsp;</span></h2>
            <h4><div id="msg">&nbsp;</div></h4> 
        </div>
    </article>
<?php endif; ?>
  </section>
  </form>
  <footer>
  </footer>
</div>

</body>
</html>
