<?php
/**
 * COPS (Calibre OPDS PHP Server) class file
 *
 * @license    GPL 2 (http://www.gnu.org/licenses/gpl.html)
 * @author     Sébastien Lucas <sebastien@slucas.fr>
 */

//
//Override parent class function 
//
class ZipBook extends Book
{
    const SQL_BOOKS_RECENT = 'select books.id as id, books.title as title, (select text from comments where comments.book = books.id) as comment, '.
        'path, timestamp, pubdate, series_index, uuid, has_cover, '.
        '(SELECT ratings.rating FROM ratings, books_ratings_link where books_ratings_link.rating = ratings.id and books_ratings_link.book = books.id) as rating '.
        'from books, books_authors_link, authors '.
        'where books_authors_link.book = books.id '.
        '  and books_authors_link.author = authors.id '.
        '  and authors.link = "Y" '.
        'order by pubdate desc limit ';

    private $filename=NULL;
    private $zipname=NULL;
    private $lTrueCalibreLib;
    private $lUseConverter;

    public function __construct($line, $ExtractFile = FALSE) {
      global $config;
      
        parent::__construct($line);

        $this->lTrueCalibreLib = (substr($this->relativePath, -4) !== '.zip');
        $this->lUseConverter = ($this->lTrueCalibreLib ? FALSE : $config['cops_convert_to_types']);

        if ($this->lTrueCalibreLib) return; 
        
        $this->getDatas();

        //$line->relativePath - имя архива
        //$this->path - директория, куда будет распакован файл
        $this->zipname = $line->path;
        $this->relativePath = substr($this->relativePath, 0, -4) . '/' .
                              $this->datas[0]->name . '/';
        
        $this->path = Base::getDbDirectory() . $this->relativePath;
        $this->filename =  $this->datas[0]->name . '.' . $this->datas[0]->realFormat;
        
        if ( $ExtractFile ) $this->getFB2fromzip($ExtractFile);
        if ( file_exists($this->getCacheDir().'comment.txt') ) 
            $this->comment = file_get_contents($this->getCacheDir().'comment.txt');
        if ( file_exists($this->getCacheDir().'cover.jpg') ) $this->hasCover = 1;
    }

    public static function getBookById($bookId, $extractFromZip=FALSE) {
        $result = parent::getDb()->prepare('select ' . self::BOOK_COLUMNS . '
from books ' . self::SQL_BOOKS_LEFT_JOIN . '
where books.id = ?');
        $result->execute(array($bookId));
        while ($post = $result->fetchObject())
        {
            $book = new ZipBook($post, $extractFromZip);
            return $book;
        }
        return NULL;
    }

    public static function getBookByDataId($dataId, $extractFromZip=FALSE) {
        $result = parent::getDb()->prepare('select ' . self::BOOK_COLUMNS . ', data.name, data.format, data.uncompressed_size as size
from data, books ' . self::SQL_BOOKS_LEFT_JOIN . '
where data.book = books.id and data.id = ?');
        $result->execute(array($dataId));
        while ($post = $result->fetchObject())
        {
            $book = new ZipBook($post, $extractFromZip);
            $data = new Data($post, $book);
            $data->id = $dataId;
            $book->datas = array($data);
            return $book;
        }
        return NULL;
    }

    public static function getEntryArray($query, $params, $n, $database = NULL, $numberPerPage = NULL) {
        /* @var $totalNumber integer */
        /* @var $result PDOStatement */
        global $config;
        list($totalNumber, $result) = parent::executeQuery($query, self::BOOK_COLUMNS, self::getFilterString(), $params, $n, $database, $numberPerPage);

        $entryArray = array();
        while ($post = $result->fetchObject())
        {
            $book = new ZipBook($post, $config['get_metadata_from_fb2']);
            array_push($entryArray, $book->getEntry());
        }
        return array($entryArray, $totalNumber);
    }

    // Мои переделки - листать не больше 4 страниц, если результат больше - список по начальным буквам, кроме вызова из поиска
    public static function getBooksByStartingLetter($letter, $n, $database = NULL, $numberPerPage = NULL) {
        $PageLimit = 4 * ( (getCurrentOption ("max_item_per_page") === -1) ? 100 : getCurrentOption ("max_item_per_page") );
        $pCnt = self::getBooksCountByFirstLetter($letter);
        $callFromSearch = (substr($letter, 0, 1) === '%');
        if ( ( $pCnt > $PageLimit )  && is_null($numberPerPage) && !$callFromSearch) {
          $ent = self::getAllBooks($letter);
          return array( $ent, count($ent)); 
        }
        else
          return self::getEntryArray (self::SQL_BOOKS_BY_FIRST_LETTER, array ($letter . "%"), $n, $database, $numberPerPage);
    }

    // Была группировка только по первой букве, сделал возможность несколько первых букв 
    public static function getAllBooks($letter='') {
        $chrCnt = mb_strlen($letter, "UTF-8")+1; 
        $fltr = "sort like '".$letter."%' "; 
        $flds = "substr(sort, 1, $chrCnt) as title, count(*) as count";
        $que = "select {0} from books where {1} group by substr(sort, 1, $chrCnt) order by substr(sort, 1, $chrCnt)";      
        
        list (, $result) = parent::executeQuery ($que, $flds, $fltr . self::getFilterString(), array (), -1);

        $entryArray = array();
        while ($post = $result->fetchObject ())
        {
            array_push ($entryArray, new Entry ($post->title, Book::getEntryIdByLetter ($post->title),
                str_format (localize("bookword", $post->count), $post->count), "text",
                array ( new LinkNavigation ("?page=".parent::PAGE_ALL_BOOKS_LETTER."&id=". rawurlencode ($post->title))), "", $post->count));
        }
        return $entryArray;
    }

    public function getPubDate () {
        if ($this->lTrueCalibreLib) return parent::getPubDate();
        return (string) $this->pubdate;
    }

    public static function getBooksByAuthor($authorId, $n) {
        return self::getEntryArray(self::SQL_BOOKS_BY_AUTHOR, array($authorId), $n);
    }

    public static function getBooksByRating($ratingId, $n) {
        return self::getEntryArray(self::SQL_BOOKS_BY_RATING, array($ratingId), $n);
    }

    public static function getBooksByPublisher($publisherId, $n) {
        return self::getEntryArray(self::SQL_BOOKS_BY_PUBLISHER, array($publisherId), $n);
    }

    public static function getBooksBySeries($serieId, $n) {
        return self::getEntryArray(self::SQL_BOOKS_BY_SERIE, array($serieId), $n);
    }

    public static function getBooksByTag($tagId, $n) {
        return self::getEntryArray(self::SQL_BOOKS_BY_TAG, array($tagId), $n);
    }

    public static function getBooksByLanguage($languageId, $n) {
        return self::getEntryArray(self::SQL_BOOKS_BY_LANGUAGE, array($languageId), $n);
    }

    public static function getAllRecentBooks() {
        global $config;
        list ($entryArray, ) = self::getEntryArray(self::SQL_BOOKS_RECENT . $config['cops_recentbooks_limit'], array(), -1);
        return $entryArray;
    }

    /**
     * @return Data[]
     */
    public function getDatas()
    {
        if (is_null($this->datas)) {
            $this->datas = Data::getDataByBook($this);
            if (!$this->lTrueCalibreLib && $this->lUseConverter) {
                $aTypes = explode(',', getCurrentOption ('convert_to_types'));
                foreach($aTypes as $type) {
                    $data = clone $this->datas[0];
                    $data->format = $type;
                    $data->extension = $type;
                    $this->datas[] = $data; 
                }
            }
        }
        return $this->datas;
    }


/**
* New function
* 
* 
*/
/* 
    function __destruct() {
      global $config;
      if (!$config['use_fb2_disk_cache'] && file_exists($this->getCacheDir() . $this->filename)) {
        unlink($this->getCacheDir() . '*');
        rmdir($this->getCacheDir());
      }
    }
*/

    public function isTrueCalibreLib() {
        return $this->lTrueCalibreLib;
    }

    public function UseConverter() {
        return $this->lUseConverter;
    }

     public static function getBooksCountByFirstLetter($letter='', $database=NULL) {
        return parent::executeQuerySingle ("select count(*) as count from books where upper(sort) like '".$letter."%' ", $database);  //fork upper
    }

    public function getExternalFilename($lURL_Encode=FALSE, $ext=FALSE) {
      $filename = $this->title. '.' . ($ext !== FALSE ? $ext : $this->datas[0]->realFormat);
      if (getCurrentOption('use_translit')) {
          //$filename = mb_cyr2trans($this->title);
          $filename = normalizeUtf8String($filename);
          if ($filename == '') $filename = (string) $this->id;
      } elseif($lURL_Encode) {
          $filename = rawurlencode($filename);
      }
      return $filename;
    }
    
 /**
 * Вытаскиваем книгу из библиотеки 
 */
    public function getFB2fromzip($ExtractMetadata=FALSE) {
        global $config;

        if ($this->lTrueCalibreLib) return TRUE;

        $fullzipname = $config['zipbook_directory'] . $this->zipname;
        $filename = $this->filename;
        $cache_name = $this->getCacheDir(TRUE) . $filename;  
      
        //Есть ли книга в кеше
        if (file_exists($cache_name)) {  
            return TRUE;        //($cache_name);
        }
      
        //книга в zip и zip существует
        if ( (strcasecmp('zip', pathinfo($fullzipname, PATHINFO_EXTENSION )) === 0) && file_exists($fullzipname)) {  
            if (version_compare(PHP_VERSION,  '7.4.0', '<')) {
                if ($config['shell_exec_cmd']) {
                    $cmd = $config['shell_exec_cmd'] . ' ' . escapeshellarg($fullzipname). ' ' . 
                                                            escapeshellarg($filename);
                    $cmd .= ' > ' . escapeshellarg($cache_name);
                    shell_exec( $cmd );
                    $buffer = file_get_contents($this->getCacheDir() . $this->filename);
                    if ($ExtractMetadata && ($this->datas[0]->realFormat == 'fb2')) $this->extractMetaData($buffer);
                } else {
                    put_log("Не задана команда разархивации 'shell_exec_cmd' в файле конфигурации");
                    $this->error(3); 
                }
            } else {
                $cmd = 'zip://'.$fullzipname. '#' .$filename;
                $buffer = file_get_contents($cmd);
                if ( $buffer !== FALSE ) {
                    file_put_contents($cache_name, $buffer);
                    if ($ExtractMetadata && ($this->datas[0]->realFormat == 'fb2')) $this->extractMetaData($buffer);
                }
            }
            if (!file_exists($cache_name)) {
                put_log("Ошибка при распаковке ".$fullzipname);
                put_log('Команда разархивации "'.$cmd.'"' );
                $this->error(3); 
            }
        } else { //file_exists
  		    put_log("Не найден архив или директория или неизвестный тип архива ".$fullzipname);
            $this->error(2);
        }
        $buffer = NULL;
        return file_exists($cache_name);
    }

    private function extractMetaData($buffer){
        if (!$buffer) return FALSE;  //Произошла ошибка при распаковке архива
        
        global $config;  
        $doc = new DOMDocument();
        //Отключаем проверку ошибок
        $doc->strictErrorChecking = false;
        $doc->recover = true;
        
        if ($doc->loadXML($buffer, LIBXML_NOERROR)) {
            $description = $doc->getElementsByTagName('description')->item(0);

            if ($description) {
                $title_info = $description->getElementsByTagName('title-info')->item(0);
                if ($title_info) {
                    $anno = $title_info->getElementsByTagName('annotation')->item(0);
                    if ($anno) $this->comment = $anno->nodeValue;
                    $coverpage = $title_info->getElementsByTagName('coverpage')->item(0);
                    if ($coverpage) {
                        $image = $coverpage->getElementsByTagName('image')->item(0);
                        if ($image)  {  // && $image->hasAttribute('href')
                            $covername = $image->attributes->getNamedItem('href')->nodeValue;
                            if ($covername) { 
                                $covername = substr($covername, 1); 
                                $binary = $doc->getElementsByTagName('binary');
                                for ($i = 0; $i < $binary->length; ++$i) {
                                    $item = $binary->item($i);
                                    $img_id = $item->attributes->getNamedItem('id')->nodeValue;
                                    if ($covername == $img_id) {
            		                    $cover = $item->nodeValue;
                                        $this->hasCover = 1; 
                                        break;
                                    }
                                }  // for
                            }  //if covername
                        }  //if image
                    }  //if coverpage
                } //if title-info                   
            } //if description 
        }  // loadXML  
        $doc = NULL;  
        
        if (strlen($this->comment)) 
            file_put_contents ($this->getCacheDir() . 'comment.txt' , $this->comment, LOCK_EX);
        if ($this->hasCover) {
            if ($covername == 'cover.jpg') {
                file_put_contents ( $this->getCacheDir() . 'cover.jpg', base64_decode($cover), LOCK_EX);
            } else {    //PNG, GIF
                $src_img = imagecreatefromstring(base64_decode($cover));
                imagejpeg($src_img, $this->getCacheDir() . 'cover.jpg');
                imagedestroy($src_img);
            }
            $cover = NULL;
    	}
        return TRUE;
    }

    private static function error ($err) {
        if (php_sapi_name() != "cli") {
            header("location: checkconfig.php?err=$err");
        }
        throw new Exception( ($err==2 ? 'ZIP with books not found.' : 'Unzip error') );
    }

    private function getCacheDir($create = FALSE) {
        $succ = TRUE;
        $dir = $this->path;
        if (isWin()) $dir = iconv('UTF-8', 'CP1251', $dir);
        if ($create && !is_dir($dir) ) { $succ = mkdir($dir, 0777, TRUE); }
        return ( $succ ? $dir : FALSE );
    }

    public static function getCacheDirectorySize() 
    { 
      $totalsize = 0; 
      $rm_cnt=0;
      $dir = Base::getDbDirectory();
          
      if ($dh = opendir($dir)) {
          while (($file = readdir($dh)) !== false) {
            if( "." == $file || ".." == $file ) continue;
            if ((strpos($file, 'fb2-') === 0) && !is_file($dir . $file)) {
              $totalsize += self::getDirectorySize($dir . $file . '/');
            }
          }  
          closedir($dh);
      }
      return $totalsize; 
    } 
    
    public static function getDirectorySize($path) 
    { 
      $totalsize = 0; 
      if ($handle = opendir ($path)) { 
        while (false !== ($file = readdir($handle))) { 
          $nextpath = $path . '/' . $file; 
          if ($file == '.' || $file == '..' || $file == 'metadata.db' || $file == 'create_metadatadb.php' || is_link ($nextpath)) continue;
          if (is_dir ($nextpath)) 
              $totalsize += self::getDirectorySize($nextpath);
          elseif (is_file ($nextpath)) 
              $totalsize += filesize ($nextpath); 
        } 
      } 
      closedir ($handle); 
      return $totalsize; 
    } 

    public static function clear_cache($database = NULL) {
        $scanmask = Base::getDbDirectory($database);
        $rm_cnt=0;
        if ($dh = opendir($scanmask)) {
            while (($file = readdir($dh)) !== false) {
                if( "." == $file || ".." == $file ) continue;
                if ( ((strpos($file, 'fb2-') === 0) || 
                      (strpos($file, 'f.fb2-') === 0) || 
                      (strpos($file, 'd.fb2-') === 0) ) 
                      && is_dir($scanmask . $file)) {
                    self::rm_dir_files($scanmask . $file . '/');
                    rmdir($scanmask . $file);
                    $rm_cnt++;
                }
            }
            closedir($dh);
        }  
        return $rm_cnt;
    }

    static function rm_dir_files( $dir ) {
        if ($dh = opendir($dir)) {
            while (($file = readdir($dh)) !== false) {
                if( "." == $file || ".." == $file ) continue;
                if (is_file($dir . $file)) {
                    unlink($dir . $file);
                } else { 
                    self::rm_dir_files($dir . $file . '/');
                    rmdir($dir . $file);
                }
            }
            closedir($dh);
        }
    }

    //Конвертация в другие форматы, только при наличии установленного стороннего конвертера
    //В случае успеха вернет имя нового файла с полным путем
    public function convert_to($type) {
        global $config;

        $filename = $this->datas[0]->getLocalPath();              //Включает полный путь и имя исходного файла
        $source_dir = $this->path;                      //Директория, где файл. Она же, директория назначения 
        $out_name = substr($filename, 0, -3) . $type;   //Включает полный путь и имя файла после конвертации

        if ( stripos($config['cops_convert_to_types'], $type) !== FALSE ) {
            $sCmd = sprintf($config['convert_cmd'], $type, $filename, $source_dir, $out_name);
            put_log("out_name=$out_name filename=$filename book-path=".$source_dir);
            put_log($sCmd);
            if (!file_exists($out_name)) {     //Проверить, может уже в кеше
                $res = shell_exec($sCmd);
                put_log($res);
            }
            if (file_exists($out_name)) {
                return $out_name;
            }
        }
        return FALSE;
    }

}
?>