<?php

$ddl_mysql = <<<EOD
#DROP DATABASE copsfb2;
#
#CREATE DATABASE IF NOT EXISTS copsfb2 CHARACTER SET utf8 COLLATE utf8_general_ci;
#
DROP TABLE IF EXISTS languages;

CREATE TABLE IF NOT EXISTS languages ( 
    id INTEGER PRIMARY KEY,
    lang_code char(3) NOT NULL,
    lang_fb2 char(2),
    UNIQUE(lang_code)
);

CREATE INDEX languages_idx ON languages (lang_code);

insert into languages values
            (1, "rus", "RU"),
            (2, "bel", "BE"),
            (3, "ukr", "UK"),
            (4, "eng", "EN"),
            (5, "bul", "BG"),
            (6, "deu", "DE"),
            (7, "pol", "PL"),
            (8, "esp", "ES"),
            (9, "ces", "CS"),
            (10, "swe", "SV"),
            (11, "ita", "IT"),
            (12, "fra", "FR"),
            (13, "zha", "ZH"),
            (14, "epo", "EO"),
            (15, "lat", "LA"),
            (16, "isl", "IS"),
            (17, "jpn", "JA"),
            (18, "por", "PT"),
            (19, "dan", "DA"),
            (20, "slk", "SK"),
            (21, "aze", "AZ"),
            (22, "hun", "HU"),
            (23, "ron", "RO"),
            (24, "srp", "SR"),
            (25, "kaz", "KK"),
            (26, "uzb", "UZ"),
            (27, "hrv", "HR"),
            (28, "chu", "CU"),
            (29, "ina", "IA"),
            (30, "lit", "LT"),
            (31, "tur", "TR"),
            (32, "vie", "VI"),
            (33, "fin", "FI"),
            (34, "lav", "LV"),
            (35, "nld", "NL"),
            (36, "cat", "CA"),
            (37, "est", "ET"),
            (38, "nor", "NO"),
            (39, "tgk", "TG"),
            (40, "ell", "EL"),
            (41, "chv", "CV"),
            (42, "tat", "TT"),
            (43, "ind", "ID"),
            (44, "kor", "KO"),
            (45, "kat", "KA"),
            (46, "glg", "GA"),
            (47, "kal", "KL");

DROP TABLE IF EXISTS tags;

CREATE TABLE tags ( id INTEGER PRIMARY KEY,
                    name varchar(64) NOT NULL,
                    fb2code varchar(32),
                    UNIQUE (fb2code)
);

CREATE INDEX tags_idx ON tags (name);

DROP TABLE IF EXISTS series;

CREATE TABLE series ( id INTEGER PRIMARY KEY,
                      name varchar(255) NOT NULL,
                      sort varchar(255),
                      UNIQUE (name)
);

CREATE INDEX series_idx ON series (sort);

DROP TABLE IF EXISTS publishers;

CREATE TABLE publishers ( id INTEGER PRIMARY KEY,
                          name varchar(255) NOT NULL,
                          sort varchar(255),
                          UNIQUE(name)
);

CREATE INDEX publishers_idx ON publishers (name);

DROP TABLE IF EXISTS ratings;

CREATE TABLE ratings ( id INTEGER PRIMARY KEY,
                       rating INTEGER,
                       UNIQUE (rating)
);

DROP TABLE IF EXISTS authors;

CREATE TABLE authors (id INTEGER PRIMARY KEY,
                      name varchar(128) NOT NULL,
                      sort varchar(128),
                      link varchar(30) NOT NULL DEFAULT ""
);

CREATE INDEX authors_idx ON authors (sort);

DROP TABLE IF EXISTS books;

CREATE TABLE books ( id INTEGER PRIMARY KEY,
                     title     varchar(255) NOT NULL DEFAULT 'Unknown',
                     sort      varchar(255),
                     timestamp TIMESTAMP,
                     pubdate   DATETIME,
                     series_index decimal(8.1) NOT NULL DEFAULT 1.0,
                     author_sort TEXT,
                     isbn varchar(13) DEFAULT "",
                     lccn varchar(13) DEFAULT "",
                     path varchar(255) NOT NULL DEFAULT "",
                     flags INTEGER NOT NULL DEFAULT 1,
                     uuid char(36),
                     has_cover decimal(1.0) DEFAULT 0,
                     last_modified DATETIME NOT NULL DEFAULT "2000-01-01 00:00:00"
);

CREATE INDEX books_idx ON books (sort);

DROP TABLE IF EXISTS data;

CREATE TABLE data ( id INTEGER PRIMARY KEY,
                    book   INTEGER NOT NULL,
                    format varchar(16) NOT NULL,
                    uncompressed_size INTEGER NOT NULL,
                    name TEXT NOT NULL,
                    UNIQUE(book, format)
);

CREATE INDEX data_idx ON data (book);

CREATE INDEX formats_idx ON data (format);

DROP TABLE IF EXISTS books_authors_link;

CREATE TABLE books_authors_link ( id INTEGER PRIMARY KEY,
                                  book INTEGER NOT NULL,
                                  author INTEGER NOT NULL,
                                  UNIQUE(book, author)
);

CREATE INDEX books_authors_link_aidx ON books_authors_link (author);

CREATE INDEX books_authors_link_bidx ON books_authors_link (book);

DROP TABLE IF EXISTS books_languages_link;

CREATE TABLE books_languages_link ( id INTEGER PRIMARY KEY,
                                    book INTEGER NOT NULL,
                                    lang_code INTEGER NOT NULL,
                                    item_order INTEGER NOT NULL DEFAULT 0,
                                    UNIQUE(book, lang_code)
);

CREATE INDEX books_languages_link_aidx ON books_languages_link (lang_code);

CREATE INDEX books_languages_link_bidx ON books_languages_link (book);

DROP TABLE IF EXISTS books_publishers_link;

CREATE TABLE books_publishers_link ( id INTEGER PRIMARY KEY,
                                     book INTEGER NOT NULL,
                                     publisher INTEGER NOT NULL,
                                     UNIQUE(book)
);

CREATE INDEX books_publishers_link_aidx ON books_publishers_link (publisher);

CREATE INDEX books_publishers_link_bidx ON books_publishers_link (book);

DROP TABLE IF EXISTS books_ratings_link;

CREATE TABLE books_ratings_link ( id INTEGER PRIMARY KEY,
                                  book INTEGER NOT NULL,
                                  rating INTEGER NOT NULL,
                                  UNIQUE(book, rating)
);

CREATE INDEX books_ratings_link_aidx ON books_ratings_link (rating);

CREATE INDEX books_ratings_link_bidx ON books_ratings_link (book);

DROP TABLE IF EXISTS books_series_link;

CREATE TABLE books_series_link ( id INTEGER PRIMARY KEY,
                                 book INTEGER NOT NULL,
                                 series INTEGER NOT NULL,
                                 UNIQUE(book)
);

CREATE INDEX books_series_link_aidx ON books_series_link (series);

CREATE INDEX books_series_link_bidx ON books_series_link (book);

DROP TABLE IF EXISTS books_tags_link;

CREATE TABLE books_tags_link ( id INTEGER PRIMARY KEY,
                               book INTEGER NOT NULL,
                               tag INTEGER NOT NULL,
                               UNIQUE(book, tag)
);

CREATE INDEX books_tags_link_aidx ON books_tags_link (tag);

CREATE INDEX books_tags_link_bidx ON books_tags_link (book);

DROP TABLE IF EXISTS comments;

CREATE TABLE comments ( id INTEGER PRIMARY KEY,
                        book INTEGER NOT NULL,
                        text TEXT,
                        UNIQUE(book)
);

CREATE INDEX comments_idx ON comments (book);

DROP TABLE IF EXISTS custom_columns;

CREATE TABLE custom_columns (
                    id       INTEGER PRIMARY KEY,
                    label    varchar(64) NOT NULL,
                    name     varchar(64) NOT NULL,
                    datatype varchar(64) NOT NULL,
                    mark_for_delete   DECIMAL(1.0) DEFAULT 0 NOT NULL,
                    editable DECIMAL(1.0) DEFAULT 1 NOT NULL,
                    display  varchar(64) DEFAULT "{}" NOT NULL,
                    is_multiple DECIMAL(1.0) DEFAULT 0 NOT NULL,
                    normalized DECIMAL(1.0) NOT NULL,
                    UNIQUE(label)
                );

CREATE INDEX custom_columns_idx ON custom_columns (label);

EOD;

define( 'DB_DDL', $ddl_mysql);

?>