<?php
    require_once("../config.php");
    require_once("../base.php");
    require_once("../lib/Base.php");
    require_once("../lib/ZipBook.php");
    require_once("./create_db_conf.php");
    
    global $config;
    if ($config['use_mysql']) require_once("./metadata_ddl_mysql.php");  
    else                      require_once("./metadata_ddl.php");  
    
    error_reporting(E_ERROR);
    set_time_limit ( 7200 );


?>
<?php
    $aOut = array();
    $aOut["msg"] = '';
    $aOut["err_state"] = 0;
    header ("Content-Type:application/json;charset=utf-8");

    if ($_GET['func']) {
        if ( !check_admin() ) die();
        $tim = microtime(true);

        /**
         * Функции, которым не нужна база
         */
        $func = $_GET['func'];
        $aFuncName = array('clear_cache', 'create_db', 'extract_inp', 'clear_tmp');
        if (in_array($func, $aFuncName)) {
          try {
            switch ($func) {
                case 'clear_cache':
                    $n = ZipBook::clear_cache($database);
                    $aOut["msg"] = "Удалены файлы кеша из " . $n . " директорий";
                    break;
                case 'extract_inp': 
                    $inp_list = inp::extract_inp($tmp_dir, $inpx_file);
                    if (is_array($inp_list)) {
                        $aOut['inp_list'] = $inp_list;
                        $aOut["msg"] = 'Распакован во временную директорию';
                    } else {
                        $aOut["err_state"] = 3; $aOut["msg"] = "Ошибка при открытии архива: $inpx_file";
                    }
                    break;
                case 'create_db':
                    if ($config['use_mysql']) $db = new metadata_db_mysql($db_name, TRUE);
                    else $db = new metadata_db($db_name, TRUE);
                    $aOut["msg"] = 'База данных создана';
                    break;
                case 'clear_tmp': 
                    if ($handle = opendir($tmp_dir)) { 
                        while (false !== ($file = readdir($handle))) { 
                            if (($file != '.') && ($file != '..') && !is_link ($tmp_dir . $file) && !is_dir($tmp_dir . $file)) { 
                                unlink($tmp_dir . $file);  
                            } 
                        } 
                    } 
                    rmdir($tmp_dir);
                    $aOut["msg"] = 'Временная директория удалена';
                    break;
            }
          } catch (Exception $e) {
                $aOut["err_state"] = 1;
                $aOut["msg"] = 'Ошибка при обработке функции: ' . $func . ' ' . $e->getMessage();
          }
            echo json_encode ( $aOut );
            die();
        }

        /**
         * Открываем БД
         */
        try  {
            if ($config['use_mysql']) $db = new metadata_db_mysql($db_name, FALSE);
            else $db = new metadata_db($db_name, FALSE);
        } catch(Exception $e) {
            $aOut["err_state"] = 1; $aOut["msg"] = "Ошибка открытия БД";
            echo json_encode ( $aOut );
            die();
        }
      
        try {
            $inp = new inp($db, $skip_deleted, $lang_load, $genres_file);
            if ($skip_genres) $inp->set_skip_genres($skip_genres);

            $db->getDb()->beginTransaction();
            switch ($_GET['func']) {
                case 'load_genres': 
                    if ( $inp->load_genres() ) {
                        $aOut["msg"] = "Успешно загружен список жанров из ".$genres_file;
                    } else {
                        $aOut["err_state"] = 2; $aOut["msg"] = "Ошибка загрузки списка жанров из $genres_file";
                    }
                    break;
                case 'load_inp': 
                    $inp_name = $_GET['inp_name'];
                    if (is_readable($inp_name)) { 
                        if ($inp->load($inp_name)) {
                            $aOut["msg"] = "Загружен ".$inp_name;
                        } else {
                            $aOut["err_state"] = 4; $aOut["msg"] = "Ошибка загрузки ".$inp_name;
                        }
                    } else {
                        put_log("Файл недоступен " . $inp_name);
                        $aOut["err_state"] = 4; $aOut["msg"] = "Файл недоступен. Ошибка загрузки ".$inp_name;
                    } 
                    break;
            }
            $db->getDb()->commit();
            $aOut["tim"] = (microtime(true)-$tim);
            $aOut["msg"] .= ". Время ".number_format($aOut["tim"], 2)." сек.";
        } catch(Exception $e) {
            $aOut["err_state"] = 4;
            $aOut["msg"] = 'Ошибка при обработке функции: ' . $func . ' ' . $e->getMessage();
            $db->getDb()->rollback();
        }

    }

    echo json_encode ( $aOut );
    die();


function error($msg = '') {
    throw new Exception("Database create error. $msg");
}

function uuid_v4() {
    return sprintf('%04x%04x-%04x-%04x-%04x-%04x%04x%04x',
      // 32 bits for "time_low"
      mt_rand(0, 0xffff), mt_rand(0, 0xffff),
      // 16 bits for "time_mid"
      mt_rand(0, 0xffff),
      // 16 bits for "time_hi_and_version",
      // four most significant bits holds version number 4
      mt_rand(0, 0x0fff) | 0x4000,
      // 16 bits, 8 bits for "clk_seq_hi_res",
      // 8 bits for "clk_seq_low",
      // two most significant bits holds zero and one for variant DCE1.1
      mt_rand(0, 0x3fff) | 0x8000,
      // 48 bits for "node"
      mt_rand(0, 0xffff), mt_rand(0, 0xffff), mt_rand(0, 0xffff)
    );
  }

function mhl_upper($str, $encoding = null) {
    if (null === $encoding) { $encoding =  "UTF-8"; } 
    return mb_strtoupper($str, $encoding);
}
function mhl_full_name($str1, $str2, $str3, $delim=' ') {
    return trim(mhl_upper($str1).$delim.mhl_upper($str2).$delim.mhl_upper($str3));
}


class metadata_db 
{

    const DB_DDL = DB_DDL;

    protected $db=NULL;
    protected $db_name;

    public function __construct($filename='metadata.db', $create=FALSE){
        $this->db_name = $filename;
        if ( $create && file_exists( $this->db_name )) unlink( $this->db_name );
        
        try {
            $this->db = new PDO('sqlite:'. $this->db_name );
            $this->db->sqliteCreateFunction('TITLE_SORT', 'mhl_upper');
            $this->db->sqliteCreateFunction('UUID4', 'uuid_v4');
            if ($create) $this->create_db();
            $this->getDb()->query("PRAGMA synchronous=off");
            $this->getDb()->query("PRAGMA temp_store=MEMORY");
        } catch (Exception $e) {
            put_log("Ошибка при открытии БД " . $e->getMessage());  
            error ();
        }
    }

    public function getDb() {
        return $this->db;
    }


    protected function create_db() {
        $buf = '';
        $in_block = 0;
        $ddl = explode("\n", self::DB_DDL);
      
        foreach ($ddl as $str)  {
            if ( substr($str, 0, 1) == '#' ) continue;
        
            if( stripos($str, 'begin') !== FALSE ) $in_block++;
            if( stripos($str, ' case') !== FALSE ) $in_block++;
            if( stripos($str, 'end;') !== FALSE )  $in_block--;
        
            $buf .= ($str . "\n");
            if( (stripos($str, ';') !== FALSE ) && ( $in_block <= 0 ) ) {
                if ( ($stm = $this->db->query($buf)) === FALSE ) {
                    $info = $this->db->errorInfo();
       	            put_log($info[2]); put_log($buf);
                    error();
                    return FALSE;
                }
                $buf = ''; $in_block = 0;
            }
        }
        return TRUE;
    }

    public function prep_query($q)
    {
        if ( ($stm = $this->db->prepare( $q ) ) === FALSE ) {
    		$info = $this->db->errorInfo();
   			put_log($info[2]); put_log($q);
    		return FALSE;
    	}      
        return $stm;
    }

}


class inp
{
  
    //Глобальные счетчики вместо автоинкремента для ускорения работы - чтобы еще раз не дергать 
    //запрос для получения последнего добавленного ID
    private $SeriesCnt = 0;
    private $BookCnt = 0;
    private $AuthorCnt = 0;
    
    
    //Для ускорения загрузки сначала подготовим массивы, потом одним запросом загрузим
    private $AuthorsList = array();
    private $SeriesList = array();
    private $SeriesListLink = array();
    private $GenresList = array();
    private $BooksList = array();
    private $DataList = array();
    private $LangList = array();
    private $BooksAuthorsList = array();
    private $AuthorsWatchList = NULL;
    
    
    //Для быстрого поиска ключей в справочниках - на винде загрузка ускорилась в 10 раз по сравнению с поиском в базе
    private $SeriesFast = array();
    private $AuthorsFast = array();
    private $GenresFast = array();
    private $LangFast = array();
    
    private $db=NULL;
    private $stm_find_series;
    private $stm_find_author;
    private $stm_find_genre;
    
    private $skip_deleted;
    private $lang_load;
    private $genres_file;
    private $aGenresSkip = FALSE;
    
    //private $stm_ins_series;
  
    public function __construct($db, $skip_deleted = FALSE, $lang_load = FALSE, $genres_file = "genres_fb2.glst"){
        $this->db = $db;
        $this->skip_deleted = $skip_deleted;
        $this->lang_load = $lang_load;
        $this->genres_file = $genres_file;

        if ( file_exists('./WatchAuthors.txt') ) $this->AuthorsWatchList = file('./WatchAuthors.txt', FILE_SKIP_EMPTY_LINES | FILE_IGNORE_NEW_LINES);
        //put_log(print_r($this->AuthorsWatchList, true));

        $q = $this->db->getDb()->query("select id, fb2code from tags");
        while ( $row = $q->fetch() ) {
            $this->GenresFast[$row['fb2code']] = $row['id'];
        }      
        foreach ($this->db->getDb()->query("select id, sort from authors") as $row) {
            $this->AuthorsFast[$row['sort']] = $row['id'];
            $this->AuthorCnt++;
        }      
        foreach ($this->db->getDb()->query("select id, sort from series") as $row) {
            $this->SeriesFast[$row['sort']] = $row['id'];
            $this->SeriesCnt++;
        }      
        $q = $this->db->getDb()->query("select id, lang_code, lang_fb2 from languages");
        while ( $row = $q->fetch() ) {
            $this->LangFast[$row['lang_fb2']] = $row['id'];
        }      
        
        if ($n=$db->getDb()->query("select max(id) as BookCnt from books")->fetchColumn()) $this->BookCnt = $n;
    }
  
    public function set_skip_deleted($skip_deleted) {
        $this->skip_deleted = $skip_deleted;
    }

    public function set_lang_load($lang_load) {
        $this->lang_load = $lang_load;
    }
  
    public function set_genres_file($genres_file) {
        $this->genres_file = $genres_file;
    }
  
    public function set_skip_genres($skip_genres_list) {
        if ($skip_genres_list) {
            $this->aGenresSkip = explode(',', $skip_genres_list); // array();
        }
    }
  
  
    public function load($fn)
    {
        $tim = microtime(true);
        $result = $this->read_inp($fn);
        $tim1 = microtime(true);

        if ($result) {
            try {
            $result = $this->List2DB($this->SeriesList, "series", 
                                        "insert into series (id, name, sort) values ") &&
                        $this->List2DB($this->SeriesListLink, "books_series_link", 
                                        "insert into books_series_link (id, book, series) values ", TRUE) &&
                        $this->BooksList2DB() &&
                        $this->List2DB($this->DataList, "data", 
                                        "insert into data (id, book, format, uncompressed_size, name) values ") &&
                        $this->List2DB($this->AuthorsList, "authors", 
                                        "insert into authors (id, name, sort, link) values ") &&
                        $this->List2DB($this->GenresList, "books_tags_link", 
                                        "insert into books_tags_link (id, book, tag) values ", TRUE) &&
                        $this->List2DB($this->BooksAuthorsList, "books_authors_link",  
                                        "insert into books_authors_link (ID, Book, Author) values ", TRUE) &&
                        $this->List2DB($this->LangList, "books_languages_link", 
                                        "insert into books_languages_link (id, book, lang_code) values ", TRUE);
            } catch (Exception $e) {
                put_log("$fn, Ошибка при записи в базу: " . $e->getMessage()); 
                $result = FALSE;
            }
            $tim2 = microtime(true);
            
            put_log("$fn, Разбор: ".($tim1-$tim).", Загрузка: ".($tim2-$tim1).
                    ", Книг: ".count($this->BooksList).", Авторов: ".count($this->AuthorsList)); 
        }
      
        $this->AuthorsList = array();
        $this->SeriesList = array();
        $this->SeriesListLink = array();
        
        $this->GenresList = array();
        $this->BooksList = array();
        $this->BooksAuthorsList = array();
        
        return $result;
    }

    private function read_inp($fn)
    {
        if ( !( is_readable( $fn ) && ($handle = fopen($fn, "r")) ) )   return FALSE;
        $folder = basename($fn, '.inp') . '.zip';

        $result = TRUE;
        $row = 0;
        try {
            while (($str = fgets($handle)) !== FALSE) {
                $data = explode(chr(4), $str);
                $row++;

                if ( count($data) !== 15 ) continue;
                if ( $this->skip_deleted && $data[8] ) continue; //"IsDeleted"
                //Если язык не указан или это не строка, по умолчанию считаем русским (ошибки inp в librusec)
                $SearchLang = mhl_upper(empty($data[11]) ? 'ru' : $data[11]);
                if ( $this->lang_load && ( stripos($this->lang_load, $SearchLang) === FALSE ) )  continue; //язык

                //Жанры разделены двоеточием
                $aGenres = explode(':', $data[1]);
                
                //Если заданы в настройках жанры, которые не грузить
                if ( is_array($this->aGenresSkip) ) {
                    $skip = FALSE;
                    foreach($aGenres as $genre) {
                        $genre=trim($genre);
                        if($genre == '') continue;
                        if( in_array($genre, $this->aGenresSkip ) ) { 
                            $skip = TRUE;
                            break;            
                        }
                    }
                    if ($skip) continue;
                }
                    
                $this->BookCnt++;      

                if ( $data[3] ) { //"Series"
                    $SeriesID = $this->addSeries( $data[3] );
                    //Ошибки в INP Filbusta, спасибо Дмитрию ****@lts-pskov.ru
                    $SeqNumber = ( is_numeric($data[4]) ? $data[4] : '1' );
                    $this->SeriesListLink[] = array(":book" => $this->BookCnt, ":series" => $SeriesID );
                } else {
                    $SeriesID = 'NULL'; $SeqNumber = 1;
                }
                
                $now = date_create();
                $now_str = date_format($now, 'Y-m-d H:i:s.u');
                $this->BooksList[] = array(
                    ':id' => $this->BookCnt, 
                    ':title' => $this->db->getDB()->quote($data[2]), 
                    ':sort' => $this->db->getDB()->quote(mhl_upper($data[2])),
                    ':timestamp' => $now_str,
                    ':pubdate' => $data[10],
                    ':series_index' => $SeqNumber,
                    ':author_sort' => $this->db->getDB()->quote($data[0]),
                    ':isbn' => '',
                    ':lccn' => '',
                    ':path' => $folder,
                    ':flags' => 1,
                    ':uuid' => uuid_v4(),
                    ':has_cover' =>  0,
                    ':last_modified' => date('Y-m-d') );
                    
                $this->DataList[] = array(
                    ':id' => $this->BookCnt, 
                    ':book' => $this->BookCnt,     //В либрусек это одно и тоже
                    ':format' => '"'.$data[9].'"', 
                    ':uncompressed_size' => $data[6],
                    ':name' => $data[7]  ); 
                    
                if ( array_key_exists($SearchLang, $this->LangFast) ) {
                    $LangCode = $this->LangFast[$SearchLang];
                    $this->LangList[] = array(":book" => $this->BookCnt, ":lang_code" => $LangCode );
                }

                $this->addAuthors($data[0], $this->BookCnt);
                $this->addGenres($aGenres, $this->BookCnt);
            }
        } catch (Exception $e) {
            put_log("$fn, Ошибка при разборе: " . $e->getMessage() . "\nСтрока $str"); 
            $result = FALSE;
        } finally {
            fclose($handle);
        }
        return $result;
    }

    public function load_genres()
    {  
        $cnt = 0;
        if (!file_exists($this->genres_file)){
            put_log("Нет файла с описанием жанров ".$this->genres_file);
            return FALSE;
        }
      
        //$stm = $this->db->prep_query("insert into tags (id, name, alias) values (:id, :name, :alias)");
        //if ($stm) {
        $genres = file($this->genres_file);
        $val = '';
        foreach ($genres as $str)  {
            $str = trim($str);
            if ( substr($str, 0, 1) == '#' ) continue;
            preg_match("/([0-9.]+) +(.+)/", $str, $matches);
            $code = $matches[1];
            $name = $matches[2];
            if (!$code) continue;
            //$aCode = explode('.', $code); //В базе калибры не используется
            $aName = explode(';', $name);
            if ( count($aName) == 1 ) {
                $alias = $aName[0]; $fb2code = ''; //'NULL';
            } else {
                $alias = trim($aName[1]); $fb2code = trim($aName[0]);
            }
            if (($fb2code == "") or array_key_exists($fb2code, $this->GenresFast) ) continue;
            $cnt++;
/*
            $param = array(':id' => $cnt, ':name' => $fb2code, ':alias' => $alias);
            if ( ! $stm->execute($param) ) {
                $info = $this->db->getDb()->errorInfo();
                put_log("Ошибка при загрузке списка жанров:\n".$info[2]);
                put_log( print_r($param, TRUE));
                
                return FALSE;
            }
*/
            $val .= ",\n" . '('.$cnt.',"'.$alias.'","'.$fb2code.'")';
            $this->GenresFast[$fb2code] = $cnt;
        }

        $val = "insert into tags (id, name, fb2code)  values \n".substr($val,1).";\n" ;
        try {
            if ( ($stm = $this->db->getDb()->query($val)) === FALSE ) {
                $info = $this->db->getDb()->errorInfo();
                put_log("Ошибка при загрузке списка жанров:\n".$info[2]);
                put_log($val);
                return FALSE;
            }
        } catch(Exception $e) {
            put_log("Ошибка при загрузке списка жанров:\n" . $e->getMessage()); 
            put_log($val);
            return FALSE;
        }
        //}
        return TRUE;
    }
    
    //Первоначально была построена на PDO::prepare и PDO::execute
    //Но под windows работала крайне медленно, поэтому переписал на загрузку одним запросом 
    private function List2DB(&$aList, $Table, $ins_q, $add_id=FALSE)
    {
        $cnt = 0; $val = ''; $last_id = 0;
      
        if ($add_id) {
            $last_id = $this->db->getDb()->query("select max(id) as last_id from ".$Table)->fetchColumn();
        }
      
        foreach ($aList as $str => $arr )  {
            $cnt++;
            $strval = '';
            foreach($arr as $key => $s) $strval .= ','.$s;
            if ($add_id) {
                $last_id++;
                $strval = ' ' . $last_id . $strval;
            }
        
            $val .= ",\n" . '(' . substr($strval,1) .')';
            if ( ($cnt % 500) === 0  ) {
                $val = $ins_q . substr($val,1) . ";\n" ;
                if ( ($stm = $this->db->getDb()->query($val)) === FALSE ) {
                    $info = $this->db->getDb()->errorInfo();
                    put_log("Ошибка при загрузке $Table:\n".$info[2]);
                    put_log($val);
                    return FALSE;
        	    }
                $cnt = 0; $val = '';
            }
        }
        
        if ($cnt > 0) {
            $val = $ins_q . substr($val,1) . ";\n" ;
            if ( ($stm = $this->db->getDb()->query($val)) === FALSE ) {
    	        $info = $this->db->getDb()->errorInfo();
    	        put_log("Ошибка при загрузке $Table:\n".$info[2]);
                put_log($val);
    	        return FALSE;
            }
        }
        return TRUE;
    }

    function BooksList2DB()
    {
        $cnt = 0; $val = '';
      
        foreach ($this->BooksList as $arr )  {
            $cnt++;
            $val .= ",\n" . 
                    '('.$arr[":id"].','.$arr[":title"].','.$arr[":sort"].',"'.$arr[":timestamp"].'","'.
                    $arr[":pubdate"].'",'.$arr[":series_index"].','.$arr[":author_sort"].',"'.$arr[":isbn"].'","'.$arr[":iccn"].'","'.
                    $arr[":path"].'",'.$arr[":flags"].',"'.$arr[":uuid"].'",'.$arr[":has_cover"].',"'.$arr[":last_modified"].'")';

            if (($cnt % 500) === 0) {
                $val = "insert into books ".
                       "( id, title, sort, timestamp, pubdate, series_index, author_sort, isbn, ".
                       "  lccn, path, flags, uuid, has_cover, last_modified) values ".
                       substr($val,1).";\n" ;
                if (($stm = $this->db->getDb()->query($val)) === FALSE) {
            	    $info = $this->db->getDb()->errorInfo();
           			  put_log("Ошибка при загрузке книг:\n".$info[2]);
                  put_log($val);
    		          return FALSE;
            	  }
                $cnt = 0;
                $val = '';
            }
        }
      
        if ($cnt > 0) {
            $val = "insert into books ".
                   "( id, title, sort, timestamp, pubdate, series_index, author_sort, isbn, ".
                   "  lccn, path, flags, uuid, has_cover, last_modified) values ".
                   substr($val,1).";\n" ;
            if ( ($stm = $this->db->getDb()->query($val)) === FALSE ) {
    		    $info = $this->db->getDb()->errorInfo();
   			    put_log("Ошибка при загрузке книг:\n".$info[2]);
                put_log($val);
    		    return FALSE;
    	    }
        }
        return TRUE;
    }

    private function addSeries($Series)
    {
        $Series = trim($Series);
        $SearchSeriesTitle = mhl_upper($Series);

        if ( array_key_exists($SearchSeriesTitle, $this->SeriesFast) ) {
            return $this->SeriesFast[$SearchSeriesTitle];
        } else {
            $this->SeriesCnt++;
            $this->SeriesFast[$SearchSeriesTitle] = $this->SeriesCnt;
            $this->SeriesList[] = array(":id" => $this->SeriesCnt, 
                                        ":name" => $this->db->getDB()->quote($Series),
                                        ":sort"  => $this->db->getDB()->quote($SearchSeriesTitle)); 
            return $this->SeriesCnt;
        }
        return 'NULL';
    }

    private function addAuthors($authors, $BookID)
    {
        $noRepeat = array();
      
        //авторы разделены двоеточием
        $aAuthor = explode(':', $authors);
        foreach($aAuthor as $Author) {
            $name = trim(str_replace(',', ' ', $Author));
            if($name == '') continue;
            $SearchName = mhl_upper($name);
        
            if (array_key_exists($SearchName, $this->AuthorsFast) ) {
                $AuthorID = $this->AuthorsFast[$SearchName];
            } else { // Нету, в список на добавление
                $this->AuthorCnt++;
                $AuthorID = $this->AuthorCnt;
                $this->AuthorsFast[$SearchName] = $AuthorID;
                $watch = ( isset($this->AuthorsWatchList) ? (in_array($name, $this->AuthorsWatchList) ? 'Y' : '' ) : 'Y');
                $this->AuthorsList[] = array(":id" => $this->AuthorCnt, 
                                             ":name" => $this->db->getDB()->quote($name), 
                                             ":sort" => $this->db->getDB()->quote($SearchName), 
                                             ":link" => $this->db->getDB()->quote($watch) ); 
            }
        
            //Ошибки в inp, некоторые авторы в одной книге по 2 раза, например в 328410 Алкей
            if (!in_array($AuthorID, $noRepeat)) {
                $this->BooksAuthorsList[] = array(":book" => $BookID, ":author" => $AuthorID);
                $noRepeat[] = $AuthorID;
            }
        }
        
        return true;
    }
      
    private function addGenres(&$aGenres, $BookID)
    {
        //Жанры разделены двоеточием
        //$aGenres = explode(':', $genres);
        foreach($aGenres as $genre) {
            $genre=trim($genre);
            if($genre == '') continue;
            if (!array_key_exists($genre, $this->GenresFast)) continue;
            $GenreCode = $this->GenresFast[$genre];
            $this->GenresList[] = array(":book" => $BookID, ":tag" => $GenreCode );
        }
        return true;
    }

    
    public static function extract_inp($tmp_dir, $inpx_file) 
    { 
        $inp_list = false;
        $zip = new ZipArchive;
        
        if ($zip->open( $inpx_file ) === TRUE  ) {
            $dummy = (is_dir($tmp_dir) || mkdir($tmp_dir, 0777, TRUE));
            $zip->extractTo($tmp_dir);
            $zip->close();	
        
            if ($handle = opendir ($tmp_dir)) { 
                $inp_list = array();
                while (false !== ($file = readdir($handle))) { 
                    $nextfile = $tmp_dir . $file; 
                    if ( (strcasecmp('inp', pathinfo($nextfile, PATHINFO_EXTENSION ) ) == 0 ) ) {
                        $inp_list[] = $nextfile;
                    }
                } 
                closedir ($handle);
                sort($inp_list); 
            } 
        } else {
            put_log("Ошибка при открытии архива $inpx_file");
        }
        return $inp_list;
    }

}


class metadata_db_mysql extends metadata_db
{
  //const DB_DDL = DB_DDL;

    public function __construct($filename='copsfb2', $create=FALSE){
        
        global $config;  
        
        try {
            $this->db = new PDO($config['mysql_dsn'], 
                                $config['mysql_username'], 
                                $config['mysql_password'], 
                                [PDO::MYSQL_ATTR_INIT_COMMAND => 'SET NAMES utf8']);
            if ($create) $this->create_db();
        } catch (Exception $e) {
            put_log("Ошибка при открытии БД " . $e->getMessage());  
            error ();
        }
    }
} 

/**
*  Структура INP 
        $book = array(
          "authors" => $data[0],
          "genres" => $data[1],
          "title" => $data[2],
          "Series" => $data[3],
          "SeqNumber" => $data[4],
          "LibID" => $data[5],
          "BookSize" => $data[6],
          "FileName" => $data[7],
          "IsDeleted" => $data[8],
          "Ext" => $data[9],
          "Date" => $data[10],
          "Lang" => $data[11],
          "LibRate" => $data[12],
          "KeyWords" => $data[13],
          "Folder" =>  basename($fn)     //$data[14]
        );
*/
