<?php
    set_time_limit ( 60 );
    if (!isset($config)) $config = array();

/**
* Переопределяем параметры по умолчанию
*/

    // Директория архивов книг. !Обязательно должна заканчиваться слешем !    
    $config['zipbook_directory'] = '/volume2/fast/LibRusEc/lib.rus.ec/';
    
    $config['calibre_directory'] = './fb2lib/';
    $config['cops_title_default'] = "COPS";
    $config['cops_prefered_format'] = array ("fb2");
    $config['cops_language'] = 'ru';
    $config['cops_max_item_per_page'] = "25";

    //Для библиотек LibRusEc/Flibusta поиск по этим категориям не имеет смысла
    $config ['cops_ignored_categories'] = array ("publisher", "language");
	
    //Не изменять!!!
    $config['cops_use_url_rewriting'] = "0";
    
    //normalized_search (NormAndUp) - работает. Но ОЧЕНЬ медленно. Поэтому поиск в форке эту опцию не использует,
    //а по тексту в скриптах только там, где реально нужно в форке явно строка приводится к mb_strtoupper()
    $config['cops_normalized_search'] = FALSE;

/* Fork config */
    /**
    * Включить отладку. Будут выводится на экран браузера warning и notice (иначе только ошибки). 
    * Не будет использоваться lightbox, будет созаваться log.txt с результатами замеров производительности.
    * Включайте, только если у вас какие-то проблемы при работе
    */
    $config['fb_debug'] = false;
    if ($config['fb_debug']) $config['cops_server_side_render'] = ".";	
    if ($config['fb_debug']) 
      error_reporting(E_ALL & ~E_DEPRECATED);
    else 
      error_reporting(E_ERROR);
    
  	/**
  	* Вытаскивать ли метаданные из fb2 при показе списка книг.
  	* На слабых машинах работает медленно, по умолчанию отключено
  	*/
  	$config['get_metadata_from_fb2'] = false; 
  
  	/**
  	* Упаковывать книги FB2 в zip-архив при выгрузке.
  	*/
    $config['cops_use_fb2_zip'] = TRUE;
  	
  	/**
  	* Имена файлов в транслит при выгрузке.
  	*/
    $config['cops_use_translit'] = true;
  	
    /*
    * Команда для вызова внешнего разархиватора.
    * Разархиватор должен выводить извлеченный файл в stdout
    * Параметр обязательный т.к. в php класс ZipArchive не умеет работать с архивами > 2 ГБ
    * Для PHP >= 7.4 не актуальтно, теперь умеет!
    */
    $config['shell_exec_cmd'] = '/usr/bin/7z e -so ';   	 //пример для DSM 6.*
    //$config['shell_exec_cmd'] = 'c:\\7-Zip\\7z.exe e -so ';  //пример для windows
    //$config['shell_exec_cmd'] = '/usr/syno/bin/unzip -p '; //пример для DSM 5.*
    
    /**
    * Проверка безопасности
    * На нее влияют 2 переменных в настройках:
    * 1. $config['check_security'] - логическая, если TRUE, то вызов функций, которые меняют библиотеку возможен только если текущий пользователь 
    *    авторизован как admin.
    * 2. $config['cops_basic_authentication'] - ассоциативный массив из пар "логин" => "пароль". Если определен, то проверяется авторизация текущего 
    *    пользователя при доступе к любой функции. Если не авторизован, будет вызван диалог авторизации и проверка по массиву.
    *
    * *  Если пользователь авторизуется средствами WEB-сервера, то строка с  $config['cops_basic_authentication'] ДОЛЖНА БЫТЬ закомментирована или
    * *  пользователи и пароли должны совпадать с такими на сервере. 
    */                                            
    /**
    * check_security - если TRUE, то вызов функций, которые меняют библиотеку возможен только если  
    * пользователь авторизован как admin //и клиент в той же сети, что и сервер -- пока отключено
    */
    $config['check_security'] = TRUE;
    
    // Для PHP авторизации. Если нужна авторизация, но нет возможности сделать авторизацию средствами WEB-сервера
    // Если авторизация на WEB-сервере, строку ниже необходимо закомментировать
    $config['cops_basic_authentication'] = array("reader" => "mycopsfb2", "admin" => "admcopsfb2" );

    /**  
    * Можно перенести БД в mysql. Но
    * 1. Если для БД MySQL параметр COLLATE=utf8_general_ci, то MySQL считает Е и Ё одной и той же буквой, а PHP нет. 
    *    Поэтому при загрузке не будут корректно загружены авторы и книги с Ё. Нужно править процедуру загрузки. 
    * 2. При малой нагрузке на сервер выигрыша в производительности нет
    * Пример коннекта к БД на mysql
    */

    $config['use_mysql'] = FALSE;
    /*
    $config['mysql_dbname'] = 'copsfb2';
    $config['mysql_host'] = 'localhost';
    $config['mysql_dsn'] = 'mysql:host='.$config['mysql_host'].';dbname='.$config['mysql_dbname'];
    $config['mysql_username'] = 'root';
    $config['mysql_password'] = '';
    */

  	/**
  	* Использовать конвертер в epub/mobi.
    * Конвертация в другие форматы, только при наличии установленного стороннего конвертера
    * Сконвертированный файл должен иметь то же имя и попасть в ту же директороию, что и исходный, но новое расширение
    * Параметры, которые передаются в строку команды конвертации (sprintf)
    * 1$ - $type        //тип, например mobi
    * 2$ - $filename    //Включает полный путь и имя исходного файла
    * 3$ - $source_dir  //Директория, где файл. Она же, директория назначения
    * 4$ - $out_name    //Включает полный путь и имя файла после конвертации
    * Ниже пример для конвертера fb2c, установленного в поддиректории ./convert, будет возможность конвертировать в mobi и epub   
  	*/
    $config['cops_convert_to_types'] = (file_exists('convert/fb2c') ? "mobi,epub" : FALSE);     //Типы, в которые возможна конвертация "mobi,epub". Если FALSE, то иконки конвертации не выводятся.
    $config['convert_cmd'] = './convert/fb2c '.                                                 //Командная строка для конвертации, параметры описаны выше
                                (file_exists('convert/configuration.toml') ? '--config convert/configuration.toml ' : '') .
                                'convert -to %1$s %2$s %3$s';
  
    /**
     * Если хотите использовать отправку книг на почту, введите корректные настройки smtp сервера
     * Yandex прекрасно подходит для этой цели, но при использовании яндекса теперь обязательно нужно заводить на нем "пароль для приложений" 
     * подробнее https://yandex.ru/support/id/authorization/app-passwords.html
     */
    /*
    $config['cops_mail_configuration'] = array( "smtp.host"     => "smtp.yandex.ru",
                                                "smtp.username" => "user_name",
                                                "smtp.password" => "your_app_password",
                                                "smtp.secure"   => "ssl",
                                                "smtp.port"   	=> "465",
                                                "address.from"  => "user_name@yandex.ru"
                                            );
    */                                            
