#!/bin/sh

NOTES="/mnt/onboard/.adds/notes"
EXPORT="/mnt/onboard/Exported Annotations/Notes.md"

DB="/mnt/onboard/.kobo/KoboReader.sqlite"
SQLITE="${NOTES}/sqlite3"

KC_HOME="/usr/local/kobocloud"
CURL="$KC_HOME/curl --cacert $KC_HOME/ca-bundle.crt --fail --silent"
HEADER="X-Requested-With: XMLHttpRequest"
URL="[Your Nextcloud/Owncloud instance]/public.php/webdav"
USER="[Your Share]:"

LD_LIBRARY_PATH="${NOTES}/lib:${LD_LIBRARY_PATH}"
export LD_LIBRARY_PATH

mkdir -p "$(dirname "$EXPORT")"

echo -e "# Kobo Notes\n" > $EXPORT
echo -e "*$(date -R)*\n" >> $EXPORT
echo -e "## Highlights\n" >> $EXPORT

# UTF-8 char table (decimal):
#    9: Tab
#   10: Line feed
#   32: Space
#   58: :
#   62: >
# 8230: …

SQL="SELECT TRIM(
  '### ' || c1.Title || ', ' || COALESCE(c1.Attribution, 'N/A') || char(10)
  || c.Title || char(10, 62, 32)
  || REPLACE( /* start Markdown quote */
    REPLACE(
      TRIM(           /* trim newlines */
        TRIM(         /* trim tabs */
          TRIM(b.Text), /* trim spaces */
          char(9)
        ),
        char(10)
      ),
      char(9), ''
    ),
    char(10), char(10, 62, 32, 10, 62, 32)) /* continue Markdown quote for multiple paragraphs */
  || char(10, 10)
  || b.Annotation, char(10)
  ) || char(10)
  FROM Bookmark b
    JOIN Content c on b.VolumeID = c.BookID
    JOIN Content c1 ON c.BookID = c1.ContentID
  WHERE (b.Type = 'highlight' OR b.Type = 'note')
    AND b.Hidden = 'false'
    AND c.ContentID LIKE b.ContentID || '-%'
  ORDER BY c.Title ASC, c.VolumeIndex, b.DateCreated ASC;"

$SQLITE "$DB" "$SQL" >> $EXPORT

echo -e "## Dogears\n" >> $EXPORT

SQL="SELECT
  '### ' || c.BookTitle || ', ' || COALESCE(c1.Attribution, 'N/A') || char(10)
  || c.Title || char(10, 62, 32)
  || ContextString || char(8230, 10)
  FROM Bookmark b
    JOIN Content c on b.VolumeID = c.BookID
    JOIN Content c1 ON c.BookID = c1.ContentID
  WHERE b.Type ='dogear'
    AND b.Hidden = 'false'
    AND c.ContentID LIKE b.ContentID || '-%'
  ORDER BY c.Title ASC, c.VolumeIndex, b.DateCreated ASC;"

$SQLITE "$DB" "$SQL" >> $EXPORT

echo -e "## Book progress\n" >> $EXPORT

echo -e "Currently reading:\n" >> $EXPORT

SQL="SELECT
  '- ' || Title || ', ' || COALESCE(Attribution, 'N/A') || ' (' || ___PercentRead || '% read)'
  FROM content
  WHERE ContentType = 6
    AND ReadStatus = 1
    AND IsDownloaded = 'true'
  ORDER BY ___PercentRead DESC, Title ASC, Attribution ASC;"

$SQLITE "$DB" "$SQL" >> $EXPORT

DATE=$(date "+%Y-%m-%d-%H-%M-%S")
$CURL -u "$USER" -H "$HEADER" -T "$EXPORT" "$URL/notes-$DATE.md"
