#!/bin/sh

NOTES="/mnt/onboard/.adds/notes"

DB="/mnt/onboard/.kobo/KoboReader.sqlite"
SQLITE="${NOTES}/sqlite3"

KC_HOME="/usr/local/kobocloud"
CURL="$KC_HOME/curl --cacert $KC_HOME/ca-bundle.crt --fail --silent"
HEADER="X-Requested-With: XMLHttpRequest"
URL="[Your Nextcloud/Owncloud instance]/public.php/webdav"
USER="[Your Share]:"

LD_LIBRARY_PATH="${NOTES}/lib:${LD_LIBRARY_PATH}"
export LD_LIBRARY_PATH

TMP="$(mktemp)" || exit 1

echo -e "# Kobo Notes\n" > $TMP

echo -e "## Highlights\n" >> $TMP

SQL="SELECT TRIM(
  '### ' || Title || ', ' || COALESCE(Attribution, 'N/A') || char(10)
  || '> ' || REPLACE(
    REPLACE(
      TRIM(           /* trim newlines */
        TRIM(         /* trim tabs */
          TRIM(Text), /* trim spaces */
          char(9)
        ),
        char(10)
      ),
      char(9), ''
    ),
    char(10), char(10) || '> ' || char(10) || '> ')
  || char(10, 10)
  || Annotation, char(10)
  ) || char(10)
  FROM Bookmark
  INNER JOIN content ON content.ContentID = Bookmark.VolumeID
  WHERE Type = 'highlight' OR Type = 'note'
  ORDER BY Title ASC, Bookmark.DateCreated ASC;"

$SQLITE "$DB" "$SQL" >> $TMP

echo -e "## Dogears\n" >> $TMP

SQL="SELECT
  '### ' || Title || ', ' || COALESCE(Attribution, 'N/A') || char(10)
  || 'Dogear at:' || char(10)
  || '> ' || ContextString || '…'
  || char(10)
  FROM Bookmark
  INNER JOIN content ON content.ContentID = Bookmark.VolumeID
  WHERE Type = 'dogear'
  ORDER BY Title ASC, Bookmark.DateCreated ASC;"

$SQLITE "$DB" "$SQL" >> $TMP

echo -e "## Book progress\n" >> $TMP

echo -e "Currently reading:\n" >> $TMP

SQL="SELECT
  '- ' || Title || ', ' || COALESCE(Attribution, 'N/A') || ' (' || ___PercentRead || '% read)'
  FROM content
  WHERE ContentType = 6 AND ReadStatus = 1 AND IsDownloaded = 'true'
  ORDER BY ___PercentRead DESC, Title ASC, Attribution ASC;"

$SQLITE "$DB" "$SQL" >> $TMP

DATE=$(date "+%Y-%m-%d-%H-%M-%S")
$CURL -u "$USER" -H "$HEADER" -T "$TMP" "$URL/notes-$DATE.md"

rm $TMP
