#!/usr/bin/env python
from calibre_plugins.Adlibris.common_utils import KeyValueComboBox
from collections import OrderedDict
from calibre.utils.config import JSONConfig
from calibre.gui2.metadata.config import ConfigWidget as DefaultConfigWidget
from PyQt5.Qt import QLabel, QGridLayout, QGroupBox, QHBoxLayout, QComboBox, QVBoxLayout
from PyQt5 import Qt as QtGui

__license__ = "GPL v3"
__copyright__ = "2022, J-H, based on the Barnes work Pr.BarnArt and Grant Drake"
__docformat__ = "restructuredtext en"

STORE_NAME = "Options"
KEY_MAX_DOWNLOADS = "maxDownloads"
COUNTRY = "country"

DEFAULT_STORE_VALUES = {KEY_MAX_DOWNLOADS: 1, COUNTRY: "/fi/haku?q="}

COUNTRIES = OrderedDict(
    [("/fi/haku?q=", "Finland"), ("/no/sok?q=", "Norway"), ("/se/sok?q=", "Sweden")]
)

# This is where all preferences for this plugin will be stored
plugin_prefs = JSONConfig("plugins/Adlibris")

# Set defaults
plugin_prefs.defaults[STORE_NAME] = DEFAULT_STORE_VALUES


class ConfigWidget(DefaultConfigWidget):
    def __init__(self, plugin):
        DefaultConfigWidget.__init__(self, plugin)
        c = plugin_prefs[STORE_NAME]

        other_group_box = QGroupBox("Other options", self)
        self.l.addWidget(other_group_box, self.l.rowCount(), 0, 2, 0)
        other_group_box_layout = QVBoxLayout()
        other_group_box.setLayout(other_group_box_layout)

        max_label = QLabel(
            "Maximum title/author search matches to evaluate (1 = fastest):", self
        )
        max_label.setToolTip(
            "Adlibris does not always have links to large covers for every ISBN\n"
            "of the same book. Increasing this value will take effect when doing\n"
            "title/author searches to consider more ISBN editions.\n\n"
            "This will increase the potential likelihood of getting a larger cover\n"
            "though does not guarantee it."
        )
        other_group_box_layout.addWidget(max_label)
        self.max_downloads_spin = QtGui.QSpinBox(self)
        self.max_downloads_spin.setMinimum(1)
        self.max_downloads_spin.setMaximum(5)
        self.max_downloads_spin.setProperty(
            "value", c.get(KEY_MAX_DOWNLOADS, DEFAULT_STORE_VALUES[KEY_MAX_DOWNLOADS])
        )
        other_group_box_layout.addWidget(self.max_downloads_spin)

        genre_layout = QHBoxLayout()
        other_group_box_layout.addLayout(genre_layout)

        genre_label = QLabel("Download from Adlibris ", self)
        genre_label.setToolTip(
            "Choose the Adlibris site from which\nyou want to download the metadata."
        )
        genre_layout.addWidget(genre_label)
        self.genreCombo = KeyValueComboBox(
            self, COUNTRIES, c.get(COUNTRY, "/fi/haku?q=")
        )
        genre_layout.addWidget(self.genreCombo)

    def commit(self):
        DefaultConfigWidget.commit(self)
        new_prefs = {}
        new_prefs[KEY_MAX_DOWNLOADS] = int(str(self.max_downloads_spin.value()))
        new_prefs[COUNTRY] = self.genreCombo.selected_key()
        plugin_prefs[STORE_NAME] = new_prefs
