#!/usr/bin/env python
# vim:fileencoding=UTF-8:ts=4:sw=4:sta:et:sts=4:ai


__license__   = 'GPL v3'
__copyright__ = '2020, Bradles'
__docformat__ = 'restructuredtext en'

if False:
    # This is here to keep my python error checker from complaining about
    # the builtin functions that will be defined by the plugin loading system
    # You do not need this code in your plugins
    get_icons = get_resources = None

try:
    from qt.core import Qt, QApplication, QAbstractSlider
except ImportError:
    from PyQt5.Qt import QApplication, QAbstractSlider

# The class that all interface action plugins must inherit from
from calibre.gui2.actions import InterfaceAction

class ScrollDetailsPlugin(InterfaceAction):

    name = 'Scroll Book Details'

    # Declare the main action associated with this plugin
    # The keyboard shortcut can be None if you dont want to use a keyboard
    # shortcut. Remember that currently calibre has no central management for
    # keyboard shortcuts, so try to use an unusual/unused shortcut.
    action_spec = ('Scroll Book Details', None,
            'Scroll through the book details', ('Space','Shift+Space'))

    def genesis(self):
        # This method is called once per plugin, do initial setup here

        # Set the icon for this interface action
        # The get_icons function is a builtin function defined for all your
        # plugin code. It loads icons from the plugin zip file. It returns
        # QIcon objects, if you want the actual data, use the analogous
        # get_resources builtin function.
        #
        # Note that if you are loading more than one icon, for performance, you
        # should pass a list of names to get_icons. In this case, get_icons
        # will return a dictionary mapping names to QIcons. Names that
        # are not found in the zip file will result in null QIcons.
        icon = get_icons('images/icon.png')

        # The qaction is automatically created from the action_spec defined
        # above
        self.qaction.setIcon(icon)
        self.qaction.triggered.connect(self.scroll_details)

    def scroll_details(self):
        # The base plugin object defined in __init__.py
        base_plugin_object = self.interface_action_base_plugin

        # self.gui is the main calibre GUI. It acts as the gateway to access
        # all the elements of the calibre user interface, it should also be the
        # parent of the dialog
        
        # Get the scroll bar from the QTextBrowser
        vsb = self.gui.book_details.book_info.verticalScrollBar()

        # Determine if Shift key is pressed. Hopefully the user hasn't configured Shift+Something as their preferred shortcut.
        modifiers = QApplication.keyboardModifiers()
        
        # Scroll down
        if modifiers != Qt.ShiftModifier:
            vsb.triggerAction(QAbstractSlider.SliderAction.SliderPageStepAdd)

            # PageStepAdd is just a smidgen too far, so also scroll back one single step (if we're not already at the end).
            # NB: Changing the page step using setPageStep() is not ideal, as it continually
            #     shrinks the page step on every scroll.
            if vsb.value() < vsb.maximum():
                vsb.triggerAction(QAbstractSlider.SliderAction.SliderSingleStepSub)
        else:
            vsb.triggerAction(QAbstractSlider.SliderAction.SliderPageStepSub)

            # PageStepSub is just a smidgen too far, so also scroll down one single step (if we're not already at the start).
            if vsb.value() > 0:
                vsb.triggerAction(QAbstractSlider.SliderAction.SliderSingleStepAdd)
