#!/usr/bin/env python

__license__   = 'GPL v3'
__copyright__ = 'Bob McBobberson'
__docformat__ = 'restructuredtext en'

from PyQt5.Qt import QWidget, QHBoxLayout, QLabel, QLineEdit

from calibre.utils.config import JSONConfig

# This is where all preferences for this plugin will be stored
# Remember that this name (i.e. plugins/interface_demo) is also
# in a global namespace, so make it as unique as possible.
# You should always prefix your config file name with plugins/,
# so as to ensure you dont accidentally clobber a calibre config file
prefs = JSONConfig('plugins/CalibreCV')

# Set defaults
prefs.defaults['cv_api_key'] = 'INSERT YOUR API KEY HERE'
prefs.defaults['cv_api_delay'] = '1000'
prefs.defaults['cc_mode'] = 0
prefs.defaults['name_from_cv'] = bool(1)

class ConfigWidget(QWidget):

    def __init__(self):
        QWidget.__init__(self)
        self.l = QHBoxLayout()
        self.setLayout(self.l)

        self.label = QLabel('Comic Vine API Key:')
        self.l.addWidget(self.label)

        self.msg = QLineEdit(self)
        self.msg.setText(prefs['cv_api_key'])
        self.msg.setFixedWidth(400)
        self.l.addWidget(self.msg)
        self.label.setBuddy(self.msg)

        self.labelCVAPIDelay = QLabel('Comic Vine API Delay (ms):')
        self.l.addWidget(self.labelCVAPIDelay)

        self.CVAPIDelay = QLineEdit(self)
        self.CVAPIDelay.setText(prefs['cv_api_delay'])
        self.l.addWidget(self.CVAPIDelay)
        self.labelCVAPIDelay.setBuddy(self.labelCVAPIDelay)

    def save_settings(self):
        prefs['cv_api_key'] = self.msg.text()
        prefs['cv_api_delay'] = self.CVAPIDelay.text()
        prefs['name_from_cv'] = self.getChecked()