﻿/****************************************************************************
*
* SAMPLE: LZSS Library
* Copyright (C) 2004, 2006, 2007 by
* Michael Dipperstein (mdipper@alumni.engr.ucsb.edu)
*
* This file is part of the lzss library.
*
* The lzss library is free software; you can redistribute it and/or
* modify it under the terms of the GNU Lesser General Public License as
* published by the Free Software Foundation; either version 3 of the
* License, or (at your option) any later version.
*
* The lzss library is distributed in the hope that it will be useful, but
* WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Lesser
* General Public License for more details.
*
* You should have received a copy of the GNU Lesser General Public License
* along with this program.  If not, see <http://www.gnu.org/licenses/>.
*
*
* RES File Text Decompression algorithm is tweak by Nick Rapallo and
* Michael Scott.  The changes to the original algorithm by 
* Michael Dipperstein are made this IMP Decompression specifically
*
*
*
***************************************************************************/

using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;

using System.IO;

namespace ConvertIMPGUI
{
    public partial class frmMain : Form
    {
        CIMPFile impFile = null;

        #region Constructor
        public frmMain()
        {
            InitializeComponent();
        }
        #endregion

        #region mnuFile_Exit
        private void mnuFile_Exit_Click(object sender, EventArgs e)
        {
            this.Close();
        }
        #endregion

        #region btnInputFileBrowse
        private void btnInputFileBrowse_Click(object sender, EventArgs e)
        {
            openDlg.FileName = "";
            if (openDlg.ShowDialog() == DialogResult.OK)
            {
                folderDlg.SelectedPath = openDlg.FileName.Substring(0, openDlg.FileName.LastIndexOf(@"\") + 1);
                txtOutputDirectory.Text = folderDlg.SelectedPath;
                txtInputFilePath.Text = openDlg.FileName;

                Cursor = Cursors.WaitCursor;
                Application.DoEvents();

                impFile = new CIMPFile(txtInputFilePath.Text);
                impFile.ReverseIMP();

                txtOutputFileName.Text = impFile.BookProperties.FirstName + " - " + impFile.BookProperties.Title + ".txt";
                LoadIMPTree();

                txtOutputDirectory.Enabled = true;
                txtOutputFileName.Enabled = true;
                btnOutputDirectory.Enabled = true;
                IMPTree.Enabled = true;
                txtContent.Enabled = true;

                Cursor = Cursors.Default;
                Application.DoEvents();
            }
        }
        #endregion

        #region btnOutputDirectory
        private void btnOutputDirectory_Click(object sender, EventArgs e)
        {
            if (folderDlg.ShowDialog() == DialogResult.OK)
            {
                txtOutputDirectory.Text = folderDlg.SelectedPath;
            }
        }
        #endregion

        #region LoadIMPTree
        private void LoadIMPTree()
        {
            IMPTree.Nodes.Clear();

            TreeNode headerNode = IMPTree.Nodes.Add("Header");
            TreeNode bookNode = IMPTree.Nodes.Add("Book");
            TreeNode tocNode = IMPTree.Nodes.Add("Table Of Contents");
            TreeNode swIndexesNode = IMPTree.Nodes.Add("SW Indexes");
            TreeNode imagesNode = IMPTree.Nodes.Add("Images");

            #region Header Display
            headerNode.Nodes.Add("IMP Version " + impFile.Header.version);

            if (impFile.Header.compression)
                headerNode.Nodes.Add("Compressed");
            else
                headerNode.Nodes.Add("UnCompressed");

            if (impFile.Header.encryption)
                headerNode.Nodes.Add("Encrypted");
            else
                headerNode.Nodes.Add("UnEncrypted");
            #endregion

            #region Book Display
            bookNode.Nodes.Add("Category (" + impFile.BookProperties.Bookshelf_Category + ")");
            bookNode.Nodes.Add("Title (" + impFile.BookProperties.Title + ")");
            bookNode.Nodes.Add("Author First Name (" + impFile.BookProperties.FirstName + ")");
            bookNode.Nodes.Add("Author Middle Name (" + impFile.BookProperties.MiddleName + ")");
            bookNode.Nodes.Add("Author Last Name (" + impFile.BookProperties.LastName + ")");
            bookNode.Nodes.Add("ID (" + impFile.BookProperties.ID + ")");
            #endregion

            #region TOC Display
            foreach (IMPTableContentsItem item in impFile.TableOfContents.table)
            {
                TreeNode tocItem = tocNode.Nodes.Add("TOC File (" + item.fileName + ")");
                tocItem.Nodes.Add("File Type (" + item.fileType + ")");
                tocItem.Nodes.Add("File Size (" + item.fileSize + " bytes)");
            }
            #endregion

            #region SWIndexes Display
            foreach (SWIndex item in impFile.SWIndexes)
            {
                TreeNode swItem = swIndexesNode.Nodes.Add("Index (" + item.fileType + ")");
            }
            #endregion

            #region Image Display
            int imageIndex = 1;
            foreach (IMPRESFile resFile in impFile.RESFiles.list)
            {
                if (resFile.fileType == "PNG")
                {
                    TreeNode imageNode = imagesNode.Nodes.Add("Image " + imageIndex);
                    imageNode.Tag = resFile;
                }
            }
            #endregion
        }
        #endregion

        #region btnProcessText
        private void btnProcessText_Click(object sender, EventArgs e)
        {
            pnlImage.Visible = false;
            txtContent.Visible = true;

            MessageBox.Show("May take a while depending on size of IMP File");

            Cursor = Cursors.WaitCursor;
            Application.DoEvents();

            impFile.ReverseResourceFile();

            txtContent.Text = impFile.Content;

            Cursor = Cursors.Default;
            Application.DoEvents();
        }
        #endregion

        #region IMPTree_AfterSelect
        private void IMPTree_AfterSelect(object sender, TreeViewEventArgs e)
        {
            if (e.Node.Text.StartsWith("Image "))
            {
                pnlImage.Visible = true;
                txtContent.Visible = false;
                IMPRESFile resImage = (IMPRESFile)e.Node.Tag;
                MemoryStream ms = impFile.GetImage(ref resImage);
                Image img = Image.FromStream(ms);
                imageBox.Image = img;
            }
        }
        #endregion
    }
}
