﻿using System;
using System.Collections.Generic;
using System.Text;

namespace ConvertIMPGUI
{
    #region Class IMPHeader
    class IMPHeader
    {
        public int version = 0;
        public string constant = "";
        public string unknown = "";
        public int fileCount = 0;
        public int dictionaryLength = 0;
        public int bytesRemaining = 0;
        public string unknown2 = "";
        public string unknown3 = "";
        public bool compression = false;
        public bool encryption = false;
        public int zoomState = 0;
        public string unknown4 = "";

        #region ToString
        public override string ToString()
        {
            string _toString = "";

            _toString += "Version = " + version + "\n";
            _toString += "Constant = " + constant + "\n";
            _toString += "FileCount = " + fileCount.ToString() + "\n";
            _toString += "DictionaryLength = " + dictionaryLength.ToString() + "\n";
            _toString += "BytesRemainingInHeader = " + bytesRemaining.ToString() + "\n";
            _toString += "Compression = " + compression.ToString() + "\n";
            _toString += "Encryption = " + encryption.ToString() + "\n";
            _toString += "ZoomState = " + zoomState.ToString() + "\n";
            _toString += "Unknown = " + unknown.Trim() + "\n";
            _toString += "Unknown = " + unknown2.Trim() + "\n";
            _toString += "Unknown = " + unknown3.Trim() + "\n";
            _toString += "Unknown = " + unknown4.Trim() + "\n";

            return _toString;
        }
        #endregion
    }
    #endregion

    #region Class IMPBookProperties
    class IMPBookProperties
    {
        public string ID = "";
        public string Bookshelf_Category = "";
        public string Subcategory = "";
        public string Title = "";
        public string LastName = "";
        public string MiddleName = "";
        public string FirstName = "";
        public string ResFile = "";

        #region ToString
        public override string ToString()
        {
            string _toString = "";

            _toString += "ID = " + ID + "\n";
            _toString += "Bookshelf_Category = " + Bookshelf_Category + "\n";
            _toString += "Subcategory = " + Subcategory + "\n";
            _toString += "Title = " + Title + "\n";
            _toString += "LastName = " + LastName + "\n";
            _toString += "MiddleName = " + MiddleName + "\n";
            _toString += "FirstName = " + FirstName + "\n";
            _toString += "ResFile = " + ResFile + "\n";

            return _toString;
        }
        #endregion
    }
    #endregion

    #region Class IMPTableContents
    class IMPTableContents
    {
        public List<IMPTableContentsItem> table = new List<IMPTableContentsItem>();
    }
    #endregion

    #region Class IMPTableContentsItem
    class IMPTableContentsItem
    {
        public string fileName = "";
        public int fileSize = 0;
        public string fileType = "";

        #region ToString
        public override string ToString()
        {
            string _toString = "";

            _toString += "FileName = " + fileName + "\n";
            _toString += "FileSize = " + fileSize.ToString() + "\n";
            _toString += "FileType = " + fileType + "\n";

            return _toString;
        }
        #endregion
    }
    #endregion

    #region Class IMPRESFiles
    class IMPRESFiles
    {
        public List<IMPRESFile> list = new List<IMPRESFile>();
    }
    #endregion

    #region Class IMPRESFile
    class IMPRESFile
    {
        public string fileName = "";
        public int fileSize = 0;
        public string fileType = "";
        public int currentPosition = 0;
        public byte[] buffer = null;

        #region ToString
        public override string ToString()
        {
            string _toString = "";

            _toString += "FileName = " + fileName + "\n";
            _toString += "FileSize = " + fileSize.ToString() + "\n";
            _toString += "FileType = " + fileType + "\n";

            return _toString;
        }
        #endregion
    }
    #endregion

    #region Class SWIndex
    class SWIndex
    {
        public string fileType = "";
        public int indexConstant = 0;
        public int offsetToStartOfIndex = 0;
        public int lengthOfIndex = 0;
        public int sequenceNumber = 0;
        public int[] sequenceNumbers = null;
    }
    #endregion

    #region Class CMInfo
    class CMInfo
    {
        public int Index1 = 0;
        public int Index2 = 0;
        public int RecordLength1 = 0;
        public int RecordLength2 = 0;
        public int OffsetToStartOfRecord1 = 0;
        public int OffsetToStartOfRecord2 = 0;

        public int UncompressedDataPosition = 0;
        public int CompressedDataPosition = 0;
        public int bitPosPastBytePosInCompressedData = 0;
    }
    #endregion

    #region Class CMIndex
    class CMIndex
    {
        public int UncompressedDataPosition = 0;
        public int CompressedDataPosition = 0;
        public int bitPosPastBytePosInCompressedData = 0;
    }
    #endregion
}
