#!/bin/sh

ARTICLES="/mnt/onboard/.kobo/articles"
CONVERT="/mnt/onboard/.adds/pocket/convert -limit time 60"
IDENTIFY="/mnt/onboard/.adds/pocket/identify -limit time 60 -quiet"

LD_LIBRARY_PATH="/mnt/onboard/.adds/pocket/lib:${LD_LIBRARY_PATH}"
export LD_LIBRARY_PATH

for i in $(find $ARTICLES -type f -not -iname "*.html"); do
  FORMAT=$($IDENTIFY -format "%m" "$i")
  if [ "$FORMAT" == "PNG" ]; then
    echo "Converting $i"
    $CONVERT "$i" "$i.jpg"
    if [ $? -eq 0 ]; then
      mv "$i.jpg" "${i%.jpg}"
    fi
  fi
done
