#!/bin/sh

ARTICLES="/mnt/onboard/.kobo/articles"
CONVERT="/mnt/onboard/.adds/pocket/convert"
IDENTIFY="/mnt/onboard/.adds/pocket/identify -quiet"

LD_LIBRARY_PATH="/mnt/onboard/.adds/pocket/lib:${LD_LIBRARY_PATH}"
export LD_LIBRARY_PATH

for i in $(find $ARTICLES -type f -not -iname "*.html"); do
  FORMAT=$($IDENTIFY -format "%m" "$i")
  if [ "$FORMAT" == "PNG" ]; then
    echo "Converting $i"
    $CONVERT "$i" "$i.jpg"
    mv "$i.jpg" "${i%.jpg}"
  fi
done
