/*
 * Decompiled with CFR 0.152.
 */
package com.acunia.wonka.appletviewer;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.security.CodeSource;
import java.security.PermissionCollection;
import java.security.Permissions;
import java.util.HashMap;
import java.util.StringTokenizer;
import java.util.Vector;

public class AppletClassLoader
extends URLClassLoader {
    private HashMap permissions;

    static AppletClassLoader createAppletClassLoader(URL codebase, URL documentbase, String archives) throws IOException {
        Vector<URL> urls = new Vector<URL>(16);
        if (archives != null) {
            StringTokenizer stk = new StringTokenizer(archives, ",");
            while (stk.hasMoreTokens()) {
                try {
                    URL url = new URL(documentbase, stk.nextToken());
                    urls.add(new URL("jar:" + url.toString() + "!/"));
                }
                catch (MalformedURLException murle) {
                    // empty catch block
                }
            }
        }
        if (codebase != documentbase) {
            urls.add(codebase);
        }
        urls.add(documentbase);
        System.out.println(urls);
        URL[] bases = new URL[urls.size()];
        urls.toArray(bases);
        return new AppletClassLoader(bases);
    }

    protected PermissionCollection getPermissions(CodeSource cs) {
        Object o = this.permissions.get(cs);
        if (o != null) {
            return (PermissionCollection)o;
        }
        throw new SecurityException("AppletClassLoader cannot give permissions to unknown CodeSource " + cs);
    }

    private AppletClassLoader(URL[] bases) throws IOException {
        super(bases);
        this.permissions = new HashMap(bases.length);
        int i = 0;
        while (i < bases.length) {
            Permissions p = new Permissions();
            p.add(bases[i].openConnection().getPermission());
            this.permissions.put(new CodeSource(bases[i], null), p);
            ++i;
        }
    }
}

