/*
 * Decompiled with CFR 0.152.
 */
package gnu.testlet.wonka.util.WeakHashMap;

import gnu.testlet.TestHarness;
import gnu.testlet.Testlet;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import java.util.WeakHashMap;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class AcuniaWeakHashMapTest
implements Testlet {
    protected TestHarness th;
    protected Vector keys;
    private final String st = "a";
    private final Byte b;
    private final Short sh;
    private final Integer i;
    private final Long l;
    private int sqnce;

    public void test(TestHarness harness) {
        this.th = harness;
        this.th.setclass("java.util.WeakHashMap");
        this.test_WeakHashMap();
        this.test_get();
        this.test_containsKey();
        this.test_containsValue();
        this.test_isEmpty();
        this.test_size();
        this.test_clear();
        this.test_put();
        this.test_putAll();
        this.test_remove();
        this.test_entrySet();
        this.test_keySet();
        this.test_values();
        this.test_WeakRefBehaviour();
    }

    protected WeakHashMap buildHM() {
        WeakHashMap<String, String> hm = new WeakHashMap<String, String>();
        this.keys = new Vector(16);
        int i = 0;
        while (i < 15) {
            String s = "a" + i;
            hm.put(s, s + " value");
            this.keys.add(s);
            ++i;
        }
        hm.put(null, null);
        this.keys.add(null);
        return hm;
    }

    public void test_WeakHashMap() {
        this.th.checkPoint("WeakHashMap(int)");
        WeakHashMap hm = new WeakHashMap(1);
        try {
            new WeakHashMap(-1);
            this.th.fail("should throw an IllegalArgumentException");
        }
        catch (IllegalArgumentException iae) {
            this.th.check(true);
        }
        this.th.checkPoint("WeakHashMap(int,float)");
        try {
            new WeakHashMap(-1, 0.1f);
            this.th.fail("should throw an IllegalArgumentException -- 1");
        }
        catch (IllegalArgumentException iae) {
            this.th.check(true);
        }
        try {
            new WeakHashMap(1, -0.1f);
            this.th.fail("should throw an IllegalArgumentException -- 2");
        }
        catch (IllegalArgumentException iae) {
            this.th.check(true);
        }
        try {
            new WeakHashMap(1, 0.0f);
            this.th.fail("should throw an IllegalArgumentException -- 2");
        }
        catch (IllegalArgumentException iae) {
            this.th.check(true);
        }
    }

    public void test_get() {
        this.th.checkPoint("get(java.lang.Object)java.lang.Object");
        WeakHashMap hm = this.buildHM();
        boolean bl = false;
        if (hm.get(null) == null) {
            bl = true;
        }
        this.th.check(bl, "checking get -- 1");
        boolean bl2 = false;
        if (hm.get(this) == null) {
            bl2 = true;
        }
        this.th.check(bl2, "checking get -- 2");
        hm.put("a", this);
        this.th.check("a1 value".equals(hm.get("a1")), "checking get -- 3");
        this.th.check("a11 value".equals(hm.get("a11")), "checking get -- 4");
        boolean bl3 = false;
        if (hm.get(new Integer(97)) == null) {
            bl3 = true;
        }
        this.th.check(bl3, "checking get -- 5");
    }

    public void test_containsKey() {
        this.th.checkPoint("containsKey(java.lang.Object)boolean");
        WeakHashMap hm = new WeakHashMap();
        hm.clear();
        this.th.check(hm.containsKey(null) ^ true, "Map is empty");
        hm.put("a", this);
        this.th.check(hm.containsKey(null) ^ true, "Map does not containsthe key -- 1");
        this.th.check(hm.containsKey("a"), "Map does contain the key -- 2");
        hm = this.buildHM();
        this.th.check(hm.containsKey(null), "Map does contain the key -- 3");
        this.th.check(hm.containsKey(this) ^ true, "Map does not contain the key -- 4");
    }

    public void test_containsValue() {
        this.th.checkPoint("containsValue(java.lang.Object)boolean");
        WeakHashMap hm = new WeakHashMap();
        hm.clear();
        this.th.check(hm.containsValue(null) ^ true, "Map is empty");
        hm.put("a", this);
        this.th.check(hm.containsValue(null) ^ true, "Map does not containsthe value -- 1");
        this.th.check(hm.containsValue("a") ^ true, "Map does  not contain the value -- 2");
        this.th.check(hm.containsValue(this), "Map does contain the value -- 3");
        hm = this.buildHM();
        this.th.check(hm.containsValue(null), "Map does contain the value -- 4");
        this.th.check(hm.containsValue(this) ^ true, "Map does not contain the value -- 5");
        this.th.check(hm.containsValue("a1value") ^ true, "Map does  not contain the value -- 6");
    }

    public void test_isEmpty() {
        this.th.checkPoint("isEmpty()boolean");
        WeakHashMap<String, AcuniaWeakHashMapTest> hm = new WeakHashMap<String, AcuniaWeakHashMapTest>();
        this.th.check(hm.isEmpty(), "Map is empty");
        hm.put("a", this);
        this.th.check(hm.isEmpty() ^ true, "Map is not empty");
    }

    public void test_size() {
        this.th.checkPoint("size()int");
        WeakHashMap hm = new WeakHashMap();
        boolean bl = false;
        if (hm.size() == 0) {
            bl = true;
        }
        this.th.check(bl, "Map is empty");
        hm.put("a", this);
        boolean bl2 = false;
        if (hm.size() == 1) {
            bl2 = true;
        }
        this.th.check(bl2, "Map has 1 element");
        hm = this.buildHM();
        boolean bl3 = false;
        if (hm.size() == 16) {
            bl3 = true;
        }
        this.th.check(bl3, "Map has 16 elements");
    }

    public void test_clear() {
        this.th.checkPoint("clear()void");
        WeakHashMap hm = this.buildHM();
        hm.clear();
        boolean bl = false;
        if (hm.size() == 0) {
            bl = true;
        }
        this.th.check(bl, "Map is cleared -- 1");
        this.th.check(hm.isEmpty(), "Map is cleared -- 2");
    }

    public void test_put() {
        this.th.checkPoint("put(java.lang.Object,java.lang.Object)java.lang.Object");
        WeakHashMap<String, Object> hm = new WeakHashMap<String, Object>();
        boolean bl = false;
        if (hm.put(null, this) == null) {
            bl = true;
        }
        this.th.check(bl, "check on return value -- 1");
        boolean bl2 = false;
        if (hm.get(null) == this) {
            bl2 = true;
        }
        this.th.check(bl2, "check on value -- 1");
        boolean bl3 = false;
        if (hm.put(null, "a") == this) {
            bl3 = true;
        }
        this.th.check(bl3, "check on return value -- 2");
        this.th.check("a".equals(hm.get(null)), "check on value -- 2");
        this.th.check("a".equals(hm.put(null, "a")), "check on return value -- 3");
        this.th.check("a".equals(hm.get(null)), "check on value -- 3");
        boolean bl4 = false;
        if (hm.size() == 1) {
            bl4 = true;
        }
        this.th.check(bl4, "only one key added");
        boolean bl5 = false;
        if (hm.put("a", null) == null) {
            bl5 = true;
        }
        this.th.check(bl5, "check on return value -- 4");
        boolean bl6 = false;
        if (hm.get("a") == null) {
            bl6 = true;
        }
        this.th.check(bl6, "check on value -- 4");
        boolean bl7 = false;
        if (hm.put("a", this) == null) {
            bl7 = true;
        }
        this.th.check(bl7, "check on return value -- 5");
        boolean bl8 = false;
        if (hm.get("a") == this) {
            bl8 = true;
        }
        this.th.check(bl8, "check on value -- 5");
        boolean bl9 = false;
        if (hm.size() == 2) {
            bl9 = true;
        }
        this.th.check(bl9, "two keys added");
    }

    public void test_putAll() {
        this.th.checkPoint("putAll(java.util.Map)void");
        WeakHashMap<Object, Object> hm = new WeakHashMap<Object, Object>();
        hm.putAll(new Hashtable());
        this.th.check(hm.isEmpty(), "nothing addad");
        hm.putAll(this.buildHM());
        Vector store = this.keys;
        this.th.check(hm.size(), 16, "checking if all enough elements are added -- 1");
        this.th.check(hm, this.buildHM(), "check on all elements -- 1");
        hm.put(null, this);
        hm.putAll(this.buildHM());
        this.th.check(hm.size(), 16, "checking if all enough elements are added -- 2");
        store = this.keys;
        this.th.check(hm, this.buildHM(), "check on all elements -- 2");
        try {
            hm.putAll(null);
            this.th.fail("should throw a NullPointerException");
        }
        catch (NullPointerException npe) {
            this.th.check(true);
        }
    }

    public void test_remove() {
        this.th.checkPoint("remove(java.lang.Object)java.lang.Object");
        WeakHashMap hm = this.buildHM();
        boolean bl = false;
        if (hm.remove(null) == null) {
            bl = true;
        }
        this.th.check(bl, "checking return value -- 1");
        boolean bl2 = false;
        if (hm.remove(null) == null) {
            bl2 = true;
        }
        this.th.check(bl2, "checking return value -- 2");
        this.th.check(hm.containsKey(null) ^ true, "checking removed key -- 1");
        this.th.check(hm.containsValue(null) ^ true, "checking removed value -- 1");
        int i = 0;
        while (i < 15) {
            this.th.check(("a" + i + " value").equals(hm.remove("a" + i)), " removing a" + i);
            ++i;
        }
        this.th.check(hm.isEmpty(), "checking if al is gone");
    }

    public void test_entrySet() {
        this.th.checkPoint("entrySet()java.util.Set");
        WeakHashMap hm = this.buildHM();
        Set s = hm.entrySet();
        Iterator it = s.iterator();
        Map.Entry me = null;
        it.next();
        try {
            s.add("ADDING");
            this.th.fail("should throw an UnsupportedOperationException");
        }
        catch (UnsupportedOperationException uoe) {
            this.th.check(true);
        }
        boolean bl = false;
        if (s.size() == 16) {
            bl = true;
        }
        this.th.check(bl);
        hm.remove("a12");
        boolean bl2 = false;
        if (s.size() == 15) {
            bl2 = true;
        }
        this.th.check(bl2);
        try {
            it.next();
            this.th.fail("should throw a ConcurrentModificationException -- 1");
        }
        catch (ConcurrentModificationException cme) {
            this.th.check(true);
        }
        try {
            it.remove();
            this.th.fail("should throw a ConcurrentModificationException -- 2");
        }
        catch (ConcurrentModificationException cme) {
            this.th.check(true);
        }
        it = s.iterator();
        try {
            me = it.next();
            if (me.getKey() == null) {
                me = it.next();
            }
            this.th.check(me.hashCode(), me.getValue().hashCode() ^ me.getKey().hashCode(), "verifying hashCode");
            this.th.check(me.equals(it.next()) ^ true);
        }
        catch (Exception e) {
            this.th.fail("got unwanted exception ,got " + e);
            this.th.debug("got ME key = " + me + " and value = " + me.getKey());
        }
        try {
            me.setValue(this);
            this.th.check(hm.get(me.getKey()), this, "set is supported");
        }
        catch (UnsupportedOperationException uoe) {
            this.th.fail("should not throw an UnsupportedOperationException");
        }
        it = s.iterator();
        Vector v = new Vector();
        v.addAll(s);
        while (it.hasNext()) {
            Map.Entry ob = it.next();
            it.remove();
            if (v.remove(ob)) continue;
            this.th.debug("Object " + ob + " not in the Vector");
        }
        this.th.check(v.isEmpty(), "all elements gone from the vector");
        this.th.check(hm.isEmpty(), "all elements removed from the WeakHashMap");
        it = s.iterator();
        hm.put(null, "sdf");
        try {
            it.next();
            this.th.fail("should throw a ConcurrentModificationException -- 3");
        }
        catch (ConcurrentModificationException cme) {
            this.th.check(true);
        }
        hm.put(null, "sdf");
        it = s.iterator();
        hm.clear();
        hm.put(null, "sdf");
        System.gc();
        this.th.check(hm.size(), 1, "checking null key");
        try {
            it.next();
            this.th.fail("should throw a ConcurrentModificationException -- 4");
        }
        catch (ConcurrentModificationException cme) {
            this.th.check(true);
        }
    }

    public void test_keySet() {
        this.th.checkPoint("keySet()java.util.Set");
        WeakHashMap hm = this.buildHM();
        boolean bl = false;
        if (hm.size() == 16) {
            bl = true;
        }
        this.th.check(bl, "checking map size(), got " + hm.size());
        Set s = null;
        try {
            s = hm.keySet();
            boolean bl2 = false;
            if (s != null) {
                bl2 = true;
            }
            this.th.check(bl2, "s != null");
            boolean bl3 = false;
            if (s.size() == 16) {
                bl3 = true;
            }
            this.th.check(bl3, "checking size keyset, got " + s.size());
            Object[] o = s.toArray();
            boolean bl4 = false;
            if (o != null) {
                bl4 = true;
            }
            this.th.check(bl4, "o != null");
            boolean bl5 = false;
            if (o.length == 16) {
                bl5 = true;
            }
            this.th.check(bl5, "checking length, got " + o.length);
            Iterator it = s.iterator();
            Vector v = new Vector();
            v.addAll(s);
            while (it.hasNext()) {
                Object ob = it.next();
                it.remove();
                if (v.remove(ob)) continue;
                this.th.debug("Object " + ob + " not in the Vector");
            }
            this.th.check(v.isEmpty(), "all elements gone from the vector");
            this.th.check(hm.isEmpty(), "all elements removed from the WeakHashMap");
        }
        catch (Exception e) {
            this.th.fail("got bad Exception -- got " + e);
        }
        try {
            s.add("ADDING");
            this.th.fail("should throw an UnsupportedOperationException");
        }
        catch (UnsupportedOperationException uoe) {
            this.th.check(true);
        }
    }

    public void test_values() {
        this.th.checkPoint("values()java.util.Collection");
        WeakHashMap hm = this.buildHM();
        boolean bl = false;
        if (hm.size() == 16) {
            bl = true;
        }
        this.th.check(bl, "checking map size(), got " + hm.size());
        Collection s = null;
        try {
            s = hm.values();
            boolean bl2 = false;
            if (s != null) {
                bl2 = true;
            }
            this.th.check(bl2, "s != null");
            boolean bl3 = false;
            if (s.size() == 16) {
                bl3 = true;
            }
            this.th.check(bl3, "checking size keyset, got " + s.size());
            Object[] o = s.toArray();
            boolean bl4 = false;
            if (o != null) {
                bl4 = true;
            }
            this.th.check(bl4, "o != null");
            boolean bl5 = false;
            if (o.length == 16) {
                bl5 = true;
            }
            this.th.check(bl5, "checking length, got " + o.length);
            Iterator it = s.iterator();
            Vector v = new Vector();
            v.addAll(s);
            while (it.hasNext()) {
                Object ob = it.next();
                it.remove();
                if (v.remove(ob)) continue;
                this.th.debug("Object " + ob + " not in the Vector");
            }
            this.th.check(v.isEmpty(), "all elements gone from the vector");
            this.th.check(hm.isEmpty(), "all elements removed from the WeakHashMap");
        }
        catch (Exception e) {
            this.th.fail("got bad Exception -- got " + e);
        }
        try {
            s.add("ADDING");
            this.th.fail("should throw an UnsupportedOperationException");
        }
        catch (UnsupportedOperationException uoe) {
            this.th.check(true);
        }
    }

    public void test_behaviour() {
        this.th.checkPoint("behaviour testing");
        this.do_behaviourtest(0.7f);
        this.do_behaviourtest(0.75f);
        this.do_behaviourtest(0.95f);
        this.do_behaviourtest(1.0f);
    }

    protected void sleep(int time) {
        try {
            Thread.sleep(time);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected void check_presence(WeakHashMap h) {
        boolean bl = false;
        if (h.get("a") != null) {
            bl = true;
        }
        this.th.check(bl, "checking presence st -- sequence " + this.sqnce);
        boolean bl2 = false;
        if (h.get(this.sh) != null) {
            bl2 = true;
        }
        this.th.check(bl2, "checking presence sh -- sequence " + this.sqnce);
        boolean bl3 = false;
        if (h.get(this.i) != null) {
            bl3 = true;
        }
        this.th.check(bl3, "checking presence i -- sequence " + this.sqnce);
        boolean bl4 = false;
        if (h.get(this.b) != null) {
            bl4 = true;
        }
        this.th.check(bl4, "checking presence b -- sequence " + this.sqnce);
        boolean bl5 = false;
        if (h.get(this.l) != null) {
            bl5 = true;
        }
        this.th.check(bl5, "checking presence l -- sequence " + this.sqnce);
        ++this.sqnce;
    }

    protected void do_behaviourtest(float loadFactor) {
        Float f;
        this.th.checkPoint("behaviour testing with loadFactor " + loadFactor);
        WeakHashMap<Object, Object> h = new WeakHashMap<Object, Object>(11, loadFactor);
        int j = 0;
        h.put("a", "a");
        h.put(this.b, "byte");
        h.put(this.sh, "short");
        h.put(this.i, "int");
        h.put(this.l, "long");
        this.check_presence(h);
        this.sqnce = 1;
        while (j < 100) {
            f = new Float(j);
            h.put(f, f);
            ++j;
        }
        boolean bl = false;
        if (h.size() == 105) {
            bl = true;
        }
        this.th.check(bl, "size checking -- 1 got: " + h.size());
        this.check_presence(h);
        while (j < 200) {
            f = new Float(j);
            h.put(f, f);
            ++j;
        }
        boolean bl2 = false;
        if (h.size() == 205) {
            bl2 = true;
        }
        this.th.check(bl2, "size checking -- 2 got: " + h.size());
        this.check_presence(h);
        while (j < 300) {
            f = new Float(j);
            h.put(f, f);
            ++j;
        }
        boolean bl3 = false;
        if (h.size() == 305) {
            bl3 = true;
        }
        this.th.check(bl3, "size checking -- 3 got: " + h.size());
        this.check_presence(h);
        this.th.check("a".equals(h.put("a", "na")), "replacing values -- 1 - st");
        this.th.check("byte".equals(h.put(this.b, "nbyte")), "replacing values -- 2 - b");
        this.th.check("short".equals(h.put(this.sh, "nshort")), "replacing values -- 3 -sh");
        this.th.check("int".equals(h.put(this.i, "nint")), "replacing values -- 4 -i");
        this.th.check("long".equals(h.put(this.l, "nlong")), "replacing values -- 5 -l");
        while (j > 199) {
            f = new Float(j);
            h.remove(f);
            --j;
        }
        boolean bl4 = false;
        if (h.size() == 205) {
            bl4 = true;
        }
        this.th.check(bl4, "size checking -- 4 got: " + h.size());
        this.check_presence(h);
        while (j > 99) {
            f = new Float(j);
            h.remove(f);
            --j;
        }
        boolean bl5 = false;
        if (h.size() == 105) {
            bl5 = true;
        }
        this.th.check(bl5, "size checking -- 5 got: " + h.size());
        this.check_presence(h);
        while (j > -1) {
            f = new Float(j);
            h.remove(f);
            --j;
        }
        boolean bl6 = false;
        if (h.size() == 5) {
            bl6 = true;
        }
        this.th.check(bl6, "size checking -- 6 got: " + h.size());
        this.th.debug(h.toString());
        this.check_presence(h);
    }

    public void test_WeakRefBehaviour() {
        Map.Entry entry;
        this.th.checkPoint("behaviour testing of 'null' key");
        WeakHashMap hm = this.buildHM();
        this.keys = null;
        hm.put(null, "abc");
        this.th.check(hm.get(null), "abc", "checking presence of 'null'");
        int i = 0;
        while (i < 10) {
            System.gc();
            if (hm.size() == 1) break;
            ++i;
        }
        this.th.check(hm.size(), 1, "only 'null' key should remain");
        this.th.checkPoint("behaviour testing of WeakReferences");
        hm = this.buildHM();
        hm.remove(null);
        Iterator it = hm.entrySet().iterator();
        int size = hm.size();
        while (it.hasNext()) {
            entry = it.next();
            this.keys.remove(entry.getKey());
            entry = null;
            System.gc();
            this.th.check(hm.size(), size--);
        }
        hm = this.buildHM();
        it = hm.entrySet().iterator();
        size = hm.size();
        while (it.hasNext()) {
            entry = it.next();
            it.remove();
            this.th.check(hm.size(), --size);
        }
        try {
            it.remove();
            this.th.fail("should throw an IllegalStateException");
        }
        catch (IllegalStateException ise) {
            this.th.check(true);
        }
        Integer key = new Integer(25);
        hm.clear();
        hm.put(key, key);
        key = new Integer(25);
        this.th.check(hm.put(key, "REMOVE ME"), key, "checking put");
        int i2 = 0;
        while (i2 < 10) {
            System.gc();
            if (hm.size() == 0) break;
            try {
                Thread.sleep(200L);
            }
            catch (InterruptedException ie) {
                // empty catch block
            }
            ++i2;
        }
        this.th.check(hm.size(), 0, "only first key counts");
    }

    private final /* synthetic */ void this() {
        this.b = new Byte(97);
        this.sh = new Short(97);
        this.i = new Integer(97);
        this.l = new Long(97L);
        this.sqnce = 1;
    }

    public AcuniaWeakHashMapTest() {
        this.this();
    }
}

