/*
 * Decompiled with CFR 0.152.
 */
package gnu.testlet.wonka.util.Vector;

import gnu.testlet.TestHarness;
import gnu.testlet.Testlet;
import gnu.testlet.wonka.util.Vector.SMExVector;
import java.util.ArrayList;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Vector;

public class SMVectorTest
implements Testlet {
    protected TestHarness th;

    public void test(TestHarness harness) {
        this.th = harness;
        this.th.setclass("java.util.Vector");
        this.test_Vector();
        this.test_contains();
        this.test_containsAll();
        this.test_indexOf();
        this.test_isEmpty();
        this.test_lastIndexOf();
        this.test_size();
        this.test_get();
        this.test_copyInto();
        this.test_elementAt();
        this.test_elements();
        this.test_firstElement();
        this.test_lastElement();
        this.test_add();
        this.test_addAll();
        this.test_addElement();
        this.test_clear();
        this.test_insertElementAt();
        this.test_remove();
        try {
            this.test_removeAll();
        }
        catch (UnsupportedOperationException ue) {
            this.th.fail("method removeAll() is not supported");
        }
        this.test_removeAllElements();
        this.test_removeElement();
        this.test_removeElementAt();
        this.test_removeRange();
        try {
            this.test_retainAll();
        }
        catch (UnsupportedOperationException ue) {
            this.th.fail("method retainAll() is not supported");
        }
        try {
            this.test_set();
        }
        catch (UnsupportedOperationException ue) {
            this.th.fail("method set() is not supported");
        }
        this.test_setElementAt();
        this.test_setSize();
        this.test_capacity();
        this.test_ensureCapacity();
        this.test_trimToSize();
        try {
            this.test_subList();
        }
        catch (UnsupportedOperationException ue) {
            this.th.fail("method subList() is not supported");
            ue.printStackTrace();
        }
        this.test_toArray();
        this.test_clone();
        this.test_equals();
        this.test_hashCode();
        this.test_toString();
        this.test_behaviour();
        this.test_iterator();
    }

    public Vector buildknownV() {
        Vector<Float> v = new Vector<Float>();
        int i = 0;
        while (i < 11) {
            Float f = new Float(i);
            v.addElement(f);
            ++i;
        }
        return v;
    }

    public void test_Vector() {
        this.th.checkPoint("Vector()");
        Vector v = new Vector();
        boolean bl = false;
        if (v.capacity() == 10) {
            bl = true;
        }
        this.th.check(bl, "check default capacity");
        this.th.checkPoint("Vector(java.util.Collection)");
        v = new Vector(this.buildknownV());
        v.equals(this.buildknownV());
        this.th.checkPoint("Vector(int)");
        v = new Vector(20);
        boolean bl2 = false;
        if (v.capacity() == 20) {
            bl2 = true;
        }
        this.th.check(bl2, "check default capacity");
        this.th.checkPoint("Vector(int,int)");
        v = new Vector(20, 5);
        boolean bl3 = false;
        if (v.capacity() == 20) {
            bl3 = true;
        }
        this.th.check(bl3, "check default capacity");
    }

    public void test_contains() {
        this.th.checkPoint("contains(java.lang.Object)boolean");
        Vector v = this.buildknownV();
        Object o = new Object();
        Float f = new Float(5);
        this.th.check(v.contains(null) ^ true, "null is allowed -- 1");
        v.addElement(null);
        this.th.check(v.contains(null), "null is allowed -- 2");
        this.th.check(v.contains(f), "contains -- 1");
        f = new Float(15.0f);
        this.th.check(v.contains(f) ^ true, "contains -- 2");
        this.th.check(v.contains(o) ^ true, "contains -- 3");
        v.addElement(o);
        this.th.check(v.contains(o), "contains -- 4");
        this.th.check(v.contains(new Object()) ^ true, "contains -- 5");
    }

    public void test_containsAll() {
        this.th.checkPoint("containsAll(java.util.Collection)boolean");
        Vector<String> v = new Vector<String>();
        try {
            v.containsAll(null);
            this.th.fail("should throw NullPointerException");
        }
        catch (NullPointerException ne) {
            this.th.check(true);
        }
        v.addElement("a");
        v.addElement("b");
        v.addElement("c");
        v.addElement(null);
        Collection c = (Collection)v.clone();
        v.addElement("d");
        v.addElement("e");
        v.addElement("f");
        this.th.check(v.containsAll(c), "checking ContainsAll -- 1");
        v.removeElement("a");
        this.th.check(v.containsAll(c) ^ true, "checking ContainsAll -- 2");
        try {
            v.containsAll(null);
            this.th.fail("should throw NullPointerException");
        }
        catch (NullPointerException ne) {
            this.th.check(true);
        }
    }

    public void test_indexOf() {
        this.th.checkPoint("indexOf(java.lang.Object)int");
        Vector v = this.buildknownV();
        Object o = new Object();
        Float f = new Float(5);
        boolean bl = false;
        if (v.indexOf(f) == 5) {
            bl = true;
        }
        this.th.check(bl, "contains -- 1");
        f = new Float(15.0f);
        boolean bl2 = false;
        if (v.indexOf(f) == -1) {
            bl2 = true;
        }
        this.th.check(bl2, "contains -- 2");
        boolean bl3 = false;
        if (v.indexOf(o) == -1) {
            bl3 = true;
        }
        this.th.check(bl3, "contains -- 3");
        v.addElement(o);
        boolean bl4 = false;
        if (v.indexOf(o) == 11) {
            bl4 = true;
        }
        this.th.check(bl4, "contains -- 4");
        boolean bl5 = false;
        if (v.indexOf(new Object()) == -1) {
            bl5 = true;
        }
        this.th.check(bl5, "contains -- 5");
        try {
            v.indexOf(null);
            this.th.check(true);
            v.addElement(null);
            boolean bl6 = false;
            if (v.indexOf(null) == 12) {
                bl6 = true;
            }
            this.th.check(bl6, "null was added to the Vector");
        }
        catch (NullPointerException ne) {
            this.th.fail("shouldn't throw NullPointerException");
        }
        this.th.checkPoint("indexOf(java.lang.Object,int)int");
        v = this.buildknownV();
        o = new Object();
        f = new Float(5);
        boolean bl7 = false;
        if (v.indexOf(f, 2) == 5) {
            bl7 = true;
        }
        this.th.check(bl7, "contains -- 1");
        boolean bl8 = false;
        if (v.indexOf(f, 6) == -1) {
            bl8 = true;
        }
        this.th.check(bl8, "contains -- 2");
        f = new Float(15.0f);
        boolean bl9 = false;
        if (v.indexOf(f, 4) == -1) {
            bl9 = true;
        }
        this.th.check(bl9, "contains -- 3");
        boolean bl10 = false;
        if (v.indexOf(o, 3) == -1) {
            bl10 = true;
        }
        this.th.check(bl10, "contains -- 4");
        v.addElement(o);
        boolean bl11 = false;
        if (v.indexOf(o, 11) == 11) {
            bl11 = true;
        }
        this.th.check(bl11, "contains -- 5");
        v.addElement(f);
        boolean bl12 = false;
        if (v.indexOf(o, 12) == -1) {
            bl12 = true;
        }
        this.th.check(bl12, "contains -- 6");
        boolean bl13 = false;
        if (v.indexOf(new Object(), 1) == -1) {
            bl13 = true;
        }
        this.th.check(bl13, "contains -- 7");
        try {
            v.indexOf(null, 3);
            this.th.check(true);
            v.addElement(null);
            boolean bl14 = false;
            if (v.indexOf(null, 13) == 13) {
                bl14 = true;
            }
            this.th.check(bl14, "null was added to the Vector");
        }
        catch (NullPointerException ne) {
            this.th.fail("shouldn't throw NullPointerException");
        }
        try {
            f = new Float(10.0f);
            boolean bl15 = false;
            if (v.indexOf(f, 333) == -1) {
                bl15 = true;
            }
            this.th.check(bl15, "checking bounderies");
        }
        catch (Exception ne) {
            this.th.fail("shouldn't throw an Exception");
        }
        try {
            v.indexOf(f, -1);
            this.th.fail("shouldn't throw NullPointerException");
        }
        catch (Exception ne) {
            this.th.check(true);
        }
    }

    public void test_isEmpty() {
        this.th.checkPoint("isEmpty()boolean");
        Vector v = new Vector();
        this.th.check(v.isEmpty(), "testing isEmpty -- 1");
        this.th.check(this.buildknownV().isEmpty() ^ true, "testing isEmpty -- 2");
    }

    public void test_lastIndexOf() {
        this.th.checkPoint("lastIndexOf(java.lang.Object)int");
        Vector v = this.buildknownV();
        Object o = new Object();
        Float f = new Float(5);
        boolean bl = false;
        if (v.lastIndexOf(f) == 5) {
            bl = true;
        }
        this.th.check(bl, "contains -- 1");
        f = new Float(15.0f);
        boolean bl2 = false;
        if (v.lastIndexOf(f) == -1) {
            bl2 = true;
        }
        this.th.check(bl2, "contains -- 2");
        boolean bl3 = false;
        if (v.lastIndexOf(o) == -1) {
            bl3 = true;
        }
        this.th.check(bl3, "contains -- 3");
        v.addElement(o);
        boolean bl4 = false;
        if (v.lastIndexOf(o) == 11) {
            bl4 = true;
        }
        this.th.check(bl4, "contains -- 4");
        boolean bl5 = false;
        if (v.lastIndexOf(new Object()) == -1) {
            bl5 = true;
        }
        this.th.check(bl5, "contains -- 5");
        try {
            v.lastIndexOf(null);
            this.th.check(true);
            v.addElement(null);
            boolean bl6 = false;
            if (v.lastIndexOf(null) == 12) {
                bl6 = true;
            }
            this.th.check(bl6, "null was added to the Vector");
        }
        catch (NullPointerException ne) {
            this.th.fail("shouldn't throw NullPointerException");
        }
        this.th.checkPoint("lastIndexOf(java.lang.Object,int)int");
        v = this.buildknownV();
        o = new Object();
        f = new Float(5);
        boolean bl7 = false;
        if (v.lastIndexOf(f, 5) == 5) {
            bl7 = true;
        }
        this.th.check(bl7, "contains -- 1");
        boolean bl8 = false;
        if (v.lastIndexOf(f, 4) == -1) {
            bl8 = true;
        }
        this.th.check(bl8, "contains -- 2");
        f = new Float(15.0f);
        boolean bl9 = false;
        if (v.lastIndexOf(f, 4) == -1) {
            bl9 = true;
        }
        this.th.check(bl9, "contains -- 3");
        boolean bl10 = false;
        if (v.lastIndexOf(o, 3) == -1) {
            bl10 = true;
        }
        this.th.check(bl10, "contains -- 4");
        v.addElement(o);
        boolean bl11 = false;
        if (v.lastIndexOf(o, 11) == 11) {
            bl11 = true;
        }
        this.th.check(bl11, "contains -- 5");
        v.addElement(f);
        boolean bl12 = false;
        if (v.lastIndexOf(o, 10) == -1) {
            bl12 = true;
        }
        this.th.check(bl12, "contains -- 6");
        boolean bl13 = false;
        if (v.lastIndexOf(new Object(), 10) == -1) {
            bl13 = true;
        }
        this.th.check(bl13, "contains -- 7");
        try {
            v.lastIndexOf(null, 12);
            this.th.check(true);
            v.addElement(null);
            boolean bl14 = false;
            if (v.lastIndexOf(null, 13) == 13) {
                bl14 = true;
            }
            this.th.check(bl14, "null was added to the Vector");
            boolean bl15 = false;
            if (v.lastIndexOf(null, 12) == -1) {
                bl15 = true;
            }
            this.th.check(bl15, "null was added to the Vector, on pos 13");
        }
        catch (NullPointerException ne) {
            this.th.fail("shouldn't throw NullPointerException");
        }
        try {
            f = new Float(10.0f);
            boolean bl16 = false;
            if (v.lastIndexOf(f, -1) == -1) {
                bl16 = true;
            }
            this.th.check(bl16, "checking bounderies");
        }
        catch (Exception ne) {
            this.th.fail("shouldn't throw an Exception");
        }
        try {
            v.lastIndexOf(f, 91);
            this.th.fail("shouldn't throw NullPointerException");
        }
        catch (Exception ne) {
            this.th.check(true);
        }
    }

    public void test_size() {
        this.th.checkPoint("size()int");
        Vector<Object> v = this.buildknownV();
        boolean bl = false;
        if (v.size() == 11) {
            bl = true;
        }
        this.th.check(bl, "size -- 1 - got: " + v.size());
        v.addElement(null);
        boolean bl2 = false;
        if (v.size() == 12) {
            bl2 = true;
        }
        this.th.check(bl2, "size -- 2 - got: " + v.size());
        v.addElement(new Object());
        boolean bl3 = false;
        if (v.size() == 13) {
            bl3 = true;
        }
        this.th.check(bl3, "size -- 3 - got: " + v.size());
        v = new Vector<Object>();
        boolean bl4 = false;
        if (v.size() == 0) {
            bl4 = true;
        }
        this.th.check(bl4, "size -- 4 - got: " + v.size());
    }

    public void test_get() {
        this.th.checkPoint("get(int)java.lang.Object");
        Vector<String> v = this.buildknownV();
        try {
            v.get(-1);
            this.th.fail("should throw exception -- 1");
        }
        catch (ArrayIndexOutOfBoundsException ae) {
            this.th.check(true);
        }
        try {
            v.get(11);
            this.th.fail("should throw exception -- 2");
        }
        catch (ArrayIndexOutOfBoundsException ae) {
            this.th.check(true);
        }
        v = new Vector<String>();
        v.addElement("a");
        v.addElement(null);
        v.addElement("c");
        v.addElement(null);
        boolean bl = false;
        if (v.get(0).equals("a") && v.get(2).equals("c")) {
            bl = true;
        }
        this.th.check(bl, "checking get -- 1");
        boolean bl2 = false;
        if (v.get(1) == null && v.get(3) == null) {
            bl2 = true;
        }
        this.th.check(bl2, "checking get -- 2");
    }

    public void test_copyInto() {
        this.th.checkPoint("copyInto(java.lang.Object[])void");
        Vector v = this.buildknownV();
        StringBuffer bf = new StringBuffer("smartmove");
        v.addElement(bf);
        Object[] o = new Object[5];
        try {
            v.copyInto(o);
            this.th.fail("should throw ArrayIndexOutOfBoundsException");
        }
        catch (ArrayIndexOutOfBoundsException ae) {
            this.th.check(true);
        }
        o = new Object[15];
        v.copyInto(o);
        int i = 0;
        while (i < 11) {
            boolean bl = false;
            if (o[i] == v.elementAt(i)) {
                bl = true;
            }
            this.th.check(bl, "checking copyInto -- " + (i + 1) + " - got: " + o[i]);
            ++i;
        }
        boolean bl = false;
        if (o[11] == v.elementAt(11)) {
            bl = true;
        }
        this.th.check(bl, "checking stringbuffer");
        boolean bl2 = false;
        if (o.length == 15) {
            bl2 = true;
        }
        this.th.check(bl2);
    }

    public void test_elementAt() {
        this.th.checkPoint("elementAt(int)java.lang.Object");
        Vector<Number> v = new Vector<Number>();
        v.addElement(null);
        Float f = new Float(23.0f);
        Double d = new Double(54.5);
        v.addElement(f);
        v.addElement(d);
        boolean bl = false;
        if (v.elementAt(0) == null) {
            bl = true;
        }
        this.th.check(bl);
        boolean bl2 = false;
        if (v.elementAt(1) == f) {
            bl2 = true;
        }
        this.th.check(bl2);
        boolean bl3 = false;
        if (v.elementAt(2) == d) {
            bl3 = true;
        }
        this.th.check(bl3);
        try {
            v.elementAt(-1);
            this.th.fail("should throw ArrayIndexOutOfBoundsException -- 1");
        }
        catch (ArrayIndexOutOfBoundsException ae) {
            this.th.check(true);
        }
        try {
            v.elementAt(3);
            this.th.fail("should throw ArrayIndexOutOfBoundsException -- 2");
        }
        catch (ArrayIndexOutOfBoundsException ae) {
            this.th.check(true);
        }
    }

    public void test_elements() {
        this.th.checkPoint("elements()java.util.Enumeration");
        Vector<Number> v = this.buildknownV();
        v.addElement(null);
        Float f = new Float(23.0f);
        Double d = new Double(54.5);
        v.addElement(f);
        v.addElement(d);
        Enumeration e = v.elements();
        int i = 0;
        while (i < 11) {
            boolean bl = false;
            if (((Float)e.nextElement()).intValue() == i) {
                bl = true;
            }
            this.th.check(bl, "checking elements -- " + (i + 1));
            ++i;
        }
        try {
            this.th.check(e.hasMoreElements(), "null in vector might give problems -- 1");
            boolean bl = false;
            if (e.nextElement() == null) {
                bl = true;
            }
            this.th.check(bl, "null in vector might give problems -- 2");
            this.th.check(e.hasMoreElements(), "null in vector might give problems -- 3");
            boolean bl2 = false;
            if (e.nextElement() == f) {
                bl2 = true;
            }
            this.th.check(bl2, "null in vector might give problems -- 4");
            boolean bl3 = false;
            if (e.nextElement() == d) {
                bl3 = true;
            }
            this.th.check(bl3, "null in vector might give problems -- 5");
            this.th.check(e.hasMoreElements() ^ true, "null in vector might give problems -- 6");
        }
        catch (Exception te) {
            this.th.debug("caught unwanted exception: " + te);
        }
        v = new Vector<Number>();
        boolean bl = false;
        if (v.elements() != null) {
            bl = true;
        }
        this.th.check(bl);
    }

    public void test_firstElement() {
        this.th.checkPoint("firstElement()java.lang.Object");
        Vector<Number> v = new Vector<Number>();
        try {
            v.firstElement();
            this.th.fail("should throw NoSuchElementException");
        }
        catch (NoSuchElementException ne) {
            this.th.check(true);
        }
        v.addElement(null);
        boolean bl = false;
        if (v.firstElement() == null) {
            bl = true;
        }
        this.th.check(bl);
        v = new Vector();
        Float f = new Float(23.0f);
        v.addElement(f);
        boolean bl2 = false;
        if (v.firstElement() == f) {
            bl2 = true;
        }
        this.th.check(bl2);
        v = new Vector();
        Double d = new Double(54.5);
        v.addElement(d);
        v.addElement(null);
        v.addElement(f);
        boolean bl3 = false;
        if (v.firstElement() == d) {
            bl3 = true;
        }
        this.th.check(bl3);
    }

    public void test_lastElement() {
        this.th.checkPoint("lastElement()java.lang.Object");
        Vector<Float> v = new Vector<Float>();
        try {
            v.lastElement();
            this.th.fail("should throw NoSuchElementException");
        }
        catch (NoSuchElementException ne) {
            this.th.check(true);
        }
        v.addElement(null);
        boolean bl = false;
        if (v.lastElement() == null) {
            bl = true;
        }
        this.th.check(bl);
        v = this.buildknownV();
        v.addElement(null);
        boolean bl2 = false;
        if (v.lastElement() == null) {
            bl2 = true;
        }
        this.th.check(bl2);
        Float f = new Float(23.0f);
        v.addElement(f);
        boolean bl3 = false;
        if (v.lastElement() == f) {
            bl3 = true;
        }
        this.th.check(bl3);
        v = new Vector<Float>();
        Double d = new Double(54.5);
        v.addElement((Float)((Object)d));
        boolean bl4 = false;
        if (v.lastElement() == d) {
            bl4 = true;
        }
        this.th.check(bl4);
    }

    public void test_add() {
        this.th.checkPoint("add(java.lang.Object)boolean");
        Vector<String> v = new Vector<String>();
        boolean bl = false;
        if (v.add("a") && v.add(null)) {
            bl = true;
        }
        this.th.check(bl, "checking returns boolean -- 1");
        boolean bl2 = false;
        if (v.add("c") && v.add(null)) {
            bl2 = true;
        }
        this.th.check(bl2, "checking returns boolean -- 2");
        boolean bl3 = false;
        if (v.get(0) == "a" && v.get(2) == "c") {
            bl3 = true;
        }
        this.th.check(bl3, "checking addedcat right position -- 1");
        this.th.checkPoint("add(int,java.lang.Object)void");
        v = this.buildknownV();
        try {
            v.add(-1, "a");
            this.th.fail("should throw exception -- 1");
        }
        catch (ArrayIndexOutOfBoundsException ae) {
            this.th.check(true);
        }
        try {
            v.add(12, "a");
            this.th.fail("should throw exception -- 2");
        }
        catch (ArrayIndexOutOfBoundsException ae) {
            this.th.check(true);
        }
        try {
            v.add(11, "a");
            this.th.check(true);
        }
        catch (ArrayIndexOutOfBoundsException ae) {
            this.th.fail("shouldn't throw exception -- 1");
        }
        v = new Vector<String>();
        v.add(0, "a");
        v.add(0, null);
        v.add(1, "c");
        v.add(2, null);
        boolean bl4 = false;
        if (v.get(3).equals("a") && v.get(1).equals("c")) {
            bl4 = true;
        }
        this.th.check(bl4, "checking get -- 1");
        boolean bl5 = false;
        if (v.get(0) == null && v.get(2) == null) {
            bl5 = true;
        }
        this.th.check(bl5, "checking get -- 2");
        v.add(4, "b");
        v.add(5, null);
        boolean bl6 = false;
        if (v.get(4) == "b" && v.get(5) == null) {
            bl6 = true;
        }
        this.th.check(bl6, "checking get -- 3");
    }

    public void test_addAll() {
        this.th.checkPoint("addAll(java.util.Collection)boolean");
        Vector v = new Vector();
        try {
            v.addAll(null);
            this.th.fail("should throw NullPointerException");
        }
        catch (NullPointerException ne) {
            this.th.check(true);
        }
        Vector c = v;
        this.th.check(v.addAll(c) ^ true, "checking returnvalue -- 1");
        v.add("a");
        v.add("b");
        v.add("c");
        c = v;
        v = this.buildknownV();
        this.th.check(v.addAll(c), "checking returnvalue -- 2");
        this.th.check(v.containsAll(c), "extra on containsAll -- 1");
        boolean bl = false;
        if (v.get(11) == "a" && v.get(12) == "b" && v.get(13) == "c") {
            bl = true;
        }
        this.th.check(bl, "checking added on right positions");
        this.th.checkPoint("addAll(int,java.util.Collection)boolean");
        c = v = new Vector();
        this.th.check(v.addAll(0, c) ^ true, "checking returnvalue -- 1");
        v.add("a");
        v.add("b");
        v.add("c");
        c = v;
        v = this.buildknownV();
        try {
            v.addAll(-1, c);
            this.th.fail("should throw exception -- 1");
        }
        catch (ArrayIndexOutOfBoundsException ae) {
            this.th.check(true);
        }
        try {
            v.addAll(12, c);
            this.th.fail("should throw exception -- 2");
        }
        catch (ArrayIndexOutOfBoundsException ae) {
            this.th.check(true);
        }
        try {
            this.th.check(v.addAll(11, c), "checking returnvalue -- 2");
        }
        catch (ArrayIndexOutOfBoundsException ae) {
            this.th.fail("shouldn't throw exception -- 1");
        }
        this.th.check(v.containsAll(c), "extra on containsAll -- 1");
        boolean bl2 = false;
        if (v.get(11) == "a" && v.get(12) == "b" && v.get(13) == "c") {
            bl2 = true;
        }
        this.th.check(bl2, "checking added on right positions -- 1");
        this.th.check(v.addAll(1, c), "checking returnvalue -- 3");
        boolean bl3 = false;
        if (v.get(1) == "a" && v.get(2) == "b" && v.get(3) == "c") {
            bl3 = true;
        }
        this.th.check(bl3, "checking added on right positions -- 2");
    }

    public void test_addElement() {
        this.th.checkPoint("addElement(java.lang.Object)void");
        Vector<String> v = new Vector<String>();
        v.addElement("a");
        boolean bl = false;
        if (v.size() == 1) {
            bl = true;
        }
        this.th.check(bl, "check size -- 1");
        boolean bl2 = false;
        if (v.elementAt(0) == "a") {
            bl2 = true;
        }
        this.th.check(bl2);
        v.addElement(null);
        boolean bl3 = false;
        if (v.size() == 2) {
            bl3 = true;
        }
        this.th.check(bl3, "check size -- 2");
        boolean bl4 = false;
        if (v.elementAt(1) == null) {
            bl4 = true;
        }
        this.th.check(bl4);
    }

    public void test_clear() {
        this.th.checkPoint("clear()void");
        Vector v = this.buildknownV();
        int c = v.capacity();
        v.clear();
        boolean bl = false;
        if (v.isEmpty() && v.size() == 0) {
            bl = true;
        }
        this.th.check(bl, "make sure all is gone");
        boolean bl2 = false;
        if (c == v.capacity()) {
            bl2 = true;
        }
        this.th.check(bl2, "capacity stays the same, got: " + v.capacity() + ", but exp.: " + c);
        v.add("a");
    }

    public void test_insertElementAt() {
        this.th.checkPoint("insertElementAt(java.lang.Object,int)void");
        Vector v = this.buildknownV();
        v.insertElementAt("a", 5);
        int i = 0;
        while (i < 5) {
            boolean bl = false;
            if (((Float)v.elementAt(i)).intValue() == i) {
                bl = true;
            }
            this.th.check(bl, "Float value didn't change -- " + (i + 1));
            ++i;
        }
        i = 6;
        while (i < 12) {
            boolean bl = false;
            if (((Float)v.elementAt(i)).intValue() == i - 1) {
                bl = true;
            }
            this.th.check(bl, "checking shifted elements -- " + (i - 5));
            ++i;
        }
        boolean bl = false;
        if (v.elementAt(5) == "a") {
            bl = true;
        }
        this.th.check(bl);
        try {
            v.insertElementAt("a", 12);
            boolean bl2 = false;
            if (v.elementAt(12) == "a") {
                bl2 = true;
            }
            this.th.check(bl2);
        }
        catch (Exception e) {
            this.th.fail("shouldn't throw an Exception -- caught: " + e);
        }
        try {
            v.insertElementAt("a", 14);
            this.th.fail("should throw an ArrayIndexOutOfBoundsException -- 1");
        }
        catch (ArrayIndexOutOfBoundsException e) {
            this.th.check(true);
        }
        try {
            v.insertElementAt("a", -1);
            this.th.fail("should throw an ArrayIndexOutOfBoundsException -- 2");
        }
        catch (ArrayIndexOutOfBoundsException e) {
            this.th.check(true);
        }
        v = this.buildknownV();
        v.insertElementAt(null, 5);
        i = 0;
        while (i < 5) {
            boolean bl3 = false;
            if (((Float)v.elementAt(i)).intValue() == i) {
                bl3 = true;
            }
            this.th.check(bl3, "Float value didn't change inserted null -- " + (i + 1));
            ++i;
        }
        i = 6;
        while (i < 12) {
            boolean bl4 = false;
            if (((Float)v.elementAt(i)).intValue() == i - 1) {
                bl4 = true;
            }
            this.th.check(bl4, "checking shifted elements inserted null -- " + (i - 5));
            ++i;
        }
        boolean bl5 = false;
        if (v.elementAt(5) == null) {
            bl5 = true;
        }
        this.th.check(bl5);
    }

    public void test_remove() {
        this.th.checkPoint("remove(int)java.lang.Object");
        Vector<String> v = this.buildknownV();
        try {
            v.remove(-1);
            this.th.fail("should throw an ArrayIndexOutOfBoundsException -- 1");
        }
        catch (ArrayIndexOutOfBoundsException e) {
            this.th.check(true);
        }
        try {
            v.remove(11);
            this.th.fail("should throw an ArrayIndexOutOfBoundsException -- 2");
        }
        catch (ArrayIndexOutOfBoundsException e) {
            this.th.check(true);
        }
        boolean bl = false;
        if (((Float)v.remove(5)).intValue() == 5) {
            bl = true;
        }
        this.th.check(bl, "checking returnvalue remove -- 1");
        boolean ok = true;
        boolean bl2 = false;
        if (v.size() == 10) {
            bl2 = true;
        }
        this.th.check(bl2, "checking new Size");
        int i = 0;
        while (i < 5) {
            if (((Float)v.get(i)).intValue() != i) {
                ok = false;
            }
            ++i;
        }
        this.th.check(ok, "checking order Floats in Vector -- 1");
        ok = true;
        i = 5;
        while (i < 10) {
            if (((Float)v.get(i)).intValue() != i + 1) {
                ok = false;
            }
            ++i;
        }
        this.th.check(ok, "checking order Floats in Vector -- 2");
        v.add(5, null);
        boolean bl3 = false;
        if (v.remove(5) == null) {
            bl3 = true;
        }
        this.th.check(bl3, "checking returnvalue remove -- 2");
        ok = true;
        i = 0;
        while (i < 5) {
            if (((Float)v.get(i)).intValue() != i) {
                ok = false;
            }
            ++i;
        }
        this.th.check(ok, "checking order Floats in Vector -- 3");
        ok = true;
        i = 5;
        while (i < 10) {
            if (((Float)v.get(i)).intValue() != i + 1) {
                ok = false;
            }
            ++i;
        }
        this.th.check(ok, "checking order Floats in Vector -- 4");
        boolean bl4 = false;
        if (((Float)v.remove(9)).intValue() == 10) {
            bl4 = true;
        }
        this.th.check(bl4, "checking returnvalue remove -- 3");
        boolean bl5 = false;
        if (((Float)v.remove(0)).intValue() == 0) {
            bl5 = true;
        }
        this.th.check(bl5, "checking returnvalue remove -- 4");
        boolean bl6 = false;
        if (((Float)v.remove(0)).intValue() == 1) {
            bl6 = true;
        }
        this.th.check(bl6, "checking returnvalue remove -- 5");
        v = new Vector<String>();
        try {
            v.remove(0);
            this.th.fail("should throw an ArrayIndexOutOfBoundsException -- 3");
        }
        catch (ArrayIndexOutOfBoundsException e) {
            this.th.check(true);
        }
        this.th.checkPoint("remove(java.lang.Object)boolean");
        v = new Vector();
        this.th.check(v.remove("a") ^ true, "checking remove on empty vector-- 1");
        this.th.check(v.remove("a") ^ true, "checking remove on empty vector-- 2");
        v.add("a");
        v.add(null);
        v.add("a");
        v.add("c");
        v.add("d");
        v.add(null);
        this.th.check(v.remove("a"), "checking returnvalue remove -- 1");
        boolean bl7 = false;
        if (v.get(0) == null && v.get(1) == "a" && v.get(2) == "c" && v.get(3) == "d" && v.get(4) == null) {
            bl7 = true;
        }
        this.th.check(bl7, "checking order of elements -- 1");
        this.th.check(v.remove("a"), "checking returnvalue remove -- 2");
        boolean bl8 = false;
        if (v.get(0) == null && v.get(1) == "c" && v.get(2) == "d" && v.get(3) == null) {
            bl8 = true;
        }
        this.th.check(bl8, "checking order of elements -- 2");
        this.th.check(v.remove("a") ^ true, "checking returnvalue remove -- 3");
        boolean bl9 = false;
        if (v.get(0) == null && v.get(1) == "c" && v.get(2) == "d" && v.get(3) == null) {
            bl9 = true;
        }
        this.th.check(bl9, "checking order of elements -- 3");
        this.th.check(v.remove(null), "checking returnvalue remove -- 4");
        boolean bl10 = false;
        if (v.get(0) == "c" && v.get(1) == "d" && v.get(2) == null) {
            bl10 = true;
        }
        this.th.check(bl10, "checking order of elements -- 4");
        this.th.check(v.remove(null), "checking returnvalue remove -- 5");
        boolean bl11 = false;
        if (v.get(0) == "c" && v.get(1) == "d") {
            bl11 = true;
        }
        this.th.check(bl11, "checking order of elements -- 5");
        this.th.check(v.remove(null) ^ true, "checking returnvalue remove -- 6");
        boolean bl12 = false;
        if (v.get(0) == "c" && v.get(1) == "d") {
            bl12 = true;
        }
        this.th.check(bl12, "checking order of elements -- 6");
    }

    public void test_removeAll() throws UnsupportedOperationException {
        this.th.checkPoint("removeAll(java.util.Collection)boolean");
        Vector v = new Vector();
        try {
            v.removeAll(null);
            this.th.fail("should throw NullPointerException");
        }
        catch (NullPointerException ne) {
            this.th.check(true);
        }
        v.add("a");
        try {
            v.removeAll(null);
            this.th.fail("should throw NullPointerException");
        }
        catch (NullPointerException ne) {
            this.th.check(true);
        }
        v.add("b");
        v.add(null);
        Vector c = v;
        v = this.buildknownV();
        this.th.check(v.removeAll(c) ^ true, "checking returnvalue of removeAll -- 1");
        this.th.check(v.equals(this.buildknownV()), "v didn't change");
        v.addAll(c);
        this.th.check(v.removeAll(c), "checking returnvalue of removeAll -- 2");
        this.th.check(v.equals(this.buildknownV()), "v did change to original v");
        v.add(2, null);
        v.add(4, "a");
        v.add(9, "b");
        v.addAll(0, c);
        v.add(2, null);
        v.add(4, "a");
        v.add(9, "b");
        v.addAll(c);
        this.th.check(v.removeAll(c), "checking returnvalue of removeAll -- 3");
        this.th.check(v.equals(this.buildknownV()), "make sure all elements are removed");
    }

    public void test_removeAllElements() {
        this.th.checkPoint("removeAllElements()void");
        Vector v = this.buildknownV();
        int c = v.capacity();
        v.removeAllElements();
        boolean bl = false;
        if (v.isEmpty() && v.size() == 0) {
            bl = true;
        }
        this.th.check(bl, "make sure all is gone");
        boolean bl2 = false;
        if (c == v.capacity()) {
            bl2 = true;
        }
        this.th.check(bl2, "capacity stays the same, got: " + v.capacity() + ", but exp.: " + c);
    }

    public void test_removeElement() {
        this.th.checkPoint("removeElement(java.lang.Object)boolean");
        Vector v = this.buildknownV();
        v.addElement("a");
        v.addElement(null);
        v.addElement("a");
        v.addElement(null);
        v.addElement("a");
        v.addElement(null);
        this.th.check(v.removeElement("a"), "element is in there -- 1");
        boolean bl = false;
        if (v.size() == 16) {
            bl = true;
        }
        this.th.check(bl, "size is one less -- 1");
        this.th.check(v.removeElement("c") ^ true, "element isn't in there -- 1");
        boolean ok = true;
        int i = 0;
        while (i < 11) {
            if (((Float)v.elementAt(i)).intValue() != i) {
                ok = false;
            }
            ++i;
        }
        this.th.check(ok, "Float value didn't change -- 1");
        boolean bl2 = false;
        if (v.elementAt(11) == null && v.elementAt(13) == null && v.elementAt(15) == null) {
            bl2 = true;
        }
        this.th.check(bl2, "checking order -- 1");
        boolean bl3 = false;
        if (v.elementAt(12) == "a" && v.elementAt(14) == "a") {
            bl3 = true;
        }
        this.th.check(bl3, "checking order -- 2");
        ok = true;
        this.th.check(v.removeElement("a"), "element is in there -- 2");
        boolean bl4 = false;
        if (v.size() == 15) {
            bl4 = true;
        }
        this.th.check(bl4, "size is one less -- 2");
        i = 0;
        while (i < 11) {
            if (((Float)v.elementAt(i)).intValue() != i) {
                ok = false;
            }
            ++i;
        }
        this.th.check(ok, "Float value didn't change -- 2");
        boolean bl5 = false;
        if (v.elementAt(11) == null && v.elementAt(12) == null && v.elementAt(14) == null) {
            bl5 = true;
        }
        this.th.check(bl5, "checking order -- 3");
        boolean bl6 = false;
        if (v.elementAt(13) == "a") {
            bl6 = true;
        }
        this.th.check(bl6, "checking order -- 4");
        ok = true;
        this.th.check(v.removeElement("a"), "element is in there -- 3");
        boolean bl7 = false;
        if (v.size() == 14) {
            bl7 = true;
        }
        this.th.check(bl7, "size is one less -- 3");
        i = 0;
        while (i < 11) {
            if (((Float)v.elementAt(i)).intValue() != i) {
                ok = false;
            }
            ++i;
        }
        this.th.check(ok, "Float value didn't change -- 3 ");
        boolean bl8 = false;
        if (v.elementAt(11) == null && v.elementAt(12) == null && v.elementAt(13) == null) {
            bl8 = true;
        }
        this.th.check(bl8, "checking order -- 5");
        this.th.check(v.contains("a") ^ true, "checking contents -- 1");
        this.th.check(v.removeElement("a") ^ true, "element isn't in there -- 2");
        ok = true;
        this.th.check(v.removeElement(null), "element is in there -- 4");
        boolean bl9 = false;
        if (v.size() == 13) {
            bl9 = true;
        }
        this.th.check(bl9, "size is one less -- 4");
        i = 0;
        while (i < 11) {
            if (((Float)v.elementAt(i)).intValue() != i) {
                ok = false;
            }
            ++i;
        }
        this.th.check(ok, "Float value didn't change -- 4");
        boolean bl10 = false;
        if (v.elementAt(11) == null && v.elementAt(12) == null) {
            bl10 = true;
        }
        this.th.check(bl10, "checking order -- 6");
        this.th.check(v.removeElement(null), "element is in there -- 5");
        this.th.check(v.removeElement(null), "element is in there -- 6");
        this.th.check(v.removeElement(null) ^ true, "element isn't in there -- 3");
    }

    public void test_removeElementAt() {
        this.th.checkPoint("removeElementAt(int)void");
        Vector v = this.buildknownV();
        v.addElement("a");
        v.addElement("b");
        v.addElement("a");
        v.addElement(null);
        v.addElement("a");
        v.addElement("b");
        v.removeElementAt(11);
        boolean bl = false;
        if (v.size() == 16) {
            bl = true;
        }
        this.th.check(bl, "size is one less -- 1");
        boolean ok = true;
        int i = 0;
        while (i < 11) {
            if (((Float)v.elementAt(i)).intValue() != i) {
                ok = false;
            }
            ++i;
        }
        this.th.check(ok, "Float value didn't change -- 1");
        boolean bl2 = false;
        if (v.elementAt(11) == "b" && v.elementAt(13) == null && v.elementAt(15) == "b") {
            bl2 = true;
        }
        this.th.check(bl2, "checking order -- 1");
        boolean bl3 = false;
        if (v.elementAt(12) == "a" && v.elementAt(14) == "a") {
            bl3 = true;
        }
        this.th.check(bl3, "checking order -- 2");
        ok = true;
        v.removeElementAt(12);
        boolean bl4 = false;
        if (v.size() == 15) {
            bl4 = true;
        }
        this.th.check(bl4, "size is one less -- 2");
        i = 0;
        while (i < 11) {
            if (((Float)v.elementAt(i)).intValue() != i) {
                ok = false;
            }
            ++i;
        }
        this.th.check(ok, "Float value didn't change -- 2");
        boolean bl5 = false;
        if (v.elementAt(11) == "b" && v.elementAt(12) == null && v.elementAt(14) == "b") {
            bl5 = true;
        }
        this.th.check(bl5, "checking order -- 3");
        boolean bl6 = false;
        if (v.elementAt(13) == "a") {
            bl6 = true;
        }
        this.th.check(bl6, "checking order -- 4");
        ok = true;
        v.removeElementAt(13);
        boolean bl7 = false;
        if (v.size() == 14) {
            bl7 = true;
        }
        this.th.check(bl7, "size is one less -- 3");
        i = 0;
        while (i < 11) {
            if (((Float)v.elementAt(i)).intValue() != i) {
                ok = false;
            }
            ++i;
        }
        this.th.check(ok, "Float value didn't change -- 3 ");
        boolean bl8 = false;
        if (v.elementAt(11) == "b" && v.elementAt(12) == null && v.elementAt(13) == "b") {
            bl8 = true;
        }
        this.th.check(bl8, "checking order -- 5");
        this.th.check(v.contains("a") ^ true, "checking contents -- 1");
        ok = true;
        v.removeElementAt(12);
        boolean bl9 = false;
        if (v.size() == 13) {
            bl9 = true;
        }
        this.th.check(bl9, "size is one less -- 4");
        i = 0;
        while (i < 11) {
            if (((Float)v.elementAt(i)).intValue() != i) {
                ok = false;
            }
            ++i;
        }
        this.th.check(ok, "Float value didn't change -- 4");
        boolean bl10 = false;
        if (v.elementAt(11) == "b" && v.elementAt(12) == "b") {
            bl10 = true;
        }
        this.th.check(bl10, "checking order -- 5");
        this.th.check(v.contains(null) ^ true, "checking contents -- 2");
        v = this.buildknownV();
        try {
            v.removeElementAt(-1);
            this.th.fail("should throw ArrayIndexOutOfBoundsException -- 1");
        }
        catch (ArrayIndexOutOfBoundsException ae) {
            this.th.check(true);
        }
        try {
            v.removeElementAt(11);
            this.th.fail("should throw ArrayIndexOutOfBoundsException -- 2");
        }
        catch (ArrayIndexOutOfBoundsException ae) {
            this.th.check(true);
        }
    }

    public void test_removeRange() {
        this.th.checkPoint("removeRange(int,int)void");
        SMExVector xal = new SMExVector((Collection)this.buildAL());
        ArrayList al = this.buildAL();
        xal.ensureCapacity(40);
        try {
            xal.removeRange(0, -1);
            this.th.fail("should throw an IndexOutOfBoundsException -- 1");
        }
        catch (IndexOutOfBoundsException ioobe) {
            this.th.check(true);
        }
        this.th.check(xal.equals(al), "ArrayList must not be changed -- 1");
        try {
            xal.removeRange(-1, 2);
            this.th.fail("should throw an IndexOutOfBoundsException -- 2");
        }
        catch (IndexOutOfBoundsException ioobe) {
            this.th.check(true);
        }
        this.th.check(xal.equals(al), "ArrayList must not be changed -- 2");
        try {
            xal.removeRange(3, 2);
            this.th.fail("should throw an IndexOutOfBoundsException -- 3");
        }
        catch (IndexOutOfBoundsException ioobe) {
            this.th.check(true);
        }
        this.th.check(al.equals(xal), "ArrayList must not be changed -- 3");
        xal = new SMExVector((Collection)this.buildAL());
        xal.ensureCapacity(40);
        try {
            xal.removeRange(3, 15);
            this.th.fail("should throw an IndexOutOfBoundsException -- 4");
        }
        catch (IndexOutOfBoundsException ioobe) {
            this.th.check(true);
        }
        this.th.check(xal.equals(al), "ArrayList must not be changed -- 4");
        xal = new SMExVector((Collection)this.buildAL());
        xal.ensureCapacity(40);
        try {
            xal.removeRange(15, 13);
            this.th.fail("should throw an IndexOutOfBoundsException -- 5");
        }
        catch (IndexOutOfBoundsException ioobe) {
            this.th.check(true);
        }
        this.th.check(xal.equals(al), "ArrayList must not be changed -- 5");
        xal = new SMExVector((Collection)this.buildAL());
        xal.ensureCapacity(40);
        xal.removeRange(14, 14);
        boolean bl = false;
        if (xal.size() == 14) {
            bl = true;
        }
        this.th.check(bl, "no elements should have been removed -- 6, size = " + xal.size());
        xal.removeRange(10, 14);
        boolean bl2 = false;
        if (xal.size() == 10) {
            bl2 = true;
        }
        this.th.check(bl2, "4 elements should have been removed");
        boolean bl3 = false;
        if ("a".equals(xal.get(0)) && "a".equals(xal.get(5)) && "a".equals(xal.get(7))) {
            bl3 = true;
        }
        this.th.check(bl3, "check contents -- 1");
        xal.removeRange(2, 7);
        boolean bl4 = false;
        if (xal.size() == 5) {
            bl4 = true;
        }
        this.th.check(bl4, "5 elements should have been removed");
        boolean bl5 = false;
        if ("a".equals(xal.get(0)) && "c".equals(xal.get(1)) && "a".equals(xal.get(2)) && "c".equals(xal.get(3)) && "u".equals(xal.get(4))) {
            bl5 = true;
        }
        this.th.check(bl5, "check contents -- 2");
        xal.removeRange(0, 2);
        boolean bl6 = false;
        if ("a".equals(xal.get(0)) && "c".equals(xal.get(1)) && "u".equals(xal.get(2))) {
            bl6 = true;
        }
        this.th.check(bl6, "check contents -- 3");
        boolean bl7 = false;
        if (xal.size() == 3) {
            bl7 = true;
        }
        this.th.check(bl7, "2 elements should have been removed");
    }

    public void test_retainAll() {
        this.th.checkPoint("retainAll(java.util.Collection)boolean");
        Vector v = new Vector();
        try {
            v.retainAll(null);
            this.th.fail("should throw NullPointerException");
        }
        catch (NullPointerException ne) {
            this.th.check(true);
        }
        v.add("a");
        try {
            v.retainAll(null);
            this.th.fail("should throw NullPointerException");
        }
        catch (NullPointerException ne) {
            this.th.check(true);
        }
        v.add("b");
        v.add(null);
        Vector c = v;
        v = this.buildknownV();
        this.th.check(v.retainAll(c), "checking returnvalue of retainAll -- 1");
        boolean bl = false;
        if (v.size() == 0) {
            bl = true;
        }
        this.th.check(bl, "v is emptied");
        v = this.buildknownV();
        v.addAll(c);
        this.th.check(v.retainAll(c), "checking returnvalue of retainAll -- 2");
        boolean bl2 = false;
        if (v.get(2) == null && v.get(1) == "b" && v.get(0) == "a") {
            bl2 = true;
        }
        this.th.check(bl2, "v is has elements of c");
        this.th.check(v.equals(c), "extra check on Vector.equals()");
        boolean bl3 = false;
        if (v.size() == 3) {
            bl3 = true;
        }
        this.th.check(bl3, "checking new size() -- 1");
        v = this.buildknownV();
        v.add(2, null);
        v.add(4, "a");
        v.add(9, "b");
        v.addAll(10, c);
        this.th.check(v.retainAll(c), "checking returnvalue of retainAll -- 3");
        boolean bl4 = false;
        if (v.get(0) == null && v.get(2) == "b" && v.get(1) == "a") {
            bl4 = true;
        }
        this.th.check(bl4, "multiple copies of an element shouldn't be deleted -- 1" + v);
        boolean bl5 = false;
        if (v.get(5) == null && v.get(4) == "b" && v.get(3) == "a") {
            bl5 = true;
        }
        this.th.check(bl5, "multiple copies of an element shouldn't be deleted -- 2" + v);
        boolean bl6 = false;
        if (v.size() == 6) {
            bl6 = true;
        }
        this.th.check(bl6, "checking new size() -- 2");
        v = this.buildknownV();
        v.add(2, null);
        this.th.check(v.retainAll(c), "checking returnvalue of retainAll -- 3");
        boolean bl7 = false;
        if (v.get(0) == null) {
            bl7 = true;
        }
        this.th.check(bl7, "checking contents of the vector -- 1");
        boolean bl8 = false;
        if (v.size() == 1) {
            bl8 = true;
        }
        this.th.check(bl8, "checking new size() -- 2");
    }

    public void test_set() throws UnsupportedOperationException {
        this.th.checkPoint("set(int,java.lang.Object)java.lang.Object");
        Vector v = new Vector();
        try {
            v.set(-1, "a");
            this.th.fail("should throw an ArrayIndexOutOfBoundsException -- 1");
        }
        catch (ArrayIndexOutOfBoundsException e) {
            this.th.check(true);
        }
        try {
            v.set(0, "a");
            this.th.fail("should throw an ArrayIndexOutOfBoundsException -- 2");
        }
        catch (ArrayIndexOutOfBoundsException e) {
            this.th.check(true);
        }
        v = this.buildknownV();
        try {
            v.set(-1, "a");
            this.th.fail("should throw an ArrayIndexOutOfBoundsException -- 3");
        }
        catch (ArrayIndexOutOfBoundsException e) {
            this.th.check(true);
        }
        try {
            v.set(11, "a");
            this.th.fail("should throw an ArrayIndexOutOfBoundsException -- 4");
        }
        catch (ArrayIndexOutOfBoundsException e) {
            this.th.check(true);
        }
        boolean bl = false;
        if (((Float)((Object)v.set(5, "a"))).intValue() == 5) {
            bl = true;
        }
        this.th.check(bl, "checking returnvalue of set -- 1");
        boolean bl2 = false;
        if (((Float)v.set(0, null)).intValue() == 0) {
            bl2 = true;
        }
        this.th.check(bl2, "checking returnvalue of set -- 2");
        boolean bl3 = false;
        if (v.get(5) == "a") {
            bl3 = true;
        }
        this.th.check(bl3, "checking effect of set -- 1");
        boolean bl4 = false;
        if (v.get(0) == null) {
            bl4 = true;
        }
        this.th.check(bl4, "checking effect of set -- 2");
        boolean bl5 = false;
        if (v.set(5, "a") == "a") {
            bl5 = true;
        }
        this.th.check(bl5, "checking returnvalue of set -- 3");
        boolean bl6 = false;
        if (v.set(0, null) == null) {
            bl6 = true;
        }
        this.th.check(bl6, "checking returnvalue of set -- 4");
        boolean bl7 = false;
        if (v.get(5) == "a") {
            bl7 = true;
        }
        this.th.check(bl7, "checking effect of set -- 1");
        boolean bl8 = false;
        if (v.get(0) == null) {
            bl8 = true;
        }
        this.th.check(bl8, "checking effect of set -- 2");
    }

    public void test_setElementAt() {
        this.th.checkPoint("setElementAt(java.lang.Object,int)void");
        Vector v = this.buildknownV();
        try {
            v.setElementAt("a", -1);
            this.th.fail("should throw ArrayIndexOutOfBoundsException -- 1");
        }
        catch (ArrayIndexOutOfBoundsException ae) {
            this.th.check(true);
        }
        try {
            v.setElementAt("a", 11);
            this.th.fail("should throw ArrayIndexOutOfBoundsException -- 2");
        }
        catch (ArrayIndexOutOfBoundsException ae) {
            this.th.check(true);
        }
        v.setElementAt("a", 5);
        boolean bl = false;
        if (v.elementAt(5) == "a") {
            bl = true;
        }
        this.th.check(bl, "validate set -- 1");
        v.setElementAt("b", 0);
        boolean bl2 = false;
        if (v.elementAt(0) == "b") {
            bl2 = true;
        }
        this.th.check(bl2, "validate set -- 2");
        v.setElementAt("c", 10);
        boolean bl3 = false;
        if (v.elementAt(10) == "c") {
            bl3 = true;
        }
        this.th.check(bl3, "validate set -- 3");
        v.setElementAt("d", 5);
        boolean bl4 = false;
        if (v.elementAt(5) == "d") {
            bl4 = true;
        }
        this.th.check(bl4, "validate set -- 4");
        this.th.check(v.contains("a") ^ true, "check contents -- 1");
        v.setElementAt(null, 5);
        boolean bl5 = false;
        if (v.elementAt(5) == null) {
            bl5 = true;
        }
        this.th.check(bl5, "validate set -- 5");
        v.setElementAt("a", 5);
        boolean bl6 = false;
        if (v.elementAt(5) == "a") {
            bl6 = true;
        }
        this.th.check(bl6, "validate set -- 6");
        this.th.check(v.contains(null) ^ true, "check contents -- 2");
    }

    public void test_setSize() {
        this.th.checkPoint("setSize(int)void");
        Vector v = this.buildknownV();
        try {
            v.setSize(-1);
            this.th.fail("should throw ArrayIndexOutOfBoundsException -- 1");
        }
        catch (ArrayIndexOutOfBoundsException ae) {
            this.th.check(true, "good job!");
        }
        boolean ok = true;
        int size = 25;
        v.setSize(size);
        boolean bl = false;
        if (v.size() == size) {
            bl = true;
        }
        this.th.check(bl, "checking new size -- 1");
        try {
            v.elementAt(size);
            this.th.fail("should throw ArrayIndexOutOfBoundsException -- 2");
        }
        catch (ArrayIndexOutOfBoundsException ae) {
            this.th.check(true);
        }
        int i = 0;
        while (i < 11) {
            if (((Float)v.elementAt(i)).intValue() != i) {
                ok = false;
            }
            ++i;
        }
        this.th.check(ok, "Float value didn't change -- 1");
        ok = true;
        i = 11;
        while (i < size) {
            if (v.elementAt(i) != null) {
                ok = false;
            }
            ++i;
        }
        this.th.check(ok, "null value not added -- 1");
        size = 5;
        v.setSize(size);
        boolean bl2 = false;
        if (v.size() == size) {
            bl2 = true;
        }
        this.th.check(bl2, "checking new size -- 2");
        i = 0;
        while (i < size) {
            if (((Float)v.elementAt(i)).intValue() != i) {
                ok = false;
            }
            ++i;
        }
        this.th.check(ok, "Float value didn't change -- 2");
        try {
            v.elementAt(size);
            this.th.fail("should throw ArrayIndexOutOfBoundsException -- 3");
        }
        catch (ArrayIndexOutOfBoundsException ae) {
            this.th.check(true);
        }
        size = 0;
        v.setSize(size);
        boolean bl3 = false;
        if (v.size() == size) {
            bl3 = true;
        }
        this.th.check(bl3, "checking new size -- 3");
        try {
            v.elementAt(size);
            this.th.fail("should throw ArrayIndexOutOfBoundsException -- 4");
        }
        catch (ArrayIndexOutOfBoundsException ae) {
            this.th.check(true);
        }
    }

    public void test_capacity() {
        this.th.checkPoint("capacity()int");
        Vector v = new Vector(15);
        boolean bl = false;
        if (v.capacity() == 15) {
            bl = true;
        }
        this.th.check(bl, "checking capacity");
    }

    public void test_ensureCapacity() {
        this.th.checkPoint("ensureCapacity(int)void");
        Vector v = new Vector(10);
        v.ensureCapacity(9);
        boolean bl = false;
        if (v.capacity() == 10) {
            bl = true;
        }
        this.th.check(bl, "checking capacity -- 1");
        v.ensureCapacity(15);
        boolean bl2 = false;
        if (v.capacity() == 20) {
            bl2 = true;
        }
        this.th.check(bl2, "checking capacity -- 2");
        v.ensureCapacity(41);
        boolean bl3 = false;
        if (v.capacity() == 41) {
            bl3 = true;
        }
        this.th.check(bl3, "checking capacity -- 3");
        v = new Vector(10, 15);
        v.ensureCapacity(9);
        boolean bl4 = false;
        if (v.capacity() == 10) {
            bl4 = true;
        }
        this.th.check(bl4, "checking capacity -- 4");
        v.ensureCapacity(15);
        boolean bl5 = false;
        if (v.capacity() == 25) {
            bl5 = true;
        }
        this.th.check(bl5, "checking capacity -- 5");
        v.ensureCapacity(55);
        boolean bl6 = false;
        if (v.capacity() == 55) {
            bl6 = true;
        }
        this.th.check(bl6, "checking capacity -- 6");
    }

    public void test_trimToSize() {
        this.th.checkPoint("trimToSize()void");
        Vector v = this.buildknownV();
        int size = v.size();
        v.ensureCapacity(20);
        v.trimToSize();
        boolean bl = false;
        if (v.capacity() == size) {
            bl = true;
        }
        this.th.check(bl);
        boolean ok = true;
        int i = 0;
        while (i < 11) {
            if (((Float)v.elementAt(i)).intValue() != i) {
                ok = false;
            }
            ++i;
        }
        this.th.check(ok, "Float values didn't change -- 1");
        v.addElement("a");
        boolean bl2 = false;
        if (v.capacity() == 22) {
            bl2 = true;
        }
        this.th.check(bl2, "adding an elements raises the capacity");
    }

    public void test_subList() throws UnsupportedOperationException {
        this.th.checkPoint("subList(int,int)java.util.List");
        Vector<String> v = new Vector<String>();
        try {
            v.subList(-1, 0);
            this.th.fail("should throw an IndexOutOfBoundsException -- 1");
        }
        catch (IndexOutOfBoundsException e) {
            this.th.check(true);
        }
        try {
            v.subList(0, 1);
            this.th.fail("should throw an IndexOutOfBoundsException -- 2");
        }
        catch (IndexOutOfBoundsException e) {
            this.th.check(true);
        }
        try {
            boolean bl = false;
            if (v.subList(0, 0).size() == 0) {
                bl = true;
            }
            this.th.check(bl);
        }
        catch (IndexOutOfBoundsException e) {
            this.th.fail("shouldn't throw an IndexOutOfBoundsException -- 3");
        }
        try {
            v.subList(1, 0);
            this.th.fail("should throw an IllegalArgumentException -- 4");
        }
        catch (IllegalArgumentException e) {
            this.th.check(true);
        }
        v = this.buildknownV();
        try {
            v.subList(-1, 6);
            this.th.fail("should throw an IndexOutOfBoundsException -- 5");
        }
        catch (IndexOutOfBoundsException e) {
            this.th.check(true);
        }
        try {
            v.subList(10, 9);
            this.th.fail("should throw an IllegalArgumentException -- 6");
        }
        catch (IllegalArgumentException e) {
            this.th.check(true);
        }
        try {
            v.subList(1, 12);
            this.th.fail("should throw an IndexOutOfBoundsException -- 7");
        }
        catch (IndexOutOfBoundsException e) {
            this.th.check(true);
        }
        try {
            boolean bl = false;
            if (v.subList(11, 11).size() == 0) {
                bl = true;
            }
            this.th.check(bl);
        }
        catch (IndexOutOfBoundsException e) {
            this.th.fail("shouldn't throw an IndexOutOfBoundsException -- 8");
        }
        List<String> l = v.subList(0, 11);
        this.th.check(v.equals(l), "checking sublist for equality");
        v.add("a");
        try {
            l.get(3);
            this.th.fail("should throw a ConcurrentModificationException -- 1");
        }
        catch (ConcurrentModificationException e) {
            this.th.check(true);
        }
        v = new Vector<String>();
        v.add("a");
        v.add("b");
        v.add(null);
        v.add("c");
        v.add("d");
        l = v.subList(2, 5);
        boolean bl = false;
        if (l.get(0) == null && l.get(1) == "c" && l.get(2) == "d") {
            bl = true;
        }
        this.th.check(bl, "checking elements -- 1");
        boolean bl2 = false;
        if (l.set(0, "g") == null) {
            bl2 = true;
        }
        this.th.check(bl2, "checking set");
        boolean bl3 = false;
        if (v.get(2) == "g") {
            bl3 = true;
        }
        this.th.check(bl3, "modifications in l should reflect on v -- 1");
        boolean bl4 = false;
        if (l.get(0) == "g" && l.get(1) == "c" && l.get(2) == "d") {
            bl4 = true;
        }
        this.th.check(bl4, "checking elements -- 1");
        l.clear();
        boolean bl5 = false;
        if (v.size() == 2 && v.get(0) == "a" && v.get(1) == "b") {
            bl5 = true;
        }
        this.th.check(bl5, "modifications in l should reflect on v -- 1");
        v.add(null);
        v.add("c");
        v.add("d");
        l = v.subList(2, 5);
        try {
            v.addAll(l);
            this.th.fail("should throw a ConcurrentModificationException");
        }
        catch (ConcurrentModificationException e) {
            this.th.check(true);
        }
    }

    public void test_toArray() {
        this.th.checkPoint("toArray()java.lang.Object[]");
        Vector v = new Vector();
        v.add("a");
        v.add(null);
        v.add("b");
        Object[] o = v.toArray();
        boolean bl = false;
        if (o[0] == "a" && o[1] == null && o[2] == "b") {
            bl = true;
        }
        this.th.check(bl, "checking elements -- 1");
        boolean bl2 = false;
        if (o.length == 3) {
            bl2 = true;
        }
        this.th.check(bl2, "checking size Object array");
        this.th.checkPoint("toArray(java.lang.Object[])java.lang.Object[]");
        v = new Vector();
        try {
            v.toArray((T[])null);
            this.th.fail("should throw NullPointerException -- 1");
        }
        catch (NullPointerException ne) {
            this.th.check(true);
        }
        v.add("a");
        v.add(null);
        v.add("b");
        String[] sa = new String[5];
        sa[3] = "deleteme";
        sa[4] = "leavemealone";
        boolean bl3 = false;
        if (v.toArray(sa) == sa) {
            bl3 = true;
        }
        this.th.check(bl3, "sa is large enough, no new array created");
        boolean bl4 = false;
        if (sa[0] == "a" && sa[1] == null && sa[2] == "b") {
            bl4 = true;
        }
        this.th.check(bl4, "checking elements -- 1" + sa[0] + ", " + sa[1] + ", " + sa[2]);
        boolean bl5 = false;
        if (sa.length == 5) {
            bl5 = true;
        }
        this.th.check(bl5, "checking size Object array");
        boolean bl6 = false;
        if (sa[3] == null && sa[4] == "leavemealone") {
            bl6 = true;
        }
        this.th.check(bl6, "check other elements -- 1" + sa[3] + ", " + sa[4]);
        v = this.buildknownV();
        try {
            v.toArray((T[])null);
            this.th.fail("should throw NullPointerException -- 2");
        }
        catch (NullPointerException ne) {
            this.th.check(true);
        }
        try {
            v.toArray(sa);
            this.th.fail("should throw an ArrayStoreException");
        }
        catch (ArrayStoreException ae) {
            this.th.check(true);
        }
        v.add(null);
        Float[] fa = new Float[12];
        Float[] far = v.toArray(fa);
        boolean bl7 = false;
        if (far == fa) {
            bl7 = true;
        }
        this.th.check(bl7, "returned array is the same");
        try {
            sa = (String[])v.toArray(fa);
            this.th.fail("should throw ClassCastException");
        }
        catch (ClassCastException ce) {
            this.th.check(true);
        }
    }

    public void test_clone() {
        this.th.checkPoint("clone()java.lang.Object");
        Vector<String> v = new Vector<String>(10, 5);
        v.addElement("a");
        v.addElement("b");
        v.addElement("c");
        Vector cv = (Vector)v.clone();
        boolean bl = false;
        if (cv.size() == v.size()) {
            bl = true;
        }
        this.th.check(bl, "checking size -- 1");
        boolean bl2 = false;
        if (cv.capacity() == v.capacity()) {
            bl2 = true;
        }
        this.th.check(bl2, "checking capacity -- 1");
        cv.ensureCapacity(11);
        boolean bl3 = false;
        if (cv.capacity() == 15) {
            bl3 = true;
        }
        this.th.check(bl3, "capacityIncrement was not defined correctly");
        boolean bl4 = false;
        if (v.capacity() == 10) {
            bl4 = true;
        }
        this.th.check(bl4, "changes in one object doen't affect the other -- 1");
        v.addElement("d");
        boolean bl5 = false;
        if (cv.size() == 3) {
            bl5 = true;
        }
        this.th.check(bl5, "changes in one object doen't affect the other -- 2");
    }

    public void test_equals() {
        this.th.checkPoint("equals(java.lang.Object)boolean");
        Vector<String> v = this.buildknownV();
        this.th.check(v.equals(this.buildknownV()), "objects are equal -- 1");
        v.removeElementAt(1);
        this.th.check(v.equals(this.buildknownV()) ^ true, "objects are not equal -- 1");
        v = this.buildknownV();
        v.ensureCapacity(25);
        this.th.check(v.equals(this.buildknownV()), "objects are equal -- 2");
        ArrayList<String> al = new ArrayList<String>(v);
        this.th.check(v.equals(al), "checking ... -- 1");
        v = new Vector<String>();
        al = new ArrayList();
        this.th.check(v.equals(al), "checking ... -- 2");
        v.add(null);
        al.add(null);
        this.th.check(v.equals(al), "checking ... -- 3");
        v.add("a");
        v.add(null);
        al.add(null);
        al.add("a");
        this.th.check(v.equals(al) ^ true, "checking ... -- 4");
    }

    public void test_hashCode() {
        this.th.checkPoint("hashCode()int");
        Vector<Object> v = new Vector<Object>();
        boolean bl = false;
        if (v.hashCode() == 1) {
            bl = true;
        }
        this.th.check(bl, "check calculation hashcode -- 1 - got: " + v.hashCode());
        v.addElement("a");
        boolean bl2 = false;
        if (v.hashCode() == 31 + "a".hashCode()) {
            bl2 = true;
        }
        this.th.check(bl2, "check calculation hashcode -- 2 - got: " + v.hashCode());
        Integer i = new Integer(324);
        v.addElement(i);
        boolean bl3 = false;
        if (v.hashCode() == 961 + 31 * "a".hashCode() + i.hashCode()) {
            bl3 = true;
        }
        this.th.check(bl3, "check calculation hashcode -- 3 - got: " + v.hashCode());
        v = new Vector();
        v.addElement(null);
        boolean bl4 = false;
        if (v.hashCode() == 31) {
            bl4 = true;
        }
        this.th.check(bl4, "check calculation hashcode -- 4 - got: " + v.hashCode());
    }

    public void test_toString() {
        this.th.checkPoint("toString()java.lang.String");
        Vector<Object> v = new Vector<Object>();
        this.th.check(v.toString().equals("[]"), "checking toString -- 1 - got: " + v);
        v.addElement("a");
        this.th.check(v.toString().equals("[a]"), "checking toString -- 2 - got: " + v);
        Integer i = new Integer(324);
        v.addElement(i);
        this.th.check(v.toString().equals("[a, 324]"), "checking toString -- 3 - got: " + v);
        v.addElement("abcd");
        this.th.check(v.toString().equals("[a, 324, abcd]"), "checking toString -- 4 - got: " + v);
    }

    public void test_iterator() {
        Object o;
        this.th.checkPoint("iterator()java.util.Iterator");
        Vector<String> v = new Vector<String>();
        v.add("a");
        v.add("c");
        v.add("u");
        v.add("n");
        v.add("i");
        v.add("a");
        v.add(null);
        v.add("!");
        Iterator it = v.iterator();
        Vector vc = (Vector)v.clone();
        int i = 0;
        while (it.hasNext()) {
            o = it.next();
            if (!vc.remove(o)) {
                this.th.debug("didn't find " + o + " in vector");
            }
            if (i++ > 20) break;
        }
        boolean bl = false;
        if (i < 20) {
            bl = true;
        }
        this.th.check(bl, "check for infinite loop");
        this.th.check(vc.isEmpty(), "all elements iterated");
        try {
            it.next();
            this.th.fail("should throw a NoSuchElementException");
        }
        catch (NoSuchElementException nsee) {
            this.th.check(true);
        }
        it = v.iterator();
        try {
            it.remove();
            this.th.fail("should throw an IllegalStateException -- 1");
        }
        catch (IllegalStateException ise) {
            this.th.check(true);
        }
        it.next();
        it.remove();
        try {
            it.remove();
            this.th.fail("should throw an IllegalStateException -- 2");
        }
        catch (IllegalStateException ise) {
            this.th.check(true);
        }
        v.add("new");
        try {
            it.next();
            this.th.fail("should throw a ConcurrentModificationException -- 1");
        }
        catch (ConcurrentModificationException cme) {
            this.th.check(true);
        }
        try {
            it.remove();
            this.th.fail("should throw a ConcurrentModificationException -- 2");
        }
        catch (ConcurrentModificationException cme) {
            this.th.check(true);
        }
        it = v.iterator();
        while (it.hasNext()) {
            o = it.next();
            it.remove();
            if (v.contains(o)) {
                this.th.fail("removed wrong element when tried to remove " + o + ", got:" + v);
            }
            if (i++ > 20) break;
        }
        this.th.check(v.isEmpty(), "all elements are removed");
        v.add("a");
        v.add("c");
        v.add("u");
        v.add("n");
        v.add("i");
        v.add("a");
        it = v.iterator();
        v.contains("a");
        v.containsAll(v);
        v.indexOf("a");
        v.isEmpty();
        v.lastIndexOf("a");
        v.size();
        v.get(2);
        v.hashCode();
        v.equals(v);
        v.toArray();
        v.toArray(new Object[2]);
        v.copyInto(new Object[10]);
        v.elementAt(2);
        v.elements();
        v.firstElement();
        v.lastElement();
        v.capacity();
        v.trimToSize();
        v.subList(2, 5);
        v.clone();
        v.toString();
        try {
            it.next();
            this.th.check(true, "Ok -- 1");
        }
        catch (Exception e) {
            this.th.fail("should not throw an Exception, got " + e);
        }
        it = v.iterator();
        v.add(3, "a");
        try {
            it.next();
            this.th.fail("should throw a ConcurrentModificationException -- add(int,Object)");
        }
        catch (ConcurrentModificationException cme) {
            this.th.check(true, "Ok -- 2");
        }
        it = v.iterator();
        v.add("a");
        try {
            it.next();
            this.th.fail("should throw a ConcurrentModificationException -- add(Object)");
        }
        catch (ConcurrentModificationException cme) {
            this.th.check(true, "Ok -- 3");
        }
        it = v.iterator();
        v.addAll((Collection)v.clone());
        try {
            it.next();
            this.th.fail("should throw a ConcurrentModificationException -- addAll(int,Col)");
        }
        catch (ConcurrentModificationException cme) {
            this.th.check(true, "Ok -- 4");
        }
        it = v.iterator();
        v.addAll(3, (Collection)v.clone());
        try {
            it.next();
            this.th.fail("should throw a ConcurrentModificationException -- addAll(Col)");
        }
        catch (ConcurrentModificationException cme) {
            this.th.check(true, "Ok -- 5");
        }
        it = v.iterator();
        v.addElement("b");
        try {
            it.next();
            this.th.fail("should throw a ConcurrentModificationException -- addElement");
        }
        catch (ConcurrentModificationException cme) {
            this.th.check(true, "Ok -- 6");
        }
        it = v.iterator();
        v.insertElementAt("b", 4);
        try {
            it.next();
            this.th.fail("should throw a ConcurrentModificationException -- insertElementAt");
        }
        catch (ConcurrentModificationException cme) {
            this.th.check(true, "Ok -- 7");
        }
        it = v.iterator();
        v.remove(4);
        try {
            it.next();
            this.th.fail("should throw a ConcurrentModificationException -- remove(int)");
        }
        catch (ConcurrentModificationException cme) {
            this.th.check(true, "Ok -- 8");
        }
        it = v.iterator();
        v.remove("b");
        try {
            it.next();
            this.th.fail("should throw a ConcurrentModificationException -- remove(Object)");
        }
        catch (ConcurrentModificationException cme) {
            this.th.check(true, "Ok -- 9");
        }
        Vector rv = new Vector();
        rv.add("a");
        rv.add("b");
        it = v.iterator();
        v.removeAll(rv);
        try {
            it.next();
            this.th.fail("should throw a ConcurrentModificationException -- removeAll");
        }
        catch (ConcurrentModificationException cme) {
            this.th.check(true, "Ok -- 10");
        }
        it = v.iterator();
        v.removeElement("c");
        try {
            it.next();
            this.th.fail("should throw a ConcurrentModificationException -- removeElement");
        }
        catch (ConcurrentModificationException cme) {
            this.th.check(true, "Ok -- 11");
        }
        it = v.iterator();
        v.removeElementAt(7);
        try {
            it.next();
            this.th.fail("should throw a ConcurrentModificationException -- removeElementAt");
        }
        catch (ConcurrentModificationException cme) {
            this.th.check(true, "Ok -- 12");
        }
        rv = (Vector)v.clone();
        rv.remove(null);
        rv.remove(null);
        rv.remove(null);
        v.add(null);
        it = v.iterator();
        v.retainAll(rv);
        try {
            it.next();
            this.th.fail("should throw a ConcurrentModificationException -- retainAll");
        }
        catch (ConcurrentModificationException cme) {
            this.th.check(true, "Ok -- 13");
        }
        it = v.iterator();
        v.set(2, "a");
        try {
            it.next();
            this.th.check(true, "Ok -- 14");
        }
        catch (ConcurrentModificationException cme) {
            this.th.fail("should NOT throw a ConcurrentModificationException -- set");
        }
        it = v.iterator();
        v.setElementAt("a", 1);
        try {
            it.next();
            this.th.check(true, "Ok -- 15");
        }
        catch (ConcurrentModificationException cme) {
            this.th.fail("should NOT throw a ConcurrentModificationException -- setElementAt");
        }
        it = v.iterator();
        v.setSize(v.size() - 2);
        try {
            it.next();
            this.th.fail("should throw a ConcurrentModificationException -- setSize");
        }
        catch (ConcurrentModificationException cme) {
            this.th.check(true, "Ok -- 16");
        }
        it = v.iterator();
        v.removeAllElements();
        try {
            it.next();
            this.th.fail("should throw a ConcurrentModificationException -- removeAllElements");
        }
        catch (ConcurrentModificationException cme) {
            this.th.check(true);
        }
        v.add("a");
        it = v.iterator();
        v.clear();
        try {
            it.next();
            this.th.fail("should throw a ConcurrentModificationException -- clear");
        }
        catch (ConcurrentModificationException cme) {
            this.th.check(true);
        }
    }

    public void test_behaviour() {
        this.th.checkPoint("Vector()");
        Vector v = this.buildknownV();
        ArrayList al = new ArrayList(v);
        boolean bl = false;
        if (al.size() == v.size()) {
            bl = true;
        }
        this.th.check(bl, "checking size");
        Iterator it = al.iterator();
        it.next();
        try {
            it.remove();
            this.th.check(true, "passed remove");
        }
        catch (Exception e) {
            this.th.fail("got bad exception, " + e);
        }
    }

    protected ArrayList buildAL() {
        Vector<String> v = new Vector<String>();
        v.add("a");
        v.add("c");
        v.add("u");
        v.add("n");
        v.add("i");
        v.add("a");
        v.add(null);
        v.add("a");
        v.add("c");
        v.add("u");
        v.add("n");
        v.add("i");
        v.add("a");
        v.add(null);
        return new ArrayList(v);
    }
}

