/*
 * Decompiled with CFR 0.152.
 */
package gnu.testlet.wonka.util.TreeSet;

import gnu.testlet.TestHarness;
import gnu.testlet.Testlet;
import java.util.Comparator;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.Vector;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class AcuniaTreeSetTest
implements Testlet {
    protected TestHarness th;
    protected ToStringComparator TSComp;
    private final String st = "a";
    private final String b = "new Byte((byte)97)";
    private final String sh = "new Short((short)97)";
    private final String i = "new Integer(97)";
    private final String l = "new Long(97L)";
    private int sqnce;

    public void test(TestHarness harness) {
        this.th = harness;
        this.th.setclass("java.util.TreeSet");
        this.test_TreeSet();
        this.test_first();
        this.test_last();
        this.test_contains();
        this.test_isEmpty();
        this.test_size();
        this.test_add();
        this.test_clear();
        this.test_remove();
        this.test_iterator();
        this.test_clone();
        this.test_behaviour();
        this.test_headSet();
        this.test_subSet();
        this.test_tailSet();
        this.test_comparator();
    }

    public void test_TreeSet() {
        this.th.checkPoint("TreeSet(java.util.Collection)");
        Vector<String> v = new Vector<String>();
        v.add("a");
        v.add("null");
        v.add("c");
        v.add("this");
        v.add("a");
        v.add("null");
        TreeSet hs = new TreeSet(v);
        this.th.check(hs.size(), 4, "checking size -- 1");
        this.th.check(hs.contains("this"), "checking elements -- 1");
        this.th.check(hs.contains("null"), "checking elements -- 2");
        try {
            new TreeSet(null);
            this.th.fail("should throw a NullPointerException");
        }
        catch (NullPointerException e) {
            this.th.check(true);
        }
    }

    public void test_contains() {
        this.th.checkPoint("contains(java.lang.Object)boolean");
        TreeSet<String> al = new TreeSet<String>();
        this.th.check(al.contains(null) ^ true, "checking empty List -- 1");
        this.th.check(al.contains(al) ^ true, "checking empty List -- 2");
        al.add("a");
        al.add("null");
        al.add("6");
        this.th.check(al.contains("null"), "check contains ... -- 1");
        this.th.check(al.contains("a"), "check contains ... -- 2");
        this.th.check(al.contains("this") ^ true, "check contains ... -- 3");
        al.remove("6");
        al.remove("null");
        this.th.check(al.contains("null") ^ true, "check contains ... -- 4");
        this.th.check(al.contains("6") ^ true, "check contains ... -- 5");
    }

    public void test_isEmpty() {
        this.th.checkPoint("isEmpty()boolean");
        TreeSet<String> hs = new TreeSet<String>();
        this.th.check(hs.isEmpty(), "isEmpty -- 1");
        hs.add("a");
        this.th.check(hs.isEmpty() ^ true, "isEmpty -- 2");
        hs.clear();
        this.th.check(hs.isEmpty(), "isEmpty -- 3");
        hs.add("B");
        this.th.check(hs.isEmpty() ^ true, "isEmpty -- 4");
        hs.remove("B");
        this.th.check(hs.isEmpty(), "isEmpty -- 5");
    }

    public void test_size() {
        this.th.checkPoint("size()int");
        TreeSet<String> hs = new TreeSet<String>();
        this.th.check(hs.size(), 0, "verifying size -- 1");
        hs.add("a");
        this.th.check(hs.size(), 1, "verifying size -- 2");
        hs.add("B");
        this.th.check(hs.size(), 2, "verifying size -- 3");
        hs.add("B");
        this.th.check(hs.size(), 2, "verifying size -- 4");
        hs.add("null");
        this.th.check(hs.size(), 3, "verifying size -- 5");
        hs.remove("not");
        this.th.check(hs.size(), 3, "verifying size -- 6");
        hs.remove("B");
        this.th.check(hs.size(), 2, "verifying size -- 7");
        hs.clear();
        this.th.check(hs.size(), 0, "verifying size -- 8");
    }

    public void test_add() {
        this.th.checkPoint("add(java.lang.Object)boolean");
        TreeSet<String> hs = new TreeSet<String>();
        this.th.check(hs.add("a"), "checking return value -- 1");
        this.th.check(hs.add("c"), "checking return value -- 2");
        this.th.check(hs.add("a") ^ true, "checking return value -- 3");
        this.th.check(hs.add("null"), "checking return value -- 4");
        this.th.check(hs.add("null") ^ true, "checking return value -- 5");
        boolean bl = false;
        if (hs.size() == 3) {
            bl = true;
        }
        this.th.check(bl, "duplicate elements aren't added");
    }

    public void test_clear() {
        this.th.checkPoint("clear()void");
        TreeSet<String> hs = new TreeSet<String>();
        hs.clear();
        hs.add("a");
        hs.clear();
        this.th.check(hs.size(), 0, "TreeSet is cleared");
    }

    public void test_remove() {
        this.th.checkPoint("remove(java.lang.Object)boolean");
        TreeSet<String> hs = new TreeSet<String>();
        hs.clear();
        hs.add("a");
        hs.clear();
        this.th.check(hs.remove("null") ^ true, "nothing to remove -- 1");
        this.th.check(hs.size(), 0, "TreeSet is cleared");
        hs.add("a");
        this.th.check(hs.remove("null") ^ true, "nothing to remove -- 2");
        this.th.check(hs.size(), 1, "TreeSet is cleared");
        hs.add("null");
        this.th.check(hs.remove("C") ^ true, "nothing to remove -- 3");
        this.th.check(hs.remove("a"), "remove -- 1");
        this.th.check(hs.remove("a") ^ true, "remove -- 2");
        this.th.check(hs.remove("null"), "remove -- 3");
        this.th.check(hs.remove("null") ^ true, "remove -- 4");
    }

    public void test_iterator() {
        Object o;
        this.th.checkPoint("iterator()java.util.Iterator");
        TreeSet<String> v = new TreeSet<String>();
        v.add("a");
        v.add("c");
        v.add("u");
        v.add("n");
        v.add("i");
        v.add("null");
        v.add("!");
        Iterator it = v.iterator();
        TreeSet vc = (TreeSet)v.clone();
        int i = 0;
        while (it.hasNext()) {
            o = it.next();
            if (!vc.remove(o)) {
                this.th.debug("didn't find " + o + " in vector");
            }
            if (i++ > 20) break;
        }
        boolean bl = false;
        if (i < 20) {
            bl = true;
        }
        this.th.check(bl, "check for infinite loop");
        this.th.check(vc.isEmpty(), "all elements iterated");
        try {
            it.next();
            this.th.fail("should throw a NoSuchElementException");
        }
        catch (NoSuchElementException nsee) {
            this.th.check(true);
        }
        it = v.iterator();
        try {
            it.remove();
            this.th.fail("should throw an IllegalStateException -- 1");
        }
        catch (IllegalStateException ise) {
            this.th.check(true);
        }
        it.next();
        it.remove();
        try {
            it.remove();
            this.th.fail("should throw an IllegalStateException -- 2");
        }
        catch (IllegalStateException ise) {
            this.th.check(true);
        }
        it.next();
        v.add("new");
        try {
            it.next();
            this.th.fail("should throw a ConcurrentModificationException -- 1");
        }
        catch (ConcurrentModificationException cme) {
            this.th.check(true);
        }
        try {
            it.remove();
            this.th.fail("should throw a ConcurrentModificationException -- 2");
        }
        catch (ConcurrentModificationException cme) {
            this.th.check(true);
        }
        i = 0;
        it = v.iterator();
        while (it.hasNext()) {
            o = it.next();
            it.remove();
            if (v.contains(o)) {
                this.th.fail("removed wrong element when tried to remove " + o + ", got:" + v);
            }
            if (i++ > 20) break;
        }
        this.th.check(v.isEmpty(), "all elements are removed");
        v.add("a");
        v.add("c");
        v.add("u");
        v.add("n");
        v.add("i");
        it = v.iterator();
        v.contains("a");
        v.isEmpty();
        v.clone();
        v.iterator();
        try {
            it.next();
            this.th.check(true, "Ok -- 1");
        }
        catch (Exception e) {
            this.th.fail("should not throw an Exception, got " + e);
        }
        it = v.iterator();
        v.add("null");
        try {
            it.next();
            this.th.fail("should throw a ConcurrentModificationException -- add(Object)");
        }
        catch (ConcurrentModificationException cme) {
            this.th.check(true, "Ok -- 2");
        }
        it = v.iterator();
        v.remove("a");
        try {
            it.next();
            this.th.fail("should throw a ConcurrentModificationException -- remove(Object)");
        }
        catch (ConcurrentModificationException cme) {
            this.th.check(true, "Ok -- 3");
        }
        it = v.iterator();
        v.clear();
        try {
            it.next();
            this.th.fail("should throw a ConcurrentModificationException -- clear");
        }
        catch (ConcurrentModificationException cme) {
            this.th.check(true);
        }
    }

    public void test_clone() {
        this.th.checkPoint("clone()java.lang.Object");
        TreeSet<String> hs = new TreeSet<String>();
        TreeSet clone = (TreeSet)hs.clone();
        this.th.check(clone.isEmpty(), "clone is empty");
        this.th.check(clone.add("a"), "clone can be modified");
        this.th.check(hs.size(), 0, "changing clone didn't modify set -- 1");
        hs.add("null");
        hs.add("a");
        hs.add("this");
        clone = (TreeSet)hs.clone();
        this.th.check(clone.size(), 3, "checking cloned size");
        this.th.check(clone.remove("this"), "checking elements of clone -- 1");
        this.th.check(clone.add("null") ^ true, "checking elements of clone -- 2");
        this.th.check(clone.add("a") ^ true, "checking elements of clone -- 2");
        this.th.check(hs.size(), 3, "changing clone didn't modify set -- 2");
    }

    public void test_first() {
        this.th.checkPoint("first()java.lang.Object");
        TreeSet<String> ts = new TreeSet<String>();
        try {
            ts.first();
            this.th.fail("should throw a NoSuchElementException -- 1");
        }
        catch (NoSuchElementException nse) {
            this.th.check(true);
        }
        ts.add("g");
        this.th.check(ts.first(), "g", "one element --> first");
        ts.add("f");
        this.th.check(ts.first(), "f", "two elements --> first");
        ts.add("h");
        this.th.check(ts.first(), "f", "three elements --> first");
        ts.add("a");
        this.th.check(ts.first(), "a", "four elements --> first");
        ts.clear();
        try {
            ts.first();
            this.th.fail("should throw a NoSuchElementException -- 2");
        }
        catch (NoSuchElementException nse) {
            this.th.check(true);
        }
    }

    protected TreeSet buildAlfabet() {
        TreeSet<String> t = new TreeSet<String>();
        t.add("a");
        t.add("b");
        t.add("c");
        t.add("d");
        t.add("h");
        t.add("g");
        t.add("f");
        t.add("e");
        t.add("i");
        t.add("j");
        t.add("k");
        t.add("l");
        t.add("p");
        t.add("o");
        t.add("n");
        t.add("m");
        t.add("q");
        t.add("r");
        t.add("s");
        t.add("t");
        t.add("x");
        t.add("w");
        t.add("v");
        t.add("u");
        t.add("y");
        t.add("z");
        return t;
    }

    public void test_last() {
        this.th.checkPoint("last()java.lang.Object");
        TreeSet<String> ts = new TreeSet<String>();
        try {
            ts.last();
            this.th.fail("should throw a NoSuchElementException -- 1");
        }
        catch (NoSuchElementException nse) {
            this.th.check(true);
        }
        ts.add("g");
        this.th.check(ts.last(), "g", "one element --> last");
        ts.add("h");
        this.th.check(ts.last(), "h", "two elements --> last");
        ts.add("a");
        this.th.check(ts.last(), "h", "three elements --> last");
        ts.add("x");
        this.th.check(ts.last(), "x", "four elements --> last");
        ts.clear();
        try {
            ts.last();
            this.th.fail("should throw a NoSuchElementException -- 2");
        }
        catch (NoSuchElementException nse) {
            this.th.check(true);
        }
    }

    public void test_headSet() {
        this.th.checkPoint("headSet(java.lang.Object)java.util.SortedSet");
        TreeSet ts = this.buildAlfabet();
        SortedSet<String> s = ts.headSet("a");
        this.th.check(s.isEmpty(), "headSet Should be empty");
        this.th.check(s.comparator(), null, "comparator stays the same");
        try {
            String o = s.first();
            this.th.fail("should throw a NoSuchElementException, but got " + o + " -- 1");
        }
        catch (NoSuchElementException nse) {
            this.th.check(true);
        }
        try {
            s.last();
            this.th.fail("should throw a NoSuchElementException -- 2");
        }
        catch (NoSuchElementException nse) {
            this.th.check(true);
        }
        s = ts.headSet("h");
        this.th.check(s.size(), 7, "headSet Should be empty");
        this.th.check(s.first(), "a", "first element is a");
        this.th.check(s.last(), "g", "last element is g");
        s = s.subSet("d", "g");
        this.th.check(s.size(), 3, "headSet Should be empty");
        this.th.check(s.first(), "d", "first element is e");
        this.th.check(s.last(), "f", "last element is g");
    }

    public void test_tailSet() {
        String o;
        this.th.checkPoint("tailSet(java.lang.Object)java.util.SortedSet");
        TreeSet ts = this.buildAlfabet();
        SortedSet<String> s = ts.tailSet("za");
        this.th.check(s.isEmpty(), "tailSet Should be empty");
        try {
            o = s.first();
            this.th.fail("should throw a NoSuchElementException, but got " + o + " -- 1");
        }
        catch (NoSuchElementException nse) {
            this.th.check(true);
        }
        try {
            o = s.last();
            this.th.fail("should throw a NoSuchElementException, but got " + o + " -- 2");
        }
        catch (NoSuchElementException nse) {
            this.th.check(true);
        }
        s = ts.tailSet("t");
        this.th.check(s.size(), 7, "tailSet Should be empty");
        this.th.check(s.first(), "t", "first element is t");
        this.th.check(s.last(), "z", "last element is z");
        s = s.subSet("v", "y");
        this.th.check(s.size(), 3, "tailSet has size 3");
        this.th.check(s.first(), "v", "first element is v");
        this.th.check(s.last(), "x", "last element is x");
        try {
            s.add("p");
            this.th.fail("should throw an IllegalArgumentException -- 1");
        }
        catch (IllegalArgumentException iae) {
            this.th.check(true);
        }
        this.th.check(s.remove("p") ^ true, "should not remove elements out range");
    }

    public void test_subSet() {
        String o;
        this.th.checkPoint("subSet(java.lang.Object,java.lang.Object)java.util.SortedSet");
        TreeSet<String> ts = new TreeSet<String>(this.TSComp);
        ts.addAll(this.buildAlfabet());
        SortedSet<String> s = ts.subSet("", " ");
        try {
            ts.subSet("x", "a");
            this.th.fail("should throw an IllegalArgumentException -- 1");
        }
        catch (IllegalArgumentException iae) {
            this.th.check(true);
        }
        this.th.check(s.isEmpty(), "headSet Should be empty");
        this.th.check(s.comparator(), this.TSComp, "comparator stays the same");
        try {
            o = s.first();
            this.th.fail("should throw a NoSuchElementException, but got " + o + " -- 1");
        }
        catch (NoSuchElementException nse) {
            this.th.check(true);
        }
        try {
            o = s.last();
            this.th.fail("should throw a NoSuchElementException, but got " + o + " -- 2");
        }
        catch (NoSuchElementException nse) {
            this.th.check(true);
        }
        s = ts.subSet("h", "na");
        this.th.check(s.size(), 7, "headSet Should be empty");
        this.th.check(s.first(), "h", "first element is h");
        this.th.check(s.last(), "n", "last element is n");
        try {
            s.subSet("a", "j");
            this.th.fail("should throw an IllegalArgumentException -- 2");
        }
        catch (IllegalArgumentException iae) {
            this.th.check(true);
        }
        try {
            s.subSet("j", "p");
            this.th.fail("should throw an IllegalArgumentException -- 3");
        }
        catch (IllegalArgumentException iae) {
            this.th.check(true);
        }
        try {
            s.add("p");
            this.th.fail("should throw an IllegalArgumentException -- 4");
        }
        catch (IllegalArgumentException iae) {
            this.th.check(true);
        }
        this.th.check(s.remove("p") ^ true, "should not remove elements out range");
        s = s.tailSet("k");
        this.th.check(s.size(), 4, "subSet Should be empty");
        this.th.check(s.first(), "k", "first element is k");
        this.th.check(s.last(), "n", "last element is n");
    }

    public void test_comparator() {
        this.th.checkPoint("comparator()java.util.Comparator");
        TreeSet<String> tm = new TreeSet<String>(null);
        this.th.check(tm.comparator(), null, "null comparator used");
        tm = new TreeSet(this.TSComp);
        this.th.check(tm.comparator(), this.TSComp, "TSComp comparator used");
        this.th.check(tm.tailSet("f").comparator(), this.TSComp, "TSComp passes to subSets -- 1");
        this.th.check(tm.headSet("f").comparator(), this.TSComp, "TSComp passes to subSets -- 2");
        this.th.check(tm.subSet("f", "g").comparator(), this.TSComp, "TSComp passes to subSets -- 3");
    }

    protected void check_presence(SortedSet h) {
        this.th.check(h.add("a") ^ true, "checking presence st -- sequence " + this.sqnce);
        this.th.check(h.add("new Short((short)97)") ^ true, "checking presence sh -- sequence " + this.sqnce);
        this.th.check(h.add("new Integer(97)") ^ true, "checking presence i -- sequence " + this.sqnce);
        this.th.check(h.add("new Byte((byte)97)") ^ true, "checking presence b -- sequence " + this.sqnce);
        this.th.check(h.add("new Long(97L)") ^ true, "checking presence l -- sequence " + this.sqnce);
        ++this.sqnce;
    }

    public String newFloat(float j) {
        return j + " float";
    }

    public void test_behaviour() {
        String f;
        this.th.checkPoint("behaviour testing");
        SortedSet<String> h = new TreeSet<String>().subSet("", "x");
        int j = 0;
        h.add("a");
        h.add("new Byte((byte)97)");
        h.add("new Short((short)97)");
        h.add("new Integer(97)");
        h.add("new Long(97L)");
        this.check_presence(h);
        this.sqnce = 1;
        while (j < 100) {
            f = this.newFloat(j);
            h.add(f);
            ++j;
        }
        boolean bl = false;
        if (h.size() == 105) {
            bl = true;
        }
        this.th.check(bl, "size checking -- 1 got: " + h.size());
        this.check_presence(h);
        while (j < 200) {
            f = this.newFloat(j);
            h.add(f);
            ++j;
        }
        boolean bl2 = false;
        if (h.size() == 205) {
            bl2 = true;
        }
        this.th.check(bl2, "size checking -- 2 got: " + h.size());
        this.check_presence(h);
        while (j < 500) {
            f = this.newFloat(j);
            h.add(f);
            ++j;
        }
        boolean bl3 = false;
        if (h.size() == 505) {
            bl3 = true;
        }
        this.th.check(bl3, "size checking -- 3 got: " + h.size());
        this.check_presence(h);
        this.th.check(h.add("a") ^ true, "replacing values -- 1 - st");
        this.th.check(h.add("new Byte((byte)97)") ^ true, "replacing values -- 2 - b");
        this.th.check(h.add("new Short((short)97)") ^ true, "replacing values -- 3 -sh");
        this.th.check(h.add("new Integer(97)") ^ true, "replacing values -- 4 -i");
        this.th.check(h.add("new Long(97L)") ^ true, "replacing values -- 5 -l");
        while (j > 199) {
            f = this.newFloat(j);
            h.remove(f);
            --j;
        }
        boolean bl4 = false;
        if (h.size() == 205) {
            bl4 = true;
        }
        this.th.check(bl4, "size checking -- 4 got: " + h.size());
        this.check_presence(h);
        while (j > 99) {
            f = this.newFloat(j);
            h.remove(f);
            --j;
        }
        boolean bl5 = false;
        if (h.size() == 105) {
            bl5 = true;
        }
        this.th.check(bl5, "size checking -- 5 got: " + h.size());
        this.check_presence(h);
        while (j > -1) {
            f = this.newFloat(j);
            h.remove(f);
            --j;
        }
        boolean bl6 = false;
        if (h.size() == 5) {
            bl6 = true;
        }
        this.th.check(bl6, "size checking -- 6 got: " + h.size());
        this.th.debug(h.toString());
        this.check_presence(h);
    }

    private final /* synthetic */ void this() {
        this.TSComp = new ToStringComparator();
        this.sqnce = 1;
    }

    public AcuniaTreeSetTest() {
        this.this();
    }

    public static class ToStringComparator
    implements Comparator {
        public int compare(Object one, Object two) {
            if (one == null) {
                if (two == null) {
                    return 0;
                }
                return -two.toString().compareTo("null");
            }
            if (two == null) {
                return one.toString().compareTo("null");
            }
            return one.toString().compareTo(two.toString());
        }
    }
}

