/*
 * Decompiled with CFR 0.152.
 */
package gnu.testlet.wonka.util.TreeMap;

import gnu.testlet.TestHarness;
import gnu.testlet.Testlet;
import java.util.Collection;
import java.util.Comparator;
import java.util.ConcurrentModificationException;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.Vector;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class AcuniaTreeMapTest
implements Testlet {
    protected TestHarness th;
    protected ToStringComparator TSComp;
    private final String st = "a";
    private final String b = "b";
    private final String sh = "sh";
    private final String i = "i";
    private final String l = "l";
    private int sqnce;

    public void test(TestHarness harness) {
        this.th = harness;
        this.th.setclass("java.util.TreeMap");
        this.test_TreeMap();
        this.test_get();
        this.test_containsKey();
        this.test_containsValue();
        this.test_isEmpty();
        this.test_size();
        this.test_clear();
        this.test_put();
        this.test_putAll();
        this.test_remove();
        this.test_entrySet();
        this.test_keySet();
        this.test_values();
        this.test_clone();
        this.test_comparator();
        this.test_firstKey();
        this.test_lastKey();
        this.test_headMap();
        this.test_subMap();
        this.test_tailMap();
        this.test_behaviour();
        this.test_behaviour2();
    }

    protected TreeMap buildHM() {
        TreeMap<String, String> hm = new TreeMap<String, String>();
        int i = 0;
        while (i < 15) {
            String s = "a" + i;
            hm.put(s, s + " value");
            ++i;
        }
        hm.put("null", null);
        return hm;
    }

    public void test_TreeMap() {
        this.th.checkPoint("TreeMap()");
        this.th.checkPoint("TreeMap(java.util.Map)");
        TreeMap hm1 = this.buildHM();
        TreeMap hm = new TreeMap(hm1);
        boolean bl = false;
        if (hm.size() == 16) {
            bl = true;
        }
        this.th.check(bl, "all elements are put, got " + hm.size());
        try {
            hm.get(null);
            this.th.fail("should throw a NullPointerException -- 1");
        }
        catch (NullPointerException ne) {
            this.th.check(true);
        }
        this.th.check("a1 value".equals(hm.get("a1")), "test key and value pairs -- 2");
        this.th.check("a10 value".equals(hm.get("a10")), "test key and value pairs -- 3");
        this.th.check("a0 value".equals(hm.get("a0")), "test key and value pairs -- 4");
        hm = new TreeMap(new Hashtable());
        boolean bl2 = false;
        if (hm.size() == 0) {
            bl2 = true;
        }
        this.th.check(bl2, "no elements are put, got " + hm.size());
        try {
            new TreeMap(null);
            this.th.fail("should throw a NullPointerException -- 2");
        }
        catch (NullPointerException ne) {
            this.th.check(true);
        }
        try {
            new TreeMap(null);
            this.th.fail("should throw a NullPointerException -- 3");
        }
        catch (NullPointerException ne) {
            this.th.check(true);
        }
        hm = new TreeMap(this.TSComp);
        this.th.check(hm.comparator(), this.TSComp, "comparator should be used");
        hm.put("f", null);
        hm.put(null, null);
        hm = new TreeMap(hm);
        this.th.check(hm.comparator(), this.TSComp, "comparator should be taken from SortedSet");
    }

    public void test_get() {
        this.th.checkPoint("get(java.lang.Object)java.lang.Object");
        TreeMap hm = this.buildHM();
        try {
            hm.get(this);
            this.th.fail("should throw a ClassCastException");
        }
        catch (ClassCastException e) {
            this.th.check(true);
        }
        try {
            hm.get(null);
            this.th.fail("should throw a NullPointerException");
        }
        catch (NullPointerException e) {
            this.th.check(true);
        }
        this.th.check(hm.get("bad key"), null, "checking get -- 1");
        this.th.check(hm.get("null"), null, "checking get -- 2");
        hm.put("a", this);
        this.th.check(hm.get("a1"), "a1 value", "checking get -- 3");
        this.th.check(hm.get("a11"), "a11 value", "checking get -- 4");
    }

    public void test_containsKey() {
        this.th.checkPoint("containsKey(java.lang.Object)boolean");
        TreeMap hm = new TreeMap();
        hm.clear();
        this.th.check(hm.containsKey(null) ^ true, "Map is empty");
        hm.put("a", this);
        this.th.check(hm.containsKey("null") ^ true, "Map does not contains the key -- 1");
        this.th.check(hm.containsKey("a"), "Map does contain the key -- 2");
        hm = this.buildHM();
        this.th.check(hm.containsKey("null"), "Map does contain the key -- 3");
        try {
            hm.containsKey(this);
            this.th.fail("should throw a ClassCastException");
        }
        catch (ClassCastException e) {
            this.th.check(true);
        }
        try {
            hm.containsKey(null);
            this.th.fail("should throw a NullPointerException");
        }
        catch (NullPointerException e) {
            this.th.check(true);
        }
    }

    public void test_containsValue() {
        this.th.checkPoint("containsValue(java.lang.Object)boolean");
        TreeMap hm = new TreeMap();
        hm.clear();
        this.th.check(hm.containsValue(null) ^ true, "Map is empty");
        hm.put("a", this);
        this.th.check(hm.containsValue(null) ^ true, "Map does not containsthe value -- 1");
        this.th.check(hm.containsValue("a") ^ true, "Map does  not contain the value -- 2");
        this.th.check(hm.containsValue(this), "Map does contain the value -- 3");
        hm = this.buildHM();
        this.th.check(hm.containsValue(null), "Map does contain the value -- 4");
        this.th.check(hm.containsValue(this) ^ true, "Map does not contain the value -- 5");
        this.th.check(hm.containsValue("a1value") ^ true, "Map does  not contain the value -- 6");
    }

    public void test_isEmpty() {
        this.th.checkPoint("isEmpty()boolean");
        TreeMap<String, AcuniaTreeMapTest> hm = new TreeMap<String, AcuniaTreeMapTest>();
        this.th.check(hm.isEmpty(), "Map is empty");
        hm.put("a", this);
        this.th.check(hm.isEmpty() ^ true, "Map is not empty");
    }

    public void test_size() {
        this.th.checkPoint("size()int");
        TreeMap hm = new TreeMap();
        this.th.check(hm.size(), 0, "Map is empty -- 1");
        hm.put("a", this);
        this.th.check(hm.size(), 1, "Map has 1 element");
        hm = this.buildHM();
        this.th.check(hm.size(), 16, "Map has 16 elements");
        hm.remove("null");
        this.th.check(hm.size(), 15, "Map has 15 elements");
        hm.clear();
        this.th.check(hm.size(), 0, "Map is empty -- 2");
    }

    public void test_clear() {
        this.th.checkPoint("clear()void");
        TreeMap hm = this.buildHM();
        hm.clear();
        boolean bl = false;
        if (hm.size() == 0) {
            bl = true;
        }
        this.th.check(bl, "Map is cleared -- 1");
        this.th.check(hm.isEmpty(), "Map is cleared -- 2");
    }

    public void test_put() {
        this.th.checkPoint("put(java.lang.Object,java.lang.Object)java.lang.Object");
        TreeMap<String, Object> hm = new TreeMap<String, Object>();
        boolean bl = false;
        if (hm.put("null", this) == null) {
            bl = true;
        }
        this.th.check(bl, "check on return value -- 1");
        boolean bl2 = false;
        if (hm.get("null") == this) {
            bl2 = true;
        }
        this.th.check(bl2, "check on value -- 1");
        boolean bl3 = false;
        if (hm.put("null", "a") == this) {
            bl3 = true;
        }
        this.th.check(bl3, "check on return value -- 2");
        this.th.check("a".equals(hm.get("null")), "check on value -- 2");
        this.th.check("a".equals(hm.put("null", "a")), "check on return value -- 3");
        this.th.check("a".equals(hm.get("null")), "check on value -- 3");
        boolean bl4 = false;
        if (hm.size() == 1) {
            bl4 = true;
        }
        this.th.check(bl4, "only one key added");
        boolean bl5 = false;
        if (hm.put("a", null) == null) {
            bl5 = true;
        }
        this.th.check(bl5, "check on return value -- 4");
        boolean bl6 = false;
        if (hm.get("a") == null) {
            bl6 = true;
        }
        this.th.check(bl6, "check on value -- 4");
        boolean bl7 = false;
        if (hm.put("a", this) == null) {
            bl7 = true;
        }
        this.th.check(bl7, "check on return value -- 5");
        boolean bl8 = false;
        if (hm.get("a") == this) {
            bl8 = true;
        }
        this.th.check(bl8, "check on value -- 5");
        this.th.check(hm.size(), 2, "two keys added");
    }

    public void test_putAll() {
        this.th.checkPoint("putAll(java.util.Map)void");
        TreeMap<Object, Object> hm = new TreeMap<Object, Object>();
        hm.putAll(new Hashtable());
        this.th.check(hm.isEmpty(), "nothing addad");
        hm.putAll(this.buildHM());
        this.th.check(hm.size(), 16, "checking if all elements are added -- 1");
        this.th.check(hm.equals(this.buildHM()), "check on all elements -- 1");
        hm.put("null", this);
        hm.putAll(this.buildHM());
        this.th.check(hm.size(), 16, "checking if all elements are added -- 2");
        this.th.check(hm.equals(this.buildHM()), "check on all elements -- 2");
        try {
            hm.putAll(null);
            this.th.fail("should throw a NullPointerException");
        }
        catch (NullPointerException npe) {
            this.th.check(true);
        }
    }

    public void test_remove() {
        this.th.checkPoint("remove(java.lang.Object)java.lang.Object");
        TreeMap hm = this.buildHM();
        boolean bl = false;
        if (hm.remove("null") == null) {
            bl = true;
        }
        this.th.check(bl, "checking return value -- 1");
        boolean bl2 = false;
        if (hm.remove("null") == null) {
            bl2 = true;
        }
        this.th.check(bl2, "checking return value -- 2");
        this.th.check(hm.containsKey("null") ^ true, "checking removed key -- 1");
        int i = 0;
        while (i < 15) {
            this.th.check(hm.remove("a" + i), "a" + i + " value", " removing a" + i);
            this.th.check(hm.remove("a" + i), null, " removing a" + i);
            ++i;
        }
        this.th.check(hm.isEmpty(), "checking if al is gone");
    }

    public void test_entrySet() {
        this.th.checkPoint("entrySet()java.util.Set");
        TreeMap hm = this.buildHM();
        Set s = hm.entrySet();
        Iterator it = s.iterator();
        Map.Entry me = null;
        it.next();
        try {
            s.add("ADDING");
            this.th.fail("should throw an UnsupportedOperationException");
        }
        catch (UnsupportedOperationException uoe) {
            this.th.check(true);
        }
        this.th.check(s.size(), 16, "checking size -- 1");
        hm.remove("a12");
        this.th.check(s.size(), 15, "checking size -- 2");
        this.th.check(it.hasNext());
        try {
            it.next();
            this.th.fail("should throw a ConcurrentModificationException -- 1");
        }
        catch (ConcurrentModificationException cme) {
            this.th.check(true);
        }
        try {
            it.remove();
            this.th.fail("should throw a ConcurrentModificationException -- 2");
        }
        catch (ConcurrentModificationException cme) {
            this.th.check(true);
        }
        it = s.iterator();
        try {
            me = it.next();
            if (me.getKey() == null) {
                me = it.next();
            }
            this.th.check(me.hashCode(), me.getValue().hashCode() ^ me.getKey().hashCode(), "verifying hashCode");
            this.th.check(me.equals(it.next()) ^ true);
        }
        catch (Exception e) {
            this.th.fail("got unwanted exception ,got " + e);
            this.th.debug("got ME key = " + me + " and value = " + me.getKey());
        }
        Object o = me.getValue();
        Object k = me.getKey();
        this.th.check(me.setValue(this), o, "return value set");
        this.th.check(hm.get(k), this, "setting value reflected on TreeMap");
        it = s.iterator();
        Vector v = new Vector();
        v.addAll(s);
        while (it.hasNext()) {
            Map.Entry ob = it.next();
            it.remove();
            if (v.remove(ob)) continue;
            this.th.debug("Object " + ob + " not in the Vector");
        }
        this.th.check(v.isEmpty(), "all elements gone from the vector");
        this.th.check(hm.isEmpty(), "all elements removed from the TreeMap");
        hm.put("null", "sdf");
        it = s.iterator();
        hm.put("n", "sdf");
        try {
            it.next();
            this.th.fail("should throw a ConcurrentModificationException -- 3");
        }
        catch (ConcurrentModificationException cme) {
            this.th.check(true);
        }
        it = s.iterator();
        hm.clear();
        try {
            it.next();
            this.th.fail("should throw a ConcurrentModificationException -- 4");
        }
        catch (ConcurrentModificationException cme) {
            this.th.check(true);
        }
    }

    public void test_keySet() {
        this.th.checkPoint("keySet()java.util.Set");
        TreeMap hm = this.buildHM();
        boolean bl = false;
        if (hm.size() == 16) {
            bl = true;
        }
        this.th.check(bl, "checking map size(), got " + hm.size());
        Set s = null;
        try {
            s = hm.keySet();
            boolean bl2 = false;
            if (s != null) {
                bl2 = true;
            }
            this.th.check(bl2, "s != null");
            boolean bl3 = false;
            if (s.size() == 16) {
                bl3 = true;
            }
            this.th.check(bl3, "checking size keyset, got " + s.size());
            Object[] o = s.toArray();
            boolean bl4 = false;
            if (o != null) {
                bl4 = true;
            }
            this.th.check(bl4, "o != null");
            boolean bl5 = false;
            if (o.length == 16) {
                bl5 = true;
            }
            this.th.check(bl5, "checking length, got " + o.length);
            Iterator it = s.iterator();
            Vector v = new Vector();
            v.addAll(s);
            while (it.hasNext()) {
                Object ob = it.next();
                it.remove();
                if (v.remove(ob)) continue;
                this.th.debug("Object " + ob + " not in the Vector");
            }
            this.th.check(v.isEmpty(), "all elements gone from the vector");
            this.th.check(hm.isEmpty(), "all elements removed from the TreeMap");
        }
        catch (Exception e) {
            this.th.fail("got bad Exception -- got " + e);
        }
        try {
            s.add("ADDING");
            this.th.fail("should throw an UnsupportedOperationException");
        }
        catch (UnsupportedOperationException uoe) {
            this.th.check(true);
        }
    }

    public void test_values() {
        this.th.checkPoint("values()java.util.Collection");
        TreeMap hm = this.buildHM();
        boolean bl = false;
        if (hm.size() == 16) {
            bl = true;
        }
        this.th.check(bl, "checking map size(), got " + hm.size());
        Collection s = null;
        try {
            s = hm.values();
            boolean bl2 = false;
            if (s != null) {
                bl2 = true;
            }
            this.th.check(bl2, "s != null");
            boolean bl3 = false;
            if (s.size() == 16) {
                bl3 = true;
            }
            this.th.check(bl3, "checking size keyset, got " + s.size());
            Object[] o = s.toArray();
            boolean bl4 = false;
            if (o != null) {
                bl4 = true;
            }
            this.th.check(bl4, "o != null");
            boolean bl5 = false;
            if (o.length == 16) {
                bl5 = true;
            }
            this.th.check(bl5, "checking length, got " + o.length);
            Iterator it = s.iterator();
            Vector v = new Vector();
            v.addAll(s);
            while (it.hasNext()) {
                Object ob = it.next();
                it.remove();
                if (v.remove(ob)) continue;
                this.th.debug("Object " + ob + " not in the Vector");
            }
            this.th.check(v.isEmpty(), "all elements gone from the vector");
            this.th.check(hm.isEmpty(), "all elements removed from the TreeMap");
        }
        catch (Exception e) {
            this.th.fail("got bad Exception -- got " + e);
        }
        try {
            s.add("ADDING");
            this.th.fail("should throw an UnsupportedOperationException");
        }
        catch (UnsupportedOperationException uoe) {
            this.th.check(true);
        }
    }

    public void test_clone() {
        this.th.checkPoint("clone()java.lang.Object");
        TreeMap hm = this.buildHM();
        Object o = hm.clone();
        boolean bl = false;
        if (o != hm) {
            bl = true;
        }
        this.th.check(bl, "clone is not the same object");
        this.th.check(hm.equals(o), "clone is equal to Map");
        hm.put("a", "b");
        this.th.check(hm.equals(o) ^ true, "clone doesn't change if Map changes");
    }

    public void test_comparator() {
        this.th.checkPoint("comparator()java.util.Comparator");
        TreeMap tm = new TreeMap(null);
        this.th.check(tm.comparator(), null, "null comparator used");
        tm = new TreeMap(this.TSComp);
        this.th.check(tm.comparator(), this.TSComp, "TSComp comparator used");
        this.th.check(tm.tailMap("f").comparator(), this.TSComp, "TSComp passes to subMaps -- 1");
        this.th.check(tm.headMap("f").comparator(), this.TSComp, "TSComp passes to subMaps -- 2");
        this.th.check(tm.subMap("f", "g").comparator(), this.TSComp, "TSComp passes to subMaps -- 3");
    }

    public void test_firstKey() {
        this.th.checkPoint("firstKey()java.lang.Object");
        TreeMap<String, String> ts = new TreeMap<String, String>();
        try {
            ts.firstKey();
            this.th.fail("should throw a NoSuchElementException -- 1");
        }
        catch (NoSuchElementException nse) {
            this.th.check(true);
        }
        ts.put("g", "gb");
        this.th.check(ts.firstKey(), "g", "one element --> firstKey");
        ts.put("f", "fm");
        this.th.check(ts.firstKey(), "f", "two elements --> firstKey");
        ts.put("h", "hm");
        this.th.check(ts.firstKey(), "f", "three elements --> firstKey");
        ts.put("a", "ac");
        this.th.check(ts.firstKey(), "a", "four elements --> firstKey");
        ts.clear();
        try {
            ts.firstKey();
            this.th.fail("should throw a NoSuchElementException -- 2");
        }
        catch (NoSuchElementException nse) {
            this.th.check(true);
        }
    }

    public void test_lastKey() {
        this.th.checkPoint("lastKey()java.lang.Object");
        TreeMap<String, String> ts = new TreeMap<String, String>();
        try {
            ts.lastKey();
            this.th.fail("should throw a NoSuchElementException -- 1");
        }
        catch (NoSuchElementException nse) {
            this.th.check(true);
        }
        ts.put("g", "gb");
        this.th.check(ts.lastKey(), "g", "one element --> lastKey");
        ts.put("h", "hm");
        this.th.check(ts.lastKey(), "h", "two elements --> lastKey");
        ts.put("a", "ac");
        this.th.check(ts.lastKey(), "h", "three elements --> lastKey");
        ts.put("x", "xx");
        this.th.check(ts.lastKey(), "x", "four elements --> lastKey");
        ts.clear();
        try {
            ts.lastKey();
            this.th.fail("should throw a NoSuchElementException -- 2");
        }
        catch (NoSuchElementException nse) {
            this.th.check(true);
        }
    }

    protected TreeMap buildAlfabet() {
        TreeMap<String, String> t = new TreeMap<String, String>();
        t.put("a", "a1");
        t.put("b", "a2");
        t.put("c", "a3");
        t.put("d", "a4");
        t.put("h", "a8");
        t.put("g", "a7");
        t.put("f", "a6");
        t.put("e", "a5");
        t.put("i", "a9");
        t.put("j", "a10");
        t.put("k", "a11");
        t.put("l", "a12");
        t.put("p", "a16");
        t.put("o", "a15");
        t.put("n", "a14");
        t.put("m", "a13");
        t.put("q", "a17");
        t.put("r", "a18");
        t.put("s", "a19");
        t.put("t", "a20");
        t.put("x", "a24");
        t.put("w", "a23");
        t.put("v", "a22");
        t.put("u", "a21");
        t.put("y", "a25");
        t.put("z", "a26");
        return t;
    }

    public void test_headMap() {
        String o;
        this.th.checkPoint("headMap(java.lang.Object)java.util.SortedMap");
        TreeMap ts = this.buildAlfabet();
        SortedMap<String, String> s = ts.headMap("a");
        this.th.check(s.isEmpty(), "headMap Should be empty");
        this.th.check(s.comparator(), null, "comparator stays the same");
        try {
            o = s.firstKey();
            this.th.fail("should throw a NoSuchElementException, but got " + o + " -- 1");
        }
        catch (NoSuchElementException nse) {
            this.th.check(true);
        }
        try {
            o = s.lastKey();
            this.th.fail("should throw a NoSuchElementException, but got " + o + " -- 2");
        }
        catch (NoSuchElementException nse) {
            this.th.check(true);
        }
        s = ts.headMap("h");
        this.th.check(s.size(), 7, "headMap Should be empty");
        this.th.check(s.firstKey(), "a", "first element is a");
        this.th.check(s.lastKey(), "g", "last element is g");
        s = s.subMap("d", "g");
        this.th.check(s.size(), 3, "headMap Should be empty");
        this.th.check(s.firstKey(), "d", "first element is e");
        this.th.check(s.lastKey(), "f", "last element is g");
        try {
            s.put("p", "p");
            this.th.fail("should throw an IllegalArgumentException -- 1");
        }
        catch (IllegalArgumentException iae) {
            this.th.check(true);
        }
        this.th.check(s.remove("p"), null, "should not remove elements out range");
    }

    public void test_subMap() {
        String o;
        this.th.checkPoint("subMap(java.lang.Object,java.lang.Object)java.util.SortedMap");
        TreeMap ts = new TreeMap(this.TSComp);
        ts.putAll(this.buildAlfabet());
        SortedMap<String, String> s = ts.subMap("", " ");
        try {
            ts.subMap("x", "a");
            this.th.fail("should throw an IllegalArgumentException -- 1");
        }
        catch (IllegalArgumentException iae) {
            this.th.check(true);
        }
        this.th.check(s.isEmpty(), "headSet Should be empty");
        this.th.check(s.comparator(), this.TSComp, "comparator stays the same");
        try {
            o = s.firstKey();
            this.th.fail("should throw a NoSuchElementException, but got " + o + " -- 1");
        }
        catch (NoSuchElementException nse) {
            this.th.check(true);
        }
        try {
            o = s.lastKey();
            this.th.fail("should throw a NoSuchElementException, but got " + o + " -- 2");
        }
        catch (NoSuchElementException nse) {
            this.th.check(true);
        }
        s = ts.subMap("h", "na");
        this.th.check(s.size(), 7, "headSet Should be empty");
        this.th.check(s.firstKey(), "h", "first element is h");
        this.th.check(s.lastKey(), "n", "last element is n");
        try {
            s.subMap("a", "j");
            this.th.fail("should throw an IllegalArgumentException -- 2");
        }
        catch (IllegalArgumentException iae) {
            this.th.check(true);
        }
        try {
            s.subMap("j", "p");
            this.th.fail("should throw an IllegalArgumentException -- 3");
        }
        catch (IllegalArgumentException iae) {
            this.th.check(true);
        }
        try {
            s.put("p", "p");
            this.th.fail("should throw an IllegalArgumentException -- 4");
        }
        catch (IllegalArgumentException iae) {
            this.th.check(true);
        }
        this.th.check(s.remove("p"), null, "should not remove elements out range");
        s = s.tailMap("k");
        this.th.check(s.size(), 4, "subMap Should be empty");
        this.th.check(s.firstKey(), "k", "first element is k");
        this.th.check(s.lastKey(), "n", "last element is n");
    }

    public void test_tailMap() {
        String o;
        this.th.checkPoint("tailMap(java.lang.Object)java.util.SortedMap");
        TreeMap ts = this.buildAlfabet();
        SortedMap<String, String> s = ts.tailMap("za");
        this.th.check(s.isEmpty(), "tailMap Should be empty");
        try {
            o = s.firstKey();
            this.th.fail("should throw a NoSuchElementException, but got " + o + " -- 1");
        }
        catch (NoSuchElementException nse) {
            this.th.check(true);
        }
        try {
            o = s.lastKey();
            this.th.fail("should throw a NoSuchElementException, but got " + o + " -- 2");
        }
        catch (NoSuchElementException nse) {
            this.th.check(true);
        }
        s = ts.tailMap("t");
        this.th.check(s.size(), 7, "tailMap Should be empty");
        this.th.check(s.firstKey(), "t", "first element is t");
        this.th.check(s.lastKey(), "z", "last element is z");
        s = s.subMap("v", "y");
        this.th.check(s.size(), 3, "tailMap has size 3");
        this.th.check(s.firstKey(), "v", "first element is v");
        this.th.check(s.lastKey(), "x", "last element is x");
        try {
            s.put("p", "p");
            this.th.fail("should throw an IllegalArgumentException -- 1");
        }
        catch (IllegalArgumentException iae) {
            this.th.check(true);
        }
        this.th.check(s.remove("p"), null, "should not remove elements out range");
    }

    protected void check_presence(Map h) {
        boolean bl = false;
        if (h.get("a") != null) {
            bl = true;
        }
        this.th.check(bl, "checking presence st -- sequence " + this.sqnce);
        boolean bl2 = false;
        if (h.get("sh") != null) {
            bl2 = true;
        }
        this.th.check(bl2, "checking presence sh -- sequence " + this.sqnce);
        boolean bl3 = false;
        if (h.get("i") != null) {
            bl3 = true;
        }
        this.th.check(bl3, "checking presence i -- sequence " + this.sqnce);
        boolean bl4 = false;
        if (h.get("b") != null) {
            bl4 = true;
        }
        this.th.check(bl4, "checking presence b -- sequence " + this.sqnce);
        boolean bl5 = false;
        if (h.get("l") != null) {
            bl5 = true;
        }
        this.th.check(bl5, "checking presence l -- sequence " + this.sqnce);
        ++this.sqnce;
    }

    public String newFloat(float f) {
        return "float = " + f;
    }

    public void test_behaviour() {
        String f;
        this.th.checkPoint("behaviour testing");
        SortedMap<String, String> h = new TreeMap(this.TSComp).subMap("", "x");
        int j = 0;
        h.put("a", "a");
        h.put("b", "byte");
        h.put("sh", "short");
        h.put("i", "int");
        h.put("l", "long");
        h.put(null, null);
        this.check_presence(h);
        this.sqnce = 1;
        while (j < 100) {
            f = this.newFloat(j);
            h.put(f, f);
            ++j;
        }
        this.th.check(h.size(), 106, "size checking -- 1 got: " + h.size());
        this.check_presence(h);
        while (j < 200) {
            f = this.newFloat(j);
            h.put(f, f);
            ++j;
        }
        this.th.check(h.size(), 206, "size checking -- 2 got: " + h.size());
        this.check_presence(h);
        while (j < 1000) {
            f = this.newFloat(j);
            h.put(f, f);
            ++j;
        }
        this.th.check(h.size(), 1006, "size checking -- 3 got: " + h.size());
        this.check_presence(h);
        this.th.check("a".equals(h.put("a", "na")), "replacing values -- 1 - st");
        this.th.check("byte".equals(h.put("b", "nbyte")), "replacing values -- 2 - b");
        this.th.check("short".equals(h.put("sh", "nshort")), "replacing values -- 3 -sh");
        this.th.check("int".equals(h.put("i", "nint")), "replacing values -- 4 -i");
        this.th.check("long".equals(h.put("l", "nlong")), "replacing values -- 5 -l");
        while (j > 199) {
            f = this.newFloat(j);
            h.remove(f);
            --j;
        }
        this.th.check(h.size(), 206, "size checking -- 4 got: " + h.size());
        this.check_presence(h);
        while (j > 99) {
            f = this.newFloat(j);
            h.remove(f);
            --j;
        }
        this.th.check(h.size(), 106, "size checking -- 5 got: " + h.size());
        this.check_presence(h);
        while (j > -1) {
            f = this.newFloat(j);
            h.remove(f);
            --j;
        }
        this.th.check(h.size(), 6, "size checking -- 6 got: " + h.size());
        this.th.debug(h.toString());
        this.check_presence(h);
    }

    public void test_behaviour2() {
        this.th.checkPoint("behaviour testing 2");
        TreeMap<Integer, String> tm = new TreeMap<Integer, String>();
        int i = 0;
        while (i < 200) {
            tm.put(new Integer(i), "" + i);
            i += 2;
        }
        Iterator<Object> it = tm.keySet().iterator();
        while (it.hasNext()) {
            Integer i2 = (Integer)it.next();
            if (i2 <= 30 || i2 >= 90) continue;
            it.remove();
        }
        int i3 = 51;
        while (i3 < 150) {
            tm.put(new Integer(i3), "" + i3);
            i3 += 2;
        }
        it = tm.entrySet().iterator();
        i3 = 0;
        while (it.hasNext()) {
            Map.Entry me = (Map.Entry)it.next();
            Integer in = (Integer)me.getKey();
            this.th.check(me.getValue(), in.toString(), "checking entries " + i3);
            this.th.check(in, i3, "checking order " + i3);
            if (i3 == 30) {
                i3 = 51;
                continue;
            }
            if (i3 < 89 || i3 >= 150) {
                i3 += 2;
                continue;
            }
            ++i3;
        }
    }

    private final /* synthetic */ void this() {
        this.TSComp = new ToStringComparator();
        this.sqnce = 1;
    }

    public AcuniaTreeMapTest() {
        this.this();
    }

    public static class ToStringComparator
    implements Comparator {
        public int compare(Object one, Object two) {
            if (one == null) {
                if (two == null) {
                    return 0;
                }
                return -two.toString().compareTo("null");
            }
            if (two == null) {
                return one.toString().compareTo("null");
            }
            return one.toString().compareTo(two.toString());
        }
    }
}

