/*
 * Decompiled with CFR 0.152.
 */
package gnu.testlet.wonka.util.StringTokenizer;

import gnu.testlet.TestHarness;
import gnu.testlet.Testlet;
import java.util.Date;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;

public class AcuniaStringTokenizerTest
implements Testlet {
    protected TestHarness th;

    public void test(TestHarness harness) {
        this.th = harness;
        this.th.setclass("java.util.StringTokenizer");
        this.test_StringTokenizer();
        this.test_countTokens();
        this.test_hasMoreTokens();
        this.test_hasMoreElements();
        this.test_nextToken();
        this.test_nextElement();
    }

    public void test_StringTokenizer() {
        this.th.checkPoint("StringTokenizer(java.lang.String)");
        try {
            new StringTokenizer(null);
            this.th.fail("null is not allowed");
        }
        catch (NullPointerException np) {
            this.th.check(true);
        }
        StringTokenizer st = new StringTokenizer("a\rb c\nd\te");
        this.th.check(st.nextElement(), "a", "verifying default delimeter chars -- 1");
        this.th.check(st.nextElement(), "b", "verifying default delimeter chars -- 2");
        this.th.check(st.nextElement(), "c", "verifying default delimeter chars -- 3");
        this.th.check(st.nextElement(), "d", "verifying default delimeter chars -- 4");
        this.th.check(st.nextElement(), "e", "verifying default delimeter chars -- 5");
        this.th.checkPoint("StringTokenizer(java.lang.String,java.lang.String)");
        try {
            new StringTokenizer(null, "a");
            this.th.fail("null is not allowed -- 1");
        }
        catch (NullPointerException np) {
            this.th.check(true);
        }
        try {
            st = new StringTokenizer("a", null);
            this.th.fail("null is not allowed -- 2");
            st.nextElement();
        }
        catch (NullPointerException np) {
            this.th.check(true);
        }
        st = new StringTokenizer("a\rb c\nd\te", "bcbd");
        this.th.check(st.nextElement(), "a\r", "verifying delimeter chars -- 1");
        this.th.check(st.nextElement(), " ", "verifying delimeter chars -- 2");
        this.th.check(st.nextElement(), "\n", "verifying delimeter chars -- 3");
        this.th.check(st.nextElement(), "\te", "verifying delimeter chars -- 4");
        this.th.checkPoint("StringTokenizer(java.lang.String,java.lang.String,boolean)");
        try {
            new StringTokenizer(null, "a", true);
            this.th.fail("null is not allowed -- 1");
        }
        catch (NullPointerException np) {
            this.th.check(true);
        }
        try {
            st = new StringTokenizer("a", null, true);
            this.th.fail("null is not allowed -- 2");
            st.nextToken();
        }
        catch (NullPointerException np) {
            this.th.check(true);
        }
        st = new StringTokenizer("a\rb c\nd\te", "bcbd", false);
        this.th.check(st.nextToken(), "a\r", "verifying delimeter chars -- 1");
        this.th.check(st.nextToken(), " ", "verifying delimeter chars -- 2");
        this.th.check(st.nextToken(), "\n", "verifying delimeter chars -- 3");
        this.th.check(st.nextToken(), "\te", "verifying delimeter chars -- 4");
        st = new StringTokenizer("a\rb c\nd\te", "bcbd", true);
        this.th.check(st.nextToken(), "a\r", "verifying delimeter chars -- 1");
        this.th.check(st.nextToken(), "b", "verifying delimeter chars -- 2");
        this.th.check(st.nextToken(), " ", "verifying delimeter chars -- 3");
        this.th.check(st.nextToken(), "c", "verifying delimeter chars -- 4");
    }

    public void test_countTokens() {
        this.th.checkPoint("countTokens()int");
        StringTokenizer st = new StringTokenizer("a\rb c\nd\te ");
        this.th.check(st.countTokens(), 5, "counting tokens -- 1");
        st.nextToken("d");
        this.th.check(st.countTokens(), 1, "counting tokens -- 2");
        st.nextToken("d\t ");
        this.th.check(st.countTokens(), 0, "counting tokens -- 3");
        st = new StringTokenizer("a\rb c\nd\te ", " \r\t\n", true);
        this.th.check(st.countTokens(), 10, "counting tokens -- 4");
        st.nextToken("d");
        this.th.check(st.countTokens(), 2, "counting tokens -- 5");
        st.nextToken("\t ");
        this.th.check(st.countTokens(), 3, "counting tokens -- 6");
        st = new StringTokenizer("abc de", " ", false);
        this.th.check(st.countTokens(), 2, "counting tokens -- 7");
        st = new StringTokenizer("abc de", " ", true);
        this.th.check(st.countTokens(), 3, "counting tokens -- 8");
        st = new StringTokenizer(" abc   de ", " ", false);
        this.th.check(st.countTokens(), 2, "counting tokens -- 9");
        st = new StringTokenizer(" abc   de ", " ", true);
        this.th.check(st.countTokens(), 7, "counting tokens -- 10");
        st = new StringTokenizer("a bc   de ", " ", false);
        this.th.check(st.countTokens(), 3, "counting tokens -- 11");
        st = new StringTokenizer("a bc   de ", " ", true);
        this.th.check(st.countTokens(), 8, "counting tokens -- 12");
        st = new StringTokenizer("   a bc   de ", " ", false);
        this.th.check(st.countTokens(), 3, "counting tokens -- 13");
        st = new StringTokenizer("   a bc   de ", " ", true);
        this.th.check(st.countTokens(), 11, "counting tokens -- 14");
        st = new StringTokenizer("xx  a bdc   def  ", " ", false);
        this.th.check(st.countTokens(), 4, "counting tokens -- 15");
        st = new StringTokenizer("xx  a bdc   def  ", " ", true);
        this.th.check(st.countTokens(), 12, "counting tokens -- 16");
    }

    public void test_hasMoreTokens() {
        this.th.checkPoint("hasMoreTokens()boolean");
        StringTokenizer st = new StringTokenizer("a\rb c\nd\te ");
        this.th.check(st.hasMoreTokens(), "hasMoretokens -- 1");
        st.nextToken("d");
        this.th.check(st.hasMoreTokens(), "hasMoretokens -- 2");
        this.th.check(st.countTokens(), 1, "counting tokens -- 1");
        st.nextToken("\t ");
        this.th.check(st.hasMoreTokens() ^ true, "hasMoretokens -- 3");
        this.th.check(st.countTokens(), 0, "counting tokens -- 2");
        st = new StringTokenizer("   e");
        st.nextToken();
        this.th.check(st.hasMoreTokens() ^ true, "hasMoretokens -- 4");
        st = new StringTokenizer("   efg");
        this.th.check(st.hasMoreTokens(), "hasMoretokens -- 5");
        st.nextToken("e");
        this.th.check(st.hasMoreTokens() ^ true, "hasMoretokens -- 6");
        st = new StringTokenizer("a\rb c\nd\te ", " \r\t\n", true);
        this.th.check(st.hasMoreTokens(), "hasMoretokens -- 7");
        st.nextToken("d");
        this.th.check(st.hasMoreTokens(), "hasMoretokens -- 8");
        this.th.check(st.nextToken(), "d", "delimeter token not skipped");
        this.th.check(st.countTokens(), 1, "counting tokens -- 3");
        st.nextToken("\t ");
        this.th.check(st.hasMoreTokens(), "hasMoretokens -- 9");
        this.th.check(st.countTokens(), 2, "counting tokens -- 4");
        st = new StringTokenizer("   e", " ", true);
        this.th.check(st.hasMoreTokens(), "hasMoretokens -- 10");
        this.th.check(st.nextToken("e"), (Object)"   ");
        this.th.check(st.hasMoreTokens(), "hasMoretokens -- 11");
        st.nextToken();
        this.th.check(st.hasMoreTokens() ^ true, "hasMoretokens -- 12");
    }

    public void test_hasMoreElements() {
        this.th.checkPoint("hasMoreElements()boolean");
        StringTokenizer st = new StringTokenizer("a\rb c\nd\te ");
        this.th.check(st.hasMoreTokens(), "hasMoreElements -- 1");
        st.nextToken("d");
        this.th.check(st.hasMoreTokens(), "hasMoreElements -- 2");
        this.th.check(st.countTokens(), 1, "counting tokens -- 1");
        st.nextToken("\t ");
        this.th.check(st.hasMoreTokens() ^ true, "hasMoreElements -- 3");
        this.th.check(st.countTokens(), 0, "counting tokens -- 2");
        st = new StringTokenizer("   e");
        st.nextToken();
        this.th.check(st.hasMoreTokens() ^ true, "hasMoreElements -- 4");
        st = new StringTokenizer("   efg");
        this.th.check(st.hasMoreTokens(), "hasMoreElements -- 5");
        st.nextToken("e");
        this.th.check(st.hasMoreTokens() ^ true, "hasMoreElements -- 6");
        st = new StringTokenizer("a\rb c\nd\te ", " \r\t\n", true);
        this.th.check(st.hasMoreTokens(), "hasMoreElements -- 7");
        st.nextToken("d");
        this.th.check(st.hasMoreTokens(), "hasMoreElements -- 8");
        this.th.check(st.nextToken(), "d", "delimeter token not skipped");
        this.th.check(st.countTokens(), 1, "counting tokens -- 3");
        st.nextToken("\t ");
        this.th.check(st.hasMoreTokens(), "hasMoreElements -- 9");
        this.th.check(st.countTokens(), 2, "counting tokens -- 4");
        st = new StringTokenizer("   e", " ", true);
        this.th.check(st.hasMoreTokens(), "hasMoreElements -- 10");
        this.th.check(st.nextToken("e"), (Object)"   ");
        this.th.check(st.hasMoreTokens(), "hasMoreElements -- 11");
        st.nextToken();
        this.th.check(st.hasMoreTokens() ^ true, "hasMoreElements -- 12");
    }

    public void test_nextToken() {
        this.th.checkPoint("nextToken()java.lang.String");
        StringTokenizer st = new StringTokenizer("ab\rb  cd\ndef\t \nef ");
        this.th.check(st.nextToken(), "ab", "checking nextToken -- 1");
        this.th.check(st.nextToken(), "b", "checking nextToken -- 2");
        this.th.check(st.nextToken(), "cd", "checking nextToken -- 3");
        this.th.check(st.nextToken(), "def", "checking nextToken -- 4");
        this.th.check(st.nextToken(), "ef", "checking nextToken -- 5");
        try {
            st.nextToken();
            this.th.fail("should throw NoSuchElementException -- 1");
        }
        catch (Exception e) {
            this.th.check(e instanceof NoSuchElementException, "verify Exception type -- 1");
        }
        st = new StringTokenizer("ab\rb  cd\nde\t \nef ", " \r\t\n", true);
        this.th.check(st.nextToken(), "ab", "checking nextToken -- a1");
        this.th.check(st.nextToken(), "\r", "checking nextToken -- a2");
        this.th.check(st.nextToken(), "b", "checking nextToken -- a3");
        this.th.check(st.nextToken(), " ", "checking nextToken -- a4");
        this.th.check(st.nextToken(), " ", "checking nextToken -- a5");
        this.th.check(st.nextToken(), "cd", "checking nextToken -- a6");
        this.th.check(st.nextToken(), "\n", "checking nextToken -- a7");
        this.th.check(st.nextToken(), "de", "checking nextToken -- a8");
        this.th.check(st.nextToken(), "\t", "checking nextToken -- a9");
        this.th.check(st.nextToken(), " ", "checking nextToken -- a10");
        this.th.check(st.nextToken(), "\n", "checking nextToken -- a11");
        this.th.check(st.nextToken(), "ef", "checking nextToken -- a12");
        this.th.check(st.nextToken(), " ", "checking nextToken -- a13");
        try {
            st.nextToken();
            this.th.fail("should throw NoSuchElementException -- 2");
        }
        catch (Exception e) {
            this.th.check(e instanceof NoSuchElementException, "verify Exception type -- 2");
        }
        this.th.checkPoint("nextToken(java.lang.String)java.lang.String");
        st = new StringTokenizer("ab\rb  cd\ndef\t \nef ");
        this.th.check(st.nextToken("\r"), "ab", "checking nextToken -- 1");
        this.th.check(st.nextToken("c"), "\rb  ", "checking nextToken -- 2");
        this.th.check(st.nextToken("d"), "c", "checking nextToken -- 3");
        this.th.check(st.nextToken("d"), "\n", "checking nextToken -- 4");
        this.th.check(st.nextToken("f"), "de", "checking nextToken -- 5");
        this.th.check(st.nextToken("f"), "\t \ne", "checking nextToken -- 6");
        this.th.check(st.nextToken("f"), " ", "checking nextToken -- 7");
        try {
            st.nextToken("f");
            this.th.fail("should throw NoSuchElementException -- 1");
        }
        catch (Exception e) {
            this.th.check(e instanceof NoSuchElementException, "verify Exception type -- 1");
        }
        st = new StringTokenizer("ab\rb  cd\ndef\t \nef ", "", true);
        this.th.check(st.nextToken("\r"), "ab", "checking nextToken -- a1");
        this.th.check(st.nextToken("c"), "\rb  ", "checking nextToken -- a2");
        this.th.check(st.nextToken("d"), "c", "checking nextToken -- a3");
        this.th.check(st.nextToken("d"), "d", "checking nextToken -- a4");
        this.th.check(st.nextToken("d"), "\n", "checking nextToken -- a5");
        this.th.check(st.nextToken("f"), "de", "checking nextToken -- a6");
        this.th.check(st.nextToken("f"), "f", "checking nextToken -- a7");
        this.th.check(st.nextToken("f"), "\t \ne", "checking nextToken -- a8");
        this.th.check(st.nextToken("f"), "f", "checking nextToken -- a9");
        this.th.check(st.nextToken("f"), " ", "checking nextToken -- a10");
        try {
            st.nextToken("f");
            this.th.fail("should throw NoSuchElementException -- 2");
        }
        catch (Exception e) {
            this.th.check(e instanceof NoSuchElementException, "verify Exception type -- 2");
        }
    }

    public void test_nextElement() {
        this.th.checkPoint("nextElement()java.lang.String");
        StringTokenizer st = new StringTokenizer("ab\rb  cd\ndef\t \nef ");
        this.th.check(st.nextElement(), "ab", "checking nextElement -- 1");
        this.th.check(st.nextElement(), "b", "checking nextElement -- 2");
        this.th.check(st.nextElement(), "cd", "checking nextElement -- 3");
        this.th.check(st.nextElement(), "def", "checking nextElement -- 4");
        this.th.check(st.nextElement(), "ef", "checking nextElement -- 5");
        try {
            st.nextElement();
            this.th.fail("should throw NoSuchElementException -- 1");
        }
        catch (Exception e) {
            this.th.check(e instanceof NoSuchElementException, "verify Exception type -- 1");
        }
        st = new StringTokenizer("ab\rb  cd\nde\t \nef ", " \r\t\n", true);
        this.th.check(st.nextElement(), "ab", "checking nextElement -- a1");
        this.th.check(st.nextElement(), "\r", "checking nextElement -- a2");
        this.th.check(st.nextElement(), "b", "checking nextElement -- a3");
        this.th.check(st.nextElement(), " ", "checking nextElement -- a4");
        this.th.check(st.nextElement(), " ", "checking nextElement -- a5");
        this.th.check(st.nextElement(), "cd", "checking nextElement -- a6");
        this.th.check(st.nextElement(), "\n", "checking nextElement -- a7");
        this.th.check(st.nextElement(), "de", "checking nextElement -- a8");
        this.th.check(st.nextElement(), "\t", "checking nextElement -- a9");
        this.th.check(st.nextElement(), " ", "checking nextElement -- a10");
        this.th.check(st.nextElement(), "\n", "checking nextElement -- a11");
        this.th.check(st.nextElement(), "ef", "checking nextElement -- a12");
        this.th.check(st.nextElement(), " ", "checking nextElement -- a13");
        try {
            st.nextElement();
            this.th.fail("should throw NoSuchElementException -- 2");
        }
        catch (Exception e) {
            this.th.check(e instanceof NoSuchElementException, "verify Exception type -- 2");
        }
    }

    public void profile() {
        int j;
        int nr;
        StringTokenizer st;
        long time = System.currentTimeMillis();
        int i = 0;
        while (i < 250) {
            this.test_nextElement();
            ++i;
        }
        System.out.println("time nextElement = " + (System.currentTimeMillis() - time));
        time = System.currentTimeMillis();
        i = 0;
        while (i < 250) {
            this.test_countTokens();
            ++i;
        }
        System.out.println("time countTokens = " + (System.currentTimeMillis() - time));
        time = System.currentTimeMillis();
        i = 0;
        while (i < 250) {
            this.test_hasMoreTokens();
            ++i;
        }
        System.out.println("time hasMoreTokens = " + (System.currentTimeMillis() - time));
        time = System.currentTimeMillis();
        i = 0;
        while (i < 250) {
            this.test_nextToken();
            ++i;
        }
        System.out.println("time nextToken = " + (System.currentTimeMillis() - time));
        time = System.currentTimeMillis();
        i = 0;
        while (i < 250) {
            this.test_StringTokenizer();
            ++i;
        }
        System.out.println("time StringTokenizer = " + (System.currentTimeMillis() - time));
        time = System.currentTimeMillis();
        i = 0;
        while (i < 1500) {
            st = new StringTokenizer("let tell a story.  So we have a really long text wich can be tokenized.\n Hello world is common application.  It covers most of the basic functionalty offered by devellopment environments.\nIf you haven't noticed yet: this is a lot of crap");
            nr = st.countTokens();
            j = 0;
            while (j < nr) {
                st.nextToken();
                ++j;
            }
            ++i;
        }
        System.out.println("time common use = " + (System.currentTimeMillis() - time));
        time = System.currentTimeMillis();
        i = 0;
        while (i < 2500) {
            st = new StringTokenizer("com.acunia.wonka.service.testlet.TestStringTokenizer", ".", false);
            nr = st.countTokens();
            j = 0;
            while (j < nr) {
                st.nextToken();
                ++j;
            }
            ++i;
        }
        System.out.println("time common use 2 = " + (System.currentTimeMillis() - time));
        System.out.println(new Date());
    }

    private final void test_behaviour() {
        String[] a = new String[10000];
        String x = "yes this is a very long string";
        int i = 0;
        while (i < 9) {
            x = x + x;
            ++i;
        }
        try {
            i = 0;
            while (i < 10000) {
                String y = new String(x);
                StringTokenizer st = new StringTokenizer(y);
                a[i] = st.nextToken();
                ++i;
            }
        }
        catch (Exception e) {
            System.err.println(e);
        }
        catch (OutOfMemoryError e) {
            this.th.fail("should not run out of memory");
            System.err.println(i);
            System.err.println(e);
        }
    }
}

