/*
 * Decompiled with CFR 0.152.
 */
package gnu.testlet.wonka.util.Hashtable;

import gnu.testlet.TestHarness;
import gnu.testlet.Testlet;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class SMHashtableTest
implements Testlet {
    protected TestHarness th;
    private final String st = "a";
    private final Byte b;
    private final Short sh;
    private final Integer i;
    private final Long l;
    private int sqnce;

    public void test(TestHarness harness) {
        this.th = harness;
        this.th.setclass("java.util.Hashtable");
        this.test_Hashtable();
        this.test_elements();
        this.test_get();
        this.test_keys();
        this.test_contains();
        this.test_containsKey();
        this.test_containsValue();
        this.test_isEmpty();
        this.test_size();
        this.test_put();
        this.test_putAll();
        this.test_remove();
        this.test_entrySet();
        this.test_keySet();
        this.test_values();
        this.test_clone();
        this.test_equals();
        this.test_hashCode();
        this.test_toString();
        this.test_rehash();
        this.test_behaviour();
    }

    public Hashtable buildknownHt() {
        Hashtable<Float, Float> ht = new Hashtable<Float, Float>(19);
        int i = 0;
        while (i < 11) {
            Float f = new Float(i);
            ht.put(f, f);
            ++i;
        }
        return ht;
    }

    public void test_Hashtable() {
        this.th.checkPoint("Hashtable()");
        Hashtable h = new Hashtable();
        h = new Hashtable(233, 0.5f);
        try {
            h = new Hashtable(0);
            this.th.check(true, "test 1");
            h = new Hashtable(25);
            this.th.check(true, "test 2");
        }
        catch (Exception e) {
            this.th.fail("shouldn't throw an exception -- " + e);
        }
        try {
            h = new Hashtable(-233);
            this.th.fail("should throw an IllegalArgumentException");
        }
        catch (IllegalArgumentException ie) {
            this.th.check(true, "test 3");
        }
        try {
            h = new Hashtable(233, 23.0f);
            this.th.check(true, "test 4");
        }
        catch (Exception e) {
            this.th.fail("shouldn't throw an exception -- " + e);
        }
        try {
            h = new Hashtable(233, 0.0f);
            this.th.fail("should throw an IllegalArgumentException");
        }
        catch (IllegalArgumentException ie) {
            this.th.check(true, "test 5");
        }
        try {
            h = new Hashtable(233, -1.0f);
            this.th.fail("should throw an IllegalArgumentException");
        }
        catch (IllegalArgumentException ie) {
            this.th.check(true, "test 6");
        }
        try {
            h = new Hashtable(null);
            this.th.fail("should throw a NullPointerException");
        }
        catch (NullPointerException ne) {
            this.th.check(true);
        }
    }

    public void test_elements() {
        this.th.checkPoint("elements()java.util.Enumeration");
        Hashtable ht = this.buildknownHt();
        Enumeration e = ht.elements();
        int i = 0;
        while (e.hasMoreElements()) {
            ++i;
            Float f = (Float)e.nextElement();
            Object o = ht.get(f);
            boolean bl = false;
            if (o != null) {
                bl = true;
            }
            this.th.check(bl, "each element is unique -- nr " + i);
            ht.remove(f);
        }
        boolean bl = false;
        if (i == 11) {
            bl = true;
        }
        this.th.check(bl, "we should have 11 elements");
        boolean bl2 = false;
        if (ht.size() == 0) {
            bl2 = true;
        }
        this.th.check(bl2);
        e = new Hashtable().elements();
        boolean bl3 = false;
        if (e != null) {
            bl3 = true;
        }
        this.th.check(bl3, "elements should return a non-null value");
        this.th.check(e.hasMoreElements() ^ true, "e should not have elements");
    }

    public void test_get() {
        this.th.checkPoint("get(java.lang.Object)java.lang.Object");
        Hashtable<Float, Float> hte = new Hashtable<Float, Float>();
        Hashtable ht = this.buildknownHt();
        try {
            ht.get(null);
            this.th.fail("should throw NullPointerException");
        }
        catch (NullPointerException ne) {
            this.th.check(true);
        }
        boolean bl = false;
        if (ht.get(new Object()) == null) {
            bl = true;
        }
        this.th.check(bl, "gives back null if not in -- 1");
        Float f = (Float)ht.elements().nextElement();
        Float g = new Float((double)f.floatValue() + 1.0E-5);
        boolean bl2 = false;
        if (ht.get(g) == null) {
            bl2 = true;
        }
        this.th.check(bl2, "gives back null if not in -- 2");
        boolean bl3 = false;
        if (ht.get(f) == f) {
            bl3 = true;
        }
        this.th.check(bl3, "key and element are same so get(f)==f -- 1");
        ht.put(hte, hte);
        hte.put(f, f);
        hte.put(g, g);
        boolean bl4 = false;
        if (ht.get(hte) == hte) {
            bl4 = true;
        }
        this.th.check(bl4, "changing the hashcode of a key --> key must be found");
    }

    public void test_keys() {
        this.th.checkPoint("keys()java.util.Enumeration");
        Hashtable<String, String> ht = this.buildknownHt();
        Enumeration e = ht.keys();
        int i = 0;
        while (e.hasMoreElements()) {
            ++i;
            Float f = (Float)e.nextElement();
            Object o = ht.get(f);
            boolean bl = false;
            if (o != null) {
                bl = true;
            }
            this.th.check(bl, "each key is unique -- nr " + i);
            ht.remove(f);
        }
        boolean bl = false;
        if (i == 11) {
            bl = true;
        }
        this.th.check(bl, "we should have 11 key");
        boolean bl2 = false;
        if (ht.size() == 0) {
            bl2 = true;
        }
        this.th.check(bl2);
        e = new Hashtable().keys();
        boolean bl3 = false;
        if (e != null) {
            bl3 = true;
        }
        this.th.check(bl3, "keys should return a non-null value");
        this.th.check(e.hasMoreElements() ^ true, "e should not have keys");
        ht = new Hashtable<String, String>();
        e = ht.keys();
        this.th.check(e.hasMoreElements() ^ true, "empty HT Enum has no elements");
        ht.put("abcd", "value");
        e = ht.keys();
        this.th.check(e.hasMoreElements(), "HT Enum stil has elements");
        this.th.check("abcd".equals(e.nextElement()), "checking returned value");
        this.th.check(e.hasMoreElements() ^ true, "HT Enum enumerated all elements");
    }

    public void test_contains() {
        this.th.checkPoint("contains(java.lang.Object)boolean");
        Hashtable ht = this.buildknownHt();
        Float f = new Float(10.0);
        this.th.check(ht.contains(f), "contains uses equals -- 1");
        f = new Float(11.0);
        this.th.check(ht.contains(f) ^ true, "contains uses equals -- 2");
        Double d = new Double(5);
        this.th.check(ht.contains(d) ^ true, "contains uses equals -- 3");
        ht.put(f, d);
        this.th.check(ht.contains(d), "contains uses equals -- 4");
        try {
            ht.contains(null);
            this.th.fail("should throw NullPointerException");
        }
        catch (NullPointerException ne) {
            this.th.check(true);
        }
    }

    public void test_containsKey() {
        this.th.checkPoint("containsKey(java.lang.Object)boolean");
        Hashtable ht = this.buildknownHt();
        Float f = new Float(10.0);
        this.th.check(ht.containsKey(f), "containsKey uses equals -- 1");
        f = new Float(11.0);
        this.th.check(ht.containsKey(f) ^ true, "containsKey uses equals -- 2");
        Double d = new Double(5);
        this.th.check(ht.containsKey(d) ^ true, "containsKey uses equals -- 3");
        ht.put(d, f);
        this.th.check(ht.containsKey(d), "containsKey uses equals -- 4");
        try {
            ht.containsKey(null);
            this.th.fail("should throw NullPointerException");
        }
        catch (NullPointerException ne) {
            this.th.check(true);
        }
    }

    public void test_containsValue() {
        this.th.checkPoint("containsValue(java.lang.Object)boolean");
        Hashtable ht = this.buildknownHt();
        Float f = new Float(10.0);
        this.th.check(ht.containsValue(f), "containsValue uses equals -- 1");
        f = new Float(11.0);
        this.th.check(ht.containsValue(f) ^ true, "containsValue uses equals -- 2");
        Double d = new Double(5);
        this.th.check(ht.containsValue(d) ^ true, "containsValue uses equals -- 3");
        ht.put(d, f);
        this.th.check(ht.containsValue(d) ^ true, "containsValue uses equals -- 4");
        d = new Double(89.0);
        ht.put(f, d);
        this.th.check(ht.containsValue(d), "containsValue uses equals -- 5");
        try {
            ht.containsValue(null);
            this.th.fail("should throw NullPointerException");
        }
        catch (NullPointerException ne) {
            this.th.check(true);
        }
    }

    public void test_isEmpty() {
        this.th.checkPoint("isEmpty()boolean");
        Hashtable ht = this.buildknownHt();
        this.th.check(ht.isEmpty() ^ true, "ht is not empty -- 1");
        ht.clear();
        this.th.check(ht.isEmpty(), "hashtable should be empty --> after clear");
        ht.put(new Object(), ht);
        this.th.check(ht.isEmpty() ^ true, "ht is not empty -- 2");
    }

    public void test_size() {
        this.th.checkPoint("size()int");
        Hashtable ht = this.buildknownHt();
        boolean bl = false;
        if (ht.size() == 11) {
            bl = true;
        }
        this.th.check(bl);
    }

    public void test_clear() {
        this.th.checkPoint("clear()void");
        Hashtable ht = new Hashtable();
        ht.clear();
        ht = this.buildknownHt();
        if (!ht.isEmpty()) {
            ht.clear();
            this.th.check(ht.isEmpty(), "hashtable should be empty --> after clear");
            try {
                ht.clear();
                this.th.check(ht.isEmpty(), "hashtable should be empty --> after 2nd clear");
            }
            catch (Exception e) {
                this.th.fail("clear should not throw " + e);
            }
        }
    }

    public void test_put() {
        this.th.checkPoint("put(java.lang.Object,java.lang.Object)java.lang.Object");
        Hashtable h = this.buildknownHt();
        Float f = new Float(33.0f);
        Double d = new Double(343.0);
        boolean bl = false;
        if (h.put(f, f) == null) {
            bl = true;
        }
        this.th.check(bl, "key f in not used");
        boolean bl2 = false;
        if (h.get(f) == f) {
            bl2 = true;
        }
        this.th.check(bl2, "make sure element is put there -- 1");
        boolean bl3 = false;
        if (h.put(f, d) == f) {
            bl3 = true;
        }
        this.th.check(bl3, "key f in used --> return old element");
        boolean bl4 = false;
        if (h.get(f) == d) {
            bl4 = true;
        }
        this.th.check(bl4, "make sure element is put there -- 2");
        try {
            h.put(null, d);
            this.th.fail("should throw NullPointerException -- 1");
        }
        catch (NullPointerException ne) {
            this.th.check(true);
        }
        try {
            h.put(d, null);
            this.th.fail("should throw NullPointerException -- 2");
        }
        catch (NullPointerException ne) {
            this.th.check(true);
        }
        try {
            h.put(null, null);
            this.th.fail("should throw NullPointerException -- 3");
        }
        catch (NullPointerException ne) {
            this.th.check(true);
        }
    }

    public void test_putAll() {
        this.th.checkPoint("putAll(java.util.Map)void");
        Hashtable<Number, Double> h = new Hashtable<Number, Double>();
        h.putAll(this.buildknownHt());
        boolean bl = false;
        if (h.size() == 11 && h.equals(this.buildknownHt())) {
            bl = true;
        }
        this.th.check(bl);
        Double d = new Double(34.0);
        Float f = new Float((double)2);
        h.put(f, d);
        h.putAll(this.buildknownHt());
        boolean bl2 = false;
        if (h.size() == 11 && h.equals(this.buildknownHt())) {
            bl2 = true;
        }
        this.th.check(bl2);
        h.put(d, d);
        h.putAll(this.buildknownHt());
        boolean bl3 = false;
        if (h.size() == 12 && !h.equals(this.buildknownHt())) {
            bl3 = true;
        }
        this.th.check(bl3);
        try {
            h.putAll(null);
            this.th.fail("should throw NullPointerException");
        }
        catch (NullPointerException ne) {
            this.th.check(true);
        }
    }

    public void test_remove() {
        this.th.checkPoint("remove(java.lang.Object)java.lang.Object");
        Hashtable h = this.buildknownHt();
        Float f = new Float(33.0f);
        int i = h.size();
        try {
            h.remove(null);
            this.th.fail("should throw NullPointerException -- 1");
        }
        catch (NullPointerException ne) {
            this.th.check(true);
        }
        boolean bl = false;
        if (h.remove(f) == null) {
            bl = true;
        }
        this.th.check(bl, "key not there so return null");
        boolean bl2 = false;
        if (h.size() == i) {
            bl2 = true;
        }
        this.th.check(bl2, "check on size -- 1");
        int j = 0;
        while (j < 11) {
            f = new Float(j);
            this.th.check(h.remove(f).equals(f), "key is there so return element -- " + j);
            boolean bl3 = false;
            if (h.size() == --i) {
                bl3 = true;
            }
            this.th.check(bl3, "check on size after removing -- " + j);
            ++j;
        }
    }

    public void test_entrySet() {
        this.th.checkPoint("entrySet()java.util.Set");
        Hashtable h = this.buildknownHt();
        Set s = h.entrySet();
        boolean bl = false;
        if (s.size() == 11) {
            bl = true;
        }
        this.th.check(bl);
        Object[] ao = s.toArray();
        int j = 0;
        while (j < ao.length) {
            ++j;
        }
        Iterator i = s.iterator();
        j = 0;
        while (i.hasNext()) {
            Map.Entry m = i.next();
            if (j == 50) break;
            ++j;
        }
        boolean bl2 = false;
        if (j == 11) {
            bl2 = true;
        }
        this.th.check(bl2, "Iterator of Set must not do an Inf Loop, got j" + j);
    }

    public void test_keySet() {
        this.th.checkPoint("keySet()java.util.Set");
        Hashtable h = this.buildknownHt();
        Set s = h.keySet();
        boolean bl = false;
        if (s.size() == 11) {
            bl = true;
        }
        this.th.check(bl);
        int i = 0;
        while (i < 11) {
            this.th.check(s.contains(new Float(i)), "check if all keys are given -- " + i);
            ++i;
        }
    }

    public void test_values() {
        this.th.checkPoint("values()java.util.Collection");
        Hashtable h = this.buildknownHt();
        Collection c = h.values();
        boolean bl = false;
        if (c.size() == 11) {
            bl = true;
        }
        this.th.check(bl);
        int i = 0;
        while (i < 11) {
            this.th.check(c.contains(new Float(i)), "check if all values are given -- " + i);
            ++i;
        }
    }

    public void test_clone() {
        Float f;
        this.th.checkPoint("clone()java.lang.Object");
        Hashtable ht1 = this.buildknownHt();
        Hashtable ht2 = (Hashtable)ht1.clone();
        boolean bl = false;
        if (ht2.size() == 11) {
            bl = true;
        }
        this.th.check(bl, "checking size -- got: " + ht2.size());
        this.th.check(ht2.equals(ht1), "clone gives back equal hashtables");
        Enumeration e = ht1.elements();
        int i = 0;
        while (i < 11) {
            f = (Float)e.nextElement();
            Object o = ht2.get(f);
            boolean bl2 = false;
            if (f == (Float)o) {
                bl2 = true;
            }
            this.th.check(bl2, "key and element are the same");
            ++i;
        }
        f = (Float)ht1.elements().nextElement();
        ht2.remove(f);
        boolean bl3 = false;
        if (ht1.size() == 11) {
            bl3 = true;
        }
        this.th.check(bl3, "changes in clone do not affect original");
        ht1.put(ht2, ht1);
        boolean bl4 = false;
        if (ht2.size() == 10) {
            bl4 = true;
        }
        this.th.check(bl4, "changes in original do not affect clone");
        ht1 = new Hashtable();
        ht2 = (Hashtable)ht1.clone();
        boolean bl5 = false;
        if (ht2.size() == 0) {
            bl5 = true;
        }
        this.th.check(bl5, "cloning an empty hashtable must work");
    }

    public void test_equals() {
        this.th.checkPoint("equals(java.lang.Object)boolean");
        Hashtable h2 = this.buildknownHt();
        Hashtable h1 = this.buildknownHt();
        this.th.check(h2.equals(h1), "hashtables are equal -- 1");
        h2.remove(new Float(2.0f));
        this.th.check(h2.equals(h1) ^ true, "hashtables are not equal");
        h1.remove(new Float(2.0f));
        this.th.check(h2.equals(h1), "hashtables are equal -- 2");
        this.th.check(h2.equals(new Float((double)3)) ^ true, "hashtables is not equal to Float");
    }

    public void test_hashCode() {
        this.th.checkPoint("hashCode()int");
        Hashtable<Number, Object> h = new Hashtable<Number, Object>(13);
        boolean bl = false;
        if (this.buildknownHt().hashCode() == this.buildknownHt().hashCode()) {
            bl = true;
        }
        this.th.check(bl);
        Integer i = new Integer(4545);
        String s = new String("string");
        Double d = new Double(23245.6);
        Object o = new Object();
        h.put(i, s);
        boolean bl2 = false;
        if (h.hashCode() == (i.hashCode() ^ s.hashCode())) {
            bl2 = true;
        }
        this.th.check(bl2);
        h.put(d, o);
        boolean bl3 = false;
        if (h.hashCode() == (i.hashCode() ^ s.hashCode()) + (d.hashCode() ^ o.hashCode())) {
            bl3 = true;
        }
        this.th.check(bl3);
    }

    public void test_toString() {
        this.th.checkPoint("toString()java.lang.String");
        Hashtable<String, Object> h = new Hashtable<String, Object>(13, 0.75f);
        this.th.check(h.toString().equals("{}"), "got: " + h);
        h.put("SmartMove", "Fantastic");
        this.th.check(h.toString().equals("{SmartMove=Fantastic}"), "got: " + h);
        h.put("nr 1", new Float(23.0));
        boolean bl = false;
        if (h.toString().equals("{SmartMove=Fantastic, nr 1=23.0}") || h.toString().equals("{nr 1=23.0, SmartMove=Fantastic}")) {
            bl = true;
        }
        this.th.check(bl, "got: " + h);
        h.remove("SmartMove");
        this.th.check(h.toString().equals("{nr 1=23.0}"), "got: " + h);
    }

    public void test_rehash() {
        this.th.checkPoint("rehash()void");
        Hashtable<String, String> h = new Hashtable<String, String>(3, 0.5f);
        try {
            h.put("Smart", "Move");
            h.put("rehash", "now");
            boolean bl = false;
            if (h.size() == 2) {
                bl = true;
            }
            this.th.check(bl);
        }
        catch (Exception e) {
            this.th.fail("caught exception " + e);
        }
    }

    public void test_behaviour() {
        this.th.checkPoint("behaviour testing");
        this.do_behaviourtest(0.7f);
        this.do_behaviourtest(0.75f);
        this.do_behaviourtest(0.95f);
        this.do_behaviourtest(1.0f);
    }

    protected void sleep(int time) {
        try {
            Thread.sleep(time);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected void check_presence(Hashtable h) {
        boolean bl = false;
        if (h.get("a") != null) {
            bl = true;
        }
        this.th.check(bl, "checking presence st -- sequence " + this.sqnce);
        boolean bl2 = false;
        if (h.get(this.sh) != null) {
            bl2 = true;
        }
        this.th.check(bl2, "checking presence sh -- sequence " + this.sqnce);
        boolean bl3 = false;
        if (h.get(this.i) != null) {
            bl3 = true;
        }
        this.th.check(bl3, "checking presence i -- sequence " + this.sqnce);
        boolean bl4 = false;
        if (h.get(this.b) != null) {
            bl4 = true;
        }
        this.th.check(bl4, "checking presence b -- sequence " + this.sqnce);
        boolean bl5 = false;
        if (h.get(this.l) != null) {
            bl5 = true;
        }
        this.th.check(bl5, "checking presence l -- sequence " + this.sqnce);
        ++this.sqnce;
    }

    protected void do_behaviourtest(float loadFactor) {
        Float f;
        this.th.checkPoint("behaviour testing with loadFactor " + loadFactor);
        Hashtable<Object, Object> h = new Hashtable<Object, Object>(11, loadFactor);
        int j = 0;
        h.put("a", "a");
        h.put(this.b, "byte");
        h.put(this.sh, "short");
        h.put(this.i, "int");
        h.put(this.l, "long");
        this.check_presence(h);
        this.sqnce = 1;
        while (j < 100) {
            f = new Float(j);
            h.put(f, f);
            ++j;
        }
        boolean bl = false;
        if (h.size() == 105) {
            bl = true;
        }
        this.th.check(bl, "size checking -- 1 got: " + h.size());
        this.check_presence(h);
        while (j < 200) {
            f = new Float(j);
            h.put(f, f);
            ++j;
        }
        boolean bl2 = false;
        if (h.size() == 205) {
            bl2 = true;
        }
        this.th.check(bl2, "size checking -- 2 got: " + h.size());
        this.check_presence(h);
        while (j < 300) {
            f = new Float(j);
            h.put(f, f);
            ++j;
        }
        boolean bl3 = false;
        if (h.size() == 305) {
            bl3 = true;
        }
        this.th.check(bl3, "size checking -- 3 got: " + h.size());
        this.check_presence(h);
        this.th.check("a".equals(h.put("a", "na")), "replacing values -- 1 - st");
        this.th.check("byte".equals(h.put(this.b, "nbyte")), "replacing values -- 2 - b");
        this.th.check("short".equals(h.put(this.sh, "nshort")), "replacing values -- 3 -sh");
        this.th.check("int".equals(h.put(this.i, "nint")), "replacing values -- 4 -i");
        this.th.check("long".equals(h.put(this.l, "nlong")), "replacing values -- 5 -l");
        while (j > 199) {
            f = new Float(j);
            h.remove(f);
            --j;
        }
        boolean bl4 = false;
        if (h.size() == 205) {
            bl4 = true;
        }
        this.th.check(bl4, "size checking -- 4 got: " + h.size());
        this.check_presence(h);
        while (j > 99) {
            f = new Float(j);
            h.remove(f);
            --j;
        }
        boolean bl5 = false;
        if (h.size() == 105) {
            bl5 = true;
        }
        this.th.check(bl5, "size checking -- 5 got: " + h.size());
        this.check_presence(h);
        while (j > -1) {
            f = new Float(j);
            h.remove(f);
            --j;
        }
        boolean bl6 = false;
        if (h.size() == 5) {
            bl6 = true;
        }
        this.th.check(bl6, "size checking -- 6 got: " + h.size());
        this.th.debug(h.toString());
        this.check_presence(h);
    }

    private final /* synthetic */ void this() {
        this.b = new Byte(97);
        this.sh = new Short(97);
        this.i = new Integer(97);
        this.l = new Long(97L);
        this.sqnce = 1;
    }

    public SMHashtableTest() {
        this.this();
    }
}

