/*
 * Decompiled with CFR 0.152.
 */
package gnu.testlet.wonka.util.HashSet;

import gnu.testlet.TestHarness;
import gnu.testlet.Testlet;
import java.util.ConcurrentModificationException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Vector;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class AcuniaHashSetTest
implements Testlet {
    protected TestHarness th;
    private final String st = "a";
    private final Byte b;
    private final Short sh;
    private final Integer i;
    private final Long l;
    private int sqnce;

    public void test(TestHarness harness) {
        this.th = harness;
        this.th.setclass("java.util.HashSet");
        this.test_contains();
        this.test_isEmpty();
        this.test_size();
        this.test_add();
        this.test_clear();
        this.test_remove();
        this.test_iterator();
        this.test_clone();
        this.test_behaviour();
    }

    public void test_HashSet() {
        this.th.checkPoint("HashSet(java.util.Collection)");
        Vector<Object> v = new Vector<Object>();
        v.add("a");
        v.add(null);
        v.add("c");
        v.add(this);
        v.add("a");
        v.add(null);
        HashSet hs = new HashSet(v);
        this.th.check(hs.size(), 4, "checking size -- 1");
        this.th.check(hs.contains(this), "checking elements -- 1");
        this.th.check(hs.contains(null), "checking elements -- 2");
        try {
            new HashSet(null);
            this.th.fail("should throw a NullPointerException");
        }
        catch (NullPointerException e) {
            this.th.check(true);
        }
        this.th.checkPoint("HashSet(int)");
        try {
            new HashSet(-1);
            this.th.fail("should throw an IllegalArgumentException");
        }
        catch (IllegalArgumentException e) {
            this.th.check(true);
        }
        this.th.checkPoint("HashSet(int,int)");
        try {
            new HashSet(-1, 0.5f);
            this.th.fail("should throw an IllegalArgumentException");
        }
        catch (IllegalArgumentException e) {
            this.th.check(true);
        }
        try {
            new HashSet(1, -0.5f);
            this.th.fail("should throw an IllegalArgumentException");
        }
        catch (IllegalArgumentException e) {
            this.th.check(true);
        }
    }

    public void test_contains() {
        this.th.checkPoint("contains(java.lang.Object)boolean");
        HashSet<String> al = new HashSet<String>();
        this.th.check(al.contains(null) ^ true, "checking empty List -- 1");
        this.th.check(al.contains(al) ^ true, "checking empty List -- 2");
        al.add("a");
        al.add(null);
        al.add("6");
        this.th.check(al.contains(null), "check contains ... -- 1");
        this.th.check(al.contains("a"), "check contains ... -- 2");
        this.th.check(al.contains(this) ^ true, "check contains ... -- 3");
        al.remove("6");
        al.remove(null);
        this.th.check(al.contains(null) ^ true, "check contains ... -- 4");
        this.th.check(al.contains("6") ^ true, "check contains ... -- 5");
    }

    public void test_isEmpty() {
        this.th.checkPoint("isEmpty()boolean");
        HashSet<String> hs = new HashSet<String>();
        this.th.check(hs.isEmpty(), "isEmpty -- 1");
        hs.add("a");
        this.th.check(hs.isEmpty() ^ true, "isEmpty -- 2");
        hs.clear();
        this.th.check(hs.isEmpty(), "isEmpty -- 3");
        hs.add("B");
        this.th.check(hs.isEmpty() ^ true, "isEmpty -- 4");
        hs.remove("B");
        this.th.check(hs.isEmpty(), "isEmpty -- 5");
    }

    public void test_size() {
        this.th.checkPoint("size()int");
        HashSet<String> hs = new HashSet<String>();
        this.th.check(hs.size(), 0, "verifying size -- 1");
        hs.add("a");
        this.th.check(hs.size(), 1, "verifying size -- 2");
        hs.add("B");
        this.th.check(hs.size(), 2, "verifying size -- 3");
        hs.add("B");
        this.th.check(hs.size(), 2, "verifying size -- 4");
        hs.add(null);
        this.th.check(hs.size(), 3, "verifying size -- 5");
        hs.remove("not");
        this.th.check(hs.size(), 3, "verifying size -- 6");
        hs.remove("B");
        this.th.check(hs.size(), 2, "verifying size -- 7");
        hs.clear();
        this.th.check(hs.size(), 0, "verifying size -- 8");
    }

    public void test_add() {
        this.th.checkPoint("add(java.lang.Object)boolean");
        HashSet<String> hs = new HashSet<String>();
        this.th.check(hs.add("a"), "checking return value -- 1");
        this.th.check(hs.add("c"), "checking return value -- 2");
        this.th.check(hs.add("a") ^ true, "checking return value -- 3");
        this.th.check(hs.add(null), "checking return value -- 4");
        this.th.check(hs.add(null) ^ true, "checking return value -- 5");
        boolean bl = false;
        if (hs.size() == 3) {
            bl = true;
        }
        this.th.check(bl, "duplicate elements aren't added");
    }

    public void test_clear() {
        this.th.checkPoint("clear()void");
        HashSet<String> hs = new HashSet<String>();
        hs.clear();
        hs.add("a");
        hs.clear();
        this.th.check(hs.size(), 0, "HashSet is cleared");
    }

    public void test_remove() {
        this.th.checkPoint("remove(java.lang.Object)boolean");
        HashSet<String> hs = new HashSet<String>();
        hs.clear();
        hs.add("a");
        hs.clear();
        this.th.check(hs.remove(null) ^ true, "nothing to remove -- 1");
        this.th.check(hs.size(), 0, "HashSet is cleared");
        hs.add("a");
        this.th.check(hs.remove(null) ^ true, "nothing to remove -- 2");
        this.th.check(hs.size(), 1, "HashSet is cleared");
        hs.add(null);
        this.th.check(hs.remove("C") ^ true, "nothing to remove -- 3");
        this.th.check(hs.remove("a"), "remove -- 1");
        this.th.check(hs.remove("a") ^ true, "remove -- 2");
        this.th.check(hs.remove(null), "remove -- 3");
        this.th.check(hs.remove(null) ^ true, "remove -- 4");
    }

    public void test_iterator() {
        Object o;
        this.th.checkPoint("iterator()java.util.Iterator");
        HashSet<String> v = new HashSet<String>(19);
        v.add("a");
        v.add("c");
        v.add("u");
        v.add("n");
        v.add("i");
        v.add(null);
        v.add("!");
        Iterator it = v.iterator();
        HashSet vc = (HashSet)v.clone();
        int i = 0;
        while (it.hasNext()) {
            o = it.next();
            if (!vc.remove(o)) {
                this.th.debug("didn't find " + o + " in vector");
            }
            if (i++ > 20) break;
        }
        boolean bl = false;
        if (i < 20) {
            bl = true;
        }
        this.th.check(bl, "check for infinite loop");
        this.th.check(vc.isEmpty(), "all elements iterated");
        try {
            it.next();
            this.th.fail("should throw a NoSuchElementException");
        }
        catch (NoSuchElementException nsee) {
            this.th.check(true);
        }
        it = v.iterator();
        try {
            it.remove();
            this.th.fail("should throw an IllegalStateException -- 1");
        }
        catch (IllegalStateException ise) {
            this.th.check(true);
        }
        it.next();
        it.remove();
        try {
            it.remove();
            this.th.fail("should throw an IllegalStateException -- 2");
        }
        catch (IllegalStateException ise) {
            this.th.check(true);
        }
        it.next();
        v.add("new");
        try {
            it.next();
            this.th.fail("should throw a ConcurrentModificationException -- 1");
        }
        catch (ConcurrentModificationException cme) {
            this.th.check(true);
        }
        try {
            it.remove();
            this.th.fail("should throw a ConcurrentModificationException -- 2");
        }
        catch (ConcurrentModificationException cme) {
            this.th.check(true);
        }
        i = 0;
        it = v.iterator();
        while (it.hasNext()) {
            o = it.next();
            it.remove();
            if (v.contains(o)) {
                this.th.fail("removed wrong element when tried to remove " + o + ", got:" + v);
            }
            if (i++ > 20) break;
        }
        this.th.check(v.isEmpty(), "all elements are removed");
        v.add("a");
        v.add("c");
        v.add("u");
        v.add("n");
        v.add("i");
        it = v.iterator();
        v.contains("a");
        v.isEmpty();
        v.clone();
        v.iterator();
        try {
            it.next();
            this.th.check(true, "Ok -- 1");
        }
        catch (Exception e) {
            this.th.fail("should not throw an Exception, got " + e);
        }
        it = v.iterator();
        v.add(null);
        try {
            it.next();
            this.th.fail("should throw a ConcurrentModificationException -- add(Object)");
        }
        catch (ConcurrentModificationException cme) {
            this.th.check(true, "Ok -- 2");
        }
        it = v.iterator();
        v.remove("a");
        try {
            it.next();
            this.th.fail("should throw a ConcurrentModificationException -- remove(Object)");
        }
        catch (ConcurrentModificationException cme) {
            this.th.check(true, "Ok -- 3");
        }
        it = v.iterator();
        v.clear();
        try {
            it.next();
            this.th.fail("should throw a ConcurrentModificationException -- clear");
        }
        catch (ConcurrentModificationException cme) {
            this.th.check(true);
        }
    }

    public void test_clone() {
        this.th.checkPoint("clone()java.lang.Object");
        HashSet<Object> hs = new HashSet<Object>(11);
        HashSet clone = (HashSet)hs.clone();
        this.th.check(clone.isEmpty(), "clone is empty");
        this.th.check(clone.add("a"), "clone can be modified");
        this.th.check(hs.size(), 0, "changing clone didn't modify set -- 1");
        hs.add(null);
        hs.add("a");
        hs.add(this);
        clone = (HashSet)hs.clone();
        this.th.check(clone.size(), 3, "checking cloned size");
        this.th.check(clone.remove(this), "checking elements of clone -- 1");
        this.th.check(clone.add(null) ^ true, "checking elements of clone -- 2");
        this.th.check(clone.add("a") ^ true, "checking elements of clone -- 2");
        this.th.check(hs.size(), 3, "changing clone didn't modify set -- 2");
    }

    public void test_behaviour() {
        this.th.checkPoint("behaviour testing");
        this.do_behaviourtest(0.75f);
        this.do_behaviourtest(0.95f);
        this.do_behaviourtest(1.0f);
    }

    protected void check_presence(HashSet h) {
        this.th.check(h.add("a") ^ true, "checking presence st -- sequence " + this.sqnce);
        this.th.check(h.add(this.sh) ^ true, "checking presence sh -- sequence " + this.sqnce);
        this.th.check(h.add(this.i) ^ true, "checking presence i -- sequence " + this.sqnce);
        this.th.check(h.add(this.b) ^ true, "checking presence b -- sequence " + this.sqnce);
        this.th.check(h.add(this.l) ^ true, "checking presence l -- sequence " + this.sqnce);
        ++this.sqnce;
    }

    protected void do_behaviourtest(float loadFactor) {
        Float f;
        this.th.checkPoint("behaviour testing with loadFactor " + loadFactor);
        HashSet<Object> h = new HashSet<Object>(11, loadFactor);
        int j = 0;
        h.add("a");
        h.add(this.b);
        h.add(this.sh);
        h.add(this.i);
        h.add(this.l);
        this.check_presence(h);
        this.sqnce = 1;
        while (j < 100) {
            f = new Float(j);
            h.add(f);
            ++j;
        }
        boolean bl = false;
        if (h.size() == 105) {
            bl = true;
        }
        this.th.check(bl, "size checking -- 1 got: " + h.size());
        this.check_presence(h);
        while (j < 200) {
            f = new Float(j);
            h.add(f);
            ++j;
        }
        boolean bl2 = false;
        if (h.size() == 205) {
            bl2 = true;
        }
        this.th.check(bl2, "size checking -- 2 got: " + h.size());
        this.check_presence(h);
        while (j < 300) {
            f = new Float(j);
            h.add(f);
            ++j;
        }
        boolean bl3 = false;
        if (h.size() == 305) {
            bl3 = true;
        }
        this.th.check(bl3, "size checking -- 3 got: " + h.size());
        this.check_presence(h);
        this.th.check(h.add("a") ^ true, "replacing values -- 1 - st");
        this.th.check(h.add(this.b) ^ true, "replacing values -- 2 - b");
        this.th.check(h.add(this.sh) ^ true, "replacing values -- 3 -sh");
        this.th.check(h.add(this.i) ^ true, "replacing values -- 4 -i");
        this.th.check(h.add(this.l) ^ true, "replacing values -- 5 -l");
        while (j > 199) {
            f = new Float(j);
            h.remove(f);
            --j;
        }
        boolean bl4 = false;
        if (h.size() == 205) {
            bl4 = true;
        }
        this.th.check(bl4, "size checking -- 4 got: " + h.size());
        this.check_presence(h);
        while (j > 99) {
            f = new Float(j);
            h.remove(f);
            --j;
        }
        boolean bl5 = false;
        if (h.size() == 105) {
            bl5 = true;
        }
        this.th.check(bl5, "size checking -- 5 got: " + h.size());
        this.check_presence(h);
        while (j > -1) {
            f = new Float(j);
            h.remove(f);
            --j;
        }
        boolean bl6 = false;
        if (h.size() == 5) {
            bl6 = true;
        }
        this.th.check(bl6, "size checking -- 6 got: " + h.size());
        this.th.debug(h.toString());
        this.check_presence(h);
    }

    private final /* synthetic */ void this() {
        this.b = new Byte(97);
        this.sh = new Short(97);
        this.i = new Integer(97);
        this.l = new Long(97L);
        this.sqnce = 1;
    }

    public AcuniaHashSetTest() {
        this.this();
    }
}

