/*
 * Decompiled with CFR 0.152.
 */
package gnu.testlet.wonka.util.Collections;

import gnu.testlet.TestHarness;
import gnu.testlet.Testlet;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Random;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;

public class AcuniaCollectionsTest
implements Testlet {
    protected TestHarness th;
    protected HashComparator hc = new HashComparator();

    public void test(TestHarness harness) {
        this.th = harness;
        this.th.setclass("java.util.Collections");
        this.test_enumeration();
        this.test_fields();
        this.test_max();
        this.test_min();
        this.test_binarySearch();
        this.test_copy();
        this.test_fill();
        this.test_nCopies();
        this.test_reverse();
        this.test_shuffle();
        this.test_sort();
        this.test_singleton();
        this.test_reverseOrder();
        this.test_synchronizedCollection();
        this.test_synchronizedList();
        this.test_synchronizedMap();
        this.test_synchronizedSet();
        this.test_synchronizedSortedMap();
        this.test_synchronizedSortedSet();
        this.test_unmodifiableCollection();
        this.test_unmodifiableList();
        this.test_unmodifiableMap();
        this.test_unmodifiableSet();
        this.test_unmodifiableSortedMap();
        this.test_unmodifiableSortedSet();
    }

    protected List buildList(int size) {
        ArrayList<String> al = new ArrayList<String>();
        for (int i = 0; i < size; ++i) {
            al.add("string " + i);
        }
        return al;
    }

    public void test_enumeration() {
        this.th.checkPoint("enumeration(java.util.Collection)java.util.Enumeration");
        List l = this.buildList(10);
        List ls = this.buildList(10);
        Enumeration<Object> e = Collections.enumeration(l);
        boolean b = true;
        while (e.hasMoreElements()) {
            b &= ls.remove(e.nextElement());
        }
        this.th.check(b && ls.isEmpty());
        try {
            e.nextElement();
            this.th.fail("should throw a NoSuchElementException");
        }
        catch (NoSuchElementException nsee) {
            this.th.check(true);
        }
        HashSet<String> s = new HashSet<String>();
        e = Collections.enumeration(s);
        this.th.check(!e.hasMoreElements(), "empty set");
        try {
            e.nextElement();
            this.th.fail("should throw a NoSuchElementException");
        }
        catch (NoSuchElementException nsee) {
            this.th.check(true);
        }
        s.add("element");
        e = Collections.enumeration(s);
        this.th.check(e.hasMoreElements(), "not an empty set");
        s.add("another");
    }

    public void test_fields() {
        this.th.checkPoint("EMPTY_LIST");
        List l = Collections.EMPTY_LIST;
        this.th.check(l.size(), 0, "empty list");
        try {
            l.add("String");
            this.th.fail("shoult throw an UnsupportedOperationException -- 1");
        }
        catch (UnsupportedOperationException uoe) {
            this.th.check(true);
        }
        this.th.checkPoint("EMPTY_SET");
        Set s = Collections.EMPTY_SET;
        this.th.check(s.size(), 0, "empty set");
        try {
            s.add("String");
            this.th.fail("shoult throw an UnsupportedOperationException -- 1");
        }
        catch (UnsupportedOperationException uoe) {
            this.th.check(true);
        }
    }

    public void test_max() {
        this.th.checkPoint("max(java.util.Collection)java.lang.Object");
        List<Object> l = this.buildList(20);
        this.th.check(Collections.max(l), "string 9", "verifying maximum -- 1");
        try {
            Collections.max(Collections.EMPTY_SET);
            this.th.fail("should throw a NoSuchElementException");
        }
        catch (NoSuchElementException nsee) {
            this.th.check(true);
        }
        l = new ArrayList<Object>();
        l.add(null);
        this.th.check(Collections.max(l), null, "verifying maximum -- 1");
        try {
            Collections.max(null);
            this.th.fail("should throw a NullPointerException");
        }
        catch (NullPointerException npe) {
            this.th.check(true);
        }
        this.th.checkPoint("max(java.util.Collection,java.util.Comparator)java.lang.Object");
        l = this.buildList(20);
        l.add(4, null);
        l.add(14, null);
        this.th.check(Collections.max(l, this.hc), "string 9", "verifying maximum -- 1");
        try {
            Collections.max(Collections.EMPTY_SET, this.hc);
            this.th.fail("should throw a NoSuchElementException");
        }
        catch (NoSuchElementException nsee) {
            this.th.check(true);
        }
        l = new ArrayList();
        l.add(null);
        this.th.check(Collections.max(l, this.hc), null, "verifying maximum -- 1");
        l.add("null");
        try {
            Collections.max(null, this.hc);
            this.th.fail("should throw a NullPointerException -- 1");
        }
        catch (NullPointerException npe) {
            this.th.check(true);
        }
        try {
            this.th.debug("got: " + Collections.max(l, null));
            this.th.fail("should throw a NullPointerException -- 2");
        }
        catch (NullPointerException npe) {
            this.th.check(true);
        }
    }

    public void test_min() {
        this.th.checkPoint("min(java.util.Collection)java.lang.Object");
        List<Object> l = this.buildList(20);
        this.th.check(Collections.min(l), "string 0", "verifying minimum -- 1");
        try {
            Collections.min(Collections.EMPTY_SET);
            this.th.fail("should throw a NoSuchElementException");
        }
        catch (NoSuchElementException nsee) {
            this.th.check(true);
        }
        l = new ArrayList<Object>();
        l.add(null);
        this.th.check(Collections.min(l), null, "verifying minimum -- 1");
        try {
            Collections.min(null);
            this.th.fail("should throw a NullPointerException -- 1");
        }
        catch (NullPointerException npe) {
            this.th.check(true);
        }
        this.th.checkPoint("min(java.util.Collection,java.util.Comparator)java.lang.Object");
        l = this.buildList(20);
        l.add(4, null);
        l.add(14, null);
        this.th.check(Collections.min(l, this.hc), "string 10", "verifying minimum -- 1");
        try {
            Collections.min(Collections.EMPTY_SET, this.hc);
            this.th.fail("should throw a NoSuchElementException");
        }
        catch (NoSuchElementException nsee) {
            this.th.check(true);
        }
        l = new ArrayList();
        l.add(null);
        this.th.check(Collections.min(l, this.hc), null, "verifying minimum -- 1");
        l.add("null");
        try {
            Collections.min(null, this.hc);
            this.th.fail("should throw a NullPointerException -- 1");
        }
        catch (NullPointerException npe) {
            this.th.check(true);
        }
        try {
            this.th.debug("got: " + Collections.min(l, null));
            this.th.fail("should throw a NullPointerException -- 2");
        }
        catch (NullPointerException npe) {
            this.th.check(true);
        }
    }

    public void test_binarySearch() {
        this.th.checkPoint("binarySearch(java.util.List,java.lang.Object)int");
        List l = this.buildList(10);
        this.th.check(Collections.binarySearch(l, "not found"), -1, "(- index - 1) is returned if not found -- 1");
        this.th.check(Collections.binarySearch(l, "string 5bis"), -7, "(- index - 1) is returned if not found -- 2");
        this.th.check(Collections.binarySearch(l, "wstring"), -11, "(- index - 1) is returned if not found -- 3");
        this.th.check(Collections.binarySearch(l, "string 8bis"), -10, "(- index - 1) is returned if not found -- 4");
        this.th.check(Collections.binarySearch(l, "string 0"), 0, "index  is returned if found -- 1");
        this.th.check(Collections.binarySearch(l, "string 5"), 5, "index is returned if found -- 2");
        this.th.check(Collections.binarySearch(l, "string 9"), 9, "index is returned if found -- 3");
        this.th.check(Collections.binarySearch(Collections.EMPTY_LIST, null), -1, "(-index -1) is returned if not found -- 5");
        try {
            Collections.binarySearch(null, "");
            this.th.fail("should throw a NullPointerException -- 1");
        }
        catch (NullPointerException npe) {
            this.th.check(true);
        }
        this.th.checkPoint("binarySearch(java.util.List,java.lang.Object,java.util.Comparator)int");
        this.th.check(Collections.binarySearch(l, "not found", this.hc), -1, "(- index - 1) is returned if not found -- 1");
        this.th.check(Collections.binarySearch(l, null, this.hc), -1, "(- index - 1) is returned if not found -- 2");
        this.th.check(Collections.binarySearch(l, "string 0", this.hc), 0, "index  is returned if found -- 1");
        this.th.check(Collections.binarySearch(l, "string 5", this.hc), 5, "index is returned if found -- 2");
        this.th.check(Collections.binarySearch(l, "string 9", this.hc), 9, "index is returned if found -- 3");
        try {
            Collections.binarySearch(null, "", this.hc);
            this.th.fail("should throw a NullPointerException -- 1");
        }
        catch (NullPointerException npe) {
            this.th.check(true);
        }
        try {
            Collections.binarySearch(l, "", null);
            this.th.fail("should throw a NullPointerException -- 2");
        }
        catch (NullPointerException npe) {
            this.th.check(true);
        }
    }

    public void test_copy() {
        this.th.checkPoint("copy(java.util.List,java.util.List)void");
        List ls = this.buildList(10);
        ArrayList ld = new ArrayList();
        ld.add(null);
        ld.add(null);
        ld.add(null);
        try {
            Collections.copy(ld, ls);
            this.th.fail("should throw an IndexOutOfBoundsException");
        }
        catch (IndexOutOfBoundsException ioobe) {
            this.th.check(true);
        }
        try {
            Collections.copy(null, ls);
            this.th.fail("should throw a NullPointerException -- 1");
        }
        catch (NullPointerException npe) {
            this.th.check(true);
        }
        try {
            Collections.copy(ld, null);
            this.th.fail("should throw a NullPointerException -- 2");
        }
        catch (NullPointerException npe) {
            this.th.check(true);
        }
        while (ld.size() < 11) {
            ld.add(null);
        }
        Collections.copy(ld, ls);
        this.th.check(ld.get(10), null);
        ld.remove(null);
        this.th.check(((Object)ld).equals(ls), "verify copied parts");
    }

    public void test_fill() {
        this.th.checkPoint("fill(java.util.List,java.lang.Object)void");
        ArrayList<String> ls = this.buildList(5);
        Collections.fill(ls, null);
        this.th.check(ls.get(0) == null && ls.get(1) == null && ls.get(2) == null && ls.get(3) == null && ls.get(4) == null, "check if all elements are set to null");
        try {
            Collections.fill(null, "a");
            this.th.fail("should throw a NullPointerException -- 1");
        }
        catch (NullPointerException npe) {
            this.th.check(true);
        }
        ls = new ArrayList<String>();
        Collections.fill(ls, null);
        ls.add("a");
        Collections.fill(ls, "b");
        this.th.check(ls.get(0), (Object)"b");
    }

    public void test_nCopies() {
        this.th.checkPoint("nCopies(int,java.lang.Object)java.util.List");
        try {
            Collections.nCopies(-1, "a");
            this.th.fail("should throw an IllegalArgumentException");
        }
        catch (IllegalArgumentException iae) {
            this.th.check(true);
        }
        List<String> l = Collections.nCopies(3, "a");
        try {
            l.add("String");
            this.th.fail("shoult throw an UnsupportedOperationException -- 1");
        }
        catch (UnsupportedOperationException uoe) {
            this.th.check(true);
        }
        try {
            l.remove("a");
            this.th.fail("shoult throw an UnsupportedOperationException -- 2");
        }
        catch (UnsupportedOperationException uoe) {
            this.th.check(true);
        }
        try {
            l.set(2, "String");
            this.th.fail("shoult throw an UnsupportedOperationException -- 3");
        }
        catch (UnsupportedOperationException uoe) {
            this.th.check(true);
        }
        boolean b = "a".equals(l.get(0));
        b &= "a".equals(l.get(1));
        this.th.check(b &= "a".equals(l.get(2)), "all elements should be 'a'");
    }

    public void test_reverse() {
        this.th.checkPoint("reverse(java.util.List)void");
        ArrayList<String> l = new ArrayList<String>();
        Collections.reverse(l);
        l.add("a");
        Collections.reverse(l);
        l.add("b");
        Collections.reverse(l);
        this.th.check("b".equals(l.get(0)) && "a".equals(l.get(1)));
        l.add("c");
        Collections.reverse(l);
        this.th.check("b".equals(l.get(2)) && "a".equals(l.get(1)) && "c".equals(l.get(0)));
    }

    public void test_shuffle() {
        this.th.checkPoint("shuffle(java.util.List)void");
        ArrayList als = (ArrayList)this.buildList(7);
        ArrayList alo = new ArrayList(als);
        Collections.shuffle(als);
        this.th.debug("shuffled result 1 = \n" + als);
        ArrayList al1 = new ArrayList(alo);
        this.th.debug("shuffled result 2 = \n" + al1);
        Collections.shuffle(al1);
        ArrayList al2 = new ArrayList(alo);
        Collections.shuffle(al2);
        this.th.debug("shuffled result 3 = \n" + al2);
        this.th.checkPoint("shuffle(java.util.List,java.util.Random)void");
    }

    public void test_sort() {
        int i;
        int i2;
        this.th.checkPoint("sort(java.util.List)void");
        List l = this.buildList(10);
        for (i2 = 0; i2 < 10; ++i2) {
            l.add("string 9" + i2);
        }
        for (i2 = 0; i2 < 10; ++i2) {
            l.add("string 99" + i2);
        }
        for (i2 = 0; i2 < 10; ++i2) {
            l.add("string 999" + i2);
        }
        List ls = new ArrayList(l);
        Random r = new Random();
        boolean b = true;
        for (i = 0; i < 25; ++i) {
            Collections.shuffle(ls, r);
            Collections.sort(ls);
            b &= ((Object)l).equals(ls);
        }
        this.th.check(b, "check if sort works");
        this.th.checkPoint("sort(java.util.List)void");
        l = this.buildList(10);
        ls = this.buildList(10);
        b = true;
        for (i = 0; i < 15; ++i) {
            Collections.shuffle(ls, r);
            Collections.sort(ls);
            b &= ((Object)l).equals(ls);
        }
        this.th.check(b, "check if sort works");
    }

    public void test_singleton() {
        this.th.checkPoint("singleton(java.lang.Object)java.util.Set");
        Set<Object> s = Collections.singleton(null);
        this.th.check(s.size(), 1);
        Iterator<Object> it = s.iterator();
        this.th.check(it.next(), null);
        try {
            it.remove();
            this.th.fail("shoult throw an UnsupportedOperationException -- 1");
        }
        catch (UnsupportedOperationException uoe) {
            this.th.check(true);
        }
        try {
            s.add("String");
            this.th.fail("shoult throw an UnsupportedOperationException -- 2");
        }
        catch (UnsupportedOperationException uoe) {
            this.th.check(true);
        }
        try {
            s.remove(null);
            this.th.fail("shoult throw an UnsupportedOperationException -- 3");
        }
        catch (UnsupportedOperationException uoe) {
            this.th.check(true);
        }
    }

    public void test_reverseOrder() {
        this.th.checkPoint("reverseOrder()java.util.Comparator");
        List l = this.buildList(10);
        Collections.sort(l, Collections.reverseOrder());
        this.th.check("string 9".equals(l.get(0)) && "string 8".equals(l.get(1)) && "string 7".equals(l.get(2)));
        this.th.check("string 6".equals(l.get(3)) && "string 5".equals(l.get(4)) && "string 4".equals(l.get(5)));
        this.th.check("string 3".equals(l.get(6)) && "string 2".equals(l.get(7)) && "string 1".equals(l.get(8)) && "string 0".equals(l.get(9)));
        this.th.debug("" + l);
    }

    public void test_synchronizedCollection() {
        this.th.checkPoint("synchronizedCollection(java.util.Collection)java.util.Collection");
    }

    public void test_synchronizedList() {
        this.th.checkPoint("synchronizedList(java.util.List)java.util.List");
    }

    public void test_synchronizedMap() {
        this.th.checkPoint("synchronizedMap(java.util.Map)java.util.Map");
    }

    public void test_synchronizedSet() {
        this.th.checkPoint("synchronizedSet(java.util.Set)java.util.Set");
    }

    public void test_synchronizedSortedMap() {
        this.th.checkPoint("synchronizedSortedMap(java.util.SortedMap)java.util.SortedMap");
    }

    public void test_synchronizedSortedSet() {
        this.th.checkPoint("synchronizedSortedSet(java.util.SortedSet)java.util.SortedSet");
    }

    public void test_unmodifiableCollection() {
        this.th.checkPoint("unmodifiableCollection(java.util.Collection)java.util.Collection");
    }

    public void test_unmodifiableList() {
        this.th.checkPoint("unmodifiableList(java.util.List)java.util.List");
    }

    public void test_unmodifiableMap() {
        this.th.checkPoint("unmodifiableMap(java.util.Map)java.util.Map");
    }

    public void test_unmodifiableSet() {
        this.th.checkPoint("unmodifiableSet(java.util.Set)java.util.Set");
    }

    public void test_unmodifiableSortedMap() {
        this.th.checkPoint("unmodifiableSortedMap(java.util.SortedMap)java.util.SortedMap");
    }

    public void test_unmodifiableSortedSet() {
        this.th.checkPoint("unmodifiableSortedSet(java.util.SortedSet)java.util.SortedSet");
        TreeSet ts = new TreeSet(this.buildList(10));
        SortedSet<String> s = Collections.unmodifiableSortedSet(ts);
        SortedSet<String> tls = s.tailSet("string 4");
        Iterator it = tls.iterator();
        it.next();
        try {
            it.remove();
            this.th.fail("should throw an UnsupportedOperationException");
        }
        catch (UnsupportedOperationException uoe) {
            this.th.check(true);
        }
    }

    protected class HashComparator
    implements Comparator {
        protected HashComparator() {
        }

        public int compare(Object o, Object t) {
            int ho = o == null ? 0 : o.hashCode();
            int ht = t == null ? 0 : t.hashCode();
            return ho - ht;
        }
    }
}

