/*
 * Decompiled with CFR 0.152.
 */
package gnu.testlet.wonka.security.UnresolvedPermission;

import gnu.testlet.TestHarness;
import gnu.testlet.Testlet;
import java.security.Permission;
import java.security.PermissionCollection;
import java.security.SecurityPermission;
import java.security.UnresolvedPermission;
import java.security.cert.Certificate;
import java.util.Enumeration;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class AcuniaUnresolvedPermissionTest
implements Testlet {
    protected TestHarness th;
    private final String cname = "java.security.Permission";
    private final String action = "do_action";
    private final Certificate[] cert;

    public void test(TestHarness harness) {
        this.th = harness;
        this.th.setclass("java.security.UnresolvedPermission");
        this.test_UnresolvedPermission();
        this.test_equals();
        this.test_hashCode();
        this.test_implies();
        this.test_getActions();
        this.test_newPermissionCollection();
        this.test_toString();
        this.test_checkGuard();
    }

    public void test_UnresolvedPermission() {
        this.th.checkPoint("UnresolvedPermission(java.lang.String,java.lang.String,java.lang.String,java.security.cert.Certificate[])");
        String s = "acunia.*";
        UnresolvedPermission bp = new UnresolvedPermission("java.security.Permission", s, "do_action", this.cert);
        this.th.check(bp.getName(), "java.security.Permission", "checking name");
        s = "*";
        bp = new UnresolvedPermission("java.security.Permission", s, "do_action", this.cert);
        this.th.check(bp.getName(), "java.security.Permission", "checking name");
        try {
            new UnresolvedPermission(null, "java.security.Permission", "do_action", this.cert);
            this.th.fail("should throw a NullPointerException -- 1");
        }
        catch (NullPointerException iae) {
            this.th.check(true, "caught exException -- 1");
        }
    }

    public void test_equals() {
        this.th.checkPoint("equals(java.lang.Object)boolean");
        UnresolvedPermission bp = new UnresolvedPermission("java.security.Permission", "com.acunia", "do_action", this.cert);
        this.th.check(bp.equals(null) ^ true, "null is allowed");
        this.th.check(bp.equals(new UnresolvedPermission("java.security.Permission", "com.*", "do_action", this.cert)) ^ true, "not equal -- 1");
        this.th.check(bp.equals(new UnresolvedPermission("java.security.Permission", "com.acunia", "1", this.cert)) ^ true, "not equal --2");
        this.th.check(bp.equals(new SecurityPermission("com.acunia", "1")) ^ true, "not equal -- 3");
        this.th.check(bp.equals(new UnresolvedPermission("cname", "com.acunia", "do_action", this.cert)) ^ true, "not equal --4");
        Certificate[] certs = new Certificate[2];
        this.th.check(bp.equals(new UnresolvedPermission("java.security.Permission", "com.acunia", "do_action", certs)) ^ true, "not equal --5");
        this.th.check(bp.equals(new UnresolvedPermission("java.security.Permission", "com.acunia", "do_action", this.cert)), "equal");
    }

    public void test_hashCode() {
        this.th.checkPoint("hashCode()int");
        String s = "com.acunia";
        UnresolvedPermission bp = new UnresolvedPermission("java.security.Permission", s, "do_action", this.cert);
        this.th.check(bp.hashCode(), s.hashCode() ^ "java.security.Permission".hashCode() ^ "do_action".hashCode(), "cheking hash algorithm ... - 1");
        s = "com.*";
        bp = new UnresolvedPermission("java.security.Permission", s, "do_action", this.cert);
        this.th.check(bp.hashCode(), s.hashCode() ^ "java.security.Permission".hashCode() ^ "do_action".hashCode(), "cheking hash algorithm ... - 2");
        s = "*";
        bp = new UnresolvedPermission("java.security.Permission", s, "do_action", this.cert);
        this.th.check(bp.hashCode(), s.hashCode() ^ "java.security.Permission".hashCode() ^ "do_action".hashCode(), "cheking hash algorithm ... - 3");
        bp = new UnresolvedPermission("java.security.Permission", s, "do_action", this.cert);
        this.th.check(bp.hashCode(), s.hashCode() ^ "java.security.Permission".hashCode() ^ "do_action".hashCode(), "cheking hash algorithm ... - 4");
    }

    public void test_implies() {
        this.th.checkPoint("implies(java.security.Permission)boolean");
        UnresolvedPermission bp1 = new UnresolvedPermission("java.security.Permission", "com.acunia", "do_action", this.cert);
        UnresolvedPermission bp2 = new UnresolvedPermission("java.security.Permission", "com.*", "do_action", this.cert);
        this.th.check(bp1.implies(bp2) ^ true, "not implied - 1");
        this.th.check(bp2.implies(bp1) ^ true, "implied - 1");
        this.th.check(bp1.implies(bp1) ^ true, "implied - 2");
        this.th.check(bp2.implies(bp2) ^ true, "implied - 3");
        this.th.check(bp1.implies(new SecurityPermission("com.acunia", "1")) ^ true, "not implied -- 2");
    }

    public void test_getActions() {
        this.th.checkPoint("getActions()java.lang.String");
        String s = "com.acunia";
        UnresolvedPermission bp = new UnresolvedPermission("java.security.Permission", s, "do_action", this.cert);
        this.th.check(bp.getActions(), "", "getActions returnvalue - 1");
        s = "com.*";
        bp = new UnresolvedPermission("java.security.Permission", s, "do_action", this.cert);
        this.th.check(bp.getActions(), "", "getActions returnvalue - 2");
        s = "*";
        bp = new UnresolvedPermission("java.security.Permission", s, s, this.cert);
        this.th.check(bp.getActions(), "", "getActions returnvalue - 3");
    }

    public void test_newPermissionCollection() {
        Enumeration<Permission> e;
        this.th.checkPoint("newPermissionCollection()java.security.PermissionCollection");
        String s = "com.acunia";
        UnresolvedPermission bp = new UnresolvedPermission("java.security.Permission", s, "do_action", this.cert);
        PermissionCollection pc = bp.newPermissionCollection();
        this.th.check(pc.isReadOnly() ^ true);
        pc.setReadOnly();
        this.th.check(pc.isReadOnly());
        try {
            pc.add(bp);
            e = pc.elements();
            this.th.check(e.hasMoreElements() ^ true, "element added after read only is true");
        }
        catch (SecurityException se) {
            this.th.check(true);
        }
        pc = bp.newPermissionCollection();
        pc.add(bp);
        pc.add(new UnresolvedPermission("java.security.Permission", "be.*", "do_action", this.cert));
        pc.add(new UnresolvedPermission("java.security.Permission", "vm.smartmove", "do_action", this.cert));
        pc.add(new UnresolvedPermission("java.security.Permission", "com.acunia.vm*", "do_action", this.cert));
        try {
            e = pc.elements();
            boolean bl = false;
            if (bp == e.nextElement()) {
                bl = true;
            }
            boolean found = bl;
            boolean bl2 = false;
            if (bp == e.nextElement()) {
                bl2 = true;
            }
            found |= bl2;
            boolean bl3 = false;
            if (bp == e.nextElement()) {
                bl3 = true;
            }
            found |= bl3;
            boolean bl4 = false;
            if (bp == e.nextElement()) {
                bl4 = true;
            }
            this.th.check(found |= bl4, "references should be kept");
            this.th.check(e.hasMoreElements() ^ true, "should be empty");
        }
        catch (Exception e2) {
            this.th.fail("Enumeration elements() was bad");
        }
        s = pc.toString();
        this.th.debug(s);
        boolean bl = false;
        if (s.indexOf(bp.toString()) >= 0) {
            bl = true;
        }
        this.th.check(bl, "checking toString ...");
        boolean bl5 = false;
        if (s.indexOf(new UnresolvedPermission("java.security.Permission", "be.*", "do_action", this.cert).toString()) >= 0) {
            bl5 = true;
        }
        this.th.check(bl5, "checking toString ...");
        boolean bl6 = false;
        if (s.indexOf(new UnresolvedPermission("java.security.Permission", "vm.smartmove", "do_action", this.cert).toString()) >= 0) {
            bl6 = true;
        }
        this.th.check(bl6, "checking toString ...");
        boolean bl7 = false;
        if (s.indexOf(new UnresolvedPermission("java.security.Permission", "com.acunia.vm*", "do_action", this.cert).toString()) >= 0) {
            bl7 = true;
        }
        this.th.check(bl7, "checking toString ...");
        this.th.check(pc.implies(bp) ^ true, "implies -- 1 " + bp);
    }

    public void test_toString() {
        this.th.checkPoint("toString()java.lang.String");
        String s = "com.acunia";
        UnresolvedPermission bp = new UnresolvedPermission("java.security.Permission", s, "read", this.cert);
        this.th.check(bp.toString(), (Object)("(unresolved \"java.security.Permission\" \"" + s + "\" \"read\")"));
    }

    public void test_checkGuard() {
        this.th.checkPoint("checkGuard()void");
    }

    private final /* synthetic */ void this() {
        this.cert = new Certificate[0];
    }

    public AcuniaUnresolvedPermissionTest() {
        this.this();
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    private class ExPermission
    extends Permission {
        public int hashCode() {
            return 0;
        }

        public boolean equals(Object o) {
            return false;
        }

        public boolean implies(Permission p) {
            return false;
        }

        public String getActions() {
            return "";
        }

        public ExPermission(String n) {
            super(n);
        }
    }
}

