/*
 * Decompiled with CFR 0.152.
 */
package gnu.testlet.wonka.security.Permissions;

import gnu.testlet.TestHarness;
import gnu.testlet.Testlet;
import java.awt.AWTPermission;
import java.io.FilePermission;
import java.lang.reflect.ReflectPermission;
import java.net.NetPermission;
import java.net.SocketPermission;
import java.security.AllPermission;
import java.security.Permission;
import java.security.Permissions;
import java.security.SecurityPermission;
import java.security.UnresolvedPermission;
import java.util.Enumeration;
import java.util.NoSuchElementException;
import java.util.PropertyPermission;
import java.util.Vector;

public class AcuniaPermissionsTest
implements Testlet {
    protected TestHarness th;

    public void test(TestHarness harness) {
        this.th = harness;
        this.th.setclass("java.security.Permissions");
        this.test_Permissions();
        this.test_add();
        this.test_implies();
        this.test_elements();
        this.th.setclass("java.security.PermissionCollection");
        this.test_isReadOnly();
        this.test_setReadOnly();
        this.test_toString();
    }

    public void test_Permissions() {
        this.th.checkPoint("Permissions()");
    }

    public void test_add() {
        this.th.checkPoint("add(java.security.Permission)void");
        Permissions ps = new Permissions();
        ps.setReadOnly();
        try {
            ps.add(new SecurityPermission("com.*"));
            Enumeration<Permission> e = ps.elements();
            this.th.check(e.hasMoreElements() ^ true);
        }
        catch (SecurityException se) {
            this.th.check(true);
        }
    }

    public void test_elements() {
        this.th.checkPoint("elements()java.util.Enumeration");
        Permissions ps = new Permissions();
        Enumeration<Permission> e = ps.elements();
        this.th.check(e.hasMoreElements() ^ true);
        try {
            e.nextElement();
            this.th.fail("should throw a NoSuchElementException");
        }
        catch (NoSuchElementException nse) {
            this.th.check(true);
        }
        Permission p = new SecurityPermission("com.*");
        Vector<SecurityPermission> v = new Vector<SecurityPermission>(11);
        p = new AWTPermission("com.*");
        v.add((SecurityPermission)p);
        ps.add(p);
        p = new NetPermission("com.*");
        v.add((SecurityPermission)p);
        ps.add(p);
        p = new FilePermission("com.*", "read,write");
        v.add((SecurityPermission)p);
        ps.add(p);
        p = new PropertyPermission("com.*", "read");
        v.add((SecurityPermission)p);
        ps.add(p);
        p = new AllPermission();
        v.add((SecurityPermission)p);
        ps.add(p);
        p = new AWTPermission("funny");
        v.add((SecurityPermission)p);
        ps.add(p);
        p = new SocketPermission("*.com", "connect");
        v.add((SecurityPermission)p);
        ps.add(p);
        p = new SecurityPermission("com.acunia");
        v.add((SecurityPermission)p);
        ps.add(p);
        p = new FilePermission("com.*", "delete");
        v.add((SecurityPermission)p);
        ps.add(p);
        p = new SecurityPermission("*");
        v.add((SecurityPermission)p);
        ps.add(p);
        p = new SecurityPermission("toppie");
        v.add((SecurityPermission)p);
        ps.add(p);
        e = ps.elements();
        boolean ok = true;
        while (e.hasMoreElements()) {
            Permission o = e.nextElement();
            if (v.remove(o)) continue;
            this.th.debug("element " + o + " not found in vector");
            ok = false;
        }
        this.th.check(ok, "bad references returned");
        this.th.check(v.isEmpty(), "not all element were removed " + v);
    }

    public void test_implies() {
        this.th.checkPoint("implies(java.security.Permission)boolean");
        Permissions ps = new Permissions();
        Permission p = new SecurityPermission("com.*");
        p = new AWTPermission("com.*");
        ps.add(p);
        this.th.check(ps.implies(p), "implies - 1");
        p = new NetPermission("com.*");
        ps.add(p);
        this.th.check(ps.implies(p), "implies - 2");
        p = new FilePermission("com.*", "read,write");
        ps.add(p);
        this.th.check(ps.implies(p), "implies - 3");
        p = new PropertyPermission("com.*", "read");
        ps.add(p);
        this.th.check(ps.implies(p), "implies - 4");
        p = new NetPermission("not");
        ps.add(p);
        this.th.check(ps.implies(p), "implies - 5");
        p = new AWTPermission("funny");
        ps.add(p);
        this.th.check(ps.implies(p), "implies - 6");
        p = new SocketPermission("*.com", "connect");
        ps.add(p);
        this.th.check(ps.implies(p), "implies - 7");
        p = new SecurityPermission("*");
        ps.add(p);
        this.th.check(ps.implies(p), "implies - 8");
        p = new FilePermission("com/-", "delete");
        ps.add(p);
        this.th.check(ps.implies(p), "implies - 9");
        p = new FilePermission("com/*", "write,read");
        ps.add(p);
        this.th.check(ps.implies(p), "implies - 10");
        this.th.check(ps.implies(new FilePermission("com/file1", "read,write,delete")), "implies - 11");
        this.th.check(ps.implies(new ReflectPermission("java.lang.*")) ^ true, "not implied - 1");
        this.th.check(ps.implies(new SecurityPermission("java.lang.*")), "implied - 12");
        this.th.check(ps.implies(new NetPermission("java.lang.*")) ^ true, "not implied - 2");
        this.th.check(ps.implies(new AWTPermission("java.lang.*")) ^ true, "not implied - 3");
        this.th.check(ps.implies(new FilePermission("java.lang.*", "execute")) ^ true, "not implied - 4");
        this.th.check(ps.implies(new SocketPermission("*.ac.be", "connect")) ^ true, "not implied - 5");
        this.th.check(ps.implies(new UnresolvedPermission("java", "java", null, null)) ^ true, "not implied - 6");
        p = new AllPermission();
        ps.add(p);
        this.th.check(ps.implies(new ReflectPermission("java.lang.*")), "implied - 13");
        this.th.check(ps.implies(new NetPermission("java.lang.*")), "implied - 14");
    }

    public void test_setReadOnly() {
        this.th.checkPoint("setReadOnly()void");
    }

    public void test_isReadOnly() {
        this.th.checkPoint("isReadOnly()boolean");
        Permissions ps = new Permissions();
        this.th.check(ps.isReadOnly() ^ true, "not readOnly");
        ps.setReadOnly();
        this.th.check(ps.isReadOnly(), "set to readOnly");
    }

    public void test_toString() {
        this.th.checkPoint("toString()java.lang.String");
        Permissions ps = new Permissions();
        this.th.check(ps.toString(), (Object)("java.security.Permissions@" + Integer.toHexString(ps.hashCode()) + " (\n)\n"));
    }
}

