/*
 * Decompiled with CFR 0.152.
 */
package gnu.testlet.wonka.security.BasicPermission;

import gnu.testlet.TestHarness;
import gnu.testlet.Testlet;
import gnu.testlet.wonka.security.BasicPermission.ExBasicPermission;
import java.net.NetPermission;
import java.security.Permission;
import java.security.PermissionCollection;
import java.util.Enumeration;

public class AcuniaNetPermissionTest
implements Testlet {
    protected TestHarness th;

    public void test(TestHarness harness) {
        this.th = harness;
        this.th.setclass("java.net.NetPermission");
        this.test_NetPermission();
        this.test_equals();
        this.test_hashCode();
        this.test_implies();
        this.test_getActions();
        this.test_newPermissionCollection();
    }

    public void test_NetPermission() {
        this.th.checkPoint("NetPermission(java.lang.String)");
        String s = "acunia.*";
        NetPermission bp = new NetPermission(s);
        this.th.check(bp.getName(), s, "checking name");
        s = "*";
        bp = new NetPermission(s);
        this.th.check(bp.getName(), s, "checking name");
        try {
            new NetPermission("");
            this.th.fail("should throw an IllegalArgumentException -- 1");
        }
        catch (IllegalArgumentException iae) {
            this.th.check(true, "caught exception -- 1");
        }
        try {
            new NetPermission("*.java");
            this.th.fail("should throw an IllegalArgumentException -- 2");
        }
        catch (IllegalArgumentException iae) {
            this.th.check(true, "caught exception -- 2");
        }
        try {
            new NetPermission("*com");
            this.th.fail("should throw an IllegalArgumentException -- 3");
        }
        catch (IllegalArgumentException iae) {
            this.th.check(true, "caught exception -- 3");
        }
        try {
            new NetPermission("com*acunia");
            this.th.fail("should throw an IllegalArgumentException -- 4");
        }
        catch (IllegalArgumentException iae) {
            this.th.check(true, "caught exception -- 4");
        }
        try {
            new NetPermission("**");
            this.th.fail("should throw an IllegalArgumentException -- 5");
        }
        catch (IllegalArgumentException iae) {
            this.th.check(true, "caught exception -- 5");
        }
        try {
            new NetPermission("*.*");
            this.th.fail("should throw an IllegalArgumentException -- 6");
        }
        catch (IllegalArgumentException iae) {
            this.th.check(true, "caught exception -- 6");
        }
        try {
            new NetPermission(null);
            this.th.fail("should throw a NullPointerException -- 7");
        }
        catch (NullPointerException iae) {
            this.th.check(true, "caught exception -- 7");
        }
        this.th.checkPoint("NetPermission(java.lang.String,java.lang.String)");
        try {
            bp = new NetPermission("cool.*", null);
            this.th.check(bp.getName(), (Object)"cool.*");
            new NetPermission("cool.*", "");
            new NetPermission("cool.*", "*ddf");
            this.th.check(true);
        }
        catch (Exception e) {
            this.th.fail("got unwanted exception " + e);
        }
    }

    public void test_equals() {
        this.th.checkPoint("equals(java.lang.Object)boolean");
        NetPermission bp = new NetPermission("com.acunia");
        this.th.check(bp.equals(null) ^ true, "null is allowed");
        this.th.check(bp.equals(new NetPermission("com.*")) ^ true, "not equal -- 2");
        this.th.check(bp.equals(new NetPermission("com.acunia", "1")), "equal");
        this.th.check(bp.equals(new ExBasicPermission("com.acunia", "1")) ^ true, "not equal -- 2");
    }

    public void test_hashCode() {
        this.th.checkPoint("hashCode()int");
        String s = "com.acunia";
        NetPermission bp = new NetPermission(s);
        this.th.check(bp.hashCode(), s.hashCode(), "cheking hash algorithm ... - 1");
        s = "com.*";
        bp = new NetPermission(s);
        this.th.check(bp.hashCode(), s.hashCode(), "cheking hash algorithm ... - 2");
        s = "*";
        bp = new NetPermission(s, s);
        this.th.check(bp.hashCode(), s.hashCode(), "cheking hash algorithm ... - 3");
        bp = new NetPermission(s);
        this.th.check(bp.hashCode(), s.hashCode(), "cheking hash algorithm ... - 4");
    }

    public void test_implies() {
        this.th.checkPoint("implies(java.security.Permission)boolean");
        NetPermission bp1 = new NetPermission("com.acunia");
        NetPermission bp2 = new NetPermission("com.*");
        this.th.check(bp1.implies(bp2) ^ true, "not implied - 1");
        this.th.check(bp2.implies(bp1), "implied - 1");
        this.th.check(bp1.implies(bp1), "implied - 2");
        this.th.check(bp2.implies(bp2), "implied - 3");
        this.th.check(bp1.implies(new ExBasicPermission("com.acunia", "1")) ^ true, "not implied -- 2");
        bp2 = new NetPermission("com.*");
        this.th.check(bp2.implies(bp1), "implied - 4");
        bp1 = new NetPermission("com.");
        this.th.check(bp2.implies(bp1), "implied - 5");
        this.th.check(bp1.implies(bp2) ^ true, "not implied - 3");
        bp1 = new NetPermission("coma");
        bp2 = new NetPermission("coma*");
        this.th.check(bp2.implies(bp1), "implied - 6");
        this.th.check(bp1.implies(bp2) ^ true, "not implied - 4");
    }

    public void test_getActions() {
        this.th.checkPoint("getActions()java.lang.String");
        String s = "com.acunia";
        NetPermission bp = new NetPermission(s);
        this.th.check(bp.getActions(), "", "getActions returnvalue - 1");
        s = "com.*";
        bp = new NetPermission(s);
        this.th.check(bp.getActions(), "", "getActions returnvalue - 2");
        s = "*";
        bp = new NetPermission(s, s);
        this.th.check(bp.getActions(), "", "getActions returnvalue - 3");
        bp = new NetPermission(s);
        this.th.check(bp.getActions(), "", "getActions returnvalue - 4");
    }

    public void test_newPermissionCollection() {
        Enumeration<Permission> e;
        this.th.checkPoint("newPermissionCollection()java.security.PermissionCollection");
        String s = "com.acunia";
        NetPermission bp = new NetPermission(s);
        PermissionCollection pc = bp.newPermissionCollection();
        this.th.check(pc.isReadOnly() ^ true);
        pc.setReadOnly();
        this.th.check(pc.isReadOnly());
        try {
            pc.add(bp);
            e = pc.elements();
            this.th.check(e.hasMoreElements() ^ true);
        }
        catch (SecurityException se) {
            this.th.check(true);
        }
        pc = bp.newPermissionCollection();
        pc.add(bp);
        pc.add(new NetPermission("be.*"));
        pc.add(new NetPermission("vm.smartmove"));
        pc.add(new NetPermission("com.acunia.vm*"));
        try {
            e = pc.elements();
            boolean bl = false;
            if (bp == e.nextElement()) {
                bl = true;
            }
            boolean found = bl;
            boolean bl2 = false;
            if (bp == e.nextElement()) {
                bl2 = true;
            }
            found |= bl2;
            boolean bl3 = false;
            if (bp == e.nextElement()) {
                bl3 = true;
            }
            found |= bl3;
            boolean bl4 = false;
            if (bp == e.nextElement()) {
                bl4 = true;
            }
            this.th.check(found |= bl4, "reference should be kept");
            this.th.check(e.hasMoreElements() ^ true, "should be empty");
        }
        catch (Exception e2) {
            this.th.fail("Enumeration elements() was bad");
        }
        e = pc.elements();
        int i = 0;
        while (i < 50 && e.hasMoreElements()) {
            this.th.debug("got " + e.nextElement() + ", i = " + i);
            ++i;
        }
        s = pc.toString();
        this.th.debug(s);
        boolean bl = false;
        if (s.indexOf(bp.toString()) >= 0) {
            bl = true;
        }
        this.th.check(bl, "checking toString ...");
        boolean bl5 = false;
        if (s.indexOf(new NetPermission("be.*").toString()) >= 0) {
            bl5 = true;
        }
        this.th.check(bl5, "checking toString ...");
        boolean bl6 = false;
        if (s.indexOf(new NetPermission("vm.smartmove").toString()) >= 0) {
            bl6 = true;
        }
        this.th.check(bl6, "checking toString ...");
        boolean bl7 = false;
        if (s.indexOf(new NetPermission("com.acunia.vm*").toString()) >= 0) {
            bl7 = true;
        }
        this.th.check(bl7, "checking toString ...");
        this.th.check(pc.implies(bp), "implies -- 1 " + bp);
        bp = new NetPermission("com.acu*");
        this.th.check(pc.implies(bp) ^ true, "implies -- 2 " + bp);
        bp = new NetPermission("be.");
        this.th.check(pc.implies(bp), "implies -- 3 " + bp);
        bp = new NetPermission("be");
        this.th.check(pc.implies(bp) ^ true, "implies -- 4 " + bp);
        bp = new NetPermission("com.acunia");
        this.th.check(pc.implies(bp), "implies -- 5 " + bp);
        bp = new NetPermission("com.acunia.vm");
        this.th.check(pc.implies(bp), "implies -- 6 " + bp);
        bp = new NetPermission("vm");
        this.th.check(pc.implies(bp) ^ true, "implies -- 7 " + bp);
    }
}

