/*
 * Decompiled with CFR 0.152.
 */
package gnu.testlet.wonka.net.SocketPermission;

import gnu.testlet.TestHarness;
import gnu.testlet.Testlet;
import java.net.SocketPermission;
import java.security.Permission;
import java.security.PermissionCollection;
import java.security.SecurityPermission;
import java.util.Enumeration;
import java.util.NoSuchElementException;

public class AcuniaSocketPermissionTest
implements Testlet {
    protected TestHarness th;

    public void test(TestHarness harness) {
        this.th = harness;
        this.th.setclass("java.net.SocketPermission");
        this.test_SocketPermission();
        this.test_equals();
        this.test_hashCode();
        this.test_implies();
        this.test_getActions();
        this.test_newPermissionCollection();
        this.test_toString();
    }

    public void test_SocketPermission() {
        this.th.checkPoint("SocketPermission(java.lang.String,java.lang.String)");
        SocketPermission bp = new SocketPermission("", "accept");
        this.th.check(bp.getName(), (Object)"localhost");
        this.th.check(bp.getActions(), (Object)"accept,resolve");
        bp = new SocketPermission("localhost", "resolve");
        this.th.check(bp.getName(), (Object)"localhost");
        this.th.check(bp.getActions(), (Object)"resolve");
        bp = new SocketPermission("127.0.0.1:2-", "resolve");
        this.th.check(bp.getName(), (Object)"127.0.0.1:2-");
        try {
            new SocketPermission(null, "connect");
            this.th.fail("should throw a NullPointerException -- 1");
        }
        catch (NullPointerException npe) {
            this.th.check(true);
        }
        try {
            new SocketPermission("connect", null);
            this.th.fail("should throw a NullPointerException -- 2");
        }
        catch (NullPointerException npe) {
            this.th.check(true);
        }
        catch (IllegalArgumentException iae) {
            this.th.check(true);
            this.th.debug("wanted a NullPointerException though");
        }
        try {
            bp = new SocketPermission("*:12345678", "accept");
            this.th.fail("should throw a IllegalArgumentException -- 3");
            this.th.debug("just created :" + bp);
        }
        catch (IllegalArgumentException iae) {
            this.th.check(true);
        }
        try {
            new SocketPermission("1.2.3.4:567-89", "accept");
            this.th.fail("should throw a IllegalArgumentException -- 4");
        }
        catch (IllegalArgumentException iae) {
            this.th.check(true);
        }
        try {
            bp = new SocketPermission("23-445:1.1.56.3", "accept");
            this.th.fail("should throw a IllegalArgumentException -- 5");
            this.th.debug("just created :" + bp);
        }
        catch (IllegalArgumentException iae) {
            this.th.check(true);
        }
        try {
            new SocketPermission("", "accept connect");
            this.th.fail("should throw a IllegalArgumentException -- 6");
        }
        catch (IllegalArgumentException iae) {
            this.th.check(true);
        }
        try {
            new SocketPermission("", "accepty");
            this.th.fail("should throw a IllegalArgumentException -- 7");
        }
        catch (IllegalArgumentException iae) {
            this.th.check(true);
        }
        try {
            new SocketPermission("", "accept, resolve, , listen");
            this.th.fail("should throw a IllegalArgumentException -- 8");
        }
        catch (IllegalArgumentException iae) {
            this.th.check(true);
        }
        try {
            new SocketPermission("222.255.3.4,123.2.3.4:34", "accept, resolve, , listen");
            this.th.fail("should throw a IllegalArgumentException -- 9");
        }
        catch (IllegalArgumentException iae) {
            this.th.check(true);
        }
        try {
            new SocketPermission("*:23,25", "accept, resolve, , listen");
            this.th.fail("should throw a IllegalArgumentException -- 10");
        }
        catch (IllegalArgumentException iae) {
            this.th.check(true);
        }
        try {
            new SocketPermission("234.3.4.5:234:345", "accept, resolve, , listen");
            this.th.fail("should throw a IllegalArgumentException -- 11");
        }
        catch (IllegalArgumentException iae) {
            this.th.check(true);
        }
        try {
            new SocketPermission(" 123. 1 .32 . 1\n", "accept, resolve, , listen");
            this.th.fail("should throw a IllegalArgumentException -- 12");
        }
        catch (IllegalArgumentException iae) {
            this.th.check(true);
        }
        try {
            new SocketPermission("*.sun.*", "accept, resolve, , listen");
            this.th.fail("should throw a IllegalArgumentException -- 13");
        }
        catch (IllegalArgumentException iae) {
            this.th.check(true);
        }
        try {
            new SocketPermission("sun.*", "accept, resolve, , listen");
            this.th.fail("should throw a IllegalArgumentException -- 14");
        }
        catch (IllegalArgumentException iae) {
            this.th.check(true);
        }
        try {
            new SocketPermission("*.*", "accept, resolve, , listen");
            this.th.fail("should throw a IllegalArgumentException -- 15");
        }
        catch (IllegalArgumentException iae) {
            this.th.check(true);
        }
        try {
            new SocketPermission("*.243.33.4", "accept, resolve, , listen");
            this.th.fail("should throw a IllegalArgumentException -- 16");
        }
        catch (IllegalArgumentException iae) {
            this.th.check(true);
        }
        try {
            new SocketPermission("123.256.34.4", "accept, resolve, , listen");
            this.th.fail("should throw a IllegalArgumentException -- 17");
        }
        catch (IllegalArgumentException iae) {
            this.th.check(true);
        }
        try {
            new SocketPermission("123.25.34", "accept, resolve, , listen");
            this.th.fail("should throw a IllegalArgumentException -- 18");
        }
        catch (IllegalArgumentException iae) {
            this.th.check(true);
        }
        try {
            new SocketPermission("123.0.256.4", "accept, resolve, , listen");
            this.th.fail("should throw a IllegalArgumentException -- 19");
        }
        catch (IllegalArgumentException iae) {
            this.th.check(true);
        }
        try {
            new SocketPermission("123..1.1.256", "accept, resolve, , listen");
            this.th.fail("should throw a IllegalArgumentException -- 20");
        }
        catch (IllegalArgumentException iae) {
            this.th.check(true);
        }
        try {
            new SocketPermission("123.1.1.25.6", "accept, resolve, , listen");
            this.th.fail("should throw a IllegalArgumentException -- 21");
        }
        catch (IllegalArgumentException iae) {
            this.th.check(true);
        }
        try {
            new SocketPermission("123..1.1.25.6", "accept, resolve, , listen");
            this.th.fail("should throw a IllegalArgumentException -- 22");
        }
        catch (IllegalArgumentException iae) {
            this.th.check(true);
        }
        try {
            new SocketPermission(":123", "accept, resolve, , listen");
            this.th.fail("should throw a IllegalArgumentException -- 23");
        }
        catch (IllegalArgumentException iae) {
            this.th.check(true);
        }
        try {
            new SocketPermission("1.2.2.3:3 3", "accept, resolve, , listen");
            this.th.fail("should throw a IllegalArgumentException -- 24");
        }
        catch (IllegalArgumentException iae) {
            this.th.check(true);
        }
    }

    public void test_equals() {
        this.th.checkPoint("equals(java.lang.Object)boolean");
        String s = "www.acunia.com:20-";
        SocketPermission bp = new SocketPermission(s, "AcCePt,  CoNnEcT \n");
        this.th.check(bp.equals(null) ^ true, "null is allowed");
        this.th.check(bp.equals(new SocketPermission(s, "CoNnEcT ,AcCePt \n\t ,CoNnEcT")), "equal -- 1");
        this.th.check(bp.equals(new SecurityPermission(s, "accept,connect")) ^ true, "not equal -- 1");
        this.th.check(bp.equals(new SocketPermission(s, "accept")) ^ true, "not equal -- 2");
        this.th.check(bp.equals(new SocketPermission(s, "accept,connect,resolve")), "equal -- 2");
        bp = new SocketPermission("", "AcCePt,  CoNnEcT \n, LiStEn");
        this.th.check(bp, new SocketPermission("localhost", "accept,connect,listen"), "equal -- 3");
        this.th.check(bp, new SocketPermission("127.0.0.1", "accept,connect,listen"), "equal -- 4");
        this.th.check(bp.equals(new SocketPermission("*:-3", "accept,connect,listen")) ^ true, "not equal -- 2");
        this.th.check(bp.equals(new SocketPermission("127.0.0.1", "connect,listen")) ^ true, "not equal -- 3");
    }

    public void test_hashCode() {
        this.th.checkPoint("hashCode()int");
        String s = "*.acunia.com";
        SocketPermission bp = new SocketPermission(s, "accept,listen");
        this.th.check(bp.hashCode(), s.hashCode(), "cheking hashCode ... - 1");
        this.th.check(bp.hashCode(), new SocketPermission(s, "AcCePt").hashCode());
        s = "*";
        bp = new SocketPermission(s, "accept");
        this.th.check(bp.hashCode(), s.hashCode(), "cheking hashCode ... - 1");
        this.th.check(bp.hashCode(), new SocketPermission(s, "AcCePt,cOnnEct").hashCode());
    }

    public void test_getActions() {
        this.th.checkPoint("getActions()java.lang.String");
        String s = "www.acunia.com:80-99";
        SocketPermission bp = new SocketPermission(s, "connect \n \f");
        this.th.check(bp.getActions(), "connect,resolve", "getActions returnvalue - 1");
        s = "*.com:12";
        bp = new SocketPermission(s, "  \t \nCoNnEcT\f");
        this.th.check(bp.getActions(), "connect,resolve", "getActions returnvalue - 2");
        s = "*:232-";
        bp = new SocketPermission(s, "CoNnEcT \n ,\t AcCePt , AcCePt ,CoNnEcT");
        this.th.check(bp.getActions(), "connect,accept,resolve", "getActions returnvalue - 3");
        bp = new SocketPermission(s, "ReSoLvE\n \t   \f, CoNnEcT,\t LiStEn\n, \f \nAcCePt \n");
        this.th.check(bp.getActions(), "connect,listen,accept,resolve", "getActions returnvalue - 4");
    }

    public void test_implies() {
        this.th.checkPoint("implies(java.security.Permission)boolean");
        SocketPermission bp1 = new SocketPermission("localhost:80", "accept");
        SocketPermission bp2 = new SocketPermission("", "accept,resolve");
        this.th.check(bp1.implies(bp2) ^ true, "not implied - 1");
        this.th.check(bp2.implies(null) ^ true, "not implied - 2");
        this.th.check(bp2.implies(bp1), "implied - 1");
        this.th.check(bp1.implies(new SecurityPermission("com.acunia", "accept")) ^ true, "not implied -- 3");
        bp2 = new SocketPermission("", "accept,resolve,connect");
        bp1 = new SocketPermission("", "accept,resolve,connect,listen");
        this.th.check(bp2.implies(bp1) ^ true, "not implied - 4");
        bp1 = new SocketPermission("", "accept,connect");
        this.th.check(bp2.implies(bp1), "implied - 2");
        bp1 = new SocketPermission("", "accept,listen");
        this.th.check(bp2.implies(bp1) ^ true, "not implied - 5");
        bp2 = new SocketPermission("localhost:30-30000", "accept,resolve,connect");
        bp1 = new SocketPermission("localhost:300-3000", "accept,resolve,connect");
        this.th.check(bp1.implies(bp2) ^ true, "not implied - 6");
        this.th.check(bp2.implies(bp1), "implied - 3");
        bp1 = new SocketPermission("localhost:-3000", "accept,resolve,connect");
        this.th.check(bp2.implies(bp1) ^ true, "not implied - 7");
        bp1 = new SocketPermission("localhost", "accept,resolve,connect");
        this.th.check(bp2.implies(bp1) ^ true, "not implied - 8");
        bp1 = new SocketPermission("localhost:300-", "accept,resolve,connect");
        this.th.check(bp2.implies(bp1) ^ true, "not implied - 9");
        bp1 = new SocketPermission("localhost:3000", "accept,resolve,connect");
        this.th.check(bp2.implies(bp1), "implied - 4");
        bp2 = new SocketPermission("192.168.0.1", "accept,resolve,connect");
        bp1 = new SocketPermission("192.168.0.1:80", "accept,resolve,connect");
        this.th.check(bp2.implies(bp1), "implied - 5");
        bp1 = new SocketPermission("192.168.1.1:80", "accept,resolve,connect");
        this.th.check(bp2.implies(bp1) ^ true, "not implied - 10");
        bp2 = new SocketPermission("*.sun.com", "accept,resolve,connect");
        bp1 = new SocketPermission("java.sun.com:80", "accept,resolve,connect");
        this.th.check(bp2.implies(bp1), "implied - 6");
        bp1 = new SocketPermission("*.www.sun.com:80", "accept,resolve,connect");
        this.th.check(bp2.implies(bp1), "implied - 7");
        bp1 = new SocketPermission("sun.com:80", "accept,resolve,connect");
        this.th.check(bp2.implies(bp1), "implied - 7bis");
        bp2 = new SocketPermission("*.acunia.com", "accept,resolve,connect");
        bp1 = new SocketPermission("acunia.com:80", "accept,resolve,connect");
        this.th.check(bp2.implies(bp1) ^ true, "not implied - 11");
        bp2 = new SocketPermission("*", "accept,resolve,connect");
        bp1 = new SocketPermission("192.168.0.1", "accept,resolve,connect");
        this.th.check(bp2.implies(bp1), "implied - 8");
        bp2 = new SocketPermission("www.sun.com", "accept,resolve,connect");
        bp1 = new SocketPermission("www.sun.com:80", "accept,resolve,connect");
        this.th.check(bp2.implies(bp1), "implied - 9");
        bp2 = new SocketPermission("*.sun.com", "accept,resolve,connect");
        bp1 = new SocketPermission("*.sun.com:80", "accept,resolve,connect");
        this.th.check(bp2.implies(bp1), "implied - 10");
        bp1 = new SocketPermission("*.sun.us:80", "accept,resolve,connect");
        this.th.check(bp2.implies(bp1) ^ true, "not implied - 12");
    }

    public void test_newPermissionCollection() {
        this.th.checkPoint("newPermissionCollection()java.security.PermissionCollection");
        String s = "*.sun.com";
        SocketPermission bp = new SocketPermission(s, "connect");
        PermissionCollection pc = bp.newPermissionCollection();
        this.th.check(pc.isReadOnly() ^ true, "not readOnly");
        pc.setReadOnly();
        this.th.check(pc.isReadOnly(), "readOnly");
        try {
            pc.add(bp);
            Enumeration<Permission> e = pc.elements();
            this.th.check(e.hasMoreElements() ^ true, "added element");
        }
        catch (SecurityException se) {
            this.th.check(true);
        }
        pc = bp.newPermissionCollection();
        pc.add(bp);
        pc.add(new SocketPermission("192.168.0.1:30-30000", "accept,connect,listen"));
        pc.add(bp);
        pc.add(new SocketPermission("java.sun.com:80-100", "connect,accept,listen"));
        pc.add(bp);
        pc.add(new SocketPermission("java.sun.com:90-120", "accept,connect"));
        pc.add(new SocketPermission("localhost:90-120", "connect"));
        boolean f = false;
        Enumeration<Permission> e = pc.elements();
        try {
            while (e.hasMoreElements()) {
                boolean bl = false;
                if (bp == e.nextElement()) {
                    bl = true;
                }
                f |= bl;
            }
            this.th.check(f, "references should be kept");
        }
        catch (Exception ee) {
            this.th.fail("Enumeration elements() was bad");
        }
        try {
            e.nextElement();
            this.th.fail("Enumeration elements() was bad");
        }
        catch (NoSuchElementException nse) {
            this.th.check(true);
        }
        s = pc.toString();
        this.th.debug(s);
        boolean bl = false;
        if (s.indexOf(bp.toString()) >= 0) {
            bl = true;
        }
        this.th.check(bl, "checking toString ...");
        SocketPermission bp1 = new SocketPermission("localhost:100", "connect");
        this.th.check(pc.implies(bp1), "implied - 1");
        this.th.check(pc.implies(new SecurityPermission("com.acunia", "accept")) ^ true, "not implied -- 1");
        bp1 = new SocketPermission("localhost:100", "accept,resolve,connect,listen");
        this.th.check(pc.implies(bp1) ^ true, "not implied - 2");
        bp1 = new SocketPermission("localhost:100", "resolve,connect");
        this.th.check(pc.implies(bp1), "implied - 2");
        bp1 = new SocketPermission("localhost:100", "accept,listen");
        this.th.check(pc.implies(bp1) ^ true, "not implied - 3");
        bp1 = new SocketPermission("192.168.0.1:300-3000", "accept,resolve,connect");
        this.th.check(pc.implies(bp1), "implied - 3");
        bp1 = new SocketPermission("192.168.0.1:-3000", "accept,resolve,connect");
        this.th.check(pc.implies(bp1) ^ true, "not implied - 4");
        bp1 = new SocketPermission("192.168.0.1", "accept,resolve,connect");
        this.th.check(pc.implies(bp1) ^ true, "not implied - 5");
        bp1 = new SocketPermission("192.168.0.1:300-", "accept,resolve,connect");
        this.th.check(pc.implies(bp1) ^ true, "not implied - 6");
        bp1 = new SocketPermission("192.168.0.1:3000", "accept,resolve,connect");
        this.th.check(pc.implies(bp1), "implied - 4");
        bp1 = new SocketPermission("192.168.0.1:80", "accept,resolve,connect");
        this.th.check(pc.implies(bp1), "implied - 5");
        bp1 = new SocketPermission("192.168.1.1:80", "accept,resolve,connect");
        this.th.check(pc.implies(bp1) ^ true, "not implied - 7");
        bp1 = new SocketPermission("java.sun.com:90-110", "accept,resolve,connect");
        this.th.check(pc.implies(bp1), "implied - 6");
        bp1 = new SocketPermission("java.sun.com:80-120", "accept,listen,connect");
        this.th.check(pc.implies(bp1) ^ true, "not implied - 8");
        bp1 = new SocketPermission("*.www.sun.com:80", "resolve,connect");
        this.th.check(pc.implies(bp1), "implied - 7");
        bp1 = new SocketPermission("java.sun.com:80", "resolve,connect");
        this.th.check(pc.implies(bp1), "implied - 7bis");
        bp1 = new SocketPermission("acunia.com:80", "accept,resolve,connect");
        this.th.check(pc.implies(bp1) ^ true, "not implied - 9");
        bp1 = new SocketPermission("127.0.0.1:100", "resolve,connect");
        this.th.check(pc.implies(bp1), "implied - 8");
        bp1 = new SocketPermission("www.sun.com:80", "resolve,connect");
        this.th.check(pc.implies(bp1), "implied - 9");
        bp1 = new SocketPermission("*.sun.com:80", "resolve,connect");
        this.th.check(pc.implies(bp1), "implied - 10");
        bp1 = new SocketPermission("developer.java.sun.us:80", "resolve,connect");
        this.th.check(pc.implies(bp1) ^ true, "not implied - 10");
    }

    public void test_toString() {
        this.th.setclass("java.security.Permission");
        this.th.checkPoint("toString()java.lang.String");
        String s = "*.acunia.com";
        SocketPermission bp = new SocketPermission(s, "AcCePt");
        this.th.check(bp.toString(), (Object)("(\"" + bp.getClass().getName() + "\" \"" + s + "\" \"accept,resolve\")"));
    }
}

