/*
 * Decompiled with CFR 0.152.
 */
package gnu.testlet.wonka.net.ServerSocket;

import gnu.testlet.TestHarness;
import gnu.testlet.Testlet;
import gnu.testlet.wonka.net.ServerSocket.BasicBacklogSocketServer;
import gnu.testlet.wonka.net.ServerSocket.BasicSocketServer;
import gnu.testlet.wonka.net.ServerSocket.MyBasicSocketServer;
import java.io.DataInputStream;
import java.io.IOException;
import java.net.ServerSocket;
import java.net.Socket;

public class ServerSocketTest
implements Testlet {
    protected static TestHarness harness;

    public void test_BasicBacklogServer() {
        Socket sock2;
        BasicBacklogSocketServer srv = new BasicBacklogSocketServer();
        srv.init();
        srv.start();
        try {
            Thread.sleep(100L);
        }
        catch (InterruptedException sock2) {
            // empty catch block
        }
        try {
            sock2 = new Socket("localhost", 21000);
            DataInputStream dataInputStream = new DataInputStream(sock2.getInputStream());
        }
        catch (Exception e) {
            harness.fail("Error : test_BasicBacklogServer failed - 1exception was thrown");
        }
        try {
            sock2 = new Socket("localhost", 21000);
        }
        catch (Exception sock3) {
            // empty catch block
        }
        try {
            sock2 = new Socket("localhost", 21000);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void test_BasicServer() {
        String str;
        DataInputStream dis;
        Socket sock2;
        harness.checkPoint("BasicServer");
        BasicSocketServer srv = new BasicSocketServer();
        srv.init();
        srv.start();
        try {
            Thread.sleep(100L);
        }
        catch (InterruptedException sock2) {
            // empty catch block
        }
        try {
            sock2 = new Socket("localhost", 20000);
            dis = new DataInputStream(sock2.getInputStream());
            str = dis.readLine();
            if (!str.equals("hello buddy")) {
                harness.fail("Error : test_BasicServer failed - 1string returned is not correct.");
            }
            sock2.close();
        }
        catch (Exception e) {
            harness.fail("Error : test_BasicServer failed - 2exception was thrown: " + e.getMessage());
        }
        try {
            sock2 = new Socket("localhost", 20000);
            dis = new DataInputStream(sock2.getInputStream());
            str = dis.readLine();
            if (!str.equals("hello buddy")) {
                harness.fail("Error : test_BasicServer failed - 3string returned is not correct.");
            }
            sock2.close();
        }
        catch (Exception e) {
            harness.fail("Error : test_BasicServer failed - 4exception was thrown: " + e.getMessage());
        }
        try {
            srv.srvsock.close();
        }
        catch (Exception e) {
            harness.fail("Error : test_BasicServer failed - 5 should not throw exception in close ");
        }
    }

    public void test_MyBasicServer() {
        MyBasicSocketServer srv = new MyBasicSocketServer();
        srv.init();
        srv.start();
        try {
            Thread.sleep(100L);
        }
        catch (InterruptedException sock) {
            // empty catch block
        }
        try {
            Socket sock = new Socket("localhost", 20000);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void test_params() {
        try {
            ServerSocket sock = new ServerSocket(30000);
            if (sock.getLocalPort() != 30000) {
                harness.fail("Error : test_params failed - 1get port did not return proper values");
            }
            try {
                sock.setSoTimeout(100);
                harness.check(sock.getSoTimeout(), 100, "Error : test_params failed - 2get /set timeout did not return proper values");
            }
            catch (Exception e) {
                harness.fail("Error : setSoTimeout fails since vxWorks do not support the feature");
                e.printStackTrace(System.out);
            }
            try {
                ServerSocket sock1 = new ServerSocket(30000);
                harness.fail("Error : test_params failed - 3should have thrown bind exception here.");
            }
            catch (Exception exception) {
                // empty catch block
            }
            harness.check(sock.getLocalPort(), 30000, "Error : test_params failed - 4toString did not return proper values ");
            harness.check(sock.getInetAddress().toString(), "0.0.0.0/0.0.0.0", "Error : test_params failed - 5getInetAddress did not return proper values ");
        }
        catch (Exception e) {
            harness.fail("Error : test_params failed - 10exception was thrown");
            e.printStackTrace(System.out);
        }
    }

    public void testall() {
        harness.verbose("DOING BasicServer Tests");
        this.test_BasicServer();
        harness.verbose("DOING MyBasicServer Tests");
        this.test_MyBasicServer();
        harness.verbose("DOING BasicBacklogServer Tests");
        this.test_BasicBacklogServer();
        harness.verbose("DOING param Tests");
        this.test_params();
    }

    public void test(TestHarness the_harness) {
        harness = the_harness;
        harness.setclass("java.net.ServerSocket");
        this.testall();
    }
}

